/*
 * Decompiled with CFR 0.152.
 */
package io.github.wycst.wast.common.utils;

import io.github.wycst.wast.common.reflect.ClassStructureWrapper;
import io.github.wycst.wast.common.reflect.GetterInfo;
import io.github.wycst.wast.common.reflect.SetterInfo;
import java.util.List;
import java.util.Map;

public final class BeanUtils {
    public static void copy(Object srcBean, Object targetBean) {
        BeanUtils.copyProperties(srcBean, targetBean, null);
    }

    public static void copyProperties(Object srcBean, Object targetBean, String[] excludeFields) {
        boolean isSameBeanType;
        if (srcBean == null || targetBean == null) {
            return;
        }
        Map targetMap = null;
        ClassStructureWrapper targetClassStructureWrapper = null;
        boolean bl = isSameBeanType = srcBean.getClass() == targetBean.getClass();
        if (targetBean instanceof Map) {
            targetMap = (Map)targetBean;
        } else {
            targetClassStructureWrapper = ClassStructureWrapper.get(targetBean.getClass());
        }
        if (srcBean instanceof Map) {
            Map sourceMap = (Map)srcBean;
            if (targetMap != null) {
                targetMap.putAll(sourceMap);
            } else {
                for (Object key : sourceMap.keySet()) {
                    Object value = sourceMap.get(key);
                    SetterInfo setterInfo = targetClassStructureWrapper.getSetterInfo(key.toString());
                    if (setterInfo == null) continue;
                    setterInfo.invoke(targetBean, value);
                }
            }
        } else {
            ClassStructureWrapper sourceClassStructureWrapper = isSameBeanType ? targetClassStructureWrapper : ClassStructureWrapper.get(srcBean.getClass());
            List<GetterInfo> sourceGetterInfos = sourceClassStructureWrapper.getGetterInfos();
            for (GetterInfo getterInfo : sourceGetterInfos) {
                String fieldName = getterInfo.getName();
                if (targetMap != null) {
                    targetMap.put(fieldName, getterInfo.invoke(srcBean));
                    continue;
                }
                SetterInfo setterInfo = targetClassStructureWrapper.getSetterInfo(fieldName);
                if (setterInfo == null) continue;
                setterInfo.invoke(targetBean, getterInfo.invoke(srcBean));
            }
        }
    }

    public static void mergeProperties(Object srcBean, Object targetBean) {
        boolean isSameBeanType;
        if (srcBean == null || targetBean == null) {
            return;
        }
        Map targetMap = null;
        ClassStructureWrapper targetClassStructureWrapper = null;
        boolean bl = isSameBeanType = srcBean.getClass() == targetBean.getClass();
        if (targetBean instanceof Map) {
            targetMap = (Map)targetBean;
        } else {
            targetClassStructureWrapper = ClassStructureWrapper.get(targetBean.getClass());
        }
        if (srcBean instanceof Map) {
            Map sourceMap = (Map)srcBean;
            if (targetMap != null) {
                targetMap.putAll(sourceMap);
            } else {
                for (Object key : sourceMap.keySet()) {
                    Object value = sourceMap.get(key);
                    if (!targetClassStructureWrapper.containsSetterKey(String.valueOf(key))) continue;
                    SetterInfo setterInfo = targetClassStructureWrapper.getSetterInfo(String.valueOf(key));
                    setterInfo.invoke(targetBean, value);
                }
            }
        } else {
            ClassStructureWrapper sourceClassStructureWrapper = isSameBeanType ? targetClassStructureWrapper : ClassStructureWrapper.get(srcBean.getClass());
            List<GetterInfo> sourceGetterInfos = sourceClassStructureWrapper.getGetterInfos();
            for (GetterInfo getterInfo : sourceGetterInfos) {
                String fieldName = getterInfo.getName();
                Object val = getterInfo.invoke(srcBean);
                if (targetMap != null) {
                    targetMap.put(fieldName, val);
                    continue;
                }
                if (val == null || "".equals(val) || !targetClassStructureWrapper.containsSetterKey(fieldName)) continue;
                SetterInfo setterInfo = targetClassStructureWrapper.getSetterInfo(fieldName);
                setterInfo.invoke(targetBean, val);
            }
        }
    }
}

