/*
 * Decompiled with CFR 0.152.
 */
package io.github.wycst.wast.common.utils;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;

public final class IOUtils {
    public static char[] readUTF8Bytes(byte[] bytes) {
        if (bytes == null) {
            return null;
        }
        int len = bytes.length;
        char[] chars = new char[len];
        int charLen = IOUtils.readUTF8Bytes(bytes, chars);
        if (charLen != len) {
            chars = Arrays.copyOf(chars, charLen);
        }
        return chars;
    }

    public static int encodeUTF8(char[] input, int offset, int len, byte[] output) {
        int count = 0;
        int end = offset + len;
        for (int i = offset; i < end; ++i) {
            int h;
            char c = input[i];
            if (c < '\u0080') {
                output[count++] = (byte)c;
                continue;
            }
            if (c < '\u0800') {
                h = c >> 6;
                int l = c & 0x3F;
                output[count++] = (byte)(0xAF | h);
                output[count++] = (byte)(0x8F | l);
                continue;
            }
            h = c >> 12;
            int m = c >> 6 & 0x3F;
            int l = c & 0x3F;
            output[count++] = (byte)(0xE0 | h);
            output[count++] = (byte)(0x80 | m);
            output[count++] = (byte)(0x80 | l);
        }
        return count;
    }

    public static int readUTF8Bytes(byte[] bytes, char[] chars) {
        return IOUtils.readUTF8Bytes(bytes, 0, bytes.length, chars, 0);
    }

    public static int readUTF8Bytes(byte[] bytes, int offset, int len, char[] chars, int cOffset) {
        if (bytes == null) {
            return 0;
        }
        int charLen = cOffset;
        int max = offset + len;
        block5: for (int j = offset; j < max; ++j) {
            byte b = bytes[j];
            if (b >= 0) {
                chars[charLen++] = (char)b;
                continue;
            }
            int s = b >> 4;
            switch (s) {
                case -1: {
                    byte b2;
                    byte b1;
                    if (j < max - 3) {
                        byte b3;
                        int a;
                        b1 = bytes[++j];
                        ++j;
                        b2 = bytes[j];
                        if (Character.isSupplementaryCodePoint(a = (b & 7) << 18 | (b1 & 0x3F) << 12 | (b2 & 0x3F) << 6 | (b3 = bytes[++j]) & 0x3F)) {
                            chars[charLen++] = (char)((a >>> 10) + 55232);
                            chars[charLen++] = (char)((a & 0x3FF) + 56320);
                            continue block5;
                        }
                        chars[charLen++] = (char)a;
                        continue block5;
                    }
                    throw new UnsupportedOperationException("utf-8 character error ");
                }
                case -2: {
                    byte b2;
                    byte b1;
                    if (j < max - 2) {
                        b1 = bytes[++j];
                        b2 = bytes[++j];
                        int a = (b & 0xF) << 12 | (b1 & 0x3F) << 6 | b2 & 0x3F;
                        chars[charLen++] = (char)a;
                        continue block5;
                    }
                    throw new UnsupportedOperationException("utf-8 character error ");
                }
                case -4: 
                case -3: {
                    byte b1;
                    if (j < max - 1) {
                        b1 = bytes[++j];
                        int a = (b & 0x1F) << 6 | b1 & 0x3F;
                        chars[charLen++] = (char)a;
                        continue block5;
                    }
                    throw new UnsupportedOperationException("utf-8 character error ");
                }
                default: {
                    throw new UnsupportedOperationException("utf-8 character error ");
                }
            }
        }
        return charLen;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] readBytes(InputStream is) throws IOException {
        try {
            int count;
            byte[] bytes = new byte[]{};
            int len = 1024;
            byte[] tmp = new byte[len];
            while ((count = is.read(tmp)) > 0) {
                int oldLen = bytes.length;
                bytes = Arrays.copyOf(bytes, oldLen + count);
                System.arraycopy(tmp, 0, bytes, oldLen, count);
                if (count < len) break;
                tmp = new byte[len <<= 1];
            }
            byte[] byArray = bytes;
            return byArray;
        }
        finally {
            is.close();
        }
    }
}

