/*
 * Decompiled with CFR 0.152.
 */
package io.github.wycst.wast.jdbc.connection;

import io.github.wycst.wast.jdbc.connection.ConnectionManager;
import io.github.wycst.wast.jdbc.connection.ConnectionWraper;
import io.github.wycst.wast.jdbc.connection.ConnectionWraperUtils;
import java.sql.SQLException;
import javax.sql.DataSource;

public abstract class AbstractConnectionManager
implements ConnectionManager {
    private DataSource dataSource;

    public AbstractConnectionManager(DataSource dataSource) {
        dataSource.getClass();
        this.dataSource = dataSource;
    }

    public DataSource getDataSource() {
        return this.dataSource;
    }

    @Override
    public abstract ConnectionWraper getConnectionWraper();

    @Override
    public void beginTransaction() {
    }

    @Override
    public void commitTransaction() {
        this.commitTransaction(true);
    }

    @Override
    public void rollbackTransaction() {
        this.rollbackTransaction(true);
    }

    @Override
    public void commitTransaction(boolean closeConnection) {
        try {
            ConnectionWraper wraper = this.currentConnectionWraper();
            if (wraper != null) {
                if (wraper.isTransaction()) {
                    wraper.setCurrentInfluencingRows(0L);
                    if (wraper.getConnection() != null) {
                        wraper.getConnection().commit();
                    }
                }
                if (closeConnection) {
                    wraper.close();
                }
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void rollbackTransaction(boolean closeConnection) {
        try {
            ConnectionWraper wraper = this.currentConnectionWraper();
            if (wraper != null) {
                if (wraper.isTransaction()) {
                    wraper.setCurrentInfluencingRows(0L);
                    if (wraper.getConnection() != null) {
                        wraper.getConnection().rollback();
                    }
                }
                if (closeConnection) {
                    wraper.close();
                }
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void endTransaction() {
        ConnectionWraper wraper = this.currentConnectionWraper();
        if (wraper != null) {
            wraper.setCurrentInfluencingRows(0L);
            wraper.close();
        }
    }

    @Override
    public abstract void closeConnection(ConnectionWraper var1);

    @Override
    public void clear() {
    }

    protected ConnectionWraper currentConnectionWraper() {
        return ConnectionWraperUtils.currentConnectionWraper(this.dataSource);
    }

    protected void bindConnectionWraper(ConnectionWraper wraper) {
        ConnectionWraperUtils.bindConnectionWraper(wraper, this.dataSource);
    }
}

