/*
 * Decompiled with CFR 0.152.
 */
package io.github.wycst.wast.jdbc.executer;

import io.github.wycst.wast.common.reflect.SetterInfo;
import io.github.wycst.wast.jdbc.annotations.CascadeFetch;
import java.lang.reflect.Field;

public class CascadeFetchMapping {
    private final CascadeFetch cascadeFetch;
    private final String fieldName;
    private final Field cascadeFetchField;
    private final int fieldType;
    private final String targetFieldName;
    private final Class<?> targetEntityClass;
    private final boolean cascade;
    private final boolean fetch;
    private final SetterInfo setterInfo;
    private String[] fetchFieldNames;

    CascadeFetchMapping(Class<?> targetEntityClass, Field cascadeFetchField, int fieldTypeValue, CascadeFetch cascadeFetch) {
        this.targetEntityClass = targetEntityClass;
        this.cascadeFetchField = cascadeFetchField;
        this.fieldType = fieldTypeValue;
        this.cascadeFetch = cascadeFetch;
        this.fieldName = cascadeFetch.field();
        this.targetFieldName = cascadeFetch.targetField();
        this.cascade = cascadeFetch.cascade();
        this.fetch = cascadeFetch.fetch();
        this.setterInfo = SetterInfo.fromField(cascadeFetchField);
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public Field getCascadeFetchField() {
        return this.cascadeFetchField;
    }

    public int getFieldType() {
        return this.fieldType;
    }

    public Class<?> getTargetEntityClass() {
        return this.targetEntityClass;
    }

    public String getTargetFieldName() {
        return this.targetFieldName;
    }

    public boolean isCascade() {
        return this.cascade;
    }

    public boolean isFetch() {
        return this.fetch;
    }

    public String[] getFetchFieldNames() {
        return this.fetchFieldNames;
    }

    public void setFetchFieldNames(String[] fetchFieldNames) {
        this.fetchFieldNames = fetchFieldNames;
    }

    void setFetchFieldValue(Object target, Object fetchFieldVal) {
        this.setterInfo.invoke(target, fetchFieldVal);
    }
}

