/*
 * Decompiled with CFR 0.152.
 */
package io.github.wycst.wast.json;

import io.github.wycst.wast.common.reflect.ClassStructureWrapper;
import io.github.wycst.wast.common.reflect.GenericParameterizedType;
import io.github.wycst.wast.common.reflect.ReflectConsts;
import io.github.wycst.wast.common.reflect.SetterInfo;
import io.github.wycst.wast.common.utils.NumberUtils;
import io.github.wycst.wast.common.utils.ObjectUtils;
import io.github.wycst.wast.json.JSONGeneral;
import io.github.wycst.wast.json.JSONOptions;
import io.github.wycst.wast.json.JSONParseContext;
import io.github.wycst.wast.json.JSONTypeDeserializer;
import io.github.wycst.wast.json.annotations.JsonProperty;
import io.github.wycst.wast.json.exceptions.JSONException;
import io.github.wycst.wast.json.options.ReadOption;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;

abstract class JSONAbstractReader
extends JSONGeneral {
    int pos;
    int bufferSize = 8192;
    int count;
    int offset;
    int current;
    ReaderCallback callback;
    final JSONParseContext parseContext = new JSONParseContext();
    final StringBuilder writer = new StringBuilder();
    ReadOption[] readOptions = new ReadOption[0];
    GenericParameterizedType genericType;
    Object result;
    boolean reading;
    boolean closed;
    boolean aborted;
    boolean completed;
    int readingOffset = -1;
    volatile Object lock = new Object();
    boolean async;
    long timeout = 60000L;
    long currentThreadId;
    boolean multiple;

    JSONAbstractReader() {
    }

    public void setOptions(ReadOption ... readOptions) {
        this.readOptions = readOptions;
        JSONOptions.readOptions(readOptions, this.parseContext);
    }

    public void setTimeout(long timeout) {
        this.timeout = timeout;
    }

    public void setMultiple(boolean multiple) {
        this.multiple = multiple;
    }

    public abstract Object read();

    public void read(boolean async) {
        this.read(new ReaderCallback(), async);
    }

    public Object readAsResult(Class<?> actualType) {
        return this.readAsResult(GenericParameterizedType.actualType(actualType));
    }

    public <T> T readAsResult(GenericParameterizedType<T> genericType) {
        this.genericType = genericType;
        this.executeReadStream();
        return (T)this.result;
    }

    public void read(ReaderCallback callback) {
        this.read(callback, false);
    }

    public void read(ReaderCallback callback, boolean async) {
        if (this.reading) {
            return;
        }
        this.checkReadState();
        this.callback = callback;
        this.reading = true;
        if (!async) {
            this.executeReadStream();
        } else {
            this.async = true;
            this.currentThreadId = Thread.currentThread().getId();
            new Thread(new Runnable(){

                @Override
                public void run() {
                    JSONAbstractReader.this.executeReadStream();
                }
            }).start();
        }
    }

    public final void skipNext() {
        try {
            if (this.current == 0) {
                this.readBuffer();
            }
            this.clearWhitespaces();
            switch (this.current) {
                case 123: {
                    this.skipObject();
                    break;
                }
                case 91: {
                    this.skipArray();
                    break;
                }
                case -1: {
                    this.complete();
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("Character stream start character error. Only object({) or array([) parsing is supported");
                }
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public final void skipNext(int count) {
        while (count-- > 0) {
            this.skipNext();
        }
    }

    private void complete() {
        this.result = null;
        this.completed = true;
    }

    private void checkReadState() {
        if (this.closed) {
            throw new UnsupportedOperationException("is closed");
        }
        if (this.aborted) {
            throw new UnsupportedOperationException("is aborted");
        }
    }

    private void executeReadStream() {
        try {
            this.readBuffer();
            this.beginReadWithType();
        }
        catch (Exception e) {
            throw new JSONException(e);
        }
        finally {
            this.tryCloseReader();
            this.reading = false;
            this.closed = true;
            this.unlock();
        }
    }

    abstract void readBuffer() throws IOException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unlock() {
        Object object = this.lock;
        synchronized (object) {
            this.lock.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void await(long timeout) {
        Object object = this.lock;
        synchronized (object) {
            try {
                this.lock.wait(timeout);
            }
            catch (InterruptedException e) {
                throw new JSONException(e);
            }
        }
    }

    final void defaultRead() throws Exception {
        this.clearWhitespaces();
        switch (this.current) {
            case 123: {
                this.result = this.readObject();
                break;
            }
            case 91: {
                this.result = this.readArray();
                break;
            }
            case -1: {
                this.complete();
                return;
            }
            default: {
                throw new UnsupportedOperationException("Character stream start character error. Only object({) or array([) parsing is supported");
            }
        }
        if (!this.multiple) {
            this.clearWhitespaces();
            if (this.current > -1) {
                throw new JSONException("Syntax error, extra characters found, '" + (char)this.current + "', pos " + this.pos);
            }
        }
    }

    private void beginReadWithType() throws Exception {
        this.clearWhitespaces();
        switch (this.current) {
            case 123: {
                this.checkAutoGenericObjectType();
                this.result = this.readObject("", this.genericType);
                break;
            }
            case 91: {
                this.checkAutoGenericCollectionType();
                this.result = this.readArray("", this.genericType);
                break;
            }
            case -1: {
                this.complete();
                return;
            }
            default: {
                throw new UnsupportedOperationException("Character stream start character error. Only object({) or array([) parsing is supported");
            }
        }
        if (this.isAborted()) {
            return;
        }
        if (!this.multiple) {
            this.clearWhitespaces();
            if (this.current > -1) {
                throw new JSONException("Syntax error, extra characters found, '" + (char)this.current + "', pos " + this.pos);
            }
        }
        if (this.callback != null) {
            this.callback.complete(this.result);
        }
    }

    private void checkAutoGenericCollectionType() {
        if (this.genericType == null) {
            this.genericType = GenericParameterizedType.collectionType(ArrayList.class, LinkedHashMap.class);
        } else {
            Class<?> actualType = this.genericType.getActualType();
            if (!Collection.class.isAssignableFrom(actualType) && !actualType.isArray()) {
                this.genericType = GenericParameterizedType.collectionType(ArrayList.class, actualType);
            }
        }
    }

    private void checkAutoGenericObjectType() {
        if (this.genericType == null) {
            this.genericType = GenericParameterizedType.actualType(LinkedHashMap.class);
        }
    }

    private Object readObject() throws Exception {
        LinkedHashMap<String, Object> instance = new LinkedHashMap<String, Object>();
        boolean empty = true;
        block8: while (true) {
            this.clearWhitespaces();
            if (this.current == 125) {
                if (!empty) {
                    throw new JSONException("Syntax error, not allowed ',' followed by '}', pos " + this.pos);
                }
                return instance;
            }
            if (this.current == 34) {
                empty = false;
                this.beginReading(0);
                while (this.readNext() > -1 && this.current != 34) {
                }
                String key = this.endReadingAsString(-1);
                this.clearWhitespaces();
                if (this.current == 58) {
                    this.clearWhitespaces();
                    switch (this.current) {
                        case 123: {
                            Object value = this.readObject();
                            instance.put(key, value);
                            break;
                        }
                        case 91: {
                            Object value = this.readArray();
                            instance.put(key, value);
                            break;
                        }
                        case 34: {
                            Object value = this.readString();
                            instance.put(key, value);
                            break;
                        }
                        case 110: {
                            this.readNull();
                            instance.put(key, null);
                            break;
                        }
                        case 116: {
                            this.readTrue();
                            instance.put(key, true);
                            break;
                        }
                        case 102: {
                            this.readFalse();
                            instance.put(key, false);
                            break;
                        }
                        default: {
                            Object value = this.readNumber('}');
                            instance.put(key, value);
                            if (this.current != 125) continue block8;
                            return instance;
                        }
                    }
                    this.clearWhitespaces();
                    if (this.current == 44) continue;
                    if (this.current == 125) {
                        return instance;
                    }
                    if (this.current == -1) {
                        throw new JSONException("Syntax error, the closing symbol '}' is not found, end pos: " + this.pos);
                    }
                    this.throwUnexpectedException();
                    continue;
                }
                this.throwUnexpectedException();
                continue;
            }
            this.throwUnexpectedException();
        }
    }

    private void readTrue() throws Exception {
        if (this.readNext(true) == 114 && this.readNext(true) == 117 && this.readNext(true) == 101) {
            return;
        }
        this.throwUnexpectedException();
    }

    private void readFalse() throws Exception {
        if (this.readNext(true) == 97 && this.readNext(true) == 108 && this.readNext(true) == 115 && this.readNext(true) == 101) {
            return;
        }
        this.throwUnexpectedException();
    }

    private void readNull() throws Exception {
        if (this.readNext(true) == 117 && this.readNext(true) == 108 && this.readNext(true) == 108) {
            return;
        }
        this.throwUnexpectedException();
    }

    private Number readNumber(char endSyntax) throws Exception {
        double doubleVal;
        int specifySuffix;
        int mode;
        boolean expNegative;
        int expValue;
        int decimalCount;
        long value;
        boolean negative;
        block39: {
            block40: {
                boolean useBigDecimal = this.parseContext.useBigDecimalAsDefault;
                if (useBigDecimal) {
                    int ch;
                    this.writer.setLength(0);
                    this.writer.append((char)this.current);
                    while ((ch = this.readNext()) != 44 && ch != endSyntax) {
                        this.writer.append((char)ch);
                    }
                    String text = this.writer.toString();
                    try {
                        return new BigDecimal(text.trim());
                    }
                    catch (NumberFormatException numberFormatException) {
                        throw new NumberFormatException("offset " + this.offset + ", error input " + text);
                    }
                }
                negative = false;
                char beginChar = (char)this.current;
                if (beginChar == '-') {
                    negative = true;
                    this.readNext();
                } else if (beginChar == '+') {
                    this.readNext();
                }
                value = 0L;
                decimalCount = 0;
                expValue = 0;
                expNegative = false;
                mode = 0;
                specifySuffix = 0;
                while (JSONAbstractReader.isDigit(this.current)) {
                    value = (value << 3) + (value << 1) + (long)this.current - 48L;
                    this.readNext();
                }
                if (this.current == 46) {
                    mode = 1;
                    while (JSONAbstractReader.isDigit(this.readNext())) {
                        value = (value << 3) + (value << 1) + (long)this.current - 48L;
                        ++decimalCount;
                    }
                }
                if (this.current <= 32) {
                    while (this.readNext() <= 32) {
                    }
                }
                if (this.current == 44 || this.current == endSyntax) break block39;
                if (this.current != 69 && this.current != 101) break block40;
                mode = 2;
                expNegative = this.readNext() == 45;
                if (expNegative || this.current == 43) {
                    this.readNext();
                }
                if (JSONAbstractReader.isDigit(this.current)) {
                    expValue = this.current - 48;
                    while (JSONAbstractReader.isDigit(this.readNext())) {
                        expValue = (expValue << 3) + (expValue << 1) + this.current - 48;
                    }
                }
                if (this.current == 44 || this.current == endSyntax) break block39;
            }
            switch (this.current) {
                case 76: 
                case 108: {
                    if (specifySuffix == 0) {
                        specifySuffix = 1;
                        while (this.readNext() <= 32) {
                        }
                        if (this.current == 44 || this.current == endSyntax) break;
                    }
                    this.throwUnexpectedException();
                    return value;
                }
                case 70: 
                case 102: {
                    if (specifySuffix == 0) {
                        specifySuffix = 2;
                        if (this.current == 44 || this.current == endSyntax) break;
                    }
                    this.throwUnexpectedException();
                    return value;
                }
                case 68: 
                case 100: {
                    if (specifySuffix == 0) {
                        specifySuffix = 3;
                        if (this.current == 44 || this.current == endSyntax) break;
                    }
                    this.throwUnexpectedException();
                    return value;
                }
                default: {
                    this.throwUnexpectedException();
                }
            }
        }
        if (mode == 0) {
            long l = value = negative ? -value : value;
            if (specifySuffix > 0) {
                switch (specifySuffix) {
                    case 1: {
                        return value;
                    }
                    case 2: {
                        return Float.valueOf(value);
                    }
                }
                return value;
            }
            if (value <= Integer.MAX_VALUE && value >= Integer.MIN_VALUE) {
                return (int)value;
            }
            return value;
        }
        double dv = NumberUtils.scientificToIEEEDouble(value, expNegative ? expValue + decimalCount : decimalCount - expValue);
        double d = doubleVal = negative ? -dv : dv;
        if (specifySuffix > 0) {
            switch (specifySuffix) {
                case 1: {
                    return (long)doubleVal;
                }
                case 2: {
                    return Float.valueOf((float)doubleVal);
                }
            }
            return doubleVal;
        }
        return doubleVal;
    }

    private Object readArray() throws Exception {
        ArrayList<Object> arrInstance = new ArrayList<Object>();
        int elementIndex = 0;
        block8: while (true) {
            this.clearWhitespaces();
            if (this.current == 93) {
                if (elementIndex > 0) {
                    throw new JSONException("Syntax error, not allowed ',' followed by ']', pos " + this.pos);
                }
                return arrInstance;
            }
            switch (this.current) {
                case 123: {
                    Object value = this.readObject();
                    arrInstance.add(value);
                    break;
                }
                case 91: {
                    Object value = this.readArray();
                    arrInstance.add(value);
                    break;
                }
                case 34: {
                    Object value = this.readString();
                    arrInstance.add(value);
                    break;
                }
                case 110: {
                    this.readNull();
                    arrInstance.add(null);
                    break;
                }
                case 116: {
                    this.readTrue();
                    arrInstance.add(true);
                    break;
                }
                case 102: {
                    this.readFalse();
                    arrInstance.add(false);
                    break;
                }
                default: {
                    Object value = this.readNumber(']');
                    arrInstance.add(value);
                    if (this.current != 93) continue block8;
                    return arrInstance;
                }
            }
            ++elementIndex;
            this.clearWhitespaces();
            if (this.current == 44) continue;
            if (this.current == 93) {
                return arrInstance;
            }
            if (this.current == -1) {
                throw new JSONException("Syntax error, the closing symbol ']' is not found, end pos: " + this.pos);
            }
            this.throwUnexpectedException();
        }
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    Object readObject(String path, GenericParameterizedType genericType) throws Exception {
        Object instance;
        Object var4_3 = null;
        boolean assignableFromMap = true;
        ClassStructureWrapper classStructureWrapper = null;
        boolean externalImpl = this.isExternalImpl();
        GenericParameterizedType ofValueType = null;
        if (!externalImpl) {
            if (genericType != null) {
                Class<?> actualType = genericType.getActualType();
                ReflectConsts.ClassCategory classCategory = genericType.getActualClassCategory();
                if (classCategory == ReflectConsts.ClassCategory.MapCategory || classCategory == ReflectConsts.ClassCategory.ANY) {
                    assignableFromMap = true;
                    Map map = JSONAbstractReader.createMapInstance(genericType);
                    instance = map;
                    ofValueType = genericType.getValueType();
                } else {
                    if (classCategory != ReflectConsts.ClassCategory.ObjectCategory) throw new UnsupportedOperationException("Class " + actualType + " is not supported ");
                    assignableFromMap = false;
                    classStructureWrapper = ClassStructureWrapper.get(actualType);
                    if (classStructureWrapper == null) {
                        throw new UnsupportedOperationException("Class " + actualType + " is not supported ");
                    }
                    instance = classStructureWrapper.newInstance();
                }
            } else {
                LinkedHashMap linkedHashMap = new LinkedHashMap();
                instance = linkedHashMap;
            }
        } else {
            instance = this.callback.created(path, 1);
        }
        boolean empty = true;
        while (true) {
            this.clearWhitespaces();
            if (this.current == 125) {
                if (empty) return instance;
                throw new JSONException("Syntax error, not allowed ',' followed by '}', pos " + this.pos);
            }
            if (this.current == 34) {
                empty = false;
                this.beginReading(0);
                while (this.readNext() > -1 && this.current != 34) {
                }
                String key = this.endReadingAsString(-1);
                this.clearWhitespaces();
                if (this.current == 58) {
                    this.clearWhitespaces();
                    boolean toBreakOrContinue = false;
                    GenericParameterizedType valueType = ofValueType == null ? null : ofValueType;
                    SetterInfo setterInfo = null;
                    JsonProperty jsonProperty = null;
                    boolean isSkipValue = false;
                    if (!externalImpl && !assignableFromMap) {
                        setterInfo = classStructureWrapper.getSetterInfo(key);
                        boolean bl = isSkipValue = setterInfo == null;
                        if (!isSkipValue) {
                            jsonProperty = (JsonProperty)setterInfo.getAnnotation(JsonProperty.class);
                            valueType = setterInfo.getGenericParameterizedType();
                        }
                    }
                    if (isSkipValue) {
                        this.skipValue('}');
                    } else {
                        String nextPath = externalImpl ? path + "/" + key : null;
                        switch (this.current) {
                            case 123: {
                                void var4_7;
                                Object value = this.readObject(nextPath, valueType);
                                this.invokeValueOfObject(key, value, nextPath, externalImpl, assignableFromMap, (Map)var4_7, instance, setterInfo);
                                break;
                            }
                            case 91: {
                                void var4_7;
                                Object value = this.readArray(nextPath, valueType);
                                this.invokeValueOfObject(key, value, nextPath, externalImpl, assignableFromMap, (Map)var4_7, instance, setterInfo);
                                break;
                            }
                            case 34: {
                                void var4_7;
                                Object value = this.parseStringTo(this.readString(), valueType, jsonProperty);
                                this.invokeValueOfObject(key, value, nextPath, externalImpl, assignableFromMap, (Map)var4_7, instance, setterInfo);
                                break;
                            }
                            case 110: {
                                void var4_7;
                                this.readNull();
                                this.invokeValueOfObject(key, null, nextPath, externalImpl, assignableFromMap, (Map)var4_7, instance, setterInfo);
                                break;
                            }
                            case 116: {
                                void var4_7;
                                this.readTrue();
                                Object value = this.toBoolType(true, valueType);
                                this.invokeValueOfObject(key, value, nextPath, externalImpl, assignableFromMap, (Map)var4_7, instance, setterInfo);
                                break;
                            }
                            case 102: {
                                void var4_7;
                                this.readFalse();
                                Object value = this.toBoolType(false, valueType);
                                this.invokeValueOfObject(key, value, nextPath, externalImpl, assignableFromMap, (Map)var4_7, instance, setterInfo);
                                break;
                            }
                            default: {
                                void var4_7;
                                Object value = this.parseNumberTo(this.readNumber('}'), valueType);
                                toBreakOrContinue = true;
                                this.invokeValueOfObject(key, value, nextPath, externalImpl, assignableFromMap, (Map)var4_7, instance, setterInfo);
                            }
                        }
                        if (this.isAborted()) {
                            return instance;
                        }
                        if (this.callback != null && this.callback.isAbored()) {
                            this.abortRead();
                            return instance;
                        }
                        if (!toBreakOrContinue) {
                            this.clearWhitespaces();
                        }
                    }
                    if (this.current == 125) return instance;
                    if (this.current == 44) continue;
                    if (this.current == -1) {
                        throw new JSONException("Syntax error, the closing symbol '}' is not found, end pos: " + this.pos);
                    }
                    this.throwUnexpectedException();
                    continue;
                }
                this.throwUnexpectedException();
                continue;
            }
            this.throwUnexpectedException();
        }
    }

    private Object toBoolType(boolean b, GenericParameterizedType valueType) {
        if (valueType == null) {
            return b;
        }
        if (valueType.getActualClassCategory() == ReflectConsts.ClassCategory.BoolCategory) {
            return b;
        }
        Class<?> actualType = valueType.getActualType();
        if (actualType == AtomicBoolean.class) {
            return new AtomicBoolean(b);
        }
        throw new JSONException("boolean value " + b + " is mismatch " + actualType);
    }

    private void skipValue(char endChar) throws Exception {
        switch (this.current) {
            case 123: {
                this.skipObject();
                this.clearWhitespaces();
                break;
            }
            case 91: {
                this.skipArray();
                this.clearWhitespaces();
                break;
            }
            case 34: {
                this.skipString();
                this.clearWhitespaces();
                break;
            }
            default: {
                this.skipSimple(endChar);
            }
        }
    }

    private void skipObject() throws Exception {
        boolean empty = true;
        while (true) {
            this.clearWhitespaces();
            if (this.current == 125) {
                if (!empty) {
                    throw new JSONException("Syntax error, not allowed ',' followed by '}', pos " + this.pos);
                }
                return;
            }
            if (this.current == 34) {
                empty = false;
                while (this.readNext() > -1 && this.current != 34) {
                }
                this.clearWhitespaces();
                if (this.current == 58) {
                    this.clearWhitespaces();
                    this.skipValue('}');
                    if (this.current == 125) {
                        return;
                    }
                    if (this.current == 44) continue;
                    if (this.current == -1) {
                        throw new JSONException("Syntax error, the closing symbol '}' is not found, end pos: " + this.pos);
                    }
                    this.throwUnexpectedException();
                    continue;
                }
                this.throwUnexpectedException();
                continue;
            }
            this.throwUnexpectedException();
        }
    }

    private void skipArray() throws Exception {
        int elementIndex = 0;
        while (true) {
            this.clearWhitespaces();
            if (this.current == 93) {
                if (elementIndex > 0) {
                    throw new JSONException("Syntax error, not allowed ',' followed by ']', pos " + this.pos);
                }
                return;
            }
            this.skipValue(']');
            ++elementIndex;
            if (this.current == 93) {
                return;
            }
            if (this.current == 44) continue;
            if (this.current == -1) {
                throw new JSONException("Syntax error, the closing symbol ']' is not found, end pos: " + this.pos);
            }
            this.throwUnexpectedException();
        }
    }

    private void skipString() throws Exception {
        int prev = 0;
        while (this.readNext() > -1) {
            if (this.current == 34 && prev != 92) {
                return;
            }
            prev = (char)this.current;
        }
        this.throwUnexpectedException();
    }

    private void skipSimple(char endChar) throws Exception {
        while (this.readNext() > -1) {
            if (this.current != 44 && this.current != endChar) continue;
            return;
        }
        this.throwUnexpectedException();
    }

    void beginReading(int n) {
        this.writer.setLength(0);
        this.readingOffset = this.offset + n;
    }

    abstract String endReadingAsString(int var1);

    void endReading(int n) {
        this.endReading(n, -1);
    }

    abstract void endReading(int var1, int var2);

    private Object parseNumberTo(Object simpleValue, GenericParameterizedType valueType) {
        ReflectConsts.ClassCategory classCategory;
        if (simpleValue == null) {
            return null;
        }
        if (valueType == null || (classCategory = valueType.getActualClassCategory()) == ReflectConsts.ClassCategory.ANY) {
            return simpleValue;
        }
        Class<?> actualType = valueType.getActualType();
        if (actualType.isInstance(simpleValue)) {
            return simpleValue;
        }
        Number numValue = (Number)simpleValue;
        if (classCategory == ReflectConsts.ClassCategory.NumberCategory) {
            return ObjectUtils.toTypeNumber(numValue, actualType);
        }
        if (classCategory == ReflectConsts.ClassCategory.EnumCategory) {
            int ordinal = numValue.intValue();
            Enum[] values = (Enum[])actualType.getEnumConstants();
            if (values != null && ordinal < values.length) {
                return values[ordinal];
            }
            throw new JSONException("value " + numValue + " is mismatch enum " + actualType);
        }
        throw new JSONException("read simple value " + numValue + " is mismatch " + actualType);
    }

    private Object parseStringTo(String value, GenericParameterizedType valueType, JsonProperty jsonProperty) throws Exception {
        if (value == null) {
            return null;
        }
        if (valueType == null || valueType == GenericParameterizedType.AnyType) {
            return value;
        }
        Class<?> actualType = valueType.getActualType();
        if (actualType == String.class || actualType == CharSequence.class) {
            return value;
        }
        JSONTypeDeserializer deserializer = JSONTypeDeserializer.getFieldDeserializer(valueType, jsonProperty);
        return deserializer.valueOf(value, actualType);
    }

    private void invokeValueOfObject(String key, Object value, String nextPath, boolean externalImpl, boolean assignableFromMap, Map mapInstane, Object instance, SetterInfo setterInfo) throws Exception {
        if (!externalImpl) {
            if (assignableFromMap) {
                mapInstane.put(key, value);
            } else if (setterInfo != null) {
                setterInfo.invoke(instance, value);
            }
        } else {
            this.callback.parseValue(key, value, instance, -1, nextPath);
        }
    }

    private void parseCollectionElement(boolean externalImpl, Object value, Collection arrInstance, Object instance, int elementIndex, String nextPath) throws Exception {
        if (!externalImpl) {
            arrInstance.add(value);
        } else {
            this.callback.parseValue(null, value, instance, elementIndex, nextPath);
        }
    }

    final void abortRead() {
        this.aborted = true;
    }

    public final boolean isAborted() {
        return this.aborted;
    }

    final Object readArray(String path, GenericParameterizedType genericType) throws Exception {
        ArrayList instance;
        ArrayList<Object> arrInstance = null;
        Class<?> collectionCls = null;
        GenericParameterizedType<?> valueType = null;
        Class<?> actualType = null;
        boolean isArrayCls = false;
        if (genericType != null) {
            collectionCls = genericType.getActualType();
            valueType = genericType.getValueType();
            actualType = valueType == null ? null : valueType.getActualType();
        }
        boolean externalImpl = this.isExternalImpl();
        if (!this.isExternalImpl()) {
            if (collectionCls == null || collectionCls == ArrayList.class) {
                arrInstance = new ArrayList();
            } else {
                isArrayCls = collectionCls.isArray();
                if (isArrayCls) {
                    arrInstance = new ArrayList();
                    actualType = collectionCls.getComponentType();
                    if (valueType == null) {
                        valueType = GenericParameterizedType.actualType(actualType);
                    }
                } else {
                    arrInstance = JSONAbstractReader.createCollectionInstance(collectionCls);
                }
            }
            instance = arrInstance;
        } else {
            instance = this.callback.created(path, 2);
        }
        int elementIndex = 0;
        while (true) {
            this.clearWhitespaces();
            if (this.current == 93) {
                if (elementIndex > 0) {
                    throw new JSONException("Syntax error, not allowed ',' followed by ']', pos " + this.pos);
                }
                return isArrayCls ? JSONAbstractReader.collectionToArray(arrInstance, actualType == null ? Object.class : actualType) : arrInstance;
            }
            boolean toBreakOrContinue = false;
            String nextPath = externalImpl ? path + "/[" + elementIndex + "]" : null;
            switch (this.current) {
                case 123: {
                    Object value = this.readObject(nextPath, valueType);
                    this.parseCollectionElement(externalImpl, value, arrInstance, instance, elementIndex, nextPath);
                    break;
                }
                case 91: {
                    Object value = this.readArray(nextPath, valueType);
                    this.parseCollectionElement(externalImpl, value, arrInstance, instance, elementIndex, nextPath);
                    break;
                }
                case 34: {
                    Object value = this.parseStringTo(this.readString(), valueType, null);
                    this.parseCollectionElement(externalImpl, value, arrInstance, instance, elementIndex, nextPath);
                    break;
                }
                case 110: {
                    this.readNull();
                    this.parseCollectionElement(externalImpl, null, arrInstance, instance, elementIndex, nextPath);
                    break;
                }
                case 116: {
                    this.readTrue();
                    Object value = this.toBoolType(true, valueType);
                    this.parseCollectionElement(externalImpl, value, arrInstance, instance, elementIndex, nextPath);
                    break;
                }
                case 102: {
                    this.readFalse();
                    Object value = this.toBoolType(false, valueType);
                    this.parseCollectionElement(externalImpl, value, arrInstance, instance, elementIndex, nextPath);
                    break;
                }
                default: {
                    Object value = this.parseNumberTo(this.readNumber(']'), valueType);
                    toBreakOrContinue = true;
                    this.parseCollectionElement(externalImpl, value, arrInstance, instance, elementIndex, nextPath);
                    break;
                }
            }
            if (this.isAborted()) {
                return isArrayCls ? JSONAbstractReader.collectionToArray(arrInstance, actualType == null ? Object.class : actualType) : arrInstance;
            }
            if (this.callback != null && this.callback.isAbored()) {
                this.abortRead();
                return isArrayCls ? JSONAbstractReader.collectionToArray(arrInstance, actualType == null ? Object.class : actualType) : arrInstance;
            }
            ++elementIndex;
            if (!toBreakOrContinue) {
                this.clearWhitespaces();
            }
            if (this.current == 93) break;
            if (this.current == 44) continue;
            if (this.current == -1) {
                throw new JSONException("Syntax error, the closing symbol ']' is not found, end pos: " + this.pos);
            }
            this.throwUnexpectedException();
        }
        return isArrayCls ? JSONAbstractReader.collectionToArray(arrInstance, actualType == null ? Object.class : actualType) : arrInstance;
    }

    final void throwUnexpectedException() {
        throw new JSONException("Syntax error, unexpected '" + (char)this.current + "', position " + this.pos);
    }

    final String readString() throws Exception {
        this.beginReading(0);
        int prev = 0;
        while (this.readNext() > -1) {
            if (prev == 92) {
                if (this.offset == 1) {
                    int bufferLen = this.writer.length();
                    this.writer.setLength(bufferLen - 1);
                }
                switch (this.current) {
                    case 34: {
                        this.endReading(-2, this.offset);
                        this.writer.append('\"');
                        break;
                    }
                    case 110: {
                        this.endReading(-2, this.offset);
                        this.writer.append('\n');
                        break;
                    }
                    case 114: {
                        this.endReading(-2, this.offset);
                        this.writer.append('\r');
                        break;
                    }
                    case 116: {
                        this.endReading(-2, this.offset);
                        this.writer.append('\t');
                        break;
                    }
                    case 98: {
                        this.endReading(-2, this.offset);
                        this.writer.append('\b');
                        break;
                    }
                    case 102: {
                        this.endReading(-2, this.offset);
                        this.writer.append('\f');
                        break;
                    }
                    case 117: {
                        this.endReading(-2, this.offset);
                        this.readingOffset = -1;
                        int c1 = this.readNext(true);
                        int c2 = this.readNext(true);
                        int c3 = this.readNext(true);
                        int c4 = this.readNext(true);
                        int c = JSONAbstractReader.hex4(c1, c2, c3, c4);
                        this.readingOffset = this.offset;
                        this.writer.append((char)c);
                        break;
                    }
                    case 92: {
                        this.endReading(-2, this.offset);
                        this.writer.append('\\');
                        break;
                    }
                    default: {
                        this.endReading(-2, this.offset);
                        this.writer.append((char)this.current);
                    }
                }
                prev = 0;
                continue;
            }
            if (this.current == 34) {
                return this.endReadingAsString(-1);
            }
            prev = (char)this.current;
        }
        this.throwUnexpectedException();
        return null;
    }

    abstract int readNext() throws Exception;

    final int readNext(boolean check) throws Exception {
        this.readNext();
        if (check && this.current == -1) {
            this.tryCloseReader();
            throw new JSONException("Unexpected error, stream is end ");
        }
        return this.current;
    }

    private void clearWhitespaces() throws Exception {
        while (this.readNext() > -1 && this.current <= 32) {
        }
    }

    private boolean isExternalImpl() {
        return this.callback != null && this.callback.readParseMode == ReadParseMode.ExternalImpl;
    }

    abstract boolean isCompleted();

    public Object getResult() {
        return this.getResult(this.timeout);
    }

    public Object getResult(long timeout) {
        if (this.async) {
            long threadId = Thread.currentThread().getId();
            if (threadId != this.currentThreadId) {
                return this.result;
            }
            this.await(timeout);
        }
        return this.result;
    }

    void tryCloseReader() {
        this.writer.setLength(0);
        if (!this.multiple) {
            this.close();
        }
    }

    public abstract void close();

    public static class ReaderCallback {
        private final ReadParseMode readParseMode;
        private boolean abored;

        public ReaderCallback() {
            this(ReadParseMode.BuiltParse);
        }

        public ReaderCallback(ReadParseMode readParseMode) {
            this.readParseMode = readParseMode;
        }

        public Object created(String path, int type) throws Exception {
            return null;
        }

        public void parseValue(String key, Object value, Object host, int elementIndex, String path) throws Exception {
        }

        void complete(Object result) {
        }

        final void abort() {
            this.abored = true;
        }

        final boolean isAbored() {
            return this.abored;
        }
    }

    public static enum ReadParseMode {
        BuiltParse,
        ExternalImpl;

    }
}

