/*
 * Decompiled with CFR 0.152.
 */
package io.github.wycst.wast.json;

import io.github.wycst.wast.common.reflect.UnsafeHelper;
import io.github.wycst.wast.common.utils.EnvUtils;
import io.github.wycst.wast.common.utils.IOUtils;
import io.github.wycst.wast.json.JSONGeneral;
import io.github.wycst.wast.json.JSONUnsafe;
import io.github.wycst.wast.json.JSONWriter;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigInteger;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.UUID;

class JSONCharArrayWriter
extends JSONWriter {
    char[] buf;
    int count;
    static final char[] EMPTY_BUF = new char[0];
    private static final CharBufCache[] CHAR_BUF_CACHES = new CharBufCache[CACHE_COUNT];
    private Charset charset;
    private CharBufCache charBufCache;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static CharBufCache getCharBufCache() {
        CharBufCache cache;
        int cacheIndex = (Integer)THREAD_CACHE_INDEX.get();
        CharBufCache charBufCache = cache = CHAR_BUF_CACHES[cacheIndex];
        synchronized (charBufCache) {
            if (cache.inUse) {
                return null;
            }
            cache.inUse = true;
            if (cache.cacheChars == null) {
                cache.cacheChars = new char[CACHE_BUFFER_SIZE];
            }
        }
        return cache;
    }

    void setCharAt(int index, char c) {
        this.buf[index] = c;
    }

    protected char[] toChars() {
        return Arrays.copyOf(this.buf, this.count);
    }

    JSONCharArrayWriter(Charset charset) {
        this();
        this.charset = charset == null ? EnvUtils.CHARSET_DEFAULT : charset;
    }

    JSONCharArrayWriter() {
        CharBufCache charBufCache = JSONCharArrayWriter.getCharBufCache();
        if (charBufCache != null) {
            this.buf = charBufCache.cacheChars;
            this.charBufCache = charBufCache;
        } else {
            this.buf = new char[512];
        }
    }

    @Override
    public void write(int c) {
        this.ensureCapacity(129);
        this.buf[this.count++] = (char)c;
    }

    @Override
    public void writeJSONToken(char c) {
        this.buf[this.count++] = c;
    }

    @Override
    public void write(char[] c, int off, int len) {
        if (len == 0) {
            return;
        }
        this.ensureCapacity(len + 128);
        System.arraycopy(c, off, this.buf, this.count, len);
        this.count += len;
    }

    char[] ensureCapacity(int increment) {
        return this.expandCapacity(this.count + increment);
    }

    char[] expandCapacity(int newCap) {
        if (newCap > this.buf.length) {
            this.buf = Arrays.copyOf(this.buf, newCap * 3 >> 1);
        }
        return this.buf;
    }

    void writeBytes(byte[] bytes, int offset, int len) {
        if (len == 0) {
            return;
        }
        String str = new String(bytes, offset, len);
        len = str.length();
        this.ensureCapacity(len);
        str.getChars(0, len, this.buf, this.count);
        this.count += len;
    }

    @Override
    public void write(String str, int off, int len) {
        if (len == 0) {
            return;
        }
        this.ensureCapacity(len + 128);
        int count = this.count;
        for (int i = 0; i < len; ++i) {
            this.buf[count++] = str.charAt(off++);
        }
        this.count = count;
    }

    public void writeString(String str, int off, int len) {
        if (len == 0) {
            return;
        }
        this.ensureCapacity(len + 128);
        str.getChars(off, off + len, this.buf, this.count);
        this.count += len;
    }

    @Override
    public void flush() throws IOException {
    }

    @Override
    public void close() throws IOException {
    }

    @Override
    protected StringBuffer toStringBuffer() {
        StringBuffer stringBuffer = new StringBuffer(this.count);
        stringBuffer.append(this.buf, 0, this.count);
        return stringBuffer;
    }

    @Override
    protected StringBuilder toStringBuilder() {
        StringBuilder stringBuilder = new StringBuilder(this.count);
        stringBuilder.append(this.buf, 0, this.count);
        return stringBuilder;
    }

    @Override
    protected void toOutputStream(OutputStream os) throws IOException {
        String source;
        byte[] bytes;
        boolean isByteArrayOs = os.getClass() == ByteArrayOutputStream.class;
        boolean emptyByteArrayOs = false;
        if (isByteArrayOs) {
            ByteArrayOutputStream byteArrayOutputStream = (ByteArrayOutputStream)os;
            boolean bl = emptyByteArrayOs = byteArrayOutputStream.size() == 0;
        }
        if ((bytes = (byte[])UnsafeHelper.getStringValue(source = new String(this.buf, 0, this.count))).length == this.count) {
            if (emptyByteArrayOs) {
                JSONUnsafe.UNSAFE.putObject(os, UnsafeHelper.BAO_BUF_OFFSET, bytes);
                JSONUnsafe.UNSAFE.putInt(os, UnsafeHelper.BAO_COUNT_OFFSET, this.count);
            } else {
                os.write(bytes, 0, this.count);
            }
        } else if (this.charset == null || this.charset == EnvUtils.CHARSET_UTF_8) {
            byte[] output = new byte[this.count * 3];
            int length = IOUtils.encodeUTF8(this.buf, 0, this.count, output);
            if (emptyByteArrayOs) {
                JSONUnsafe.UNSAFE.putObject(os, UnsafeHelper.BAO_BUF_OFFSET, output);
                JSONUnsafe.UNSAFE.putInt(os, UnsafeHelper.BAO_COUNT_OFFSET, length);
            } else {
                os.write(output, 0, length);
            }
        } else {
            bytes = source.getBytes(this.charset);
            if (emptyByteArrayOs) {
                JSONUnsafe.UNSAFE.putObject(os, UnsafeHelper.BAO_BUF_OFFSET, bytes);
                JSONUnsafe.UNSAFE.putInt(os, UnsafeHelper.BAO_COUNT_OFFSET, bytes.length);
            } else {
                os.write(bytes);
            }
        }
        os.flush();
    }

    @Override
    protected byte[] toBytes(Charset charset) {
        String source = new String(this.buf, 0, this.count);
        byte[] bytes = (byte[])UnsafeHelper.getStringValue(source);
        if (bytes.length == this.count) {
            return bytes;
        }
        if (charset == EnvUtils.CHARSET_UTF_8) {
            byte[] output = new byte[this.count * 3];
            int length = IOUtils.encodeUTF8(this.buf, 0, this.count, output);
            return Arrays.copyOf(output, length);
        }
        bytes = source.getBytes(charset);
        return bytes;
    }

    @Override
    public String toString() {
        return new String(this.buf, 0, this.count);
    }

    public int size() {
        return this.count;
    }

    @Override
    public final void writeShortChars(char[] chars, int offset, int len) {
        this.ensureCapacity(len + 128);
        int count = this.count;
        for (int i = 0; i < len; ++i) {
            this.buf[count++] = chars[offset++];
        }
        this.count = count;
    }

    final void writeShortJSONChars(char[] chars) {
        int len = chars.length;
        this.ensureCapacity(len + 130);
        int count = this.count;
        this.buf[count++] = 34;
        for (char ch : chars) {
            String escapeStr;
            if (ch > '\"' && ch != '\\' || (escapeStr = JSONGeneral.ESCAPE_VALUES[ch]) == null) {
                this.buf[count++] = ch;
                continue;
            }
            int escapesLen = escapeStr.length();
            this.ensureCapacity(escapesLen + 128);
            for (int j = 0; j < escapesLen; ++j) {
                this.buf[count++] = escapeStr.charAt(j);
            }
        }
        this.buf[count++] = 34;
        this.count = count;
    }

    @Override
    public final void writeLong(long numValue) throws IOException {
        if (numValue == 0L) {
            this.ensureCapacity(129);
            this.buf[this.count++] = 48;
            return;
        }
        this.ensureCapacity(148);
        if (numValue < 0L) {
            if (numValue == Long.MIN_VALUE) {
                this.write("-9223372036854775808");
                return;
            }
            numValue = -numValue;
            this.buf[this.count++] = 45;
        }
        this.count += JSONCharArrayWriter.writeInteger(numValue, this.buf, this.count);
    }

    @Override
    protected final void writeCommaLongValues(long val1, long val2) throws IOException {
        this.ensureCapacity(170);
        int off = this.count;
        if (val1 < 0L) {
            if (val1 == Long.MIN_VALUE) {
                this.write(",-9223372036854775808");
                off = this.count;
            } else {
                val1 = -val1;
                this.buf[off++] = 44;
                this.buf[off++] = 45;
                off += JSONCharArrayWriter.writeInteger(val1, this.buf, off);
            }
        } else {
            this.buf[off++] = 44;
            off += JSONCharArrayWriter.writeInteger(val1, this.buf, off);
        }
        if (val2 < 0L) {
            if (val2 == Long.MIN_VALUE) {
                this.write(",-9223372036854775808");
                off = this.count;
            } else {
                val2 = -val2;
                this.buf[off++] = 44;
                this.buf[off++] = 45;
                off += JSONCharArrayWriter.writeInteger(val2, this.buf, off);
            }
        } else {
            this.buf[off++] = 44;
            off += JSONCharArrayWriter.writeInteger(val2, this.buf, off);
        }
        this.count = off;
    }

    @Override
    public final void writeUUID(UUID uuid) {
        this.ensureCapacity(166);
        int off = this.count;
        this.buf[off++] = 34;
        off += JSONCharArrayWriter.writeUUID(uuid, this.buf, off);
        this.buf[off++] = 34;
        this.count = off;
    }

    @Override
    public final void writeDouble(double numValue) {
        this.ensureCapacity(152);
        int off = this.count;
        off += JSONCharArrayWriter.writeDouble(numValue, this.buf, off);
        this.count = off;
    }

    @Override
    public final void writeFloat(float numValue) {
        this.ensureCapacity(152);
        this.count += JSONCharArrayWriter.writeFloat(numValue, this.buf, this.count);
    }

    @Override
    public final void writeJSONLocalDateTime(int year, int month, int day, int hour, int minute, int second, int nano, String zoneId) throws IOException {
        this.ensureCapacity(164);
        int off = this.count;
        this.buf[off++] = 34;
        if (year < 0) {
            this.buf[off++] = 45;
            year = -year;
        }
        off = year < 10000 ? (off += JSONUnsafe.putLong(this.buf, off, FOUR_DIGITS_64_BITS[year])) : (off += JSONCharArrayWriter.writeInteger((long)year, this.buf, off));
        off += JSONUnsafe.putLong(this.buf, off, 0x2D000000000000L | (long)TWO_DIGITS_32_BITS[month] << 16 | 0x2DL);
        off += JSONUnsafe.putInt(this.buf, off, TWO_DIGITS_32_BITS[day]);
        off += JSONUnsafe.putLong(this.buf, off, JSONCharArrayWriter.mergeInt64(hour, 'T', ':'));
        off += JSONUnsafe.putInt(this.buf, off, TWO_DIGITS_32_BITS[minute]);
        this.buf[off++] = 58;
        off += JSONUnsafe.putInt(this.buf, off, TWO_DIGITS_32_BITS[second]);
        if (nano > 0) {
            off = this.writeNano(nano, off);
        }
        if (zoneId.length() == 1) {
            off += JSONUnsafe.putInt(this.buf, off, Z_QUOT_INT);
            this.count = off;
        } else {
            this.count = off;
            this.writeZoneId(zoneId);
            this.buf[this.count++] = 34;
        }
    }

    final int writeNano(int nano, int off) {
        this.buf[off++] = 46;
        int div1 = nano / 1000;
        int seg1 = div1 / 100;
        int seg2 = div1 - 100 * seg1;
        int seg3 = nano - div1 * 1000;
        off += JSONUnsafe.putLong(this.buf, off, FOUR_DIGITS_64_BITS[seg1]);
        if (seg3 > 0) {
            off += JSONUnsafe.putInt(this.buf, off, TWO_DIGITS_32_BITS[seg2]);
            int pos = --off;
            char last = this.buf[pos];
            off += JSONUnsafe.putLong(this.buf, pos, FOUR_DIGITS_64_BITS[seg3]);
            this.buf[pos] = last;
        } else {
            off = seg2 == 0 && (seg1 & 1) == 0 && seg1 % 5 == 0 ? --off : (off += JSONUnsafe.putInt(this.buf, off, TWO_DIGITS_32_BITS[seg2]));
        }
        return off;
    }

    @Override
    public final void writeJSONLocalDate(int year, int month, int day) {
        this.ensureCapacity(141);
        int off = this.count;
        this.buf[off++] = 34;
        if (year < 0) {
            this.buf[off++] = 45;
            year = -year;
        }
        off = year < 10000 ? (off += JSONUnsafe.putLong(this.buf, off, FOUR_DIGITS_64_BITS[year])) : (off += JSONCharArrayWriter.writeInteger((long)year, this.buf, off));
        off += JSONUnsafe.putLong(this.buf, off, 0x2D000000000000L | (long)TWO_DIGITS_32_BITS[month] << 16 | 0x2DL);
        off += JSONUnsafe.putInt(this.buf, off, TWO_DIGITS_32_BITS[day]);
        this.buf[off++] = 34;
        this.count = off;
    }

    @Override
    public final void writeTime(int hourOfDay, int minute, int second) {
        this.ensureCapacity(138);
        int off = this.count;
        off += JSONUnsafe.putInt(this.buf, off, TWO_DIGITS_32_BITS[hourOfDay]);
        off += JSONUnsafe.putLong(this.buf, off, JSONCharArrayWriter.mergeInt64(minute, ':', ':'));
        off += JSONUnsafe.putInt(this.buf, off, TWO_DIGITS_32_BITS[second]);
        this.count = off;
    }

    @Override
    public final void writeJSONTimeWithNano(int hourOfDay, int minute, int second, int nano) {
        this.ensureCapacity(150);
        int off = this.count;
        this.buf[off++] = 34;
        off += JSONUnsafe.putInt(this.buf, off, TWO_DIGITS_32_BITS[hourOfDay]);
        off += JSONUnsafe.putLong(this.buf, off, JSONCharArrayWriter.mergeInt64(minute, ':', ':'));
        off += JSONUnsafe.putInt(this.buf, off, TWO_DIGITS_32_BITS[second]);
        if (nano > 0) {
            off = this.writeNano(nano, off);
        }
        this.buf[off++] = 34;
        this.count = off;
    }

    @Override
    public final void writeDate(int year, int month, int day, int hourOfDay, int minute, int second) {
        this.ensureCapacity(152);
        int off = this.count;
        if (year < 0) {
            this.buf[off++] = 45;
            year = -year;
        }
        off = year < 10000 ? (off += JSONUnsafe.putLong(this.buf, off, FOUR_DIGITS_64_BITS[year])) : (off += JSONCharArrayWriter.writeInteger((long)year, this.buf, off));
        off += JSONUnsafe.putLong(this.buf, off, JSONCharArrayWriter.mergeInt64(month, '-', '-'));
        off += JSONUnsafe.putInt(this.buf, off, TWO_DIGITS_32_BITS[day]);
        off += JSONUnsafe.putLong(this.buf, off, JSONCharArrayWriter.mergeInt64(hourOfDay, ' ', ':'));
        off += JSONUnsafe.putInt(this.buf, off, TWO_DIGITS_32_BITS[minute]);
        this.buf[off++] = 58;
        off += JSONUnsafe.putInt(this.buf, off, TWO_DIGITS_32_BITS[second]);
        this.count = off;
    }

    @Override
    public final void writeBigInteger(BigInteger bigInteger) {
        int increment = (bigInteger.bitLength() / 60 + 1) * 18;
        this.ensureCapacity(increment + 128);
        this.count += JSONCharArrayWriter.writeBigInteger(bigInteger, this.buf, this.count);
    }

    @Override
    public void writeJSONChars(char[] chars) throws IOException {
        int len = chars.length;
        if (len <= 64) {
            this.writeShortJSONChars(chars);
        } else {
            this.ensureCapacity(len + 130);
            int count = this.count;
            int beginIndex = 0;
            this.buf[count++] = 34;
            for (int i = 0; i < len; ++i) {
                String escapeStr;
                char ch = chars[i];
                if (ch > '\"' && ch != '\\' || (escapeStr = JSONGeneral.ESCAPE_VALUES[ch]) == null) continue;
                int length = i - beginIndex;
                this.expandCapacity(length + count + 133);
                if (length > 0) {
                    System.arraycopy(chars, beginIndex, this.buf, count, length);
                    count += length;
                }
                int escapesLen = escapeStr.length();
                escapeStr.getChars(0, escapesLen, this.buf, count);
                count += escapesLen;
                beginIndex = i + 1;
            }
            int length = len - beginIndex;
            System.arraycopy(chars, beginIndex, this.buf, count, length);
            count += length;
            this.buf[count++] = 34;
            this.count = count;
        }
    }

    static final int escapeBytesToChars(byte[] bytes, int begin, char[] buf, int offset) {
        int len = bytes.length;
        for (int i = begin; i < len; ++i) {
            int b = bytes[i] & 0xFF;
            if (JSONCharArrayWriter.isNoEscape(b)) {
                buf[offset++] = (char)b;
                continue;
            }
            String escapeStr = JSONGeneral.ESCAPE_VALUES[b];
            int escapesLen = escapeStr.length();
            escapeStr.getChars(0, escapesLen, buf, offset);
            offset += escapesLen;
        }
        return offset;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void writeLatinJSONString(String value, byte[] bytes) throws IOException {
        int count;
        block7: {
            int len;
            block8: {
                int b;
                int i;
                block13: {
                    int b1;
                    block14: {
                        block11: {
                            int b3;
                            int b2;
                            block12: {
                                block9: {
                                    int b7;
                                    int b6;
                                    int b5;
                                    int b4;
                                    block10: {
                                        len = bytes.length;
                                        this.ensureCapacity(len + 130);
                                        count = this.count;
                                        this.buf[count++] = 34;
                                        if (len > 15) break block8;
                                        i = 0;
                                        if (i > len - 8) break block9;
                                        b = bytes[i] & 0xFF;
                                        if (JSONCharArrayWriter.isNoEscape(b) && JSONCharArrayWriter.isNoEscape(b1 = bytes[i + 1] & 0xFF) && JSONCharArrayWriter.isNoEscape(b2 = bytes[i + 2] & 0xFF) && JSONCharArrayWriter.isNoEscape(b3 = bytes[i + 3] & 0xFF) && JSONCharArrayWriter.isNoEscape(b4 = bytes[i + 4] & 0xFF) && JSONCharArrayWriter.isNoEscape(b5 = bytes[i + 5] & 0xFF) && JSONCharArrayWriter.isNoEscape(b6 = bytes[i + 6] & 0xFF) && JSONCharArrayWriter.isNoEscape(b7 = bytes[i + 7] & 0xFF)) break block10;
                                        count = JSONCharArrayWriter.escapeBytesToChars(bytes, i, this.buf, count);
                                        break block7;
                                    }
                                    this.buf[count++] = (char)b;
                                    this.buf[count++] = (char)b1;
                                    this.buf[count++] = (char)b2;
                                    this.buf[count++] = (char)b3;
                                    this.buf[count++] = (char)b4;
                                    this.buf[count++] = (char)b5;
                                    this.buf[count++] = (char)b6;
                                    this.buf[count++] = (char)b7;
                                    i += 8;
                                }
                                if (i > len - 4) break block11;
                                b = bytes[i] & 0xFF;
                                if (JSONCharArrayWriter.isNoEscape(b) && JSONCharArrayWriter.isNoEscape(b1 = bytes[i + 1] & 0xFF) && JSONCharArrayWriter.isNoEscape(b2 = bytes[i + 2] & 0xFF) && JSONCharArrayWriter.isNoEscape(b3 = bytes[i + 3] & 0xFF)) break block12;
                                count = JSONCharArrayWriter.escapeBytesToChars(bytes, i, this.buf, count);
                                break block7;
                            }
                            this.buf[count++] = (char)b;
                            this.buf[count++] = (char)b1;
                            this.buf[count++] = (char)b2;
                            this.buf[count++] = (char)b3;
                            i += 4;
                        }
                        if (i > len - 2) break block13;
                        b = bytes[i] & 0xFF;
                        if (JSONCharArrayWriter.isNoEscape(b) && JSONCharArrayWriter.isNoEscape(b1 = bytes[i + 1] & 0xFF)) break block14;
                        count = JSONCharArrayWriter.escapeBytesToChars(bytes, i, this.buf, count);
                        break block7;
                    }
                    this.buf[count++] = (char)b;
                    this.buf[count++] = (char)b1;
                    i += 2;
                }
                if (i < len) {
                    b = bytes[i] & 0xFF;
                    if (JSONCharArrayWriter.isNoEscape(b)) {
                        this.buf[count++] = (char)b;
                        break block7;
                    } else {
                        String escapeStr = JSONGeneral.ESCAPE_VALUES[b];
                        int escapesLen = escapeStr.length();
                        for (int j = 0; j < escapesLen; ++j) {
                            this.buf[count++] = escapeStr.charAt(j);
                        }
                    }
                }
                break block7;
            }
            int beginIndex = 0;
            for (int i = 0; i < len; ++i) {
                int b = bytes[i] & 0xFF;
                if (JSONGeneral.ESCAPE_FLAGS[b] == 0) continue;
                String escapeStr = JSONGeneral.ESCAPE_VALUES[b];
                int length = i - beginIndex;
                this.expandCapacity(length + count + 8);
                if (length > 0) {
                    value.getChars(beginIndex, i, this.buf, count);
                    count += length;
                }
                int escapesLen = escapeStr.length();
                escapeStr.getChars(0, escapesLen, this.buf, count);
                count += escapesLen;
                beginIndex = i + 1;
            }
            int length = len - beginIndex;
            if (length > 0) {
                value.getChars(beginIndex, len, this.buf, count);
                count += length;
            }
        }
        this.buf[count++] = 34;
        this.count = count;
    }

    @Override
    final void writeMemory(long fourChars, int fourBytes, int len) throws IOException {
        JSONUnsafe.putLong(this.buf, this.count, fourChars);
        this.count += len;
    }

    @Override
    void writeMemory(long fourChars1, long fourChars2, long fourBytes, int len) throws IOException {
        JSONUnsafe.putLong(this.buf, this.count, fourChars1);
        JSONUnsafe.putLong(this.buf, this.count + 4, fourChars2);
        this.count += len;
    }

    @Override
    final void writeMemory(long[] fourChars, long[] fourBytes, int totalCount) throws IOException {
        int n = fourChars.length;
        this.ensureCapacity((n << 2) + 128);
        int count = this.count;
        for (long fourChar : fourChars) {
            JSONUnsafe.putLong(this.buf, count, fourChar);
            count += 4;
        }
        this.count += totalCount;
    }

    @Override
    public final void writeEmptyArray() throws IOException {
        this.ensureCapacity(130);
        JSONUnsafe.putInt(this.buf, this.count, EMPTY_ARRAY_INT);
        this.count += 2;
    }

    void clearCache() {
        if (this.charBufCache != null) {
            if (this.buf.length <= MAX_CACHE_BUFFER_SIZE) {
                this.charBufCache.cacheChars = this.buf;
            }
            this.charBufCache.inUse = false;
            this.charBufCache = null;
        }
    }

    @Override
    public void clear() {
        this.count = 0;
    }

    @Override
    void reset() {
        this.clear();
        this.clearCache();
        this.buf = EMPTY_BUF;
    }

    static {
        for (int i = 0; i < CACHE_COUNT; ++i) {
            CharBufCache charBufCache = new CharBufCache();
            charBufCache.index = i;
            if (i < AVAILABLE_PROCESSORS) {
                charBufCache.cacheChars = new char[CACHE_BUFFER_SIZE];
            }
            JSONCharArrayWriter.CHAR_BUF_CACHES[i] = charBufCache;
        }
    }

    static class JSONCharArrayIgnoreEscapeWriter
    extends JSONCharArrayWriter {
        JSONCharArrayIgnoreEscapeWriter() {
        }

        @Override
        public void writeJSONChars(char[] chars) throws IOException {
            int len = chars.length;
            this.ensureCapacity(len + 130);
            int count = this.count;
            this.buf[count++] = 34;
            System.arraycopy(chars, 0, this.buf, count, len);
            count += len;
            this.buf[count++] = 34;
            this.count = count;
        }

        @Override
        public void writeLatinJSONString(String value, byte[] bytes) throws IOException {
            int len = bytes.length;
            this.ensureCapacity(len + 130);
            int count = this.count;
            this.buf[count++] = 34;
            value.getChars(0, len, this.buf, count);
            count += len;
            this.buf[count++] = 34;
            this.count = count;
        }
    }

    private static class CharBufCache {
        char[] cacheChars;
        boolean inUse;
        int index;

        private CharBufCache() {
        }
    }
}

