/*
 * Decompiled with CFR 0.152.
 */
package io.github.wycst.wast.json;

import io.github.wycst.wast.common.beans.GregorianDate;
import io.github.wycst.wast.common.compiler.JavaSourceObject;
import io.github.wycst.wast.common.reflect.GetterInfo;
import io.github.wycst.wast.common.reflect.ReflectConsts;
import io.github.wycst.wast.common.reflect.UnsafeHelper;
import io.github.wycst.wast.common.utils.EnvUtils;
import io.github.wycst.wast.json.JSONConfig;
import io.github.wycst.wast.json.JSONPojoFieldSerializer;
import io.github.wycst.wast.json.JSONPojoStructure;
import io.github.wycst.wast.json.JSONTypeSerializer;
import io.github.wycst.wast.json.JSONWriter;
import java.io.IOException;
import java.lang.reflect.Modifier;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicLong;

public class JSONPojoSerializer<T>
extends JSONTypeSerializer {
    protected final JSONPojoStructure pojoStructure;
    protected final Class<?> pojoClass;
    static final String IMPORT_CODE_TEXT = "import io.github.wycst.wast.json.JSONConfig;\nimport io.github.wycst.wast.json.JSONPojoFieldSerializer;\nimport io.github.wycst.wast.json.JSONPojoStructure;\n\nimport io.github.wycst.wast.json.JSONWriter;\n\n";
    static final AtomicLong SEQ = new AtomicLong(1L);

    protected JSONPojoSerializer(Class<T> pojoClass) {
        this.pojoClass = pojoClass;
        this.pojoStructure = JSONPojoStructure.get(pojoClass);
        this.init();
    }

    protected JSONPojoSerializer(JSONPojoStructure pojoStructure) {
        this.pojoStructure = pojoStructure;
        this.pojoClass = pojoStructure.getSourceClass();
        this.init();
    }

    public void init() {
    }

    public void serializePojoCompact(T entity, JSONWriter writer, JSONConfig jsonConfig, int indentLevel) throws Exception {
        boolean writeFullProperty = jsonConfig.isFullProperty();
        boolean writeClassName = jsonConfig.isWriteClassName();
        boolean isEmptyFlag = !this.checkWriteClassName(writeClassName, writer, this.pojoClass, false, indentLevel, jsonConfig);
        JSONPojoFieldSerializer[] fieldSerializers = this.pojoStructure.getFieldSerializers(jsonConfig.isUseFields());
        boolean skipGetterOfNoExistField = jsonConfig.isSkipGetterOfNoneField();
        boolean unCamelCaseToUnderline = !jsonConfig.isCamelCaseToUnderline();
        for (JSONPojoFieldSerializer fieldSerializer : fieldSerializers) {
            Object value;
            GetterInfo getterInfo = fieldSerializer.getGetterInfo();
            if (!getterInfo.existField() && skipGetterOfNoExistField || (value = getterInfo.invoke(entity)) == null && !writeFullProperty) continue;
            if (isEmptyFlag) {
                isEmptyFlag = false;
            } else {
                writer.writeJSONToken(',');
            }
            if (value != null) {
                if (unCamelCaseToUnderline) {
                    fieldSerializer.writeJSONFieldName(writer);
                } else {
                    writer.append('\"').append(getterInfo.getUnderlineName()).append("\":");
                }
                JSONTypeSerializer serializer = fieldSerializer.getSerializer();
                serializer.serialize(value, writer, jsonConfig, -1);
                continue;
            }
            if (unCamelCaseToUnderline) {
                fieldSerializer.writeJSONFieldNameWithNull(writer);
                continue;
            }
            writer.append('\"').append(getterInfo.getUnderlineName()).append("\":null");
        }
    }

    public void serializePojoFormatOut(T entity, JSONWriter writer, JSONConfig jsonConfig, int indentLevel) throws Exception {
        boolean writeFullProperty = jsonConfig.isFullProperty();
        boolean writeClassName = jsonConfig.isWriteClassName();
        boolean formatOutColonSpace = jsonConfig.isFormatOutColonSpace();
        boolean isEmptyFlag = !this.checkWriteClassName(writeClassName, writer, this.pojoClass, true, indentLevel, jsonConfig);
        JSONPojoFieldSerializer[] fieldSerializers = this.pojoStructure.getFieldSerializers(jsonConfig.isUseFields());
        boolean skipGetterOfNoExistField = jsonConfig.isSkipGetterOfNoneField();
        boolean unCamelCaseToUnderline = !jsonConfig.isCamelCaseToUnderline();
        int indentPlus = indentLevel + 1;
        for (JSONPojoFieldSerializer fieldSerializer : fieldSerializers) {
            Object value;
            GetterInfo getterInfo = fieldSerializer.getterInfo;
            if (!getterInfo.existField() && skipGetterOfNoExistField || (value = getterInfo.invoke(entity)) == null && !writeFullProperty) continue;
            if (isEmptyFlag) {
                isEmptyFlag = false;
            } else {
                writer.writeJSONToken(',');
            }
            JSONPojoSerializer.writeFormatOutSymbols(writer, indentPlus, true, jsonConfig);
            if (value != null) {
                if (unCamelCaseToUnderline) {
                    fieldSerializer.writeJSONFieldName(writer);
                } else {
                    writer.append('\"').append(getterInfo.getUnderlineName()).append("\":");
                }
                if (formatOutColonSpace) {
                    writer.writeJSONToken(' ');
                }
                JSONTypeSerializer serializer = fieldSerializer.getSerializer();
                serializer.serialize(value, writer, jsonConfig, indentPlus);
                continue;
            }
            if (unCamelCaseToUnderline) {
                if (formatOutColonSpace) {
                    fieldSerializer.writeJSONFieldName(writer);
                    writer.write(" null");
                    continue;
                }
                fieldSerializer.writeJSONFieldNameWithNull(writer);
                continue;
            }
            writer.writeJSONToken('\"');
            writer.write(getterInfo.getUnderlineName());
            writer.writeJSONToken('\"');
            if (formatOutColonSpace) {
                writer.write(": null");
                continue;
            }
            writer.write(":null");
        }
        if (!isEmptyFlag) {
            JSONPojoSerializer.writeFormatOutSymbols(writer, indentLevel, true, jsonConfig);
        }
    }

    @Override
    protected final void serialize(Object obj, JSONWriter writer, JSONConfig jsonConfig, int indentLevel) throws Exception {
        Class<?> entityClass = obj.getClass();
        if (entityClass == this.pojoClass) {
            int hashcode = -1;
            if (jsonConfig.isSkipCircularReference()) {
                hashcode = System.identityHashCode(obj);
                if (jsonConfig.getStatus(hashcode) == 0) {
                    writer.writeNull();
                    return;
                }
                jsonConfig.setStatus(hashcode, 0);
            }
            this.pojoStructure.ensureInitialized();
            writer.writeJSONToken('{');
            boolean formatOut = jsonConfig.isFormatOut();
            Object entity = obj;
            if (formatOut) {
                this.serializePojoFormatOut(entity, writer, jsonConfig, indentLevel);
            } else {
                this.serializePojoCompact(entity, writer, jsonConfig, indentLevel);
            }
            this.writeEndPojo(writer);
            jsonConfig.setStatus(hashcode, -1);
        } else {
            JSONTypeSerializer serializer = JSONPojoSerializer.getTypeSerializer(entityClass);
            serializer.serialize(obj, writer, jsonConfig, indentLevel);
        }
    }

    protected void writeEndPojo(JSONWriter writer) throws IOException {
        writer.write(125);
    }

    protected final void doSerialize(JSONTypeSerializer serializer, Object fieldValue, JSONWriter writer, JSONConfig jsonConfig, int indentLevel) throws Exception {
        serializer.serialize(fieldValue, writer, jsonConfig, indentLevel);
    }

    protected final void writeMemory(JSONWriter jsonWriter, long fourChars1, long fourChars2, long fourBytes, int len) throws IOException {
        jsonWriter.writeMemory(fourChars1, fourChars2, fourBytes, len);
    }

    protected final void writeMemory(JSONWriter jsonWriter, long fourChars, int fourBytes, int len) throws IOException {
        jsonWriter.writeMemory(fourChars, fourBytes, len);
    }

    static JavaSourceObject generateRuntimeJavaCodeSource(JSONPojoStructure jsonPojoStructure) {
        return JSONPojoSerializer.generateJavaCodeSource(jsonPojoStructure, false, true);
    }

    static JavaSourceObject generateJavaCodeSource(JSONPojoStructure jsonPojoStructure, boolean printSource, boolean runtime) {
        Class<?> pojoClass = jsonPojoStructure.getSourceClass();
        String simpleName = pojoClass.getSimpleName();
        String canonicalName = pojoClass.getCanonicalName();
        String genClassName = "__JPS_" + simpleName + "_" + SEQ.getAndIncrement();
        String packageName = pojoClass.getPackage().getName();
        StringBuilder codeBuilder = new StringBuilder(2048);
        codeBuilder.append("package ").append(packageName).append(";\n\n");
        codeBuilder.append(IMPORT_CODE_TEXT);
        if (!runtime) {
            codeBuilder.append("/**\n");
            codeBuilder.append(" * pojo serializer \n");
            codeBuilder.append(" * @Date " + new GregorianDate() + "\n");
            codeBuilder.append(" * @Created by code generator\n");
            codeBuilder.append(" */\n");
        }
        codeBuilder.append("public final class ").append(genClassName).append(" extends io.github.wycst.wast.json.JSONPojoSerializer<").append(canonicalName).append("> {\n\n");
        StringBuilder fieldsDefinitionBuilder = new StringBuilder(64);
        StringBuilder fieldSetBuilder = new StringBuilder(64);
        StringBuilder serializePojoCompactHeaderBuilder = new StringBuilder(1024);
        if (!jsonPojoStructure.isForceUseFields()) {
            serializePojoCompactHeaderBuilder.append("\t\tif(jsonConfig.isUseFields()) {\n");
            serializePojoCompactHeaderBuilder.append("\t\t\tsuper.serializePojoCompact(entity, writer, jsonConfig, indentLevel);\n");
            serializePojoCompactHeaderBuilder.append("\t\t\treturn;\n");
            serializePojoCompactHeaderBuilder.append("\t\t}\n");
        }
        serializePojoCompactHeaderBuilder.append("\t\tboolean isEmptyFlag = !checkWriteClassName(jsonConfig.isWriteClassName(), writer, pojoClass, false, indentLevel, jsonConfig);\n");
        StringBuilder serializePojoCompactBodyBuilder = new StringBuilder(1024);
        JSONPojoFieldSerializer[] fieldSerializerUseMethods = jsonPojoStructure.getFieldSerializers(false);
        fieldsDefinitionBuilder.append("\n");
        StringBuilder fieldNameTempBuilder = new StringBuilder();
        boolean appendFieldSerializersFlag = false;
        boolean appendUnCamelCaseToUnderlineFlag = false;
        if (fieldSerializerUseMethods.length > 0) {
            int fieldIndex = 0;
            boolean ensureNotEmptyFlag = false;
            for (JSONPojoFieldSerializer fieldSerializer : fieldSerializerUseMethods) {
                boolean useUnsafe;
                String underlineName;
                boolean firstFlag = fieldIndex == 0;
                GetterInfo getterInfo = fieldSerializer.getGetterInfo();
                String name = getterInfo.getName();
                boolean nameEqualUnderlineName = name.equals(underlineName = getterInfo.getUnderlineName());
                if (!nameEqualUnderlineName) {
                    appendUnCamelCaseToUnderlineFlag = true;
                }
                boolean primitive = getterInfo.isPrimitive();
                Class<?> returnType = getterInfo.getReturnType();
                String returnTypeName = returnType.getName().intern();
                boolean accessFlag = getterInfo.isAccess() && Modifier.isPublic(returnType.getModifiers());
                boolean isBoolean = returnType == Boolean.TYPE;
                String fieldSerializerName = name + "UseMethodSerializer";
                String valueVar = fieldSerializer.getName();
                byte[] bytes = valueVar.getBytes();
                boolean isFieldNameAscii = bytes.length == valueVar.length();
                long[] longs = null;
                long[] longsWithComma = null;
                long[] longsWithCommaBoolFalse = null;
                int[] ints = null;
                int[] intsWithComma = null;
                int[] intsWithCommaBoolFalse = null;
                int fieldNameTokenLength = 0;
                int fieldNameTokenBoolFalseLength = 0;
                boolean bl = useUnsafe = runtime && isFieldNameAscii;
                if (useUnsafe) {
                    fieldNameTempBuilder.setLength(0);
                    fieldNameTempBuilder.append(",\"").append(valueVar).append("\":");
                    if (isBoolean) {
                        fieldNameTempBuilder.append("true");
                    }
                    fieldNameTokenLength = fieldNameTempBuilder.length();
                    fieldNameTokenBoolFalseLength = fieldNameTokenLength + 1;
                    longs = UnsafeHelper.getCharLongs(fieldNameTempBuilder.substring(1));
                    longsWithComma = UnsafeHelper.getCharLongs(fieldNameTempBuilder.toString());
                    ints = UnsafeHelper.getByteInts(fieldNameTempBuilder.substring(1));
                    intsWithComma = UnsafeHelper.getByteInts(fieldNameTempBuilder.toString());
                    if (isBoolean) {
                        fieldNameTempBuilder.setLength(fieldNameTempBuilder.length() - 4);
                        fieldNameTempBuilder.append("false");
                        longsWithCommaBoolFalse = UnsafeHelper.getCharLongs(fieldNameTempBuilder.toString());
                        intsWithCommaBoolFalse = UnsafeHelper.getByteInts(fieldNameTempBuilder.toString());
                    }
                }
                if (accessFlag) {
                    long l3;
                    int i2;
                    int i1;
                    long l2;
                    long l1;
                    int len;
                    int i;
                    boolean remOne;
                    int arrLength;
                    int total;
                    serializePojoCompactBodyBuilder.append("\t\t" + returnType.getCanonicalName() + " " + valueVar + " = entity." + getterInfo.generateCode() + ";\n");
                    if (primitive) {
                        if (firstFlag) {
                            if (isBoolean) {
                                serializePojoCompactBodyBuilder.append("\t\tif(" + valueVar + ") {\n");
                                if (nameEqualUnderlineName) {
                                    serializePojoCompactBodyBuilder.append("\t\t\twriter.write(\"\\\"" + valueVar + "\\\":true\");\n");
                                } else {
                                    serializePojoCompactBodyBuilder.append("\t\t\tif (unCamelCaseToUnderline) {\n");
                                    serializePojoCompactBodyBuilder.append("\t\t\t\twriter.write(\"\\\"" + valueVar + "\\\":true\");\n");
                                    serializePojoCompactBodyBuilder.append("\t\t\t} else {\n");
                                    serializePojoCompactBodyBuilder.append("\t\t\t\twriter.write(\"\\\"" + underlineName + "\\\":true\");\n");
                                    serializePojoCompactBodyBuilder.append("\t\t\t}\n");
                                }
                                serializePojoCompactBodyBuilder.append("\t\t} else {\n");
                                if (nameEqualUnderlineName) {
                                    serializePojoCompactBodyBuilder.append("\t\t\twriter.write(\"\\\"" + valueVar + "\\\":false\");\n");
                                } else {
                                    serializePojoCompactBodyBuilder.append("\t\t\tif (unCamelCaseToUnderline) {\n");
                                    serializePojoCompactBodyBuilder.append("\t\t\t\twriter.write(\"\\\"" + valueVar + "\\\":false\");\n");
                                    serializePojoCompactBodyBuilder.append("\t\t\t} else {\n");
                                    serializePojoCompactBodyBuilder.append("\t\t\t\twriter.write(\"\\\"" + underlineName + "\\\":false\");\n");
                                    serializePojoCompactBodyBuilder.append("\t\t\t}\n");
                                }
                                serializePojoCompactBodyBuilder.append("\t\t}\n");
                            } else {
                                if (nameEqualUnderlineName) {
                                    total = fieldNameTokenLength - 1;
                                    if (useUnsafe) {
                                        arrLength = longs.length;
                                        boolean bl2 = remOne = (total & 3) == 1;
                                        if (remOne) {
                                            --arrLength;
                                        }
                                        for (i = 0; i < arrLength; ++i) {
                                            if (i + 1 < arrLength) {
                                                len = total > 8 ? 8 : total;
                                                l1 = longs[i];
                                                l2 = longs[i + 1];
                                                i1 = ints[i];
                                                i2 = ints[i + 1];
                                                l3 = EnvUtils.BIG_ENDIAN ? (long)i1 << 32 | (long)i2 : (long)i2 << 32 | (long)i1;
                                                serializePojoCompactBodyBuilder.append("\t\twriteMemory(writer, " + l1 + "L, " + l2 + "L, " + l3 + "L, " + len + ");\n");
                                                total -= 8;
                                                ++i;
                                                continue;
                                            }
                                            len = total > 4 ? 4 : total;
                                            serializePojoCompactBodyBuilder.append("\t\twriteMemory(writer, " + longs[i] + "L, " + ints[i] + ", " + len + ");\n");
                                            total -= 4;
                                        }
                                        if (remOne) {
                                            serializePojoCompactBodyBuilder.append("\t\twriter.writeJSONToken(':');\n");
                                        }
                                    } else {
                                        serializePojoCompactBodyBuilder.append("\t\twriter.write(\"\\\"" + valueVar + "\\\":\");\n");
                                    }
                                } else {
                                    serializePojoCompactBodyBuilder.append("\t\tif (unCamelCaseToUnderline) {\n");
                                    serializePojoCompactBodyBuilder.append("\t\t\twriter.write(\"\\\"" + valueVar + "\\\":\");\n");
                                    serializePojoCompactBodyBuilder.append("\t\t} else {\n");
                                    serializePojoCompactBodyBuilder.append("\t\t\twriter.write(\"\\\"" + underlineName + "\\\":\");\n");
                                    serializePojoCompactBodyBuilder.append("\t\t}\n");
                                }
                                if (returnType == Double.TYPE) {
                                    serializePojoCompactBodyBuilder.append("\t\twriter.writeDouble(" + valueVar + ");\n");
                                } else if (returnType == Float.TYPE) {
                                    serializePojoCompactBodyBuilder.append("\t\twriter.writeFloat(" + valueVar + ");\n");
                                } else if (returnType == Long.TYPE || returnType == Integer.TYPE || returnType == Short.TYPE || returnType == Byte.TYPE) {
                                    serializePojoCompactBodyBuilder.append("\t\twriter.writeLong(" + valueVar + ");\n");
                                } else {
                                    serializePojoCompactBodyBuilder.append("\t\twriter.writeJSONToken('\"');\n");
                                    serializePojoCompactBodyBuilder.append("\t\twriter.write(" + valueVar + ");\n");
                                    serializePojoCompactBodyBuilder.append("\t\twriter.writeJSONToken('\"');\n");
                                }
                            }
                        } else if (isBoolean) {
                            if (ensureNotEmptyFlag) {
                                serializePojoCompactBodyBuilder.append("\t\tif(" + valueVar + ") {\n");
                                if (nameEqualUnderlineName) {
                                    total = fieldNameTokenLength;
                                    if (useUnsafe) {
                                        arrLength = longsWithComma.length;
                                        boolean bl3 = remOne = (total & 3) == 1;
                                        if (remOne) {
                                            --arrLength;
                                        }
                                        for (i = 0; i < arrLength; ++i) {
                                            if (i + 1 < arrLength) {
                                                len = total > 8 ? 8 : total;
                                                l1 = longsWithComma[i];
                                                l2 = longsWithComma[i + 1];
                                                i1 = intsWithComma[i];
                                                i2 = intsWithComma[i + 1];
                                                l3 = EnvUtils.BIG_ENDIAN ? (long)i1 << 32 | (long)i2 : (long)i2 << 32 | (long)i1;
                                                serializePojoCompactBodyBuilder.append("\t\t\twriteMemory(writer, " + l1 + "L, " + l2 + "L, " + l3 + "L, " + len + ");\n");
                                                total -= 8;
                                                ++i;
                                                continue;
                                            }
                                            len = total > 4 ? 4 : total;
                                            serializePojoCompactBodyBuilder.append("\t\t\twriteMemory(writer, " + longsWithComma[i] + "L, " + intsWithComma[i] + ", " + len + ");\n");
                                            total -= 4;
                                        }
                                        if (remOne) {
                                            serializePojoCompactBodyBuilder.append("\t\t\twriter.writeJSONToken('e');\n");
                                        }
                                    } else {
                                        serializePojoCompactBodyBuilder.append("\t\t\twriter.write(\",\\\"" + valueVar + "\\\":true\");\n");
                                    }
                                } else {
                                    serializePojoCompactBodyBuilder.append("\t\t\tif (unCamelCaseToUnderline) {\n");
                                    total = fieldNameTokenLength;
                                    if (useUnsafe) {
                                        arrLength = longsWithComma.length;
                                        boolean bl4 = remOne = (total & 3) == 1;
                                        if (remOne) {
                                            --arrLength;
                                        }
                                        for (i = 0; i < arrLength; ++i) {
                                            if (i + 1 < arrLength) {
                                                len = total > 8 ? 8 : total;
                                                l1 = longsWithComma[i];
                                                l2 = longsWithComma[i + 1];
                                                i1 = intsWithComma[i];
                                                i2 = intsWithComma[i + 1];
                                                l3 = EnvUtils.BIG_ENDIAN ? (long)i1 << 32 | (long)i2 : (long)i2 << 32 | (long)i1;
                                                serializePojoCompactBodyBuilder.append("\t\t\t\twriteMemory(writer, " + l1 + "L, " + l2 + "L, " + l3 + "L, " + len + ");\n");
                                                total -= 8;
                                                ++i;
                                                continue;
                                            }
                                            len = total > 4 ? 4 : total;
                                            serializePojoCompactBodyBuilder.append("\t\t\t\twriteMemory(writer, " + longsWithComma[i] + "L, " + intsWithComma[i] + ", " + len + ");\n");
                                            total -= 4;
                                        }
                                        if (remOne) {
                                            serializePojoCompactBodyBuilder.append("\t\t\t\twriter.writeJSONToken('e');\n");
                                        }
                                    } else {
                                        serializePojoCompactBodyBuilder.append("\t\t\t\twriter.write(\",\\\"" + valueVar + "\\\":true\");\n");
                                    }
                                    serializePojoCompactBodyBuilder.append("\t\t\t} else {\n");
                                    serializePojoCompactBodyBuilder.append("\t\t\t\twriter.write(\",\\\"" + underlineName + "\\\":true\");\n");
                                    serializePojoCompactBodyBuilder.append("\t\t\t}\n");
                                }
                                serializePojoCompactBodyBuilder.append("\t\t} else {\n");
                                if (nameEqualUnderlineName) {
                                    total = fieldNameTokenBoolFalseLength;
                                    if (useUnsafe) {
                                        arrLength = longsWithCommaBoolFalse.length;
                                        boolean bl5 = remOne = (total & 3) == 1;
                                        if (remOne) {
                                            --arrLength;
                                        }
                                        for (i = 0; i < arrLength; ++i) {
                                            if (i + 1 < arrLength) {
                                                len = total > 8 ? 8 : total;
                                                l1 = longsWithCommaBoolFalse[i];
                                                l2 = longsWithCommaBoolFalse[i + 1];
                                                i1 = intsWithCommaBoolFalse[i];
                                                i2 = intsWithCommaBoolFalse[i + 1];
                                                l3 = EnvUtils.BIG_ENDIAN ? (long)i1 << 32 | (long)i2 : (long)i2 << 32 | (long)i1;
                                                serializePojoCompactBodyBuilder.append("\t\t\twriteMemory(writer, " + l1 + "L, " + l2 + "L, " + l3 + "L, " + len + ");\n");
                                                total -= 8;
                                                ++i;
                                                continue;
                                            }
                                            len = total > 4 ? 4 : total;
                                            serializePojoCompactBodyBuilder.append("\t\t\twriteMemory(writer, " + longsWithCommaBoolFalse[i] + "L, " + intsWithCommaBoolFalse[i] + ", " + len + ");\n");
                                            total -= 4;
                                        }
                                        if (remOne) {
                                            serializePojoCompactBodyBuilder.append("\t\t\twriter.writeJSONToken('e');\n");
                                        }
                                    } else {
                                        serializePojoCompactBodyBuilder.append("\t\t\twriter.write(\",\\\"" + valueVar + "\\\":false\");\n");
                                    }
                                } else {
                                    serializePojoCompactBodyBuilder.append("\t\t\tif (unCamelCaseToUnderline) {\n");
                                    total = fieldNameTokenBoolFalseLength;
                                    if (useUnsafe) {
                                        arrLength = longsWithCommaBoolFalse.length;
                                        boolean bl6 = remOne = (total & 3) == 1;
                                        if (remOne) {
                                            --arrLength;
                                        }
                                        for (i = 0; i < arrLength; ++i) {
                                            if (i + 1 < arrLength) {
                                                len = total > 8 ? 8 : total;
                                                l1 = longsWithCommaBoolFalse[i];
                                                l2 = longsWithCommaBoolFalse[i + 1];
                                                i1 = intsWithCommaBoolFalse[i];
                                                i2 = intsWithCommaBoolFalse[i + 1];
                                                l3 = EnvUtils.BIG_ENDIAN ? (long)i1 << 32 | (long)i2 : (long)i2 << 32 | (long)i1;
                                                serializePojoCompactBodyBuilder.append("\t\t\t\twriteMemory(writer, " + l1 + "L, " + l2 + "L, " + l3 + "L, " + len + ");\n");
                                                total -= 8;
                                                ++i;
                                                continue;
                                            }
                                            len = total > 4 ? 4 : total;
                                            serializePojoCompactBodyBuilder.append("\t\t\t\twriteMemory(writer, " + longsWithCommaBoolFalse[i] + "L, " + intsWithCommaBoolFalse[i] + ", " + len + ");\n");
                                            total -= 4;
                                        }
                                        if (remOne) {
                                            serializePojoCompactBodyBuilder.append("\t\t\t\twriter.writeJSONToken('e');\n");
                                        }
                                    } else {
                                        serializePojoCompactBodyBuilder.append("\t\t\t\twriter.write(\",\\\"" + valueVar + "\\\":false\");\n");
                                    }
                                    serializePojoCompactBodyBuilder.append("\t\t\t} else {\n");
                                    serializePojoCompactBodyBuilder.append("\t\t\t\twriter.write(\",\\\"" + underlineName + "\\\":false\");\n");
                                    serializePojoCompactBodyBuilder.append("\t\t\t}\n");
                                }
                                serializePojoCompactBodyBuilder.append("\t\t}\n");
                            } else {
                                serializePojoCompactBodyBuilder.append("\t\tif(isEmptyFlag) {\n");
                                serializePojoCompactBodyBuilder.append("\t\t\tif(" + valueVar + ") {\n");
                                if (nameEqualUnderlineName) {
                                    serializePojoCompactBodyBuilder.append("\t\t\t\twriter.write(\"\\\"" + valueVar + "\\\":true\");\n");
                                } else {
                                    serializePojoCompactBodyBuilder.append("\t\t\t\tif (unCamelCaseToUnderline) {\n");
                                    serializePojoCompactBodyBuilder.append("\t\t\t\t\twriter.write(\"\\\"" + valueVar + "\\\":true\");\n");
                                    serializePojoCompactBodyBuilder.append("\t\t\t\t} else {\n");
                                    serializePojoCompactBodyBuilder.append("\t\t\t\t\twriter.write(\"\\\"" + underlineName + "\\\":true\");\n");
                                    serializePojoCompactBodyBuilder.append("\t\t\t\t}\n");
                                }
                                serializePojoCompactBodyBuilder.append("\t\t\t} else {\n");
                                if (nameEqualUnderlineName) {
                                    serializePojoCompactBodyBuilder.append("\t\t\t\twriter.write(\"\\\"" + valueVar + "\\\":false\");\n");
                                } else {
                                    serializePojoCompactBodyBuilder.append("\t\t\t\tif (unCamelCaseToUnderline) {\n");
                                    serializePojoCompactBodyBuilder.append("\t\t\t\t\twriter.write(\"\\\"" + valueVar + "\\\":false\");\n");
                                    serializePojoCompactBodyBuilder.append("\t\t\t\t} else {\n");
                                    serializePojoCompactBodyBuilder.append("\t\t\t\t\twriter.write(\"\\\"" + underlineName + "\\\":false\");\n");
                                    serializePojoCompactBodyBuilder.append("\t\t\t\t}\n");
                                }
                                serializePojoCompactBodyBuilder.append("\t\t\t}\n");
                                serializePojoCompactBodyBuilder.append("\t\t} else {\n");
                                serializePojoCompactBodyBuilder.append("\t\t\tif(" + valueVar + ") {\n");
                                if (nameEqualUnderlineName) {
                                    serializePojoCompactBodyBuilder.append("\t\t\t\twriter.write(\",\\\"" + valueVar + "\\\":true\");\n");
                                } else {
                                    serializePojoCompactBodyBuilder.append("\t\t\t\tif (unCamelCaseToUnderline) {\n");
                                    serializePojoCompactBodyBuilder.append("\t\t\t\t\twriter.write(\",\\\"" + valueVar + "\\\":true\");\n");
                                    serializePojoCompactBodyBuilder.append("\t\t\t\t} else {\n");
                                    serializePojoCompactBodyBuilder.append("\t\t\t\t\twriter.write(\",\\\"" + underlineName + "\\\":true\");\n");
                                    serializePojoCompactBodyBuilder.append("\t\t\t\t}\n");
                                }
                                serializePojoCompactBodyBuilder.append("\t\t\t} else {\n");
                                if (nameEqualUnderlineName) {
                                    serializePojoCompactBodyBuilder.append("\t\t\t\twriter.write(\",\\\"" + valueVar + "\\\":false\");\n");
                                } else {
                                    serializePojoCompactBodyBuilder.append("\t\t\t\tif (unCamelCaseToUnderline) {\n");
                                    serializePojoCompactBodyBuilder.append("\t\t\t\t\twriter.write(\",\\\"" + valueVar + "\\\":false\");\n");
                                    serializePojoCompactBodyBuilder.append("\t\t\t\t} else {\n");
                                    serializePojoCompactBodyBuilder.append("\t\t\t\t\twriter.write(\",\\\"" + underlineName + "\\\":false\");\n");
                                    serializePojoCompactBodyBuilder.append("\t\t\t\t}\n");
                                }
                                serializePojoCompactBodyBuilder.append("\t\t\t}\n");
                                serializePojoCompactBodyBuilder.append("\t\t}\n");
                            }
                        } else {
                            if (ensureNotEmptyFlag) {
                                if (nameEqualUnderlineName) {
                                    total = fieldNameTokenLength;
                                    if (useUnsafe) {
                                        arrLength = longsWithComma.length;
                                        boolean bl7 = remOne = (total & 3) == 1;
                                        if (remOne) {
                                            --arrLength;
                                        }
                                        for (i = 0; i < arrLength; ++i) {
                                            if (i + 1 < arrLength) {
                                                len = total > 8 ? 8 : total;
                                                l1 = longsWithComma[i];
                                                l2 = longsWithComma[i + 1];
                                                i1 = intsWithComma[i];
                                                i2 = intsWithComma[i + 1];
                                                l3 = EnvUtils.BIG_ENDIAN ? (long)i1 << 32 | (long)i2 : (long)i2 << 32 | (long)i1;
                                                serializePojoCompactBodyBuilder.append("\t\twriteMemory(writer, " + l1 + "L, " + l2 + "L, " + l3 + "L, " + len + ");\n");
                                                total -= 8;
                                                ++i;
                                                continue;
                                            }
                                            len = total > 4 ? 4 : total;
                                            serializePojoCompactBodyBuilder.append("\t\twriteMemory(writer, " + longsWithComma[i] + "L, " + intsWithComma[i] + ", " + len + ");\n");
                                            total -= 4;
                                        }
                                        if (remOne) {
                                            serializePojoCompactBodyBuilder.append("\t\twriter.writeJSONToken(':');\n");
                                        }
                                    } else {
                                        serializePojoCompactBodyBuilder.append("\t\twriter.write(\",\\\"" + valueVar + "\\\":\");\n");
                                    }
                                } else {
                                    serializePojoCompactBodyBuilder.append("\t\tif (unCamelCaseToUnderline) {\n");
                                    total = fieldNameTokenLength;
                                    if (useUnsafe) {
                                        arrLength = longsWithComma.length;
                                        boolean bl8 = remOne = (total & 3) == 1;
                                        if (remOne) {
                                            --arrLength;
                                        }
                                        for (i = 0; i < arrLength; ++i) {
                                            if (i + 1 < arrLength) {
                                                len = total > 8 ? 8 : total;
                                                l1 = longsWithComma[i];
                                                l2 = longsWithComma[i + 1];
                                                i1 = intsWithComma[i];
                                                i2 = intsWithComma[i + 1];
                                                l3 = EnvUtils.BIG_ENDIAN ? (long)i1 << 32 | (long)i2 : (long)i2 << 32 | (long)i1;
                                                serializePojoCompactBodyBuilder.append("\t\t\twriteMemory(writer, " + l1 + "L, " + l2 + "L, " + l3 + "L, " + len + ");\n");
                                                total -= 8;
                                                ++i;
                                                continue;
                                            }
                                            len = total > 4 ? 4 : total;
                                            serializePojoCompactBodyBuilder.append("\t\t\twriteMemory(writer, " + longsWithComma[i] + "L, " + intsWithComma[i] + ", " + len + ");\n");
                                            total -= 4;
                                        }
                                        if (remOne) {
                                            serializePojoCompactBodyBuilder.append("\t\t\twriter.writeJSONToken(':');\n");
                                        }
                                    } else {
                                        serializePojoCompactBodyBuilder.append("\t\t\twriter.write(\",\\\"" + valueVar + "\\\":\");\n");
                                    }
                                    serializePojoCompactBodyBuilder.append("\t\t} else {\n");
                                    serializePojoCompactBodyBuilder.append("\t\t\twriter.write(\",\\\"" + underlineName + "\\\":\");\n");
                                    serializePojoCompactBodyBuilder.append("\t\t}\n");
                                }
                            } else {
                                serializePojoCompactBodyBuilder.append("\t\tif(isEmptyFlag) {\n");
                                if (nameEqualUnderlineName) {
                                    total = fieldNameTokenLength - 1;
                                    if (useUnsafe) {
                                        arrLength = longs.length;
                                        boolean bl9 = remOne = (total & 3) == 1;
                                        if (remOne) {
                                            --arrLength;
                                        }
                                        for (i = 0; i < arrLength; ++i) {
                                            if (i + 1 < arrLength) {
                                                len = total > 8 ? 8 : total;
                                                l1 = longs[i];
                                                l2 = longs[i + 1];
                                                i1 = ints[i];
                                                i2 = ints[i + 1];
                                                l3 = EnvUtils.BIG_ENDIAN ? (long)i1 << 32 | (long)i2 : (long)i2 << 32 | (long)i1;
                                                serializePojoCompactBodyBuilder.append("\t\t\twriteMemory(writer, " + l1 + "L, " + l2 + "L, " + l3 + "L, " + len + ");\n");
                                                total -= 8;
                                                ++i;
                                                continue;
                                            }
                                            len = total > 4 ? 4 : total;
                                            serializePojoCompactBodyBuilder.append("\t\t\twriteMemory(writer, " + longs[i] + "L, " + ints[i] + ", " + len + ");\n");
                                            total -= 4;
                                        }
                                        if (remOne) {
                                            serializePojoCompactBodyBuilder.append("\t\t\twriter.writeJSONToken(':');\n");
                                        }
                                    } else {
                                        serializePojoCompactBodyBuilder.append("\t\t\twriter.write(\"\\\"" + valueVar + "\\\":\");\n");
                                    }
                                } else {
                                    serializePojoCompactBodyBuilder.append("\t\t\tif (unCamelCaseToUnderline) {\n");
                                    total = fieldNameTokenLength - 1;
                                    if (useUnsafe) {
                                        arrLength = longs.length;
                                        boolean bl10 = remOne = (total & 3) == 1;
                                        if (remOne) {
                                            --arrLength;
                                        }
                                        for (i = 0; i < arrLength; ++i) {
                                            if (i + 1 < arrLength) {
                                                len = total > 8 ? 8 : total;
                                                l1 = longs[i];
                                                l2 = longs[i + 1];
                                                i1 = ints[i];
                                                i2 = ints[i + 1];
                                                l3 = EnvUtils.BIG_ENDIAN ? (long)i1 << 32 | (long)i2 : (long)i2 << 32 | (long)i1;
                                                serializePojoCompactBodyBuilder.append("\t\t\t\twriteMemory(writer, " + l1 + "L, " + l2 + "L, " + l3 + "L, " + len + ");\n");
                                                total -= 8;
                                                ++i;
                                                continue;
                                            }
                                            len = total > 4 ? 4 : total;
                                            serializePojoCompactBodyBuilder.append("\t\t\t\twriteMemory(writer, " + longs[i] + "L, " + ints[i] + ", " + len + ");\n");
                                            total -= 4;
                                        }
                                        if (remOne) {
                                            serializePojoCompactBodyBuilder.append("\t\t\t\twriter.writeJSONToken(':');\n");
                                        }
                                    } else {
                                        serializePojoCompactBodyBuilder.append("\t\t\t\twriter.write(\"\\\"" + valueVar + "\\\":\");\n");
                                    }
                                    serializePojoCompactBodyBuilder.append("\t\t\t} else {\n");
                                    serializePojoCompactBodyBuilder.append("\t\t\t\twriter.write(\"\\\"" + underlineName + "\\\":\");\n");
                                    serializePojoCompactBodyBuilder.append("\t\t\t}\n");
                                }
                                serializePojoCompactBodyBuilder.append("\t\t} else {\n");
                                if (nameEqualUnderlineName) {
                                    total = fieldNameTokenLength;
                                    if (useUnsafe) {
                                        arrLength = longsWithComma.length;
                                        boolean bl11 = remOne = (total & 3) == 1;
                                        if (remOne) {
                                            --arrLength;
                                        }
                                        for (i = 0; i < arrLength; ++i) {
                                            if (i + 1 < arrLength) {
                                                len = total > 8 ? 8 : total;
                                                l1 = longsWithComma[i];
                                                l2 = longsWithComma[i + 1];
                                                i1 = intsWithComma[i];
                                                i2 = intsWithComma[i + 1];
                                                l3 = EnvUtils.BIG_ENDIAN ? (long)i1 << 32 | (long)i2 : (long)i2 << 32 | (long)i1;
                                                serializePojoCompactBodyBuilder.append("\t\t\twriteMemory(writer, " + l1 + "L, " + l2 + "L, " + l3 + "L, " + len + ");\n");
                                                total -= 8;
                                                ++i;
                                                continue;
                                            }
                                            len = total > 4 ? 4 : total;
                                            serializePojoCompactBodyBuilder.append("\t\t\twriteMemory(writer, " + longsWithComma[i] + "L, " + intsWithComma[i] + ", " + len + ");\n");
                                            total -= 4;
                                        }
                                        if (remOne) {
                                            serializePojoCompactBodyBuilder.append("\t\t\twriter.writeJSONToken(':');\n");
                                        }
                                    } else {
                                        serializePojoCompactBodyBuilder.append("\t\t\twriter.write(\",\\\"" + valueVar + "\\\":\");\n");
                                    }
                                } else {
                                    serializePojoCompactBodyBuilder.append("\t\t\tif (unCamelCaseToUnderline) {\n");
                                    total = fieldNameTokenLength;
                                    if (useUnsafe) {
                                        arrLength = longsWithComma.length;
                                        boolean bl12 = remOne = (total & 3) == 1;
                                        if (remOne) {
                                            --arrLength;
                                        }
                                        for (i = 0; i < arrLength; ++i) {
                                            if (i + 1 < arrLength) {
                                                len = total > 8 ? 8 : total;
                                                l1 = longsWithComma[i];
                                                l2 = longsWithComma[i + 1];
                                                i1 = intsWithComma[i];
                                                i2 = intsWithComma[i + 1];
                                                l3 = EnvUtils.BIG_ENDIAN ? (long)i1 << 32 | (long)i2 : (long)i2 << 32 | (long)i1;
                                                serializePojoCompactBodyBuilder.append("\t\t\t\twriteMemory(writer, " + l1 + "L, " + l2 + "L, " + l3 + "L, " + len + ");\n");
                                                total -= 8;
                                                ++i;
                                                continue;
                                            }
                                            len = total > 4 ? 4 : total;
                                            serializePojoCompactBodyBuilder.append("\t\t\t\twriteMemory(writer, " + longsWithComma[i] + "L, " + intsWithComma[i] + ", " + len + ");\n");
                                            total -= 4;
                                        }
                                        if (remOne) {
                                            serializePojoCompactBodyBuilder.append("\t\t\t\twriter.writeJSONToken(':');\n");
                                        }
                                    } else {
                                        serializePojoCompactBodyBuilder.append("\t\t\twriter.write(\",\\\"" + valueVar + "\\\":\");\n");
                                    }
                                    serializePojoCompactBodyBuilder.append("\t\t\t} else {\n");
                                    serializePojoCompactBodyBuilder.append("\t\t\twriter.write(\",\\\"" + underlineName + "\\\":\");\n");
                                    serializePojoCompactBodyBuilder.append("\t\t\t}\n");
                                }
                                serializePojoCompactBodyBuilder.append("\t\t}\n");
                            }
                            if (returnType == Double.TYPE) {
                                serializePojoCompactBodyBuilder.append("\t\twriter.writeDouble(" + valueVar + ");\n");
                            } else if (returnType == Float.TYPE) {
                                serializePojoCompactBodyBuilder.append("\t\twriter.writeFloat(" + valueVar + ");\n");
                            } else if (returnType == Long.TYPE || returnType == Integer.TYPE || returnType == Short.TYPE || returnType == Byte.TYPE) {
                                serializePojoCompactBodyBuilder.append("\t\twriter.writeLong(" + valueVar + ");\n");
                            } else {
                                serializePojoCompactBodyBuilder.append("\t\twriter.writeJSONToken('\"');\n");
                                serializePojoCompactBodyBuilder.append("\t\twriter.write(" + valueVar + ");\n");
                                serializePojoCompactBodyBuilder.append("\t\twriter.writeJSONToken('\"');\n");
                            }
                        }
                        ensureNotEmptyFlag = true;
                    } else {
                        serializePojoCompactBodyBuilder.append("\t\tif(" + valueVar + " != null) {\n");
                        if (firstFlag) {
                            if (nameEqualUnderlineName) {
                                total = fieldNameTokenLength - 1;
                                if (useUnsafe) {
                                    arrLength = longs.length;
                                    boolean bl13 = remOne = (total & 3) == 1;
                                    if (remOne) {
                                        --arrLength;
                                    }
                                    for (i = 0; i < arrLength; ++i) {
                                        if (i + 1 < arrLength) {
                                            len = total > 8 ? 8 : total;
                                            l1 = longs[i];
                                            l2 = longs[i + 1];
                                            i1 = ints[i];
                                            i2 = ints[i + 1];
                                            l3 = EnvUtils.BIG_ENDIAN ? (long)i1 << 32 | (long)i2 : (long)i2 << 32 | (long)i1;
                                            serializePojoCompactBodyBuilder.append("\t\t\twriteMemory(writer, " + l1 + "L, " + l2 + "L, " + l3 + "L, " + len + ");\n");
                                            total -= 8;
                                            ++i;
                                            continue;
                                        }
                                        len = total > 4 ? 4 : total;
                                        serializePojoCompactBodyBuilder.append("\t\t\twriteMemory(writer, " + longs[i] + "L, " + ints[i] + ", " + len + ");\n");
                                        total -= 4;
                                    }
                                    if (remOne) {
                                        serializePojoCompactBodyBuilder.append("\t\t\twriter.writeJSONToken(':');\n");
                                    }
                                } else {
                                    serializePojoCompactBodyBuilder.append("\t\t\twriter.write(\"\\\"" + valueVar + "\\\":\");\n");
                                }
                            } else {
                                serializePojoCompactBodyBuilder.append("\t\t\tif (unCamelCaseToUnderline) {\n");
                                total = fieldNameTokenLength - 1;
                                if (useUnsafe) {
                                    arrLength = longs.length;
                                    boolean bl14 = remOne = (total & 3) == 1;
                                    if (remOne) {
                                        --arrLength;
                                    }
                                    for (i = 0; i < arrLength; ++i) {
                                        if (i + 1 < arrLength) {
                                            len = total > 8 ? 8 : total;
                                            l1 = longs[i];
                                            l2 = longs[i + 1];
                                            i1 = ints[i];
                                            i2 = ints[i + 1];
                                            l3 = EnvUtils.BIG_ENDIAN ? (long)i1 << 32 | (long)i2 : (long)i2 << 32 | (long)i1;
                                            serializePojoCompactBodyBuilder.append("\t\t\t\twriteMemory(writer, " + l1 + "L, " + l2 + "L, " + l3 + "L, " + len + ");\n");
                                            total -= 8;
                                            ++i;
                                            continue;
                                        }
                                        len = total > 4 ? 4 : total;
                                        serializePojoCompactBodyBuilder.append("\t\t\t\twriteMemory(writer, " + longs[i] + "L, " + ints[i] + ", " + len + ");\n");
                                        total -= 4;
                                    }
                                    if (remOne) {
                                        serializePojoCompactBodyBuilder.append("\t\t\t\twriter.writeJSONToken(':');\n");
                                    }
                                } else {
                                    serializePojoCompactBodyBuilder.append("\t\t\t\twriter.write(\"\\\"" + valueVar + "\\\":\");\n");
                                }
                                serializePojoCompactBodyBuilder.append("\t\t\t} else {\n");
                                serializePojoCompactBodyBuilder.append("\t\t\t\twriter.write(\"\\\"" + underlineName + "\\\":\");\n");
                                serializePojoCompactBodyBuilder.append("\t\t\t}\n");
                            }
                            serializePojoCompactBodyBuilder.append("\t\t\tisEmptyFlag = false;\n");
                        } else if (ensureNotEmptyFlag) {
                            if (nameEqualUnderlineName) {
                                total = fieldNameTokenLength;
                                if (useUnsafe) {
                                    arrLength = longsWithComma.length;
                                    boolean bl15 = remOne = (total & 3) == 1;
                                    if (remOne) {
                                        --arrLength;
                                    }
                                    for (i = 0; i < arrLength; ++i) {
                                        if (i + 1 < arrLength) {
                                            len = total > 8 ? 8 : total;
                                            l1 = longsWithComma[i];
                                            l2 = longsWithComma[i + 1];
                                            i1 = intsWithComma[i];
                                            i2 = intsWithComma[i + 1];
                                            l3 = EnvUtils.BIG_ENDIAN ? (long)i1 << 32 | (long)i2 : (long)i2 << 32 | (long)i1;
                                            serializePojoCompactBodyBuilder.append("\t\t\twriteMemory(writer, " + l1 + "L, " + l2 + "L, " + l3 + "L, " + len + ");\n");
                                            total -= 8;
                                            ++i;
                                            continue;
                                        }
                                        len = total > 4 ? 4 : total;
                                        serializePojoCompactBodyBuilder.append("\t\t\twriteMemory(writer, " + longsWithComma[i] + "L, " + intsWithComma[i] + ", " + len + ");\n");
                                        total -= 4;
                                    }
                                    if (remOne) {
                                        serializePojoCompactBodyBuilder.append("\t\t\twriter.writeJSONToken(':');\n");
                                    }
                                } else {
                                    serializePojoCompactBodyBuilder.append("\t\t\twriter.write(\",\\\"" + valueVar + "\\\":\");\n");
                                }
                            } else {
                                serializePojoCompactBodyBuilder.append("\t\t\tif (unCamelCaseToUnderline) {\n");
                                total = fieldNameTokenLength;
                                if (useUnsafe) {
                                    arrLength = longsWithComma.length;
                                    boolean bl16 = remOne = (total & 3) == 1;
                                    if (remOne) {
                                        --arrLength;
                                    }
                                    for (i = 0; i < arrLength; ++i) {
                                        if (i + 1 < arrLength) {
                                            len = total > 8 ? 8 : total;
                                            l1 = longsWithComma[i];
                                            l2 = longsWithComma[i + 1];
                                            i1 = intsWithComma[i];
                                            i2 = intsWithComma[i + 1];
                                            l3 = EnvUtils.BIG_ENDIAN ? (long)i1 << 32 | (long)i2 : (long)i2 << 32 | (long)i1;
                                            serializePojoCompactBodyBuilder.append("\t\t\t\twriteMemory(writer, " + l1 + "L, " + l2 + "L, " + l3 + "L, " + len + ");\n");
                                            total -= 8;
                                            ++i;
                                            continue;
                                        }
                                        len = total > 4 ? 4 : total;
                                        serializePojoCompactBodyBuilder.append("\t\t\t\twriteMemory(writer, " + longsWithComma[i] + "L, " + intsWithComma[i] + ", " + len + ");\n");
                                        total -= 4;
                                    }
                                    if (remOne) {
                                        serializePojoCompactBodyBuilder.append("\t\t\t\twriter.writeJSONToken(':');\n");
                                    }
                                } else {
                                    serializePojoCompactBodyBuilder.append("\t\t\t\twriter.write(\",\\\"" + valueVar + "\\\":\");\n");
                                }
                                serializePojoCompactBodyBuilder.append("\t\t\t} else {\n");
                                serializePojoCompactBodyBuilder.append("\t\t\t\twriter.write(\",\\\"" + underlineName + "\\\":\");\n");
                                serializePojoCompactBodyBuilder.append("\t\t\t}\n");
                            }
                        } else {
                            serializePojoCompactBodyBuilder.append("\t\t\tif(isEmptyFlag) {\n");
                            serializePojoCompactBodyBuilder.append("\t\t\t\tisEmptyFlag = false;\n");
                            if (nameEqualUnderlineName) {
                                total = fieldNameTokenLength - 1;
                                if (useUnsafe) {
                                    arrLength = longs.length;
                                    boolean bl17 = remOne = (total & 3) == 1;
                                    if (remOne) {
                                        --arrLength;
                                    }
                                    for (i = 0; i < arrLength; ++i) {
                                        if (i + 1 < arrLength) {
                                            len = total > 8 ? 8 : total;
                                            l1 = longs[i];
                                            l2 = longs[i + 1];
                                            i1 = ints[i];
                                            i2 = ints[i + 1];
                                            l3 = EnvUtils.BIG_ENDIAN ? (long)i1 << 32 | (long)i2 : (long)i2 << 32 | (long)i1;
                                            serializePojoCompactBodyBuilder.append("\t\t\t\twriteMemory(writer, " + l1 + "L, " + l2 + "L, " + l3 + "L, " + len + ");\n");
                                            total -= 8;
                                            ++i;
                                            continue;
                                        }
                                        len = total > 4 ? 4 : total;
                                        serializePojoCompactBodyBuilder.append("\t\t\t\twriteMemory(writer, " + longs[i] + "L, " + ints[i] + ", " + len + ");\n");
                                        total -= 4;
                                    }
                                    if (remOne) {
                                        serializePojoCompactBodyBuilder.append("\t\t\t\twriter.writeJSONToken(':');\n");
                                    }
                                } else {
                                    serializePojoCompactBodyBuilder.append("\t\t\t\twriter.write(\"\\\"" + valueVar + "\\\":\");\n");
                                }
                            } else {
                                serializePojoCompactBodyBuilder.append("\t\t\t\tif (unCamelCaseToUnderline) {\n");
                                total = fieldNameTokenLength - 1;
                                if (useUnsafe) {
                                    arrLength = longs.length;
                                    boolean bl18 = remOne = (total & 3) == 1;
                                    if (remOne) {
                                        --arrLength;
                                    }
                                    for (i = 0; i < arrLength; ++i) {
                                        if (i + 1 < arrLength) {
                                            len = total > 8 ? 8 : total;
                                            l1 = longs[i];
                                            l2 = longs[i + 1];
                                            i1 = ints[i];
                                            i2 = ints[i + 1];
                                            l3 = EnvUtils.BIG_ENDIAN ? (long)i1 << 32 | (long)i2 : (long)i2 << 32 | (long)i1;
                                            serializePojoCompactBodyBuilder.append("\t\t\t\t\twriteMemory(writer, " + l1 + "L, " + l2 + "L, " + l3 + "L, " + len + ");\n");
                                            total -= 8;
                                            ++i;
                                            continue;
                                        }
                                        len = total > 4 ? 4 : total;
                                        serializePojoCompactBodyBuilder.append("\t\t\t\t\twriteMemory(writer, " + longs[i] + "L, " + ints[i] + ", " + len + ");\n");
                                        total -= 4;
                                    }
                                    if (remOne) {
                                        serializePojoCompactBodyBuilder.append("\t\t\t\t\twriter.writeJSONToken(':');\n");
                                    }
                                } else {
                                    serializePojoCompactBodyBuilder.append("\t\t\t\t\twriter.write(\"\\\"" + valueVar + "\\\":\");\n");
                                }
                                serializePojoCompactBodyBuilder.append("\t\t\t\t} else {\n");
                                serializePojoCompactBodyBuilder.append("\t\t\t\t\twriter.write(\"\\\"" + underlineName + "\\\":\");\n");
                                serializePojoCompactBodyBuilder.append("\t\t\t\t}\n");
                            }
                            serializePojoCompactBodyBuilder.append("\t\t\t} else {\n");
                            if (nameEqualUnderlineName) {
                                total = fieldNameTokenLength;
                                if (useUnsafe) {
                                    arrLength = longsWithComma.length;
                                    boolean bl19 = remOne = (total & 3) == 1;
                                    if (remOne) {
                                        --arrLength;
                                    }
                                    for (i = 0; i < arrLength; ++i) {
                                        if (i + 1 < arrLength) {
                                            len = total > 8 ? 8 : total;
                                            l1 = longsWithComma[i];
                                            l2 = longsWithComma[i + 1];
                                            i1 = intsWithComma[i];
                                            i2 = intsWithComma[i + 1];
                                            l3 = EnvUtils.BIG_ENDIAN ? (long)i1 << 32 | (long)i2 : (long)i2 << 32 | (long)i1;
                                            serializePojoCompactBodyBuilder.append("\t\t\t\twriteMemory(writer, " + l1 + "L, " + l2 + "L, " + l3 + "L, " + len + ");\n");
                                            total -= 8;
                                            ++i;
                                            continue;
                                        }
                                        len = total > 4 ? 4 : total;
                                        serializePojoCompactBodyBuilder.append("\t\t\t\twriteMemory(writer, " + longsWithComma[i] + "L, " + intsWithComma[i] + ", " + len + ");\n");
                                        total -= 4;
                                    }
                                    if (remOne) {
                                        serializePojoCompactBodyBuilder.append("\t\t\t\twriter.writeJSONToken(':');\n");
                                    }
                                } else {
                                    serializePojoCompactBodyBuilder.append("\t\t\t\twriter.write(\",\\\"" + valueVar + "\\\":\");\n");
                                }
                            } else {
                                serializePojoCompactBodyBuilder.append("\t\t\t\tif (unCamelCaseToUnderline) {\n");
                                total = fieldNameTokenLength;
                                if (useUnsafe) {
                                    arrLength = longsWithComma.length;
                                    boolean bl20 = remOne = (total & 3) == 1;
                                    if (remOne) {
                                        --arrLength;
                                    }
                                    for (i = 0; i < arrLength; ++i) {
                                        if (i + 1 < arrLength) {
                                            len = total > 8 ? 8 : total;
                                            l1 = longsWithComma[i];
                                            l2 = longsWithComma[i + 1];
                                            i1 = intsWithComma[i];
                                            i2 = intsWithComma[i + 1];
                                            l3 = EnvUtils.BIG_ENDIAN ? (long)i1 << 32 | (long)i2 : (long)i2 << 32 | (long)i1;
                                            serializePojoCompactBodyBuilder.append("\t\t\t\t\twriteMemory(writer, " + l1 + "L, " + l2 + "L, " + l3 + "L, " + len + ");\n");
                                            total -= 8;
                                            ++i;
                                            continue;
                                        }
                                        len = total > 4 ? 4 : total;
                                        serializePojoCompactBodyBuilder.append("\t\t\t\t\twriteMemory(writer, " + longsWithComma[i] + "L, " + intsWithComma[i] + ", " + len + ");\n");
                                        total -= 4;
                                    }
                                    if (remOne) {
                                        serializePojoCompactBodyBuilder.append("\t\t\t\t\twriter.writeJSONToken(':');\n");
                                    }
                                } else {
                                    serializePojoCompactBodyBuilder.append("\t\t\t\t\twriter.write(\",\\\"" + valueVar + "\\\":\");\n");
                                }
                                serializePojoCompactBodyBuilder.append("\t\t\t\t} else {\n");
                                serializePojoCompactBodyBuilder.append("\t\t\t\t\twriter.write(\",\\\"" + underlineName + "\\\":\");\n");
                                serializePojoCompactBodyBuilder.append("\t\t\t\t}\n");
                            }
                            serializePojoCompactBodyBuilder.append("\t\t\t}\n");
                        }
                        boolean useSerializerInvokeFlag = false;
                        if (returnType == String.class) {
                            if (runtime) {
                                if (EnvUtils.JDK_9_PLUS) {
                                    serializePojoCompactBodyBuilder.append("\t\t\twriter.writeJSONStringBytes(" + valueVar + ", (byte[]) getStringValue(" + valueVar + "));\n");
                                } else {
                                    serializePojoCompactBodyBuilder.append("\t\t\twriter.writeJSONChars(getChars(" + valueVar + "));\n");
                                }
                            } else {
                                serializePojoCompactBodyBuilder.append("\t\t\twriter.writeJSONString(" + valueVar + ");\n");
                            }
                        } else if (returnType == Double.class) {
                            serializePojoCompactBodyBuilder.append("\t\t\twriter.writeDouble(" + valueVar + ");\n");
                        } else if (returnType == Float.class) {
                            serializePojoCompactBodyBuilder.append("\t\t\twriter.writeFloat(" + valueVar + ");\n");
                        } else if (returnType == Character.class) {
                            serializePojoCompactBodyBuilder.append("\t\t\twriter.writeJSONToken('\"');\n");
                            serializePojoCompactBodyBuilder.append("\t\t\twriter.writeJSONToken(" + valueVar + ");\n");
                            serializePojoCompactBodyBuilder.append("\t\t\twriter.writeJSONToken('\"');\n");
                        } else if (returnType == Long.class || returnType == Integer.class || returnType == Short.class || returnType == Byte.class) {
                            serializePojoCompactBodyBuilder.append("\t\t\twriter.writeLong(" + valueVar + ");\n");
                        } else if (returnType == BigDecimal.class) {
                            serializePojoCompactBodyBuilder.append("\t\t\twriter.write(" + valueVar + ".toString());\n");
                        } else if (returnType == BigInteger.class) {
                            serializePojoCompactBodyBuilder.append("\t\t\twriter.writeBigInteger(" + valueVar + ");\n");
                        } else if (returnType == String[].class) {
                            serializePojoCompactBodyBuilder.append("\t\t\twriter.writeStringArray(" + valueVar + ");\n");
                        } else if (returnType == double[].class) {
                            serializePojoCompactBodyBuilder.append("\t\t\twriter.writeDoubleArray(" + valueVar + ");\n");
                        } else if (returnType == long[].class) {
                            serializePojoCompactBodyBuilder.append("\t\t\twriter.writeLongArray(" + valueVar + ");\n");
                        } else if (fieldSerializer.isStringCollection()) {
                            serializePojoCompactBodyBuilder.append("\t\t\twriter.writeStringCollection(" + valueVar + ");\n");
                        } else if (returnType == UUID.class) {
                            serializePojoCompactBodyBuilder.append("\t\t\twriter.writeUUID(" + valueVar + ");\n");
                        } else if (returnTypeName == "java.time.Instant") {
                            if (fieldSerializer.getJsonProperty() == null || fieldSerializer.getJsonProperty().pattern().length() == 0) {
                                serializePojoCompactBodyBuilder.append("\t\t\twriter.writeJSONInstant(" + valueVar + ".getEpochSecond(), " + valueVar + ".getNano());\n");
                            } else {
                                useSerializerInvokeFlag = true;
                            }
                        } else if (returnTypeName == "java.time.LocalTime") {
                            if (fieldSerializer.getJsonProperty() == null || fieldSerializer.getJsonProperty().pattern().length() == 0) {
                                serializePojoCompactBodyBuilder.append("\t\t\twriter.writeJSONTimeWithNano(" + valueVar + ".getHour(), " + valueVar + ".getMinute(), " + valueVar + ".getSecond(), " + valueVar + ".getNano());\n");
                            } else {
                                useSerializerInvokeFlag = true;
                            }
                        } else if (returnTypeName == "java.time.LocalDate") {
                            if (fieldSerializer.getJsonProperty() == null || fieldSerializer.getJsonProperty().pattern().length() == 0) {
                                serializePojoCompactBodyBuilder.append("\t\t\twriter.writeJSONLocalDate(" + valueVar + ".getYear(), " + valueVar + ".getMonthValue(), " + valueVar + ".getDayOfMonth());\n");
                            } else {
                                useSerializerInvokeFlag = true;
                            }
                        } else if (returnTypeName == "java.time.LocalDateTime") {
                            if (fieldSerializer.getJsonProperty() == null || fieldSerializer.getJsonProperty().pattern().length() == 0) {
                                serializePojoCompactBodyBuilder.append("\t\t\twriter.writeJSONLocalDateTime(" + valueVar + ".getYear(), " + valueVar + ".getMonthValue(), " + valueVar + ".getDayOfMonth(), " + valueVar + ".getHour(), " + valueVar + ".getMinute(), " + valueVar + ".getSecond(), " + valueVar + ".getNano(), null);\n");
                            } else {
                                useSerializerInvokeFlag = true;
                            }
                        } else if (returnTypeName == "java.time.ZonedDateTime" || returnTypeName == "java.time.OffsetDateTime") {
                            if (fieldSerializer.getJsonProperty() == null || fieldSerializer.getJsonProperty().pattern().length() == 0) {
                                if (returnTypeName == "java.time.ZonedDateTime") {
                                    serializePojoCompactBodyBuilder.append("\t\t\twriter.writeJSONLocalDateTime(" + valueVar + ".getYear(), " + valueVar + ".getMonthValue(), " + valueVar + ".getDayOfMonth(), " + valueVar + ".getHour(), " + valueVar + ".getMinute(), " + valueVar + ".getSecond(), " + valueVar + ".getNano(), " + valueVar + ".getZone().getId());\n");
                                } else {
                                    serializePojoCompactBodyBuilder.append("\t\t\twriter.writeJSONLocalDateTime(" + valueVar + ".getYear(), " + valueVar + ".getMonthValue(), " + valueVar + ".getDayOfMonth(), " + valueVar + ".getHour(), " + valueVar + ".getMinute(), " + valueVar + ".getSecond(), " + valueVar + ".getNano(), " + valueVar + ".getOffset().getId());\n");
                                }
                            } else {
                                useSerializerInvokeFlag = true;
                            }
                        } else {
                            useSerializerInvokeFlag = true;
                        }
                        if (useSerializerInvokeFlag) {
                            if (!appendFieldSerializersFlag) {
                                appendFieldSerializersFlag = true;
                                fieldSetBuilder.append("\t\tJSONPojoFieldSerializer[] fieldSerializerUseMethods = pojoStructure.getFieldSerializers(false);\n");
                            }
                            fieldsDefinitionBuilder.append("\tfinal JSONPojoFieldSerializer ").append(fieldSerializerName).append(";\n");
                            fieldSetBuilder.append("\t\tthis.").append(fieldSerializerName).append(" = ").append("fieldSerializerUseMethods[").append(fieldIndex).append("];\n");
                            serializePojoCompactBodyBuilder.append("\t\t\tdoSerialize(" + fieldSerializerName + ".getSerializer(), " + valueVar + ", writer, jsonConfig, -1);\n");
                        }
                        serializePojoCompactBodyBuilder.append("\t\t}\n");
                    }
                } else {
                    if (!appendFieldSerializersFlag) {
                        appendFieldSerializersFlag = true;
                        fieldSetBuilder.append("\t\tJSONPojoFieldSerializer[] fieldSerializerUseMethods = pojoStructure.getFieldSerializers(false);\n");
                    }
                    fieldsDefinitionBuilder.append("\tfinal JSONPojoFieldSerializer ").append(fieldSerializerName).append(";\n");
                    fieldSetBuilder.append("\t\tthis.").append(fieldSerializerName).append(" = ").append("fieldSerializerUseMethods[").append(fieldIndex).append("];\n");
                    serializePojoCompactBodyBuilder.append("\t\tObject " + valueVar + " = " + fieldSerializerName + ".invoke(entity);\n");
                    serializePojoCompactBodyBuilder.append("\t\tif(" + valueVar + " != null) {\n");
                    if (firstFlag) {
                        if (nameEqualUnderlineName) {
                            serializePojoCompactBodyBuilder.append("\t\t\twriter.write(\"\\\"" + valueVar + "\\\":\");\n");
                        } else {
                            serializePojoCompactBodyBuilder.append("\t\t\tif (unCamelCaseToUnderline) {\n");
                            serializePojoCompactBodyBuilder.append("\t\t\t\twriter.write(\"\\\"" + valueVar + "\\\":\");\n");
                            serializePojoCompactBodyBuilder.append("\t\t\t} else {\n");
                            serializePojoCompactBodyBuilder.append("\t\t\t\twriter.write(\"\\\"" + underlineName + "\\\":\");\n");
                            serializePojoCompactBodyBuilder.append("\t\t\t}\n");
                        }
                        serializePojoCompactBodyBuilder.append("\t\t\tisEmptyFlag = false;\n");
                    } else if (ensureNotEmptyFlag) {
                        if (nameEqualUnderlineName) {
                            serializePojoCompactBodyBuilder.append("\t\t\twriter.write(\",\\\"" + valueVar + "\\\":\");\n");
                        } else {
                            serializePojoCompactBodyBuilder.append("\t\t\tif (unCamelCaseToUnderline) {\n");
                            serializePojoCompactBodyBuilder.append("\t\t\t\twriter.write(\",\\\"" + valueVar + "\\\":\");\n");
                            serializePojoCompactBodyBuilder.append("\t\t\t} else {\n");
                            serializePojoCompactBodyBuilder.append("\t\t\t\twriter.write(\",\\\"" + underlineName + "\\\":\");\n");
                            serializePojoCompactBodyBuilder.append("\t\t\t}\n");
                        }
                    } else if (nameEqualUnderlineName) {
                        serializePojoCompactBodyBuilder.append("\t\t\tif(isEmptyFlag) {\n");
                        serializePojoCompactBodyBuilder.append("\t\t\t\tisEmptyFlag = false;\n");
                        serializePojoCompactBodyBuilder.append("\t\t\t\twriter.write(\"\\\"" + valueVar + "\\\":\");\n");
                        serializePojoCompactBodyBuilder.append("\t\t\t} else {\n");
                        serializePojoCompactBodyBuilder.append("\t\t\t\twriter.write(\",\\\"" + valueVar + "\\\":\");\n");
                        serializePojoCompactBodyBuilder.append("\t\t\t}\n");
                    } else {
                        serializePojoCompactBodyBuilder.append("\t\t\tif(isEmptyFlag) {\n");
                        serializePojoCompactBodyBuilder.append("\t\t\t\tisEmptyFlag = false;\n");
                        serializePojoCompactBodyBuilder.append("\t\t\t\tif (unCamelCaseToUnderline) {\n");
                        serializePojoCompactBodyBuilder.append("\t\t\t\t\twriter.write(\"\\\"" + valueVar + "\\\":\");\n");
                        serializePojoCompactBodyBuilder.append("\t\t\t\t} else {\n");
                        serializePojoCompactBodyBuilder.append("\t\t\t\t\twriter.write(\"\\\"" + underlineName + "\\\":\");\n");
                        serializePojoCompactBodyBuilder.append("\t\t\t\t}\n");
                        serializePojoCompactBodyBuilder.append("\t\t\t} else {\n");
                        serializePojoCompactBodyBuilder.append("\t\t\t\tif (unCamelCaseToUnderline) {\n");
                        serializePojoCompactBodyBuilder.append("\t\t\t\t\twriter.write(\",\\\"" + valueVar + "\\\":\");\n");
                        serializePojoCompactBodyBuilder.append("\t\t\t\t} else {\n");
                        serializePojoCompactBodyBuilder.append("\t\t\t\t\twriter.write(\",\\\"" + underlineName + "\\\":\");\n");
                        serializePojoCompactBodyBuilder.append("\t\t\t\t}\n");
                        serializePojoCompactBodyBuilder.append("\t\t\t}\n");
                    }
                    serializePojoCompactBodyBuilder.append("\t\t\tdoSerialize(" + fieldSerializerName + ".getSerializer(), " + valueVar + ", writer, jsonConfig, -1);\n");
                    serializePojoCompactBodyBuilder.append("\t\t}\n");
                }
                serializePojoCompactBodyBuilder.append("\n");
                ++fieldIndex;
            }
        }
        if (appendUnCamelCaseToUnderlineFlag) {
            serializePojoCompactHeaderBuilder.append("\t\tboolean unCamelCaseToUnderline = !jsonConfig.isCamelCaseToUnderline();\n\n");
        } else {
            serializePojoCompactHeaderBuilder.append("\n");
        }
        if (!runtime) {
            codeBuilder.append("\tpublic ").append(genClassName).append("() {\n");
            codeBuilder.append("\t\tthis(JSONPojoStructure.get(" + canonicalName + ".class));\n");
            codeBuilder.append("\t}\n\n");
        }
        codeBuilder.append("\tprotected ").append(genClassName).append("(JSONPojoStructure pojoStructure) {\n");
        codeBuilder.append("\t\tsuper(pojoStructure);\n");
        codeBuilder.append((CharSequence)fieldSetBuilder);
        codeBuilder.append("\t}\n");
        codeBuilder.append((CharSequence)fieldsDefinitionBuilder).append("\n");
        codeBuilder.append("\tpublic void serializePojoCompact(").append(canonicalName).append(" entity, JSONWriter writer, JSONConfig jsonConfig, int indentLevel) throws Exception {\n\n");
        codeBuilder.append((CharSequence)serializePojoCompactHeaderBuilder);
        codeBuilder.append((CharSequence)serializePojoCompactBodyBuilder);
        codeBuilder.append("\t}\n");
        codeBuilder.append("}\n");
        codeBuilder.append("\n");
        String code = codeBuilder.toString();
        if (printSource) {
            System.out.println(code);
        }
        return new JavaSourceObject(packageName, genClassName, code);
    }

    static JavaSourceObject generateJavaCodeSource(JSONPojoStructure jsonPojoStructure, boolean printJavaSource) {
        return JSONPojoSerializer.generateJavaCodeSource(jsonPojoStructure, printJavaSource, false);
    }

    public static JavaSourceObject generateJavaCodeSource(Class<?> pojoClass, boolean printJavaSource) {
        return JSONPojoSerializer.generateJavaCodeSource(pojoClass, printJavaSource, false);
    }

    static JavaSourceObject generateJavaCodeSource(Class<?> pojoClass, boolean printJavaSource, boolean runtime) {
        ReflectConsts.ClassCategory classCategory = ReflectConsts.getClassCategory(pojoClass);
        if (classCategory != ReflectConsts.ClassCategory.ObjectCategory) {
            throw new UnsupportedOperationException(pojoClass + " is not a pojo class");
        }
        JSONPojoStructure jsonPojoStructure = JSONPojoStructure.get(pojoClass);
        if (!jsonPojoStructure.isSupportedJavaBeanConvention()) {
            throw new UnsupportedOperationException(pojoClass + " is not supported for code generator");
        }
        return JSONPojoSerializer.generateJavaCodeSource(jsonPojoStructure, printJavaSource, runtime);
    }

    public static JavaSourceObject generateJavaCodeSource(Class<?> pojoClass) {
        return JSONPojoSerializer.generateJavaCodeSource(pojoClass, false);
    }
}

