/*
 * Decompiled with CFR 0.152.
 */
package io.github.wycst.wast.json;

import io.github.wycst.wast.json.JSONAbstractReader;
import io.github.wycst.wast.json.JSONDefaultParser;
import io.github.wycst.wast.json.exceptions.JSONException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;

public class JSONReader
extends JSONAbstractReader {
    final Reader reader;
    private char[] buf;

    private JSONReader(File file) throws FileNotFoundException {
        this(new FileReader(file));
    }

    public static JSONReader from(File file) {
        try {
            return new JSONReader(file);
        }
        catch (FileNotFoundException e) {
            throw new JSONException(e);
        }
    }

    public static JSONReader from(InputStream inputStream) {
        return new JSONReader(inputStream);
    }

    public static JSONReader from(String json) {
        return new JSONReader(JSONReader.getChars(json));
    }

    public static JSONReader from(char[] source) {
        return new JSONReader(source);
    }

    public JSONReader(char[] buf) {
        this.buf = buf;
        this.count = buf.length;
        this.reader = null;
    }

    public JSONReader(InputStream inputStream) {
        this.reader = new InputStreamReader(inputStream);
    }

    public JSONReader(InputStream inputStream, int buffSize) {
        this.reader = new InputStreamReader(inputStream);
        this.bufferSize = buffSize;
    }

    public JSONReader(InputStream inputStream, String charsetName) {
        InputStreamReader reader;
        try {
            reader = new InputStreamReader(inputStream, charsetName);
        }
        catch (UnsupportedEncodingException e) {
            throw new UnsupportedOperationException(e);
        }
        this.reader = reader;
    }

    public JSONReader(Reader reader) {
        if (reader == null) {
            throw new UnsupportedOperationException("reader is null");
        }
        this.reader = reader;
    }

    @Override
    public Object read() {
        try {
            this.readBuffer();
            if (!this.multiple && this.isCompleted()) {
                Object object = JSONDefaultParser.parse(null, this.buf, 0, this.count, null, this.readOptions);
                return object;
            }
            this.defaultRead();
        }
        catch (Exception e) {
            throw new JSONException(e);
        }
        finally {
            this.tryCloseReader();
        }
        return this.result;
    }

    @Override
    protected void readBuffer() throws IOException {
        if (this.reader == null) {
            return;
        }
        if (this.buf == null) {
            this.buf = new char[this.bufferSize];
        }
        if (this.readingOffset > -1) {
            if (this.bufferSize > this.readingOffset) {
                this.writer.append(this.buf, this.readingOffset, this.bufferSize - this.readingOffset);
            }
            this.readingOffset = 0;
        }
        if (this.offset >= this.count) {
            this.count = this.reader.read(this.buf);
            this.offset = 0;
        }
    }

    @Override
    protected String endReadingAsString(int n) {
        if (this.writer.length() > 0) {
            this.endReading(n);
            return this.writer.toString();
        }
        int endIndex = this.offset + n;
        String result = new String(this.buf, this.readingOffset, endIndex - this.readingOffset);
        this.readingOffset = -1;
        return result;
    }

    @Override
    protected void endReading(int n, int newOffset) {
        int endIndex = this.offset + n;
        if (endIndex > this.readingOffset) {
            this.writer.append(this.buf, this.readingOffset, endIndex - this.readingOffset);
        }
        this.readingOffset = newOffset;
    }

    @Override
    protected int readNext() throws Exception {
        ++this.pos;
        if (this.offset < this.count) {
            this.current = this.buf[this.offset++];
            return this.current;
        }
        if (this.reader == null) {
            this.current = -1;
            return -1;
        }
        if (this.count == this.bufferSize) {
            this.readBuffer();
            if (this.count == -1) {
                this.current = -1;
                return -1;
            }
            this.current = this.buf[this.offset++];
            return this.current;
        }
        this.current = -1;
        return -1;
    }

    @Override
    protected boolean isCompleted() {
        return this.reader == null || this.count < this.bufferSize || this.completed;
    }

    @Override
    public void close() {
        try {
            if (this.reader != null) {
                this.reader.close();
            }
        }
        catch (IOException iOException) {
        }
        finally {
            this.closed = true;
        }
    }
}

