/*
 * Decompiled with CFR 0.152.
 */
package io.github.wycst.wast.json;

import io.github.wycst.wast.common.beans.DateFormatter;
import io.github.wycst.wast.common.reflect.ClassStructureWrapper;
import io.github.wycst.wast.json.JSONConfig;
import io.github.wycst.wast.json.JSONTypeSerializer;
import io.github.wycst.wast.json.JSONWriter;
import io.github.wycst.wast.json.annotations.JsonProperty;
import io.github.wycst.wast.json.temporal.TemporalInstantSerializer;
import io.github.wycst.wast.json.temporal.TemporalLocalDateSerializer;
import io.github.wycst.wast.json.temporal.TemporalLocalDateTimeSerializer;
import io.github.wycst.wast.json.temporal.TemporalLocalTimeSerializer;
import io.github.wycst.wast.json.temporal.TemporalOffsetDateTimeSerializer;
import io.github.wycst.wast.json.temporal.TemporalZonedDateTimeSerializer;

public abstract class JSONTemporalSerializer
extends JSONTypeSerializer {
    protected final Class<?> temporalClass;
    protected DateFormatter dateFormatter;
    protected final boolean useFormatter;

    protected JSONTemporalSerializer(Class<?> temporalClass, JsonProperty property) {
        String pattern;
        this.checkClass(temporalClass);
        this.temporalClass = temporalClass;
        if (property != null && (pattern = property.pattern().trim()).length() > 0) {
            this.dateFormatter = DateFormatter.of(pattern);
        }
        this.useFormatter = this.dateFormatter != null;
    }

    static JSONTypeSerializer getTemporalSerializerInstance(ClassStructureWrapper classStructureWrapper, JsonProperty property) {
        ClassStructureWrapper.ClassWrapperType classWrapperType = classStructureWrapper.getClassWrapperType();
        Class<?> temporalClass = classStructureWrapper.getSourceClass();
        switch (classWrapperType) {
            case TemporalLocalDate: {
                return new TemporalLocalDateSerializer(temporalClass, property);
            }
            case TemporalLocalTime: {
                return new TemporalLocalTimeSerializer(temporalClass, property);
            }
            case TemporalLocalDateTime: {
                return new TemporalLocalDateTimeSerializer(temporalClass, property);
            }
            case TemporalZonedDateTime: {
                return new TemporalZonedDateTimeSerializer(temporalClass, property);
            }
            case TemporalOffsetDateTime: {
                return new TemporalOffsetDateTimeSerializer(temporalClass, property);
            }
            case TemporalInstant: {
                return new TemporalInstantSerializer(temporalClass, property);
            }
        }
        throw new UnsupportedOperationException();
    }

    protected abstract void checkClass(Class<?> var1);

    @Override
    protected void serialize(Object value, JSONWriter writer, JSONConfig jsonConfig, int indent) throws Exception {
        if (this.useFormatter) {
            this.writeTemporalWithTemplate(value, writer, jsonConfig);
        } else {
            this.writeDefault(value, writer, jsonConfig, indent);
        }
    }

    protected abstract void writeTemporalWithTemplate(Object var1, JSONWriter var2, JSONConfig var3) throws Exception;

    protected void writeDefault(Object value, JSONWriter writer, JSONConfig jsonConfig, int indent) throws Exception {
        String temporal = value.toString();
        CHAR_SEQUENCE_STRING.serialize(temporal, writer, jsonConfig, indent);
    }
}

