/*
 * Decompiled with CFR 0.152.
 */
package io.github.wycst.wast.json;

import io.github.wycst.wast.common.beans.DateTemplate;
import io.github.wycst.wast.common.reflect.ClassStructureWrapper;
import io.github.wycst.wast.common.reflect.GenericParameterizedType;
import io.github.wycst.wast.common.reflect.ReflectConsts;
import io.github.wycst.wast.common.reflect.UnsafeHelper;
import io.github.wycst.wast.common.tools.Base64;
import io.github.wycst.wast.common.utils.EnvUtils;
import io.github.wycst.wast.common.utils.NumberUtils;
import io.github.wycst.wast.common.utils.ObjectUtils;
import io.github.wycst.wast.common.utils.ReflectUtils;
import io.github.wycst.wast.json.CharSource;
import io.github.wycst.wast.json.JSONCharArrayWriter;
import io.github.wycst.wast.json.JSONDefaultParser;
import io.github.wycst.wast.json.JSONGeneral;
import io.github.wycst.wast.json.JSONImplInstCreator;
import io.github.wycst.wast.json.JSONParseContext;
import io.github.wycst.wast.json.JSONPojoDeserializer;
import io.github.wycst.wast.json.JSONPojoStructure;
import io.github.wycst.wast.json.JSONTemporalDeserializer;
import io.github.wycst.wast.json.JSONUnsafe;
import io.github.wycst.wast.json.JSONValueMatcher;
import io.github.wycst.wast.json.annotations.JsonProperty;
import io.github.wycst.wast.json.exceptions.JSONException;
import java.io.Serializable;
import java.lang.reflect.Modifier;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;

public abstract class JSONTypeDeserializer
extends JSONGeneral {
    private static final int LENGTH = ReflectConsts.ClassCategory.values().length;
    static final JSONTypeDeserializer[] TYPE_DESERIALIZERS = new JSONTypeDeserializer[LENGTH];
    private static final CharSequenceDeserializer CHAR_SEQUENCE = new CharSequenceDeserializer();
    protected static final CharSequenceDeserializer.StringDeserializer CHAR_SEQUENCE_STRING;
    protected static final NumberDeserializer NUMBER;
    protected static final NumberDeserializer NUMBER_LONG;
    protected static final NumberDeserializer NUMBER_INTEGER;
    protected static final NumberDeserializer NUMBER_SHORT;
    protected static final NumberDeserializer NUMBER_BYTE;
    protected static final NumberDeserializer NUMBER_FLOAT;
    protected static final NumberDeserializer NUMBER_DOUBLE;
    protected static final NumberDeserializer NUMBER_BIGDECIMAL;
    protected static final NumberDeserializer NUMBER_BIGINTEGER;
    protected static final BinaryDeserializer BINARY;
    static final BooleanDeserializer BOOLEAN;
    static final DateDeserializer DATE;
    protected static final ArrayDeserializer ARRAY;
    protected static final CollectionDeserializer COLLECTION;
    protected static final MapDeserializer MAP;
    protected static final ObjectDeserializer OBJECT;
    protected static final JSONTypeDeserializer ANY;
    protected static final NULLDeserializer NULL;
    protected static final SerializableDeserializer SERIALIZABLE_DESERIALIZER;
    private static final Map<Class<?>, JSONTypeDeserializer> classJSONTypeDeserializerMap;
    private static final Map<String, Class<?>> classNameMapping;
    static final Set<Class<?>> BUILT_IN_TYPE_SET;

    static boolean isBuiltInType(Class<?> type) {
        return BUILT_IN_TYPE_SET.contains(type);
    }

    static void putTypeDeserializer(JSONTypeDeserializer typeDeserializer, Class ... types) {
        for (Class type : types) {
            classJSONTypeDeserializerMap.put(type, typeDeserializer);
        }
    }

    static JSONTypeDeserializer getCachedTypeDeserializer(Class type) {
        return classJSONTypeDeserializerMap.get(type);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static JSONTypeDeserializer getTypeDeserializer(Class type) {
        if (type == null) {
            return ANY;
        }
        JSONTypeDeserializer typeDeserializer = classJSONTypeDeserializerMap.get(type);
        if (typeDeserializer != null) {
            return typeDeserializer;
        }
        ReflectConsts.ClassCategory classCategory = ReflectConsts.getClassCategory(type);
        Class clazz = type;
        synchronized (clazz) {
            if (classJSONTypeDeserializerMap.containsKey(type)) {
                return classJSONTypeDeserializerMap.get(type);
            }
            switch (classCategory) {
                case ObjectCategory: {
                    typeDeserializer = JSONTypeDeserializer.createObjectDeserializer(type);
                    break;
                }
                case EnumCategory: {
                    typeDeserializer = JSONTypeDeserializer.createEnumDeserializer(type);
                    break;
                }
                case MapCategory: {
                    Class[] kvTypes = ReflectUtils.getMapDefinedKVTypes(type);
                    if (kvTypes == null) {
                        typeDeserializer = MAP;
                        break;
                    }
                    typeDeserializer = new CustomMapDeserializer(kvTypes[0], kvTypes[1]);
                    break;
                }
                case NonInstance: {
                    typeDeserializer = new NonInstanceDeserializer(type);
                }
            }
            if (typeDeserializer == null && (typeDeserializer = TYPE_DESERIALIZERS[classCategory.ordinal()]) == null) {
                return null;
            }
            classJSONTypeDeserializerMap.put(type, typeDeserializer);
        }
        return typeDeserializer;
    }

    private static JSONTypeDeserializer createObjectDeserializer(Class type) {
        JSONPojoStructure objectStructureWrapper = JSONPojoStructure.get(type);
        if (objectStructureWrapper.isRecord()) {
            return new JSONPojoDeserializer.JSONRecordDeserializer(objectStructureWrapper);
        }
        if (objectStructureWrapper.isTemporal()) {
            ClassStructureWrapper.ClassWrapperType classWrapperType = objectStructureWrapper.getClassWrapperType();
            return JSONTemporalDeserializer.getTemporalDeserializerInstance(classWrapperType, GenericParameterizedType.actualType(type), null);
        }
        return new JSONPojoDeserializer(objectStructureWrapper);
    }

    private static JSONTypeDeserializer createEnumDeserializer(Class type) {
        Enum[] values = (Enum[])type.getEnumConstants();
        HashMap<String, Enum> enumValues = new HashMap<String, Enum>();
        for (Enum value : values) {
            String name = value.name();
            enumValues.put(name, value);
        }
        JSONValueMatcher<Enum> enumMatcher = JSONValueMatcher.build(enumValues);
        return new EnumDeserializer.EnumInstanceDeserializer(values, enumMatcher);
    }

    protected static JSONTypeDeserializer getFieldDeserializer(GenericParameterizedType genericParameterizedType, JsonProperty property) {
        if (genericParameterizedType == null || genericParameterizedType.getActualType() == null) {
            return ANY;
        }
        ReflectConsts.ClassCategory classCategory = genericParameterizedType.getActualClassCategory();
        switch (classCategory) {
            case CollectionCategory: {
                int collectionType = JSONTypeDeserializer.getCollectionType(genericParameterizedType.getActualType());
                switch (collectionType) {
                    case 1: {
                        return new CollectionDeserializer.ArrayListDeserializer(genericParameterizedType);
                    }
                    case 2: {
                        return new CollectionDeserializer.HashSetDeserializer(genericParameterizedType);
                    }
                }
                return new CollectionDeserializer.CollectionInstanceDeserializer(genericParameterizedType);
            }
            case DateCategory: {
                return property == null ? DATE : new DateDeserializer.DateInstanceDeserializer(genericParameterizedType, property);
            }
            case ObjectCategory: {
                ClassStructureWrapper classStructureWrapper = ClassStructureWrapper.get(genericParameterizedType.getActualType());
                if (!classStructureWrapper.isTemporal()) break;
                ClassStructureWrapper.ClassWrapperType classWrapperType = classStructureWrapper.getClassWrapperType();
                return JSONTemporalDeserializer.getTemporalDeserializerInstance(classWrapperType, genericParameterizedType, property);
            }
        }
        return JSONTypeDeserializer.getTypeDeserializer(genericParameterizedType.getActualType());
    }

    protected static Object doDeserialize(JSONTypeDeserializer deserializer, CharSource charSource, char[] buf, int fromIndex, int toIndex, GenericParameterizedType parameterizedType, Object defaultValue, char endToken, JSONParseContext jsonParseContext) throws Exception {
        return deserializer.deserialize(charSource, buf, fromIndex, toIndex, parameterizedType, defaultValue, endToken, jsonParseContext);
    }

    protected static Object doDeserialize(JSONTypeDeserializer deserializer, CharSource charSource, byte[] buf, int fromIndex, int toIndex, GenericParameterizedType parameterizedType, Object defaultValue, byte endToken, JSONParseContext jsonParseContext) throws Exception {
        return deserializer.deserialize(charSource, buf, fromIndex, toIndex, parameterizedType, defaultValue, endToken, jsonParseContext);
    }

    protected GenericParameterizedType getGenericParameterizedType() {
        return null;
    }

    void skip(CharSource charSource, char[] buf, int fromIndex, int toIndex, char endToken, JSONParseContext jsonParseContext) throws Exception {
        throw new UnsupportedOperationException();
    }

    void skip(CharSource charSource, byte[] buf, int fromIndex, int toIndex, byte endToken, JSONParseContext jsonParseContext) throws Exception {
        throw new UnsupportedOperationException();
    }

    protected abstract Object deserialize(CharSource var1, char[] var2, int var3, int var4, GenericParameterizedType var5, Object var6, char var7, JSONParseContext var8) throws Exception;

    protected abstract Object deserialize(CharSource var1, byte[] var2, int var3, int var4, GenericParameterizedType var5, Object var6, byte var7, JSONParseContext var8) throws Exception;

    protected Object valueOf(String value, Class<?> actualType) throws Exception {
        throw new JSONException("string value \"" + value + "\" is not supported " + actualType);
    }

    protected static final String parseObjectClassName(CharSource charSource, char[] buf, int fromIndex, int toIndex, JSONParseContext jsonParseContext) throws Exception {
        char ch;
        int i = fromIndex + 1;
        while ((ch = buf[i]) <= ' ') {
            ++i;
        }
        if (jsonParseContext.allowComment && ch == '/') {
            i = JSONTypeDeserializer.clearCommentAndWhiteSpaces(buf, i + 1, toIndex, jsonParseContext);
            ch = buf[i];
        }
        boolean matched = false;
        if (ch == '\"') {
            if (buf[++i] == '@' && buf[++i] == 'c' && buf[++i] == '\"') {
                matched = true;
                ++i;
            }
        } else {
            if (ch == '}') {
                return null;
            }
            if (ch == '\'') {
                if (buf[++i] == '@' && buf[++i] == 'c' && buf[++i] == '\'') {
                    matched = true;
                    ++i;
                }
            } else if (jsonParseContext.allowUnquotedFieldNames) {
                char atChar = buf[i++];
                char cChar = buf[i++];
                while ((ch = buf[i]) <= ' ') {
                    ++i;
                }
                if (atChar == '@' && cChar == 'c' && ch == ':') {
                    matched = true;
                }
            }
        }
        if (!matched) {
            return null;
        }
        while ((ch = buf[i]) <= ' ') {
            ++i;
        }
        if (jsonParseContext.allowComment && ch == '/') {
            i = JSONTypeDeserializer.clearCommentAndWhiteSpaces(buf, i + 1, toIndex, jsonParseContext);
            ch = buf[i];
        }
        if (ch == ':') {
            Object value;
            while ((ch = buf[++i]) <= ' ') {
            }
            if (jsonParseContext.allowComment && ch == '/') {
                i = JSONTypeDeserializer.clearCommentAndWhiteSpaces(buf, i + 1, toIndex, jsonParseContext);
                ch = buf[i];
            }
            if ((value = ANY.deserialize(charSource, buf, i, toIndex, null, null, '}', jsonParseContext)) instanceof String) {
                return ((String)value).trim();
            }
            return null;
        }
        String errorContextTextAt = JSONTypeDeserializer.createErrorContextText(buf, i);
        throw new JSONException("Syntax error, at pos " + i + ", context text by '" + errorContextTextAt + "', unexpected '" + ch + "', token ':' is expected.");
    }

    protected static final String parseObjectClassName(CharSource charSource, byte[] buf, int fromIndex, int toIndex, JSONParseContext jsonParseContext) throws Exception {
        byte b;
        int i = fromIndex + 1;
        while ((b = buf[i]) <= 32) {
            ++i;
        }
        if (jsonParseContext.allowComment && b == 47) {
            i = JSONTypeDeserializer.clearCommentAndWhiteSpaces(buf, i + 1, toIndex, jsonParseContext);
            b = buf[i];
        }
        boolean matched = false;
        if (b == 34) {
            if (buf[++i] == 64 && buf[++i] == 99 && buf[++i] == 34) {
                matched = true;
                ++i;
            }
        } else {
            if (b == 125) {
                return null;
            }
            if (b == 39) {
                if (buf[++i] == 64 && buf[++i] == 99 && buf[++i] == 39) {
                    matched = true;
                    ++i;
                }
            } else if (jsonParseContext.allowUnquotedFieldNames) {
                byte atChar = buf[i++];
                byte cChar = buf[i++];
                while ((b = buf[i]) <= 32) {
                    ++i;
                }
                if (atChar == 64 && cChar == 99 && b == 58) {
                    matched = true;
                }
            }
        }
        if (!matched) {
            return null;
        }
        while ((b = buf[i]) <= 32) {
            ++i;
        }
        if (jsonParseContext.allowComment && b == 47) {
            i = JSONTypeDeserializer.clearCommentAndWhiteSpaces(buf, i + 1, toIndex, jsonParseContext);
            b = buf[i];
        }
        if (b == 58) {
            Object value;
            while ((b = buf[++i]) <= 32) {
            }
            if (jsonParseContext.allowComment && b == 47) {
                i = JSONTypeDeserializer.clearCommentAndWhiteSpaces(buf, i + 1, toIndex, jsonParseContext);
                b = buf[i];
            }
            if ((value = ANY.deserialize(charSource, buf, i, toIndex, null, null, (byte)125, jsonParseContext)) instanceof String) {
                return ((String)value).trim();
            }
            return null;
        }
        String errorContextTextAt = JSONTypeDeserializer.createErrorContextText(buf, i);
        throw new JSONException("Syntax error, at pos " + i + ", context text by '" + errorContextTextAt + "', unexpected '" + (char)b + "', token ':' is expected.");
    }

    protected static final Class<?> getClassByName(String className) throws ClassNotFoundException {
        Class<?> cls = classNameMapping.get(className);
        if (cls != null) {
            return cls;
        }
        cls = Class.forName(className);
        classNameMapping.put(className, cls);
        return cls;
    }

    protected static final Object parseNull(byte[] bytes, int fromIndex, int toIndex, JSONParseContext jsonParseContext) {
        int endIndex = fromIndex + 3;
        if (bytes[fromIndex + 1] == 117 && bytes[fromIndex + 2] == 108 && bytes[endIndex] == 108) {
            jsonParseContext.endIndex = endIndex;
            return null;
        }
        throw new JSONException("Syntax error, at pos " + fromIndex + ", expected 'null' because it starts with 'n', but found text '" + new String(bytes, fromIndex, Math.min(toIndex - fromIndex + 1, 4)) + "'");
    }

    protected static final boolean parseTrue(byte[] bytes, int fromIndex, int toIndex, JSONParseContext jsonParseContext) throws Exception {
        int endIndex = fromIndex + 3;
        if (JSONUnsafe.getInt(bytes, fromIndex) == TRUE_INT) {
            jsonParseContext.endIndex = endIndex;
            return true;
        }
        int len = Math.min(toIndex - fromIndex + 1, 4);
        throw new JSONException("Syntax error, at pos " + fromIndex + ", expected 'true' because it starts with 't', but found text '" + new String(bytes, fromIndex, len) + "'");
    }

    protected static final boolean parseFalse(byte[] bytes, int fromIndex, int toIndex, JSONParseContext jsonParseContext) throws Exception {
        int endIndex = fromIndex + 4;
        if (JSONUnsafe.getInt(bytes, fromIndex + 1) == ALSE_INT) {
            jsonParseContext.endIndex = endIndex;
            return false;
        }
        int len = Math.min(toIndex - fromIndex + 1, 5);
        throw new JSONException("Syntax error, at pos " + fromIndex + ", expected 'false' because it starts with 'f', but found text '" + new String(bytes, fromIndex, len) + "'");
    }

    static String parseMapKey(byte[] bytes, int from, int toIndex, char endCh, JSONParseContext jsonParseContext) {
        int beginIndex = from + 1;
        byte next = 0;
        int i = from;
        JSONCharArrayWriter writer = null;
        boolean escape = false;
        while (true) {
            byte b;
            if ((b = bytes[++i]) != 92 && b != endCh) {
                continue;
            }
            if (b != 92) break;
            if (i < toIndex - 1) {
                next = bytes[i + 1];
            }
            if (writer == null) {
                writer = JSONTypeDeserializer.getContextWriter(jsonParseContext);
            }
            escape = true;
            beginIndex = JSONTypeDeserializer.escape(bytes, next, i, beginIndex, writer, jsonParseContext);
            i = jsonParseContext.endIndex;
        }
        jsonParseContext.endIndex = i;
        int len = i - beginIndex;
        if (escape) {
            writer.writeBytes(bytes, beginIndex, len);
            return writer.toString();
        }
        return len == 0 ? "" : new String(bytes, beginIndex, len);
    }

    static String parseMapKeyByCache(byte[] bytes, int from, int toIndex, char endCh, JSONParseContext jsonParseContext) {
        long hashValue;
        byte next = 0;
        int i = from;
        int beginIndex = from + 1;
        JSONCharArrayWriter writer = null;
        if (!jsonParseContext.escape) {
            byte b1;
            byte b;
            long hashValue2 = 92L;
            if ((b = bytes[++i]) != endCh && (b1 = bytes[++i]) != endCh) {
                hashValue2 = hashValue2 << 16 | (long)(b << 8) | (long)b1;
                if ((b = bytes[++i]) != endCh && (b1 = bytes[++i]) != endCh) {
                    hashValue2 = hashValue2 << 16 | (long)(b << 8) | (long)b1;
                    while ((b = bytes[++i]) != endCh && (b1 = bytes[++i]) != endCh) {
                        hashValue2 = hashValue2 << 16 | (long)(b << 8) | (long)b1;
                    }
                }
            }
            if (b != endCh) {
                hashValue2 = hashValue2 << 8 | (long)b;
            }
            jsonParseContext.endIndex = i;
            int len = i - beginIndex;
            if (len <= 8) {
                return JSONTypeDeserializer.getCacheEightBytesKey(bytes, beginIndex, len, hashValue2);
            }
            return JSONTypeDeserializer.getCacheKey(bytes, beginIndex, len, hashValue2);
        }
        boolean escape = false;
        while (true) {
            byte b;
            hashValue = 92L;
            while ((b = bytes[++i]) != 92 && b != endCh) {
                hashValue = hashValue << 8 | (long)b;
            }
            if (b != 92) break;
            if (i < toIndex - 1) {
                next = bytes[i + 1];
            }
            if (writer == null) {
                writer = JSONTypeDeserializer.getContextWriter(jsonParseContext);
            }
            escape = true;
            beginIndex = JSONTypeDeserializer.escape(bytes, next, i, beginIndex, writer, jsonParseContext);
            i = jsonParseContext.endIndex;
        }
        jsonParseContext.endIndex = i;
        int len = i - beginIndex;
        if (escape) {
            writer.writeBytes(bytes, beginIndex, len);
            return writer.toString();
        }
        if (len <= 8) {
            return JSONTypeDeserializer.getCacheEightBytesKey(bytes, beginIndex, len, hashValue);
        }
        return JSONTypeDeserializer.getCacheKey(bytes, beginIndex, len, hashValue);
    }

    static {
        NUMBER = new NumberDeserializer();
        NUMBER_LONG = new NumberDeserializer.LongDeserializer();
        NUMBER_INTEGER = new NumberDeserializer.IntegerDeserializer();
        NUMBER_SHORT = new NumberDeserializer.ShortDeserializer();
        NUMBER_BYTE = new NumberDeserializer.ByteDeserializer();
        NUMBER_FLOAT = new NumberDeserializer.FloatDeserializer();
        NUMBER_DOUBLE = new NumberDeserializer.DoubleDeserializer();
        NUMBER_BIGDECIMAL = new NumberDeserializer.BigDecimalDeserializer();
        NUMBER_BIGINTEGER = new NumberDeserializer.BigIntegerDeserializer();
        BINARY = new BinaryDeserializer();
        BOOLEAN = new BooleanDeserializer();
        DATE = new DateDeserializer();
        ARRAY = new ArrayDeserializer();
        COLLECTION = new CollectionDeserializer();
        MAP = new MapDeserializer();
        OBJECT = new ObjectDeserializer();
        ANY = new ANYDeserializer();
        NULL = new NULLDeserializer();
        SERIALIZABLE_DESERIALIZER = new SerializableDeserializer();
        classJSONTypeDeserializerMap = new ConcurrentHashMap();
        classNameMapping = new ConcurrentHashMap();
        JSONTypeDeserializer.TYPE_DESERIALIZERS[ReflectConsts.ClassCategory.CharSequence.ordinal()] = CHAR_SEQUENCE;
        JSONTypeDeserializer.TYPE_DESERIALIZERS[ReflectConsts.ClassCategory.NumberCategory.ordinal()] = NUMBER;
        JSONTypeDeserializer.TYPE_DESERIALIZERS[ReflectConsts.ClassCategory.BoolCategory.ordinal()] = BOOLEAN;
        JSONTypeDeserializer.TYPE_DESERIALIZERS[ReflectConsts.ClassCategory.DateCategory.ordinal()] = DATE;
        JSONTypeDeserializer.TYPE_DESERIALIZERS[ReflectConsts.ClassCategory.ClassCategory.ordinal()] = new ClassDeserializer();
        JSONTypeDeserializer.TYPE_DESERIALIZERS[ReflectConsts.ClassCategory.EnumCategory.ordinal()] = new EnumDeserializer();
        JSONTypeDeserializer.TYPE_DESERIALIZERS[ReflectConsts.ClassCategory.AnnotationCategory.ordinal()] = new AnnotationDeserializer();
        JSONTypeDeserializer.TYPE_DESERIALIZERS[ReflectConsts.ClassCategory.Binary.ordinal()] = BINARY;
        JSONTypeDeserializer.TYPE_DESERIALIZERS[ReflectConsts.ClassCategory.ArrayCategory.ordinal()] = ARRAY;
        JSONTypeDeserializer.TYPE_DESERIALIZERS[ReflectConsts.ClassCategory.CollectionCategory.ordinal()] = COLLECTION;
        JSONTypeDeserializer.TYPE_DESERIALIZERS[ReflectConsts.ClassCategory.MapCategory.ordinal()] = MAP;
        JSONTypeDeserializer.TYPE_DESERIALIZERS[ReflectConsts.ClassCategory.ObjectCategory.ordinal()] = OBJECT;
        JSONTypeDeserializer.TYPE_DESERIALIZERS[ReflectConsts.ClassCategory.ANY.ordinal()] = ANY;
        JSONTypeDeserializer.TYPE_DESERIALIZERS[ReflectConsts.ClassCategory.NonInstance.ordinal()] = null;
        JSONTypeDeserializer.putTypeDeserializer(NUMBER_LONG, Long.TYPE, Long.class);
        JSONTypeDeserializer.putTypeDeserializer(NUMBER_INTEGER, Integer.TYPE, Integer.class);
        JSONTypeDeserializer.putTypeDeserializer(NUMBER_DOUBLE, Double.TYPE, Double.class);
        JSONTypeDeserializer.putTypeDeserializer(NUMBER_FLOAT, Float.TYPE, Float.class);
        JSONTypeDeserializer.putTypeDeserializer(NUMBER_SHORT, Short.TYPE, Short.class);
        JSONTypeDeserializer.putTypeDeserializer(NUMBER_BYTE, Byte.TYPE, Byte.class);
        JSONTypeDeserializer.putTypeDeserializer(NUMBER_BIGDECIMAL, BigDecimal.class);
        JSONTypeDeserializer.putTypeDeserializer(NUMBER_BIGINTEGER, BigInteger.class);
        JSONTypeDeserializer.putTypeDeserializer(new ArrayDeserializer.StringArrayDeserializer(), String[].class);
        JSONTypeDeserializer.putTypeDeserializer(new ArrayDeserializer.DoubleArrayDeserializer(), Double[].class);
        JSONTypeDeserializer.putTypeDeserializer(new ArrayDeserializer.PrimitiveDoubleArrayDeserializer(), double[].class);
        JSONTypeDeserializer.putTypeDeserializer(new ArrayDeserializer.FloatArrayDeserializer(), Float[].class);
        JSONTypeDeserializer.putTypeDeserializer(new ArrayDeserializer.PrimitiveFloatArrayDeserializer(), float[].class);
        JSONTypeDeserializer.putTypeDeserializer(new ArrayDeserializer.LongArrayDeserializer(), Long[].class);
        JSONTypeDeserializer.putTypeDeserializer(new ArrayDeserializer.PrimitiveLongArrayDeserializer(), long[].class);
        JSONTypeDeserializer.putTypeDeserializer(new ArrayDeserializer.IntArrayDeserializer(), Integer[].class);
        JSONTypeDeserializer.putTypeDeserializer(new ArrayDeserializer.PrimitiveIntArrayDeserializer(), int[].class);
        JSONTypeDeserializer.putTypeDeserializer(new ArrayDeserializer.ByteArrayDeserializer(), Byte[].class);
        JSONTypeDeserializer.putTypeDeserializer(BINARY, byte[].class);
        CharSequenceDeserializer.StringDeserializer defaultStringDeserializer = new CharSequenceDeserializer.StringDeserializer();
        if (EnvUtils.JDK_9_PLUS) {
            defaultStringDeserializer = EnvUtils.JDK_16_PLUS ? new CharSequenceDeserializer.StringJDK16PlusDeserializer() : new CharSequenceDeserializer.StringJDK9PlusDeserializer();
        }
        CHAR_SEQUENCE_STRING = defaultStringDeserializer;
        JSONTypeDeserializer.putTypeDeserializer(CHAR_SEQUENCE_STRING, String.class);
        JSONTypeDeserializer.putTypeDeserializer(SERIALIZABLE_DESERIALIZER, Serializable.class);
        JSONTypeDeserializer.putTypeDeserializer(new CharSequenceDeserializer.CharDeserializer(), Character.TYPE, Character.class);
        JSONTypeDeserializer.putTypeDeserializer(new UUIDDeserializer(), UUID.class);
        JSONTypeDeserializer.putTypeDeserializer(MapDeserializer.hashtable(), Dictionary.class);
        BUILT_IN_TYPE_SET = new HashSet(classJSONTypeDeserializerMap.keySet());
    }

    private static class UUIDDeserializer
    extends JSONTypeDeserializer {
        private UUIDDeserializer() {
        }

        @Override
        protected Object valueOf(String value, Class<?> actualType) {
            return UUID.fromString(value);
        }

        /*
         * Unable to fully structure code
         */
        @Override
        protected Object deserialize(CharSource charSource, char[] buf, int fromIndex, int toIndex, GenericParameterizedType parameterizedType, Object defaultValue, char endToken, JSONParseContext jsonParseContext) throws Exception {
            block6: {
                beginChar = buf[fromIndex];
                offset = fromIndex + 1;
                if (beginChar != '\"' && beginChar != '\'') break block6;
                next = buf[offset];
                if (next == beginChar) {
                    jsonParseContext.endIndex = offset;
                    return null;
                }
                try {
                    h1 = UUIDDeserializer.hex(next);
                    h2 = UUIDDeserializer.hex(buf[++offset]);
                    h3 = UUIDDeserializer.hex(buf[++offset]);
                    h4 = UUIDDeserializer.hex(buf[++offset]);
                    h5 = UUIDDeserializer.hex(buf[++offset]);
                    h6 = UUIDDeserializer.hex(buf[++offset]);
                    h7 = UUIDDeserializer.hex(buf[++offset]);
                    h8 = UUIDDeserializer.hex(buf[++offset]);
                    h9 = buf[++offset];
                    h10 = UUIDDeserializer.hex(buf[++offset]);
                    h11 = UUIDDeserializer.hex(buf[++offset]);
                    h12 = UUIDDeserializer.hex(buf[++offset]);
                    h13 = UUIDDeserializer.hex(buf[++offset]);
                    h14 = buf[++offset];
                    h15 = UUIDDeserializer.hex(buf[++offset]);
                    h16 = UUIDDeserializer.hex(buf[++offset]);
                    h17 = UUIDDeserializer.hex(buf[++offset]);
                    h18 = UUIDDeserializer.hex(buf[++offset]);
                    h19 = buf[++offset];
                    h20 = UUIDDeserializer.hex(buf[++offset]);
                    h21 = UUIDDeserializer.hex(buf[++offset]);
                    h22 = UUIDDeserializer.hex(buf[++offset]);
                    h23 = UUIDDeserializer.hex(buf[++offset]);
                    h24 = buf[++offset];
                    h25 = UUIDDeserializer.hex(buf[++offset]);
                    h26 = UUIDDeserializer.hex(buf[++offset]);
                    h27 = UUIDDeserializer.hex(buf[++offset]);
                    h28 = UUIDDeserializer.hex(buf[++offset]);
                    h29 = UUIDDeserializer.hex(buf[++offset]);
                    h30 = UUIDDeserializer.hex(buf[++offset]);
                    h31 = UUIDDeserializer.hex(buf[++offset]);
                    h32 = UUIDDeserializer.hex(buf[++offset]);
                    h33 = UUIDDeserializer.hex(buf[++offset]);
                    h34 = UUIDDeserializer.hex(buf[++offset]);
                    h35 = UUIDDeserializer.hex(buf[++offset]);
                    h36 = UUIDDeserializer.hex(buf[++offset]);
                    mostSigBits = h1 << 60 | h2 << 56 | h3 << 52 | h4 << 48 | h5 << 44 | h6 << 40 | h7 << 36 | h8 << 32 | h10 << 28 | h11 << 24 | h12 << 20 | h13 << 16 | h15 << 12 | h16 << 8 | h17 << 4 | h18;
                    leastSigBits = h20 << 60 | h21 << 56 | h22 << 52 | h23 << 48 | h25 << 44 | h26 << 40 | h27 << 36 | h28 << 32 | h29 << 28 | h30 << 24 | h31 << 20 | h32 << 16 | h33 << 12 | h34 << 8 | h35 << 4 | h36;
                    if (h9 != 45L) break block7;
                    if (h14 != 45L) break block8;
                    if (h19 != 45L) break block9;
                    if (h24 != 45L) break block10;
                    if (buf[++offset] == beginChar) {
                        jsonParseContext.endIndex = offset;
                        return new UUID(mostSigBits, leastSigBits);
                    }
                    ** break block11
                }
                finally {
                    errorContextTextAt = UUIDDeserializer.createErrorContextText(buf, fromIndex);
                    throw new JSONException("Syntax error, at pos " + fromIndex + ", context text by '" + errorContextTextAt + "', deserialize UUID fail");
                }
            }
            if (beginChar == 'n') {
                return UUIDDeserializer.NULL.deserialize(charSource, buf, fromIndex, toIndex, null, null, jsonParseContext);
            }
lbl-1000:
            // 1 sources

            {
                block7: {
                    block8: {
                        block9: {
                            block10: {
                            }
                        }
                    }
                }
            }
        }

        /*
         * Unable to fully structure code
         */
        @Override
        protected Object deserialize(CharSource charSource, byte[] bytes, int fromIndex, int toIndex, GenericParameterizedType parameterizedType, Object defaultValue, byte endToken, JSONParseContext jsonParseContext) throws Exception {
            block6: {
                beginByte = bytes[fromIndex];
                offset = fromIndex + 1;
                if (beginByte != 34 && beginByte != 39) break block6;
                next = bytes[offset];
                if (next == beginByte) {
                    jsonParseContext.endIndex = offset;
                    return null;
                }
                try {
                    h1 = UUIDDeserializer.hex(next);
                    h2 = UUIDDeserializer.hex(bytes[++offset]);
                    h3 = UUIDDeserializer.hex(bytes[++offset]);
                    h4 = UUIDDeserializer.hex(bytes[++offset]);
                    h5 = UUIDDeserializer.hex(bytes[++offset]);
                    h6 = UUIDDeserializer.hex(bytes[++offset]);
                    h7 = UUIDDeserializer.hex(bytes[++offset]);
                    h8 = UUIDDeserializer.hex(bytes[++offset]);
                    h9 = bytes[++offset];
                    h10 = UUIDDeserializer.hex(bytes[++offset]);
                    h11 = UUIDDeserializer.hex(bytes[++offset]);
                    h12 = UUIDDeserializer.hex(bytes[++offset]);
                    h13 = UUIDDeserializer.hex(bytes[++offset]);
                    h14 = bytes[++offset];
                    h15 = UUIDDeserializer.hex(bytes[++offset]);
                    h16 = UUIDDeserializer.hex(bytes[++offset]);
                    h17 = UUIDDeserializer.hex(bytes[++offset]);
                    h18 = UUIDDeserializer.hex(bytes[++offset]);
                    h19 = bytes[++offset];
                    h20 = UUIDDeserializer.hex(bytes[++offset]);
                    h21 = UUIDDeserializer.hex(bytes[++offset]);
                    h22 = UUIDDeserializer.hex(bytes[++offset]);
                    h23 = UUIDDeserializer.hex(bytes[++offset]);
                    h24 = bytes[++offset];
                    h25 = UUIDDeserializer.hex(bytes[++offset]);
                    h26 = UUIDDeserializer.hex(bytes[++offset]);
                    h27 = UUIDDeserializer.hex(bytes[++offset]);
                    h28 = UUIDDeserializer.hex(bytes[++offset]);
                    h29 = UUIDDeserializer.hex(bytes[++offset]);
                    h30 = UUIDDeserializer.hex(bytes[++offset]);
                    h31 = UUIDDeserializer.hex(bytes[++offset]);
                    h32 = UUIDDeserializer.hex(bytes[++offset]);
                    h33 = UUIDDeserializer.hex(bytes[++offset]);
                    h34 = UUIDDeserializer.hex(bytes[++offset]);
                    h35 = UUIDDeserializer.hex(bytes[++offset]);
                    h36 = UUIDDeserializer.hex(bytes[++offset]);
                    mostSigBits = h1 << 60 | h2 << 56 | h3 << 52 | h4 << 48 | h5 << 44 | h6 << 40 | h7 << 36 | h8 << 32 | h10 << 28 | h11 << 24 | h12 << 20 | h13 << 16 | h15 << 12 | h16 << 8 | h17 << 4 | h18;
                    leastSigBits = h20 << 60 | h21 << 56 | h22 << 52 | h23 << 48 | h25 << 44 | h26 << 40 | h27 << 36 | h28 << 32 | h29 << 28 | h30 << 24 | h31 << 20 | h32 << 16 | h33 << 12 | h34 << 8 | h35 << 4 | h36;
                    if (h9 != 45L) break block7;
                    if (h14 != 45L) break block8;
                    if (h19 != 45L) break block9;
                    if (h24 != 45L) break block10;
                    if (bytes[++offset] == beginByte) {
                        jsonParseContext.endIndex = offset;
                        return new UUID(mostSigBits, leastSigBits);
                    }
                    ** break block11
                }
                finally {
                    errorContextTextAt = UUIDDeserializer.createErrorContextText(bytes, fromIndex);
                    throw new JSONException("Syntax error, at pos " + fromIndex + ", context text by '" + errorContextTextAt + "', deserialize UUID fail");
                }
            }
            if (beginByte == 110) {
                return UUIDDeserializer.NULL.deserialize(charSource, bytes, fromIndex, toIndex, null, null, jsonParseContext);
            }
lbl-1000:
            // 1 sources

            {
                block7: {
                    block8: {
                        block9: {
                            block10: {
                            }
                        }
                    }
                }
            }
        }
    }

    static class NonInstanceDeserializer
    extends JSONTypeDeserializer {
        final Class<?> baseClass;

        NonInstanceDeserializer(Class<?> baseClass) {
            this.baseClass = baseClass;
        }

        boolean isAvailableImpl(Class<?> cls) {
            return this.baseClass.isAssignableFrom(cls) && ReflectConsts.getClassCategory(cls) == ReflectConsts.ClassCategory.ObjectCategory;
        }

        JSONTypeDeserializer getJSONTypeDeserializer(String className) {
            if (className != null) {
                try {
                    Class<?> cls = NonInstanceDeserializer.getClassByName(className);
                    if (this.isAvailableImpl(cls)) {
                        return NonInstanceDeserializer.getTypeDeserializer(cls);
                    }
                }
                catch (Throwable throwable) {
                    throw throwable instanceof RuntimeException ? (RuntimeException)throwable : new JSONException(throwable.getMessage(), throwable);
                }
            }
            return null;
        }

        @Override
        protected Object deserialize(CharSource charSource, char[] buf, int fromIndex, int toIndex, GenericParameterizedType parameterizedType, Object defaultValue, char endToken, JSONParseContext jsonParseContext) throws Exception {
            char ch;
            String className = NonInstanceDeserializer.parseObjectClassName(charSource, buf, fromIndex, toIndex, jsonParseContext);
            JSONPojoDeserializer deserializer = (JSONPojoDeserializer)this.getJSONTypeDeserializer(className);
            if (deserializer == null) {
                ANY.skip(charSource, buf, fromIndex, toIndex, endToken, jsonParseContext);
                return null;
            }
            int i = jsonParseContext.endIndex;
            while ((ch = buf[++i]) <= ' ') {
            }
            if (ch == ',') {
                return deserializer.deserializePojo(charSource, buf, i, toIndex, parameterizedType, defaultValue, endToken, jsonParseContext);
            }
            if (ch == '}') {
                jsonParseContext.endIndex = i;
                return deserializer.pojo(deserializer.createPojo());
            }
            String errorContextTextAt = NonInstanceDeserializer.createErrorContextText(buf, i);
            throw new JSONException("Syntax error, at pos " + i + ", context text by '" + errorContextTextAt + "', unexpected '" + ch + "', expected ',' or '}'");
        }

        @Override
        protected Object deserialize(CharSource charSource, byte[] bytes, int fromIndex, int toIndex, GenericParameterizedType parameterizedType, Object defaultValue, byte endToken, JSONParseContext jsonParseContext) throws Exception {
            byte b;
            String className = NonInstanceDeserializer.parseObjectClassName(charSource, bytes, fromIndex, toIndex, jsonParseContext);
            JSONPojoDeserializer deserializer = (JSONPojoDeserializer)this.getJSONTypeDeserializer(className);
            if (deserializer == null) {
                ANY.skip(charSource, bytes, fromIndex, toIndex, endToken, jsonParseContext);
                return null;
            }
            int i = jsonParseContext.endIndex;
            while ((b = bytes[++i]) <= 32) {
            }
            if (b == 44) {
                return deserializer.deserializePojo(charSource, bytes, i, toIndex, parameterizedType, defaultValue, endToken, jsonParseContext);
            }
            if (b == 125) {
                jsonParseContext.endIndex = i;
                return deserializer.pojo(deserializer.createPojo());
            }
            String errorContextTextAt = NonInstanceDeserializer.createErrorContextText(bytes, i);
            throw new JSONException("Syntax error, at pos " + i + ", context text by '" + errorContextTextAt + "', unexpected '" + (char)b + "', expected ',' or '}'");
        }
    }

    static class SerializableDeserializer
    extends JSONTypeDeserializer {
        SerializableDeserializer() {
        }

        @Override
        protected Object deserialize(CharSource charSource, char[] buf, int fromIndex, int toIndex, GenericParameterizedType parameterizedType, Object defaultValue, char endToken, JSONParseContext jsonParseContext) throws Exception {
            Object value = ANY.deserialize(charSource, buf, fromIndex, toIndex, parameterizedType, defaultValue, endToken, jsonParseContext);
            if (value instanceof Serializable) {
                return value;
            }
            return null;
        }

        @Override
        protected Object deserialize(CharSource charSource, byte[] buf, int fromIndex, int toIndex, GenericParameterizedType parameterizedType, Object defaultValue, byte endToken, JSONParseContext jsonParseContext) throws Exception {
            Object value = ANY.deserialize(charSource, buf, fromIndex, toIndex, parameterizedType, defaultValue, endToken, jsonParseContext);
            if (value instanceof Serializable) {
                return value;
            }
            return null;
        }
    }

    static class NULLDeserializer
    extends JSONTypeDeserializer {
        NULLDeserializer() {
        }

        Object deserialize(CharSource charSource, char[] buf, int fromIndex, int toIndex, GenericParameterizedType parameterizedType, Object instance, JSONParseContext jsonParseContext) throws Exception {
            return this.deserialize(charSource, buf, fromIndex, toIndex, parameterizedType, instance, '\u0000', jsonParseContext);
        }

        Object deserialize(CharSource charSource, byte[] buf, int fromIndex, int toIndex, GenericParameterizedType parameterizedType, Object instance, JSONParseContext jsonParseContext) throws Exception {
            return this.deserialize(charSource, buf, fromIndex, toIndex, parameterizedType, instance, (byte)0, jsonParseContext);
        }

        @Override
        protected Object deserialize(CharSource charSource, char[] buf, int fromIndex, int toIndex, GenericParameterizedType parameterizedType, Object instance, char endToken, JSONParseContext jsonParseContext) throws Exception {
            int endIndex = fromIndex + 3;
            if (buf[fromIndex + 1] == 'u' && buf[fromIndex + 2] == 'l' && buf[endIndex] == 'l') {
                jsonParseContext.endIndex = endIndex;
                return null;
            }
            throw new JSONException("Syntax error, at pos " + fromIndex + ", expected 'null' because it starts with 'n', but found text '" + new String(buf, fromIndex, Math.min(toIndex - fromIndex + 1, 4)) + "'");
        }

        @Override
        protected Object deserialize(CharSource charSource, byte[] buf, int fromIndex, int toIndex, GenericParameterizedType parameterizedType, Object instance, byte endToken, JSONParseContext jsonParseContext) throws Exception {
            int endIndex = fromIndex + 3;
            if (buf[fromIndex + 1] == 117 && buf[fromIndex + 2] == 108 && buf[endIndex] == 108) {
                jsonParseContext.endIndex = endIndex;
                return null;
            }
            throw new JSONException("Syntax error, at pos " + fromIndex + ", expected 'null' because it starts with 'n', but found text '" + new String(buf, fromIndex, Math.min(toIndex - fromIndex + 1, 4)) + "'");
        }
    }

    static class ANYDeserializer
    extends JSONTypeDeserializer {
        ANYDeserializer() {
        }

        @Override
        protected Object valueOf(String value, Class<?> actualType) {
            return value;
        }

        @Override
        void skip(CharSource charSource, char[] buf, int fromIndex, int toIndex, char endToken, JSONParseContext jsonParseContext) throws Exception {
            char beginChar = buf[fromIndex];
            switch (beginChar) {
                case '{': {
                    MAP.skip(charSource, buf, fromIndex, toIndex, jsonParseContext);
                    break;
                }
                case '[': {
                    COLLECTION.skip(charSource, buf, fromIndex, toIndex, jsonParseContext);
                    break;
                }
                case '\"': 
                case '\'': {
                    CHAR_SEQUENCE.skip(charSource, buf, fromIndex, beginChar, jsonParseContext);
                    break;
                }
                case 'n': {
                    NULL.deserialize(null, buf, fromIndex, toIndex, null, null, jsonParseContext);
                    break;
                }
                case 't': {
                    BOOLEAN.deserializeTrue(buf, fromIndex, toIndex, null, jsonParseContext);
                    break;
                }
                case 'f': {
                    BOOLEAN.deserializeFalse(buf, fromIndex, toIndex, null, jsonParseContext);
                    break;
                }
                default: {
                    NUMBER.deserialize(charSource, buf, fromIndex, toIndex, GenericParameterizedType.AnyType, null, endToken, jsonParseContext);
                }
            }
        }

        @Override
        void skip(CharSource charSource, byte[] buf, int fromIndex, int toIndex, byte endToken, JSONParseContext jsonParseContext) throws Exception {
            byte beginByte = buf[fromIndex];
            switch (beginByte) {
                case 123: {
                    MAP.skip(charSource, buf, fromIndex, toIndex, jsonParseContext);
                    break;
                }
                case 91: {
                    COLLECTION.skip(charSource, buf, fromIndex, toIndex, jsonParseContext);
                    break;
                }
                case 34: 
                case 39: {
                    CHAR_SEQUENCE.skip(charSource, buf, fromIndex, beginByte, jsonParseContext);
                    break;
                }
                case 110: {
                    ANYDeserializer.parseNull(buf, fromIndex, toIndex, jsonParseContext);
                    break;
                }
                case 116: {
                    ANYDeserializer.parseTrue(buf, fromIndex, toIndex, jsonParseContext);
                    break;
                }
                case 102: {
                    ANYDeserializer.parseFalse(buf, fromIndex, toIndex, jsonParseContext);
                    break;
                }
                default: {
                    NUMBER.deserialize(null, buf, fromIndex, toIndex, GenericParameterizedType.AnyType, null, endToken, jsonParseContext);
                }
            }
        }

        @Override
        protected Object deserialize(CharSource charSource, char[] buf, int fromIndex, int toIndex, GenericParameterizedType parameterizedType, Object instance, char endToken, JSONParseContext jsonParseContext) throws Exception {
            char beginChar = buf[fromIndex];
            switch (beginChar) {
                case '{': {
                    return JSONDefaultParser.parseJSONObject(charSource, buf, fromIndex, toIndex, new LinkedHashMap(), jsonParseContext);
                }
                case '[': {
                    return JSONDefaultParser.parseJSONArray(charSource, buf, fromIndex, toIndex, new ArrayList(), jsonParseContext);
                }
                case '\"': 
                case '\'': {
                    return CHAR_SEQUENCE_STRING.deserializeString(charSource, buf, fromIndex, toIndex, beginChar, GenericParameterizedType.StringType, jsonParseContext);
                }
                case 'n': {
                    return NULL.deserialize(charSource, buf, fromIndex, toIndex, null, null, jsonParseContext);
                }
                case 't': {
                    return BOOLEAN.deserializeTrue(buf, fromIndex, toIndex, null, jsonParseContext);
                }
                case 'f': {
                    return BOOLEAN.deserializeFalse(buf, fromIndex, toIndex, null, jsonParseContext);
                }
            }
            return NUMBER.deserialize(charSource, buf, fromIndex, toIndex, jsonParseContext.useBigDecimalAsDefault ? GenericParameterizedType.BigDecimalType : GenericParameterizedType.AnyType, null, endToken, jsonParseContext);
        }

        @Override
        protected Object deserialize(CharSource charSource, byte[] buf, int fromIndex, int toIndex, GenericParameterizedType parameterizedType, Object instance, byte endToken, JSONParseContext jsonParseContext) throws Exception {
            byte beginByte = buf[fromIndex];
            char beginChar = (char)beginByte;
            switch (beginChar) {
                case '{': {
                    return JSONDefaultParser.parseJSONObject(charSource, buf, fromIndex, toIndex, new LinkedHashMap(), jsonParseContext);
                }
                case '[': {
                    return JSONDefaultParser.parseJSONArray(charSource, buf, fromIndex, toIndex, new ArrayList(), jsonParseContext);
                }
                case '\"': 
                case '\'': {
                    return CHAR_SEQUENCE_STRING.deserializeString(charSource, buf, fromIndex, toIndex, beginByte, GenericParameterizedType.StringType, jsonParseContext);
                }
                case 'n': {
                    return ANYDeserializer.parseNull(buf, fromIndex, toIndex, jsonParseContext);
                }
                case 't': {
                    return ANYDeserializer.parseTrue(buf, fromIndex, toIndex, jsonParseContext);
                }
                case 'f': {
                    return ANYDeserializer.parseFalse(buf, fromIndex, toIndex, jsonParseContext);
                }
            }
            return NUMBER.deserialize(null, buf, fromIndex, toIndex, GenericParameterizedType.AnyType, null, endToken, jsonParseContext);
        }
    }

    static class ObjectDeserializer
    extends JSONTypeDeserializer {
        ObjectDeserializer() {
        }

        Object deserializeObject(CharSource charSource, char[] buf, int fromIndex, int toIndex, GenericParameterizedType genericParameterizedType, Object instance, JSONParseContext jsonParseContext) throws Exception {
            Class<?> clazz = genericParameterizedType.getActualType();
            JSONPojoDeserializer pojoDeserializer = (JSONPojoDeserializer)JSONTypeDeserializer.createObjectDeserializer(clazz);
            return pojoDeserializer.deserializePojo(charSource, buf, fromIndex, toIndex, genericParameterizedType, instance, '}', jsonParseContext);
        }

        Object deserializeObject(CharSource charSource, byte[] buf, int fromIndex, int toIndex, GenericParameterizedType genericParameterizedType, Object instance, JSONParseContext jsonParseContext) throws Exception {
            Class<?> clazz = genericParameterizedType.getActualType();
            JSONPojoDeserializer pojoDeserializer = (JSONPojoDeserializer)JSONTypeDeserializer.createObjectDeserializer(clazz);
            return pojoDeserializer.deserializePojo(charSource, buf, fromIndex, toIndex, genericParameterizedType, instance, (byte)125, jsonParseContext);
        }

        @Override
        protected Object deserialize(CharSource charSource, char[] buf, int fromIndex, int toIndex, GenericParameterizedType genericParameterizedType, Object instance, char endToken, JSONParseContext jsonParseContext) throws Exception {
            char beginChar = buf[fromIndex];
            switch (beginChar) {
                case '{': {
                    return this.deserializeObject(charSource, buf, fromIndex, toIndex, genericParameterizedType, instance, jsonParseContext);
                }
                case 'n': {
                    return NULL.deserialize(charSource, buf, fromIndex, toIndex, null, null, jsonParseContext);
                }
            }
            if (jsonParseContext.unMatchedEmptyAsNull && beginChar == '\"' && buf[fromIndex + 1] == '\"') {
                jsonParseContext.endIndex = fromIndex + 1;
                return null;
            }
            String errorContextTextAt = ObjectDeserializer.createErrorContextText(buf, fromIndex);
            throw new JSONException("Syntax error, at pos " + fromIndex + ", context text by '" + errorContextTextAt + "', unexpected '" + beginChar + "' for Object Type, expected '{' ");
        }

        @Override
        protected Object deserialize(CharSource charSource, byte[] buf, int fromIndex, int toIndex, GenericParameterizedType genericParameterizedType, Object instance, byte endToken, JSONParseContext jsonParseContext) throws Exception {
            byte beginByte = buf[fromIndex];
            char beginChar = (char)beginByte;
            switch (beginChar) {
                case '{': {
                    return this.deserializeObject(charSource, buf, fromIndex, toIndex, genericParameterizedType, instance, jsonParseContext);
                }
                case 'n': {
                    return ObjectDeserializer.parseNull(buf, fromIndex, toIndex, jsonParseContext);
                }
            }
            if (jsonParseContext.unMatchedEmptyAsNull && beginChar == '\"' && buf[fromIndex + 1] == 34) {
                jsonParseContext.endIndex = fromIndex + 1;
                return null;
            }
            String errorContextTextAt = ObjectDeserializer.createErrorContextText(buf, fromIndex);
            throw new JSONException("Syntax error, at pos " + fromIndex + ", context text by '" + errorContextTextAt + "', unexpected '" + beginChar + "' for Object Type, expected '{' ");
        }
    }

    static class CustomMapDeserializer
    extends MapDeserializer {
        final GenericParameterizedType valueParameterizedType;
        JSONTypeDeserializer valueDeserializer;

        @Override
        GenericParameterizedType getValueType(GenericParameterizedType parameterizedType) {
            return this.valueParameterizedType;
        }

        @Override
        protected JSONTypeDeserializer getValueDeserializer(GenericParameterizedType valueGenType) {
            if (this.valueDeserializer == null) {
                this.valueDeserializer = JSONTypeDeserializer.getTypeDeserializer(this.valueParameterizedType.getActualType());
            }
            return this.valueDeserializer;
        }

        public CustomMapDeserializer(Class<?> keyClass, Class<?> valueClass) {
            this.valueParameterizedType = GenericParameterizedType.actualType(valueClass);
        }
    }

    static class MapDeserializer
    extends JSONTypeDeserializer {
        MapDeserializer() {
        }

        public static JSONTypeDeserializer hashtable() {
            return new MapDeserializer(){

                @Override
                Map createMap(GenericParameterizedType parameterizedType) {
                    return new Hashtable();
                }
            };
        }

        /*
         * Enabled aggressive block sorting
         */
        void skip(CharSource charSource, char[] buf, int fromIndex, int toIndex, JSONParseContext jsonParseContext) throws Exception {
            char ch;
            boolean empty = true;
            int i = fromIndex + 1;
            while (true) {
                if (i >= toIndex) {
                    throw new JSONException("Syntax error, the closing symbol '}' is not found ");
                }
                while ((ch = buf[i]) <= ' ') {
                    ++i;
                }
                if (jsonParseContext.allowComment && ch == '/') {
                    i = MapDeserializer.clearCommentAndWhiteSpaces(buf, i + 1, toIndex, jsonParseContext);
                    ch = buf[i];
                }
                if (ch == '\"') {
                    CHAR_SEQUENCE.skip(charSource, buf, i, '\"', jsonParseContext);
                    i = jsonParseContext.endIndex;
                    ch = buf[i];
                    empty = false;
                    if (ch != '\"') {
                        String errorContextTextAt = MapDeserializer.createErrorContextText(buf, i);
                        throw new JSONException("Syntax error, util pos " + i + ", context text by '" + errorContextTextAt + "' the closing symbol '\"' is not found ");
                    }
                    ++i;
                } else {
                    if (ch == '}') {
                        if (!empty && !jsonParseContext.allowLastEndComma) {
                            String errorContextTextAt = MapDeserializer.createErrorContextText(buf, i);
                            throw new JSONException("Syntax error, at pos " + i + ", context text by '" + errorContextTextAt + "' the closing symbol '}' is not allowed here.");
                        }
                        jsonParseContext.endIndex = i;
                        return;
                    }
                    if (ch == '\'') {
                        if (!jsonParseContext.allowSingleQuotes) {
                            String errorContextTextAt = MapDeserializer.createErrorContextText(buf, i);
                            throw new JSONException("Syntax error, at pos " + i + ", context text by '" + errorContextTextAt + "' the single quote symbol ' is not allowed here.");
                        }
                        CHAR_SEQUENCE.skip(charSource, buf, i, '\'', jsonParseContext);
                        i = jsonParseContext.endIndex + 1;
                        empty = false;
                    } else if (jsonParseContext.allowUnquotedFieldNames) {
                        while (i + 1 < toIndex && buf[++i] != ':') {
                        }
                        empty = false;
                    }
                }
                while ((ch = buf[i]) <= ' ') {
                    ++i;
                }
                if (jsonParseContext.allowComment && ch == '/') {
                    i = MapDeserializer.clearCommentAndWhiteSpaces(buf, i + 1, toIndex, jsonParseContext);
                    ch = buf[i];
                }
                if (ch != ':') {
                    String errorContextTextAt = MapDeserializer.createErrorContextText(buf, i);
                    throw new JSONException("Syntax error, at pos " + i + ", context text by '" + errorContextTextAt + "', unexpected '" + ch + "', token ':' is expected.");
                }
                while ((ch = buf[++i]) <= ' ') {
                }
                if (jsonParseContext.allowComment && ch == '/') {
                    i = MapDeserializer.clearCommentAndWhiteSpaces(buf, i + 1, toIndex, jsonParseContext);
                }
                ANY.skip(charSource, buf, i, toIndex, '}', jsonParseContext);
                i = jsonParseContext.endIndex;
                while ((ch = buf[++i]) <= ' ') {
                }
                if (jsonParseContext.allowComment && ch == '/') {
                    i = MapDeserializer.clearCommentAndWhiteSpaces(buf, i + 1, toIndex, jsonParseContext);
                    ch = buf[i];
                }
                if (ch != ',') break;
                ++i;
            }
            if (ch == '}') {
                jsonParseContext.endIndex = i;
                return;
            }
            String errorContextTextAt = MapDeserializer.createErrorContextText(buf, i);
            throw new JSONException("Syntax error, at pos " + i + ", context text by '" + errorContextTextAt + "', unexpected '" + ch + "', expected ',' or '}'");
        }

        /*
         * Enabled aggressive block sorting
         */
        void skip(CharSource charSource, byte[] buf, int fromIndex, int toIndex, JSONParseContext jsonParseContext) throws Exception {
            byte b;
            boolean empty = true;
            int i = fromIndex + 1;
            while (true) {
                if (i >= toIndex) {
                    throw new JSONException("Syntax error, the closing symbol '}' is not found ");
                }
                while ((b = buf[i]) <= 32) {
                    ++i;
                }
                if (jsonParseContext.allowComment && b == 47) {
                    i = MapDeserializer.clearCommentAndWhiteSpaces(buf, i + 1, toIndex, jsonParseContext);
                    b = buf[i];
                }
                if (b == 34) {
                    CHAR_SEQUENCE.skip(charSource, buf, i, 34, jsonParseContext);
                    i = jsonParseContext.endIndex;
                    b = buf[i];
                    empty = false;
                    if (b != 34) {
                        String errorContextTextAt = MapDeserializer.createErrorContextText(buf, i);
                        throw new JSONException("Syntax error, util pos " + i + ", context text by '" + errorContextTextAt + "' the closing symbol '\"' is not found ");
                    }
                    ++i;
                } else {
                    if (b == 125) {
                        if (!empty && !jsonParseContext.allowLastEndComma) {
                            String errorContextTextAt = MapDeserializer.createErrorContextText(buf, i);
                            throw new JSONException("Syntax error, at pos " + i + ", context text by '" + errorContextTextAt + "' the closing symbol '}' is not allowed here.");
                        }
                        jsonParseContext.endIndex = i;
                        return;
                    }
                    if (b == 39) {
                        if (!jsonParseContext.allowSingleQuotes) {
                            String errorContextTextAt = MapDeserializer.createErrorContextText(buf, i);
                            throw new JSONException("Syntax error, at pos " + i + ", context text by '" + errorContextTextAt + "' the single quote symbol ' is not allowed here.");
                        }
                        CHAR_SEQUENCE.skip(charSource, buf, i, 39, jsonParseContext);
                        i = jsonParseContext.endIndex + 1;
                        empty = false;
                    } else if (jsonParseContext.allowUnquotedFieldNames) {
                        while (i + 1 < toIndex && buf[++i] != 58) {
                        }
                        empty = false;
                    }
                }
                while ((b = buf[i]) <= 32) {
                    ++i;
                }
                if (jsonParseContext.allowComment && b == 47) {
                    i = MapDeserializer.clearCommentAndWhiteSpaces(buf, i + 1, toIndex, jsonParseContext);
                    b = buf[i];
                }
                if (b != 58) {
                    String errorContextTextAt = MapDeserializer.createErrorContextText(buf, i);
                    throw new JSONException("Syntax error, at pos " + i + ", context text by '" + errorContextTextAt + "', unexpected '" + (char)b + "', token ':' is expected.");
                }
                while ((b = buf[++i]) <= 32) {
                }
                if (jsonParseContext.allowComment && b == 47) {
                    i = MapDeserializer.clearCommentAndWhiteSpaces(buf, i + 1, toIndex, jsonParseContext);
                }
                ANY.skip(charSource, buf, i, toIndex, (byte)125, jsonParseContext);
                i = jsonParseContext.endIndex;
                while ((b = buf[++i]) <= 32) {
                }
                if (jsonParseContext.allowComment && b == 47) {
                    i = MapDeserializer.clearCommentAndWhiteSpaces(buf, i + 1, toIndex, jsonParseContext);
                    b = buf[i];
                }
                if (b != 44) break;
                ++i;
            }
            if (b == 125) {
                jsonParseContext.endIndex = i;
                return;
            }
            String errorContextTextAt = MapDeserializer.createErrorContextText(buf, i);
            throw new JSONException("Syntax error, at pos " + i + ", context text by '" + errorContextTextAt + "', unexpected '" + (char)b + "', expected ',' or '}'");
        }

        @Override
        protected Object deserialize(CharSource charSource, char[] buf, int fromIndex, int toIndex, GenericParameterizedType parameterizedType, Object instance, char endToken, JSONParseContext jsonParseContext) throws Exception {
            char beginChar = buf[fromIndex];
            if (beginChar == '{') {
                return this.deserializeMap(charSource, buf, fromIndex, toIndex, parameterizedType, instance, jsonParseContext);
            }
            if (beginChar == 'n') {
                return NULL.deserialize(charSource, buf, fromIndex, toIndex, null, null, jsonParseContext);
            }
            if (jsonParseContext.unMatchedEmptyAsNull && beginChar == '\"' && buf[fromIndex + 1] == '\"') {
                jsonParseContext.endIndex = fromIndex + 1;
                return null;
            }
            String errorContextTextAt = MapDeserializer.createErrorContextText(buf, fromIndex);
            throw new JSONException("Syntax error, at pos " + fromIndex + ", context text by '" + errorContextTextAt + "', unexpected '" + beginChar + "' for Map Type, expected '{' ");
        }

        @Override
        protected Object deserialize(CharSource charSource, byte[] buf, int fromIndex, int toIndex, GenericParameterizedType parameterizedType, Object instance, byte endToken, JSONParseContext jsonParseContext) throws Exception {
            byte beginByte = buf[fromIndex];
            char beginChar = (char)beginByte;
            if (beginChar == '{') {
                return this.deserializeMap(charSource, buf, fromIndex, toIndex, parameterizedType, instance, jsonParseContext);
            }
            if (beginChar == 'n') {
                return MapDeserializer.parseNull(buf, fromIndex, toIndex, jsonParseContext);
            }
            if (jsonParseContext.unMatchedEmptyAsNull && beginChar == '\"' && buf[fromIndex + 1] == 34) {
                jsonParseContext.endIndex = fromIndex + 1;
                return null;
            }
            String errorContextTextAt = MapDeserializer.createErrorContextText(buf, fromIndex);
            throw new JSONException("Syntax error, at pos " + fromIndex + ", context text by '" + errorContextTextAt + "', unexpected '" + beginChar + "' for Map Type, expected '{' ");
        }

        protected static Object mapKeyToType(Serializable mapKey, Class<?> keyType) {
            if (mapKey == null || keyType == null || keyType == String.class || keyType == CharSequence.class) {
                return mapKey;
            }
            Object key = ObjectUtils.toType(mapKey, keyType);
            if (key == null) {
                throw new UnsupportedOperationException("not supported type '" + keyType + "' as map key ");
            }
            return key;
        }

        Map createMap(GenericParameterizedType parameterizedType) {
            return MapDeserializer.createMapInstance(parameterizedType);
        }

        GenericParameterizedType getValueType(GenericParameterizedType parameterizedType) {
            return parameterizedType.getValueType();
        }

        JSONTypeDeserializer getValueDeserializer(GenericParameterizedType parameterizedType) {
            GenericParameterizedType valueType = parameterizedType.getValueType();
            return valueType == null ? ANY : JSONTypeDeserializer.getTypeDeserializer(valueType.getActualType());
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        Object deserializeMap(CharSource charSource, char[] buf, int fromIndex, int toIndex, GenericParameterizedType parameterizedType, Object obj, JSONParseContext jsonParseContext) throws Exception {
            Map instance = obj != null ? (Map)obj : this.createMap(parameterizedType);
            boolean empty = true;
            boolean disableCacheMapKey = jsonParseContext.disableCacheMapKey;
            boolean allowComment = jsonParseContext.allowComment;
            int i = fromIndex + 1;
            while (true) {
                Object mapKey;
                char ch;
                if ((ch = buf[i]) <= ' ') {
                    ++i;
                    continue;
                }
                if (allowComment && ch == '/') {
                    i = MapDeserializer.clearCommentAndWhiteSpaces(buf, i + 1, toIndex, jsonParseContext);
                    ch = buf[i];
                }
                int fieldKeyFrom = i;
                if (ch == '\"') {
                    mapKey = disableCacheMapKey ? (String)CHAR_SEQUENCE_STRING.deserializeString(charSource, buf, i, toIndex, '\"', GenericParameterizedType.StringType, jsonParseContext) : JSONDefaultParser.parseMapKeyByCache(buf, i, toIndex, '\"', jsonParseContext);
                    i = jsonParseContext.endIndex;
                    empty = false;
                    ++i;
                } else {
                    if (ch == '}') {
                        if (!empty && !jsonParseContext.allowLastEndComma) {
                            throw new JSONException("Syntax error, at pos " + i + ", the closing symbol '}' is not allowed here.");
                        }
                        jsonParseContext.endIndex = i;
                        return instance;
                    }
                    if (ch == '\'') {
                        if (!jsonParseContext.allowSingleQuotes) throw new JSONException("Syntax error, at pos " + i + ", the single quote symbol ' is not allowed here.");
                        while (i + 1 < toIndex && (buf[++i] != '\'' || buf[i - 1] == '\\')) {
                        }
                        empty = false;
                        mapKey = MapDeserializer.parseKeyOfMap(buf, fieldKeyFrom, ++i, false);
                    } else if (jsonParseContext.allowUnquotedFieldNames) {
                        while (i + 1 < toIndex && buf[++i] != ':') {
                        }
                        empty = false;
                        mapKey = MapDeserializer.parseKeyOfMap(buf, fieldKeyFrom, i, true);
                    } else {
                        int j = i++;
                        boolean isNullKey = false;
                        mapKey = null;
                        if (ch == 'n' && buf[i] == 'u' && buf[++i] == 'l' && buf[++i] == 'l') {
                            isNullKey = true;
                            ++i;
                        }
                        if (!isNullKey) {
                            String errorContextTextAt = MapDeserializer.createErrorContextText(buf, j);
                            throw new JSONException("Syntax error, at pos " + j + ", context text by '" + errorContextTextAt + "', unexpected '" + ch + "', expected '\"' or use option ReadOption.AllowUnquotedFieldNames ");
                        }
                    }
                }
                while ((ch = buf[i]) <= ' ') {
                    ++i;
                }
                if (allowComment && ch == '/') {
                    i = MapDeserializer.clearCommentAndWhiteSpaces(buf, i + 1, toIndex, jsonParseContext);
                    ch = buf[i];
                }
                if (ch == ':') {
                    Class<?> mapKeyClass = parameterizedType == null ? null : parameterizedType.getMapKeyClass();
                    Object key = MapDeserializer.mapKeyToType((Serializable)mapKey, mapKeyClass);
                    while ((ch = buf[++i]) <= ' ') {
                    }
                    if (allowComment && ch == '/') {
                        i = MapDeserializer.clearCommentAndWhiteSpaces(buf, i + 1, toIndex, jsonParseContext);
                        ch = buf[i];
                    }
                    JSONTypeDeserializer valueDeserializer = this.getValueDeserializer(parameterizedType);
                    Object value = valueDeserializer.deserialize(charSource, buf, i, toIndex, this.getValueType(parameterizedType), null, '}', jsonParseContext);
                    instance.put(key, value);
                    i = jsonParseContext.endIndex;
                    int endChar = jsonParseContext.endChar;
                    if (endChar == 0) {
                        while ((ch = buf[++i]) <= ' ') {
                        }
                        if (allowComment && ch == '/') {
                            i = MapDeserializer.clearCommentAndWhiteSpaces(buf, i + 1, toIndex, jsonParseContext);
                            ch = buf[i];
                        }
                    } else {
                        ch = (char)endChar;
                        jsonParseContext.endChar = 0;
                    }
                    if (ch != ',') {
                        if (ch == '}') {
                            jsonParseContext.endIndex = i;
                            return instance;
                        }
                        String errorContextTextAt = MapDeserializer.createErrorContextText(buf, i);
                        throw new JSONException("Syntax error, at pos " + i + ", context text by '" + errorContextTextAt + "', unexpected '" + ch + "', expected ',' or '}'");
                    }
                } else {
                    String errorContextTextAt = MapDeserializer.createErrorContextText(buf, i);
                    throw new JSONException("Syntax error, at pos " + i + ", context text by '" + errorContextTextAt + "', unexpected '" + ch + "', token ':' is expected.");
                }
                ++i;
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        Object deserializeMap(CharSource charSource, byte[] buf, int fromIndex, int toIndex, GenericParameterizedType parameterizedType, Object obj, JSONParseContext jsonParseContext) throws Exception {
            Map instance = obj != null ? (Map)obj : MapDeserializer.createMapInstance(parameterizedType);
            boolean empty = true;
            boolean disableCacheMapKey = jsonParseContext.disableCacheMapKey;
            boolean allowComment = jsonParseContext.allowComment;
            int i = fromIndex + 1;
            while (true) {
                Object mapKey;
                byte b;
                if ((b = buf[i]) <= 32) {
                    ++i;
                    continue;
                }
                if (allowComment && b == 47) {
                    i = MapDeserializer.clearCommentAndWhiteSpaces(buf, i + 1, toIndex, jsonParseContext);
                    b = buf[i];
                }
                int fieldKeyFrom = i;
                if (b == 34) {
                    mapKey = disableCacheMapKey ? MapDeserializer.parseMapKey(buf, i, toIndex, '\"', jsonParseContext) : MapDeserializer.parseMapKeyByCache(buf, i, toIndex, '\"', jsonParseContext);
                    i = jsonParseContext.endIndex;
                    empty = false;
                    ++i;
                } else {
                    if (b == 125) {
                        if (!empty && !jsonParseContext.allowLastEndComma) {
                            throw new JSONException("Syntax error, at pos " + i + ", the closing symbol '}' is not allowed here.");
                        }
                        jsonParseContext.endIndex = i;
                        return instance;
                    }
                    if (b == 39) {
                        if (!jsonParseContext.allowSingleQuotes) throw new JSONException("Syntax error, at pos " + i + ", the single quote symbol ' is not allowed here.");
                        while (i + 1 < toIndex && (buf[++i] != 39 || buf[i - 1] == 92)) {
                        }
                        empty = false;
                        mapKey = MapDeserializer.parseKeyOfMap(buf, fieldKeyFrom, ++i, false);
                    } else if (jsonParseContext.allowUnquotedFieldNames) {
                        while (i + 1 < toIndex && buf[++i] != 58) {
                        }
                        empty = false;
                        mapKey = MapDeserializer.parseKeyOfMap(buf, fieldKeyFrom, i, true);
                    } else {
                        int j = i++;
                        boolean isNullKey = false;
                        mapKey = null;
                        if (b == 110 && buf[i] == 117 && buf[++i] == 108 && buf[++i] == 108) {
                            isNullKey = true;
                            ++i;
                        }
                        if (!isNullKey) {
                            String errorContextTextAt = MapDeserializer.createErrorContextText(buf, j);
                            throw new JSONException("Syntax error, at pos " + j + ", context text by '" + errorContextTextAt + "', unexpected '" + (char)b + "', expected '\"' or use option ReadOption.AllowUnquotedFieldNames ");
                        }
                    }
                }
                while ((b = buf[i]) <= 32) {
                    ++i;
                }
                if (allowComment && b == 47) {
                    i = MapDeserializer.clearCommentAndWhiteSpaces(buf, i + 1, toIndex, jsonParseContext);
                    b = buf[i];
                }
                if (b == 58) {
                    Class<?> mapKeyClass = parameterizedType == null ? null : parameterizedType.getMapKeyClass();
                    Object key = MapDeserializer.mapKeyToType((Serializable)mapKey, mapKeyClass);
                    while ((b = buf[++i]) <= 32) {
                    }
                    if (allowComment && b == 47) {
                        i = MapDeserializer.clearCommentAndWhiteSpaces(buf, i + 1, toIndex, jsonParseContext);
                        b = buf[i];
                    }
                    Object value = this.getValueDeserializer(parameterizedType).deserialize(charSource, buf, i, toIndex, this.getValueType(parameterizedType), null, (byte)125, jsonParseContext);
                    instance.put(key, value);
                    i = jsonParseContext.endIndex;
                    int endChar = jsonParseContext.endChar;
                    if (endChar == 0) {
                        while ((b = buf[++i]) <= 32) {
                        }
                        if (allowComment && b == 47) {
                            i = MapDeserializer.clearCommentAndWhiteSpaces(buf, i + 1, toIndex, jsonParseContext);
                            b = buf[i];
                        }
                    } else {
                        b = (byte)endChar;
                        jsonParseContext.endChar = 0;
                    }
                    if (b != 44) {
                        if (b == 125) {
                            jsonParseContext.endIndex = i;
                            return instance;
                        }
                        String errorContextTextAt = MapDeserializer.createErrorContextText(buf, i);
                        throw new JSONException("Syntax error, at pos " + i + ", context text by '" + errorContextTextAt + "', unexpected '" + (char)b + "', expected ',' or '}'");
                    }
                } else {
                    String errorContextTextAt = MapDeserializer.createErrorContextText(buf, i);
                    throw new JSONException("Syntax error, at pos " + i + ", context text by '" + errorContextTextAt + "', unexpected '" + (char)b + "', token ':' is expected.");
                }
                ++i;
            }
        }
    }

    static class CollectionDeserializer
    extends JSONTypeDeserializer {
        CollectionDeserializer() {
        }

        void skip(CharSource charSource, char[] buf, int fromIndex, int toIndex, JSONParseContext jsonParseContext) throws Exception {
            int beginIndex = fromIndex + 1;
            int size = 0;
            boolean allowComment = jsonParseContext.allowComment;
            for (int i = beginIndex; i < toIndex; ++i) {
                char ch;
                while ((ch = buf[i]) <= ' ') {
                    ++i;
                }
                if (allowComment && ch == '/') {
                    i = CollectionDeserializer.clearCommentAndWhiteSpaces(buf, i + 1, toIndex, jsonParseContext);
                    ch = buf[i];
                }
                if (ch == ']') {
                    if (size > 0 && !jsonParseContext.allowLastEndComma) {
                        String errorContextTextAt = CollectionDeserializer.createErrorContextText(buf, i);
                        throw new JSONException("Syntax error, at pos " + i + ", context text by '" + errorContextTextAt + "' the closing symbol ']' is not allowed here.");
                    }
                    jsonParseContext.endIndex = i;
                    return;
                }
                ++size;
                ANY.skip(charSource, buf, i, toIndex, ']', jsonParseContext);
                i = jsonParseContext.endIndex;
                while ((ch = buf[++i]) <= ' ') {
                }
                if (allowComment && ch == '/') {
                    i = CollectionDeserializer.clearCommentAndWhiteSpaces(buf, i + 1, toIndex, jsonParseContext);
                    ch = buf[i];
                }
                if (ch == ',') continue;
                if (ch == ']') {
                    jsonParseContext.endIndex = i;
                    return;
                }
                String errorContextTextAt = CollectionDeserializer.createErrorContextText(buf, i);
                throw new JSONException("Syntax error, at pos " + i + ", context text by '" + errorContextTextAt + "', unexpected '" + ch + "', expected ',' or ']'");
            }
            throw new JSONException("Syntax error, cannot find closing symbol ']' matching '['");
        }

        void skip(CharSource charSource, byte[] buf, int fromIndex, int toIndex, JSONParseContext jsonParseContext) throws Exception {
            int beginIndex = fromIndex + 1;
            int size = 0;
            boolean allowComment = jsonParseContext.allowComment;
            for (int i = beginIndex; i < toIndex; ++i) {
                byte b;
                while ((b = buf[i]) <= 32) {
                    ++i;
                }
                if (allowComment && b == 47) {
                    i = CollectionDeserializer.clearCommentAndWhiteSpaces(buf, i + 1, toIndex, jsonParseContext);
                    b = buf[i];
                }
                if (b == 93) {
                    if (size > 0 && !jsonParseContext.allowLastEndComma) {
                        String errorContextTextAt = CollectionDeserializer.createErrorContextText(buf, i);
                        throw new JSONException("Syntax error, at pos " + i + ", context text by '" + errorContextTextAt + "' the closing symbol ']' is not allowed here.");
                    }
                    jsonParseContext.endIndex = i;
                    return;
                }
                ++size;
                ANY.skip(charSource, buf, i, toIndex, (byte)93, jsonParseContext);
                i = jsonParseContext.endIndex;
                while ((b = buf[++i]) <= 32) {
                }
                if (allowComment && b == 47) {
                    i = CollectionDeserializer.clearCommentAndWhiteSpaces(buf, i + 1, toIndex, jsonParseContext);
                    b = buf[i];
                }
                if (b == 44) continue;
                if (b == 93) {
                    jsonParseContext.endIndex = i;
                    return;
                }
                String errorContextTextAt = CollectionDeserializer.createErrorContextText(buf, i);
                throw new JSONException("Syntax error, at pos " + i + ", context text by '" + errorContextTextAt + "', unexpected '" + (char)b + "', expected ',' or ']'");
            }
            throw new JSONException("Syntax error, cannot find closing symbol ']' matching '['");
        }

        protected Collection createCollection(GenericParameterizedType parameterizedType) throws Exception {
            Class<?> collectionCls = parameterizedType.getActualType();
            if (collectionCls == null || collectionCls == List.class || collectionCls == ArrayList.class) {
                return new ArrayList(4);
            }
            return CollectionDeserializer.createCollectionInstance(collectionCls);
        }

        protected JSONTypeDeserializer getValueDeserializer(GenericParameterizedType valueGenType) {
            return JSONTypeDeserializer.getTypeDeserializer(valueGenType.getActualType());
        }

        Collection deserializeCollection(CharSource charSource, char[] buf, int fromIndex, int toIndex, GenericParameterizedType parameterizedType, Object instance, JSONParseContext jsonParseContext) throws Exception {
            Collection collection = instance != null ? (Collection)instance : this.createCollection(parameterizedType);
            GenericParameterizedType valueGenType = parameterizedType.getValueType();
            if (valueGenType == null) {
                valueGenType = GenericParameterizedType.AnyType;
            }
            JSONTypeDeserializer valueDeserializer = this.getValueDeserializer(valueGenType);
            boolean allowComment = jsonParseContext.allowComment;
            int beginIndex = fromIndex + 1;
            char ch = '\u0000';
            int i = beginIndex;
            while (true) {
                if ((ch = buf[i]) <= ' ') {
                    ++i;
                    continue;
                }
                if (allowComment && ch == '/') {
                    i = CollectionDeserializer.clearCommentAndWhiteSpaces(buf, i + 1, toIndex, jsonParseContext);
                    ch = buf[i];
                }
                if (ch == ']') {
                    if (collection.size() > 0 && !jsonParseContext.allowLastEndComma) {
                        String errorContextTextAt = CollectionDeserializer.createErrorContextText(buf, i);
                        throw new JSONException("Syntax error, at pos " + i + ", context text by '" + errorContextTextAt + "' the closing symbol ']' is not allowed here.");
                    }
                    jsonParseContext.endIndex = i;
                    return collection;
                }
                Object value = valueDeserializer.deserialize(charSource, buf, i, toIndex, valueGenType, null, ']', jsonParseContext);
                collection.add(value);
                i = jsonParseContext.endIndex;
                int endChar = jsonParseContext.endChar;
                if (endChar == 0) {
                    while ((ch = buf[++i]) <= ' ') {
                    }
                    if (allowComment && ch == '/') {
                        i = CollectionDeserializer.clearCommentAndWhiteSpaces(buf, i + 1, toIndex, jsonParseContext);
                        ch = buf[i];
                    }
                } else {
                    ch = (char)endChar;
                    jsonParseContext.endChar = 0;
                }
                if (ch != ',') {
                    if (ch == ']') {
                        jsonParseContext.endIndex = i;
                        return collection;
                    }
                    String errorContextTextAt = CollectionDeserializer.createErrorContextText(buf, i);
                    throw new JSONException("Syntax error, at pos " + i + ", context text by '" + errorContextTextAt + "', unexpected '" + ch + "', expected ',' or ']'");
                }
                ++i;
            }
        }

        Collection deserializeCollection(CharSource charSource, byte[] buf, int fromIndex, int toIndex, GenericParameterizedType parameterizedType, Object instance, JSONParseContext jsonParseContext) throws Exception {
            Collection collection = instance != null ? (Collection)instance : this.createCollection(parameterizedType);
            GenericParameterizedType valueGenType = parameterizedType.getValueType();
            if (valueGenType == null) {
                valueGenType = GenericParameterizedType.AnyType;
            }
            JSONTypeDeserializer valueDeserializer = this.getValueDeserializer(valueGenType);
            boolean allowComment = jsonParseContext.allowComment;
            int beginIndex = fromIndex + 1;
            byte b = 0;
            int i = beginIndex;
            while (true) {
                if ((b = buf[i]) <= 32) {
                    ++i;
                    continue;
                }
                if (allowComment && b == 47) {
                    i = CollectionDeserializer.clearCommentAndWhiteSpaces(buf, i + 1, toIndex, jsonParseContext);
                    b = buf[i];
                }
                if (b == 93) {
                    if (collection.size() > 0 && !jsonParseContext.allowLastEndComma) {
                        String errorContextTextAt = CollectionDeserializer.createErrorContextText(buf, i);
                        throw new JSONException("Syntax error, at pos " + i + ", context text by '" + errorContextTextAt + "' the closing symbol ']' is not allowed here.");
                    }
                    jsonParseContext.endIndex = i;
                    return collection;
                }
                Object value = valueDeserializer.deserialize(charSource, buf, i, toIndex, valueGenType, null, (byte)93, jsonParseContext);
                collection.add(value);
                i = jsonParseContext.endIndex;
                int endChar = jsonParseContext.endChar;
                if (endChar == 0) {
                    while ((b = buf[++i]) <= 32) {
                    }
                    if (allowComment && b == 47) {
                        i = CollectionDeserializer.clearCommentAndWhiteSpaces(buf, i + 1, toIndex, jsonParseContext);
                        b = buf[i];
                    }
                } else {
                    b = (byte)endChar;
                    jsonParseContext.endChar = 0;
                }
                if (b != 44) {
                    if (b == 93) {
                        jsonParseContext.endIndex = i;
                        return collection;
                    }
                    String errorContextTextAt = CollectionDeserializer.createErrorContextText(buf, i);
                    throw new JSONException("Syntax error, at pos " + i + ", context text by '" + errorContextTextAt + "', unexpected '" + (char)b + "', expected ',' or ']'");
                }
                ++i;
            }
        }

        @Override
        protected Object deserialize(CharSource charSource, char[] buf, int fromIndex, int toIndex, GenericParameterizedType parameterizedType, Object instance, char endToken, JSONParseContext jsonParseContext) throws Exception {
            char beginChar = buf[fromIndex];
            if (beginChar == '[') {
                return this.deserializeCollection(charSource, buf, fromIndex, toIndex, parameterizedType, instance, jsonParseContext);
            }
            if (beginChar == 'n') {
                return NULL.deserialize(charSource, buf, fromIndex, toIndex, null, null, jsonParseContext);
            }
            if (jsonParseContext.unMatchedEmptyAsNull && beginChar == '\"' && buf[fromIndex + 1] == '\"') {
                jsonParseContext.endIndex = fromIndex + 1;
                return null;
            }
            String errorContextTextAt = CollectionDeserializer.createErrorContextText(buf, fromIndex);
            throw new JSONException("Syntax error, at pos " + fromIndex + ", context text by '" + errorContextTextAt + "', expected token character '[', but found '" + beginChar + "' for Collection Type ");
        }

        @Override
        protected Object deserialize(CharSource charSource, byte[] buf, int fromIndex, int toIndex, GenericParameterizedType parameterizedType, Object instance, byte endToken, JSONParseContext jsonParseContext) throws Exception {
            byte beginByte = buf[fromIndex];
            if (beginByte == 91) {
                return this.deserializeCollection(charSource, buf, fromIndex, toIndex, parameterizedType, instance, jsonParseContext);
            }
            if (beginByte == 110) {
                return CollectionDeserializer.parseNull(buf, fromIndex, toIndex, jsonParseContext);
            }
            if (jsonParseContext.unMatchedEmptyAsNull && beginByte == 34 && buf[fromIndex + 1] == 34) {
                jsonParseContext.endIndex = fromIndex + 1;
                return null;
            }
            String errorContextTextAt = CollectionDeserializer.createErrorContextText(buf, fromIndex);
            throw new JSONException("Syntax error, at pos " + fromIndex + ", context text by '" + errorContextTextAt + "', expected token character '[', but found '" + (char)beginByte + "' for Collection Type ");
        }

        static class HashSetDeserializer
        extends CollectionInstanceDeserializer {
            HashSetDeserializer(GenericParameterizedType genericParameterizedType) {
                super(genericParameterizedType);
            }

            @Override
            protected final Collection createCollection(GenericParameterizedType parameterizedType) throws Exception {
                return new HashSet(5);
            }
        }

        static class ArrayListDeserializer
        extends CollectionInstanceDeserializer {
            ArrayListDeserializer(GenericParameterizedType genericParameterizedType) {
                super(genericParameterizedType);
            }

            @Override
            Collection deserializeCollection(CharSource charSource, char[] buf, int fromIndex, int toIndex, GenericParameterizedType parameterizedType, Object instance, JSONParseContext jsonParseContext) throws Exception {
                char ch;
                boolean allowComment = jsonParseContext.allowComment;
                ArrayList<Object> collection = new ArrayList<Object>(5);
                int i = fromIndex;
                while (true) {
                    if ((ch = buf[++i]) <= ' ') {
                        continue;
                    }
                    if (allowComment && ch == '/') {
                        i = ArrayListDeserializer.clearCommentAndWhiteSpaces(buf, i + 1, toIndex, jsonParseContext);
                        ch = buf[i];
                    }
                    if (ch == ']') {
                        if (collection.size() > 0 && !jsonParseContext.allowLastEndComma) {
                            String errorContextTextAt = ArrayListDeserializer.createErrorContextText(buf, i);
                            throw new JSONException("Syntax error, at pos " + i + ", context text by '" + errorContextTextAt + "' the closing symbol ']' is not allowed here.");
                        }
                        jsonParseContext.endIndex = i;
                        return collection;
                    }
                    Object value = this.valueDeserializer.deserialize(charSource, buf, i, toIndex, this.valueType, null, ']', jsonParseContext);
                    collection.add(value);
                    i = jsonParseContext.endIndex;
                    int endChar = jsonParseContext.endChar;
                    if (endChar == 0) {
                        while ((ch = buf[++i]) <= ' ') {
                        }
                        if (allowComment && ch == '/') {
                            i = ArrayListDeserializer.clearCommentAndWhiteSpaces(buf, i + 1, toIndex, jsonParseContext);
                            ch = buf[i];
                        }
                    } else {
                        ch = (char)endChar;
                        jsonParseContext.endChar = 0;
                    }
                    if (ch != ',') break;
                }
                if (ch == ']') {
                    jsonParseContext.endIndex = i;
                    return collection;
                }
                String errorContextTextAt = ArrayListDeserializer.createErrorContextText(buf, i);
                throw new JSONException("Syntax error, at pos " + i + ", context text by '" + errorContextTextAt + "', unexpected '" + ch + "', expected ',' or ']'");
            }

            @Override
            Collection deserializeCollection(CharSource charSource, byte[] buf, int fromIndex, int toIndex, GenericParameterizedType parameterizedType, Object instance, JSONParseContext jsonParseContext) throws Exception {
                byte b;
                boolean allowComment = jsonParseContext.allowComment;
                ArrayList<Object> collection = new ArrayList<Object>(5);
                int i = fromIndex;
                while (true) {
                    if ((b = buf[++i]) <= 32) {
                        continue;
                    }
                    if (allowComment && b == 47) {
                        i = ArrayListDeserializer.clearCommentAndWhiteSpaces(buf, i + 1, toIndex, jsonParseContext);
                        b = buf[i];
                    }
                    if (b == 93) {
                        if (collection.size() > 0 && !jsonParseContext.allowLastEndComma) {
                            String errorContextTextAt = ArrayListDeserializer.createErrorContextText(buf, i);
                            throw new JSONException("Syntax error, at pos " + i + ", context text by '" + errorContextTextAt + "' the closing symbol ']' is not allowed here.");
                        }
                        jsonParseContext.endIndex = i;
                        return collection;
                    }
                    Object value = this.valueDeserializer.deserialize(charSource, buf, i, toIndex, this.valueType, null, (byte)93, jsonParseContext);
                    collection.add(value);
                    i = jsonParseContext.endIndex;
                    int endChar = jsonParseContext.endChar;
                    if (endChar == 0) {
                        while ((b = buf[++i]) <= 32) {
                        }
                        if (allowComment && b == 47) {
                            i = ArrayListDeserializer.clearCommentAndWhiteSpaces(buf, i + 1, toIndex, jsonParseContext);
                            b = buf[i];
                        }
                    } else {
                        b = (byte)endChar;
                        jsonParseContext.endChar = 0;
                    }
                    if (b != 44) break;
                }
                if (b == 93) {
                    jsonParseContext.endIndex = i;
                    return collection;
                }
                String errorContextTextAt = ArrayListDeserializer.createErrorContextText(buf, i);
                throw new JSONException("Syntax error, at pos " + i + ", context text by '" + errorContextTextAt + "', unexpected '" + (char)b + "', expected ',' or ']'");
            }

            @Override
            protected Collection createCollection(GenericParameterizedType parameterizedType) throws Exception {
                return new ArrayList(5);
            }
        }

        static class CollectionInstanceDeserializer
        extends CollectionDeserializer {
            protected final GenericParameterizedType parameterizedType;
            protected final GenericParameterizedType valueType;
            protected final JSONTypeDeserializer valueDeserializer;
            private final Class<? extends Collection> constructionClass;

            CollectionInstanceDeserializer(GenericParameterizedType genericParameterizedType) {
                this.parameterizedType = genericParameterizedType;
                this.valueType = genericParameterizedType.getValueType();
                this.valueDeserializer = this.valueType == null ? ANY : CollectionInstanceDeserializer.getTypeDeserializer(this.valueType.getActualType());
                this.constructionClass = genericParameterizedType.getActualType();
            }

            @Override
            protected Collection createCollection(GenericParameterizedType parameterizedType) throws Exception {
                try {
                    Class<? extends Collection> targetClass = this.constructionClass;
                    if (targetClass.isInterface() || Modifier.isAbstract(targetClass.getModifiers())) {
                        JSONImplInstCreator implInstCreator = CollectionInstanceDeserializer.getJSONImplInstCreator(targetClass);
                        if (implInstCreator != null) {
                            return (Collection)implInstCreator.create(parameterizedType);
                        }
                        throw new JSONException("create instance error for " + targetClass);
                    }
                    return (Collection)UnsafeHelper.newInstance(targetClass);
                }
                catch (Throwable throwable) {
                    throw new JSONException("create instance error for " + parameterizedType.getActualType());
                }
            }

            @Override
            protected JSONTypeDeserializer getValueDeserializer(GenericParameterizedType valueGenType) {
                return this.valueDeserializer;
            }
        }
    }

    static class ArrayDeserializer
    extends JSONTypeDeserializer {
        ArrayDeserializer() {
        }

        @Override
        protected Object valueOf(String value, Class<?> actualType) {
            return value.toCharArray();
        }

        Object deserializeArray(CharSource charSource, char[] buf, int fromIndex, int toIndex, GenericParameterizedType parameterizedType, Object instance, JSONParseContext jsonParseContext) throws Exception {
            int beginIndex = fromIndex + 1;
            char ch = '\u0000';
            Class<?> arrayCls = parameterizedType.getActualType();
            GenericParameterizedType<?> valueType = parameterizedType.getValueType();
            JSONTypeDeserializer valueDeserializer = null;
            Class<?> elementCls = null;
            if (valueType == null) {
                elementCls = arrayCls.getComponentType();
                valueType = GenericParameterizedType.actualType(elementCls);
                valueDeserializer = ArrayDeserializer.getTypeDeserializer(elementCls);
            } else {
                elementCls = valueType.getActualType();
                valueDeserializer = ArrayDeserializer.getTypeDeserializer(elementCls);
            }
            ArrayList<Object> collection = new ArrayList<Object>(5);
            boolean allowComment = jsonParseContext.allowComment;
            int i = beginIndex;
            while (true) {
                if ((ch = buf[i]) <= ' ') {
                    ++i;
                    continue;
                }
                if (allowComment && ch == '/') {
                    i = ArrayDeserializer.clearCommentAndWhiteSpaces(buf, i + 1, toIndex, jsonParseContext);
                    ch = buf[i];
                }
                if (ch == ']') {
                    if (collection.size() > 0 && !jsonParseContext.allowLastEndComma) {
                        String errorContextTextAt = ArrayDeserializer.createErrorContextText(buf, i);
                        throw new JSONException("Syntax error, at pos " + i + ", context text by '" + errorContextTextAt + "' the closing symbol ']' is not allowed here.");
                    }
                    jsonParseContext.endIndex = i;
                    return ArrayDeserializer.collectionToArray(collection, elementCls);
                }
                Object value = valueDeserializer.deserialize(charSource, buf, i, toIndex, valueType, null, ']', jsonParseContext);
                collection.add(value);
                i = jsonParseContext.endIndex;
                int endChar = jsonParseContext.endChar;
                if (endChar == 0) {
                    while ((ch = buf[++i]) <= ' ') {
                    }
                    if (allowComment && ch == '/') {
                        i = ArrayDeserializer.clearCommentAndWhiteSpaces(buf, i + 1, toIndex, jsonParseContext);
                        ch = buf[i];
                    }
                } else {
                    ch = (char)endChar;
                    jsonParseContext.endChar = 0;
                }
                if (ch != ',') {
                    if (ch == ']') {
                        jsonParseContext.endIndex = i;
                        return ArrayDeserializer.collectionToArray(collection, elementCls);
                    }
                    String errorContextTextAt = ArrayDeserializer.createErrorContextText(buf, i);
                    throw new JSONException("Syntax error, at pos " + i + ", context text by '" + errorContextTextAt + "', unexpected '" + ch + "', expected ',' or ']'");
                }
                ++i;
            }
        }

        Object deserializeArray(CharSource charSource, byte[] buf, int fromIndex, int toIndex, GenericParameterizedType parameterizedType, Object instance, JSONParseContext jsonParseContext) throws Exception {
            int beginIndex = fromIndex + 1;
            byte b = 0;
            Class<?> arrayCls = parameterizedType.getActualType();
            GenericParameterizedType<?> valueType = parameterizedType.getValueType();
            Class<?> elementCls = null;
            JSONTypeDeserializer valueDeserializer = null;
            if (valueType == null) {
                elementCls = arrayCls.getComponentType();
                valueType = GenericParameterizedType.actualType(elementCls);
                valueDeserializer = ArrayDeserializer.getTypeDeserializer(elementCls);
            } else {
                elementCls = valueType.getActualType();
                valueDeserializer = ArrayDeserializer.getTypeDeserializer(elementCls);
            }
            ArrayList<Object> collection = new ArrayList<Object>(5);
            boolean allowComment = jsonParseContext.allowComment;
            int i = beginIndex;
            while (true) {
                if ((b = buf[i]) <= 32) {
                    ++i;
                    continue;
                }
                if (allowComment && b == 47) {
                    i = ArrayDeserializer.clearCommentAndWhiteSpaces(buf, i + 1, toIndex, jsonParseContext);
                    b = buf[i];
                }
                if (b == 93) {
                    if (collection.size() > 0 && !jsonParseContext.allowLastEndComma) {
                        String errorContextTextAt = ArrayDeserializer.createErrorContextText(buf, i);
                        throw new JSONException("Syntax error, at pos " + i + ", context text by '" + errorContextTextAt + "' the closing symbol ']' is not allowed here.");
                    }
                    jsonParseContext.endIndex = i;
                    return ArrayDeserializer.collectionToArray(collection, elementCls);
                }
                Object value = valueDeserializer.deserialize(charSource, buf, i, toIndex, valueType, null, (byte)93, jsonParseContext);
                collection.add(value);
                i = jsonParseContext.endIndex;
                int endChar = jsonParseContext.endChar;
                if (endChar == 0) {
                    while ((b = buf[++i]) <= 32) {
                    }
                    if (allowComment && b == 47) {
                        i = ArrayDeserializer.clearCommentAndWhiteSpaces(buf, i + 1, toIndex, jsonParseContext);
                        b = buf[i];
                    }
                } else {
                    b = (byte)endChar;
                    jsonParseContext.endChar = 0;
                }
                if (b != 44) {
                    if (b == 93) {
                        jsonParseContext.endIndex = i;
                        return ArrayDeserializer.collectionToArray(collection, elementCls);
                    }
                    String errorContextTextAt = ArrayDeserializer.createErrorContextText(buf, i);
                    throw new JSONException("Syntax error, at pos " + i + ", context text by '" + errorContextTextAt + "', unexpected '" + (char)b + "', expected ',' or ']'");
                }
                ++i;
            }
        }

        @Override
        protected Object deserialize(CharSource charSource, char[] buf, int fromIndex, int toIndex, GenericParameterizedType parameterizedType, Object instance, char endToken, JSONParseContext jsonParseContext) throws Exception {
            char beginChar = buf[fromIndex];
            if (beginChar == '[') {
                return this.deserializeArray(charSource, buf, fromIndex, toIndex, parameterizedType, instance, jsonParseContext);
            }
            if (beginChar == 'n') {
                return NULL.deserialize(charSource, buf, fromIndex, toIndex, null, null, '\u0000', jsonParseContext);
            }
            if (jsonParseContext.unMatchedEmptyAsNull && beginChar == '\"' && buf[fromIndex + 1] == '\"') {
                jsonParseContext.endIndex = fromIndex + 1;
                return null;
            }
            String errorContextTextAt = ArrayDeserializer.createErrorContextText(buf, fromIndex);
            throw new JSONException("Syntax error, at pos " + fromIndex + ", context text by '" + errorContextTextAt + "', unexpected '" + beginChar + "' for collection type ");
        }

        @Override
        protected Object deserialize(CharSource charSource, byte[] buf, int fromIndex, int toIndex, GenericParameterizedType parameterizedType, Object instance, byte endToken, JSONParseContext jsonParseContext) throws Exception {
            byte beginByte = buf[fromIndex];
            if (beginByte == 91) {
                return this.deserializeArray(charSource, buf, fromIndex, toIndex, parameterizedType, instance, jsonParseContext);
            }
            if (beginByte == 110) {
                return ArrayDeserializer.parseNull(buf, fromIndex, toIndex, jsonParseContext);
            }
            char beginChar = (char)beginByte;
            if (jsonParseContext.unMatchedEmptyAsNull && beginChar == '\"' && buf[fromIndex + 1] == 34) {
                jsonParseContext.endIndex = fromIndex + 1;
                return null;
            }
            String errorContextTextAt = ArrayDeserializer.createErrorContextText(buf, fromIndex);
            throw new JSONException("Syntax error, at pos " + fromIndex + ", context text by '" + errorContextTextAt + "', unexpected '" + beginChar + "' for Collection Type ");
        }

        static class ByteArrayDeserializer
        extends ArrayInstanceDeserializer {
            ByteArrayDeserializer() {
            }

            @Override
            public Object empty() {
                return new Byte[0];
            }

            @Override
            public Object initArray(JSONParseContext parseContext) {
                return new Byte[10];
            }

            @Override
            public int size(Object arr) {
                return ((Byte[])arr).length;
            }

            @Override
            public void setElementAt(Object arr, Object element, int index) {
                Byte[] value = (Byte[])arr;
                value[index] = (Byte)element;
            }

            @Override
            public Object copyOf(Object arr, int len) {
                Byte[] value = (Byte[])arr;
                return Arrays.copyOf(value, len);
            }

            @Override
            public JSONTypeDeserializer getValueDeserializer() {
                return NUMBER_BYTE;
            }
        }

        static class PrimitiveIntArrayDeserializer
        extends ArrayInstanceDeserializer {
            PrimitiveIntArrayDeserializer() {
            }

            @Override
            public Object empty() {
                return EMPTY_INTS;
            }

            @Override
            public Object initArray(JSONParseContext parseContext) {
                return INT_ARRAY_TL.get();
            }

            @Override
            public int size(Object arr) {
                return ((int[])arr).length;
            }

            @Override
            public void setElementAt(Object arr, Object element, int index) {
                int[] value = (int[])arr;
                value[index] = (Integer)element;
            }

            @Override
            public Object copyOf(Object arr, int len) {
                int[] value = (int[])arr;
                return Arrays.copyOf(value, len);
            }

            @Override
            public JSONTypeDeserializer getValueDeserializer() {
                return NUMBER_INTEGER;
            }
        }

        static class IntArrayDeserializer
        extends ArrayInstanceDeserializer {
            IntArrayDeserializer() {
            }

            @Override
            public Object empty() {
                return new Integer[0];
            }

            @Override
            public Object initArray(JSONParseContext parseContext) {
                return new Integer[10];
            }

            @Override
            public int size(Object arr) {
                return ((Integer[])arr).length;
            }

            @Override
            public void setElementAt(Object arr, Object element, int index) {
                Integer[] value = (Integer[])arr;
                value[index] = (Integer)element;
            }

            @Override
            public Object copyOf(Object arr, int len) {
                Integer[] value = (Integer[])arr;
                return Arrays.copyOf(value, len);
            }

            @Override
            public JSONTypeDeserializer getValueDeserializer() {
                return NUMBER_INTEGER;
            }
        }

        static class PrimitiveFloatArrayDeserializer
        extends ArrayInstanceDeserializer {
            PrimitiveFloatArrayDeserializer() {
            }

            @Override
            public Object empty() {
                return new float[0];
            }

            @Override
            public Object initArray(JSONParseContext parseContext) {
                return new float[10];
            }

            @Override
            public int size(Object arr) {
                return ((float[])arr).length;
            }

            @Override
            public void setElementAt(Object arr, Object element, int index) {
                float[] value = (float[])arr;
                value[index] = ((Float)element).floatValue();
            }

            @Override
            public Object copyOf(Object arr, int len) {
                float[] value = (float[])arr;
                return Arrays.copyOf(value, len);
            }

            @Override
            public JSONTypeDeserializer getValueDeserializer() {
                return NUMBER_FLOAT;
            }
        }

        static class FloatArrayDeserializer
        extends ArrayInstanceDeserializer {
            FloatArrayDeserializer() {
            }

            @Override
            public Object empty() {
                return new Float[0];
            }

            @Override
            public Object initArray(JSONParseContext parseContext) {
                return new Float[10];
            }

            @Override
            public int size(Object arr) {
                return ((Float[])arr).length;
            }

            @Override
            public void setElementAt(Object arr, Object element, int index) {
                Float[] value = (Float[])arr;
                value[index] = (Float)element;
            }

            @Override
            public Object copyOf(Object arr, int len) {
                Float[] value = (Float[])arr;
                return Arrays.copyOf(value, len);
            }

            @Override
            public JSONTypeDeserializer getValueDeserializer() {
                return NUMBER_FLOAT;
            }
        }

        static class PrimitiveLongArrayDeserializer
        extends ArrayInstanceDeserializer {
            PrimitiveLongArrayDeserializer() {
            }

            @Override
            public Object empty() {
                return EMPTY_LONGS;
            }

            @Override
            public Object initArray(JSONParseContext parseContext) {
                return LONG_ARRAY_TL.get();
            }

            @Override
            public int size(Object arr) {
                return ((long[])arr).length;
            }

            @Override
            public void setElementAt(Object arr, Object element, int index) {
                long[] value = (long[])arr;
                value[index] = (Long)element;
            }

            @Override
            public Object copyOf(Object arr, int len) {
                long[] value = (long[])arr;
                return Arrays.copyOf(value, len);
            }

            @Override
            public Object subOf(Object arr, int len) {
                long[] value = (long[])arr;
                return JSONUnsafe.copyLongs(value, 0, len);
            }

            @Override
            public JSONTypeDeserializer getValueDeserializer() {
                return NUMBER_LONG;
            }
        }

        static class LongArrayDeserializer
        extends ArrayInstanceDeserializer {
            LongArrayDeserializer() {
            }

            @Override
            public Object empty() {
                return new Long[0];
            }

            @Override
            public Object initArray(JSONParseContext parseContext) {
                return new Long[10];
            }

            @Override
            public int size(Object arr) {
                return ((Long[])arr).length;
            }

            @Override
            public void setElementAt(Object arr, Object element, int index) {
                Long[] value = (Long[])arr;
                value[index] = (Long)element;
            }

            @Override
            public Object copyOf(Object arr, int len) {
                Long[] value = (Long[])arr;
                return Arrays.copyOf(value, len);
            }

            @Override
            public JSONTypeDeserializer getValueDeserializer() {
                return NUMBER_LONG;
            }
        }

        static class PrimitiveDoubleArrayDeserializer
        extends ArrayInstanceDeserializer {
            PrimitiveDoubleArrayDeserializer() {
            }

            @Override
            public Object empty() {
                return EMPTY_DOUBLES;
            }

            @Override
            public Object initArray(JSONParseContext parseContext) {
                return DOUBLE_ARRAY_TL.get();
            }

            @Override
            public int size(Object arr) {
                return ((double[])arr).length;
            }

            @Override
            public void setElementAt(Object arr, Object element, int index) {
                double[] value = (double[])arr;
                value[index] = (Double)element;
            }

            @Override
            public Object copyOf(Object arr, int len) {
                double[] value = (double[])arr;
                return Arrays.copyOf(value, len);
            }

            @Override
            public Object subOf(Object arr, int len) {
                double[] value = (double[])arr;
                return JSONUnsafe.copyDoubles(value, 0, len);
            }

            @Override
            public JSONTypeDeserializer getValueDeserializer() {
                return NUMBER_DOUBLE;
            }
        }

        static class DoubleArrayDeserializer
        extends ArrayInstanceDeserializer {
            DoubleArrayDeserializer() {
            }

            @Override
            public Object empty() {
                return new Double[0];
            }

            @Override
            public Object initArray(JSONParseContext parseContext) {
                return new Double[10];
            }

            @Override
            public int size(Object arr) {
                return ((Double[])arr).length;
            }

            @Override
            public void setElementAt(Object arr, Object element, int index) {
                Double[] value = (Double[])arr;
                value[index] = (Double)element;
            }

            @Override
            public Object copyOf(Object arr, int len) {
                Double[] value = (Double[])arr;
                return Arrays.copyOf(value, len);
            }

            @Override
            public JSONTypeDeserializer getValueDeserializer() {
                return NUMBER_DOUBLE;
            }
        }

        static final class StringArrayDeserializer
        extends ArrayInstanceDeserializer {
            StringArrayDeserializer() {
            }

            @Override
            protected Object valueOf(String value, Class<?> actualType) {
                return new String[]{value};
            }

            @Override
            Object deserializeArray(CharSource charSource, char[] buf, int fromIndex, int toIndex, GenericParameterizedType parameterizedType, Object instance, JSONParseContext jsonParseContext) throws Exception {
                int beginIndex = fromIndex + 1;
                String[] arr = jsonParseContext.getContextStrings();
                int size = arr.length;
                int len = 0;
                boolean allowComment = jsonParseContext.allowComment;
                int i = beginIndex;
                while (true) {
                    char ch;
                    if ((ch = buf[i]) <= ' ') {
                        ++i;
                        continue;
                    }
                    if (allowComment && ch == '/') {
                        i = StringArrayDeserializer.clearCommentAndWhiteSpaces(buf, i + 1, toIndex, jsonParseContext);
                        ch = buf[i];
                    }
                    if (ch == ']') {
                        if (len > 0 && !jsonParseContext.allowLastEndComma) {
                            String errorContextTextAt = StringArrayDeserializer.createErrorContextText(buf, i);
                            throw new JSONException("Syntax error, at pos " + i + ", context text by '" + errorContextTextAt + "' the closing symbol ']' is not allowed here.");
                        }
                        jsonParseContext.endIndex = i;
                        return len == 0 ? EMPTY_STRINGS : JSONUnsafe.copyStrings(arr, 0, len);
                    }
                    String value = (String)CHAR_SEQUENCE_STRING.deserialize(charSource, buf, i, toIndex, null, null, ']', jsonParseContext);
                    if (len >= size) {
                        arr = Arrays.copyOf(arr, size <<= 1);
                    }
                    arr[len++] = value;
                    i = jsonParseContext.endIndex;
                    while ((ch = buf[++i]) <= ' ') {
                    }
                    if (allowComment && ch == '/') {
                        i = StringArrayDeserializer.clearCommentAndWhiteSpaces(buf, i + 1, toIndex, jsonParseContext);
                        ch = buf[i];
                    }
                    if (ch != ',') {
                        if (ch == ']') {
                            jsonParseContext.endIndex = i;
                            return JSONUnsafe.copyStrings(arr, 0, len);
                        }
                        String errorContextTextAt = StringArrayDeserializer.createErrorContextText(buf, i);
                        throw new JSONException("Syntax error, at pos " + i + ", context text by '" + errorContextTextAt + "', unexpected '" + ch + "', expected ',' or ']'");
                    }
                    ++i;
                }
            }

            @Override
            Object deserializeArray(CharSource charSource, byte[] buf, int fromIndex, int toIndex, GenericParameterizedType parameterizedType, Object instance, JSONParseContext jsonParseContext) throws Exception {
                int beginIndex = fromIndex + 1;
                String[] arr = jsonParseContext.getContextStrings();
                int size = arr.length;
                int len = 0;
                boolean allowComment = jsonParseContext.allowComment;
                int i = beginIndex;
                while (true) {
                    byte b;
                    if ((b = buf[i]) <= 32) {
                        ++i;
                        continue;
                    }
                    if (allowComment && b == 47) {
                        i = StringArrayDeserializer.clearCommentAndWhiteSpaces(buf, i + 1, toIndex, jsonParseContext);
                        b = buf[i];
                    }
                    if (b == 93) {
                        if (len > 0 && !jsonParseContext.allowLastEndComma) {
                            String errorContextTextAt = StringArrayDeserializer.createErrorContextText(buf, i);
                            throw new JSONException("Syntax error, at pos " + i + ", context text by '" + errorContextTextAt + "' the closing symbol ']' is not allowed here.");
                        }
                        jsonParseContext.endIndex = i;
                        return len == 0 ? EMPTY_STRINGS : JSONUnsafe.copyStrings(arr, 0, len);
                    }
                    String value = (String)CHAR_SEQUENCE_STRING.deserialize(charSource, buf, i, toIndex, null, null, (byte)93, jsonParseContext);
                    if (len >= size) {
                        arr = Arrays.copyOf(arr, size <<= 1);
                    }
                    arr[len++] = value;
                    i = jsonParseContext.endIndex;
                    while ((b = buf[++i]) <= 32) {
                    }
                    if (allowComment && b == 47) {
                        i = StringArrayDeserializer.clearCommentAndWhiteSpaces(buf, i + 1, toIndex, jsonParseContext);
                        b = buf[i];
                    }
                    if (b != 44) {
                        if (b == 93) {
                            jsonParseContext.endIndex = i;
                            return JSONUnsafe.copyStrings(arr, 0, len);
                        }
                        String errorContextTextAt = StringArrayDeserializer.createErrorContextText(buf, i);
                        throw new JSONException("Syntax error, at pos " + i + ", context text by '" + errorContextTextAt + "', unexpected '" + (char)b + "', expected ',' or ']'");
                    }
                    ++i;
                }
            }
        }

        static abstract class ArrayInstanceDeserializer
        extends ArrayDeserializer {
            ArrayInstanceDeserializer() {
            }

            public Object empty() {
                throw new UnsupportedOperationException();
            }

            public Object initArray(JSONParseContext parseContext) {
                throw new UnsupportedOperationException();
            }

            public int size(Object arr) {
                throw new UnsupportedOperationException();
            }

            public void setElementAt(Object arr, Object element, int index) {
                throw new UnsupportedOperationException();
            }

            public Object copyOf(Object value, int len) {
                throw new UnsupportedOperationException();
            }

            public Object subOf(Object value, int len) {
                return this.copyOf(value, len);
            }

            public JSONTypeDeserializer getValueDeserializer() {
                throw new UnsupportedOperationException();
            }

            @Override
            Object deserializeArray(CharSource charSource, char[] buf, int fromIndex, int toIndex, GenericParameterizedType parameterizedType, Object instance, JSONParseContext jsonParseContext) throws Exception {
                int beginIndex = fromIndex + 1;
                Object arr = this.initArray(jsonParseContext);
                int size = this.size(arr);
                int len = 0;
                boolean allowComment = jsonParseContext.allowComment;
                int i = beginIndex;
                while (true) {
                    char ch;
                    if ((ch = buf[i]) <= ' ') {
                        ++i;
                        continue;
                    }
                    if (allowComment && ch == '/') {
                        i = ArrayInstanceDeserializer.clearCommentAndWhiteSpaces(buf, i + 1, toIndex, jsonParseContext);
                        ch = buf[i];
                    }
                    if (ch == ']') {
                        if (len > 0 && !jsonParseContext.allowLastEndComma) {
                            String errorContextTextAt = ArrayInstanceDeserializer.createErrorContextText(buf, i);
                            throw new JSONException("Syntax error, at pos " + i + ", context text by '" + errorContextTextAt + "' the closing symbol ']' is not allowed here.");
                        }
                        jsonParseContext.endIndex = i;
                        return len == 0 ? this.empty() : this.subOf(arr, len);
                    }
                    Object value = this.getValueDeserializer().deserialize(charSource, buf, i, toIndex, null, null, ']', jsonParseContext);
                    if (len >= size) {
                        arr = this.copyOf(arr, size <<= 1);
                    }
                    this.setElementAt(arr, value, len++);
                    i = jsonParseContext.endIndex;
                    int endChar = jsonParseContext.endChar;
                    if (endChar == 0) {
                        while ((ch = buf[++i]) <= ' ') {
                        }
                        if (allowComment && ch == '/') {
                            i = ArrayInstanceDeserializer.clearCommentAndWhiteSpaces(buf, i + 1, toIndex, jsonParseContext);
                            ch = buf[i];
                        }
                    } else {
                        ch = (char)endChar;
                        jsonParseContext.endChar = 0;
                    }
                    if (ch != ',') {
                        if (ch == ']') {
                            jsonParseContext.endIndex = i;
                            return this.subOf(arr, len);
                        }
                        String errorContextTextAt = ArrayInstanceDeserializer.createErrorContextText(buf, i);
                        throw new JSONException("Syntax error, at pos " + i + ", context text by '" + errorContextTextAt + "', unexpected '" + ch + "', expected ',' or ']'");
                    }
                    ++i;
                }
            }

            @Override
            Object deserializeArray(CharSource charSource, byte[] buf, int fromIndex, int toIndex, GenericParameterizedType parameterizedType, Object instance, JSONParseContext jsonParseContext) throws Exception {
                int beginIndex = fromIndex + 1;
                Object arr = this.initArray(jsonParseContext);
                int size = this.size(arr);
                int len = 0;
                boolean allowComment = jsonParseContext.allowComment;
                int i = beginIndex;
                while (true) {
                    byte b;
                    if ((b = buf[i]) <= 32) {
                        ++i;
                        continue;
                    }
                    if (allowComment && b == 47) {
                        i = ArrayInstanceDeserializer.clearCommentAndWhiteSpaces(buf, i + 1, toIndex, jsonParseContext);
                        b = buf[i];
                    }
                    if (b == 93) {
                        if (len > 0 && !jsonParseContext.allowLastEndComma) {
                            String errorContextTextAt = ArrayInstanceDeserializer.createErrorContextText(buf, i);
                            throw new JSONException("Syntax error, at pos " + i + ", context text by '" + errorContextTextAt + "' the closing symbol ']' is not allowed here.");
                        }
                        jsonParseContext.endIndex = i;
                        return len == 0 ? this.empty() : this.subOf(arr, len);
                    }
                    Object value = this.getValueDeserializer().deserialize(charSource, buf, i, toIndex, null, null, (byte)93, jsonParseContext);
                    if (len >= size) {
                        arr = this.copyOf(arr, size <<= 1);
                    }
                    this.setElementAt(arr, value, len++);
                    i = jsonParseContext.endIndex;
                    int endChar = jsonParseContext.endChar;
                    if (endChar == 0) {
                        while ((b = buf[++i]) <= 32) {
                        }
                        if (allowComment && b == 47) {
                            i = ArrayInstanceDeserializer.clearCommentAndWhiteSpaces(buf, i + 1, toIndex, jsonParseContext);
                            b = buf[i];
                        }
                    } else {
                        b = (byte)endChar;
                        jsonParseContext.endChar = 0;
                    }
                    if (b != 44) {
                        if (b == 93) {
                            jsonParseContext.endIndex = i;
                            return this.subOf(arr, len);
                        }
                        String errorContextTextAt = ArrayInstanceDeserializer.createErrorContextText(buf, i);
                        throw new JSONException("Syntax error, at pos " + i + ", context text by '" + errorContextTextAt + "', unexpected '" + (char)b + "', expected ',' or ']'");
                    }
                    ++i;
                }
            }
        }
    }

    static class BinaryDeserializer
    extends JSONTypeDeserializer {
        BinaryDeserializer() {
        }

        @Override
        protected Object valueOf(String value, Class<?> actualType) {
            return value.getBytes();
        }

        @Override
        protected Object deserialize(CharSource charSource, char[] buf, int fromIndex, int toIndex, GenericParameterizedType parameterizedType, Object instance, char endToken, JSONParseContext jsonParseContext) throws Exception {
            char beginChar = buf[fromIndex];
            switch (beginChar) {
                case 'n': {
                    return NULL.deserialize(null, buf, fromIndex, toIndex, null, null, jsonParseContext);
                }
                case '\"': {
                    CHAR_SEQUENCE.skip(charSource, buf, fromIndex, beginChar, jsonParseContext);
                    int endStringIndex = jsonParseContext.endIndex;
                    byte[] bytes = BinaryDeserializer.parseBytesOfBuf0(fromIndex, endStringIndex - fromIndex - 1, buf, jsonParseContext);
                    return bytes;
                }
                case '[': {
                    Byte[] target = (Byte[])ARRAY.deserialize(charSource, buf, fromIndex, toIndex, GenericParameterizedType.arrayType(Byte.class), null, '\u0000', jsonParseContext);
                    byte[] bytes = new byte[target.length];
                    int len = bytes.length;
                    for (int i = 0; i < len; ++i) {
                        bytes[i] = target[i];
                    }
                    return bytes;
                }
            }
            throw new JSONException("Syntax error, from pos " + fromIndex + ", the beginChar '" + beginChar + "' mismatch type byte[] or Byte[] ");
        }

        @Override
        protected Object deserialize(CharSource charSource, byte[] buf, int fromIndex, int toIndex, GenericParameterizedType parameterizedType, Object instance, byte endToken, JSONParseContext jsonParseContext) throws Exception {
            byte beginByte = buf[fromIndex];
            char beginChar = (char)beginByte;
            switch (beginChar) {
                case 'n': {
                    return BinaryDeserializer.parseNull(buf, fromIndex, toIndex, jsonParseContext);
                }
                case '\"': 
                case '\'': {
                    CHAR_SEQUENCE.skip(charSource, buf, fromIndex, (int)beginChar, jsonParseContext);
                    int endStringIndex = jsonParseContext.endIndex;
                    byte[] bytes = BinaryDeserializer.parseBytesOfBuf0(fromIndex, endStringIndex - fromIndex - 1, buf, jsonParseContext);
                    return bytes;
                }
                case '[': {
                    Byte[] target = (Byte[])ARRAY.deserialize(charSource, buf, fromIndex, toIndex, GenericParameterizedType.arrayType(Byte.class), null, endToken, jsonParseContext);
                    byte[] bytes = new byte[target.length];
                    int len = bytes.length;
                    for (int i = 0; i < len; ++i) {
                        bytes[i] = target[i];
                    }
                    return bytes;
                }
            }
            throw new JSONException("Syntax error, from pos " + fromIndex + ", the beginChar '" + beginChar + "' mismatch type byte[] or Byte[] ");
        }

        private static byte[] parseBytesOfBuf0(int fromIndex, int len, char[] buf, JSONParseContext jsonParseContext) {
            if (jsonParseContext.byteArrayFromHexString) {
                return BinaryDeserializer.hexString2Bytes(buf, fromIndex + 1, len);
            }
            byte[] bytes = new byte[len];
            int offset = fromIndex + 1;
            for (int i = 0; i < len; ++i) {
                bytes[i] = (byte)buf[offset + i];
            }
            return Base64.getDecoder().decode(bytes);
        }

        private static byte[] parseBytesOfBuf0(int fromIndex, int len, byte[] buf, JSONParseContext jsonParseContext) {
            if (jsonParseContext.byteArrayFromHexString) {
                return BinaryDeserializer.hexString2Bytes(buf, fromIndex + 1, len);
            }
            int offset = fromIndex + 1;
            byte[] bytes = Arrays.copyOfRange(buf, offset, offset + len);
            return Base64.getDecoder().decode(bytes);
        }
    }

    static class AnnotationDeserializer
    extends JSONTypeDeserializer {
        AnnotationDeserializer() {
        }

        @Override
        protected Object valueOf(String value, Class<?> actualType) {
            return null;
        }

        @Override
        protected Object deserialize(CharSource charSource, char[] buf, int fromIndex, int toIndex, GenericParameterizedType parameterizedType, Object defaultValue, char endToken, JSONParseContext jsonParseContext) throws Exception {
            ANY.skip(charSource, buf, fromIndex, toIndex, endToken, jsonParseContext);
            return null;
        }

        @Override
        protected Object deserialize(CharSource charSource, byte[] buf, int fromIndex, int toIndex, GenericParameterizedType parameterizedType, Object defaultValue, byte endToken, JSONParseContext jsonParseContext) throws Exception {
            ANY.skip(charSource, buf, fromIndex, toIndex, endToken, jsonParseContext);
            return null;
        }
    }

    static class ClassDeserializer
    extends JSONTypeDeserializer {
        ClassDeserializer() {
        }

        @Override
        protected Object valueOf(String value, Class<?> actualType) throws ClassNotFoundException {
            return Class.forName(value);
        }

        @Override
        protected Object deserialize(CharSource charSource, char[] buf, int fromIndex, int toIndex, GenericParameterizedType parameterizedType, Object defaultValue, char endToken, JSONParseContext jsonParseContext) throws Exception {
            char beginChar = buf[fromIndex];
            if (beginChar == '\"') {
                String name = (String)CHAR_SEQUENCE_STRING.deserializeString(charSource, buf, fromIndex, toIndex, beginChar, GenericParameterizedType.StringType, jsonParseContext);
                return Class.forName(name);
            }
            if (beginChar == 'n') {
                return NULL.deserialize(null, buf, fromIndex, toIndex, null, null, jsonParseContext);
            }
            String errorContextTextAt = ClassDeserializer.createErrorContextText(buf, fromIndex);
            throw new JSONException("Syntax error, at pos " + fromIndex + ", context text by '" + errorContextTextAt + "', unexpected '" + beginChar + "' for Class Type, expected '\"' ");
        }

        @Override
        protected Object deserialize(CharSource charSource, byte[] buf, int fromIndex, int toIndex, GenericParameterizedType parameterizedType, Object defaultValue, byte endToken, JSONParseContext jsonParseContext) throws Exception {
            byte beginByte = buf[fromIndex];
            if (beginByte == 34) {
                String name = (String)CHAR_SEQUENCE_STRING.deserializeString(charSource, buf, fromIndex, toIndex, beginByte, GenericParameterizedType.StringType, jsonParseContext);
                return Class.forName(name);
            }
            if (beginByte == 110) {
                return ClassDeserializer.parseNull(buf, fromIndex, toIndex, jsonParseContext);
            }
            String errorContextTextAt = ClassDeserializer.createErrorContextText(buf, fromIndex);
            throw new JSONException("Syntax error, at pos " + fromIndex + ", context text by '" + errorContextTextAt + "', unexpected '" + (char)beginByte + "' for Class Type, expected '\"' ");
        }
    }

    static class EnumDeserializer
    extends JSONTypeDeserializer {
        EnumDeserializer() {
        }

        @Override
        protected Object valueOf(String value, Class<?> actualType) {
            Class<?> enumCls = actualType;
            return Enum.valueOf(enumCls, value);
        }

        protected Enum deserializeEnumName(CharSource charSource, char[] buf, int fromIndex, int toIndex, Class enumCls, JSONParseContext jsonParseContext) throws Exception {
            String name = (String)CHAR_SEQUENCE.deserializeString(charSource, buf, fromIndex, toIndex, '\"', GenericParameterizedType.StringType, jsonParseContext);
            try {
                return Enum.valueOf(enumCls, name);
            }
            catch (RuntimeException exception) {
                if (jsonParseContext.unknownEnumAsNull) {
                    return null;
                }
                throw exception;
            }
        }

        protected Enum deserializeEnumName(CharSource charSource, byte[] buf, int fromIndex, int toIndex, Class enumCls, JSONParseContext jsonParseContext) throws Exception {
            String name = (String)CHAR_SEQUENCE.deserializeString(charSource, buf, fromIndex, toIndex, 34, GenericParameterizedType.StringType, jsonParseContext);
            try {
                return Enum.valueOf(enumCls, name);
            }
            catch (RuntimeException exception) {
                if (jsonParseContext.unknownEnumAsNull) {
                    return null;
                }
                throw exception;
            }
        }

        @Override
        protected Object deserialize(CharSource charSource, char[] buf, int fromIndex, int toIndex, GenericParameterizedType parameterizedType, Object instance, char endToken, JSONParseContext jsonParseContext) throws Exception {
            char beginChar = buf[fromIndex];
            Class<?> clazz = parameterizedType.getActualType();
            if (beginChar == '\"') {
                return this.deserializeEnumName(charSource, buf, fromIndex, toIndex, clazz, jsonParseContext);
            }
            if (beginChar == 'n') {
                return NULL.deserialize(null, buf, fromIndex, toIndex, null, null, jsonParseContext);
            }
            Integer ordinal = (Integer)NUMBER_INTEGER.deserialize(charSource, buf, fromIndex, toIndex, GenericParameterizedType.IntType, null, endToken, jsonParseContext);
            Enum[] values = (Enum[])this.getEnumConstants(clazz);
            if (values != null && ordinal < values.length) {
                return values[ordinal];
            }
            throw new JSONException("Syntax error, at pos " + fromIndex + ", ordinal " + ordinal + " cannot convert to Enum " + clazz + "");
        }

        protected Object getEnumConstants(Class clazz) {
            return clazz.getEnumConstants();
        }

        @Override
        protected Object deserialize(CharSource charSource, byte[] buf, int fromIndex, int toIndex, GenericParameterizedType parameterizedType, Object instance, byte endToken, JSONParseContext jsonParseContext) throws Exception {
            byte b = buf[fromIndex];
            Class<?> clazz = parameterizedType.getActualType();
            if (b == 34) {
                return this.deserializeEnumName(charSource, buf, fromIndex, toIndex, clazz, jsonParseContext);
            }
            if (b == 110) {
                return NULL.deserialize(null, buf, fromIndex, toIndex, null, null, jsonParseContext);
            }
            Integer ordinal = (Integer)NUMBER_INTEGER.deserialize(charSource, buf, fromIndex, toIndex, GenericParameterizedType.IntType, null, endToken, jsonParseContext);
            Enum[] values = (Enum[])clazz.getEnumConstants();
            if (values != null && ordinal < values.length) {
                return values[ordinal];
            }
            throw new JSONException("Syntax error, at pos " + fromIndex + ", ordinal " + ordinal + " cannot convert to Enum " + clazz + "");
        }

        static class EnumInstanceDeserializer
        extends EnumDeserializer {
            private final Enum[] values;
            protected final JSONValueMatcher<Enum> enumValueMatcher;

            public EnumInstanceDeserializer(Enum[] values, JSONValueMatcher<Enum> enumValueMatcher) {
                this.values = values;
                this.enumValueMatcher = enumValueMatcher;
            }

            @Override
            protected Object getEnumConstants(Class clazz) {
                return this.values;
            }

            @Override
            protected Enum deserializeEnumName(CharSource charSource, char[] buf, int fromIndex, int toIndex, Class enumCls, JSONParseContext jsonParseContext) throws Exception {
                int begin;
                int i = begin = fromIndex + 1;
                Enum value = this.enumValueMatcher.matchValue(charSource, buf, i, 34, jsonParseContext);
                i = jsonParseContext.endIndex;
                if (value == null) {
                    if (buf[i - 1] == '\\') {
                        char ch;
                        char prev = '\u0000';
                        while ((ch = buf[++i]) != '\"' || prev == '\\') {
                            prev = ch;
                        }
                    }
                    jsonParseContext.endIndex = i;
                    if (jsonParseContext.unknownEnumAsNull) {
                        return null;
                    }
                    String errorContextTextAt = EnumInstanceDeserializer.createErrorContextText(buf, fromIndex);
                    throw new JSONException("Syntax error, at pos " + fromIndex + ", context text by '" + errorContextTextAt + "', unknown Enum name '" + new String(buf, fromIndex + 1, i - fromIndex - 1) + "' of EnumType " + enumCls);
                }
                jsonParseContext.endIndex = i;
                return value;
            }

            @Override
            protected Enum deserializeEnumName(CharSource charSource, byte[] buf, int fromIndex, int toIndex, Class enumCls, JSONParseContext jsonParseContext) throws Exception {
                int begin;
                int i = begin = fromIndex + 1;
                Enum value = this.enumValueMatcher.matchValue(charSource, buf, i, 34, jsonParseContext);
                i = jsonParseContext.endIndex;
                if (value == null) {
                    if (buf[i - 1] == 92) {
                        byte b;
                        byte prev = 0;
                        while ((b = buf[++i]) != 34 || prev == 92) {
                            prev = b;
                        }
                    }
                    jsonParseContext.endIndex = i;
                    if (jsonParseContext.unknownEnumAsNull) {
                        return null;
                    }
                    String errorContextTextAt = EnumInstanceDeserializer.createErrorContextText(buf, fromIndex);
                    throw new JSONException("Syntax error, at pos " + fromIndex + ", context text by '" + errorContextTextAt + "', unknown Enum name '" + new String(buf, fromIndex + 1, i - fromIndex - 1) + "' of EnumType " + enumCls);
                }
                jsonParseContext.endIndex = i;
                return value;
            }
        }
    }

    static class DateDeserializer
    extends JSONTypeDeserializer {
        DateDeserializer() {
        }

        @Override
        protected Object valueOf(String value, Class<?> actualType) {
            return DateDeserializer.matchDate(DateDeserializer.getChars(value), 0, value.length(), null, actualType);
        }

        protected Object deserializeDate(char[] buf, int from, int to, Class<? extends Date> dateCls) {
            return DateDeserializer.matchDate(buf, from + 1, to - 1, null, dateCls);
        }

        protected Object deserializeDate(byte[] buf, int from, int to, Class<? extends Date> dateCls) {
            return DateDeserializer.matchDate(buf, from + 1, to - 1, null, dateCls);
        }

        @Override
        protected Object deserialize(CharSource charSource, char[] buf, int fromIndex, int toIndex, GenericParameterizedType parameterizedType, Object instance, char endToken, JSONParseContext jsonParseContext) throws Exception {
            char beginChar = buf[fromIndex];
            switch (beginChar) {
                case '\"': {
                    CHAR_SEQUENCE.skip(charSource, buf, fromIndex, beginChar, jsonParseContext);
                    int endStringIndex = jsonParseContext.endIndex;
                    Class<?> dateCls = parameterizedType.getActualType();
                    return this.deserializeDate(buf, fromIndex, endStringIndex + 1, dateCls);
                }
                case 'n': {
                    return NULL.deserialize(null, buf, fromIndex, toIndex, null, null, jsonParseContext);
                }
                case '{': {
                    return OBJECT.deserializeObject(charSource, buf, fromIndex, toIndex, parameterizedType, instance, jsonParseContext);
                }
            }
            long timestamp = (Long)NUMBER_LONG.deserialize(charSource, buf, fromIndex, toIndex, GenericParameterizedType.LongType, null, endToken, jsonParseContext);
            return DateDeserializer.parseDate(timestamp, parameterizedType.getActualType());
        }

        @Override
        protected Object deserialize(CharSource charSource, byte[] bytes, int fromIndex, int toIndex, GenericParameterizedType parameterizedType, Object instance, byte endToken, JSONParseContext jsonParseContext) throws Exception {
            byte beginByte = bytes[fromIndex];
            switch (beginByte) {
                case 34: 
                case 39: {
                    CHAR_SEQUENCE.skip(charSource, bytes, fromIndex, beginByte, jsonParseContext);
                    int endStringIndex = jsonParseContext.endIndex;
                    Class<?> dateCls = parameterizedType.getActualType();
                    return this.deserializeDate(bytes, fromIndex, endStringIndex + 1, dateCls);
                }
                case 110: {
                    return DateDeserializer.parseNull(bytes, fromIndex, toIndex, jsonParseContext);
                }
                case 123: {
                    return OBJECT.deserializeObject(charSource, bytes, fromIndex, toIndex, parameterizedType, instance, jsonParseContext);
                }
            }
            long timestamp = (Long)NUMBER_LONG.deserialize(charSource, bytes, fromIndex, toIndex, GenericParameterizedType.LongType, null, endToken, jsonParseContext);
            return DateDeserializer.parseDate(timestamp, parameterizedType.getActualType());
        }

        static class DateInstanceDeserializer
        extends DateDeserializer {
            String pattern;
            int patternType;
            DateTemplate dateTemplate;
            String timezone;

            public DateInstanceDeserializer(GenericParameterizedType genericParameterizedType, JsonProperty property) {
                String patternAt;
                genericParameterizedType.getClass();
                String timezoneAt = property.timezone().trim();
                if (timezoneAt.length() > 0) {
                    this.timezone = timezoneAt;
                }
                if ((patternAt = property.pattern().trim()).length() > 0) {
                    this.pattern = patternAt;
                    this.patternType = DateInstanceDeserializer.getPatternType(this.pattern);
                }
                if (this.patternType == 4) {
                    this.dateTemplate = new DateTemplate(this.pattern);
                }
            }

            @Override
            protected Object valueOf(String value, Class<?> actualType) {
                return DateInstanceDeserializer.parseDateValueOfString(DateInstanceDeserializer.getChars(value), -1, value.length() + 1, this.pattern, this.patternType, this.dateTemplate, this.timezone, actualType);
            }

            @Override
            protected Object deserializeDate(char[] buf, int from, int to, Class<? extends Date> dateCls) {
                return DateInstanceDeserializer.parseDateValueOfString(buf, from, to, this.pattern, this.patternType, this.dateTemplate, this.timezone, dateCls);
            }

            @Override
            protected Object deserializeDate(byte[] buf, int from, int to, Class<? extends Date> dateCls) {
                return DateInstanceDeserializer.parseDateValueOfString(buf, from, to, this.pattern, this.patternType, this.dateTemplate, this.timezone, dateCls);
            }
        }
    }

    static class BooleanDeserializer
    extends JSONTypeDeserializer {
        BooleanDeserializer() {
        }

        @Override
        protected Object valueOf(String value, Class<?> actualType) {
            return value.equals("true");
        }

        @Override
        protected Object deserialize(CharSource charSource, char[] buf, int fromIndex, int toIndex, GenericParameterizedType parameterizedType, Object instance, char endToken, JSONParseContext jsonParseContext) throws Exception {
            char beginChar = buf[fromIndex];
            if (beginChar == 't') {
                return this.deserializeTrue(buf, fromIndex, toIndex, parameterizedType, jsonParseContext);
            }
            if (beginChar == 'f') {
                return this.deserializeFalse(buf, fromIndex, toIndex, parameterizedType, jsonParseContext);
            }
            String errorContextTextAt = BooleanDeserializer.createErrorContextText(buf, fromIndex);
            throw new JSONException("Syntax error, at pos " + fromIndex + ", context text by '" + errorContextTextAt + "', unexpected '" + beginChar + "' for Boolean Type, expected 't' or 'f'");
        }

        @Override
        protected Object deserialize(CharSource charSource, byte[] buf, int fromIndex, int toIndex, GenericParameterizedType parameterizedType, Object instance, byte endToken, JSONParseContext jsonParseContext) throws Exception {
            byte beginByte = buf[fromIndex];
            if (beginByte == 116) {
                return BooleanDeserializer.parseTrue(buf, fromIndex, toIndex, jsonParseContext);
            }
            if (beginByte == 102) {
                return BooleanDeserializer.parseFalse(buf, fromIndex, toIndex, jsonParseContext);
            }
            String errorContextTextAt = BooleanDeserializer.createErrorContextText(buf, fromIndex);
            throw new JSONException("Syntax error, at pos " + fromIndex + ", context text by '" + errorContextTextAt + "', unexpected '" + (char)beginByte + "' for Boolean Type, expected 't' or 'f'");
        }

        Object deserializeTrue(char[] buf, int fromIndex, int toIndex, GenericParameterizedType parameterizedType, JSONParseContext jsonParseContext) throws Exception {
            int endIndex = fromIndex + 3;
            if (JSONUnsafe.getLong(buf, fromIndex) == TRUE_LONG) {
                jsonParseContext.endIndex = endIndex;
                return true;
            }
            int len = Math.min(toIndex - fromIndex + 1, 4);
            throw new JSONException("Syntax error, at pos " + fromIndex + ", expected 'true' because it starts with 't', but found text '" + new String(buf, fromIndex, len) + "'");
        }

        Object deserializeFalse(char[] buf, int fromIndex, int toIndex, GenericParameterizedType parameterizedType, JSONParseContext jsonParseContext) throws Exception {
            int endIndex = fromIndex + 4;
            if (JSONUnsafe.getLong(buf, fromIndex + 1) == ALSE_LONG) {
                jsonParseContext.endIndex = endIndex;
                return false;
            }
            int len = Math.min(toIndex - fromIndex + 1, 5);
            throw new JSONException("Syntax error, at pos " + fromIndex + ", expected 'false' because it starts with 'f', but found text '" + new String(buf, fromIndex, len) + "'");
        }
    }

    static class NumberDeserializer
    extends JSONTypeDeserializer {
        protected NumberDeserializer() {
        }

        @Override
        protected Object valueOf(String value, Class<?> actualType) {
            return Double.parseDouble(value);
        }

        @Override
        protected Object deserialize(CharSource charSource, char[] buf, int fromIndex, int toIndex, GenericParameterizedType parameterizedType, Object instance, char endToken, JSONParseContext jsonParseContext) throws Exception {
            char beginChar = buf[fromIndex];
            switch (beginChar) {
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': {
                    return this.deserializeNumber((long)(beginChar - 48), false, 1, buf, fromIndex++, fromIndex, toIndex, parameterizedType, endToken, jsonParseContext);
                }
            }
            switch (beginChar) {
                case '+': 
                case '0': {
                    return this.deserializeNumber(0L, false, 0, buf, fromIndex++, fromIndex, toIndex, parameterizedType, endToken, jsonParseContext);
                }
                case '-': {
                    return this.deserializeNumber(0L, true, 0, buf, fromIndex++, fromIndex, toIndex, parameterizedType, endToken, jsonParseContext);
                }
                case '\"': {
                    char ch = buf[++fromIndex];
                    if (ch == '\"') {
                        if (jsonParseContext.unMatchedEmptyAsNull) {
                            jsonParseContext.endIndex = fromIndex;
                            return null;
                        }
                        throw new JSONException("Syntax error, at pos " + fromIndex + ", unexpected empty string '\"\"' when parsing a number, use ReadOption.UnMatchedEmptyAsNull to support");
                    }
                    Number result = (Number)this.deserialize(charSource, buf, fromIndex, toIndex, parameterizedType, instance, '\"', jsonParseContext);
                    int endIndex = jsonParseContext.endIndex;
                    if (buf[++endIndex] != '\"') {
                        throw new JSONException("Syntax error, for input: \"" + new String(buf, fromIndex, endIndex - fromIndex) + "\", unable to convert to number");
                    }
                    jsonParseContext.endIndex = endIndex;
                    return ObjectUtils.toTypeNumber(result, parameterizedType.getActualType());
                }
                case 'n': {
                    NULL.deserialize(null, buf, fromIndex, toIndex, null, null, jsonParseContext);
                    if (parameterizedType.getActualType().isPrimitive()) {
                        return (byte)0;
                    }
                    return null;
                }
            }
            throw new JSONException("Syntax error, at pos " + fromIndex + ", unexpected character '" + beginChar + "' when parsing a number");
        }

        @Override
        protected Object deserialize(CharSource charSource, byte[] buf, int fromIndex, int toIndex, GenericParameterizedType parameterizedType, Object instance, byte endToken, JSONParseContext jsonParseContext) throws Exception {
            byte beginByte = buf[fromIndex];
            switch (beginByte) {
                case 49: 
                case 50: 
                case 51: 
                case 52: 
                case 53: 
                case 54: 
                case 55: 
                case 56: 
                case 57: {
                    return this.deserializeNumber((long)(beginByte - 48), false, 1, buf, fromIndex++, fromIndex, toIndex, parameterizedType, endToken, jsonParseContext);
                }
                case 43: 
                case 48: {
                    return this.deserializeNumber(0L, false, 0, buf, fromIndex++, fromIndex, toIndex, parameterizedType, endToken, jsonParseContext);
                }
                case 45: {
                    return this.deserializeNumber(0L, true, 0, buf, fromIndex++, fromIndex, toIndex, parameterizedType, endToken, jsonParseContext);
                }
                case 34: {
                    byte b = buf[++fromIndex];
                    if (b == 34) {
                        throw new JSONException("Syntax error, at pos " + fromIndex + ", unexpected character '\"' when parsing a number");
                    }
                    Number result = (Number)this.deserialize(charSource, buf, fromIndex, toIndex, parameterizedType, instance, (byte)34, jsonParseContext);
                    int endIndex = jsonParseContext.endIndex;
                    if (buf[++endIndex] != 34) {
                        throw new JSONException("For input string: \"" + new String(buf, fromIndex, endIndex - fromIndex) + "\"");
                    }
                    jsonParseContext.endIndex = endIndex;
                    return result;
                }
                case 110: {
                    NULL.deserialize(null, buf, fromIndex, toIndex, null, null, jsonParseContext);
                    if (parameterizedType.getActualType().isPrimitive()) {
                        return (byte)0;
                    }
                    return null;
                }
            }
            throw new JSONException("Syntax error, at pos " + fromIndex + ", unexpected character '" + beginByte + "' when parsing a number");
        }

        Number deserializeDefault0(char[] buf, int fromIndex, int toIndex, int offset, long val, int cnt, boolean negative, char endToken, int returnType, JSONParseContext jsonParseContext) throws Exception {
            int endIndex;
            char ch;
            int i;
            int specifySuffix;
            int mode;
            boolean expNegative;
            int expValue;
            int decimalCount;
            long value;
            block52: {
                block53: {
                    value = val;
                    decimalCount = 0;
                    expValue = 0;
                    expNegative = false;
                    mode = 0;
                    specifySuffix = 0;
                    i = offset;
                    while (NumberDeserializer.isDigit(ch = buf[i])) {
                        value = (value << 3) + (value << 1) + (long)ch - 48L;
                        ++cnt;
                        ++i;
                    }
                    if (ch == '.') {
                        mode = 1;
                        while (NumberDeserializer.isDigit(ch = buf[++i])) {
                            value = (value << 3) + (value << 1) + (long)ch - 48L;
                            ++decimalCount;
                            ++cnt;
                        }
                    }
                    if (ch <= ' ') {
                        while ((ch = buf[++i]) <= ' ') {
                        }
                    }
                    if (ch == ',' || ch == endToken) break block52;
                    if (ch != 'E' && ch != 'e') break block53;
                    mode = 2;
                    if ((expNegative = (ch = buf[++i]) == '-') || ch == '+') {
                        ch = buf[++i];
                    }
                    if (NumberDeserializer.isDigit(ch)) {
                        expValue = ch - 48;
                        while (NumberDeserializer.isDigit(ch = buf[++i])) {
                            expValue = (expValue << 3) + (expValue << 1) + ch - 48;
                        }
                    }
                    if (ch == ',' || ch == endToken) break block52;
                }
                switch (ch) {
                    case 'L': 
                    case 'l': {
                        specifySuffix = 1;
                        while ((ch = buf[++i]) <= ' ') {
                        }
                        if (ch == ',' || ch == endToken) break;
                        String contextErrorAt = NumberDeserializer.createErrorContextText(buf, i);
                        throw new JSONException("For input string: \"" + new String(buf, fromIndex, i - fromIndex + 1) + "\", expected ',' or '" + endToken + "', but found '" + ch + "', context text by '" + contextErrorAt + "'");
                    }
                    case 'F': 
                    case 'f': {
                        specifySuffix = 2;
                        while ((ch = buf[++i]) <= ' ') {
                        }
                        if (ch == ',' || ch == endToken) break;
                        String contextErrorAt = NumberDeserializer.createErrorContextText(buf, i);
                        throw new JSONException("For input string: \"" + new String(buf, fromIndex, i - fromIndex + 1) + "\", expected ',' or '" + endToken + "', but found '" + ch + "', context text by '" + contextErrorAt + "'");
                    }
                    case 'D': 
                    case 'd': {
                        specifySuffix = 3;
                        while ((ch = buf[++i]) <= ' ') {
                        }
                        if (ch == ',' || ch == endToken) break;
                        String contextErrorAt = NumberDeserializer.createErrorContextText(buf, i);
                        throw new JSONException("For input string: \"" + new String(buf, fromIndex, i - fromIndex + 1) + "\", expected ',' or '" + endToken + "', but found '" + ch + "', context text by '" + contextErrorAt + "'");
                    }
                    default: {
                        String contextErrorAt = NumberDeserializer.createErrorContextText(buf, i);
                        throw new JSONException("For input string: \"" + new String(buf, fromIndex, i - fromIndex + 1) + "\", expected ',' or '" + endToken + "', but found '" + ch + "', context text by '" + contextErrorAt + "'");
                    }
                }
            }
            jsonParseContext.endIndex = endIndex = i - 1;
            if (returnType == 4) {
                if (cnt > 19) {
                    value = 0L;
                    cnt = 0;
                    int j = fromIndex;
                    int decimalPointIndex = endIndex;
                    decimalCount = 0;
                    while (true) {
                        if (NumberDeserializer.isDigit(ch = buf[j])) {
                            value = value * 10L + (long)ch - 48L;
                            ++cnt;
                            if (j > decimalPointIndex) {
                                ++decimalCount;
                            }
                        } else if (ch == '.') {
                            decimalPointIndex = j;
                        }
                        if (cnt == 18) break;
                        ++j;
                    }
                }
                double dv = NumberUtils.scientificToIEEEDouble(value, expNegative ? expValue + decimalCount : decimalCount - expValue);
                return negative ? -dv : dv;
            }
            switch (returnType) {
                case 1: {
                    if (cnt > 19) {
                        while (buf[endIndex] <= ' ') {
                            --endIndex;
                        }
                        return new BigDecimal(new String(buf, fromIndex, endIndex - fromIndex + 1));
                    }
                    value = negative ? -value : value;
                    return new BigDecimal(BigInteger.valueOf(value), expNegative ? expValue + decimalCount : decimalCount - expValue);
                }
                case 2: {
                    if (cnt > 19) {
                        while (buf[endIndex] <= ' ') {
                            --endIndex;
                        }
                        return new BigInteger(new String(buf, fromIndex, endIndex - fromIndex + 1));
                    }
                    value = negative ? -value : value;
                    return BigInteger.valueOf(value);
                }
                case 3: {
                    float fv = NumberUtils.scientificToIEEEFloat(value, expNegative ? expValue + decimalCount : decimalCount - expValue);
                    return Float.valueOf(negative ? -fv : fv);
                }
            }
            if (mode == 0) {
                if (cnt > 19) {
                    while (buf[endIndex] <= ' ') {
                        --endIndex;
                    }
                    return new BigInteger(new String(buf, fromIndex, endIndex - fromIndex + 1));
                }
                long l = value = negative ? -value : value;
                if (specifySuffix > 0) {
                    switch (specifySuffix) {
                        case 1: {
                            return value;
                        }
                        case 2: {
                            return Float.valueOf(value);
                        }
                    }
                    return value;
                }
                if (value <= Integer.MAX_VALUE && value > Integer.MIN_VALUE) {
                    return (int)value;
                }
                return value;
            }
            if (cnt > 19) {
                while (buf[endIndex] <= ' ') {
                    --endIndex;
                }
                return new BigDecimal(buf, fromIndex, endIndex - fromIndex + 1);
            }
            expValue = expNegative ? -expValue - decimalCount : expValue - decimalCount;
            double doubleVal = NumberUtils.scientificToIEEEDouble(value, -expValue);
            double d = doubleVal = negative ? -doubleVal : doubleVal;
            if (specifySuffix > 0) {
                switch (specifySuffix) {
                    case 1: {
                        return (long)doubleVal;
                    }
                    case 2: {
                        return Float.valueOf((float)doubleVal);
                    }
                }
                return doubleVal;
            }
            return doubleVal;
        }

        Number deserializeDefault0(byte[] buf, int fromIndex, int toIndex, int offset, long val, int cnt, boolean negative, byte endToken, int returnType, JSONParseContext jsonParseContext) throws Exception {
            int endIndex;
            byte b;
            int i;
            int specifySuffix;
            int mode;
            boolean expNegative;
            int expValue;
            int decimalCount;
            long value;
            block54: {
                block55: {
                    boolean isDigit;
                    value = val;
                    decimalCount = 0;
                    expValue = 0;
                    expNegative = false;
                    mode = 0;
                    specifySuffix = 0;
                    i = offset;
                    byte b1 = 0;
                    while ((isDigit = NumberDeserializer.isDigit(b = buf[i])) && NumberDeserializer.isDigit(b1 = buf[++i])) {
                        value = value * 100L + (long)(b * 10) + (long)b1 - 528L;
                        cnt += 2;
                        ++i;
                    }
                    if (isDigit) {
                        value = (value << 3) + (value << 1) + (long)b - 48L;
                        b = b1;
                        ++cnt;
                    }
                    if (b == 46) {
                        mode = 1;
                        while ((isDigit = NumberDeserializer.isDigit(b = buf[++i])) && NumberDeserializer.isDigit(b1 = buf[++i])) {
                            value = value * 100L + (long)(b * 10) + (long)b1 - 528L;
                            cnt += 2;
                            decimalCount += 2;
                        }
                        if (isDigit) {
                            value = (value << 3) + (value << 1) + (long)b - 48L;
                            b = b1;
                            ++cnt;
                            ++decimalCount;
                        }
                    }
                    if (b <= 32) {
                        while ((b = buf[++i]) <= 32) {
                        }
                    }
                    if (b == 44 || b == endToken) break block54;
                    if (b != 69 && b != 101) break block55;
                    mode = 2;
                    if ((expNegative = (b = buf[++i]) == 45) || b == 43) {
                        b = buf[++i];
                    }
                    if (NumberDeserializer.isDigit(b)) {
                        expValue = b - 48;
                        while (NumberDeserializer.isDigit(b = buf[++i])) {
                            expValue = (expValue << 3) + (expValue << 1) + b - 48;
                        }
                    }
                    if (b == 44 || b == endToken) break block54;
                }
                switch (b) {
                    case 76: 
                    case 108: {
                        specifySuffix = 1;
                        while ((b = buf[++i]) <= 32) {
                        }
                        if (b == 44 || b == endToken) break;
                        String contextErrorAt = NumberDeserializer.createErrorContextText(buf, i);
                        throw new JSONException("For input string: \"" + new String(buf, fromIndex, i - fromIndex + 1) + "\", expected ',' or '" + (char)endToken + "', but found '" + (char)b + "', context text by '" + contextErrorAt + "'");
                    }
                    case 70: 
                    case 102: {
                        specifySuffix = 2;
                        while ((b = buf[++i]) <= 32) {
                        }
                        if (b == 44 || b == endToken) break;
                        String contextErrorAt = NumberDeserializer.createErrorContextText(buf, i);
                        throw new JSONException("For input string: \"" + new String(buf, fromIndex, i - fromIndex + 1) + "\", expected ',' or '" + (char)endToken + "', but found '" + (char)b + "', context text by '" + contextErrorAt + "'");
                    }
                    case 68: 
                    case 100: {
                        specifySuffix = 3;
                        while ((b = buf[++i]) <= 32) {
                        }
                        if (b == 44 || b == endToken) break;
                        String contextErrorAt = NumberDeserializer.createErrorContextText(buf, i);
                        throw new JSONException("For input string: \"" + new String(buf, fromIndex, i - fromIndex + 1) + "\", expected ',' or '" + (char)endToken + "', but found '" + (char)b + "', context text by '" + contextErrorAt + "'");
                    }
                    default: {
                        String contextErrorAt = NumberDeserializer.createErrorContextText(buf, i);
                        throw new JSONException("For input string: \"" + new String(buf, fromIndex, i - fromIndex + 1) + "\", expected ',' or '" + (char)endToken + "', but found '" + (char)b + "', context text by '" + contextErrorAt + "'");
                    }
                }
            }
            jsonParseContext.endIndex = endIndex = i - 1;
            if (returnType == 4) {
                if (cnt > 19) {
                    value = 0L;
                    cnt = 0;
                    int j = fromIndex;
                    int decimalPointIndex = endIndex;
                    decimalCount = 0;
                    while (true) {
                        if (NumberDeserializer.isDigit(b = buf[j])) {
                            value = value * 10L + (long)b - 48L;
                            ++cnt;
                            if (j > decimalPointIndex) {
                                ++decimalCount;
                            }
                        } else if (b == 46) {
                            decimalPointIndex = j;
                        }
                        if (cnt == 18) break;
                        ++j;
                    }
                }
                double dv = NumberUtils.scientificToIEEEDouble(value, expNegative ? expValue + decimalCount : decimalCount - expValue);
                return negative ? -dv : dv;
            }
            switch (returnType) {
                case 1: {
                    if (cnt > 19) {
                        while (buf[endIndex] <= 32) {
                            --endIndex;
                        }
                        return new BigDecimal(new String(buf, fromIndex, endIndex - fromIndex + 1));
                    }
                    value = negative ? -value : value;
                    return new BigDecimal(BigInteger.valueOf(value), expNegative ? expValue + decimalCount : decimalCount - expValue);
                }
                case 2: {
                    if (cnt > 19) {
                        while (buf[endIndex] <= 32) {
                            --endIndex;
                        }
                        return new BigInteger(new String(buf, fromIndex, endIndex - fromIndex + 1));
                    }
                    value = negative ? -value : value;
                    return BigInteger.valueOf(value);
                }
                case 3: {
                    float fv = NumberUtils.scientificToIEEEFloat(value, expNegative ? expValue + decimalCount : decimalCount - expValue);
                    return Float.valueOf(negative ? -fv : fv);
                }
            }
            if (mode == 0) {
                if (cnt > 19) {
                    while (buf[endIndex] <= 32) {
                        --endIndex;
                    }
                    return new BigInteger(new String(buf, fromIndex, endIndex - fromIndex + 1));
                }
                long l = value = negative ? -value : value;
                if (specifySuffix > 0) {
                    switch (specifySuffix) {
                        case 1: {
                            return value;
                        }
                        case 2: {
                            return Float.valueOf(value);
                        }
                    }
                    return value;
                }
                if (value <= Integer.MAX_VALUE && value > Integer.MIN_VALUE) {
                    return (int)value;
                }
                return value;
            }
            if (cnt > 19) {
                while (buf[endIndex] <= 32) {
                    --endIndex;
                }
                return new BigDecimal(new String(buf, fromIndex, endIndex - fromIndex + 1));
            }
            expValue = expNegative ? -expValue - decimalCount : expValue - decimalCount;
            double doubleVal = NumberUtils.scientificToIEEEDouble(value, -expValue);
            double d = doubleVal = negative ? -doubleVal : doubleVal;
            if (specifySuffix > 0) {
                switch (specifySuffix) {
                    case 1: {
                        return (long)doubleVal;
                    }
                    case 2: {
                        return Float.valueOf((float)doubleVal);
                    }
                }
                return doubleVal;
            }
            return doubleVal;
        }

        Number deserializeDouble(char[] buf, int fromIndex, char endToken, JSONParseContext jsonParseContext) {
            int endIndex;
            char ch;
            int i = fromIndex;
            while ((ch = buf[i + 1]) != ',' && ch != endToken) {
                ++i;
            }
            jsonParseContext.endIndex = i;
            for (endIndex = i + 1; endIndex > fromIndex && buf[endIndex - 1] <= ' '; --endIndex) {
            }
            int len = endIndex - fromIndex;
            return Double.parseDouble(new String(buf, fromIndex, len));
        }

        protected long deserializeInteger(long value, boolean negative, int cnt, char[] buf, int fromIndex, int toIndex, char endToken, JSONParseContext jsonParseContext) throws Exception {
            char ch;
            boolean isDigit;
            int i = fromIndex;
            char ch1 = '\u0000';
            while ((isDigit = NumberDeserializer.isDigit(ch = buf[i])) && NumberDeserializer.isDigit(ch1 = buf[++i])) {
                value = value * 100L + (long)(ch * 10) + (long)ch1 - 528L;
                ++i;
            }
            if (isDigit) {
                value = (value << 3) + (value << 1) + (long)ch - 48L;
                ch = ch1;
            }
            if (ch == ',' || ch == endToken) {
                jsonParseContext.endIndex = i;
                jsonParseContext.endChar = ch;
                return negative ? -value : value;
            }
            if (ch <= ' ') {
                while ((ch = buf[++i]) <= ' ') {
                }
                if (ch == ',' || ch == endToken) {
                    jsonParseContext.endIndex = i;
                    jsonParseContext.endChar = ch;
                    return negative ? -value : value;
                }
                String contextErrorAt = NumberDeserializer.createErrorContextText(buf, i);
                throw new JSONException("For input string: \"" + new String(buf, fromIndex, i - fromIndex + 1) + "\", expected ',' or '" + endToken + "', but found '" + ch + "', context text by '" + contextErrorAt + "'");
            }
            return this.deserializeDefault0(buf, fromIndex, toIndex, i, value, cnt + i - fromIndex, negative, endToken, 0, jsonParseContext).longValue();
        }

        protected long deserializeInteger(long value, boolean negative, int cnt, byte[] buf, int fromIndex, int toIndex, byte endToken, JSONParseContext jsonParseContext) throws Exception {
            int b;
            boolean isDigit;
            int i = fromIndex;
            int b1 = 0;
            while ((isDigit = NumberDeserializer.isDigit(b = buf[i])) && NumberDeserializer.isDigit(b1 = buf[++i])) {
                value = value * 100L + (long)(b * 10) + (long)b1 - 528L;
                ++i;
            }
            if (isDigit) {
                value = (value << 3) + (value << 1) + (long)b - 48L;
                b = b1;
            }
            if (b == 44 || b == endToken) {
                jsonParseContext.endIndex = i;
                jsonParseContext.endChar = b;
                return negative ? -value : value;
            }
            if (b <= 32) {
                while ((b = buf[++i]) <= 32) {
                }
                if (b == 44 || b == endToken) {
                    jsonParseContext.endIndex = i;
                    jsonParseContext.endChar = b;
                    return negative ? -value : value;
                }
                String contextErrorAt = NumberDeserializer.createErrorContextText(buf, i);
                throw new JSONException("For input string: \"" + new String(buf, fromIndex, i - fromIndex + 1) + "\", expected ',' or '" + endToken + "', but found '" + (char)b + "', context text by '" + contextErrorAt + "'");
            }
            return this.deserializeDefault0(buf, fromIndex, toIndex, i, value, cnt + i - fromIndex, negative, endToken, 0, jsonParseContext).longValue();
        }

        protected Number deserializeNumber(long initValue, boolean negative, int cnt, char[] buf, int fromIndex, int offset, int toIndex, GenericParameterizedType parameterizedType, char endToken, JSONParseContext jsonParseContext) throws Exception {
            if (parameterizedType == GenericParameterizedType.AnyType || parameterizedType == null) {
                return this.deserializeDefault0(buf, fromIndex, toIndex, offset, initValue, cnt, negative, endToken, 0, jsonParseContext);
            }
            if (parameterizedType == GenericParameterizedType.BigDecimalType) {
                return NUMBER_BIGDECIMAL.deserializeNumber(initValue, negative, cnt, buf, fromIndex, offset, toIndex, parameterizedType, endToken, jsonParseContext);
            }
            Number value = this.deserializeDefault0(buf, fromIndex, toIndex, offset, initValue, cnt, negative, endToken, 0, jsonParseContext);
            return ObjectUtils.toTypeNumber(value, parameterizedType.getActualType());
        }

        protected Number deserializeNumber(long initValue, boolean negative, int cnt, byte[] buf, int fromIndex, int offset, int toIndex, GenericParameterizedType parameterizedType, byte endToken, JSONParseContext jsonParseContext) throws Exception {
            if (parameterizedType == GenericParameterizedType.AnyType || parameterizedType == null) {
                return this.deserializeDefault0(buf, fromIndex, toIndex, offset, initValue, cnt, negative, endToken, 0, jsonParseContext);
            }
            if (parameterizedType == GenericParameterizedType.BigDecimalType) {
                return NUMBER_BIGDECIMAL.deserializeNumber(initValue, negative, cnt, buf, fromIndex, offset, toIndex, parameterizedType, endToken, jsonParseContext);
            }
            Number value = this.deserializeDefault0(buf, fromIndex, toIndex, offset, initValue, cnt, negative, endToken, 0, jsonParseContext);
            return ObjectUtils.toTypeNumber(value, parameterizedType.getActualType());
        }

        static class BigIntegerDeserializer
        extends NumberDeserializer {
            BigIntegerDeserializer() {
            }

            @Override
            protected final Number deserializeNumber(long initValue, boolean negative, int cnt, char[] buf, int fromIndex, int offset, int toIndex, GenericParameterizedType parameterizedType, char endToken, JSONParseContext jsonParseContext) throws Exception {
                return this.deserializeDefault0(buf, fromIndex, toIndex, offset, initValue, cnt, negative, endToken, 2, jsonParseContext);
            }

            @Override
            protected final Number deserializeNumber(long initValue, boolean negative, int cnt, byte[] buf, int fromIndex, int offset, int toIndex, GenericParameterizedType parameterizedType, byte endToken, JSONParseContext jsonParseContext) throws Exception {
                return this.deserializeDefault0(buf, fromIndex, toIndex, offset, initValue, cnt, negative, endToken, 2, jsonParseContext);
            }

            @Override
            protected Object valueOf(String value, Class<?> actualType) {
                return new BigInteger(value);
            }
        }

        static class BigDecimalDeserializer
        extends NumberDeserializer {
            BigDecimalDeserializer() {
            }

            @Override
            protected final Number deserializeNumber(long initValue, boolean negative, int cnt, char[] buf, int fromIndex, int offset, int toIndex, GenericParameterizedType parameterizedType, char endToken, JSONParseContext jsonParseContext) throws Exception {
                return this.deserializeDefault0(buf, fromIndex, toIndex, offset, initValue, cnt, negative, endToken, 1, jsonParseContext);
            }

            @Override
            protected final Number deserializeNumber(long initValue, boolean negative, int cnt, byte[] buf, int fromIndex, int offset, int toIndex, GenericParameterizedType parameterizedType, byte endToken, JSONParseContext jsonParseContext) throws Exception {
                return this.deserializeDefault0(buf, fromIndex, toIndex, offset, initValue, cnt, negative, endToken, 1, jsonParseContext);
            }

            @Override
            protected Object valueOf(String value, Class<?> actualType) {
                return new BigDecimal(value);
            }
        }

        static class FloatDeserializer
        extends NumberDeserializer {
            FloatDeserializer() {
            }

            @Override
            protected final Number deserializeNumber(long initValue, boolean negative, int cnt, char[] buf, int fromIndex, int offset, int toIndex, GenericParameterizedType parameterizedType, char endToken, JSONParseContext jsonParseContext) throws Exception {
                return Float.valueOf(this.deserializeDefault0(buf, fromIndex, toIndex, offset, initValue, cnt, negative, endToken, 3, jsonParseContext).floatValue());
            }

            @Override
            protected final Number deserializeNumber(long initValue, boolean negative, int cnt, byte[] buf, int fromIndex, int offset, int toIndex, GenericParameterizedType parameterizedType, byte endToken, JSONParseContext jsonParseContext) throws Exception {
                return Float.valueOf(this.deserializeDefault0(buf, fromIndex, toIndex, offset, initValue, cnt, negative, endToken, 3, jsonParseContext).floatValue());
            }

            @Override
            protected Object valueOf(String value, Class<?> actualType) {
                return Float.valueOf(Float.parseFloat(value));
            }
        }

        static class DoubleDeserializer
        extends NumberDeserializer {
            DoubleDeserializer() {
            }

            @Override
            protected final Number deserializeNumber(long initValue, boolean negative, int cnt, char[] buf, int fromIndex, int offset, int toIndex, GenericParameterizedType parameterizedType, char endToken, JSONParseContext jsonParseContext) throws Exception {
                return this.deserializeDefault0(buf, fromIndex, toIndex, offset, initValue, cnt, negative, endToken, 4, jsonParseContext).doubleValue();
            }

            @Override
            protected final Number deserializeNumber(long initValue, boolean negative, int cnt, byte[] buf, int fromIndex, int offset, int toIndex, GenericParameterizedType parameterizedType, byte endToken, JSONParseContext jsonParseContext) throws Exception {
                return this.deserializeDefault0(buf, fromIndex, toIndex, offset, initValue, cnt, negative, endToken, 4, jsonParseContext).doubleValue();
            }
        }

        static class ByteDeserializer
        extends NumberDeserializer {
            ByteDeserializer() {
            }

            @Override
            protected final Number deserializeNumber(long initValue, boolean negative, int cnt, char[] buf, int fromIndex, int offset, int toIndex, GenericParameterizedType parameterizedType, char endToken, JSONParseContext jsonParseContext) throws Exception {
                return (byte)this.deserializeInteger(initValue, negative, cnt, buf, offset, toIndex, endToken, jsonParseContext);
            }

            @Override
            protected final Number deserializeNumber(long initValue, boolean negative, int cnt, byte[] buf, int fromIndex, int offset, int toIndex, GenericParameterizedType parameterizedType, byte endToken, JSONParseContext jsonParseContext) throws Exception {
                return (byte)this.deserializeInteger(initValue, negative, cnt, buf, offset, toIndex, endToken, jsonParseContext);
            }

            @Override
            protected Object valueOf(String value, Class<?> actualType) {
                return Byte.parseByte(value);
            }
        }

        static class ShortDeserializer
        extends NumberDeserializer {
            ShortDeserializer() {
            }

            @Override
            protected final Number deserializeNumber(long initValue, boolean negative, int cnt, char[] buf, int fromIndex, int offset, int toIndex, GenericParameterizedType parameterizedType, char endToken, JSONParseContext jsonParseContext) throws Exception {
                return (short)this.deserializeInteger(initValue, negative, cnt, buf, offset, toIndex, endToken, jsonParseContext);
            }

            @Override
            protected final Number deserializeNumber(long initValue, boolean negative, int cnt, byte[] buf, int fromIndex, int offset, int toIndex, GenericParameterizedType parameterizedType, byte endToken, JSONParseContext jsonParseContext) throws Exception {
                return (short)this.deserializeInteger(initValue, negative, cnt, buf, offset, toIndex, endToken, jsonParseContext);
            }

            @Override
            protected Object valueOf(String value, Class<?> actualType) {
                return Short.parseShort(value);
            }
        }

        static class IntegerDeserializer
        extends NumberDeserializer {
            IntegerDeserializer() {
            }

            @Override
            protected final Integer deserializeNumber(long initValue, boolean negative, int cnt, char[] buf, int fromIndex, int offset, int toIndex, GenericParameterizedType parameterizedType, char endToken, JSONParseContext jsonParseContext) throws Exception {
                return (int)this.deserializeInteger(initValue, negative, cnt, buf, offset, toIndex, endToken, jsonParseContext);
            }

            @Override
            protected final Integer deserializeNumber(long initValue, boolean negative, int cnt, byte[] buf, int fromIndex, int offset, int toIndex, GenericParameterizedType parameterizedType, byte endToken, JSONParseContext jsonParseContext) throws Exception {
                return (int)this.deserializeInteger(initValue, negative, cnt, buf, offset, toIndex, endToken, jsonParseContext);
            }

            @Override
            protected Object valueOf(String value, Class<?> actualType) {
                return Integer.parseInt(value);
            }
        }

        static class LongDeserializer
        extends NumberDeserializer {
            LongDeserializer() {
            }

            @Override
            protected final Number deserializeNumber(long initValue, boolean negative, int cnt, char[] buf, int fromIndex, int offset, int toIndex, GenericParameterizedType parameterizedType, char endToken, JSONParseContext jsonParseContext) throws Exception {
                return this.deserializeInteger(initValue, negative, cnt, buf, offset, toIndex, endToken, jsonParseContext);
            }

            @Override
            protected final Number deserializeNumber(long initValue, boolean negative, int cnt, byte[] buf, int fromIndex, int offset, int toIndex, GenericParameterizedType parameterizedType, byte endToken, JSONParseContext jsonParseContext) throws Exception {
                return this.deserializeInteger(initValue, negative, cnt, buf, offset, toIndex, endToken, jsonParseContext);
            }

            @Override
            protected Object valueOf(String value, Class<?> actualType) {
                return Long.parseLong(value);
            }
        }
    }

    static class CharSequenceDeserializer
    extends JSONTypeDeserializer {
        CharSequenceDeserializer() {
        }

        protected void skip(CharSource source, char[] buf, int fromIndex, char endCh, JSONParseContext jsonParseContext) throws Exception {
            if (source != null) {
                int beginIndex = fromIndex + 1;
                int endIndex = source.indexOf(endCh, beginIndex);
                char prev = buf[endIndex - 1];
                while (prev == '\\') {
                    boolean prevEscapeFlag = true;
                    int j = endIndex - 1;
                    while (buf[--j] == '\\') {
                        prevEscapeFlag = !prevEscapeFlag;
                    }
                    if (!prevEscapeFlag) break;
                    endIndex = source.indexOf(endCh, endIndex + 1);
                    prev = buf[endIndex - 1];
                }
                jsonParseContext.endIndex = endIndex;
                return;
            }
            int i = fromIndex;
            while (buf[++i] != endCh) {
            }
            char prev = buf[i - 1];
            while (prev == '\\') {
                boolean prevEscapeFlag = true;
                int j = i - 1;
                while (buf[--j] == '\\') {
                    prevEscapeFlag = !prevEscapeFlag;
                }
                if (!prevEscapeFlag) break;
                while (buf[++i] != endCh) {
                }
                prev = buf[i - 1];
            }
            jsonParseContext.endIndex = i;
        }

        protected void skip(CharSource source, byte[] buf, int fromIndex, int endCh, JSONParseContext jsonParseContext) throws Exception {
            int beginIndex = fromIndex + 1;
            if (source != null) {
                String input = source.input();
                int endIndex = input.indexOf(endCh, beginIndex);
                byte prev = buf[endIndex - 1];
                while (prev == 92) {
                    boolean prevEscapeFlag = true;
                    int j = endIndex - 1;
                    while (buf[--j] == 92) {
                        prevEscapeFlag = !prevEscapeFlag;
                    }
                    if (!prevEscapeFlag) break;
                    endIndex = input.indexOf(endCh, endIndex + 1);
                    prev = buf[endIndex - 1];
                }
                jsonParseContext.endIndex = endIndex;
                return;
            }
            int i = fromIndex;
            while (buf[++i] != endCh) {
            }
            byte prev = buf[i - 1];
            while (prev == 92) {
                boolean prevEscapeFlag = true;
                int j = i - 1;
                while (buf[--j] == 92) {
                    prevEscapeFlag = !prevEscapeFlag;
                }
                if (!prevEscapeFlag) break;
                while (buf[++i] != endCh) {
                }
                prev = buf[i - 1];
            }
            jsonParseContext.endIndex = i;
        }

        protected Object unEscapeAsciiResult(String source, byte[] buf, int beginIndex, int len, GenericParameterizedType parameterizedType) {
            Class<?> actualType = parameterizedType.getActualType();
            if (actualType == char[].class) {
                char[] chars = new char[len];
                for (int i = 0; i < len; ++i) {
                    chars[i] = (char)buf[beginIndex++];
                }
                return chars;
            }
            if (actualType == StringBuilder.class) {
                return new StringBuilder().append(source, beginIndex, beginIndex + len);
            }
            return new StringBuilder().append(source, beginIndex, beginIndex + len);
        }

        protected Object escapeResult(JSONCharArrayWriter writer, GenericParameterizedType parameterizedType) {
            Class<?> actualType = parameterizedType.getActualType();
            if (actualType == char[].class) {
                return writer.toChars();
            }
            if (actualType == StringBuilder.class) {
                return writer.toStringBuilder();
            }
            return writer.toStringBuffer();
        }

        Object deserializeString(CharSource charSource, byte[] buf, int fromIndex, int toIndex, int endByte, GenericParameterizedType parameterizedType, JSONParseContext jsonParseContext) {
            if (charSource != null) {
                return this.deserializeAsciiCharSource(charSource, buf, fromIndex, endByte, parameterizedType, jsonParseContext);
            }
            JSONCharArrayWriter writer = CharSequenceDeserializer.getContextWriter(jsonParseContext);
            char[] chars = writer.ensureCapacity(buf.length);
            int count = writer.count;
            byte b0 = 0;
            int i = fromIndex;
            while (true) {
                byte b;
                boolean bEndFlag;
                boolean bl = bEndFlag = (b = buf[++i]) != 92 && b != endByte;
                if (bl && (b0 = buf[++i]) != 92 && b0 != endByte) {
                    byte b2;
                    byte b1;
                    if (b0 >= 0) {
                        chars[count++] = (char)b;
                        chars[count++] = (char)b0;
                        continue;
                    }
                    if (b >= 0) {
                        chars[count++] = (char)b;
                        b = b0;
                        b1 = buf[++i];
                    } else {
                        b1 = b0;
                    }
                    int s = b >> 4;
                    if (s == -2) {
                        try {
                            b2 = buf[++i];
                            int a = (b & 0xF) << 12 | (b1 & 0x3F) << 6 | b2 & 0x3F;
                            chars[count++] = (char)a;
                        }
                        catch (Throwable throwable) {
                            throw new UnsupportedOperationException("utf-8 character error ");
                        }
                    }
                    if (s == -3 || s == -4) {
                        try {
                            int a = (b & 0x1F) << 6 | b1 & 0x3F;
                            chars[count++] = (char)a;
                        }
                        catch (Throwable throwable) {
                            throw new UnsupportedOperationException("utf-8 character error ");
                        }
                    }
                    if (s == -1) {
                        try {
                            b2 = buf[++i];
                            byte b3 = buf[++i];
                            int a = (b & 7) << 18 | (b1 & 0x3F) << 12 | (b2 & 0x3F) << 6 | b3 & 0x3F;
                            if (Character.isSupplementaryCodePoint(a)) {
                                chars[count++] = (char)((a >>> 10) + 55232);
                                chars[count++] = (char)((a & 0x3FF) + 56320);
                            }
                            chars[count++] = (char)a;
                        }
                        catch (Throwable throwable) {
                            throw new UnsupportedOperationException("utf-8 character error ");
                        }
                    }
                    throw new UnsupportedOperationException("utf-8 character error ");
                }
                if (bEndFlag) {
                    chars[count++] = (char)b;
                    b = b0;
                }
                if (b == endByte) {
                    jsonParseContext.endIndex = i;
                    writer.count = count;
                    return this.charSequenceResult(writer, parameterizedType);
                }
                byte next = 0;
                if (i < toIndex - 1) {
                    next = buf[i + 1];
                }
                writer.count = count;
                CharSequenceDeserializer.escape(buf, next, i, i, writer, jsonParseContext);
                count = writer.count;
                i = jsonParseContext.endIndex;
            }
        }

        Object deserializeAsciiCharSource(CharSource charSource, byte[] buf, int fromIndex, int endByte, GenericParameterizedType parameterizedType, JSONParseContext jsonParseContext) {
            return CHAR_SEQUENCE_STRING.deserializeAsciiCharSourceAs(charSource, buf, fromIndex, endByte, parameterizedType, jsonParseContext);
        }

        Object deserializeString(CharSource source, char[] buf, int fromIndex, int toIndex, char endChar, GenericParameterizedType parameterizedType, JSONParseContext jsonParseContext) {
            int beginIndex = fromIndex + 1;
            JSONCharArrayWriter writer = null;
            int i = beginIndex;
            boolean unEscape = true;
            while (true) {
                char ch;
                if ((ch = buf[i]) != '\\' && ch != endChar) {
                    ++i;
                    continue;
                }
                if (ch == endChar) {
                    jsonParseContext.endIndex = i;
                    int len = i - beginIndex;
                    return this.charSequenceResult(buf, beginIndex, len, unEscape, writer, parameterizedType);
                }
                if (writer == null) {
                    writer = CharSequenceDeserializer.getContextWriter(jsonParseContext);
                    unEscape = false;
                }
                beginIndex = CharSequenceDeserializer.escapeNext(buf, buf[i + 1], i, beginIndex, writer, jsonParseContext);
                i = jsonParseContext.endIndex;
                ++i;
            }
        }

        Object charSequenceResult(char[] buf, int beginIndex, int len, boolean unEscape, JSONCharArrayWriter writer, GenericParameterizedType parameterizedType) {
            boolean isCharArray;
            Class<?> actualType = parameterizedType.getActualType();
            boolean bl = isCharArray = actualType == char[].class;
            if (unEscape) {
                if (isCharArray) {
                    char[] chars = new char[len];
                    System.arraycopy(buf, beginIndex, chars, 0, len);
                    return chars;
                }
                if (actualType == StringBuilder.class) {
                    return new StringBuilder(len).append(buf, beginIndex, len);
                }
                return new StringBuffer(len).append(buf, beginIndex, len);
            }
            writer.write(buf, beginIndex, len);
            if (isCharArray) {
                return writer.toChars();
            }
            if (actualType == StringBuilder.class) {
                return writer.toStringBuilder();
            }
            return writer.toStringBuilder();
        }

        Object charSequenceResult(JSONCharArrayWriter writer, GenericParameterizedType parameterizedType) {
            boolean isCharArray;
            Class<?> actualType = parameterizedType.getActualType();
            boolean bl = isCharArray = actualType == char[].class;
            if (isCharArray) {
                return writer.toChars();
            }
            if (actualType == StringBuilder.class) {
                return writer.toStringBuilder();
            }
            return writer.toStringBuffer();
        }

        @Override
        protected Object deserialize(CharSource charSource, char[] buf, int fromIndex, int toIndex, GenericParameterizedType parameterizedType, Object instance, char endToken, JSONParseContext jsonParseContext) throws Exception {
            boolean isStringType;
            char beginChar = buf[fromIndex];
            if (beginChar == '\"') {
                return this.deserializeString(charSource, buf, fromIndex, toIndex, beginChar, parameterizedType, jsonParseContext);
            }
            if (beginChar == 'n') {
                return NULL.deserialize(charSource, buf, fromIndex, toIndex, null, null, jsonParseContext);
            }
            boolean bl = isStringType = parameterizedType.getActualType() == String.class;
            if (isStringType) {
                try {
                    NUMBER.deserialize(charSource, buf, fromIndex, toIndex, null, null, endToken, jsonParseContext);
                    return new String(buf, fromIndex, jsonParseContext.endIndex + 1 - fromIndex);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            String errorContextTextAt = CharSequenceDeserializer.createErrorContextText(buf, fromIndex);
            throw new JSONException("Syntax error, at pos " + fromIndex + ", context text by '" + errorContextTextAt + "', unexpected '" + beginChar + "' for CharSequence, expected '\"' ");
        }

        @Override
        protected Object deserialize(CharSource charSource, byte[] buf, int fromIndex, int toIndex, GenericParameterizedType parameterizedType, Object defaultValue, byte endToken, JSONParseContext jsonParseContext) throws Exception {
            boolean isStringType;
            byte b = buf[fromIndex];
            if (b == 34) {
                return this.deserializeString(charSource, buf, fromIndex, toIndex, b, parameterizedType, jsonParseContext);
            }
            if (b == 110) {
                return NULL.deserialize(charSource, buf, fromIndex, toIndex, null, null, jsonParseContext);
            }
            boolean bl = isStringType = parameterizedType.getActualType() == String.class;
            if (isStringType) {
                try {
                    NUMBER.deserialize(charSource, buf, fromIndex, toIndex, null, null, endToken, jsonParseContext);
                    return new String(buf, fromIndex, jsonParseContext.endIndex + 1 - fromIndex);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            String errorContextTextAt = CharSequenceDeserializer.createErrorContextText(buf, fromIndex);
            throw new JSONException("Syntax error, at pos " + fromIndex + ", context text by '" + errorContextTextAt + "', unexpected '" + (char)b + "' for CharSequence, expected '\"' ");
        }

        public static class CharDeserializer
        extends CharSequenceDeserializer {
            @Override
            protected Object valueOf(String value, Class<?> actualType) {
                return Character.valueOf(value.charAt(0));
            }

            @Override
            protected Object deserialize(CharSource charSource, char[] buf, int fromIndex, int toIndex, GenericParameterizedType parameterizedType, Object instance, char endToken, JSONParseContext jsonParseContext) throws Exception {
                char firstChar = buf[fromIndex];
                switch (firstChar) {
                    case '\"': 
                    case '\'': {
                        char result = '\u0000';
                        String value = (String)CHAR_SEQUENCE_STRING.deserializeString(charSource, buf, fromIndex, toIndex, firstChar, null, jsonParseContext);
                        if (value.length() > 0) {
                            result = value.charAt(0);
                        }
                        return Character.valueOf(result);
                    }
                    case 'n': {
                        return NULL.deserialize(charSource, buf, fromIndex, toIndex, null, null, jsonParseContext);
                    }
                }
                short value = (Short)NUMBER_SHORT.deserialize(charSource, buf, fromIndex, toIndex, parameterizedType, instance, endToken, jsonParseContext);
                return Character.valueOf((char)value);
            }

            @Override
            protected Object deserialize(CharSource charSource, byte[] buf, int fromIndex, int toIndex, GenericParameterizedType parameterizedType, Object defaultValue, byte endToken, JSONParseContext jsonParseContext) throws Exception {
                byte firstByte = buf[fromIndex];
                switch (firstByte) {
                    case 34: 
                    case 39: {
                        char result = '\u0000';
                        String value = (String)CHAR_SEQUENCE_STRING.deserializeString(charSource, buf, fromIndex, toIndex, firstByte, null, jsonParseContext);
                        if (value.length() > 0) {
                            result = value.charAt(0);
                        }
                        return Character.valueOf(result);
                    }
                    case 110: {
                        return NULL.deserialize(charSource, buf, fromIndex, toIndex, null, null, jsonParseContext);
                    }
                }
                short value = (Short)NUMBER_SHORT.deserialize(charSource, buf, fromIndex, toIndex, parameterizedType, defaultValue, endToken, jsonParseContext);
                return Character.valueOf((char)value);
            }
        }

        static class StringJDK16PlusDeserializer
        extends StringDeserializer {
            StringJDK16PlusDeserializer() {
            }

            @Override
            public Object deserializeAsciiCharSourceAs(CharSource charSource, byte[] buf, int fromIndex, int endByte, GenericParameterizedType parameterizedType, JSONParseContext jsonParseContext) {
                int endIndex;
                int beginIndex;
                String source = charSource.input();
                if (!jsonParseContext.checkEscapeUseChar(source, beginIndex = fromIndex + 1, endIndex = source.indexOf(endByte, beginIndex))) {
                    jsonParseContext.endIndex = endIndex;
                    int len = endIndex - beginIndex;
                    return this.unEscapeAsciiResult(source, buf, beginIndex, len, parameterizedType);
                }
                JSONCharArrayWriter writer = StringJDK16PlusDeserializer.getContextWriter(jsonParseContext);
                do {
                    int escapeIndex;
                    if ((beginIndex = StringJDK16PlusDeserializer.escapeAscii(source, buf, buf[(escapeIndex = jsonParseContext.getEscapeOffset()) + 1], escapeIndex, beginIndex, writer, jsonParseContext)) <= endIndex) continue;
                    endIndex = source.indexOf(endByte, endIndex + 1);
                } while (jsonParseContext.checkEscapeUseChar(source, beginIndex, endIndex));
                jsonParseContext.endIndex = endIndex;
                writer.write(source, beginIndex, endIndex - beginIndex);
                return this.escapeResult(writer, parameterizedType);
            }

            @Override
            String deserializeAsciiCharSource(CharSource charSource, byte[] buf, int fromIndex, int endByte, GenericParameterizedType parameterizedType, JSONParseContext jsonParseContext) {
                int endIndex;
                int beginIndex;
                String source = charSource.input();
                if (!jsonParseContext.checkEscapeUseChar(source, beginIndex = fromIndex + 1, endIndex = source.indexOf(endByte, beginIndex))) {
                    jsonParseContext.endIndex = endIndex;
                    return charSource.substring(beginIndex, endIndex);
                }
                JSONCharArrayWriter writer = StringJDK16PlusDeserializer.getContextWriter(jsonParseContext);
                do {
                    int escapeIndex;
                    if ((beginIndex = StringJDK16PlusDeserializer.escapeAscii(source, buf, buf[(escapeIndex = jsonParseContext.getEscapeOffset()) + 1], escapeIndex, beginIndex, writer, jsonParseContext)) <= endIndex) continue;
                    endIndex = source.indexOf(endByte, endIndex + 1);
                } while (jsonParseContext.checkEscapeUseChar(source, beginIndex, endIndex));
                jsonParseContext.endIndex = endIndex;
                writer.write(source, beginIndex, endIndex - beginIndex);
                return writer.toString();
            }
        }

        static class StringJDK9PlusDeserializer
        extends StringDeserializer {
            StringJDK9PlusDeserializer() {
            }

            @Override
            public Object deserializeAsciiCharSourceAs(CharSource charSource, byte[] buf, int fromIndex, int endByte, GenericParameterizedType parameterizedType, JSONParseContext jsonParseContext) {
                String token;
                int endIndex;
                int beginIndex;
                String source = charSource.input();
                if (!jsonParseContext.checkEscapeUseString(source, beginIndex = fromIndex + 1, endIndex = source.indexOf(token = endByte == 34 ? "\"" : "'", beginIndex))) {
                    jsonParseContext.endIndex = endIndex;
                    int len = endIndex - beginIndex;
                    return this.unEscapeAsciiResult(source, buf, beginIndex, len, parameterizedType);
                }
                JSONCharArrayWriter writer = StringJDK9PlusDeserializer.getContextWriter(jsonParseContext);
                do {
                    int escapeIndex;
                    if ((beginIndex = StringJDK9PlusDeserializer.escapeAscii(source, buf, buf[(escapeIndex = jsonParseContext.getEscapeOffset()) + 1], escapeIndex, beginIndex, writer, jsonParseContext)) <= endIndex) continue;
                    endIndex = source.indexOf(token, endIndex + 1);
                } while (jsonParseContext.checkEscapeUseString(source, beginIndex, endIndex));
                jsonParseContext.endIndex = endIndex;
                writer.write(source, beginIndex, endIndex - beginIndex);
                return this.escapeResult(writer, parameterizedType);
            }

            @Override
            Object deserializeAsciiCharSource(CharSource charSource, byte[] buf, int fromIndex, int endByte, GenericParameterizedType parameterizedType, JSONParseContext jsonParseContext) {
                String token;
                int endIndex;
                int beginIndex;
                String source = charSource.input();
                if (!jsonParseContext.checkEscapeUseString(source, beginIndex = fromIndex + 1, endIndex = source.indexOf(token = endByte == 34 ? "\"" : "'", beginIndex))) {
                    jsonParseContext.endIndex = endIndex;
                    return charSource.substring(beginIndex, endIndex);
                }
                JSONCharArrayWriter writer = StringJDK9PlusDeserializer.getContextWriter(jsonParseContext);
                do {
                    int escapeIndex;
                    if ((beginIndex = StringJDK9PlusDeserializer.escapeAscii(source, buf, buf[(escapeIndex = jsonParseContext.getEscapeOffset()) + 1], escapeIndex, beginIndex, writer, jsonParseContext)) <= endIndex) continue;
                    endIndex = source.indexOf(token, endIndex + 1);
                } while (jsonParseContext.checkEscapeUseString(source, beginIndex, endIndex));
                jsonParseContext.endIndex = endIndex;
                writer.write(source, beginIndex, endIndex - beginIndex);
                return writer.toString();
            }
        }

        static class StringDeserializer
        extends CharSequenceDeserializer {
            StringDeserializer() {
            }

            @Override
            final Object deserializeString(CharSource charSource, char[] buf, int fromIndex, int toIndex, char endChar, GenericParameterizedType parameterizedType, JSONParseContext jsonParseContext) {
                int endIndex;
                if (charSource == null) {
                    return super.deserializeString(charSource, buf, fromIndex, toIndex, endChar, parameterizedType, jsonParseContext);
                }
                int beginIndex = fromIndex + 1;
                String source = charSource.input();
                if (!jsonParseContext.checkEscapeUseChar(source, beginIndex, endIndex = source.indexOf(endChar, beginIndex))) {
                    jsonParseContext.endIndex = endIndex;
                    return new String(buf, beginIndex, endIndex - beginIndex);
                }
                JSONCharArrayWriter writer = StringDeserializer.getContextWriter(jsonParseContext);
                do {
                    int escapeIndex;
                    if ((beginIndex = StringDeserializer.escapeNext(buf, buf[(escapeIndex = jsonParseContext.getEscapeOffset()) + 1], escapeIndex, beginIndex, writer, jsonParseContext)) <= endIndex) continue;
                    endIndex = source.indexOf(endChar, endIndex + 1);
                } while (jsonParseContext.checkEscapeUseChar(source, beginIndex, endIndex));
                jsonParseContext.endIndex = endIndex;
                writer.write(charSource.input(), beginIndex, endIndex - beginIndex);
                return writer.toString();
            }

            @Override
            final Object charSequenceResult(char[] buf, int beginIndex, int len, boolean unEscape, JSONCharArrayWriter writer, GenericParameterizedType parameterizedType) {
                if (unEscape) {
                    return UnsafeHelper.getString(JSONUnsafe.copyChars(buf, beginIndex, len));
                }
                writer.write(buf, beginIndex, len);
                return writer.toString();
            }

            @Override
            final String charSequenceResult(JSONCharArrayWriter writer, GenericParameterizedType parameterizedType) {
                return writer.toString();
            }

            public Object deserializeAsciiCharSourceAs(CharSource charSource, byte[] buf, int fromIndex, int endByte, GenericParameterizedType parameterizedType, JSONParseContext jsonParseContext) {
                throw new UnsupportedOperationException();
            }
        }
    }
}

