/*
 * Decompiled with CFR 0.152.
 */
package io.github.wycst.wast.json;

import io.github.wycst.wast.common.beans.DateFormatter;
import io.github.wycst.wast.common.beans.GeneralDate;
import io.github.wycst.wast.common.compiler.JDKCompiler;
import io.github.wycst.wast.common.reflect.ClassStructureWrapper;
import io.github.wycst.wast.common.reflect.GetterInfo;
import io.github.wycst.wast.common.reflect.ReflectConsts;
import io.github.wycst.wast.common.reflect.UnsafeHelper;
import io.github.wycst.wast.common.tools.Base64;
import io.github.wycst.wast.common.utils.EnvUtils;
import io.github.wycst.wast.json.JSONCharArrayWriter;
import io.github.wycst.wast.json.JSONConfig;
import io.github.wycst.wast.json.JSONGeneral;
import io.github.wycst.wast.json.JSONPojoFieldSerializer;
import io.github.wycst.wast.json.JSONPojoSerializer;
import io.github.wycst.wast.json.JSONPojoStructure;
import io.github.wycst.wast.json.JSONTemporalSerializer;
import io.github.wycst.wast.json.JSONWriter;
import io.github.wycst.wast.json.annotations.JsonProperty;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.math.BigInteger;
import java.sql.Time;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;

public abstract class JSONTypeSerializer
extends JSONGeneral {
    static final int LENGTH = ReflectConsts.ClassCategory.values().length;
    static final JSONTypeSerializer[] TYPE_SERIALIZERS = new JSONTypeSerializer[LENGTH];
    private static final Map<Class<?>, JSONTypeSerializer> classJSONTypeSerializerMap = new ConcurrentHashMap();
    static final CharSequenceSerializer CHAR_SEQUENCE = new CharSequenceSerializer();
    static final CharSequenceSerializer CHAR_SEQUENCE_STRING = EnvUtils.JDK_9_PLUS ? new CharSequenceSerializer.StringBytesSerializer() : new CharSequenceSerializer.StringCharsSerializer();
    static final EnumSerializer ENUM = new EnumSerializer();
    static final SimpleSerializer.SimpleNumberSerializer NUMBER = new SimpleSerializer.SimpleNumberSerializer();
    static final SimpleSerializer.SimpleNumberSerializer NUMBER_LONG = new SimpleSerializer.LongSerializer();
    static final SimpleSerializer.SimpleNumberSerializer NUMBER_DOUBLE = new SimpleSerializer.DoubleSerializer();
    static final SimpleSerializer.SimpleNumberSerializer NUMBER_FLOAT = new SimpleSerializer.FloatSerializer();
    static final MapSerializer MAP = new MapSerializer();
    static final ArraySerializer ARRAY_OBJECT = new ArraySerializer();
    static final ArraySerializer ARRAY_STRING = new ArraySerializer.ArrayStringSerializer();
    static final ArraySerializer ARRAY_PRIMITIVE_LONG = new ArraySerializer.ArrayPrimitiveSerializer(NUMBER_LONG, ReflectConsts.PrimitiveType.PrimitiveLong);
    static final ArraySerializer ARRAY_PRIMITIVE_BYTE = new ArraySerializer.ArrayPrimitiveSerializer(NUMBER_LONG, ReflectConsts.PrimitiveType.PrimitiveByte);
    static final ArraySerializer ARRAY_PRIMITIVE_INTEGER = new ArraySerializer.ArrayPrimitiveSerializer(NUMBER_LONG, ReflectConsts.PrimitiveType.PrimitiveInt);
    static final ArraySerializer ARRAY_PRIMITIVE_SHORT = new ArraySerializer.ArrayPrimitiveSerializer(NUMBER_LONG, ReflectConsts.PrimitiveType.PrimitiveShort);
    static final ArraySerializer ARRAY_PRIMITIVE_FLOAT = new ArraySerializer.ArrayPrimitiveSerializer(NUMBER_FLOAT, ReflectConsts.PrimitiveType.PrimitiveFloat);
    static final ArraySerializer ARRAY_PRIMITIVE_DOUBLE = new ArraySerializer.ArrayPrimitiveSerializer(NUMBER_DOUBLE, ReflectConsts.PrimitiveType.PrimitiveDouble);
    static final CollectionSerializer COLLECTION = new CollectionSerializer();
    static final JSONTypeSerializer DATE_AS_TIME_SERIALIZER = new DateSerializer.DateAsTimeSerializer();
    static final Set<Class<?>> BUILT_IN_TYPE_SET;

    static boolean isBuiltInType(Class<?> type) {
        return BUILT_IN_TYPE_SET.contains(type);
    }

    static void putTypeSerializer(JSONTypeSerializer typeSerializer, Class ... types) {
        for (Class type : types) {
            classJSONTypeSerializerMap.put(type, typeSerializer);
        }
    }

    static JSONTypeSerializer getTypeSerializer(ReflectConsts.ClassCategory classCategory, JsonProperty jsonProperty) {
        int ordinal = classCategory.ordinal();
        if (classCategory == ReflectConsts.ClassCategory.DateCategory && jsonProperty != null) {
            if (jsonProperty.asTimestamp()) {
                return DATE_AS_TIME_SERIALIZER;
            }
            String pattern = jsonProperty.pattern().trim();
            if (pattern.length() > 0) {
                String timeZoneId = jsonProperty.timezone().trim();
                return new DateSerializer.DatePatternSerializer(DateFormatter.of(pattern), JSONTypeSerializer.getTimeZone(timeZoneId));
            }
        }
        if (classCategory == ReflectConsts.ClassCategory.NonInstance) {
            return new ObjectSerializer.ObjectWithTypeSerializer();
        }
        return TYPE_SERIALIZERS[ordinal];
    }

    static final JSONTypeSerializer getMapValueSerializer(Class<?> cls) {
        int classHashCode = cls.getName().hashCode();
        switch (classHashCode) {
            case 1195259493: {
                if (cls != String.class) break;
                return CHAR_SEQUENCE_STRING;
            }
            case -2056817302: 
            case 104431: 
            case 3327612: 
            case 398795216: {
                if (!Number.class.isAssignableFrom(cls)) break;
                return NUMBER_LONG;
            }
            case -1402722386: 
            case 1258621781: {
                if (!Map.class.isAssignableFrom(cls)) break;
                return MAP;
            }
            case -1402716492: 
            case -1114099497: {
                if (!Collection.class.isAssignableFrom(cls)) break;
                return COLLECTION;
            }
        }
        return JSONTypeSerializer.getTypeSerializer(cls);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static JSONTypeSerializer getTypeSerializer(Class<?> cls) {
        JSONTypeSerializer typeSerializer = classJSONTypeSerializerMap.get(cls);
        if (typeSerializer != null) {
            return typeSerializer;
        }
        Class<?> clazz = cls;
        synchronized (clazz) {
            typeSerializer = classJSONTypeSerializerMap.get(cls);
            if (typeSerializer != null) {
                return typeSerializer;
            }
            ReflectConsts.ClassCategory classCategory = ReflectConsts.getClassCategory(cls);
            if (classCategory == ReflectConsts.ClassCategory.ObjectCategory) {
                ClassStructureWrapper classStructureWrapper = ClassStructureWrapper.get(cls);
                if (classStructureWrapper.isTemporal()) {
                    typeSerializer = JSONTemporalSerializer.getTemporalSerializerInstance(classStructureWrapper, null);
                } else if (classStructureWrapper.isSubEnum()) {
                    typeSerializer = ENUM;
                } else {
                    JSONPojoStructure jsonPojoStructure = JSONPojoStructure.get(cls);
                    if (jsonPojoStructure.isSupportedJIT()) {
                        try {
                            Class<?> serializerClass = JDKCompiler.compileJavaSource(JSONPojoSerializer.generateRuntimeJavaCodeSource(jsonPojoStructure));
                            Constructor<?> constructor = serializerClass.getDeclaredConstructor(JSONPojoStructure.class);
                            UnsafeHelper.setAccessible(constructor);
                            typeSerializer = (JSONPojoSerializer)constructor.newInstance(jsonPojoStructure);
                        }
                        catch (Throwable throwable) {
                            typeSerializer = new ObjectSerializer.ObjectWrapperSerializer(cls, jsonPojoStructure);
                        }
                    } else {
                        typeSerializer = new ObjectSerializer.ObjectWrapperSerializer(cls, jsonPojoStructure);
                    }
                }
            } else {
                typeSerializer = JSONTypeSerializer.getTypeSerializer(classCategory, null);
            }
            classJSONTypeSerializerMap.put(cls, typeSerializer);
            return typeSerializer;
        }
    }

    static JSONTypeSerializer getEnumSerializer(Class<?> enumClass) {
        JSONTypeSerializer enumSerializer = classJSONTypeSerializerMap.get(enumClass);
        if (enumSerializer != null) {
            return enumSerializer;
        }
        Enum[] values = (Enum[])enumClass.getEnumConstants();
        char[][] enumNames = new char[values.length][];
        for (Enum value : values) {
            String enumName = value.name();
            char[] chars = new char[enumName.length() + 2];
            chars[chars.length - 1] = 34;
            chars[0] = 34;
            enumName.getChars(0, enumName.length(), chars, 1);
            enumNames[value.ordinal()] = chars;
        }
        enumSerializer = new EnumSerializer.EnumInstanceSerializer(enumNames);
        classJSONTypeSerializerMap.put(enumClass, enumSerializer);
        return enumSerializer;
    }

    static JSONTypeSerializer createCollectionSerializer(Class valueClass) {
        return new CollectionSerializer.CollectionFinalTypeSerializer(JSONTypeSerializer.getTypeSerializer(valueClass));
    }

    static JSONTypeSerializer getFieldTypeSerializer(ReflectConsts.ClassCategory classCategory, Class<?> type, JsonProperty jsonProperty) {
        switch (classCategory) {
            case EnumCategory: {
                return JSONTypeSerializer.getEnumSerializer(type);
            }
            case NumberCategory: {
                return JSONTypeSerializer.getTypeSerializer(type);
            }
            case ArrayCategory: {
                if (Object[].class.isAssignableFrom(type)) {
                    return type == String[].class ? ARRAY_STRING : ARRAY_OBJECT;
                }
                return JSONTypeSerializer.getTypeSerializer(type);
            }
            case ObjectCategory: {
                ClassStructureWrapper classStructureWrapper = ClassStructureWrapper.get(type);
                if (classStructureWrapper.isTemporal()) {
                    return JSONTemporalSerializer.getTemporalSerializerInstance(classStructureWrapper, jsonProperty);
                }
                if (jsonProperty != null && jsonProperty.unfixedType()) {
                    return new ObjectSerializer.ObjectWithTypeSerializer();
                }
                return JSONTypeSerializer.getTypeSerializer(type);
            }
        }
        return JSONTypeSerializer.getTypeSerializer(classCategory, jsonProperty);
    }

    protected abstract void serialize(Object var1, JSONWriter var2, JSONConfig var3, int var4) throws Exception;

    protected boolean checkWriteClassName(boolean writeClassName, JSONWriter writer, Class clazz, boolean formatOut, int indentLevel, JSONConfig jsonConfig) throws IOException {
        if (writeClassName) {
            this.writeType(writer, clazz, formatOut, indentLevel, jsonConfig);
            return true;
        }
        return false;
    }

    void writeType(JSONWriter writer, Class clazz, boolean formatOut, int indentLevel, JSONConfig jsonConfig) throws IOException {
        JSONTypeSerializer.writeFormatOutSymbols(writer, indentLevel + 1, formatOut, jsonConfig);
        writer.write("\"@c\":\"");
        writer.write(clazz.getName());
        writer.write("\"");
    }

    protected static void writeDate(int year, int month, int day, int hourOfDay, int minute, int second, int millisecond, DateFormatter dateFormatter, JSONWriter writer) throws Exception {
        if (writer instanceof JSONCharArrayWriter) {
            JSONCharArrayWriter charArrayWriter = (JSONCharArrayWriter)writer;
            char[] buf = charArrayWriter.ensureCapacity(dateFormatter.getEstimateSize());
            int off = charArrayWriter.count;
            off += dateFormatter.write(year, month, day, hourOfDay, minute, second, millisecond, buf, off);
            charArrayWriter.count = off;
            return;
        }
        dateFormatter.formatTo(year, month, day, hourOfDay, minute, second, millisecond, writer);
    }

    protected static void writeGeneralDate(GeneralDate generalDate, DateFormatter dateFormatter, JSONWriter writer) throws Exception {
        int year = generalDate.getYear();
        int month = generalDate.getMonth();
        int day = generalDate.getDay();
        int hourOfDay = generalDate.getHourOfDay();
        int minute = generalDate.getMinute();
        int second = generalDate.getSecond();
        int millisecond = generalDate.getMillisecond();
        JSONTypeSerializer.writeDate(year, month, day, hourOfDay, minute, second, millisecond, dateFormatter, writer);
    }

    static {
        JSONTypeSerializer.TYPE_SERIALIZERS[ReflectConsts.ClassCategory.CharSequence.ordinal()] = CHAR_SEQUENCE;
        SimpleSerializer SIMPLE = new SimpleSerializer();
        JSONTypeSerializer.TYPE_SERIALIZERS[ReflectConsts.ClassCategory.NumberCategory.ordinal()] = NUMBER;
        JSONTypeSerializer.TYPE_SERIALIZERS[ReflectConsts.ClassCategory.BoolCategory.ordinal()] = SIMPLE;
        JSONTypeSerializer.TYPE_SERIALIZERS[ReflectConsts.ClassCategory.DateCategory.ordinal()] = new DateSerializer();
        JSONTypeSerializer.TYPE_SERIALIZERS[ReflectConsts.ClassCategory.ClassCategory.ordinal()] = new ClassSerializer();
        JSONTypeSerializer.TYPE_SERIALIZERS[ReflectConsts.ClassCategory.EnumCategory.ordinal()] = ENUM;
        JSONTypeSerializer.TYPE_SERIALIZERS[ReflectConsts.ClassCategory.AnnotationCategory.ordinal()] = new AnnotationSerializer();
        JSONTypeSerializer.TYPE_SERIALIZERS[ReflectConsts.ClassCategory.Binary.ordinal()] = new BinarySerializer();
        JSONTypeSerializer.TYPE_SERIALIZERS[ReflectConsts.ClassCategory.ArrayCategory.ordinal()] = ARRAY_OBJECT;
        JSONTypeSerializer.TYPE_SERIALIZERS[ReflectConsts.ClassCategory.CollectionCategory.ordinal()] = COLLECTION;
        JSONTypeSerializer.TYPE_SERIALIZERS[ReflectConsts.ClassCategory.MapCategory.ordinal()] = MAP;
        JSONTypeSerializer.TYPE_SERIALIZERS[ReflectConsts.ClassCategory.ObjectCategory.ordinal()] = new ObjectSerializer();
        JSONTypeSerializer.TYPE_SERIALIZERS[ReflectConsts.ClassCategory.ANY.ordinal()] = new ANYSerializer();
        JSONTypeSerializer.putTypeSerializer(CHAR_SEQUENCE_STRING, String.class);
        JSONTypeSerializer.putTypeSerializer(new SimpleSerializer.BigIntegerSerializer(), BigInteger.class);
        JSONTypeSerializer.putTypeSerializer(NUMBER_DOUBLE, Double.TYPE, Double.class);
        JSONTypeSerializer.putTypeSerializer(NUMBER_FLOAT, Float.TYPE, Float.class);
        JSONTypeSerializer.putTypeSerializer(NUMBER_LONG, Byte.TYPE, Byte.class, Short.TYPE, Short.class, Integer.TYPE, Integer.class, Long.TYPE, Long.class, AtomicInteger.class, AtomicLong.class);
        JSONTypeSerializer.putTypeSerializer(ARRAY_OBJECT, Object[].class);
        JSONTypeSerializer.putTypeSerializer(ARRAY_STRING, String[].class);
        JSONTypeSerializer.putTypeSerializer(ARRAY_PRIMITIVE_LONG, long[].class);
        JSONTypeSerializer.putTypeSerializer(ARRAY_PRIMITIVE_INTEGER, int[].class);
        JSONTypeSerializer.putTypeSerializer(ARRAY_PRIMITIVE_FLOAT, float[].class);
        JSONTypeSerializer.putTypeSerializer(ARRAY_PRIMITIVE_DOUBLE, double[].class);
        JSONTypeSerializer.putTypeSerializer(ARRAY_PRIMITIVE_SHORT, short[].class);
        JSONTypeSerializer.putTypeSerializer(ARRAY_PRIMITIVE_BYTE, byte[].class);
        JSONTypeSerializer.putTypeSerializer(new ArraySerializer.ArrayPrimitiveSerializer(SIMPLE, ReflectConsts.PrimitiveType.PrimitiveBoolean), boolean[].class);
        JSONTypeSerializer.putTypeSerializer(CHAR_SEQUENCE, char[].class);
        JSONTypeSerializer.putTypeSerializer(new JSONTypeSerializer(){

            @Override
            protected void serialize(Object value, JSONWriter writer, JSONConfig jsonConfig, int indent) throws Exception {
                writer.writeUUID((UUID)value);
            }
        }, UUID.class);
        BUILT_IN_TYPE_SET = new HashSet(classJSONTypeSerializerMap.keySet());
    }

    private static class ANYSerializer
    extends JSONTypeSerializer {
        private ANYSerializer() {
        }

        @Override
        protected void serialize(Object value, JSONWriter writer, JSONConfig jsonConfig, int indent) throws Exception {
            Class<?> clazz = value.getClass();
            if (clazz == Object.class) {
                writer.write(EMPTY_OBJECT);
            } else {
                ReflectConsts.ClassCategory classCategory = ReflectConsts.getClassCategory(clazz);
                int ordinal = classCategory.ordinal();
                TYPE_SERIALIZERS[ordinal].serialize(value, writer, jsonConfig, indent);
            }
        }
    }

    private static class ObjectSerializer
    extends JSONTypeSerializer {
        private ObjectSerializer() {
        }

        @Override
        protected void serialize(Object obj, JSONWriter writer, JSONConfig jsonConfig, int indentLevel) throws Exception {
            int hashcode = -1;
            if (jsonConfig.isSkipCircularReference()) {
                hashcode = System.identityHashCode(obj);
                if (jsonConfig.getStatus(hashcode) == 0) {
                    writer.writeNull();
                    return;
                }
                jsonConfig.setStatus(hashcode, 0);
            }
            boolean writeFullProperty = jsonConfig.isFullProperty();
            boolean formatOut = jsonConfig.isFormatOut();
            boolean formatOutColonSpace = formatOut && jsonConfig.isFormatOutColonSpace();
            boolean writeClassName = jsonConfig.isWriteClassName();
            writer.writeJSONToken('{');
            Class<?> clazz = obj.getClass();
            JSONPojoStructure classStructureWrapper = this.getObjectStructureWrapper(clazz);
            classStructureWrapper.ensureInitialized();
            boolean isEmptyFlag = !this.checkWriteClassName(writeClassName, writer, clazz, formatOut, indentLevel, jsonConfig);
            JSONPojoFieldSerializer[] fieldSerializers = classStructureWrapper.getFieldSerializers(jsonConfig.isUseFields());
            boolean skipGetterOfNoExistField = jsonConfig.isSkipGetterOfNoneField();
            boolean unCamelCaseToUnderline = !jsonConfig.isCamelCaseToUnderline();
            int indentPlus = indentLevel + 1;
            for (JSONPojoFieldSerializer fieldSerializer : fieldSerializers) {
                Object value;
                GetterInfo getterInfo = fieldSerializer.getGetterInfo();
                if (!getterInfo.existField() && skipGetterOfNoExistField || (value = getterInfo.invoke(obj)) == null && !writeFullProperty) continue;
                if (isEmptyFlag) {
                    isEmptyFlag = false;
                } else {
                    writer.writeJSONToken(',');
                }
                ObjectSerializer.writeFormatOutSymbols(writer, indentPlus, formatOut, jsonConfig);
                if (value != null) {
                    if (unCamelCaseToUnderline) {
                        fieldSerializer.writeJSONFieldName(writer);
                    } else {
                        writer.append('\"').append(getterInfo.getUnderlineName()).append("\":");
                    }
                    if (formatOutColonSpace) {
                        writer.writeJSONToken(' ');
                    }
                    JSONTypeSerializer serializer = fieldSerializer.getSerializer();
                    serializer.serialize(value, writer, jsonConfig, indentPlus);
                    continue;
                }
                if (unCamelCaseToUnderline) {
                    if (formatOutColonSpace) {
                        fieldSerializer.writeJSONFieldName(writer);
                        writer.writeJSONToken(' ');
                        writer.writeNull();
                        continue;
                    }
                    fieldSerializer.writeJSONFieldNameWithNull(writer);
                    continue;
                }
                writer.writeJSONToken('\"');
                writer.write(getterInfo.getUnderlineName());
                writer.writeJSONToken('\"');
                if (formatOutColonSpace) {
                    writer.write(": null");
                    continue;
                }
                writer.write(":null");
            }
            if (!isEmptyFlag) {
                ObjectSerializer.writeFormatOutSymbols(writer, indentLevel, formatOut, jsonConfig);
            }
            writer.write(125);
            jsonConfig.setStatus(hashcode, -1);
        }

        JSONPojoStructure getObjectStructureWrapper(Class clazz) {
            return JSONPojoStructure.get(clazz);
        }

        static final class ObjectWrapperSerializer
        extends ObjectSerializer {
            final JSONPojoStructure pojoStructure;
            final Class objectCls;

            ObjectWrapperSerializer(Class cls, JSONPojoStructure pojoStructure) {
                this.objectCls = cls;
                this.pojoStructure = pojoStructure;
            }

            @Override
            JSONPojoStructure getObjectStructureWrapper(Class clazz) {
                return clazz == this.objectCls ? this.pojoStructure : JSONPojoStructure.get(clazz);
            }
        }

        static final class ObjectWithTypeSerializer
        extends ObjectSerializer {
            ObjectWithTypeSerializer() {
            }

            @Override
            protected void serialize(Object obj, JSONWriter writer, JSONConfig jsonConfig, int indentLevel) throws Exception {
                ReflectConsts.ClassCategory classCategory = ReflectConsts.getClassCategory(obj.getClass());
                if (classCategory != ReflectConsts.ClassCategory.ObjectCategory) {
                    ObjectWithTypeSerializer.getTypeSerializer(classCategory, null).serialize(obj, writer, jsonConfig, indentLevel);
                } else {
                    super.serialize(obj, writer, jsonConfig, indentLevel);
                }
            }

            @Override
            protected boolean checkWriteClassName(boolean writeClassName, JSONWriter writer, Class clazz, boolean formatOut, int indentLevel, JSONConfig jsonConfig) throws IOException {
                this.writeType(writer, clazz, formatOut, indentLevel, jsonConfig);
                return true;
            }
        }
    }

    private static class MapSerializer
    extends JSONTypeSerializer {
        private MapSerializer() {
        }

        private static void writeMap(Object obj, JSONWriter writer, JSONConfig jsonConfig, int indentLevel) throws Exception {
            boolean formatOut = jsonConfig.isFormatOut();
            boolean formatOutColonSpace = formatOut && jsonConfig.isFormatOutColonSpace();
            Map map = (Map)obj;
            if (map.size() == 0) {
                writer.write(EMPTY_OBJECT);
            } else {
                writer.writeJSONToken('{');
                Set entrySet = map.entrySet();
                boolean isFirstKey = true;
                int indentLevelPlus = indentLevel + 1;
                for (Map.Entry entry : entrySet) {
                    Object key = entry.getKey();
                    Object value = entry.getValue();
                    if (isFirstKey) {
                        isFirstKey = false;
                    } else {
                        writer.writeJSONToken(',');
                    }
                    MapSerializer.writeFormatOutSymbols(writer, indentLevelPlus, formatOut, jsonConfig);
                    if (jsonConfig.isAllowUnquotedMapKey() && (key == null || key instanceof Number)) {
                        writer.append(String.valueOf(key)).write(58);
                    } else {
                        String stringKey = key == null ? "null" : key.toString();
                        writer.writeJSONKeyAndColon(stringKey);
                    }
                    if (formatOutColonSpace) {
                        writer.writeJSONToken(' ');
                    }
                    if (value != null) {
                        JSONTypeSerializer valueSerializer = MapSerializer.getMapValueSerializer(value.getClass());
                        valueSerializer.serialize(value, writer, jsonConfig, formatOut ? indentLevelPlus : -1);
                        continue;
                    }
                    writer.writeNull();
                }
                MapSerializer.writeFormatOutSymbols(writer, indentLevel, formatOut, jsonConfig);
                writer.write(125);
            }
        }

        @Override
        protected void serialize(Object obj, JSONWriter writer, JSONConfig jsonConfig, int indent) throws Exception {
            int hashcode = -1;
            if (jsonConfig.isSkipCircularReference()) {
                hashcode = System.identityHashCode(obj);
                if (jsonConfig.getStatus(hashcode) == 0) {
                    writer.writeNull();
                    return;
                }
                jsonConfig.setStatus(hashcode, 0);
            }
            MapSerializer.writeMap(obj, writer, jsonConfig, indent);
            jsonConfig.setStatus(hashcode, -1);
        }
    }

    private static class CollectionSerializer
    extends JSONTypeSerializer {
        private CollectionSerializer() {
        }

        protected void writeCollection(Object obj, JSONWriter writer, JSONConfig jsonConfig, int indentLevel) throws Exception {
            boolean formatOut = jsonConfig.isFormatOut();
            Collection collect = (Collection)obj;
            if (collect.size() > 0) {
                writer.writeJSONToken('[');
                int indentLevelPlus = indentLevel + 1;
                boolean isEmptyFlag = true;
                Class<?> firstElementClass = null;
                JSONTypeSerializer firstSerializer = null;
                for (Object value : collect) {
                    if (isEmptyFlag) {
                        isEmptyFlag = false;
                    } else {
                        writer.writeJSONToken(',');
                    }
                    CollectionSerializer.writeFormatOutSymbols(writer, indentLevelPlus, formatOut, jsonConfig);
                    if (value != null) {
                        Class<?> valueClass = value.getClass();
                        if (valueClass == firstElementClass) {
                            firstSerializer.serialize(value, writer, jsonConfig, indentLevelPlus);
                            continue;
                        }
                        if (firstElementClass == null) {
                            firstElementClass = valueClass;
                            firstSerializer = CollectionSerializer.getTypeSerializer(valueClass);
                            firstSerializer.serialize(value, writer, jsonConfig, indentLevelPlus);
                            continue;
                        }
                        CollectionSerializer.getTypeSerializer(valueClass).serialize(value, writer, jsonConfig, indentLevelPlus);
                        continue;
                    }
                    writer.writeNull();
                }
                if (!isEmptyFlag) {
                    CollectionSerializer.writeFormatOutSymbols(writer, indentLevel, formatOut, jsonConfig);
                }
                writer.write(93);
            } else {
                writer.writeEmptyArray();
            }
        }

        @Override
        protected void serialize(Object obj, JSONWriter writer, JSONConfig jsonConfig, int indent) throws Exception {
            int hashcode = -1;
            if (jsonConfig.isSkipCircularReference()) {
                hashcode = System.identityHashCode(obj);
                if (jsonConfig.getStatus(hashcode) == 0) {
                    writer.writeNull();
                    return;
                }
                jsonConfig.setStatus(hashcode, 0);
            }
            this.writeCollection(obj, writer, jsonConfig, indent);
            jsonConfig.setStatus(hashcode, -1);
        }

        static class CollectionFinalTypeSerializer
        extends CollectionSerializer {
            private final JSONTypeSerializer valueSerializer;

            CollectionFinalTypeSerializer(JSONTypeSerializer valueSerializer) {
                this.valueSerializer = valueSerializer;
            }

            @Override
            protected final void writeCollection(Object obj, JSONWriter writer, JSONConfig jsonConfig, int indentLevel) throws Exception {
                boolean formatOut = jsonConfig.isFormatOut();
                Collection collect = (Collection)obj;
                if (collect.size() > 0) {
                    writer.writeJSONToken('[');
                    int indentLevelPlus = indentLevel + 1;
                    boolean isEmptyFlag = true;
                    for (Object value : collect) {
                        if (isEmptyFlag) {
                            isEmptyFlag = false;
                        } else {
                            writer.writeJSONToken(',');
                        }
                        CollectionFinalTypeSerializer.writeFormatOutSymbols(writer, indentLevelPlus, formatOut, jsonConfig);
                        if (value != null) {
                            this.valueSerializer.serialize(value, writer, jsonConfig, indentLevelPlus);
                            continue;
                        }
                        writer.writeNull();
                    }
                    if (!isEmptyFlag) {
                        CollectionFinalTypeSerializer.writeFormatOutSymbols(writer, indentLevel, formatOut, jsonConfig);
                    }
                    writer.write(93);
                } else {
                    writer.writeEmptyArray();
                }
            }
        }
    }

    private static class ArraySerializer
    extends JSONTypeSerializer {
        private ArraySerializer() {
        }

        protected JSONTypeSerializer getComponentTypeSerializer(Class<?> componentType) {
            return JSONTypeSerializer.getTypeSerializer(componentType);
        }

        protected void writeArray(Object obj, JSONWriter writer, JSONConfig jsonConfig, int indentLevel) throws Exception {
            boolean formatOut = jsonConfig.isFormatOut();
            Object[] objects = (Object[])obj;
            int length = objects.length;
            if (length > 0) {
                writer.writeJSONToken('[');
                int indentLevelPlus = indentLevel + 1;
                Class<?> componentType = obj.getClass().getComponentType();
                JSONTypeSerializer valueSerializer = this.getComponentTypeSerializer(componentType);
                Object value = objects[0];
                ArraySerializer.writeFormatOutSymbols(writer, indentLevelPlus, formatOut, jsonConfig);
                if (value != null) {
                    this.serializeComponent(valueSerializer, value, componentType, writer, jsonConfig, indentLevelPlus);
                } else {
                    writer.writeNull();
                }
                for (int i = 1; i < length; ++i) {
                    writer.writeJSONToken(',');
                    ArraySerializer.writeFormatOutSymbols(writer, indentLevelPlus, formatOut, jsonConfig);
                    value = objects[i];
                    if (value != null) {
                        this.serializeComponent(valueSerializer, value, componentType, writer, jsonConfig, indentLevelPlus);
                        continue;
                    }
                    writer.writeNull();
                }
                ArraySerializer.writeFormatOutSymbols(writer, indentLevel, formatOut, jsonConfig);
                writer.write(93);
            } else {
                writer.writeEmptyArray();
            }
        }

        protected void serializeComponent(JSONTypeSerializer valueSerializer, Object value, Class<?> componentType, JSONWriter writer, JSONConfig jsonConfig, int indentLevel) throws Exception {
            Class<?> valueClass = value.getClass();
            if (componentType == valueClass) {
                valueSerializer.serialize(value, writer, jsonConfig, indentLevel);
            } else {
                ArraySerializer.getTypeSerializer(valueClass).serialize(value, writer, jsonConfig, indentLevel);
            }
        }

        @Override
        protected void serialize(Object obj, JSONWriter writer, JSONConfig jsonConfig, int indent) throws Exception {
            int hashcode = -1;
            if (jsonConfig.isSkipCircularReference()) {
                hashcode = System.identityHashCode(obj);
                if (jsonConfig.getStatus(hashcode) == 0) {
                    writer.writeNull();
                    return;
                }
                jsonConfig.setStatus(hashcode, 0);
            }
            this.writeArray(obj, writer, jsonConfig, indent);
            jsonConfig.setStatus(hashcode, -1);
        }

        static class ArrayPrimitiveSerializer
        extends ArraySerializer {
            final JSONTypeSerializer valueSerializer;
            final ReflectConsts.PrimitiveType primitiveType;

            public ArrayPrimitiveSerializer(JSONTypeSerializer valueSerializer, ReflectConsts.PrimitiveType primitiveType) {
                this.valueSerializer = valueSerializer;
                this.primitiveType = primitiveType;
            }

            @Override
            protected final void serialize(Object obj, JSONWriter writer, JSONConfig jsonConfig, int indentLevel) throws Exception {
                boolean formatOut = jsonConfig.isFormatOut();
                int length = this.primitiveType.arrayLength(obj);
                if (length > 0) {
                    writer.writeJSONToken('[');
                    int indentLevelPlus = indentLevel + 1;
                    ArrayPrimitiveSerializer.writeFormatOutSymbols(writer, indentLevelPlus, formatOut, jsonConfig);
                    this.valueSerializer.serialize(this.primitiveType.elementAt(obj, 0), writer, jsonConfig, indentLevelPlus);
                    for (int i = 1; i < length; ++i) {
                        writer.writeJSONToken(',');
                        ArrayPrimitiveSerializer.writeFormatOutSymbols(writer, indentLevelPlus, formatOut, jsonConfig);
                        this.valueSerializer.serialize(this.primitiveType.elementAt(obj, i), writer, jsonConfig, indentLevelPlus);
                    }
                    ArrayPrimitiveSerializer.writeFormatOutSymbols(writer, indentLevel, formatOut, jsonConfig);
                    writer.writeJSONToken(']');
                } else {
                    writer.writeEmptyArray();
                }
            }
        }

        static final class ArrayStringSerializer
        extends ArraySerializer {
            ArrayStringSerializer() {
            }

            @Override
            protected JSONTypeSerializer getComponentTypeSerializer(Class<?> componentType) {
                return null;
            }

            @Override
            protected void serializeComponent(JSONTypeSerializer valueSerializer, Object value, Class<?> componentType, JSONWriter writer, JSONConfig jsonConfig, int indentLevel) throws Exception {
                CHAR_SEQUENCE_STRING.serialize(value, writer, jsonConfig, indentLevel);
            }
        }
    }

    private static class BinarySerializer
    extends JSONTypeSerializer {
        private BinarySerializer() {
        }

        @Override
        protected void serialize(Object value, JSONWriter writer, JSONConfig jsonConfig, int indent) throws Exception {
            if (jsonConfig.isBytesArrayToNative()) {
                ARRAY_PRIMITIVE_BYTE.writeArray(value, writer, jsonConfig, indent);
            } else {
                byte[] bytes = (byte[])value;
                if (jsonConfig.isBytesArrayToHex()) {
                    writer.append('\"').append(BinarySerializer.printHexString(bytes, '\u0000')).append('\"');
                } else {
                    writer.append('\"').append(Base64.getEncoder().encodeToString(bytes)).append('\"');
                }
            }
        }
    }

    private static class AnnotationSerializer
    extends JSONTypeSerializer {
        private AnnotationSerializer() {
        }

        @Override
        protected void serialize(Object value, JSONWriter writer, JSONConfig jsonConfig, int indent) throws Exception {
            writer.append('\"').append(value.toString()).append('\"');
        }
    }

    private static class ClassSerializer
    extends JSONTypeSerializer {
        private ClassSerializer() {
        }

        @Override
        protected void serialize(Object value, JSONWriter writer, JSONConfig jsonConfig, int indent) throws Exception {
            writer.append('\"').append(((Class)value).getName()).append('\"');
        }
    }

    private static class EnumSerializer
    extends JSONTypeSerializer {
        private EnumSerializer() {
        }

        @Override
        protected void serialize(Object value, JSONWriter writer, JSONConfig jsonConfig, int indent) throws Exception {
            Enum enmuValue = (Enum)value;
            if (jsonConfig.isWriteEnumAsOrdinal()) {
                NUMBER_LONG.serializeNumber(enmuValue.ordinal(), writer, jsonConfig, indent);
            } else {
                String enumName = enmuValue.name();
                writer.append('\"');
                if (EnvUtils.JDK_9_PLUS) {
                    writer.write(enumName);
                } else {
                    writer.writeShortChars(EnumSerializer.getChars(enumName), 0, enumName.length());
                }
                writer.append('\"');
            }
        }

        static class EnumInstanceSerializer
        extends EnumSerializer {
            final EnumFieldNameData[] enumFieldNameDatas;

            EnumInstanceSerializer(char[][] enumNameTokenChars) {
                EnumFieldNameData[] enumFieldNameDatas = new EnumFieldNameData[enumNameTokenChars.length];
                for (int i = 0; i < enumNameTokenChars.length; ++i) {
                    boolean useUnsafe;
                    char[] chars = enumNameTokenChars[i];
                    String enumNameTokenStr = new String(chars);
                    boolean bl = useUnsafe = enumNameTokenStr.getBytes().length == chars.length;
                    enumFieldNameDatas[i] = useUnsafe ? new EnumFieldNameData(null, null, UnsafeHelper.getCharLongs(enumNameTokenStr), UnsafeHelper.getByteLongs(enumNameTokenStr), chars.length) : (EnvUtils.JDK_9_PLUS ? new EnumFieldNameData(enumNameTokenStr, null, null, null, chars.length) : new EnumFieldNameData(null, chars, null, null, chars.length));
                }
                this.enumFieldNameDatas = enumFieldNameDatas;
            }

            @Override
            protected void serialize(Object value, JSONWriter writer, JSONConfig jsonConfig, int indent) throws Exception {
                Enum enmuValue = (Enum)value;
                int ordinal = enmuValue.ordinal();
                if (!jsonConfig.isWriteEnumAsOrdinal()) {
                    EnumFieldNameData fieldNameData = this.enumFieldNameDatas[ordinal];
                    if (fieldNameData.useLong) {
                        writer.writeMemory(fieldNameData.enumNameTokenCharLongs, fieldNameData.enumNameTokenByteLongs, fieldNameData.tokenLength);
                    } else if (EnvUtils.JDK_9_PLUS) {
                        String enumNameToken = fieldNameData.enumNameTokenStr;
                        writer.write(enumNameToken, 0, enumNameToken.length());
                    } else {
                        char[] chars = fieldNameData.enumNameTokenChars;
                        writer.writeShortChars(chars, 0, chars.length);
                    }
                } else {
                    NUMBER_LONG.serializeNumber(ordinal, writer, jsonConfig, indent);
                }
            }
        }

        static class EnumFieldNameData {
            final String enumNameTokenStr;
            final char[] enumNameTokenChars;
            final long[] enumNameTokenCharLongs;
            final long[] enumNameTokenByteLongs;
            final int tokenLength;
            final boolean useLong;

            public EnumFieldNameData(String enumNameTokenStr, char[] enumNameTokenChars, long[] enumNameTokenCharLongs, long[] enumNameTokenByteLongs, int tokenLength) {
                this.enumNameTokenStr = enumNameTokenStr;
                this.enumNameTokenChars = enumNameTokenChars;
                this.enumNameTokenCharLongs = enumNameTokenCharLongs;
                this.enumNameTokenByteLongs = enumNameTokenByteLongs;
                this.tokenLength = tokenLength;
                this.useLong = enumNameTokenCharLongs != null;
            }
        }
    }

    private static class DateSerializer
    extends JSONTypeSerializer {
        protected TimeZone timeZone;

        private DateSerializer() {
        }

        final void writeDateAsTime(Date date, JSONWriter writer, JSONConfig jsonConfig, int indent) throws Exception {
            long time = date.getTime();
            NUMBER_LONG.serializeNumber(time, writer, jsonConfig, indent);
        }

        @Override
        protected void serialize(Object value, JSONWriter writer, JSONConfig jsonConfig, int indent) throws Exception {
            Date date = (Date)value;
            if (jsonConfig.isWriteDateAsTime()) {
                this.writeDateAsTime(date, writer, jsonConfig, indent);
                return;
            }
            TimeZone timeZone = jsonConfig.getTimezone();
            if (timeZone == null) {
                timeZone = this.timeZone;
            }
            GeneralDate generalDate = new GeneralDate(date.getTime(), timeZone);
            int year = generalDate.getYear();
            int month = generalDate.getMonth();
            int day = generalDate.getDay();
            int hourOfDay = generalDate.getHourOfDay();
            int minute = generalDate.getMinute();
            int second = generalDate.getSecond();
            writer.write(34);
            if (date instanceof Time) {
                writer.writeTime(hourOfDay, minute, second);
            } else {
                writer.writeDate(year, month, day, hourOfDay, minute, second);
            }
            writer.write(34);
        }

        static class DatePatternSerializer
        extends DateSerializer {
            protected final DateFormatter dateFormatter;

            public DatePatternSerializer(DateFormatter dateFormatter, TimeZone timeZone) {
                this.dateFormatter = dateFormatter;
                this.timeZone = timeZone;
            }

            @Override
            protected void serialize(Object value, JSONWriter writer, JSONConfig jsonConfig, int indent) throws Exception {
                Date date = (Date)value;
                TimeZone timeZone = jsonConfig.getTimezone();
                if (timeZone == null) {
                    timeZone = this.timeZone;
                }
                writer.write(34);
                GeneralDate generalDate = new GeneralDate(date.getTime(), timeZone);
                DatePatternSerializer.writeGeneralDate(generalDate, this.dateFormatter, writer);
                writer.write(34);
            }
        }

        static class DateAsTimeSerializer
        extends DateSerializer {
            DateAsTimeSerializer() {
            }

            @Override
            protected void serialize(Object value, JSONWriter writer, JSONConfig jsonConfig, int indent) throws Exception {
                Date date = (Date)value;
                this.writeDateAsTime(date, writer, jsonConfig, indent);
            }
        }
    }

    private static class SimpleSerializer
    extends JSONTypeSerializer {
        private SimpleSerializer() {
        }

        @Override
        protected void serialize(Object value, JSONWriter writer, JSONConfig jsonConfig, int indent) throws Exception {
            writer.write(value.toString());
        }

        static class FloatSerializer
        extends SimpleNumberSerializer {
            FloatSerializer() {
            }

            @Override
            protected void serializeNumber(Object value, JSONWriter writer, JSONConfig jsonConfig, int indent) throws Exception {
                float numValue = ((Number)value).floatValue();
                writer.writeFloat(numValue);
            }
        }

        static class DoubleSerializer
        extends SimpleNumberSerializer {
            DoubleSerializer() {
            }

            @Override
            protected void serializeNumber(Object value, JSONWriter writer, JSONConfig jsonConfig, int indent) throws Exception {
                double numValue = ((Number)value).doubleValue();
                writer.writeDouble(numValue);
            }
        }

        static class LongSerializer
        extends SimpleNumberSerializer {
            LongSerializer() {
            }

            @Override
            protected void serializeNumber(Object value, JSONWriter writer, JSONConfig jsonConfig, int indent) throws Exception {
                long numValue = ((Number)value).longValue();
                writer.writeLong(numValue);
            }
        }

        static class BigIntegerSerializer
        extends SimpleNumberSerializer {
            BigIntegerSerializer() {
            }

            @Override
            protected void serializeNumber(Object value, JSONWriter writer, JSONConfig jsonConfig, int indent) throws Exception {
                writer.writeBigInteger((BigInteger)value);
            }
        }

        static class SimpleNumberSerializer
        extends SimpleSerializer {
            SimpleNumberSerializer() {
            }

            protected void serializeNumber(Object value, JSONWriter writer, JSONConfig jsonConfig, int indent) throws Exception {
                writer.write(value.toString());
            }

            @Override
            protected void serialize(Object value, JSONWriter writer, JSONConfig jsonConfig, int indent) throws Exception {
                boolean writeAsString = jsonConfig.isWriteNumberAsString();
                if (!writeAsString) {
                    this.serializeNumber(value, writer, jsonConfig, indent);
                } else {
                    writer.write(34);
                    this.serializeNumber(value, writer, jsonConfig, indent);
                    writer.write(34);
                }
            }
        }
    }

    static class CharSequenceSerializer
    extends JSONTypeSerializer {
        CharSequenceSerializer() {
        }

        @Override
        protected void serialize(Object value, JSONWriter writer, JSONConfig jsonConfig, int indent) throws Exception {
            char[] chars;
            boolean isCharSequence = value instanceof CharSequence;
            if (isCharSequence) {
                String strValue = value.toString();
                chars = CharSequenceSerializer.getChars(strValue);
            } else if (value instanceof char[]) {
                chars = (char[])value;
            } else {
                char c = ((Character)value).charValue();
                chars = new char[]{c};
            }
            writer.writeJSONChars(chars);
        }

        public static class StringBytesSerializer
        extends CharSequenceSerializer {
            @Override
            protected void serialize(Object value, JSONWriter writer, JSONConfig jsonConfig, int indent) throws Exception {
                String stringVal = (String)value;
                byte[] bytes = (byte[])UnsafeHelper.getStringValue(stringVal);
                writer.writeJSONStringBytes(stringVal, bytes);
            }
        }

        public static class StringCharsSerializer
        extends CharSequenceSerializer {
            @Override
            protected void serialize(Object value, JSONWriter writer, JSONConfig jsonConfig, int indent) throws Exception {
                String stringVal = (String)value;
                writer.writeJSONChars(StringCharsSerializer.getChars(stringVal));
            }
        }
    }
}

