/*
 * Decompiled with CFR 0.152.
 */
package io.github.wycst.wast.json;

import io.github.wycst.wast.common.reflect.UnsafeHelper;
import java.lang.reflect.Field;
import sun.misc.Unsafe;

final class JSONUnsafe {
    static final Unsafe UNSAFE;
    static final MemoryOptimizer[] SIZE_INSTANCES;
    static final int SIZE_LEN;
    static final MemoryOptimizer SIZE_INSTANCE_8;

    JSONUnsafe() {
    }

    static MemoryOptimizer s0() {
        return new MemoryOptimizer(){

            @Override
            public char[] copyChars(char[] buf, int offset, int len) {
                return new char[0];
            }

            @Override
            public byte[] copyBytes(byte[] buf, int offset, int len) {
                return new byte[0];
            }

            @Override
            public String[] copy(String[] buf, int offset, int len) {
                return new String[0];
            }

            @Override
            public double[] copy(double[] buf, int offset, int len) {
                return new double[0];
            }

            @Override
            public long[] copy(long[] buf, int offset, int len) {
                return new long[0];
            }
        };
    }

    static MemoryOptimizer s1() {
        return new MemoryOptimizer(){

            @Override
            public char[] copyChars(char[] buf, int offset, int len) {
                return new char[]{buf[offset]};
            }

            @Override
            public byte[] copyBytes(byte[] buf, int offset, int len) {
                return new byte[]{buf[offset]};
            }

            @Override
            public String[] copy(String[] buf, int offset, int len) {
                return new String[]{buf[offset]};
            }

            @Override
            public double[] copy(double[] buf, int offset, int len) {
                return new double[]{buf[offset]};
            }

            @Override
            public long[] copy(long[] buf, int offset, int len) {
                return new long[]{buf[offset]};
            }

            @Override
            void multipleCopyMemory(byte[] source, long sourceOff, byte[] target, long targetOff) {
                UNSAFE.putLong(target, targetOff, UNSAFE.getLong(source, sourceOff));
            }

            @Override
            void copyMemory(byte[] source, int sourceOff, byte[] target, int targetOff) {
                target[targetOff] = source[sourceOff];
            }
        };
    }

    static MemoryOptimizer s2() {
        return new MemoryOptimizer(){

            @Override
            public char[] copyChars(char[] buf, int offset, int len) {
                char[] chars = new char[2];
                JSONUnsafe.putInt(chars, 0, JSONUnsafe.getInt(buf, offset));
                return chars;
            }

            @Override
            public byte[] copyBytes(byte[] buf, int offset, int len) {
                byte[] bytes = new byte[2];
                JSONUnsafe.putShort(bytes, 0, JSONUnsafe.getShort(buf, offset));
                return bytes;
            }

            @Override
            public String[] copy(String[] buf, int offset, int len) {
                return new String[]{buf[offset++], buf[offset]};
            }

            @Override
            public double[] copy(double[] buf, int offset, int len) {
                return new double[]{buf[offset++], buf[offset]};
            }

            @Override
            public long[] copy(long[] buf, int offset, int len) {
                return new long[]{buf[offset++], buf[offset]};
            }

            @Override
            void multipleCopyMemory(byte[] source, long sourceOff, byte[] target, long targetOff) {
                UNSAFE.putLong(target, targetOff, UNSAFE.getLong(source, sourceOff));
                UNSAFE.putLong(target, targetOff + 8L, UNSAFE.getLong(source, sourceOff + 8L));
            }

            @Override
            void copyMemory(byte[] source, int sourceOff, byte[] target, int targetOff) {
                UNSAFE.putShort(target, UnsafeHelper.BYTE_ARRAY_OFFSET + (long)targetOff, UNSAFE.getShort(source, UnsafeHelper.BYTE_ARRAY_OFFSET + (long)sourceOff));
            }
        };
    }

    static MemoryOptimizer s3() {
        return new MemoryOptimizer(){

            @Override
            public char[] copyChars(char[] buf, int offset, int len) {
                char[] chars = new char[3];
                JSONUnsafe.putInt(chars, 0, JSONUnsafe.getInt(buf, offset));
                chars[2] = buf[offset + 2];
                return chars;
            }

            @Override
            public byte[] copyBytes(byte[] buf, int offset, int len) {
                byte[] bytes = new byte[3];
                JSONUnsafe.putShort(bytes, 0, JSONUnsafe.getShort(buf, offset));
                bytes[2] = buf[offset + 2];
                return bytes;
            }

            @Override
            public String[] copy(String[] buf, int offset, int len) {
                return new String[]{buf[offset++], buf[offset++], buf[offset]};
            }

            @Override
            public double[] copy(double[] buf, int offset, int len) {
                return new double[]{buf[offset++], buf[offset++], buf[offset]};
            }

            @Override
            public long[] copy(long[] buf, int offset, int len) {
                return new long[]{buf[offset++], buf[offset++], buf[offset]};
            }

            @Override
            void multipleCopyMemory(byte[] source, long sourceOff, byte[] target, long targetOff) {
                UNSAFE.putLong(target, targetOff, UNSAFE.getLong(source, sourceOff));
                UNSAFE.putLong(target, targetOff + 8L, UNSAFE.getLong(source, sourceOff + 8L));
                UNSAFE.putLong(target, targetOff + 16L, UNSAFE.getLong(source, sourceOff + 16L));
            }

            @Override
            void copyMemory(byte[] source, int sourceOff, byte[] target, int targetOff) {
                UNSAFE.putShort(target, UnsafeHelper.BYTE_ARRAY_OFFSET + (long)targetOff, UNSAFE.getShort(source, UnsafeHelper.BYTE_ARRAY_OFFSET + (long)sourceOff));
                target[targetOff + 2] = source[sourceOff + 2];
            }
        };
    }

    static MemoryOptimizer s4() {
        return new MemoryOptimizer(){

            @Override
            public char[] copyChars(char[] buf, int offset, int len) {
                char[] chars = new char[4];
                JSONUnsafe.putLong(chars, 0, JSONUnsafe.getLong(buf, offset));
                return chars;
            }

            @Override
            public byte[] copyBytes(byte[] buf, int offset, int len) {
                byte[] bytes = new byte[4];
                JSONUnsafe.putInt(bytes, 0, JSONUnsafe.getInt(buf, offset));
                return bytes;
            }

            @Override
            public String[] copy(String[] buf, int offset, int len) {
                return new String[]{buf[offset++], buf[offset++], buf[offset++], buf[offset]};
            }

            @Override
            public double[] copy(double[] buf, int offset, int len) {
                return new double[]{buf[offset++], buf[offset++], buf[offset++], buf[offset]};
            }

            @Override
            public long[] copy(long[] buf, int offset, int len) {
                return new long[]{buf[offset++], buf[offset++], buf[offset++], buf[offset]};
            }

            @Override
            void multipleCopyMemory(byte[] source, long sourceOff, byte[] target, long targetOff) {
                UNSAFE.putLong(target, targetOff, UNSAFE.getLong(source, sourceOff));
                UNSAFE.putLong(target, targetOff + 8L, UNSAFE.getLong(source, sourceOff + 8L));
                UNSAFE.putLong(target, targetOff + 16L, UNSAFE.getLong(source, sourceOff + 16L));
                UNSAFE.putLong(target, targetOff + 24L, UNSAFE.getLong(source, sourceOff + 24L));
            }

            @Override
            void copyMemory(byte[] source, int sourceOff, byte[] target, int targetOff) {
                UNSAFE.putInt(target, UnsafeHelper.BYTE_ARRAY_OFFSET + (long)targetOff, UNSAFE.getInt(source, UnsafeHelper.BYTE_ARRAY_OFFSET + (long)sourceOff));
            }
        };
    }

    static MemoryOptimizer s5() {
        return new MemoryOptimizer(){

            @Override
            public char[] copyChars(char[] buf, int offset, int len) {
                char[] chars = new char[5];
                JSONUnsafe.putLong(chars, 0, JSONUnsafe.getLong(buf, offset));
                chars[4] = buf[offset + 4];
                return chars;
            }

            @Override
            public byte[] copyBytes(byte[] buf, int offset, int len) {
                byte[] bytes = new byte[5];
                JSONUnsafe.putInt(bytes, 0, JSONUnsafe.getInt(buf, offset));
                bytes[4] = buf[offset + 4];
                return bytes;
            }

            @Override
            public String[] copy(String[] buf, int offset, int len) {
                return new String[]{buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset]};
            }

            @Override
            public double[] copy(double[] buf, int offset, int len) {
                return new double[]{buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset]};
            }

            @Override
            public long[] copy(long[] buf, int offset, int len) {
                return new long[]{buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset]};
            }

            @Override
            void multipleCopyMemory(byte[] source, long sourceOff, byte[] target, long targetOff) {
                UNSAFE.putLong(target, targetOff, UNSAFE.getLong(source, sourceOff));
                UNSAFE.putLong(target, targetOff + 8L, UNSAFE.getLong(source, sourceOff + 8L));
                UNSAFE.putLong(target, targetOff + 16L, UNSAFE.getLong(source, sourceOff + 16L));
                UNSAFE.putLong(target, targetOff + 24L, UNSAFE.getLong(source, sourceOff + 24L));
                UNSAFE.putLong(target, targetOff + 32L, UNSAFE.getLong(source, sourceOff + 32L));
            }

            @Override
            void copyMemory(byte[] source, int sourceOff, byte[] target, int targetOff) {
                UNSAFE.putInt(target, UnsafeHelper.BYTE_ARRAY_OFFSET + (long)targetOff, UNSAFE.getInt(source, UnsafeHelper.BYTE_ARRAY_OFFSET + (long)sourceOff));
                target[targetOff + 4] = source[sourceOff + 4];
            }
        };
    }

    static MemoryOptimizer s6() {
        return new MemoryOptimizer(){

            @Override
            public char[] copyChars(char[] buf, int offset, int len) {
                char[] chars = new char[6];
                JSONUnsafe.putLong(chars, 0, JSONUnsafe.getLong(buf, offset));
                JSONUnsafe.putInt(chars, 4, JSONUnsafe.getInt(buf, offset + 4));
                return chars;
            }

            @Override
            public byte[] copyBytes(byte[] buf, int offset, int len) {
                byte[] bytes = new byte[6];
                JSONUnsafe.putInt(bytes, 0, JSONUnsafe.getInt(buf, offset));
                JSONUnsafe.putShort(bytes, 4, JSONUnsafe.getShort(buf, offset + 4));
                return bytes;
            }

            @Override
            public String[] copy(String[] buf, int offset, int len) {
                return new String[]{buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset]};
            }

            @Override
            public double[] copy(double[] buf, int offset, int len) {
                return new double[]{buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset]};
            }

            @Override
            public long[] copy(long[] buf, int offset, int len) {
                return new long[]{buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset]};
            }

            @Override
            void multipleCopyMemory(byte[] source, long sourceOff, byte[] target, long targetOff) {
                UNSAFE.putLong(target, targetOff, UNSAFE.getLong(source, sourceOff));
                UNSAFE.putLong(target, targetOff + 8L, UNSAFE.getLong(source, sourceOff + 8L));
                UNSAFE.putLong(target, targetOff + 16L, UNSAFE.getLong(source, sourceOff + 16L));
                UNSAFE.putLong(target, targetOff + 24L, UNSAFE.getLong(source, sourceOff + 24L));
                UNSAFE.putLong(target, targetOff + 32L, UNSAFE.getLong(source, sourceOff + 32L));
                UNSAFE.putLong(target, targetOff + 40L, UNSAFE.getLong(source, sourceOff + 40L));
            }

            @Override
            void copyMemory(byte[] source, int sourceOff, byte[] target, int targetOff) {
                UNSAFE.putInt(target, UnsafeHelper.BYTE_ARRAY_OFFSET + (long)targetOff, UNSAFE.getInt(source, UnsafeHelper.BYTE_ARRAY_OFFSET + (long)sourceOff));
                UNSAFE.putShort(target, UnsafeHelper.BYTE_ARRAY_OFFSET + (long)targetOff + 4L, UNSAFE.getShort(source, UnsafeHelper.BYTE_ARRAY_OFFSET + (long)sourceOff + 4L));
            }
        };
    }

    static MemoryOptimizer s7() {
        return new MemoryOptimizer(){

            @Override
            public char[] copyChars(char[] buf, int offset, int len) {
                char[] chars = new char[7];
                JSONUnsafe.putLong(chars, 0, JSONUnsafe.getLong(buf, offset));
                JSONUnsafe.putLong(chars, 3, JSONUnsafe.getLong(buf, offset + 3));
                return chars;
            }

            @Override
            public byte[] copyBytes(byte[] buf, int offset, int len) {
                byte[] bytes = new byte[7];
                JSONUnsafe.putInt(bytes, 0, JSONUnsafe.getInt(buf, offset));
                JSONUnsafe.putInt(bytes, 3, JSONUnsafe.getInt(buf, offset + 3));
                return bytes;
            }

            @Override
            public String[] copy(String[] buf, int offset, int len) {
                return new String[]{buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset]};
            }

            @Override
            public double[] copy(double[] buf, int offset, int len) {
                return new double[]{buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset]};
            }

            @Override
            public long[] copy(long[] buf, int offset, int len) {
                return new long[]{buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset]};
            }

            @Override
            void multipleCopyMemory(byte[] source, long sourceOff, byte[] target, long targetOff) {
                UNSAFE.putLong(target, targetOff, UNSAFE.getLong(source, sourceOff));
                UNSAFE.putLong(target, targetOff + 8L, UNSAFE.getLong(source, sourceOff + 8L));
                UNSAFE.putLong(target, targetOff + 16L, UNSAFE.getLong(source, sourceOff + 16L));
                UNSAFE.putLong(target, targetOff + 24L, UNSAFE.getLong(source, sourceOff + 24L));
                UNSAFE.putLong(target, targetOff + 32L, UNSAFE.getLong(source, sourceOff + 32L));
                UNSAFE.putLong(target, targetOff + 40L, UNSAFE.getLong(source, sourceOff + 40L));
                UNSAFE.putLong(target, targetOff + 48L, UNSAFE.getLong(source, sourceOff + 48L));
            }

            @Override
            void copyMemory(byte[] source, int sourceOff, byte[] target, int targetOff) {
                UNSAFE.putInt(target, UnsafeHelper.BYTE_ARRAY_OFFSET + (long)targetOff, UNSAFE.getInt(source, UnsafeHelper.BYTE_ARRAY_OFFSET + (long)sourceOff));
                UNSAFE.putShort(target, UnsafeHelper.BYTE_ARRAY_OFFSET + (long)targetOff + 4L, UNSAFE.getShort(source, UnsafeHelper.BYTE_ARRAY_OFFSET + (long)sourceOff + 4L));
                target[targetOff + 6] = source[sourceOff + 6];
            }
        };
    }

    static MemoryOptimizer s8() {
        return new MemoryOptimizer(){

            @Override
            public char[] copyChars(char[] buf, int offset, int len) {
                char[] chars = new char[8];
                JSONUnsafe.putLong(chars, 0, JSONUnsafe.getLong(buf, offset));
                JSONUnsafe.putLong(chars, 4, JSONUnsafe.getLong(buf, offset + 4));
                return chars;
            }

            @Override
            public byte[] copyBytes(byte[] buf, int offset, int len) {
                byte[] bytes = new byte[8];
                JSONUnsafe.putLong(bytes, 0, JSONUnsafe.getLong(buf, offset));
                return bytes;
            }

            @Override
            public String[] copy(String[] buf, int offset, int len) {
                return new String[]{buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset]};
            }

            @Override
            public double[] copy(double[] buf, int offset, int len) {
                return new double[]{buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset]};
            }

            @Override
            public long[] copy(long[] buf, int offset, int len) {
                return new long[]{buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset]};
            }

            @Override
            void multipleCopyMemory(byte[] source, long sourceOff, byte[] target, long targetOff) {
                UNSAFE.putLong(target, targetOff, UNSAFE.getLong(source, sourceOff));
                UNSAFE.putLong(target, targetOff + 8L, UNSAFE.getLong(source, sourceOff + 8L));
                UNSAFE.putLong(target, targetOff + 16L, UNSAFE.getLong(source, sourceOff + 16L));
                UNSAFE.putLong(target, targetOff + 24L, UNSAFE.getLong(source, sourceOff + 24L));
                UNSAFE.putLong(target, targetOff + 32L, UNSAFE.getLong(source, sourceOff + 32L));
                UNSAFE.putLong(target, targetOff + 40L, UNSAFE.getLong(source, sourceOff + 40L));
                UNSAFE.putLong(target, targetOff + 48L, UNSAFE.getLong(source, sourceOff + 48L));
                UNSAFE.putLong(target, targetOff + 56L, UNSAFE.getLong(source, sourceOff + 56L));
            }

            @Override
            void copyMemory(byte[] source, int sourceOff, byte[] target, int targetOff) {
                UNSAFE.putLong(target, UnsafeHelper.BYTE_ARRAY_OFFSET + (long)targetOff, UNSAFE.getLong(source, UnsafeHelper.BYTE_ARRAY_OFFSET + (long)sourceOff));
            }
        };
    }

    static MemoryOptimizer s9() {
        return new MemoryOptimizer(){

            @Override
            public char[] copyChars(char[] buf, int offset, int len) {
                char[] chars = new char[9];
                JSONUnsafe.putLong(chars, 0, JSONUnsafe.getLong(buf, offset));
                JSONUnsafe.putLong(chars, 4, JSONUnsafe.getLong(buf, offset + 4));
                chars[8] = buf[offset + 8];
                return chars;
            }

            @Override
            public byte[] copyBytes(byte[] buf, int offset, int len) {
                byte[] bytes = new byte[9];
                JSONUnsafe.putLong(bytes, 0, JSONUnsafe.getLong(buf, offset));
                bytes[8] = buf[offset + 8];
                return bytes;
            }

            @Override
            public String[] copy(String[] buf, int offset, int len) {
                return new String[]{buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset]};
            }

            @Override
            public double[] copy(double[] buf, int offset, int len) {
                return new double[]{buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset]};
            }

            @Override
            public long[] copy(long[] buf, int offset, int len) {
                return new long[]{buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset]};
            }
        };
    }

    static MemoryOptimizer s10() {
        return new MemoryOptimizer(){

            @Override
            public char[] copyChars(char[] buf, int offset, int len) {
                char[] chars = new char[10];
                JSONUnsafe.putLong(chars, 0, JSONUnsafe.getLong(buf, offset));
                JSONUnsafe.putLong(chars, 4, JSONUnsafe.getLong(buf, offset + 4));
                JSONUnsafe.putInt(chars, 8, JSONUnsafe.getInt(buf, offset + 8));
                return chars;
            }

            @Override
            public byte[] copyBytes(byte[] buf, int offset, int len) {
                byte[] bytes = new byte[10];
                JSONUnsafe.putLong(bytes, 0, JSONUnsafe.getLong(buf, offset));
                JSONUnsafe.putShort(bytes, 8, JSONUnsafe.getShort(buf, offset + 8));
                return bytes;
            }

            @Override
            public String[] copy(String[] buf, int offset, int len) {
                return new String[]{buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset]};
            }

            @Override
            public double[] copy(double[] buf, int offset, int len) {
                return new double[]{buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset]};
            }

            @Override
            public long[] copy(long[] buf, int offset, int len) {
                return new long[]{buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset]};
            }
        };
    }

    static MemoryOptimizer s11() {
        return new MemoryOptimizer(){

            @Override
            public char[] copyChars(char[] buf, int offset, int len) {
                char[] chars = new char[11];
                JSONUnsafe.putLong(chars, 0, JSONUnsafe.getLong(buf, offset));
                JSONUnsafe.putLong(chars, 4, JSONUnsafe.getLong(buf, offset + 4));
                JSONUnsafe.putLong(chars, 7, JSONUnsafe.getLong(buf, offset + 7));
                return chars;
            }

            @Override
            public byte[] copyBytes(byte[] buf, int offset, int len) {
                byte[] bytes = new byte[11];
                JSONUnsafe.putLong(bytes, 0, JSONUnsafe.getLong(buf, offset));
                JSONUnsafe.putInt(bytes, 7, JSONUnsafe.getInt(buf, offset + 7));
                return bytes;
            }

            @Override
            public String[] copy(String[] buf, int offset, int len) {
                return new String[]{buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset]};
            }

            @Override
            public double[] copy(double[] buf, int offset, int len) {
                return new double[]{buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset]};
            }

            @Override
            public long[] copy(long[] buf, int offset, int len) {
                return new long[]{buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset]};
            }
        };
    }

    static MemoryOptimizer s12() {
        return new MemoryOptimizer(){

            @Override
            public char[] copyChars(char[] buf, int offset, int len) {
                char[] chars = new char[12];
                JSONUnsafe.putLong(chars, 0, JSONUnsafe.getLong(buf, offset));
                JSONUnsafe.putLong(chars, 4, JSONUnsafe.getLong(buf, offset + 4));
                JSONUnsafe.putLong(chars, 8, JSONUnsafe.getLong(buf, offset + 8));
                return chars;
            }

            @Override
            public byte[] copyBytes(byte[] buf, int offset, int len) {
                byte[] bytes = new byte[12];
                JSONUnsafe.putLong(bytes, 0, JSONUnsafe.getLong(buf, offset));
                JSONUnsafe.putInt(bytes, 8, JSONUnsafe.getInt(buf, offset + 8));
                return bytes;
            }

            @Override
            public String[] copy(String[] buf, int offset, int len) {
                return new String[]{buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset]};
            }

            @Override
            public double[] copy(double[] buf, int offset, int len) {
                return new double[]{buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset]};
            }

            @Override
            public long[] copy(long[] buf, int offset, int len) {
                return new long[]{buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset]};
            }
        };
    }

    static MemoryOptimizer s13() {
        return new MemoryOptimizer(){

            @Override
            public char[] copyChars(char[] buf, int offset, int len) {
                char[] chars = new char[13];
                JSONUnsafe.putLong(chars, 0, JSONUnsafe.getLong(buf, offset));
                JSONUnsafe.putLong(chars, 4, JSONUnsafe.getLong(buf, offset + 4));
                JSONUnsafe.putLong(chars, 8, JSONUnsafe.getLong(buf, offset + 8));
                chars[12] = buf[offset + 12];
                return chars;
            }

            @Override
            public byte[] copyBytes(byte[] buf, int offset, int len) {
                byte[] bytes = new byte[13];
                JSONUnsafe.putLong(bytes, 0, JSONUnsafe.getLong(buf, offset));
                JSONUnsafe.putLong(bytes, 5, JSONUnsafe.getLong(buf, offset + 5));
                return bytes;
            }

            @Override
            public String[] copy(String[] buf, int offset, int len) {
                return new String[]{buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset]};
            }

            @Override
            public double[] copy(double[] buf, int offset, int len) {
                return new double[]{buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset]};
            }

            @Override
            public long[] copy(long[] buf, int offset, int len) {
                return new long[]{buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset]};
            }
        };
    }

    static MemoryOptimizer s14() {
        return new MemoryOptimizer(){

            @Override
            public char[] copyChars(char[] buf, int offset, int len) {
                char[] chars = new char[14];
                JSONUnsafe.putLong(chars, 0, JSONUnsafe.getLong(buf, offset));
                JSONUnsafe.putLong(chars, 4, JSONUnsafe.getLong(buf, offset + 4));
                JSONUnsafe.putLong(chars, 8, JSONUnsafe.getLong(buf, offset + 8));
                JSONUnsafe.putInt(chars, 12, JSONUnsafe.getInt(buf, offset + 12));
                return chars;
            }

            @Override
            public byte[] copyBytes(byte[] buf, int offset, int len) {
                byte[] bytes = new byte[14];
                JSONUnsafe.putLong(bytes, 0, JSONUnsafe.getLong(buf, offset));
                JSONUnsafe.putLong(bytes, 6, JSONUnsafe.getLong(buf, offset + 6));
                return bytes;
            }

            @Override
            public String[] copy(String[] buf, int offset, int len) {
                return new String[]{buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset]};
            }

            @Override
            public double[] copy(double[] buf, int offset, int len) {
                return new double[]{buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset]};
            }

            @Override
            public long[] copy(long[] buf, int offset, int len) {
                return new long[]{buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset]};
            }
        };
    }

    static MemoryOptimizer s15() {
        return new MemoryOptimizer(){

            @Override
            public char[] copyChars(char[] buf, int offset, int len) {
                char[] chars = new char[15];
                JSONUnsafe.putLong(chars, 0, JSONUnsafe.getLong(buf, offset));
                JSONUnsafe.putLong(chars, 4, JSONUnsafe.getLong(buf, offset + 4));
                JSONUnsafe.putLong(chars, 8, JSONUnsafe.getLong(buf, offset + 8));
                JSONUnsafe.putLong(chars, 11, JSONUnsafe.getLong(buf, offset + 11));
                return chars;
            }

            @Override
            public byte[] copyBytes(byte[] buf, int offset, int len) {
                byte[] bytes = new byte[15];
                JSONUnsafe.putLong(bytes, 0, JSONUnsafe.getLong(buf, offset));
                JSONUnsafe.putLong(bytes, 7, JSONUnsafe.getLong(buf, offset + 7));
                return bytes;
            }

            @Override
            public String[] copy(String[] buf, int offset, int len) {
                return new String[]{buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset]};
            }

            @Override
            public double[] copy(double[] buf, int offset, int len) {
                return new double[]{buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset]};
            }

            @Override
            public long[] copy(long[] buf, int offset, int len) {
                return new long[]{buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset]};
            }
        };
    }

    static MemoryOptimizer s16() {
        return new MemoryOptimizer(){

            @Override
            public char[] copyChars(char[] buf, int offset, int len) {
                char[] chars = new char[16];
                JSONUnsafe.putLong(chars, 0, JSONUnsafe.getLong(buf, offset));
                JSONUnsafe.putLong(chars, 4, JSONUnsafe.getLong(buf, offset + 4));
                JSONUnsafe.putLong(chars, 8, JSONUnsafe.getLong(buf, offset + 8));
                JSONUnsafe.putLong(chars, 12, JSONUnsafe.getLong(buf, offset + 12));
                return chars;
            }

            @Override
            public byte[] copyBytes(byte[] buf, int offset, int len) {
                byte[] bytes = new byte[16];
                JSONUnsafe.putLong(bytes, 0, JSONUnsafe.getLong(buf, offset));
                JSONUnsafe.putLong(bytes, 8, JSONUnsafe.getLong(buf, offset + 8));
                return bytes;
            }

            @Override
            public String[] copy(String[] buf, int offset, int len) {
                return new String[]{buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset]};
            }

            @Override
            public double[] copy(double[] buf, int offset, int len) {
                return new double[]{buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset]};
            }

            @Override
            public long[] copy(long[] buf, int offset, int len) {
                return new long[]{buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset]};
            }
        };
    }

    static MemoryOptimizer s17() {
        return new MemoryOptimizer(){

            @Override
            public byte[] copyBytes(byte[] buf, int offset, int len) {
                byte[] bytes = new byte[17];
                JSONUnsafe.putLong(bytes, 0, JSONUnsafe.getLong(buf, offset));
                JSONUnsafe.putLong(bytes, 8, JSONUnsafe.getLong(buf, offset + 8));
                bytes[16] = buf[offset + 16];
                return bytes;
            }

            @Override
            public String[] copy(String[] buf, int offset, int len) {
                return new String[]{buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset]};
            }

            @Override
            public double[] copy(double[] buf, int offset, int len) {
                return new double[]{buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset]};
            }

            @Override
            public long[] copy(long[] buf, int offset, int len) {
                return new long[]{buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset]};
            }
        };
    }

    static MemoryOptimizer s18() {
        return new MemoryOptimizer(){

            @Override
            public byte[] copyBytes(byte[] buf, int offset, int len) {
                byte[] bytes = new byte[18];
                JSONUnsafe.putLong(bytes, 0, JSONUnsafe.getLong(buf, offset));
                JSONUnsafe.putLong(bytes, 8, JSONUnsafe.getLong(buf, offset + 8));
                JSONUnsafe.putShort(bytes, 16, JSONUnsafe.getShort(buf, offset + 16));
                return bytes;
            }

            @Override
            public String[] copy(String[] buf, int offset, int len) {
                return new String[]{buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset]};
            }

            @Override
            public double[] copy(double[] buf, int offset, int len) {
                return new double[]{buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset]};
            }

            @Override
            public long[] copy(long[] buf, int offset, int len) {
                return new long[]{buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset]};
            }
        };
    }

    static MemoryOptimizer s19() {
        return new MemoryOptimizer(){

            @Override
            public byte[] copyBytes(byte[] buf, int offset, int len) {
                byte[] bytes = new byte[19];
                JSONUnsafe.putLong(bytes, 0, JSONUnsafe.getLong(buf, offset));
                JSONUnsafe.putLong(bytes, 8, JSONUnsafe.getLong(buf, offset + 8));
                JSONUnsafe.putInt(bytes, 15, JSONUnsafe.getInt(buf, offset + 15));
                return bytes;
            }

            @Override
            public String[] copy(String[] buf, int offset, int len) {
                return new String[]{buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset]};
            }

            @Override
            public double[] copy(double[] buf, int offset, int len) {
                return new double[]{buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset]};
            }

            @Override
            public long[] copy(long[] buf, int offset, int len) {
                return new long[]{buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset]};
            }
        };
    }

    static MemoryOptimizer s20() {
        return new MemoryOptimizer(){

            @Override
            public byte[] copyBytes(byte[] buf, int offset, int len) {
                byte[] bytes = new byte[20];
                JSONUnsafe.putLong(bytes, 0, JSONUnsafe.getLong(buf, offset));
                JSONUnsafe.putLong(bytes, 8, JSONUnsafe.getLong(buf, offset + 8));
                JSONUnsafe.putInt(bytes, 16, JSONUnsafe.getInt(buf, offset + 16));
                return bytes;
            }

            @Override
            public String[] copy(String[] buf, int offset, int len) {
                return new String[]{buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset]};
            }

            @Override
            public double[] copy(double[] buf, int offset, int len) {
                return new double[]{buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset]};
            }

            @Override
            public long[] copy(long[] buf, int offset, int len) {
                return new long[]{buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset]};
            }
        };
    }

    static long getLong(byte[] buf, int offset) {
        return UNSAFE.getLong(buf, UnsafeHelper.BYTE_ARRAY_OFFSET + (long)offset);
    }

    static long getLong(char[] buf, int offset) {
        return UNSAFE.getLong(buf, UnsafeHelper.CHAR_ARRAY_OFFSET + (long)(offset << 1));
    }

    static int getInt(byte[] buf, int offset) {
        return UNSAFE.getInt(buf, UnsafeHelper.BYTE_ARRAY_OFFSET + (long)offset);
    }

    static int getInt(char[] buf, int offset) {
        return UNSAFE.getInt(buf, UnsafeHelper.CHAR_ARRAY_OFFSET + (long)(offset << 1));
    }

    static short getShort(byte[] buf, int offset) {
        return UNSAFE.getShort(buf, UnsafeHelper.BYTE_ARRAY_OFFSET + (long)offset);
    }

    static int putInt(char[] buf, int offset, int value) {
        UNSAFE.putInt(buf, UnsafeHelper.CHAR_ARRAY_OFFSET + (long)(offset << 1), value);
        return 2;
    }

    static int putLong(char[] buf, int offset, long value) {
        UNSAFE.putLong(buf, UnsafeHelper.CHAR_ARRAY_OFFSET + (long)(offset << 1), value);
        return 4;
    }

    static int putLong(byte[] buf, int offset, long value) {
        UNSAFE.putLong(buf, UnsafeHelper.BYTE_ARRAY_OFFSET + (long)offset, value);
        return 8;
    }

    static int putInt(byte[] buf, int offset, int value) {
        UNSAFE.putInt(buf, UnsafeHelper.BYTE_ARRAY_OFFSET + (long)offset, value);
        return 4;
    }

    static int putShort(byte[] buf, int offset, short value) {
        UNSAFE.putShort(buf, UnsafeHelper.BYTE_ARRAY_OFFSET + (long)offset, value);
        return 2;
    }

    public static char[] copyChars(char[] buf, int offset, int len) {
        if (len < 16) {
            return SIZE_INSTANCES[len].copyChars(buf, offset, len);
        }
        char[] chars = new char[len];
        System.arraycopy(buf, offset, chars, 0, len);
        return chars;
    }

    public static byte[] copyBytes(byte[] buf, int offset, int len) {
        if (len < SIZE_LEN) {
            return SIZE_INSTANCES[len].copyBytes(buf, offset, len);
        }
        byte[] bytes = new byte[len];
        if (len < 72) {
            int rem = len & 7;
            int t = len >> 3;
            long sourceOff = UnsafeHelper.BYTE_ARRAY_OFFSET + (long)offset;
            SIZE_INSTANCES[t].multipleCopyMemory(buf, sourceOff, bytes, UnsafeHelper.BYTE_ARRAY_OFFSET);
            if (rem > 0) {
                int remOffset = t << 3;
                JSONUnsafe.putLong(bytes, remOffset - 8 + rem, JSONUnsafe.getLong(buf, offset + remOffset - 8 + rem));
            }
            return bytes;
        }
        System.arraycopy(buf, offset, bytes, 0, len);
        return bytes;
    }

    public static String[] copyStrings(String[] buf, int offset, int len) {
        if (len < SIZE_LEN) {
            return SIZE_INSTANCES[len].copy(buf, offset, len);
        }
        String[] result = new String[len];
        System.arraycopy(buf, offset, result, 0, len);
        return result;
    }

    public static double[] copyDoubles(double[] buf, int offset, int len) {
        if (len < SIZE_LEN) {
            return SIZE_INSTANCES[len].copy(buf, offset, len);
        }
        double[] result = new double[len];
        System.arraycopy(buf, offset, result, 0, len);
        return result;
    }

    public static long[] copyLongs(long[] buf, int offset, int len) {
        if (len < SIZE_LEN) {
            return SIZE_INSTANCES[len].copy(buf, offset, len);
        }
        long[] result = new long[len];
        System.arraycopy(buf, offset, result, 0, len);
        return result;
    }

    static String createAsciiString(byte[] bytes, int offset, int len) {
        try {
            byte[] asciiBytes = JSONUnsafe.copyBytes(bytes, offset, len);
            String result = (String)UNSAFE.allocateInstance(String.class);
            UNSAFE.putObject(result, UnsafeHelper.STRING_VALUE_OFFSET, asciiBytes);
            return result;
        }
        catch (InstantiationException e) {
            throw new RuntimeException(e);
        }
    }

    public static boolean equals(byte[] a, int aOffset, byte[] b, int bOffset, int len, long remValueForBytes) {
        if (len >= 8) {
            do {
                long lb;
                long la;
                if ((la = JSONUnsafe.getLong(a, aOffset)) != (lb = JSONUnsafe.getLong(b, bOffset))) {
                    return false;
                }
                aOffset += 8;
                bOffset += 8;
            } while ((len -= 8) >= 8);
            if (len == 0) {
                return true;
            }
            int padd = 8 - len;
            return JSONUnsafe.getLong(a, aOffset -= padd) == JSONUnsafe.getLong(b, bOffset -= padd);
        }
        if (len >= 4) {
            int lb;
            int la = JSONUnsafe.getInt(a, aOffset);
            if (la != (lb = JSONUnsafe.getInt(b, bOffset))) {
                return false;
            }
            int v = len - 4;
            if (v == 0) {
                return true;
            }
            return JSONUnsafe.getInt(a, aOffset += v) == JSONUnsafe.getInt(b, bOffset += v);
        }
        switch (len) {
            case 1: {
                return (long)a[aOffset] == remValueForBytes;
            }
            case 2: {
                return (long)JSONUnsafe.getShort(a, aOffset) == remValueForBytes;
            }
        }
        return a[aOffset++] == b[bOffset] && (long)JSONUnsafe.getShort(a, aOffset) == remValueForBytes;
    }

    public static boolean equals(char[] a, int aOffset, char[] b, int bOffset, int len, long remValueForChars) {
        if (len >= 4) {
            do {
                long lb;
                long la;
                if ((la = JSONUnsafe.getLong(a, aOffset)) != (lb = JSONUnsafe.getLong(b, bOffset))) {
                    return false;
                }
                aOffset += 4;
                bOffset += 4;
            } while ((len -= 4) >= 4);
            if (len == 0) {
                return true;
            }
            int v = 4 - len;
            return JSONUnsafe.getLong(a, aOffset -= v) == JSONUnsafe.getLong(b, bOffset -= v);
        }
        switch (len) {
            case 1: {
                return (long)a[aOffset] == remValueForChars;
            }
            case 2: {
                return (long)JSONUnsafe.getInt(a, aOffset) == remValueForChars;
            }
        }
        return a[aOffset++] == b[bOffset] && (long)JSONUnsafe.getInt(a, aOffset) == remValueForChars;
    }

    public static void main(String[] args) {
        char[] chars = "hellohelulollqwewewe".toCharArray();
        char[] results = JSONUnsafe.copyChars(chars, 0, chars.length);
        System.out.println(new String(chars));
        System.out.println(new String(results));
    }

    static {
        Field theUnsafeField;
        try {
            theUnsafeField = Unsafe.class.getDeclaredField("theUnsafe");
            theUnsafeField.setAccessible(true);
        }
        catch (NoSuchFieldException exception) {
            theUnsafeField = null;
        }
        Unsafe instance = null;
        if (theUnsafeField != null) {
            try {
                instance = (Unsafe)theUnsafeField.get(null);
            }
            catch (IllegalAccessException exception) {
                throw new RuntimeException(exception);
            }
        }
        UNSAFE = instance;
        SIZE_INSTANCES = new MemoryOptimizer[]{JSONUnsafe.s0(), JSONUnsafe.s1(), JSONUnsafe.s2(), JSONUnsafe.s3(), JSONUnsafe.s4(), JSONUnsafe.s5(), JSONUnsafe.s6(), JSONUnsafe.s7(), JSONUnsafe.s8(), JSONUnsafe.s9(), JSONUnsafe.s10(), JSONUnsafe.s11(), JSONUnsafe.s12(), JSONUnsafe.s13(), JSONUnsafe.s14(), JSONUnsafe.s15(), JSONUnsafe.s16(), JSONUnsafe.s17(), JSONUnsafe.s18(), JSONUnsafe.s19(), JSONUnsafe.s20()};
        SIZE_LEN = SIZE_INSTANCES.length;
        SIZE_INSTANCE_8 = SIZE_INSTANCES[8];
    }

    static abstract class MemoryOptimizer {
        MemoryOptimizer() {
        }

        public String[] copy(String[] buf, int offset, int len) {
            String[] result = new String[len];
            System.arraycopy(buf, offset, result, 0, len);
            return result;
        }

        public double[] copy(double[] buf, int offset, int len) {
            double[] result = new double[len];
            System.arraycopy(buf, offset, result, 0, len);
            return result;
        }

        public long[] copy(long[] buf, int offset, int len) {
            long[] result = new long[len];
            System.arraycopy(buf, offset, result, 0, len);
            return result;
        }

        public char[] copyChars(char[] buf, int offset, int len) {
            char[] result = new char[len];
            System.arraycopy(buf, offset, result, 0, len);
            return result;
        }

        public byte[] copyBytes(byte[] buf, int offset, int len) {
            byte[] result = new byte[len];
            System.arraycopy(buf, offset, result, 0, len);
            return result;
        }

        void multipleCopyMemory(byte[] source, long sourceOff, byte[] target, long targetOff) {
        }

        void copyMemory(byte[] source, int sourceOff, byte[] target, int targetOff) {
        }
    }
}

