/*
 * Decompiled with CFR 0.152.
 */
package io.github.wycst.wast.json.temporal;

import io.github.wycst.wast.json.JSONConfig;
import io.github.wycst.wast.json.JSONTemporalSerializer;
import io.github.wycst.wast.json.JSONWriter;
import io.github.wycst.wast.json.annotations.JsonProperty;
import java.time.OffsetDateTime;

public class TemporalOffsetDateTimeSerializer
extends JSONTemporalSerializer {
    public TemporalOffsetDateTimeSerializer(Class<?> temporalClass, JsonProperty property) {
        super(temporalClass, property);
    }

    @Override
    protected void checkClass(Class<?> temporalClass) {
    }

    @Override
    protected void writeTemporalWithTemplate(Object value, JSONWriter writer, JSONConfig jsonConfig) throws Exception {
        OffsetDateTime offsetDateTime = (OffsetDateTime)value;
        writer.write(34);
        TemporalOffsetDateTimeSerializer.writeDate(offsetDateTime.getYear(), offsetDateTime.getMonthValue(), offsetDateTime.getDayOfMonth(), offsetDateTime.getHour(), offsetDateTime.getMinute(), offsetDateTime.getSecond(), offsetDateTime.getNano() / 1000000, this.dateFormatter, writer);
        String zoneId = offsetDateTime.getOffset().toString();
        writer.writeZoneId(zoneId);
        writer.write(34);
    }

    @Override
    protected void writeDefault(Object value, JSONWriter writer, JSONConfig jsonConfig, int indent) throws Exception {
        OffsetDateTime offsetDateTime = (OffsetDateTime)value;
        writer.writeJSONLocalDateTime(offsetDateTime.getYear(), offsetDateTime.getMonthValue(), offsetDateTime.getDayOfMonth(), offsetDateTime.getHour(), offsetDateTime.getMinute(), offsetDateTime.getSecond(), offsetDateTime.getNano(), offsetDateTime.getOffset().toString());
    }
}

