/*
 * Decompiled with CFR 0.152.
 */
package io.github.wycst.wast.yaml;

import io.github.wycst.wast.common.reflect.UnsafeHelper;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

class YamlGeneral {
    public static final boolean IS_WINDOW_OS;
    protected static final char SPACE_CHAR = ' ';
    protected static final char SPLIT_CHAR = ':';
    protected static Map<String, Integer> typeValues;

    YamlGeneral() {
    }

    protected static final char[] getChars(String value) {
        return UnsafeHelper.getChars(value);
    }

    protected static final int parseInt(char[] buffers, int fromIndex, int len, int radix) throws NumberFormatException {
        if (buffers == null) {
            throw new NumberFormatException("null");
        }
        int result = 0;
        boolean negative = false;
        int i = 0;
        int limit = -2147483647;
        if (len > 0) {
            char firstChar = buffers[fromIndex];
            if (firstChar < '0') {
                if (firstChar == '-') {
                    negative = true;
                    limit = Integer.MIN_VALUE;
                } else if (firstChar != '+') {
                    return 1 / 0;
                }
                if (len == 1) {
                    return 1 / 0;
                }
                ++i;
            }
            int multmin = limit / radix;
            while (i < len) {
                int digit;
                if ((digit = Character.digit(buffers[fromIndex + i++], radix)) < 0) {
                    return 1 / 0;
                }
                if (result < multmin) {
                    return 1 / 0;
                }
                if ((result *= radix) < limit + digit) {
                    return 1 / 0;
                }
                result -= digit;
            }
        } else {
            return 0;
        }
        return negative ? result : -result;
    }

    static {
        typeValues = new ConcurrentHashMap<String, Integer>();
        typeValues.put("str", 1);
        typeValues.put("float", 2);
        typeValues.put("int", 3);
        typeValues.put("bool", 4);
        typeValues.put("binary", 5);
        typeValues.put("timestamp", 6);
        typeValues.put("set", 7);
        typeValues.put("omap", 8);
        typeValues.put("pairs", 8);
        typeValues.put("seq", 9);
        typeValues.put("map", 10);
        IS_WINDOW_OS = System.getProperty("os.name").toLowerCase().contains("windows");
    }
}

