/*
 * Decompiled with CFR 0.152.
 */
package io.github.wycst.wast.clients.http.provider;

import io.github.wycst.wast.clients.http.HttpClient;
import io.github.wycst.wast.clients.http.provider.DefaultServiceProvider;
import io.github.wycst.wast.clients.http.provider.FetchPropertiesCallback;
import io.github.wycst.wast.common.utils.ExecutorServiceUtils;
import java.util.Properties;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;

public abstract class CloudServiceProvider
extends DefaultServiceProvider {
    protected final HttpClient httpClient = new HttpClient();
    protected final ScheduledExecutorService scheduledExecutorService;
    protected ScheduledFuture<?> serviceScheduledFuture;
    protected ScheduledFuture<?> healthyCheckScheduledFuture;
    protected ScheduledFuture<?> tokenRefreshScheduledFuture;
    protected final Properties properties;
    protected FetchPropertiesCallback fetchPropertiesCallback;
    protected boolean enableClient;
    protected long instanceCheckHealthyInterval;
    protected boolean instanceEnable;
    protected boolean status;
    private final long serviceUpdateInterval = 60L;

    public CloudServiceProvider(Properties nacosProperties, FetchPropertiesCallback fetchPropertiesCallback) {
        this.properties = nacosProperties;
        this.fetchPropertiesCallback = fetchPropertiesCallback;
        this.scheduledExecutorService = Executors.newScheduledThreadPool(3);
        this.init();
    }

    public void setFetchPropertiesCallback(FetchPropertiesCallback fetchPropertiesCallback) {
        this.fetchPropertiesCallback = fetchPropertiesCallback;
    }

    private void init() {
        this.initBase();
        if (!this.enableClient) {
            return;
        }
        this.fetchClientConfig();
        this.setHttpClientServiceProvider();
        if (this.autoSchedule()) {
            this.scheduleTask();
        }
    }

    protected abstract void fetchClientConfig();

    public void scheduleTask() {
        if (!this.enableClient) {
            return;
        }
        this.initInstanceConfig();
        this.fetchServiceList();
        if (this.instanceEnable) {
            this.registerInstance();
            this.beginHealthyCheck();
        }
    }

    public void fetchServiceList() {
        this.cancelServiceScheduled();
        this.serviceScheduledFuture = this.scheduledExecutorService.scheduleWithFixedDelay(new Runnable(){

            @Override
            public void run() {
                if (CloudServiceProvider.this.status) {
                    CloudServiceProvider.this.fetchServiceInstanceList();
                }
            }
        }, 0L, this.serviceUpdateInterval, TimeUnit.SECONDS);
        this.scheduledExecutorService.execute(new Runnable(){

            @Override
            public void run() {
                CloudServiceProvider.this.fetchServiceInstanceList();
            }
        });
    }

    protected abstract void fetchServiceInstanceList();

    protected final void setHttpClientServiceProvider() {
        this.httpClient.setServiceProvider(this);
        this.httpClient.setEnableLoadBalance(true);
    }

    protected boolean autoSchedule() {
        return true;
    }

    protected abstract void initBase();

    protected abstract void initInstanceConfig();

    protected abstract void registerInstance();

    public String getProperty(String key) {
        return this.properties.getProperty(key);
    }

    private void cancelServiceScheduled() {
        if (this.serviceScheduledFuture != null) {
            this.serviceScheduledFuture.cancel(true);
        }
    }

    private void cancelHealthyCheckScheduled() {
        if (this.healthyCheckScheduledFuture != null) {
            this.healthyCheckScheduledFuture.cancel(true);
        }
    }

    private void cancelTokenRefreshScheduled() {
        if (this.tokenRefreshScheduledFuture != null) {
            this.tokenRefreshScheduledFuture.cancel(true);
        }
    }

    public void shutdownExecutorService() {
        ExecutorServiceUtils.shutdownExecutorService(this.scheduledExecutorService);
    }

    private void beginHealthyCheck() {
        this.cancelHealthyCheckScheduled();
        if (this.instanceCheckHealthyInterval > 0L) {
            this.scheduledExecutorService.scheduleWithFixedDelay(new Runnable(){

                @Override
                public void run() {
                    CloudServiceProvider.this.doHealthyCheck();
                }
            }, 0L, this.instanceCheckHealthyInterval, TimeUnit.SECONDS);
        }
    }

    protected abstract void doHealthyCheck();

    @Override
    public void destroy() {
        super.clear();
        if (this.properties != null) {
            this.properties.clear();
        }
        this.cancelScheduled();
        this.shutdownExecutorService();
    }

    public void cancelScheduled() {
        this.cancelServiceScheduled();
        this.cancelHealthyCheckScheduled();
        this.cancelTokenRefreshScheduled();
    }
}

