/*
 * Decompiled with CFR 0.152.
 */
package io.github.wycst.wast.common.beans;

import io.github.wycst.wast.common.beans.DateTemplate;
import io.github.wycst.wast.common.beans.GregorianDate;

public class DateParser {
    private static DateTemplate[] pattern_21bit = new DateTemplate[]{new DateTemplate("yyyy.MM.dd HH:mm:ss.S")};
    private static DateTemplate[] pattern_19bit = new DateTemplate[]{new DateTemplate("yyyy.MM.dd HH:mm:ss")};
    private static DateTemplate[] pattern_10bit = new DateTemplate[]{new DateTemplate("yyyy.MM.dd")};
    private static DateTemplate[] pattern_8bit = new DateTemplate[]{new DateTemplate("yyyyMMdd")};
    private static DateTemplate[] pattern_others = new DateTemplate[]{new DateTemplate("Y.M.d H:m:s"), new DateTemplate("M.d.Y H:m:s"), new DateTemplate("Y.M.d H:m"), new DateTemplate("M.d.Y H:m"), new DateTemplate("Y.M.d"), new DateTemplate("M.d.Y")};

    public static long parseTime(String originDate) {
        originDate = originDate.trim();
        int len = originDate.length();
        switch (len) {
            case 8: {
                return DateParser.parseTime(originDate, pattern_8bit);
            }
            case 10: {
                return DateParser.parseTime(originDate, pattern_10bit);
            }
            case 19: {
                return DateParser.parseTime(originDate, pattern_19bit);
            }
            case 21: 
            case 22: 
            case 23: {
                return DateParser.parseTime(originDate, pattern_21bit);
            }
        }
        return DateParser.parseTime(originDate, pattern_others);
    }

    public static GregorianDate parseDate(String originDate) {
        originDate = originDate.trim();
        int len = originDate.length();
        switch (len) {
            case 8: {
                return DateParser.parseDate(originDate, pattern_8bit);
            }
            case 10: {
                return DateParser.parseDate(originDate, pattern_10bit);
            }
            case 19: {
                return DateParser.parseDate(originDate, pattern_19bit);
            }
            case 21: 
            case 22: 
            case 23: {
                return DateParser.parseDate(originDate, pattern_21bit);
            }
        }
        return DateParser.parseDate(originDate, pattern_others);
    }

    private static long parseTime(String originDate, DateTemplate[] dateTemplates) {
        return DateParser.parseDate(originDate, dateTemplates).getTime();
    }

    private static GregorianDate parseDate(String originDate, DateTemplate[] dateTemplates) {
        for (DateTemplate dateTemplate : dateTemplates) {
            try {
                return dateTemplate.parse(originDate);
            }
            catch (Exception exception) {
            }
        }
        throw new IllegalArgumentException(String.format("date input '%s' not matched any format", originDate));
    }
}

