/*
 * Decompiled with CFR 0.152.
 */
package io.github.wycst.wast.common.expression;

import io.github.wycst.wast.common.expression.EvaluateEnvironment;
import io.github.wycst.wast.common.expression.EvaluatorContext;
import io.github.wycst.wast.common.expression.ExprChildParser;
import io.github.wycst.wast.common.expression.ExprFunction;
import io.github.wycst.wast.common.expression.ExprParser;
import io.github.wycst.wast.common.expression.ExprUtils;
import io.github.wycst.wast.common.expression.ExpressionException;
import io.github.wycst.wast.common.expression.invoker.VariableInvoker;
import io.github.wycst.wast.common.utils.ObjectUtils;
import io.github.wycst.wast.common.utils.ReflectUtils;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;

public class ExprEvaluator {
    protected int evalType;
    protected int opsType;
    ExprEvaluator left;
    ExprEvaluator right;
    int level = -1;
    boolean negate;
    boolean logicalNot;
    boolean isStatic;
    Object result;
    static final int OPTIMIZE_DEPTH_VALUE = 1024;
    private static ThreadLocal<Object> valueHolder = new ThreadLocal();

    public boolean isStaticExpr() {
        if (this.opsType == 70) {
            return false;
        }
        if (this.left == null && this.right == null) {
            return this.isStatic;
        }
        if (this.left == null) {
            return this.right.isStaticExpr();
        }
        if (this.right == null) {
            return this.left.isStaticExpr();
        }
        return this.left.isStaticExpr() && this.right.isStaticExpr();
    }

    public int getEvalType() {
        return this.evalType;
    }

    public void setEvalType(int evalType) {
        this.evalType = evalType;
    }

    public void setOperator(int opsType, int level) {
        this.opsType = opsType;
        this.level = level;
    }

    public ExprEvaluator getLeft() {
        return this.left;
    }

    public void setLeft(ExprEvaluator left) {
        this.left = left;
    }

    public ExprEvaluator getRight() {
        return this.right;
    }

    public void setRight(ExprEvaluator right) {
        this.right = right;
    }

    String[] parseStringArr(String splitStr, AtomicInteger atomicInteger, AtomicBoolean strArr, AtomicBoolean doubleArr) {
        int length = splitStr.length();
        boolean isStrArr = false;
        boolean isDoubleArr = false;
        String[] strings = new String[10];
        int beginIndex = 0;
        int arrLen = 0;
        int bracketCount = 0;
        int bigBracketCount = 0;
        for (int i = 0; i < length; ++i) {
            char ch = splitStr.charAt(i);
            if (!isStrArr && ch == '\'') {
                isStrArr = true;
            }
            if (!isDoubleArr && ch == '.') {
                isDoubleArr = true;
            }
            if (ch == '(') {
                ++bracketCount;
                continue;
            }
            if (ch == ')') {
                --bracketCount;
                continue;
            }
            if (ch == '{') {
                ++bigBracketCount;
                continue;
            }
            if (ch == '}') {
                --bigBracketCount;
                continue;
            }
            if (bracketCount != 0 || bigBracketCount != 0 || ch != ',') continue;
            if (arrLen == strings.length) {
                String[] tmp = strings;
                strings = new String[strings.length << 1];
                System.arraycopy(tmp, 0, strings, 0, tmp.length);
            }
            String val = new String(splitStr.substring(beginIndex, i)).trim();
            strings[arrLen++] = val;
            beginIndex = i + 1;
        }
        if (arrLen == strings.length) {
            String[] tmp = strings;
            strings = new String[strings.length << 1];
            System.arraycopy(tmp, 0, strings, 0, tmp.length);
        }
        strings[arrLen++] = new String(splitStr.substring(beginIndex, length)).trim();
        atomicInteger.set(arrLen);
        strArr.set(isStrArr);
        doubleArr.set(isDoubleArr);
        return strings;
    }

    public void setArrayValue(String splitStr) {
        this.isStatic = true;
        int length = (splitStr = splitStr.trim()).length();
        if (length == 0) {
            this.result = new Object[0];
            return;
        }
        AtomicInteger atomicInteger = new AtomicInteger();
        AtomicBoolean strArr = new AtomicBoolean();
        AtomicBoolean doubleArr = new AtomicBoolean();
        String[] strings = this.parseStringArr(splitStr, atomicInteger, strArr, doubleArr);
        int arrLen = atomicInteger.get();
        boolean isStrArr = strArr.get();
        boolean isDoubleArr = doubleArr.get();
        Object[] result = isStrArr ? new String[arrLen] : (isDoubleArr ? new Double[arrLen] : new Long[arrLen]);
        for (int i = 0; i < arrLen; ++i) {
            String val = strings[i];
            if (isStrArr) {
                if (!val.startsWith("'") || !val.endsWith("'")) {
                    throw new ExpressionException("\u65e0\u6548\u7684\u5b57\u7b26\u4e32\u6570\u7ec4\u5143\u7d20: " + val + ", \u6570\u7ec4\u7247\u6bb5\uff1a '" + splitStr + "'");
                }
                val = new String(val.substring(1, val.length() - 1));
                result[i] = val;
                continue;
            }
            result[i] = isDoubleArr ? (Number)Double.parseDouble(val.trim()) : (Number)Long.parseLong(val.trim());
        }
        this.result = result;
    }

    public boolean isNegate() {
        return this.negate;
    }

    public boolean isLogicalNot() {
        return this.logicalNot;
    }

    public void setNegate(boolean negate) {
        this.negate = negate;
    }

    public void setLogicalNot(boolean logicalNot) {
        this.logicalNot = logicalNot;
    }

    public Object evaluate() {
        return this.evaluate(null, EvaluateEnvironment.DefaultEnvironment);
    }

    public Object evaluate(EvaluatorContext context, EvaluateEnvironment evaluateEnvironment) {
        if (this.isStatic) {
            return this.result;
        }
        if (this.evalType == 0) {
            this.result = this.left.evaluate(context, evaluateEnvironment);
            this.isStatic = this.left.isStatic;
            return this.result;
        }
        if (this.evalType == 1) {
            Object leftValue = this.left.evaluate(context, evaluateEnvironment);
            if (this.right == null) {
                this.isStatic = this.left.isStatic;
                this.result = leftValue;
                return this.result;
            }
            Object rightValue = null;
            if (this.opsType == 71) {
                Object result = this.right.evaluateTernary(context, evaluateEnvironment, (Boolean)leftValue, this.left.isStatic);
                boolean bl = this.isStatic = this.left.isStatic && this.right.isStatic;
                if (this.isStatic) {
                    this.result = result;
                }
                return result;
            }
            rightValue = this.right.evaluate(context, evaluateEnvironment);
            if (evaluateEnvironment.isAutoParseStringAsDouble()) {
                if (leftValue instanceof String) {
                    leftValue = Double.parseDouble(leftValue.toString());
                }
                if (rightValue instanceof String) {
                    rightValue = Double.parseDouble(rightValue.toString());
                }
            }
            this.isStatic = this.left.isStatic && this.right.isStatic;
            boolean isDouble = leftValue instanceof Double || rightValue instanceof Double;
            switch (this.opsType) {
                case 1: {
                    this.result = isDouble ? (Number)(((Number)leftValue).doubleValue() * ((Number)rightValue).doubleValue()) : (Number)(((Number)leftValue).longValue() * ((Number)rightValue).longValue());
                    return this.result;
                }
                case 2: {
                    this.result = isDouble ? (Number)(((Number)leftValue).doubleValue() / ((Number)rightValue).doubleValue()) : (Number)(((Number)leftValue).longValue() / ((Number)rightValue).longValue());
                    return this.result;
                }
                case 3: {
                    this.result = isDouble ? (Number)(((Number)leftValue).doubleValue() % ((Number)rightValue).doubleValue()) : (Number)(((Number)leftValue).longValue() % ((Number)rightValue).longValue());
                    return this.result;
                }
                case 4: {
                    this.result = isDouble ? Double.valueOf(Math.pow(((Number)leftValue).doubleValue(), ((Number)rightValue).doubleValue())) : Double.valueOf(Math.pow(((Number)leftValue).longValue(), ((Number)rightValue).longValue()));
                    return this.result;
                }
                case 11: {
                    if (leftValue instanceof Number && rightValue instanceof Number) {
                        this.result = isDouble ? (Number)(((Number)leftValue).doubleValue() + ((Number)rightValue).doubleValue()) : (Number)(((Number)leftValue).longValue() + ((Number)rightValue).longValue());
                        return this.result;
                    }
                    return leftValue + String.valueOf(rightValue);
                }
                case 12: {
                    this.result = isDouble ? (Number)(((Number)leftValue).doubleValue() - ((Number)rightValue).doubleValue()) : (Number)(((Number)leftValue).longValue() - ((Number)rightValue).longValue());
                    return this.result;
                }
                case 21: {
                    this.result = ((Number)leftValue).longValue() >> (int)((Number)rightValue).longValue();
                    return this.result;
                }
                case 22: {
                    this.result = ((Number)leftValue).longValue() << (int)((Number)rightValue).longValue();
                    return this.result;
                }
                case 31: {
                    this.result = ((Number)leftValue).longValue() & ((Number)rightValue).longValue();
                    return this.result;
                }
                case 32: {
                    this.result = ((Number)leftValue).longValue() ^ ((Number)rightValue).longValue();
                    return this.result;
                }
                case 33: {
                    this.result = ((Number)leftValue).longValue() | ((Number)rightValue).longValue();
                    return this.result;
                }
                case 51: {
                    this.result = ((Number)leftValue).doubleValue() > ((Number)rightValue).doubleValue();
                    return this.result;
                }
                case 52: {
                    this.result = ((Number)leftValue).doubleValue() < ((Number)rightValue).doubleValue();
                    return this.result;
                }
                case 53: {
                    if (leftValue instanceof Number && rightValue instanceof Number) {
                        this.result = ((Number)leftValue).doubleValue() == ((Number)rightValue).doubleValue();
                        return this.result;
                    }
                    if (leftValue == rightValue) {
                        this.result = true;
                        return this.result;
                    }
                    this.result = leftValue != null && leftValue.equals(rightValue);
                    return this.result;
                }
                case 54: {
                    this.result = ((Number)leftValue).doubleValue() >= ((Number)rightValue).doubleValue();
                    return this.result;
                }
                case 55: {
                    this.result = ((Number)leftValue).doubleValue() <= ((Number)rightValue).doubleValue();
                    return this.result;
                }
                case 56: {
                    if (leftValue instanceof Number && rightValue instanceof Number) {
                        this.result = ((Number)leftValue).doubleValue() != ((Number)rightValue).doubleValue();
                        return this.result;
                    }
                    if (leftValue == rightValue) {
                        this.result = false;
                        return this.result;
                    }
                    this.result = leftValue == null || !leftValue.equals(rightValue);
                    return this.result;
                }
                case 61: {
                    this.result = (Boolean)leftValue != false && (Boolean)rightValue != false;
                    return this.result;
                }
                case 62: {
                    this.result = (Boolean)leftValue != false || (Boolean)rightValue != false;
                    return this.result;
                }
                case 63: {
                    this.result = this.evaluateIn(leftValue, rightValue);
                    return this.result;
                }
                case 64: {
                    this.result = !this.evaluateIn(leftValue, rightValue);
                    return this.result;
                }
                case 70: {
                    throw new ExpressionException(" \u4e0d\u652f\u6301\u5355\u72ec\u4f7f\u7528\u5192\u53f7\u8fd0\u7b97\u7b26: ':'");
                }
                case 71: {
                    return this.right.evaluateTernary(context, evaluateEnvironment, (Boolean)leftValue, this.left.isStatic);
                }
            }
        } else {
            if (this.evalType == 5) {
                Object bracketValue = this.right.evaluate(context, evaluateEnvironment);
                this.isStatic = this.right.isStatic;
                if (this.negate) {
                    this.result = ExprUtils.getNegateNumber(bracketValue);
                    return this.result;
                }
                if (this.logicalNot) {
                    this.result = bracketValue == Boolean.FALSE || bracketValue == null;
                    return this.result;
                }
                this.result = bracketValue;
                return this.result;
            }
            if (this.evalType == 6) {
                throw new UnsupportedOperationException();
            }
            if (this.evalType == 7) {
                throw new UnsupportedOperationException();
            }
            if (this.evalType == 9) {
                throw new UnsupportedOperationException();
            }
            this.result = this.left.evaluate(context, evaluateEnvironment);
            this.isStatic = this.left.isStatic;
            return this.result;
        }
        return null;
    }

    boolean evaluateIn(Object leftValue, Object rightValue) {
        if (leftValue == null || rightValue == null) {
            return false;
        }
        if (rightValue instanceof Collection) {
            Collection collection = (Collection)rightValue;
            for (Object value : collection) {
                boolean isEqual = this.execEquals(value, leftValue);
                if (!isEqual) continue;
                return true;
            }
        } else if (rightValue.getClass().isArray()) {
            int length = Array.getLength(rightValue);
            for (int i = 0; i < length; ++i) {
                Object value = Array.get(rightValue, i);
                boolean isEqual = this.execEquals(value, leftValue);
                if (!isEqual) continue;
                return true;
            }
        } else {
            if (rightValue instanceof Number || rightValue instanceof CharSequence) {
                return false;
            }
            return ObjectUtils.contains(rightValue, String.valueOf(leftValue));
        }
        return false;
    }

    private boolean execEquals(Object value, Object leftValue) {
        if (value instanceof Number && leftValue instanceof Number && ((Number)value).doubleValue() == ((Number)leftValue).doubleValue()) {
            return true;
        }
        return value == leftValue || String.valueOf(leftValue).equals(String.valueOf(value));
    }

    Object evaluateTernary(EvaluatorContext context, EvaluateEnvironment evaluateEnvironment, Boolean bool, boolean isStatic) {
        if (this.isStatic) {
            return this.result;
        }
        Object result = null;
        if (bool == null || bool == Boolean.FALSE) {
            this.isStatic = isStatic && this.right.isStatic;
            result = this.right.evaluate(context, evaluateEnvironment);
        } else {
            this.isStatic = isStatic && this.left.isStatic;
            result = this.left.evaluate(context, evaluateEnvironment);
        }
        if (this.isStatic) {
            this.result = result;
        }
        return result;
    }

    ExprEvaluator update(ExprEvaluator left, ExprEvaluator right) {
        this.left = left;
        this.right = right;
        return this;
    }

    public ExprEvaluator optimize() {
        ExprEvaluator next;
        ExprEvaluator optimized = this.optimizeDepth();
        while (optimized != (next = optimized.optimizeDepth())) {
            optimized = next;
        }
        return optimized;
    }

    public ExprEvaluator optimizeDepth() {
        boolean optimizeFlag;
        ExprEvaluator optimizedRoot = this.optimizeDepth(this, 0);
        ExprEvaluator target = optimizedRoot;
        boolean bl = optimizeFlag = target != this;
        while (optimizeFlag) {
            ExprEvaluator oldLeft = target.left;
            ExprEvaluator newLeft = oldLeft.optimizeDepth(oldLeft, 0);
            optimizeFlag = newLeft != oldLeft;
            target.left = newLeft;
            target = newLeft;
        }
        return optimizedRoot;
    }

    ExprEvaluator optimizeDepth(ExprEvaluator target, int depth) {
        if (this.left == null) {
            return target;
        }
        if (++depth > 1024) {
            ExprEvaluatorStackSplitImpl stackSplit = new ExprEvaluatorStackSplitImpl(target, this.left);
            ExprEvaluatorContextValueHolderImpl valueHolder = new ExprEvaluatorContextValueHolderImpl();
            this.left = valueHolder;
            return stackSplit;
        }
        return this.left.optimizeDepth(target, depth);
    }

    public String code() {
        throw new UnsupportedOperationException("non compiled executor are not supported code()");
    }

    static class ExprEvaluatorContextValueHolderImpl
    extends ExprEvaluator {
        ExprEvaluatorContextValueHolderImpl() {
        }

        @Override
        public Object evaluate(EvaluatorContext context, EvaluateEnvironment evaluateEnvironment) {
            return context.value;
        }
    }

    static class ExprEvaluatorStackSplitImpl
    extends ExprEvaluator {
        ExprEvaluator front;

        ExprEvaluatorStackSplitImpl(ExprEvaluator front, ExprEvaluator left) {
            this.front = front;
            this.left = left;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object evaluate(EvaluatorContext context, EvaluateEnvironment evaluateEnvironment) {
            Object val = this.left.evaluate(context, evaluateEnvironment);
            try {
                context.value = val;
                Object object = this.front.evaluate(context, evaluateEnvironment);
                return object;
            }
            finally {
                context.value = null;
            }
        }
    }

    static class ExprEvaluatorMethodImpl
    extends ExprEvaluatorFunctionImpl {
        static String operator = "@method";
        VariableInvoker variableInvoker;

        ExprEvaluatorMethodImpl() {
        }

        @Override
        public String toString() {
            return "ExprEvaluatorMethodImpl{@method}";
        }

        @Override
        public String code() {
            StringBuilder builder = new StringBuilder();
            builder.append("_$").append(this.variableInvoker.getIndex()).append(".").append(this.functionName).append("(");
            for (int i = 0; i < this.paramLength; ++i) {
                builder.append(this.paramExprParsers[i].getEvaluator().code());
                if (i >= this.paramLength - 1) continue;
                builder.append(",");
            }
            builder.append(")");
            return builder.toString();
        }

        public void setMethod(VariableInvoker variableInvoker, String methodName, String params, ExprParser global) {
            this.variableInvoker = variableInvoker;
            this.setFunction(methodName, params, global);
        }

        Object evaluateMethod(EvaluatorContext evaluatorContext, EvaluateEnvironment evaluateEnvironment) {
            Object invokeObj = null;
            try {
                invokeObj = evaluatorContext.getContextValue(this.variableInvoker);
            }
            catch (RuntimeException e) {
                if (invokeObj == null) {
                    throw new ExpressionException("Unresolved property or variable:'" + this.variableInvoker + "' by context");
                }
                throw e;
            }
            Object[] params = new Object[this.paramLength];
            for (int i = 0; i < this.paramLength; ++i) {
                params[i] = this.paramExprParsers[i].doEvaluate(evaluatorContext, evaluateEnvironment);
            }
            try {
                return ReflectUtils.invoke(invokeObj, this.functionName, params);
            }
            catch (Throwable throwable) {
                throw new ExpressionException(String.format("invoke error, %s and methodName '%s', message: %s", invokeObj.getClass(), this.functionName, throwable.getMessage()));
            }
        }

        @Override
        public Object evaluate(EvaluatorContext evaluatorContext, EvaluateEnvironment evaluateEnvironment) {
            Object functionValue = this.evaluateMethod(evaluatorContext, evaluateEnvironment);
            if (this.negate) {
                return ExprUtils.getNegateNumber(functionValue);
            }
            if (this.logicalNot) {
                return functionValue == Boolean.FALSE || functionValue == null;
            }
            return functionValue;
        }
    }

    static class ExprEvaluatorFunctionImpl
    extends ExprEvaluator {
        static String operator = "@function";
        String functionName;
        String[] paramExprs;
        int paramLength;
        ExprParser[] paramExprParsers;

        ExprEvaluatorFunctionImpl() {
        }

        public String toString() {
            return "ExprEvaluatorFunctionImpl{@function}";
        }

        @Override
        public String code() {
            StringBuilder builder = new StringBuilder();
            builder.append(this.functionName).append("(");
            for (int i = 0; i < this.paramLength; ++i) {
                builder.append(this.paramExprParsers[i].getEvaluator().code());
                if (i >= this.paramLength - 1) continue;
                builder.append(",");
            }
            builder.append(")");
            return builder.toString();
        }

        public void setFunction(String funName, String params, ExprParser global) {
            this.functionName = funName.trim();
            if (params.isEmpty()) {
                this.paramLength = 0;
                this.paramExprs = new String[0];
                return;
            }
            AtomicInteger atomicInteger = new AtomicInteger();
            AtomicBoolean strArr = new AtomicBoolean(true);
            AtomicBoolean doubleArr = new AtomicBoolean(true);
            String[] paramExprs = this.parseStringArr(params, atomicInteger, strArr, doubleArr);
            this.paramExprs = paramExprs;
            this.paramLength = atomicInteger.get();
            ExprParser[] paramExprParsers = new ExprParser[this.paramLength];
            for (int i = 0; i < this.paramLength; ++i) {
                paramExprParsers[i] = new ExprChildParser(paramExprs[i], global);
            }
            this.paramExprParsers = paramExprParsers;
        }

        Object evaluateFunction(EvaluatorContext evaluatorContext, EvaluateEnvironment evaluateEnvironment) {
            Object[] params = new Object[this.paramLength];
            for (int i = 0; i < this.paramLength; ++i) {
                params[i] = this.paramExprParsers[i].doEvaluate(evaluatorContext, evaluateEnvironment);
            }
            ExprFunction exprFunction = evaluateEnvironment.getFunction(this.functionName);
            if (exprFunction == null) {
                throw new ExpressionException("function '" + this.functionName + "' is unregistered!");
            }
            return exprFunction.call(params);
        }

        @Override
        public Object evaluate(EvaluatorContext evaluatorContext, EvaluateEnvironment evaluateEnvironment) {
            Object functionValue = this.evaluateFunction(evaluatorContext, evaluateEnvironment);
            if (this.negate) {
                return ExprUtils.getNegateNumber(functionValue);
            }
            if (this.logicalNot) {
                return functionValue == Boolean.FALSE || functionValue == null;
            }
            return functionValue;
        }
    }

    static class ExprEvaluatorOutImpl
    extends ExprEvaluator {
        static String operator = "out";

        ExprEvaluatorOutImpl() {
        }

        static ExprEvaluatorOutImpl of(ExprEvaluator evaluator) {
            ExprEvaluatorOutImpl evaluatorImpl = new ExprEvaluatorOutImpl();
            evaluatorImpl.left = evaluator.left;
            evaluatorImpl.right = evaluator.right;
            return evaluatorImpl;
        }

        public String toString() {
            return "ExprEvaluatorOutImpl{out}";
        }

        @Override
        public Object evaluate(EvaluatorContext context, EvaluateEnvironment evaluateEnvironment) {
            Object rightValue;
            Object leftValue = this.left.evaluate(context, evaluateEnvironment);
            return !this.evaluateIn(leftValue, rightValue = this.right.evaluate(context, evaluateEnvironment));
        }
    }

    static class ExprEvaluatorInImpl
    extends ExprEvaluator {
        static String operator = "in";

        ExprEvaluatorInImpl() {
        }

        static ExprEvaluatorInImpl of(ExprEvaluator evaluator) {
            ExprEvaluatorInImpl evaluatorImpl = new ExprEvaluatorInImpl();
            evaluatorImpl.left = evaluator.left;
            evaluatorImpl.right = evaluator.right;
            return evaluatorImpl;
        }

        public String toString() {
            return "ExprEvaluatorInImpl{in}";
        }

        @Override
        public Object evaluate(EvaluatorContext context, EvaluateEnvironment evaluateEnvironment) {
            Object leftValue = this.left.evaluate(context, evaluateEnvironment);
            Object rightValue = this.right.evaluate(context, evaluateEnvironment);
            return this.evaluateIn(leftValue, rightValue);
        }
    }

    static class ExprEvaluatorTernaryImpl
    extends ExprEvaluator {
        static String operator = "?:";
        private ExprEvaluator condition;
        private ExprEvaluator question;
        private ExprEvaluator colon;

        ExprEvaluatorTernaryImpl() {
        }

        static ExprEvaluatorTernaryImpl of(ExprEvaluator evaluator) {
            ExprEvaluatorTernaryImpl evaluatorImpl = new ExprEvaluatorTernaryImpl();
            evaluatorImpl.condition = evaluator.left;
            evaluatorImpl.question = evaluator.right.left;
            evaluatorImpl.colon = evaluator.right.right;
            return evaluatorImpl;
        }

        public String toString() {
            return "ExprEvaluatorTernaryImpl{?:}";
        }

        @Override
        public Object evaluate(EvaluatorContext context, EvaluateEnvironment evaluateEnvironment) {
            Object leftValue = this.condition.evaluate(context, evaluateEnvironment);
            boolean conditionResult = leftValue == null ? false : (Boolean)leftValue;
            Object result = conditionResult ? this.question.evaluate(context, evaluateEnvironment) : this.colon.evaluate(context, evaluateEnvironment);
            return result;
        }
    }

    static class ExprEvaluatorLogicalOrImpl
    extends ExprEvaluator {
        static String operator = "||";

        ExprEvaluatorLogicalOrImpl() {
        }

        static ExprEvaluatorLogicalOrImpl of(ExprEvaluator evaluator) {
            ExprEvaluatorLogicalOrImpl evaluatorImpl = new ExprEvaluatorLogicalOrImpl();
            evaluatorImpl.left = evaluator.left;
            evaluatorImpl.right = evaluator.right;
            return evaluatorImpl;
        }

        public String toString() {
            return "ExprEvaluatorLogicalOrImpl{||}";
        }

        @Override
        public Object evaluate(EvaluatorContext context, EvaluateEnvironment evaluateEnvironment) {
            Object leftValue = this.left.evaluate(context, evaluateEnvironment);
            Object rightValue = this.right.evaluate(context, evaluateEnvironment);
            return (Boolean)leftValue != false || (Boolean)rightValue != false;
        }
    }

    static class ExprEvaluatorLogicalAndImpl
    extends ExprEvaluator {
        static String operator = "&&";

        ExprEvaluatorLogicalAndImpl() {
        }

        static ExprEvaluatorLogicalAndImpl of(ExprEvaluator evaluator) {
            ExprEvaluatorLogicalAndImpl evaluatorImpl = new ExprEvaluatorLogicalAndImpl();
            evaluatorImpl.left = evaluator.left;
            evaluatorImpl.right = evaluator.right;
            return evaluatorImpl;
        }

        public String toString() {
            return "ExprEvaluatorLogicalAndImpl{&&}";
        }

        @Override
        public Object evaluate(EvaluatorContext context, EvaluateEnvironment evaluateEnvironment) {
            Object leftValue = this.left.evaluate(context, evaluateEnvironment);
            Object rightValue = this.right.evaluate(context, evaluateEnvironment);
            return (Boolean)leftValue != false && (Boolean)rightValue != false;
        }
    }

    static class ExprEvaluatorNEImpl
    extends ExprEvaluator {
        static String operator = "!=";

        ExprEvaluatorNEImpl() {
        }

        static ExprEvaluatorNEImpl of(ExprEvaluator evaluator) {
            ExprEvaluatorNEImpl evaluatorImpl = new ExprEvaluatorNEImpl();
            evaluatorImpl.left = evaluator.left;
            evaluatorImpl.right = evaluator.right;
            return evaluatorImpl;
        }

        public String toString() {
            return "ExprEvaluatorNEImpl{!=}";
        }

        @Override
        public Object evaluate(EvaluatorContext context, EvaluateEnvironment evaluateEnvironment) {
            Object leftValue = this.left.evaluate(context, evaluateEnvironment);
            Object rightValue = this.right.evaluate(context, evaluateEnvironment);
            if (leftValue instanceof Number && rightValue instanceof Number) {
                return ((Number)leftValue).doubleValue() != ((Number)rightValue).doubleValue();
            }
            if (leftValue == rightValue) {
                return false;
            }
            return leftValue == null || !leftValue.equals(rightValue);
        }
    }

    static class ExprEvaluatorLEImpl
    extends ExprEvaluator {
        static String operator = "<=";

        ExprEvaluatorLEImpl() {
        }

        static ExprEvaluatorLEImpl of(ExprEvaluator evaluator) {
            ExprEvaluatorLEImpl evaluatorImpl = new ExprEvaluatorLEImpl();
            evaluatorImpl.left = evaluator.left;
            evaluatorImpl.right = evaluator.right;
            return evaluatorImpl;
        }

        public String toString() {
            return "ExprEvaluatorLEImpl{<=}";
        }

        @Override
        public Object evaluate(EvaluatorContext context, EvaluateEnvironment evaluateEnvironment) {
            Object leftValue = this.left.evaluate(context, evaluateEnvironment);
            Object rightValue = this.right.evaluate(context, evaluateEnvironment);
            return ((Number)leftValue).doubleValue() <= ((Number)rightValue).doubleValue();
        }
    }

    static class ExprEvaluatorGEImpl
    extends ExprEvaluator {
        static String operator = ">=";

        ExprEvaluatorGEImpl() {
        }

        static ExprEvaluatorGEImpl of(ExprEvaluator evaluator) {
            ExprEvaluatorGEImpl evaluatorImpl = new ExprEvaluatorGEImpl();
            evaluatorImpl.left = evaluator.left;
            evaluatorImpl.right = evaluator.right;
            return evaluatorImpl;
        }

        public String toString() {
            return "ExprEvaluatorGEImpl{>=}";
        }

        @Override
        public Object evaluate(EvaluatorContext context, EvaluateEnvironment evaluateEnvironment) {
            Object leftValue = this.left.evaluate(context, evaluateEnvironment);
            Object rightValue = this.right.evaluate(context, evaluateEnvironment);
            return ((Number)leftValue).doubleValue() >= ((Number)rightValue).doubleValue();
        }
    }

    static class ExprEvaluatorLtImpl
    extends ExprEvaluator {
        static String operator = "<";

        ExprEvaluatorLtImpl() {
        }

        static ExprEvaluatorLtImpl of(ExprEvaluator evaluator) {
            ExprEvaluatorLtImpl evaluatorImpl = new ExprEvaluatorLtImpl();
            evaluatorImpl.left = evaluator.left;
            evaluatorImpl.right = evaluator.right;
            return evaluatorImpl;
        }

        public String toString() {
            return "ExprEvaluatorLtImpl{<}";
        }

        @Override
        public Object evaluate(EvaluatorContext context, EvaluateEnvironment evaluateEnvironment) {
            Object leftValue = this.left.evaluate(context, evaluateEnvironment);
            Object rightValue = this.right.evaluate(context, evaluateEnvironment);
            return ((Number)leftValue).doubleValue() < ((Number)rightValue).doubleValue();
        }
    }

    static class ExprEvaluatorGtImpl
    extends ExprEvaluator {
        static String operator = ">";

        ExprEvaluatorGtImpl() {
        }

        static ExprEvaluatorGtImpl of(ExprEvaluator evaluator) {
            ExprEvaluatorGtImpl evaluatorImpl = new ExprEvaluatorGtImpl();
            evaluatorImpl.left = evaluator.left;
            evaluatorImpl.right = evaluator.right;
            return evaluatorImpl;
        }

        public String toString() {
            return "ExprEvaluatorGtImpl{>}";
        }

        @Override
        public Object evaluate(EvaluatorContext context, EvaluateEnvironment evaluateEnvironment) {
            Object leftValue = this.left.evaluate(context, evaluateEnvironment);
            Object rightValue = this.right.evaluate(context, evaluateEnvironment);
            return ((Number)leftValue).doubleValue() > ((Number)rightValue).doubleValue();
        }
    }

    static class ExprEvaluatorEqualImpl
    extends ExprEvaluator {
        static String operator = "==";

        ExprEvaluatorEqualImpl() {
        }

        static ExprEvaluatorEqualImpl of(ExprEvaluator evaluator) {
            ExprEvaluatorEqualImpl evaluatorImpl = new ExprEvaluatorEqualImpl();
            evaluatorImpl.left = evaluator.left;
            evaluatorImpl.right = evaluator.right;
            return evaluatorImpl;
        }

        public String toString() {
            return "ExprEvaluatorEqualImpl{==}";
        }

        @Override
        public Object evaluate(EvaluatorContext context, EvaluateEnvironment evaluateEnvironment) {
            Object leftValue = this.left.evaluate(context, evaluateEnvironment);
            Object rightValue = this.right.evaluate(context, evaluateEnvironment);
            if (leftValue instanceof Number && rightValue instanceof Number) {
                return ((Number)leftValue).doubleValue() == ((Number)rightValue).doubleValue();
            }
            if (leftValue == rightValue) {
                return true;
            }
            return leftValue != null && leftValue.equals(rightValue);
        }
    }

    static class ExprEvaluatorBitXorImpl
    extends ExprEvaluator {
        static String operator = "^";

        ExprEvaluatorBitXorImpl() {
        }

        static ExprEvaluatorBitXorImpl of(ExprEvaluator evaluator) {
            ExprEvaluatorBitXorImpl evaluatorImpl = new ExprEvaluatorBitXorImpl();
            evaluatorImpl.left = evaluator.left;
            evaluatorImpl.right = evaluator.right;
            return evaluatorImpl;
        }

        public String toString() {
            return "ExprEvaluatorBitOrImpl{^}";
        }

        @Override
        public Object evaluate(EvaluatorContext context, EvaluateEnvironment evaluateEnvironment) {
            Object leftValue = this.left.evaluate(context, evaluateEnvironment);
            Object rightValue = this.right.evaluate(context, evaluateEnvironment);
            return ((Number)leftValue).longValue() ^ ((Number)rightValue).longValue();
        }
    }

    static class ExprEvaluatorBitOrImpl
    extends ExprEvaluator {
        static String operator = "|";

        ExprEvaluatorBitOrImpl() {
        }

        static ExprEvaluatorBitOrImpl of(ExprEvaluator evaluator) {
            ExprEvaluatorBitOrImpl evaluatorImpl = new ExprEvaluatorBitOrImpl();
            evaluatorImpl.left = evaluator.left;
            evaluatorImpl.right = evaluator.right;
            return evaluatorImpl;
        }

        public String toString() {
            return "ExprEvaluatorBitOrImpl{|}";
        }

        @Override
        public Object evaluate(EvaluatorContext context, EvaluateEnvironment evaluateEnvironment) {
            Object leftValue = this.left.evaluate(context, evaluateEnvironment);
            Object rightValue = this.right.evaluate(context, evaluateEnvironment);
            return ((Number)leftValue).longValue() | ((Number)rightValue).longValue();
        }
    }

    static class ExprEvaluatorBitAndImpl
    extends ExprEvaluator {
        static String operator = "&";

        ExprEvaluatorBitAndImpl() {
        }

        static ExprEvaluatorBitAndImpl of(ExprEvaluator evaluator) {
            ExprEvaluatorBitAndImpl evaluatorImpl = new ExprEvaluatorBitAndImpl();
            evaluatorImpl.left = evaluator.left;
            evaluatorImpl.right = evaluator.right;
            return evaluatorImpl;
        }

        public String toString() {
            return "ExprEvaluatorBitAndImpl{&}";
        }

        @Override
        public Object evaluate(EvaluatorContext context, EvaluateEnvironment evaluateEnvironment) {
            Object leftValue = this.left.evaluate(context, evaluateEnvironment);
            Object rightValue = this.right.evaluate(context, evaluateEnvironment);
            return ((Number)leftValue).longValue() & ((Number)rightValue).longValue();
        }
    }

    static class ExprEvaluatorBitRightImpl
    extends ExprEvaluator {
        static String operator = ">>";

        ExprEvaluatorBitRightImpl() {
        }

        static ExprEvaluatorBitRightImpl of(ExprEvaluator evaluator) {
            ExprEvaluatorBitRightImpl evaluatorImpl = new ExprEvaluatorBitRightImpl();
            evaluatorImpl.left = evaluator.left;
            evaluatorImpl.right = evaluator.right;
            return evaluatorImpl;
        }

        public String toString() {
            return "ExprEvaluatorBitRightImpl{>>}";
        }

        @Override
        public Object evaluate(EvaluatorContext context, EvaluateEnvironment evaluateEnvironment) {
            Object leftValue = this.left.evaluate(context, evaluateEnvironment);
            Object rightValue = this.right.evaluate(context, evaluateEnvironment);
            return ((Number)leftValue).longValue() >> (int)((Number)rightValue).longValue();
        }
    }

    static class ExprEvaluatorBitLeftImpl
    extends ExprEvaluator {
        static String operator = "<<";

        ExprEvaluatorBitLeftImpl() {
        }

        static ExprEvaluatorBitLeftImpl of(ExprEvaluator evaluator) {
            ExprEvaluatorBitLeftImpl evaluatorImpl = new ExprEvaluatorBitLeftImpl();
            evaluatorImpl.left = evaluator.left;
            evaluatorImpl.right = evaluator.right;
            return evaluatorImpl;
        }

        public String toString() {
            return "ExprEvaluatorBitLeftImpl{<<}";
        }

        @Override
        public Object evaluate(EvaluatorContext context, EvaluateEnvironment evaluateEnvironment) {
            Object leftValue = this.left.evaluate(context, evaluateEnvironment);
            Object rightValue = this.right.evaluate(context, evaluateEnvironment);
            return ((Number)leftValue).longValue() << (int)((Number)rightValue).longValue();
        }
    }

    static class ExprEvaluatorModulusImpl
    extends ExprEvaluator {
        static String operator = "%";

        ExprEvaluatorModulusImpl() {
        }

        static ExprEvaluatorModulusImpl of(ExprEvaluator evaluator) {
            ExprEvaluatorModulusImpl evaluatorImpl = new ExprEvaluatorModulusImpl();
            evaluatorImpl.left = evaluator.left;
            evaluatorImpl.right = evaluator.right;
            return evaluatorImpl;
        }

        public String toString() {
            return "ExprEvaluatorModulusImpl{%}";
        }

        @Override
        public Object evaluate(EvaluatorContext context, EvaluateEnvironment evaluateEnvironment) {
            boolean isDouble;
            Object leftValue = this.left.evaluate(context, evaluateEnvironment);
            Object rightValue = this.right.evaluate(context, evaluateEnvironment);
            boolean bl = isDouble = leftValue instanceof Double || rightValue instanceof Double;
            if (isDouble) {
                return ((Number)leftValue).doubleValue() % ((Number)rightValue).doubleValue();
            }
            return ((Number)leftValue).longValue() % ((Number)rightValue).longValue();
        }
    }

    static class ExprEvaluatorDivisionImpl
    extends ExprEvaluator {
        static String operator = "/";

        ExprEvaluatorDivisionImpl() {
        }

        static ExprEvaluatorDivisionImpl of(ExprEvaluator evaluator) {
            ExprEvaluatorDivisionImpl evaluatorImpl = new ExprEvaluatorDivisionImpl();
            evaluatorImpl.left = evaluator.left;
            evaluatorImpl.right = evaluator.right;
            return evaluatorImpl;
        }

        public String toString() {
            return "ExprEvaluatorDivisionImpl{/}";
        }

        @Override
        public Object evaluate(EvaluatorContext context, EvaluateEnvironment evaluateEnvironment) {
            boolean isDouble;
            Object leftValue = this.left.evaluate(context, evaluateEnvironment);
            Object rightValue = this.right.evaluate(context, evaluateEnvironment);
            boolean bl = isDouble = leftValue instanceof Double || rightValue instanceof Double;
            if (isDouble) {
                return ((Number)leftValue).doubleValue() / ((Number)rightValue).doubleValue();
            }
            return ((Number)leftValue).longValue() / ((Number)rightValue).longValue();
        }
    }

    static class ExprEvaluatorPowerImpl
    extends ExprEvaluator {
        static String operator = "**";

        ExprEvaluatorPowerImpl() {
        }

        static ExprEvaluatorPowerImpl of(ExprEvaluator evaluator) {
            ExprEvaluatorPowerImpl evaluatorImpl = new ExprEvaluatorPowerImpl();
            evaluatorImpl.left = evaluator.left;
            evaluatorImpl.right = evaluator.right;
            return evaluatorImpl;
        }

        public String toString() {
            return "ExprEvaluatorPowerImpl{**}";
        }

        @Override
        public Object evaluate(EvaluatorContext context, EvaluateEnvironment evaluateEnvironment) {
            if (this.isStatic) {
                return this.result;
            }
            Object leftValue = this.left.evaluate(context, evaluateEnvironment);
            Object rightValue = this.right.evaluate(context, evaluateEnvironment);
            this.isStatic = this.left.isStatic && this.right.isStatic;
            double powValue = Math.pow(((Number)leftValue).doubleValue(), ((Number)rightValue).doubleValue());
            long longVal = (long)powValue;
            if ((double)longVal == powValue) {
                this.result = longVal;
                return this.result;
            }
            this.result = powValue;
            return this.result;
        }
    }

    static class ExprEvaluatorMultiplyImpl
    extends ExprEvaluator {
        static String operator = "*";

        ExprEvaluatorMultiplyImpl() {
        }

        static ExprEvaluatorMultiplyImpl of(ExprEvaluator evaluator) {
            ExprEvaluatorMultiplyImpl evaluatorImpl = new ExprEvaluatorMultiplyImpl();
            evaluatorImpl.left = evaluator.left;
            evaluatorImpl.right = evaluator.right;
            return evaluatorImpl;
        }

        public String toString() {
            return "ExprEvaluatorMultiplyImpl{*}";
        }

        @Override
        public Object evaluate(EvaluatorContext context, EvaluateEnvironment evaluateEnvironment) {
            if (this.isStatic) {
                return this.result;
            }
            Object leftValue = this.left.evaluate(context, evaluateEnvironment);
            Object rightValue = this.right.evaluate(context, evaluateEnvironment);
            this.isStatic = this.left.isStatic && this.right.isStatic;
            boolean isDouble = leftValue instanceof Double || rightValue instanceof Double;
            this.result = isDouble ? (Number)(((Number)leftValue).doubleValue() * ((Number)rightValue).doubleValue()) : (Number)(((Number)leftValue).longValue() * ((Number)rightValue).longValue());
            return this.result;
        }
    }

    static class ExprEvaluatorMinusImpl
    extends ExprEvaluator {
        static String operator = "-";

        ExprEvaluatorMinusImpl() {
        }

        static ExprEvaluatorMinusImpl of(ExprEvaluator evaluator) {
            ExprEvaluatorMinusImpl evaluatorImpl = new ExprEvaluatorMinusImpl();
            evaluatorImpl.left = evaluator.left;
            evaluatorImpl.right = evaluator.right;
            return evaluatorImpl;
        }

        public String toString() {
            return "ExprEvaluatorMinusImpl{-}";
        }

        @Override
        public Object evaluate(EvaluatorContext context, EvaluateEnvironment evaluateEnvironment) {
            if (this.isStatic) {
                return this.result;
            }
            Object leftValue = this.left.evaluate(context, evaluateEnvironment);
            Object rightValue = this.right.evaluate(context, evaluateEnvironment);
            this.isStatic = this.left.isStatic && this.right.isStatic;
            boolean isDouble = leftValue instanceof Double || rightValue instanceof Double;
            this.result = isDouble ? (Number)(((Number)leftValue).doubleValue() - ((Number)rightValue).doubleValue()) : (Number)(((Number)leftValue).longValue() - ((Number)rightValue).longValue());
            return this.result;
        }
    }

    static class ExprEvaluatorPlusImpl
    extends ExprEvaluator {
        static String operator = "+";

        ExprEvaluatorPlusImpl() {
        }

        static ExprEvaluatorPlusImpl of(ExprEvaluator evaluator) {
            ExprEvaluatorPlusImpl evaluatorImpl = new ExprEvaluatorPlusImpl();
            evaluatorImpl.left = evaluator.left;
            evaluatorImpl.right = evaluator.right;
            return evaluatorImpl;
        }

        public String toString() {
            return "ExprEvaluatorPlusImpl{+}";
        }

        @Override
        public Object evaluate(EvaluatorContext context, EvaluateEnvironment evaluateEnvironment) {
            Object leftValue = this.left.evaluate(context, evaluateEnvironment);
            Object rightValue = this.right.evaluate(context, evaluateEnvironment);
            if (leftValue instanceof Number && rightValue instanceof Number) {
                boolean isDouble;
                boolean bl = isDouble = leftValue instanceof Double || rightValue instanceof Double;
                if (isDouble) {
                    return ((Number)leftValue).doubleValue() + ((Number)rightValue).doubleValue();
                }
                return ((Number)leftValue).longValue() + ((Number)rightValue).longValue();
            }
            String leftStrValue = String.valueOf(leftValue);
            String rightStrValue = String.valueOf(rightValue);
            char[] chars = new char[leftStrValue.length() + rightStrValue.length()];
            leftStrValue.getChars(0, leftStrValue.length(), chars, 0);
            rightStrValue.getChars(0, rightStrValue.length(), chars, leftStrValue.length());
            return new String(chars);
        }
    }

    static class ExprEvaluatorBracketImpl
    extends ExprEvaluator {
        static String operator = "()";

        ExprEvaluatorBracketImpl() {
        }

        static ExprEvaluatorBracketImpl of(ExprEvaluator evaluator) {
            ExprEvaluatorBracketImpl exprEvaluatorImpl = new ExprEvaluatorBracketImpl();
            exprEvaluatorImpl.right = evaluator.right;
            exprEvaluatorImpl.negate = evaluator.negate;
            exprEvaluatorImpl.logicalNot = evaluator.logicalNot;
            return exprEvaluatorImpl;
        }

        public String toString() {
            return "ExprEvaluatorBracketImpl{()}";
        }

        @Override
        public Object evaluate(EvaluatorContext context, EvaluateEnvironment evaluateEnvironment) {
            Object bracketValue = this.right.evaluate(context, evaluateEnvironment);
            if (this.negate) {
                if (bracketValue instanceof Double) {
                    return -((Double)bracketValue).doubleValue();
                }
                if (bracketValue instanceof Long) {
                    return -((Long)bracketValue).longValue();
                }
                return -((Number)bracketValue).doubleValue();
            }
            if (this.logicalNot) {
                return bracketValue == Boolean.FALSE || bracketValue == null;
            }
            return bracketValue;
        }
    }

    static class ExprEvaluatorConstantImpl
    extends ExprEvaluator {
        ExprEvaluatorConstantImpl(Object result) {
            this.result = result;
            this.isStatic = true;
        }

        @Override
        public Object evaluate(EvaluatorContext context, EvaluateEnvironment evaluateEnvironment) {
            return this.result;
        }

        public String toString() {
            return String.valueOf(this.result);
        }

        @Override
        public String code() {
            if (this.result instanceof String) {
                StringBuilder builder = new StringBuilder();
                String strValue = (String)this.result;
                if (strValue.indexOf(34) > -1) {
                    strValue = strValue.replace("\"", "\\\"");
                }
                return builder.append("\"").append(strValue).append("\"").toString();
            }
            return String.valueOf(this.result);
        }
    }

    static class ExprEvaluatorVariableImpl
    extends ExprEvaluator {
        VariableInvoker variableInvoke;

        ExprEvaluatorVariableImpl() {
        }

        public void setVariableInvoker(VariableInvoker variableInvoke) {
            this.variableInvoke = variableInvoke;
        }

        ExprEvaluator internKey() {
            this.variableInvoke.internKey();
            return this;
        }

        @Override
        public Object evaluate(EvaluatorContext context, EvaluateEnvironment evaluateEnvironment) {
            Object obj = null;
            try {
                obj = context.getContextValue(this.variableInvoke);
                if (obj == null && !this.variableInvoke.existKey(context)) {
                    throw new ExpressionException("Unresolved property or variable:'" + this.variableInvoke + "' by context");
                }
                if (evaluateEnvironment.isAutoParseStringAsDouble() && obj instanceof String) {
                    obj = Double.parseDouble((String)obj);
                }
            }
            catch (RuntimeException e) {
                if (obj == null && context == null) {
                    throw new ExpressionException("Unresolved property or variable:'" + this.variableInvoke + "' by context");
                }
                throw e;
            }
            if (this.negate) {
                Number number = (Number)obj;
                if (number instanceof Double || number instanceof Float) {
                    return -number.doubleValue();
                }
                if (number instanceof Integer) {
                    return -number.intValue();
                }
                return -number.longValue();
            }
            if (this.logicalNot) {
                return obj == Boolean.FALSE || obj == null;
            }
            return obj;
        }

        @Override
        public String code() {
            StringBuilder builder = new StringBuilder();
            return builder.append("_$").append(this.variableInvoke.getIndex()).toString();
        }
    }
}

