/*
 * Decompiled with CFR 0.152.
 */
package io.github.wycst.wast.common.reflect;

import io.github.wycst.wast.common.exceptions.InvokeReflectException;
import io.github.wycst.wast.common.reflect.GenericParameterizedType;
import io.github.wycst.wast.common.reflect.ReflectConsts;
import io.github.wycst.wast.common.reflect.UnsafeHelper;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Map;

public class GetterInfo {
    private Field field;
    private long fieldOffset = -1L;
    private boolean fieldPrimitive;
    private ReflectConsts.PrimitiveType primitiveType;
    private GenericParameterizedType genericParameterizedType;
    private String name;
    private String underlineName;
    private Map<Class<? extends Annotation>, Annotation> annotations;
    private ReflectConsts.ClassCategory classCategory;
    private boolean record;

    public ReflectConsts.ClassCategory getClassCategory() {
        if (this.classCategory != null) {
            return this.classCategory;
        }
        this.classCategory = ReflectConsts.getClassCategory(this.getReturnType());
        return this.classCategory;
    }

    public final boolean isInstance(Object target) {
        return this.field.getDeclaringClass().isInstance(target);
    }

    public final Object invoke(Object target) {
        if (this.fieldOffset > -1L) {
            if (this.isInstance(target)) {
                if (this.fieldPrimitive) {
                    return this.primitiveType.get(target, this.fieldOffset);
                }
                return UnsafeHelper.getObjectValue(target, this.fieldOffset);
            }
            throw new SecurityException("invoke error: parameter mismatch");
        }
        return this.invokeObjectValue(target);
    }

    protected Object invokeObjectValue(Object target) {
        try {
            return this.field.get(target);
        }
        catch (Exception e) {
            throw new InvokeReflectException(e);
        }
    }

    Object invokeInternal(Object target) {
        if (this.fieldOffset > -1L) {
            if (this.fieldPrimitive) {
                return this.primitiveType.getValue(target, this.fieldOffset);
            }
            return UnsafeHelper.UNSAFE.getObject(target, this.fieldOffset);
        }
        return this.invokeObjectValue(target);
    }

    void setField(Field field) {
        this.field = field;
        try {
            this.fieldOffset = UnsafeHelper.objectFieldOffset(field);
            this.fieldPrimitive = field.getType().isPrimitive();
            if (this.fieldPrimitive) {
                this.primitiveType = ReflectConsts.PrimitiveType.typeOf(field.getType());
            }
        }
        catch (Throwable throwable) {
            this.fieldOffset = -1L;
        }
    }

    Field getField() {
        return this.field;
    }

    public boolean existField() {
        return this.field != null;
    }

    void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public Map<Class<? extends Annotation>, Annotation> getAnnotations() {
        return this.annotations;
    }

    void setAnnotations(Map<Class<? extends Annotation>, Annotation> annotations) {
        this.annotations = annotations;
    }

    public Annotation getAnnotation(Class<? extends Annotation> annotationType) {
        return this.annotations.get(annotationType);
    }

    public Class<?> getReturnType() {
        return this.field.getType();
    }

    void setUnderlineName(String underlineName) {
        this.underlineName = underlineName;
    }

    public String getUnderlineName() {
        return this.underlineName;
    }

    public boolean isMethod() {
        return false;
    }

    public boolean isAccess() {
        return !Modifier.isPrivate(this.field.getModifiers());
    }

    public boolean isPrimitive() {
        return this.fieldPrimitive;
    }

    public GenericParameterizedType getGenericParameterizedType() {
        return this.genericParameterizedType;
    }

    void setGenericParameterizedType(GenericParameterizedType genericParameterizedType) {
        this.genericParameterizedType = genericParameterizedType;
    }

    public String getMethodName() {
        return null;
    }

    public String generateCode() {
        if (this.record) {
            return this.field.getName() + "()";
        }
        return this.field.getName();
    }

    void setRecord(boolean record) {
        this.record = record;
    }
}

