/*
 * Decompiled with CFR 0.152.
 */
package io.github.wycst.wast.common.utils;

import io.github.wycst.wast.common.reflect.UnsafeHelper;
import io.github.wycst.wast.common.utils.EnvUtils;

public final class Base64Utils {
    private static final char[] BASE64_CHARS = new char[]{'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '+', '/'};
    private static final int[] BASE64_VALUES = new int[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 62, -1, -1, -1, 63, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, -1, -1, -1, -2, -1, -1, -1, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, -1, -1, -1, -1, -1, -1, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, -1, -1, -1, -1, -1};

    public static byte[] encode(byte[] src) {
        int tlen = (src.length + 2) / 3 << 2;
        byte[] dst = new byte[tlen];
        Base64Utils.encode(src, dst, 0);
        return dst;
    }

    public static String encodeToString(byte[] src) {
        int tlen = (src.length + 2) / 3 << 2;
        if (EnvUtils.JDK_9_PLUS) {
            byte[] dst = new byte[tlen];
            Base64Utils.encode(src, dst, 0);
            return UnsafeHelper.getAsciiString(dst);
        }
        char[] dst = new char[tlen];
        Base64Utils.encode(src, dst, 0);
        return UnsafeHelper.getString(dst);
    }

    public static int encode(byte[] src, byte[] dst, int offset) {
        int n = src.length / 3;
        int n3 = n * 3;
        int rem = src.length - n3;
        int begin = offset;
        int srcOff = 0;
        for (int i = 0; i < n; ++i) {
            int b1 = src[srcOff++] & 0xFF;
            int b2 = src[srcOff++] & 0xFF;
            int b3 = src[srcOff++] & 0xFF;
            int bits = b1 << 16 | b2 << 8 | b3;
            dst[offset++] = (byte)BASE64_CHARS[b1 >> 2];
            dst[offset++] = (byte)BASE64_CHARS[bits >> 12 & 0x3F];
            dst[offset++] = (byte)BASE64_CHARS[bits >> 6 & 0x3F];
            dst[offset++] = (byte)BASE64_CHARS[bits & 0x3F];
        }
        if (rem == 1) {
            int b = src[n3] & 0xFF;
            dst[offset++] = (byte)BASE64_CHARS[b >> 2];
            dst[offset++] = (byte)BASE64_CHARS[(b & 3) << 4];
            dst[offset++] = 61;
            dst[offset++] = 61;
        } else if (rem == 2) {
            int b1 = src[n3] & 0xFF;
            int b2 = src[n3 + 1] & 0xFF;
            dst[offset++] = (byte)BASE64_CHARS[b1 >> 2];
            dst[offset++] = (byte)BASE64_CHARS[(b1 & 3) << 4 | b2 >> 4];
            dst[offset++] = (byte)BASE64_CHARS[(b2 & 0xF) << 2];
            dst[offset++] = 61;
        }
        return offset - begin;
    }

    public static int encode(byte[] src, char[] dst, int offset) {
        int n = src.length / 3;
        int n3 = n * 3;
        int rem = src.length - n3;
        int begin = offset;
        int srcOff = 0;
        for (int i = 0; i < n; ++i) {
            int b1 = src[srcOff++] & 0xFF;
            int b2 = src[srcOff++] & 0xFF;
            int b3 = src[srcOff++] & 0xFF;
            int bits = b1 << 16 | b2 << 8 | b3;
            dst[offset++] = BASE64_CHARS[b1 >> 2];
            dst[offset++] = BASE64_CHARS[bits >> 12 & 0x3F];
            dst[offset++] = BASE64_CHARS[bits >> 6 & 0x3F];
            dst[offset++] = BASE64_CHARS[bits & 0x3F];
        }
        if (rem == 1) {
            int b = src[n3] & 0xFF;
            dst[offset++] = BASE64_CHARS[b >> 2];
            dst[offset++] = BASE64_CHARS[(b & 3) << 4];
            dst[offset++] = 61;
            dst[offset++] = 61;
        } else if (rem == 2) {
            int b1 = src[n3] & 0xFF;
            int b2 = src[n3 + 1] & 0xFF;
            dst[offset++] = BASE64_CHARS[b1 >> 2];
            dst[offset++] = BASE64_CHARS[(b1 & 3) << 4 | b2 >> 4];
            dst[offset++] = BASE64_CHARS[(b2 & 0xF) << 2];
            dst[offset++] = 61;
        }
        return offset - begin;
    }

    public static byte[] decode(String src) {
        if (EnvUtils.JDK_9_PLUS) {
            byte[] buf = (byte[])UnsafeHelper.getStringValue(src);
            return Base64Utils.decode(buf, 0, buf.length);
        }
        char[] buf = (char[])UnsafeHelper.getStringValue(src);
        return Base64Utils.decode(buf, 0, buf.length);
    }

    public static byte[] decode(byte[] src) {
        return Base64Utils.decode(src, 0, src.length);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static byte[] decode(byte[] src, int offset, int len) {
        if ((len & 3) > 0) {
            throw new IllegalArgumentException("The length error of base64 should be an integer multiple of 4");
        }
        try {
            int v1;
            byte[] dst;
            int n = len >> 2;
            int tlen = n * 3;
            int srcOff = offset;
            int endOffset = offset + len;
            if (src[--endOffset] == 61) {
                byte v;
                --n;
                --tlen;
                if ((v = src[--endOffset]) == 61) {
                    dst = new byte[--tlen];
                    int v2 = BASE64_VALUES[src[--endOffset]];
                    if ((v1 = BASE64_VALUES[src[--endOffset]]) <= -1 || v2 <= -1) throw new IllegalArgumentException("Base64 data error: " + new String(src, offset, len));
                    dst[tlen - 1] = (byte)(v1 << 2 | v2 >> 4);
                } else {
                    int v12;
                    dst = new byte[tlen];
                    int v3 = BASE64_VALUES[v];
                    int v2 = BASE64_VALUES[src[--endOffset]];
                    if ((v12 = BASE64_VALUES[src[--endOffset]]) <= -1 || v2 <= -1 || v3 <= -1) throw new IllegalArgumentException("Base64 data error: " + new String(src, offset, len));
                    int bits = v12 << 10 | v2 << 4 | v3 >> 2;
                    dst[tlen - 2] = (byte)(bits >> 8);
                    dst[tlen - 1] = (byte)bits;
                }
            } else {
                dst = new byte[tlen];
            }
            int dstOff = 0;
            for (int i = 0; i < n; ++i) {
                v1 = BASE64_VALUES[src[srcOff++]];
                int v2 = BASE64_VALUES[src[srcOff++]];
                int v3 = BASE64_VALUES[src[srcOff++]];
                int v4 = BASE64_VALUES[src[srcOff++]];
                if (v1 <= -1 || v2 <= -1 || v3 <= -1 || v4 <= -1) {
                    throw new IllegalArgumentException("Base64 data error: " + new String(src, offset, len));
                }
                int bits = v1 << 18 | v2 << 12 | v3 << 6 | v4;
                dst[dstOff++] = (byte)(bits >> 16);
                dst[dstOff++] = (byte)(bits >> 8);
                dst[dstOff++] = (byte)bits;
            }
            return dst;
        }
        catch (Throwable throwable) {
            throw new IllegalArgumentException("Base64 data error: " + new String(src, offset, len));
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static byte[] decode(char[] src, int offset, int len) {
        if ((len & 3) > 0) {
            throw new IllegalArgumentException("The length error of base64 should be an integer multiple of 4");
        }
        try {
            int v1;
            byte[] dst;
            int n = len >> 2;
            int tlen = n * 3;
            int srcOff = offset;
            int endOffset = offset + len;
            if (src[--endOffset] == '=') {
                char v;
                --n;
                --tlen;
                if ((v = src[--endOffset]) == '=') {
                    dst = new byte[--tlen];
                    int v2 = BASE64_VALUES[src[--endOffset]];
                    if ((v1 = BASE64_VALUES[src[--endOffset]]) <= -1 || v2 <= -1) throw new IllegalArgumentException("Base64 data error: " + new String(src, offset, len));
                    dst[tlen - 1] = (byte)(v1 << 2 | v2 >> 4);
                } else {
                    dst = new byte[tlen];
                    int v3 = BASE64_VALUES[v];
                    int v2 = BASE64_VALUES[src[--endOffset]];
                    int v12 = BASE64_VALUES[src[--endOffset]];
                    if (v3 <= -1 || v2 <= -1 || v12 <= -1) throw new IllegalArgumentException("Base64 data error: " + new String(src, offset, len));
                    int bits = v12 << 10 | v2 << 4 | v3 >> 2;
                    dst[tlen - 2] = (byte)(bits >> 8);
                    dst[tlen - 1] = (byte)bits;
                }
            } else {
                dst = new byte[tlen];
            }
            int dstOff = 0;
            for (int i = 0; i < n; ++i) {
                v1 = BASE64_VALUES[src[srcOff++]];
                int v2 = BASE64_VALUES[src[srcOff++]];
                int v3 = BASE64_VALUES[src[srcOff++]];
                int v4 = BASE64_VALUES[src[srcOff++]];
                if (v1 <= -1 || v2 <= -1 || v3 <= -1 || v4 <= -1) {
                    throw new IllegalArgumentException("Base64 data error: " + new String(src, offset, len));
                }
                int bits = v1 << 18 | v2 << 12 | v3 << 6 | v4;
                dst[dstOff++] = (byte)(bits >> 16);
                dst[dstOff++] = (byte)(bits >> 8);
                dst[dstOff++] = (byte)bits;
            }
            return dst;
        }
        catch (Throwable throwable) {
            throw new IllegalArgumentException("Base64 data error: " + new String(src, offset, len));
        }
    }
}

