/*
 * Decompiled with CFR 0.152.
 */
package io.github.wycst.wast.jdbc.executer;

import io.github.wycst.wast.common.utils.ObjectUtils;
import io.github.wycst.wast.jdbc.executer.CacheableEntity;
import io.github.wycst.wast.jdbc.executer.DefaultSqlExecuter;
import io.github.wycst.wast.jdbc.executer.EntityHandler;
import io.github.wycst.wast.jdbc.executer.EntitySqlMapping;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

class CacheableEntityHandler
extends EntityHandler {
    Map<Serializable, CacheableEntity> cachedEntityMap = new ConcurrentHashMap<Serializable, CacheableEntity>();
    boolean cachedAllFlag = false;
    List<?> cachedFullEntityList = null;
    private Object lock = new Object();

    CacheableEntityHandler(EntitySqlMapping entitySqlMapping) {
        super(entitySqlMapping);
    }

    @Override
    <E> E getById(DefaultSqlExecuter sqlExecuter, Class<E> entityCls, Serializable id) {
        CacheableEntity cacheableEntity = this.cachedEntityMap.get(id);
        if (cacheableEntity == null) {
            return this.putOrRemove(sqlExecuter, entityCls, id);
        }
        return (E)cacheableEntity.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    <E> int deleteById(DefaultSqlExecuter sqlExecuter, Class<E> entityCls, Serializable id) {
        try {
            int n = super.deleteById(sqlExecuter, entityCls, id);
            return n;
        }
        finally {
            this.removeCacheEntity(id);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeCacheEntity(Serializable id) {
        Object object = this.lock;
        synchronized (object) {
            this.cachedEntityMap.remove(id);
            this.cachedFullEntityList = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    <E> List<E> executeQueryBy(DefaultSqlExecuter sqlExecuter, Class<E> entityCls, Object params) {
        boolean emptyParams;
        boolean bl = emptyParams = params == null || ObjectUtils.getNonEmptyFields(params).isEmpty();
        if (this.cachedAllFlag && emptyParams) {
            Object object = this.lock;
            synchronized (object) {
                ArrayList<Object> result;
                if (this.cachedFullEntityList == null) {
                    result = new ArrayList();
                    Collection<CacheableEntity> cacheableEntities = this.cachedEntityMap.values();
                    for (CacheableEntity cacheableEntity : cacheableEntities) {
                        result.add(cacheableEntity.getEntity());
                    }
                    this.cachedFullEntityList = result;
                } else {
                    result = new ArrayList(this.cachedFullEntityList);
                }
                return result;
            }
        }
        List<E> result = super.executeQueryBy(sqlExecuter, entityCls, params);
        if (emptyParams) {
            this.cacheAll(result);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    <E> E putOrRemove(DefaultSqlExecuter sqlExecuter, Class<E> entityCls, Serializable id) {
        E e = super.getById(sqlExecuter, entityCls, id);
        Object object = this.lock;
        synchronized (object) {
            if (e != null) {
                CacheableEntity cacheableEntity = new CacheableEntity(e);
                this.cachedEntityMap.put(id, cacheableEntity);
            } else {
                this.cachedEntityMap.remove(id);
            }
            this.cachedFullEntityList = null;
        }
        return e;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    <E> void cacheAll(List<E> entityList) {
        if (this.entitySqlMapping.existPrimary()) {
            Object object = this.lock;
            synchronized (object) {
                this.cachedEntityMap.clear();
                for (E e : entityList) {
                    Serializable id = this.entitySqlMapping.getId(e);
                    CacheableEntity cacheableEntity = new CacheableEntity(e);
                    this.cachedEntityMap.put(id, cacheableEntity);
                }
                this.cachedAllFlag = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void resetCaches() {
        Object object = this.lock;
        synchronized (object) {
            this.cachedEntityMap.clear();
            this.cachedAllFlag = false;
            this.cachedFullEntityList = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    <E> int updateEntity(DefaultSqlExecuter sqlExecuter, E entity) {
        int n = -1;
        try {
            int n2 = n = super.updateEntity(sqlExecuter, entity);
            return n2;
        }
        finally {
            if (n == 1) {
                this.afterUpdate(sqlExecuter, entity);
            }
        }
    }

    @Override
    <E> void afterUpdate(DefaultSqlExecuter sqlExecuter, E entity) {
        Serializable id = this.entitySqlMapping.getId(entity);
        this.putOrRemove(sqlExecuter, entity.getClass(), id);
    }

    @Override
    void afterBatchDelete() {
        this.resetCaches();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void clearExpiredCaches() {
        long expires = this.entitySqlMapping.expires();
        long now = System.currentTimeMillis();
        Object object = this.lock;
        synchronized (object) {
            HashSet<Serializable> cacheKeys = new HashSet<Serializable>(this.cachedEntityMap.keySet());
            int removeCnt = 0;
            for (Serializable id : cacheKeys) {
                long lastHitAt;
                CacheableEntity cacheableEntity = this.cachedEntityMap.get(id);
                if (cacheableEntity == null || now - (lastHitAt = cacheableEntity.getLastHitAt()) < expires) continue;
                this.cachedEntityMap.remove(id);
                ++removeCnt;
            }
            if (removeCnt > 0) {
                this.cachedAllFlag = false;
                this.cachedFullEntityList = null;
            }
        }
    }
}

