/*
 * Decompiled with CFR 0.152.
 */
package io.github.wycst.wast.json;

import io.github.wycst.wast.common.beans.GeneralDate;
import io.github.wycst.wast.common.utils.Base64Utils;
import io.github.wycst.wast.common.utils.EnvUtils;
import io.github.wycst.wast.common.utils.NumberUtils;
import io.github.wycst.wast.common.utils.Scientific;
import io.github.wycst.wast.json.JSONByteArrayWriter;
import io.github.wycst.wast.json.JSONCharArrayWriter;
import io.github.wycst.wast.json.JSONConfig;
import io.github.wycst.wast.json.JSONGeneral;
import io.github.wycst.wast.json.JSONUnsafe;
import io.github.wycst.wast.json.JSONWrapWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.math.BigInteger;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;

public abstract class JSONWriter
extends Writer {
    static final int CACHE_BUFFER_SIZE;
    static final int MAX_CACHE_BUFFER_SIZE;
    static final int AVAILABLE_PROCESSORS;
    static final int SECURITY_UNCHECK_SPACE = 128;
    static final int CACHE_COUNT;
    static final AtomicInteger AUTO_SEQ;
    static final int EMPTY_ARRAY_INT;
    static final short EMPTY_ARRAY_SHORT;
    static final int Z_QUOT_INT;
    static final short Z_QUOT_SHORT;
    static final int ZERO_DOT_32;
    static final short ZERO_DOT_16;
    static final int DOT_ZERO_32;
    static final short DOT_ZERO_16;
    static final int ZERO_ZERO_32 = 0x300030;
    static final short ZERO_ZERO_16 = 12336;
    static final char[] HEX_DIGITS;
    static final long[] POW10_LONG_VALUES;
    static final char[][] POSITIVE_DECIMAL_POWER_CHARS;
    static final char[][] NEGATIVE_DECIMAL_POWER_CHARS;
    static final long[] FOUR_DIGITS_64_BITS;
    static final int[] FOUR_DIGITS_32_BITS;
    static final int[] TWO_DIGITS_32_BITS;
    static final short[] TWO_DIGITS_16_BITS;
    static final int[] HEX_DIGITS_INT32;
    static final int[] HEX_DIGITS_INT16;
    static final BigInteger BI_TO_DECIMAL_BASE;
    static final BigInteger BI_MAX_VALUE_FOR_LONG;
    static ThreadLocal<Integer> THREAD_CACHE_INDEX;

    JSONWriter() {
    }

    static JSONWriter forStringWriter(JSONConfig jsonConfig) {
        if (jsonConfig.isIgnoreEscapeCheck()) {
            return new JSONCharArrayWriter.IgnoreEscapeWriter();
        }
        return new JSONCharArrayWriter();
    }

    static JSONWriter forBytesWriter(Charset charset, JSONConfig jsonConfig) {
        return new JSONByteArrayWriter(charset);
    }

    static JSONWriter forStreamWriter(Charset charset, JSONConfig jsonConfig) {
        return new JSONByteArrayWriter(charset);
    }

    static JSONWriter wrap(Writer writer) {
        return JSONWrapWriter.wrap(writer);
    }

    public abstract String toString();

    abstract StringBuffer toStringBuffer();

    abstract StringBuilder toStringBuilder();

    protected byte[] toBytes() {
        return this.toBytes(Charset.defaultCharset());
    }

    protected abstract void toOutputStream(OutputStream var1) throws IOException;

    protected byte[] toBytes(Charset charset) {
        return this.toString().getBytes(charset);
    }

    void reset() {
    }

    public void clear() {
    }

    static final void writeNano(int nano, Writer content) throws IOException {
        if (nano > 0) {
            content.write(46);
            int stringSize = NumberUtils.stringSize(nano);
            for (int n = 9 - stringSize; n > 0; --n) {
                content.write(48);
            }
            while (nano % 1000 == 0) {
                nano /= 1000;
            }
            NumberUtils.writePositiveLong(nano, content);
        }
    }

    static final int writeNano(int nano, char[] buf, int off) {
        buf[off++] = 46;
        int div1 = (int)EnvUtils.JDK_AGENT_INSTANCE.multiplyHighKaratsuba(nano, 18446744073709552L);
        int seg1 = (int)EnvUtils.JDK_AGENT_INSTANCE.multiplyHighKaratsuba(div1, 184467440737095517L);
        int seg2 = div1 - 100 * seg1;
        int seg3 = nano - div1 * 1000;
        off += JSONUnsafe.putLong(buf, off, FOUR_DIGITS_64_BITS[seg1]);
        if (seg3 > 0) {
            off += JSONUnsafe.putInt(buf, off, TWO_DIGITS_32_BITS[seg2]);
            int pos = --off;
            char last = buf[pos];
            off += JSONUnsafe.putLong(buf, pos, FOUR_DIGITS_64_BITS[seg3]);
            buf[pos] = last;
        } else {
            off = seg2 == 0 && (seg1 & 1) == 0 && seg1 % 5 == 0 ? --off : (off += JSONUnsafe.putInt(buf, off, TWO_DIGITS_32_BITS[seg2]));
        }
        return off;
    }

    public final void writeZoneId(String zoneId) throws IOException {
        if (zoneId == null) {
            return;
        }
        if (zoneId.length() > 0) {
            char c = zoneId.charAt(0);
            switch (c) {
                case 'Z': {
                    this.writeJSONToken('Z');
                    break;
                }
                case '+': 
                case '-': {
                    this.write(zoneId);
                    break;
                }
                default: {
                    this.write(91);
                    this.write(zoneId);
                    this.write(93);
                }
            }
        }
    }

    public void writeJSONToken(char c) throws IOException {
        this.write(c);
    }

    public abstract void writeShortChars(char[] var1, int var2, int var3) throws IOException;

    public abstract void writeLong(long var1) throws IOException;

    public abstract void writeUUID(UUID var1) throws IOException;

    public abstract void writeDouble(double var1) throws IOException;

    public abstract void writeFloat(float var1) throws IOException;

    public void writeNull() throws IOException {
        this.write("null");
    }

    public final void writeLongArray(long[] values) throws IOException {
        int len = values.length;
        if (len > 0) {
            this.writeJSONToken('[');
            int i = 1;
            this.writeLong(values[0]);
            if ((len & 1) == 0) {
                this.writeJSONToken(',');
                this.writeLong(values[1]);
                ++i;
            }
            while (i < len) {
                this.writeCommaLongValues(values[i], values[i + 1]);
                i += 2;
            }
            this.writeJSONToken(']');
        } else {
            this.writeEmptyArray();
        }
    }

    protected void writeCommaLongValues(long val1, long val2) throws IOException {
        this.writeJSONToken(',');
        this.writeLong(val1);
        this.writeJSONToken(',');
        this.writeLong(val2);
    }

    public final void writeDoubleArray(double[] values) throws IOException {
        int len = values.length;
        if (len > 0) {
            this.writeJSONToken('[');
            int i = 1;
            this.writeDouble(values[0]);
            if ((len & 1) == 0) {
                this.writeJSONToken(',');
                this.writeDouble(values[1]);
                ++i;
            }
            while (i < len) {
                this.writeJSONToken(',');
                this.writeDouble(values[i]);
                this.writeJSONToken(',');
                this.writeDouble(values[i + 1]);
                i += 2;
            }
            this.writeJSONToken(']');
        } else {
            this.writeEmptyArray();
        }
    }

    final void writeStringCompatibleNull(String value) throws IOException {
        if (value == null) {
            this.writeNull();
        } else {
            this.writeJSONString(value);
        }
    }

    public final void writeStringArray(String[] values) throws IOException {
        int len = values.length;
        if (len > 0) {
            this.writeJSONToken('[');
            int i = 1;
            this.writeStringCompatibleNull(values[0]);
            if ((len & 1) == 0) {
                this.writeJSONToken(',');
                this.writeStringCompatibleNull(values[1]);
                ++i;
            }
            while (i < len) {
                this.writeJSONToken(',');
                this.writeStringCompatibleNull(values[i]);
                this.writeJSONToken(',');
                this.writeStringCompatibleNull(values[i + 1]);
                i += 2;
            }
            this.writeJSONToken(']');
        } else {
            this.writeEmptyArray();
        }
    }

    public final void writeStringCollection(Collection values) throws IOException {
        int size = values.size();
        if (size > 0) {
            this.writeJSONToken('[');
            boolean hasAddFlag = false;
            for (Object value : values) {
                if (hasAddFlag) {
                    this.writeJSONToken(',');
                } else {
                    hasAddFlag = true;
                }
                this.writeStringCompatibleNull((String)value);
            }
            this.writeJSONToken(']');
        } else {
            this.writeEmptyArray();
        }
    }

    public final void writeJSONInstant(long epochSeconds, int nanos) throws IOException {
        GeneralDate generalDate = new GeneralDate(epochSeconds * 1000L, JSONGeneral.ZERO_TIME_ZONE);
        int year = generalDate.getYear();
        int month = generalDate.getMonth();
        int day = generalDate.getDay();
        int hour = generalDate.getHourOfDay();
        int minute = generalDate.getMinute();
        int second = generalDate.getSecond();
        this.writeJSONLocalDateTime(year, month, day, hour, minute, second, nanos, "Z");
    }

    public abstract void writeJSONLocalDateTime(int var1, int var2, int var3, int var4, int var5, int var6, int var7, String var8) throws IOException;

    public abstract void writeJSONLocalDate(int var1, int var2, int var3) throws IOException;

    public abstract void writeTime(int var1, int var2, int var3) throws IOException;

    public abstract void writeJSONTimeWithNano(int var1, int var2, int var3, int var4) throws IOException;

    public abstract void writeDate(int var1, int var2, int var3, int var4, int var5, int var6) throws IOException;

    public abstract void writeBigInteger(BigInteger var1) throws IOException;

    public final void writeJSONKeyAndColon(String value) throws IOException {
        this.writeJSONString(value);
        this.writeJSONToken(':');
    }

    public void writeJSONChars(char[] chars) throws IOException {
        int beginIndex = 0;
        int len = chars.length;
        this.write(34);
        for (int i = 0; i < len; ++i) {
            String escapeStr;
            char ch = chars[i];
            if (ch > '\"' && ch != '\\' || (escapeStr = JSONGeneral.ESCAPE_VALUES[ch]) == null) continue;
            int length = i - beginIndex;
            if (length > 0) {
                this.write(chars, beginIndex, length);
            }
            this.write(escapeStr);
            beginIndex = i + 1;
        }
        int size = len - beginIndex;
        this.write(chars, beginIndex, size);
        this.write(34);
    }

    public final void writeJSONString(String value) throws IOException {
        if (EnvUtils.JDK_9_PLUS) {
            byte[] bytes = (byte[])JSONUnsafe.getStringValue(value.toString());
            this.writeJSONStringBytes(value, bytes);
        } else {
            this.writeJSONChars((char[])JSONUnsafe.getStringValue(value.toString()));
        }
    }

    public final void writeJSONStringBytes(String value, byte[] bytes) throws IOException {
        if (bytes.length == value.length()) {
            this.writeLatinJSONString(value, bytes);
        } else {
            this.writeUTF16JSONString(value, bytes);
        }
    }

    public void writeLatinJSONString(String value, byte[] bytes) throws IOException {
        int len = bytes.length;
        this.write(34);
        int beginIndex = 0;
        for (int i = 0; i < len; ++i) {
            byte b = bytes[i];
            String escapeStr = JSONGeneral.ESCAPE_VALUES[b & 0xFF];
            if (escapeStr == null) continue;
            this.write(value, beginIndex, i - beginIndex);
            this.write(escapeStr);
            beginIndex = i + 1;
        }
        int size = len - beginIndex;
        this.write(value, beginIndex, size);
        this.write(34);
    }

    public void writeUTF16JSONString(String value, byte[] bytes) throws IOException {
        this.write(34);
        int beginIndex = 0;
        int strlen = value.length();
        for (int i = 0; i < strlen; ++i) {
            String escapeStr;
            char b = value.charAt(i);
            if (b > '\"' && b != '\\' || (escapeStr = JSONGeneral.ESCAPE_VALUES[b]) == null) continue;
            this.write(value, beginIndex, i - beginIndex);
            this.write(escapeStr);
            beginIndex = i + 1;
        }
        int size = strlen - beginIndex;
        this.write(value, beginIndex, size);
        this.write(34);
    }

    void writeMemory2(int int32, short int16, char[] source, int off) throws IOException {
        this.write(source, off, 2);
    }

    void writeMemory(long fourChars, int fourBytes, int len) throws IOException {
        char[] chars = new char[4];
        JSONUnsafe.putLong(chars, 0, fourChars);
        this.write(chars, 0, len);
    }

    void writeMemory(long fourChars1, long fourChars2, long fourBytes, int len) throws IOException {
        char[] chars = new char[8];
        JSONUnsafe.putLong(chars, 0, fourChars1);
        JSONUnsafe.putLong(chars, 4, fourChars2);
        this.write(chars, 0, len);
    }

    void writeMemory(long[] fourChars, long[] fourBytes, int totalCount) throws IOException {
        int n = fourChars.length;
        char[] chars = new char[n << 2];
        int offset = 0;
        for (long fourChar : fourChars) {
            JSONUnsafe.putLong(chars, offset, fourChar);
            offset += 4;
        }
        this.write(chars, 0, totalCount);
    }

    public void writeEmptyArray() throws IOException {
        this.write(JSONGeneral.EMPTY_ARRAY, 0, 2);
    }

    static final boolean isNoEscape(int b) {
        return JSONGeneral.NO_ESCAPE_FLAGS[b];
    }

    static final int writeUUID(UUID uuid, char[] buf, int offset) {
        long v4;
        long v3;
        long v2;
        long v1;
        long mostSigBits = uuid.getMostSignificantBits();
        int b1 = (int)(mostSigBits >>> 56 & 0xFFL);
        int b2 = (int)(mostSigBits >>> 48 & 0xFFL);
        int b3 = (int)(mostSigBits >>> 40 & 0xFFL);
        int b4 = (int)(mostSigBits >>> 32 & 0xFFL);
        int b5 = (int)(mostSigBits >>> 24 & 0xFFL);
        int b6 = (int)(mostSigBits >>> 16 & 0xFFL);
        int b7 = (int)(mostSigBits >>> 8 & 0xFFL);
        int b8 = (int)(mostSigBits & 0xFFL);
        if (EnvUtils.BIG_ENDIAN) {
            v1 = (long)HEX_DIGITS_INT32[b1] << 32 | (long)HEX_DIGITS_INT32[b2];
            v2 = (long)HEX_DIGITS_INT32[b3] << 32 | (long)HEX_DIGITS_INT32[b4];
            v3 = (long)HEX_DIGITS_INT32[b5] << 32 | (long)HEX_DIGITS_INT32[b6];
            v4 = (long)HEX_DIGITS_INT32[b7] << 32 | (long)HEX_DIGITS_INT32[b8];
        } else {
            v1 = (long)HEX_DIGITS_INT32[b2] << 32 | (long)HEX_DIGITS_INT32[b1];
            v2 = (long)HEX_DIGITS_INT32[b4] << 32 | (long)HEX_DIGITS_INT32[b3];
            v3 = (long)HEX_DIGITS_INT32[b6] << 32 | (long)HEX_DIGITS_INT32[b5];
            v4 = (long)HEX_DIGITS_INT32[b8] << 32 | (long)HEX_DIGITS_INT32[b7];
        }
        offset += JSONUnsafe.putLong(buf, offset, v1);
        offset += JSONUnsafe.putLong(buf, offset, v2);
        buf[offset++] = 45;
        offset += JSONUnsafe.putLong(buf, offset, v3);
        buf[offset++] = 45;
        offset += JSONUnsafe.putLong(buf, offset, v4);
        long leastSigBits = uuid.getLeastSignificantBits();
        int b12 = (int)(leastSigBits >>> 56 & 0xFFL);
        int b22 = (int)(leastSigBits >>> 48 & 0xFFL);
        int b32 = (int)(leastSigBits >>> 40 & 0xFFL);
        int b42 = (int)(leastSigBits >>> 32 & 0xFFL);
        int b52 = (int)(leastSigBits >>> 24 & 0xFFL);
        int b62 = (int)(leastSigBits >>> 16 & 0xFFL);
        int b72 = (int)(leastSigBits >>> 8 & 0xFFL);
        int b82 = (int)(leastSigBits & 0xFFL);
        if (EnvUtils.BIG_ENDIAN) {
            v1 = (long)HEX_DIGITS_INT32[b12] << 32 | (long)HEX_DIGITS_INT32[b22];
            v2 = (long)HEX_DIGITS_INT32[b32] << 32 | (long)HEX_DIGITS_INT32[b42];
            v3 = (long)HEX_DIGITS_INT32[b52] << 32 | (long)HEX_DIGITS_INT32[b62];
            v4 = (long)HEX_DIGITS_INT32[b72] << 32 | (long)HEX_DIGITS_INT32[b82];
        } else {
            v1 = (long)HEX_DIGITS_INT32[b22] << 32 | (long)HEX_DIGITS_INT32[b12];
            v2 = (long)HEX_DIGITS_INT32[b42] << 32 | (long)HEX_DIGITS_INT32[b32];
            v3 = (long)HEX_DIGITS_INT32[b62] << 32 | (long)HEX_DIGITS_INT32[b52];
            v4 = (long)HEX_DIGITS_INT32[b82] << 32 | (long)HEX_DIGITS_INT32[b72];
        }
        buf[offset++] = 45;
        offset += JSONUnsafe.putLong(buf, offset, v1);
        buf[offset++] = 45;
        offset += JSONUnsafe.putLong(buf, offset, v2);
        offset += JSONUnsafe.putLong(buf, offset, v3);
        JSONUnsafe.putLong(buf, offset, v4);
        return 36;
    }

    static final int writeUUID(UUID uuid, byte[] buf, int offset) {
        long v3;
        int v2;
        int v1;
        int v32;
        int v22;
        long v12;
        long mostSigBits = uuid.getMostSignificantBits();
        int b1 = (int)(mostSigBits >>> 56 & 0xFFL);
        int b2 = (int)(mostSigBits >>> 48 & 0xFFL);
        int b3 = (int)(mostSigBits >>> 40 & 0xFFL);
        int b4 = (int)(mostSigBits >>> 32 & 0xFFL);
        int b5 = (int)(mostSigBits >>> 24 & 0xFFL);
        int b6 = (int)(mostSigBits >>> 16 & 0xFFL);
        int b7 = (int)(mostSigBits >>> 8 & 0xFFL);
        int b8 = (int)(mostSigBits & 0xFFL);
        if (EnvUtils.BIG_ENDIAN) {
            v12 = (long)HEX_DIGITS_INT16[b1] << 48 | (long)HEX_DIGITS_INT16[b2] << 32 | (long)(HEX_DIGITS_INT16[b3] << 16) | (long)HEX_DIGITS_INT16[b4];
            v22 = HEX_DIGITS_INT16[b5] << 16 | HEX_DIGITS_INT16[b6];
            v32 = HEX_DIGITS_INT16[b7] << 16 | HEX_DIGITS_INT16[b8];
        } else {
            v12 = (long)HEX_DIGITS_INT16[b4] << 48 | (long)HEX_DIGITS_INT16[b3] << 32 | (long)(HEX_DIGITS_INT16[b2] << 16) | (long)HEX_DIGITS_INT16[b1];
            v22 = HEX_DIGITS_INT16[b6] << 16 | HEX_DIGITS_INT16[b5];
            v32 = HEX_DIGITS_INT16[b8] << 16 | HEX_DIGITS_INT16[b7];
        }
        offset += JSONUnsafe.putLong(buf, offset, v12);
        buf[offset++] = 45;
        offset += JSONUnsafe.putInt(buf, offset, v22);
        buf[offset++] = 45;
        offset += JSONUnsafe.putInt(buf, offset, v32);
        long leastSigBits = uuid.getLeastSignificantBits();
        int b12 = (int)(leastSigBits >>> 56 & 0xFFL);
        int b22 = (int)(leastSigBits >>> 48 & 0xFFL);
        int b32 = (int)(leastSigBits >>> 40 & 0xFFL);
        int b42 = (int)(leastSigBits >>> 32 & 0xFFL);
        int b52 = (int)(leastSigBits >>> 24 & 0xFFL);
        int b62 = (int)(leastSigBits >>> 16 & 0xFFL);
        int b72 = (int)(leastSigBits >>> 8 & 0xFFL);
        int b82 = (int)(leastSigBits & 0xFFL);
        if (EnvUtils.BIG_ENDIAN) {
            v1 = HEX_DIGITS_INT16[b12] << 16 | HEX_DIGITS_INT16[b22];
            v2 = HEX_DIGITS_INT16[b32] << 16 | HEX_DIGITS_INT16[b42];
            v3 = (long)HEX_DIGITS_INT16[b52] << 48 | (long)HEX_DIGITS_INT16[b62] << 32 | (long)(HEX_DIGITS_INT16[b72] << 16) | (long)HEX_DIGITS_INT16[b82];
        } else {
            v1 = HEX_DIGITS_INT16[b22] << 16 | HEX_DIGITS_INT16[b12];
            v2 = HEX_DIGITS_INT16[b42] << 16 | HEX_DIGITS_INT16[b32];
            v3 = (long)HEX_DIGITS_INT16[b82] << 48 | (long)HEX_DIGITS_INT16[b72] << 32 | (long)(HEX_DIGITS_INT16[b62] << 16) | (long)HEX_DIGITS_INT16[b52];
        }
        buf[offset++] = 45;
        offset += JSONUnsafe.putInt(buf, offset, v1);
        buf[offset++] = 45;
        offset += JSONUnsafe.putInt(buf, offset, v2);
        JSONUnsafe.putLong(buf, offset, v3);
        return 36;
    }

    static final int writeDouble(double doubleValue, char[] buf, int off) {
        boolean sign;
        int beginIndex = off;
        if (doubleValue == 0.0) {
            long bits = Double.doubleToLongBits(doubleValue);
            if (bits == Long.MIN_VALUE) {
                buf[off++] = 45;
            }
            buf[off++] = 48;
            off += JSONUnsafe.putInt(buf, off, DOT_ZERO_32);
            return off - beginIndex;
        }
        boolean bl = sign = doubleValue < 0.0;
        if (sign) {
            buf[off++] = 45;
            doubleValue = -doubleValue;
        }
        if (doubleValue == (double)((long)doubleValue)) {
            long output = (long)doubleValue;
            int numLength = NumberUtils.stringSize(output);
            return JSONWriter.writeDecimal(output, numLength, numLength - 1, buf, beginIndex, off);
        }
        Scientific scientific = NumberUtils.doubleToScientific(doubleValue);
        int e10 = scientific.e10;
        if (!scientific.b) {
            return JSONWriter.writeDecimal(scientific.output, scientific.count, e10, buf, beginIndex, off);
        }
        if (scientific == Scientific.SCIENTIFIC_NULL) {
            off += JSONUnsafe.putLong(buf, off, JSONGeneral.NULL_LONG);
            return off - beginIndex;
        }
        if (e10 >= 0) {
            char[] chars = POSITIVE_DECIMAL_POWER_CHARS[e10];
            System.arraycopy(chars, 0, buf, off, chars.length);
            return (off += chars.length) - beginIndex;
        }
        char[] chars = NEGATIVE_DECIMAL_POWER_CHARS[-e10];
        System.arraycopy(chars, 0, buf, off, chars.length);
        return (off += chars.length) - beginIndex;
    }

    static final int writeFloat(float floatValue, char[] buf, int off) {
        boolean sign;
        if (Float.isNaN(floatValue) || floatValue == Float.POSITIVE_INFINITY || floatValue == Float.NEGATIVE_INFINITY) {
            return JSONUnsafe.putLong(buf, off, JSONGeneral.NULL_LONG);
        }
        int beginIndex = off;
        if (floatValue == 0.0f) {
            int bits = Float.floatToIntBits(floatValue);
            if (bits == Integer.MIN_VALUE) {
                buf[off++] = 45;
            }
            buf[off++] = 48;
            off += JSONUnsafe.putInt(buf, off, DOT_ZERO_32);
            return off - beginIndex;
        }
        boolean bl = sign = floatValue < 0.0f;
        if (sign) {
            buf[off++] = 45;
            floatValue = -floatValue;
        }
        Scientific scientific = NumberUtils.floatToScientific(floatValue);
        return JSONWriter.writeDecimal(scientific.output, scientific.count, scientific.e10, buf, beginIndex, off);
    }

    static final int writeDecimal(long value, int digitCnt, int e10, char[] buf, int beginIndex, int off) {
        boolean useScientific;
        if ((value & 1L) == 0L && value % 5L == 0L) {
            while (value % 100L == 0L) {
                value /= 100L;
                if ((digitCnt -= 2) != 1) continue;
            }
            if ((value & 1L) == 0L && value % 5L == 0L && value > 0L) {
                --digitCnt;
                value /= 10L;
            }
        }
        boolean bl = useScientific = e10 < -3 || e10 >= 7;
        if (useScientific) {
            if (digitCnt == 1) {
                buf[off++] = (char)(value + 48L);
                off += JSONUnsafe.putInt(buf, off, DOT_ZERO_32);
            } else {
                int pos = digitCnt - 2;
                long tl = POW10_LONG_VALUES[pos];
                int fd = (int)(value / tl);
                buf[off++] = (char)(fd + 48);
                buf[off++] = 46;
                long pointAfter = value - (long)fd * tl;
                while (--pos > -1 && pointAfter < POW10_LONG_VALUES[pos]) {
                    buf[off++] = 48;
                }
                off += JSONWriter.writeInteger(pointAfter, buf, off);
            }
            buf[off++] = 69;
            if (e10 < 0) {
                buf[off++] = 45;
                e10 = -e10;
            }
            if (e10 > 99) {
                int n = e10 / 100;
                buf[off++] = (char)(n + 48);
                off += JSONUnsafe.putInt(buf, off, TWO_DIGITS_32_BITS[e10 -= n * 100]);
            } else if (e10 > 9) {
                off += JSONUnsafe.putInt(buf, off, TWO_DIGITS_32_BITS[e10]);
            } else {
                buf[off++] = (char)(e10 + 48);
            }
        } else if (e10 < 0) {
            off += JSONUnsafe.putInt(buf, off, ZERO_DOT_32);
            if (e10 == -2) {
                buf[off++] = 48;
            } else if (e10 == -3) {
                off += JSONUnsafe.putInt(buf, off, 0x300030);
            }
            off += JSONWriter.writeInteger(value, buf, off);
        } else {
            int decimalPointPos = digitCnt - 1 - e10;
            if (decimalPointPos > 0) {
                int pos = decimalPointPos - 1;
                long tl = POW10_LONG_VALUES[pos];
                int pointBefore = (int)(value / tl);
                off += JSONWriter.writeInteger((long)pointBefore, buf, off);
                buf[off++] = 46;
                long pointAfter = value - (long)pointBefore * tl;
                while (--pos > -1 && pointAfter < POW10_LONG_VALUES[pos]) {
                    buf[off++] = 48;
                }
                off += JSONWriter.writeInteger(pointAfter, buf, off);
            } else {
                off += JSONWriter.writeInteger(value, buf, off);
                int zeroCnt = -decimalPointPos;
                if (zeroCnt > 0) {
                    for (int i = 0; i < zeroCnt; ++i) {
                        buf[off++] = 48;
                    }
                }
                off += JSONUnsafe.putInt(buf, off, DOT_ZERO_32);
            }
        }
        return off - beginIndex;
    }

    static final int writeDouble(double doubleValue, byte[] buf, int off) {
        char[] chars;
        boolean sign;
        int beginIndex = off;
        if (doubleValue == 0.0) {
            long bits = Double.doubleToLongBits(doubleValue);
            if (bits == Long.MIN_VALUE) {
                buf[off++] = 45;
            }
            buf[off++] = 48;
            off += JSONUnsafe.putShort(buf, off, DOT_ZERO_16);
            return off - beginIndex;
        }
        boolean bl = sign = doubleValue < 0.0;
        if (sign) {
            buf[off++] = 45;
            doubleValue = -doubleValue;
        }
        if (doubleValue == (double)((long)doubleValue)) {
            long output = (long)doubleValue;
            int numLength = NumberUtils.stringSize(output);
            return JSONWriter.writeDecimal(output, numLength, numLength - 1, buf, beginIndex, off);
        }
        Scientific scientific = NumberUtils.doubleToScientific(doubleValue);
        int e10 = scientific.e10;
        if (!scientific.b) {
            return JSONWriter.writeDecimal(scientific.output, scientific.count, scientific.e10, buf, beginIndex, off);
        }
        if (scientific == Scientific.SCIENTIFIC_NULL) {
            off += JSONUnsafe.putInt(buf, off, JSONGeneral.NULL_INT);
            return off - beginIndex;
        }
        if (e10 >= 0) {
            char[] chars2;
            for (char c : chars2 = POSITIVE_DECIMAL_POWER_CHARS[e10]) {
                buf[off++] = (byte)c;
            }
            return off - beginIndex;
        }
        for (char c : chars = NEGATIVE_DECIMAL_POWER_CHARS[-e10]) {
            buf[off++] = (byte)c;
        }
        return off - beginIndex;
    }

    static final int writeFloat(float floatValue, byte[] buf, int off) {
        boolean sign;
        if (Float.isNaN(floatValue) || floatValue == Float.POSITIVE_INFINITY || floatValue == Float.NEGATIVE_INFINITY) {
            return JSONUnsafe.putInt(buf, off, JSONGeneral.NULL_INT);
        }
        int beginIndex = off;
        if (floatValue == 0.0f) {
            int bits = Float.floatToIntBits(floatValue);
            if (bits == Integer.MIN_VALUE) {
                buf[off++] = 45;
            }
            buf[off++] = 48;
            off += JSONUnsafe.putShort(buf, off, DOT_ZERO_16);
            return off - beginIndex;
        }
        boolean bl = sign = floatValue < 0.0f;
        if (sign) {
            buf[off++] = 45;
            floatValue = -floatValue;
        }
        Scientific scientific = NumberUtils.floatToScientific(floatValue);
        return JSONWriter.writeDecimal(scientific.output, scientific.count, scientific.e10, buf, beginIndex, off);
    }

    static final int writeDecimal(long value, int digitCnt, int e10, byte[] buf, int beginIndex, int off) {
        boolean useScientific;
        if ((value & 1L) == 0L && value % 5L == 0L) {
            while (value % 100L == 0L) {
                value /= 100L;
                if ((digitCnt -= 2) != 1) continue;
            }
            if ((value & 1L) == 0L && value % 5L == 0L && value > 0L) {
                --digitCnt;
                value /= 10L;
            }
        }
        boolean bl = useScientific = e10 < -3 || e10 >= 7;
        if (useScientific) {
            if (digitCnt == 1) {
                buf[off++] = (byte)(value + 48L);
                off += JSONUnsafe.putShort(buf, off, DOT_ZERO_16);
            } else {
                int pos = digitCnt - 2;
                long tl = POW10_LONG_VALUES[pos];
                int fd = (int)(value / tl);
                buf[off++] = (byte)(fd + 48);
                buf[off++] = 46;
                long pointAfter = value - (long)fd * tl;
                while (--pos > -1 && pointAfter < POW10_LONG_VALUES[pos]) {
                    buf[off++] = 48;
                }
                off += JSONWriter.writeInteger(pointAfter, buf, off);
            }
            buf[off++] = 69;
            if (e10 < 0) {
                buf[off++] = 45;
                e10 = -e10;
            }
            if (e10 > 99) {
                int n = e10 / 100;
                buf[off++] = (byte)(n + 48);
                off += JSONUnsafe.putShort(buf, off, TWO_DIGITS_16_BITS[e10 -= n * 100]);
            } else if (e10 > 9) {
                off += JSONUnsafe.putShort(buf, off, TWO_DIGITS_16_BITS[e10]);
            } else {
                buf[off++] = (byte)(e10 + 48);
            }
        } else if (e10 < 0) {
            off += JSONUnsafe.putShort(buf, off, ZERO_DOT_16);
            if (e10 == -2) {
                buf[off++] = 48;
            } else if (e10 == -3) {
                off += JSONUnsafe.putShort(buf, off, (short)12336);
            }
            off += JSONWriter.writeInteger(value, buf, off);
        } else {
            int decimalPointPos = digitCnt - 1 - e10;
            if (decimalPointPos > 0) {
                int pos = decimalPointPos - 1;
                long tl = POW10_LONG_VALUES[pos];
                int pointBefore = (int)(value / tl);
                off += JSONWriter.writeInteger((long)pointBefore, buf, off);
                buf[off++] = 46;
                long pointAfter = value - (long)pointBefore * tl;
                while (--pos > -1 && pointAfter < POW10_LONG_VALUES[pos]) {
                    buf[off++] = 48;
                }
                off += JSONWriter.writeInteger(pointAfter, buf, off);
            } else {
                off += JSONWriter.writeInteger(value, buf, off);
                int zeroCnt = -decimalPointPos;
                if (zeroCnt > 0) {
                    for (int i = 0; i < zeroCnt; ++i) {
                        buf[off++] = 48;
                    }
                }
                off += JSONUnsafe.putShort(buf, off, DOT_ZERO_16);
            }
        }
        return off - beginIndex;
    }

    static final int writeBigInteger(BigInteger val, char[] chars, int off) {
        int beginIndex = off;
        if (val.signum() == -1) {
            chars[off++] = 45;
            val = val.negate();
        }
        if (val.compareTo(BI_MAX_VALUE_FOR_LONG) < 1) {
            long value = val.longValue();
            off += JSONWriter.writeInteger(value, chars, off);
            return off - beginIndex;
        }
        int bigLength = val.bitLength();
        int[] values = new int[bigLength / 31];
        int len = 0;
        while (true) {
            BigInteger[] bigIntegers = val.divideAndRemainder(BI_TO_DECIMAL_BASE);
            int rem = bigIntegers[1].intValue();
            val = bigIntegers[0];
            if (val.compareTo(BI_MAX_VALUE_FOR_LONG) < 1) {
                long headNum = val.longValue();
                off += JSONWriter.writeInteger(headNum, chars, off);
                int pos = 8;
                while (--pos > -1 && (long)rem < POW10_LONG_VALUES[pos]) {
                    chars[off++] = 48;
                }
                off += JSONWriter.writeInteger((long)rem, chars, off);
                for (int j = len - 1; j > -1; --j) {
                    int value = values[j];
                    pos = 8;
                    while (--pos > -1 && (long)value < POW10_LONG_VALUES[pos]) {
                        chars[off++] = 48;
                    }
                    off += JSONWriter.writeInteger((long)value, chars, off);
                }
                return off - beginIndex;
            }
            values[len++] = rem;
        }
    }

    static final int writeBigInteger(BigInteger val, byte[] buf, int off) {
        int beginIndex = off;
        if (val.signum() == -1) {
            buf[off++] = 45;
            val = val.negate();
        }
        if (val.compareTo(BI_MAX_VALUE_FOR_LONG) < 1) {
            long value = val.longValue();
            off += JSONWriter.writeInteger(value, buf, off);
            return off - beginIndex;
        }
        int bigLength = val.bitLength();
        int[] values = new int[bigLength / 31];
        int len = 0;
        while (true) {
            BigInteger[] bigIntegers = val.divideAndRemainder(BI_TO_DECIMAL_BASE);
            int rem = bigIntegers[1].intValue();
            val = bigIntegers[0];
            if (val.compareTo(BI_MAX_VALUE_FOR_LONG) < 1) {
                long headNum = val.longValue();
                off += JSONWriter.writeInteger(headNum, buf, off);
                int pos = 8;
                while (--pos > -1 && (long)rem < POW10_LONG_VALUES[pos]) {
                    buf[off++] = 48;
                }
                off += JSONWriter.writeInteger((long)rem, buf, off);
                for (int j = len - 1; j > -1; --j) {
                    int value = values[j];
                    pos = 8;
                    while (--pos > -1 && (long)value < POW10_LONG_VALUES[pos]) {
                        buf[off++] = 48;
                    }
                    off += JSONWriter.writeInteger((long)value, buf, off);
                }
                return off - beginIndex;
            }
            values[len++] = rem;
        }
    }

    static final int writeThreeDigits(int val, char[] chars, int off) {
        if (val < 10) {
            chars[off] = (char)(val + 48);
            return 1;
        }
        if (val < 100) {
            JSONUnsafe.putInt(chars, off, TWO_DIGITS_32_BITS[val]);
            return 2;
        }
        int v = (int)EnvUtils.JDK_AGENT_INSTANCE.multiplyHighKaratsuba(val, 184467440737095517L);
        int v1 = val - v * 100;
        chars[off++] = (char)(v + 48);
        JSONUnsafe.putInt(chars, off, TWO_DIGITS_32_BITS[v1]);
        return 3;
    }

    static final int writeThreeDigits(int val, byte[] buf, int off) {
        if (val < 10) {
            buf[off] = (byte)(val + 48);
            return 1;
        }
        if (val < 100) {
            JSONUnsafe.putShort(buf, off, TWO_DIGITS_16_BITS[val]);
            return 2;
        }
        int v = (int)EnvUtils.JDK_AGENT_INSTANCE.multiplyHighKaratsuba(val, 184467440737095517L);
        int v1 = val - v * 100;
        buf[off++] = (byte)(v + 48);
        JSONUnsafe.putShort(buf, off, TWO_DIGITS_16_BITS[v1]);
        return 3;
    }

    static final int writeInteger(long val, char[] chars, int off) {
        if (val < 10000L) {
            int v = (int)val;
            if (v < 1000) {
                return JSONWriter.writeThreeDigits(v, chars, off);
            }
            return JSONUnsafe.putLong(chars, off, FOUR_DIGITS_64_BITS[v]);
        }
        int beginIndex = off;
        long numValue = val;
        val = EnvUtils.JDK_AGENT_INSTANCE.multiplyHighKaratsuba(numValue, 7555786372591432342L) >> 12;
        int v1 = (int)(numValue - val * 10000L);
        if (val < 10000L) {
            int v = (int)val;
            off = v < 1000 ? (off += JSONWriter.writeThreeDigits(v, chars, off)) : (off += JSONUnsafe.putLong(chars, off, FOUR_DIGITS_64_BITS[v]));
            off += JSONUnsafe.putLong(chars, off, FOUR_DIGITS_64_BITS[v1]);
            return off - beginIndex;
        }
        numValue = val;
        val = EnvUtils.JDK_AGENT_INSTANCE.multiplyHighKaratsuba(numValue, 1844674407370956L);
        int v2 = (int)(numValue - val * 10000L);
        if (val < 10000L) {
            int v = (int)val;
            off = v < 1000 ? (off += JSONWriter.writeThreeDigits(v, chars, off)) : (off += JSONUnsafe.putLong(chars, off, FOUR_DIGITS_64_BITS[v]));
            off += JSONUnsafe.putLong(chars, off, FOUR_DIGITS_64_BITS[v2]);
            off += JSONUnsafe.putLong(chars, off, FOUR_DIGITS_64_BITS[v1]);
            return off - beginIndex;
        }
        numValue = val;
        val = EnvUtils.JDK_AGENT_INSTANCE.multiplyHighKaratsuba(numValue, 1844674407370956L);
        int v3 = (int)(numValue - val * 10000L);
        if (val < 10000L) {
            int v = (int)val;
            off = v < 1000 ? (off += JSONWriter.writeThreeDigits(v, chars, off)) : (off += JSONUnsafe.putLong(chars, off, FOUR_DIGITS_64_BITS[v]));
            off += JSONUnsafe.putLong(chars, off, FOUR_DIGITS_64_BITS[v3]);
            off += JSONUnsafe.putLong(chars, off, FOUR_DIGITS_64_BITS[v2]);
            off += JSONUnsafe.putLong(chars, off, FOUR_DIGITS_64_BITS[v1]);
            return off - beginIndex;
        }
        numValue = val;
        val = EnvUtils.JDK_AGENT_INSTANCE.multiplyHighKaratsuba(numValue, 1844674407370956L);
        int v4 = (int)(numValue - val * 10000L);
        off += JSONWriter.writeThreeDigits((int)val, chars, off);
        off += JSONUnsafe.putLong(chars, off, FOUR_DIGITS_64_BITS[v4]);
        off += JSONUnsafe.putLong(chars, off, FOUR_DIGITS_64_BITS[v3]);
        off += JSONUnsafe.putLong(chars, off, FOUR_DIGITS_64_BITS[v2]);
        off += JSONUnsafe.putLong(chars, off, FOUR_DIGITS_64_BITS[v1]);
        return off - beginIndex;
    }

    static final long mergeInt64(int val, char pre, char suff) {
        return EnvUtils.BIG_ENDIAN ? (long)pre << 48 | (long)TWO_DIGITS_32_BITS[val] << 16 | (long)suff : (long)suff << 48 | (long)TWO_DIGITS_32_BITS[val] << 16 | (long)pre;
    }

    static final int mergeInt32(int val, char pre, char suff) {
        return EnvUtils.BIG_ENDIAN ? pre << 24 | TWO_DIGITS_16_BITS[val] << 8 | suff : suff << 24 | TWO_DIGITS_16_BITS[val] << 8 | pre;
    }

    static final long mergeInt64(int t, int r) {
        long top32 = FOUR_DIGITS_32_BITS[t];
        long rem32 = FOUR_DIGITS_32_BITS[r];
        return EnvUtils.BIG_ENDIAN ? top32 << 32 | rem32 : rem32 << 32 | top32;
    }

    static final long mergeYYYY_MM_(int year, int month) {
        long year32 = FOUR_DIGITS_32_BITS[year];
        long month16 = TWO_DIGITS_16_BITS[month];
        return EnvUtils.BIG_ENDIAN ? year32 << 32 | 0x2D000000L | month16 << 8 | 0x2DL : 0x2D00000000000000L | month16 << 40 | 0x2D00000000L | year32;
    }

    static final long mergeInt64(int s1, char c, int s2, char c1, int s3) {
        return EnvUtils.BIG_ENDIAN ? (long)TWO_DIGITS_16_BITS[s1] << 48 | (long)c << 40 | (long)TWO_DIGITS_16_BITS[s2] << 24 | (long)(c1 << 16) | (long)TWO_DIGITS_16_BITS[s3] : (long)TWO_DIGITS_16_BITS[s3] << 48 | (long)c1 << 40 | (long)TWO_DIGITS_16_BITS[s2] << 24 | (long)(c << 16) | (long)TWO_DIGITS_16_BITS[s1];
    }

    static final int writeInteger(long val, byte[] buf, int off) {
        if (val < 10000L) {
            int v = (int)val;
            if (v < 1000) {
                return JSONWriter.writeThreeDigits(v, buf, off);
            }
            return JSONUnsafe.putInt(buf, off, FOUR_DIGITS_32_BITS[v]);
        }
        int beginIndex = off;
        long numValue = val;
        val = EnvUtils.JDK_AGENT_INSTANCE.multiplyHighKaratsuba(numValue, 7555786372591432342L) >> 12;
        int v1 = (int)(numValue - val * 10000L);
        if (val < 10000L) {
            int v = (int)val;
            if (v < 1000) {
                off += JSONWriter.writeThreeDigits(v, buf, off);
                off += JSONUnsafe.putInt(buf, off, FOUR_DIGITS_32_BITS[v1]);
            } else {
                off += JSONUnsafe.putLong(buf, off, JSONWriter.mergeInt64(v, v1));
            }
            return off - beginIndex;
        }
        numValue = val;
        val = EnvUtils.JDK_AGENT_INSTANCE.multiplyHighKaratsuba(numValue, 1844674407370956L);
        int v2 = (int)(numValue - val * 10000L);
        if (val < 10000L) {
            int v = (int)val;
            off = v < 1000 ? (off += JSONWriter.writeThreeDigits(v, buf, off)) : (off += JSONUnsafe.putInt(buf, off, FOUR_DIGITS_32_BITS[v]));
            off += JSONUnsafe.putLong(buf, off, JSONWriter.mergeInt64(v2, v1));
            return off - beginIndex;
        }
        numValue = val;
        val = EnvUtils.JDK_AGENT_INSTANCE.multiplyHighKaratsuba(numValue, 1844674407370956L);
        int v3 = (int)(numValue - val * 10000L);
        if (val < 10000L) {
            int v = (int)val;
            if (v < 1000) {
                off += JSONWriter.writeThreeDigits(v, buf, off);
                off += JSONUnsafe.putInt(buf, off, FOUR_DIGITS_32_BITS[v3]);
            } else {
                off += JSONUnsafe.putLong(buf, off, JSONWriter.mergeInt64(v, v3));
            }
            off += JSONUnsafe.putLong(buf, off, JSONWriter.mergeInt64(v2, v1));
            return off - beginIndex;
        }
        numValue = val;
        val = EnvUtils.JDK_AGENT_INSTANCE.multiplyHighKaratsuba(numValue, 1844674407370956L);
        int v4 = (int)(numValue - val * 10000L);
        off += JSONWriter.writeThreeDigits((int)val, buf, off);
        off += JSONUnsafe.putLong(buf, off, JSONWriter.mergeInt64(v4, v3));
        off += JSONUnsafe.putLong(buf, off, JSONWriter.mergeInt64(v2, v1));
        return off - beginIndex;
    }

    public final void writeJSONChar(char ch) throws IOException {
        String escapeStr;
        this.writeJSONToken('\"');
        if (ch > '\"' && ch != '\\' || (escapeStr = JSONGeneral.ESCAPE_VALUES[ch]) == null) {
            this.writeJSONToken(ch);
        } else {
            this.write(escapeStr, 0, escapeStr.length());
        }
        this.writeJSONToken('\"');
    }

    public void writeAsBase64String(byte[] src) throws IOException {
        this.writeJSONToken('\"');
        char[] chars = new char[src.length / 3 + 1 << 2];
        int len = Base64Utils.encode(src, chars, 0);
        this.write(chars, 0, len);
        this.writeJSONToken('\"');
    }

    public void writeAsHexString(byte[] src) throws IOException {
        this.writeJSONToken('\"');
        char[] buf = new char[src.length << 1];
        int count = 0;
        for (byte b : src) {
            count += JSONUnsafe.putInt(buf, count, HEX_DIGITS_INT32[b & 0xFF]);
        }
        this.write(buf, 0, count);
        this.writeJSONToken('\"');
    }

    public void writeTo(Writer writer) throws IOException {
        throw new UnsupportedOperationException();
    }

    static {
        int cacheCount;
        AVAILABLE_PROCESSORS = Runtime.getRuntime().availableProcessors();
        AUTO_SEQ = new AtomicInteger();
        ZERO_DOT_32 = EnvUtils.BIG_ENDIAN ? 3145774 : 3014704;
        ZERO_DOT_16 = (short)(EnvUtils.BIG_ENDIAN ? 12334 : 11824);
        DOT_ZERO_32 = EnvUtils.BIG_ENDIAN ? 3014704 : 3145774;
        DOT_ZERO_16 = (short)(EnvUtils.BIG_ENDIAN ? 11824 : 12334);
        HEX_DIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
        POW10_LONG_VALUES = new long[]{10L, 100L, 1000L, 10000L, 100000L, 1000000L, 10000000L, 100000000L, 1000000000L, 10000000000L, 100000000000L, 1000000000000L, 10000000000000L, 100000000000000L, 1000000000000000L, 10000000000000000L, 100000000000000000L, 1000000000000000000L, Long.MAX_VALUE};
        POSITIVE_DECIMAL_POWER_CHARS = new char[325][];
        NEGATIVE_DECIMAL_POWER_CHARS = new char[325][];
        FOUR_DIGITS_64_BITS = new long[10000];
        FOUR_DIGITS_32_BITS = new int[10000];
        TWO_DIGITS_32_BITS = new int[100];
        TWO_DIGITS_16_BITS = new short[100];
        HEX_DIGITS_INT32 = new int[256];
        HEX_DIGITS_INT16 = new int[256];
        BI_TO_DECIMAL_BASE = BigInteger.valueOf(1000000000L);
        BI_MAX_VALUE_FOR_LONG = BigInteger.valueOf(Long.MAX_VALUE);
        CACHE_BUFFER_SIZE = EnvUtils.JDK_VERSION >= 1.8f ? 16384 : 4096;
        MAX_CACHE_BUFFER_SIZE = 0x300000;
        int availableProcessors = AVAILABLE_PROCESSORS << 1;
        for (cacheCount = 16; availableProcessors > cacheCount; cacheCount <<= 1) {
        }
        CACHE_COUNT = cacheCount;
        if (EnvUtils.BIG_ENDIAN) {
            EMPTY_ARRAY_INT = 5963869;
            EMPTY_ARRAY_SHORT = (short)23389;
            Z_QUOT_INT = 5898274;
            Z_QUOT_SHORT = (short)23074;
        } else {
            EMPTY_ARRAY_INT = 6094939;
            EMPTY_ARRAY_SHORT = (short)23899;
            Z_QUOT_INT = 2228314;
            Z_QUOT_SHORT = (short)8794;
        }
        for (long d1 = 0L; d1 < 10L; ++d1) {
            for (long d2 = 0L; d2 < 10L; ++d2) {
                int intVal32;
                long intVal64;
                if (EnvUtils.BIG_ENDIAN) {
                    intVal64 = d1 + 48L << 16 | d2 + 48L;
                    intVal32 = (int)d1 + 48 << 8 | (int)d2 + 48;
                } else {
                    intVal64 = d2 + 48L << 16 | d1 + 48L;
                    intVal32 = (int)d2 + 48 << 8 | (int)d1 + 48;
                }
                int k = (int)(d1 * 10L + d2);
                JSONWriter.TWO_DIGITS_32_BITS[k] = (int)intVal64;
                JSONWriter.TWO_DIGITS_16_BITS[k] = (short)intVal32;
                for (long d3 = 0L; d3 < 10L; ++d3) {
                    for (long d4 = 0L; d4 < 10L; ++d4) {
                        int int32;
                        long int64;
                        if (EnvUtils.BIG_ENDIAN) {
                            int64 = intVal64 << 32 | d3 + 48L << 16 | d4 + 48L;
                            int32 = intVal32 << 16 | (int)d3 + 48 << 8 | (int)d4 + 48;
                        } else {
                            int64 = d4 + 48L << 48 | d3 + 48L << 32 | intVal64;
                            int32 = (int)d4 + 48 << 24 | (int)d3 + 48 << 16 | intVal32;
                        }
                        int index = (int)(d1 * 1000L + d2 * 100L + d3 * 10L + d4);
                        JSONWriter.FOUR_DIGITS_64_BITS[index] = int64;
                        JSONWriter.FOUR_DIGITS_32_BITS[index] = int32;
                    }
                }
            }
        }
        for (int b = 0; b < 256; ++b) {
            int b1 = b >> 4;
            int b2 = b & 0xF;
            JSONWriter.HEX_DIGITS_INT32[b] = EnvUtils.BIG_ENDIAN ? HEX_DIGITS[b1] << 16 | HEX_DIGITS[b2] : HEX_DIGITS[b2] << 16 | HEX_DIGITS[b1];
            JSONWriter.HEX_DIGITS_INT16[b] = EnvUtils.BIG_ENDIAN ? HEX_DIGITS[b1] << 8 | HEX_DIGITS[b2] : HEX_DIGITS[b2] << 8 | HEX_DIGITS[b1];
        }
        int len = POSITIVE_DECIMAL_POWER_CHARS.length;
        for (int i = 0; i < len; ++i) {
            String positive = "1.0E" + i;
            String negative = "1.0E-" + i;
            JSONWriter.POSITIVE_DECIMAL_POWER_CHARS[i] = positive.toCharArray();
            JSONWriter.NEGATIVE_DECIMAL_POWER_CHARS[i] = negative.toCharArray();
        }
        JSONWriter.NEGATIVE_DECIMAL_POWER_CHARS[JSONWriter.NEGATIVE_DECIMAL_POWER_CHARS.length - 1] = "4.9E-324".toCharArray();
        THREAD_CACHE_INDEX = new ThreadLocal<Integer>(){

            @Override
            protected Integer initialValue() {
                return AUTO_SEQ.incrementAndGet() & CACHE_COUNT - 1;
            }

            @Override
            public void set(Integer value) {
            }
        };
    }
}

