/*
 * Decompiled with CFR 0.152.
 */
package io.github.wycst.wast.json.temporal;

import io.github.wycst.wast.common.beans.GeneralDate;
import io.github.wycst.wast.common.reflect.GenericParameterizedType;
import io.github.wycst.wast.json.JSONParseContext;
import io.github.wycst.wast.json.JSONTemporalDeserializer;
import io.github.wycst.wast.json.exceptions.JSONException;
import io.github.wycst.wast.json.temporal.TemporalConfig;
import java.time.Instant;

public class TemporalInstantDeserializer
extends JSONTemporalDeserializer {
    public TemporalInstantDeserializer(TemporalConfig temporalConfig) {
        super(temporalConfig);
    }

    @Override
    protected void checkClass(GenericParameterizedType genericParameterizedType) {
    }

    @Override
    protected Object deserializeTemporal(char[] buf, int fromIndex, int endIndex, JSONParseContext jsonParseContext) throws Exception {
        long millis = this.dateTemplate.parseTime(buf, fromIndex + 1, endIndex - fromIndex - 1, ZERO_TIME_ZONE);
        return Instant.ofEpochMilli(millis);
    }

    @Override
    protected Object deserializeTemporal(byte[] buf, int fromIndex, int endIndex, JSONParseContext jsonParseContext) throws Exception {
        long millis = this.dateTemplate.parseTime(buf, fromIndex + 1, endIndex - fromIndex - 1, ZERO_TIME_ZONE);
        return Instant.ofEpochMilli(millis);
    }

    @Override
    protected Object deserializeDefaultTemporal(char[] buf, int offset, char endToken, JSONParseContext jsonParseContext) throws Exception {
        int year;
        char c4;
        char c3;
        char c2;
        int i = offset;
        char c1 = buf[i];
        if (TemporalInstantDeserializer.isDigit(c1) && TemporalInstantDeserializer.isDigit(c2 = buf[++i]) && TemporalInstantDeserializer.isDigit(c3 = buf[++i]) && TemporalInstantDeserializer.isDigit(c4 = buf[++i])) {
            year = c1 * 1000 + c2 * 100 + c3 * 10 + c4 - 53328;
        } else if (c1 == '-' && TemporalInstantDeserializer.isDigit(c1 = buf[++i]) && TemporalInstantDeserializer.isDigit(c2 = buf[++i]) && TemporalInstantDeserializer.isDigit(c3 = buf[++i]) && TemporalInstantDeserializer.isDigit(c4 = buf[++i])) {
            year = c1 * 1000 + c2 * 100 + c3 * 10 + c4 - 53328;
            year = -year;
        } else {
            String errorContextTextAt = TemporalInstantDeserializer.createErrorContextText(buf, i);
            throw new JSONException("Syntax error, at pos " + i + ", context text by '" + errorContextTextAt + "', year field error ");
        }
        ++i;
        c1 = buf[++i];
        if (!TemporalInstantDeserializer.isDigit(c1)) {
            String errorContextTextAt = TemporalInstantDeserializer.createErrorContextText(buf, i);
            throw new JSONException("Syntax error, at pos " + i + ", context text by '" + errorContextTextAt + "', month field error ");
        }
        int month = c1 - 48;
        c1 = buf[++i];
        if (TemporalInstantDeserializer.isDigit(c1)) {
            month = (month << 3) + (month << 1) + c1 - 48;
        }
        ++i;
        if (!TemporalInstantDeserializer.isDigit(c1 = buf[++i])) {
            String errorContextTextAt = TemporalInstantDeserializer.createErrorContextText(buf, i);
            throw new JSONException("Syntax error, at pos " + i + ", context text by '" + errorContextTextAt + "', day field error ");
        }
        int day = c1 - 48;
        c1 = buf[++i];
        if (TemporalInstantDeserializer.isDigit(c1)) {
            day = (day << 3) + (day << 1) + c1 - 48;
        }
        ++i;
        if (!TemporalInstantDeserializer.isDigit(c1 = buf[++i])) {
            String errorContextTextAt = TemporalInstantDeserializer.createErrorContextText(buf, i);
            throw new JSONException("Syntax error, at pos " + i + ", context text by '" + errorContextTextAt + "', hour field error ");
        }
        int hour = c1 - 48;
        c1 = buf[++i];
        if (TemporalInstantDeserializer.isDigit(c1)) {
            hour = (hour << 3) + (hour << 1) + c1 - 48;
        }
        ++i;
        if (!TemporalInstantDeserializer.isDigit(c1 = buf[++i])) {
            String errorContextTextAt = TemporalInstantDeserializer.createErrorContextText(buf, i);
            throw new JSONException("Syntax error, at pos " + i + ", context text by '" + errorContextTextAt + "', minute field error ");
        }
        int minute = c1 - 48;
        c1 = buf[++i];
        if (TemporalInstantDeserializer.isDigit(c1)) {
            minute = (minute << 3) + (minute << 1) + c1 - 48;
        }
        ++i;
        if (!TemporalInstantDeserializer.isDigit(c1 = buf[++i])) {
            String errorContextTextAt = TemporalInstantDeserializer.createErrorContextText(buf, i);
            throw new JSONException("Syntax error, at pos " + i + ", context text by '" + errorContextTextAt + "', second field error ");
        }
        int second = c1 - 48;
        c1 = buf[++i];
        if (TemporalInstantDeserializer.isDigit(c1)) {
            second = (second << 3) + (second << 1) + c1 - 48;
            c1 = buf[++i];
        }
        long epochSecond = GeneralDate.getSeconds(year, month, day, hour, minute, second);
        int nanoOfSecond = 0;
        char c = c1;
        if (c == '.') {
            int cnt = 9;
            while (TemporalInstantDeserializer.isDigit(c = buf[++i])) {
                nanoOfSecond = (nanoOfSecond << 3) + (nanoOfSecond << 1) + c - 48;
                --cnt;
            }
            if (cnt > 0) {
                nanoOfSecond *= NANO_OF_SECOND_PADDING[cnt];
            }
        }
        switch (c) {
            case 'Z': 
            case 'z': {
                c = buf[++i];
            }
        }
        if (c == endToken) {
            jsonParseContext.endIndex = i;
            return Instant.ofEpochSecond(epochSecond, nanoOfSecond);
        }
        String errorContextTextAt = TemporalInstantDeserializer.createErrorContextText(buf, i);
        throw new JSONException("Syntax error, at pos " + i + ", context text by '" + errorContextTextAt + "', unexpected token '" + c + "', expected '" + endToken + "'");
    }

    @Override
    protected Object deserializeDefaultTemporal(byte[] buf, int offset, char endToken, JSONParseContext jsonParseContext) throws Exception {
        int year;
        byte b4;
        byte b3;
        byte b2;
        int i = offset;
        byte b1 = buf[i];
        if (TemporalInstantDeserializer.isDigit(b1) && TemporalInstantDeserializer.isDigit(b2 = buf[++i]) && TemporalInstantDeserializer.isDigit(b3 = buf[++i]) && TemporalInstantDeserializer.isDigit(b4 = buf[++i])) {
            year = b1 * 1000 + b2 * 100 + b3 * 10 + b4 - 53328;
        } else if (b1 == 45 && TemporalInstantDeserializer.isDigit(b1 = buf[++i]) && TemporalInstantDeserializer.isDigit(b2 = buf[++i]) && TemporalInstantDeserializer.isDigit(b3 = buf[++i]) && TemporalInstantDeserializer.isDigit(b4 = buf[++i])) {
            year = b1 * 1000 + b2 * 100 + b3 * 10 + b4 - 53328;
            year = -year;
        } else {
            String errorContextTextAt = TemporalInstantDeserializer.createErrorContextText(buf, i);
            throw new JSONException("Syntax error, at pos " + i + ", context text by '" + errorContextTextAt + "', year field error ");
        }
        ++i;
        b1 = buf[++i];
        if (!TemporalInstantDeserializer.isDigit(b1)) {
            String errorContextTextAt = TemporalInstantDeserializer.createErrorContextText(buf, i);
            throw new JSONException("Syntax error, at pos " + i + ", context text by '" + errorContextTextAt + "', month field error ");
        }
        int month = b1 - 48;
        b1 = buf[++i];
        if (TemporalInstantDeserializer.isDigit(b1)) {
            month = (month << 3) + (month << 1) + b1 - 48;
        }
        ++i;
        if (!TemporalInstantDeserializer.isDigit(b1 = buf[++i])) {
            String errorContextTextAt = TemporalInstantDeserializer.createErrorContextText(buf, i);
            throw new JSONException("Syntax error, at pos " + i + ", context text by '" + errorContextTextAt + "', day field error ");
        }
        int day = b1 - 48;
        b1 = buf[++i];
        if (TemporalInstantDeserializer.isDigit(b1)) {
            day = (day << 3) + (day << 1) + b1 - 48;
        }
        ++i;
        if (!TemporalInstantDeserializer.isDigit(b1 = buf[++i])) {
            String errorContextTextAt = TemporalInstantDeserializer.createErrorContextText(buf, i);
            throw new JSONException("Syntax error, at pos " + i + ", context text by '" + errorContextTextAt + "', hour field error ");
        }
        int hour = b1 - 48;
        b1 = buf[++i];
        if (TemporalInstantDeserializer.isDigit(b1)) {
            hour = (hour << 3) + (hour << 1) + b1 - 48;
        }
        ++i;
        if (!TemporalInstantDeserializer.isDigit(b1 = buf[++i])) {
            String errorContextTextAt = TemporalInstantDeserializer.createErrorContextText(buf, i);
            throw new JSONException("Syntax error, at pos " + i + ", context text by '" + errorContextTextAt + "', minute field error ");
        }
        int minute = b1 - 48;
        b1 = buf[++i];
        if (TemporalInstantDeserializer.isDigit(b1)) {
            minute = (minute << 3) + (minute << 1) + b1 - 48;
        }
        ++i;
        if (!TemporalInstantDeserializer.isDigit(b1 = buf[++i])) {
            String errorContextTextAt = TemporalInstantDeserializer.createErrorContextText(buf, i);
            throw new JSONException("Syntax error, at pos " + i + ", context text by '" + errorContextTextAt + "', second field error ");
        }
        int second = b1 - 48;
        b1 = buf[++i];
        if (TemporalInstantDeserializer.isDigit(b1)) {
            second = (second << 3) + (second << 1) + b1 - 48;
            b1 = buf[++i];
        }
        long epochSecond = GeneralDate.getSeconds(year, month, day, hour, minute, second);
        int nanoOfSecond = 0;
        byte c = b1;
        if (c == 46) {
            int cnt = 9;
            while (TemporalInstantDeserializer.isDigit(c = buf[++i])) {
                nanoOfSecond = (nanoOfSecond << 3) + (nanoOfSecond << 1) + c - 48;
                --cnt;
            }
            if (cnt > 0) {
                nanoOfSecond *= NANO_OF_SECOND_PADDING[cnt];
            }
        }
        switch (c) {
            case 90: 
            case 122: {
                c = buf[++i];
            }
        }
        if (c == endToken) {
            jsonParseContext.endIndex = i;
            return Instant.ofEpochSecond(epochSecond, nanoOfSecond);
        }
        String errorContextTextAt = TemporalInstantDeserializer.createErrorContextText(buf, i);
        throw new JSONException("Syntax error, at pos " + i + ", context text by '" + errorContextTextAt + "', unexpected token '" + (char)c + "', expected '" + endToken + "'");
    }

    @Override
    protected Object valueOf(String value, Class<?> actualType) throws Exception {
        return Instant.parse(value);
    }

    @Override
    protected Object fromTime(long timestamp) {
        long epochSecond = timestamp / 1000L;
        long millis = timestamp - epochSecond;
        return Instant.ofEpochSecond(epochSecond, millis * 1000000L);
    }

    @Override
    protected boolean supportedTime() {
        return true;
    }
}

