/*
 * Decompiled with CFR 0.152.
 */
package io.github.wycst.wast.json.temporal;

import io.github.wycst.wast.common.beans.GeneralDate;
import io.github.wycst.wast.common.reflect.GenericParameterizedType;
import io.github.wycst.wast.json.JSONParseContext;
import io.github.wycst.wast.json.JSONTemporalDeserializer;
import io.github.wycst.wast.json.exceptions.JSONException;
import io.github.wycst.wast.json.temporal.TemporalConfig;
import java.time.LocalDateTime;

public class TemporalLocalDateTimeDeserializer
extends JSONTemporalDeserializer {
    public TemporalLocalDateTimeDeserializer(TemporalConfig temporalConfig) {
        super(temporalConfig);
    }

    @Override
    protected void checkClass(GenericParameterizedType genericParameterizedType) {
    }

    @Override
    protected Object deserializeTemporal(char[] buf, int fromIndex, int endIndex, JSONParseContext jsonParseContext) throws Exception {
        GeneralDate generalDate = this.dateTemplate.parseGeneralDate(buf, fromIndex + 1, endIndex - fromIndex - 1, ZERO_TIME_ZONE);
        return LocalDateTime.of(generalDate.getYear(), generalDate.getMonth(), generalDate.getDay(), generalDate.getHourOfDay(), generalDate.getMinute(), generalDate.getSecond(), generalDate.getMillisecond() * 1000000);
    }

    @Override
    protected Object deserializeTemporal(byte[] buf, int fromIndex, int endIndex, JSONParseContext jsonParseContext) throws Exception {
        GeneralDate generalDate = this.dateTemplate.parseGeneralDate(buf, fromIndex + 1, endIndex - fromIndex - 1, ZERO_TIME_ZONE);
        return LocalDateTime.of(generalDate.getYear(), generalDate.getMonth(), generalDate.getDay(), generalDate.getHourOfDay(), generalDate.getMinute(), generalDate.getSecond(), generalDate.getMillisecond() * 1000000);
    }

    @Override
    protected Object deserializeDefaultTemporal(char[] buf, int offset, char endToken, JSONParseContext jsonParseContext) throws Exception {
        int year;
        char c4;
        char c3;
        char c2;
        int i = offset;
        char c1 = buf[i];
        if (TemporalLocalDateTimeDeserializer.isDigit(c1) && TemporalLocalDateTimeDeserializer.isDigit(c2 = buf[++i]) && TemporalLocalDateTimeDeserializer.isDigit(c3 = buf[++i]) && TemporalLocalDateTimeDeserializer.isDigit(c4 = buf[++i])) {
            year = c1 * 1000 + c2 * 100 + c3 * 10 + c4 - 53328;
        } else if (c1 == '-' && TemporalLocalDateTimeDeserializer.isDigit(c1 = buf[++i]) && TemporalLocalDateTimeDeserializer.isDigit(c2 = buf[++i]) && TemporalLocalDateTimeDeserializer.isDigit(c3 = buf[++i]) && TemporalLocalDateTimeDeserializer.isDigit(c4 = buf[++i])) {
            year = c1 * 1000 + c2 * 100 + c3 * 10 + c4 - 53328;
            year = -year;
        } else {
            String errorContextTextAt = TemporalLocalDateTimeDeserializer.createErrorContextText(buf, i);
            throw new JSONException("Syntax error, at pos " + i + ", context text by '" + errorContextTextAt + "', year field error ");
        }
        ++i;
        c1 = buf[++i];
        if (!TemporalLocalDateTimeDeserializer.isDigit(c1)) {
            String errorContextTextAt = TemporalLocalDateTimeDeserializer.createErrorContextText(buf, i);
            throw new JSONException("Syntax error, at pos " + i + ", context text by '" + errorContextTextAt + "', month field error ");
        }
        int month = c1 - 48;
        c1 = buf[++i];
        if (TemporalLocalDateTimeDeserializer.isDigit(c1)) {
            month = (month << 3) + (month << 1) + c1 - 48;
        }
        ++i;
        if (!TemporalLocalDateTimeDeserializer.isDigit(c1 = buf[++i])) {
            String errorContextTextAt = TemporalLocalDateTimeDeserializer.createErrorContextText(buf, i);
            throw new JSONException("Syntax error, at pos " + i + ", context text by '" + errorContextTextAt + "', day field error ");
        }
        int day = c1 - 48;
        c1 = buf[++i];
        if (TemporalLocalDateTimeDeserializer.isDigit(c1)) {
            day = (day << 3) + (day << 1) + c1 - 48;
        }
        ++i;
        if (!TemporalLocalDateTimeDeserializer.isDigit(c1 = buf[++i])) {
            String errorContextTextAt = TemporalLocalDateTimeDeserializer.createErrorContextText(buf, i);
            throw new JSONException("Syntax error, at pos " + i + ", context text by '" + errorContextTextAt + "', hour field error ");
        }
        int hour = c1 - 48;
        c1 = buf[++i];
        if (TemporalLocalDateTimeDeserializer.isDigit(c1)) {
            hour = (hour << 3) + (hour << 1) + c1 - 48;
        }
        ++i;
        if (!TemporalLocalDateTimeDeserializer.isDigit(c1 = buf[++i])) {
            String errorContextTextAt = TemporalLocalDateTimeDeserializer.createErrorContextText(buf, i);
            throw new JSONException("Syntax error, at pos " + i + ", context text by '" + errorContextTextAt + "', minute field error ");
        }
        int minute = c1 - 48;
        c1 = buf[++i];
        if (TemporalLocalDateTimeDeserializer.isDigit(c1)) {
            minute = (minute << 3) + (minute << 1) + c1 - 48;
        }
        ++i;
        if (!TemporalLocalDateTimeDeserializer.isDigit(c1 = buf[++i])) {
            String errorContextTextAt = TemporalLocalDateTimeDeserializer.createErrorContextText(buf, i);
            throw new JSONException("Syntax error, at pos " + i + ", context text by '" + errorContextTextAt + "', second field error ");
        }
        int second = c1 - 48;
        c1 = buf[++i];
        if (TemporalLocalDateTimeDeserializer.isDigit(c1)) {
            second = (second << 3) + (second << 1) + c1 - 48;
            c1 = buf[++i];
        }
        int nanoOfSecond = 0;
        char c = c1;
        if (c == '.') {
            boolean isDigitFlag;
            int cnt = 9;
            while ((isDigitFlag = TemporalLocalDateTimeDeserializer.isDigit(c = buf[++i])) && TemporalLocalDateTimeDeserializer.isDigit(c1 = buf[++i])) {
                cnt -= 2;
                nanoOfSecond = nanoOfSecond * 100 + c * 10 + c1 - 528;
            }
            if (isDigitFlag) {
                nanoOfSecond = (nanoOfSecond << 3) + (nanoOfSecond << 1) + c - 48;
                c = c1;
                --cnt;
            }
            if (cnt > 0) {
                nanoOfSecond *= NANO_OF_SECOND_PADDING[cnt];
            }
        }
        if (c == endToken) {
            jsonParseContext.endIndex = i;
            return LocalDateTime.of(year, month, day, hour, minute, second, nanoOfSecond);
        }
        String errorContextTextAt = TemporalLocalDateTimeDeserializer.createErrorContextText(buf, i);
        throw new JSONException("Syntax error, at pos " + i + ", context text by '" + errorContextTextAt + "', unexpected token '" + c + "', expected '" + endToken + "'");
    }

    @Override
    protected Object deserializeDefaultTemporal(byte[] buf, int offset, char endToken, JSONParseContext jsonParseContext) throws Exception {
        int year;
        byte b4;
        byte b3;
        byte b2;
        int i = offset;
        byte b1 = buf[i];
        if (TemporalLocalDateTimeDeserializer.isDigit(b1) && TemporalLocalDateTimeDeserializer.isDigit(b2 = buf[++i]) && TemporalLocalDateTimeDeserializer.isDigit(b3 = buf[++i]) && TemporalLocalDateTimeDeserializer.isDigit(b4 = buf[++i])) {
            year = b1 * 1000 + b2 * 100 + b3 * 10 + b4 - 53328;
        } else if (b1 == 45 && TemporalLocalDateTimeDeserializer.isDigit(b1 = buf[++i]) && TemporalLocalDateTimeDeserializer.isDigit(b2 = buf[++i]) && TemporalLocalDateTimeDeserializer.isDigit(b3 = buf[++i]) && TemporalLocalDateTimeDeserializer.isDigit(b4 = buf[++i])) {
            year = b1 * 1000 + b2 * 100 + b3 * 10 + b4 - 53328;
            year = -year;
        } else {
            String errorContextTextAt = TemporalLocalDateTimeDeserializer.createErrorContextText(buf, i);
            throw new JSONException("Syntax error, at pos " + i + ", context text by '" + errorContextTextAt + "', year field error ");
        }
        ++i;
        b1 = buf[++i];
        if (!TemporalLocalDateTimeDeserializer.isDigit(b1)) {
            String errorContextTextAt = TemporalLocalDateTimeDeserializer.createErrorContextText(buf, i);
            throw new JSONException("Syntax error, at pos " + i + ", context text by '" + errorContextTextAt + "', month field error ");
        }
        int month = b1 - 48;
        b1 = buf[++i];
        if (TemporalLocalDateTimeDeserializer.isDigit(b1)) {
            month = (month << 3) + (month << 1) + b1 - 48;
        }
        ++i;
        if (!TemporalLocalDateTimeDeserializer.isDigit(b1 = buf[++i])) {
            String errorContextTextAt = TemporalLocalDateTimeDeserializer.createErrorContextText(buf, i);
            throw new JSONException("Syntax error, at pos " + i + ", context text by '" + errorContextTextAt + "', day field error ");
        }
        int day = b1 - 48;
        b1 = buf[++i];
        if (TemporalLocalDateTimeDeserializer.isDigit(b1)) {
            day = (day << 3) + (day << 1) + b1 - 48;
        }
        ++i;
        if (!TemporalLocalDateTimeDeserializer.isDigit(b1 = buf[++i])) {
            String errorContextTextAt = TemporalLocalDateTimeDeserializer.createErrorContextText(buf, i);
            throw new JSONException("Syntax error, at pos " + i + ", context text by '" + errorContextTextAt + "', hour field error ");
        }
        int hour = b1 - 48;
        b1 = buf[++i];
        if (TemporalLocalDateTimeDeserializer.isDigit(b1)) {
            hour = (hour << 3) + (hour << 1) + b1 - 48;
        }
        ++i;
        if (!TemporalLocalDateTimeDeserializer.isDigit(b1 = buf[++i])) {
            String errorContextTextAt = TemporalLocalDateTimeDeserializer.createErrorContextText(buf, i);
            throw new JSONException("Syntax error, at pos " + i + ", context text by '" + errorContextTextAt + "', minute field error ");
        }
        int minute = b1 - 48;
        b1 = buf[++i];
        if (TemporalLocalDateTimeDeserializer.isDigit(b1)) {
            minute = (minute << 3) + (minute << 1) + b1 - 48;
        }
        ++i;
        if (!TemporalLocalDateTimeDeserializer.isDigit(b1 = buf[++i])) {
            String errorContextTextAt = TemporalLocalDateTimeDeserializer.createErrorContextText(buf, i);
            throw new JSONException("Syntax error, at pos " + i + ", context text by '" + errorContextTextAt + "', second field error ");
        }
        int second = b1 - 48;
        b1 = buf[++i];
        if (TemporalLocalDateTimeDeserializer.isDigit(b1)) {
            second = (second << 3) + (second << 1) + b1 - 48;
            b1 = buf[++i];
        }
        int nanoOfSecond = 0;
        byte c = b1;
        if (c == 46) {
            boolean isDigitFlag;
            int cnt = 9;
            while ((isDigitFlag = TemporalLocalDateTimeDeserializer.isDigit(c = buf[++i])) && TemporalLocalDateTimeDeserializer.isDigit(b1 = buf[++i])) {
                cnt -= 2;
                nanoOfSecond = nanoOfSecond * 100 + c * 10 + b1 - 528;
            }
            if (isDigitFlag) {
                nanoOfSecond = (nanoOfSecond << 3) + (nanoOfSecond << 1) + c - 48;
                c = b1;
                --cnt;
            }
            if (cnt > 0) {
                nanoOfSecond *= NANO_OF_SECOND_PADDING[cnt];
            }
        }
        if (c == endToken) {
            jsonParseContext.endIndex = i;
            return LocalDateTime.of(year, month, day, hour, minute, second, nanoOfSecond);
        }
        String errorContextTextAt = TemporalLocalDateTimeDeserializer.createErrorContextText(buf, i);
        throw new JSONException("Syntax error, at pos " + i + ", context text by '" + errorContextTextAt + "', unexpected token '" + (char)c + "', expected '" + endToken + "'");
    }

    @Override
    protected Object valueOf(String value, Class<?> actualType) throws Exception {
        return LocalDateTime.parse(value);
    }

    @Override
    protected Object fromTime(long timestamp) {
        GeneralDate generalDate = new GeneralDate(timestamp);
        return LocalDateTime.of(generalDate.getYear(), generalDate.getMonth(), generalDate.getDay(), generalDate.getHourOfDay(), generalDate.getMinute(), generalDate.getSecond(), generalDate.getMillisecond() * 1000000);
    }

    @Override
    protected boolean supportedTime() {
        return true;
    }
}

