/*
 * Decompiled with CFR 0.152.
 */
package io.github.wycst.wast.common.csv;

import io.github.wycst.wast.common.beans.DateParser;
import io.github.wycst.wast.common.beans.GregorianDate;
import io.github.wycst.wast.common.csv.CSVTypeHandler;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;

public interface CSVTemporalHandler {

    public static class CSVLocalTimeHandler
    extends CSVTypeHandler<LocalTime> {
        @Override
        public LocalTime handle(String input, Class<LocalTime> type) throws Throwable {
            if (input == null || input.length() == 0) {
                return null;
            }
            return LocalTime.parse(input);
        }
    }

    public static class CSVLocalDateTimeHandler
    extends CSVTypeHandler<LocalDateTime> {
        @Override
        public LocalDateTime handle(String input, Class<LocalDateTime> type) throws Throwable {
            if (input == null || input.length() == 0) {
                return null;
            }
            GregorianDate date = DateParser.parseDate(input);
            return LocalDateTime.of(date.getYear(), date.getMonth(), date.getDay(), date.getHourOfDay(), date.getMinute(), date.getSecond());
        }
    }

    public static class CSVLocalDateHandler
    extends CSVTypeHandler<LocalDate> {
        @Override
        public LocalDate handle(String input, Class<LocalDate> type) throws Throwable {
            if (input == null || input.length() == 0) {
                return null;
            }
            GregorianDate date = DateParser.parseDate(input);
            return LocalDate.of(date.getYear(), date.getMonth(), date.getDay());
        }
    }
}

