/*
 * Decompiled with CFR 0.152.
 */
package io.github.wycst.wast.common.expression;

import io.github.wycst.wast.common.expression.ElInvoker;
import io.github.wycst.wast.common.expression.ElVariableInvoker;
import io.github.wycst.wast.common.expression.ExpressionException;
import java.util.Map;

public class EvaluatorContext {
    public static final EvaluatorContext EMPTY = new EvaluatorContext();
    Object[] variableValues;
    StringBuilder builder;
    Object value;

    EvaluatorContext() {
    }

    public Object getContextValue(ElVariableInvoker variableInvoker) {
        try {
            return this.variableValues[variableInvoker.index];
        }
        catch (Throwable throwable) {
            throw new ExpressionException("Unresolved property or variable '" + variableInvoker + "' by context");
        }
    }

    public EvaluatorContext invokeVariables(ElInvoker invoke, Object context, int variableCount) {
        this.variableValues = variableCount < 10 ? new Object[10] : new Object[variableCount];
        invoke.invoke(context, this.variableValues);
        return this;
    }

    public EvaluatorContext invokeVariables(ElInvoker invoke, Map context, int variableCount) {
        this.variableValues = variableCount < 10 ? new Object[10] : new Object[variableCount];
        invoke.invoke(context, this.variableValues);
        return this;
    }

    final StringBuilder getStringBuilder() {
        if (this.builder == null) {
            this.builder = new StringBuilder();
        } else {
            this.builder.setLength(0);
        }
        return this.builder;
    }

    protected EvaluatorContext cloneContext() {
        return new EvaluatorContext();
    }

    static final class EvaluatorContextTwinsImpl
    extends EvaluatorContext {
        final ElVariableInvoker parent;
        final ElVariableInvoker one;
        final ElVariableInvoker other;
        Object oneValue;
        Object otherValue;

        EvaluatorContextTwinsImpl(ElVariableInvoker parent, ElVariableInvoker one, ElVariableInvoker other) {
            this.parent = parent;
            this.one = one;
            this.other = other;
        }

        @Override
        public Object getContextValue(ElVariableInvoker variableInvoker) {
            return variableInvoker == this.one ? this.oneValue : this.otherValue;
        }

        @Override
        public EvaluatorContextTwinsImpl invokeVariables(ElInvoker invoke, Object context, int variableCount) {
            Object parentContext = this.parent.invokeDirect(context);
            this.oneValue = this.one.invokeCurrent(context, parentContext);
            this.otherValue = this.other.invokeCurrent(context, parentContext);
            return this;
        }

        @Override
        public EvaluatorContextTwinsImpl invokeVariables(ElInvoker invoke, Map context, int variableCount) {
            Object parentContext = this.parent.invokeDirect(context);
            this.oneValue = this.one.invokeCurrent(context, parentContext);
            this.otherValue = this.other.invokeCurrent(context, parentContext);
            return this;
        }

        @Override
        protected EvaluatorContext cloneContext() {
            return new EvaluatorContextTwinsImpl(this.parent, this.one, this.other);
        }
    }

    static final class EvaluatorContextSibbingVariablesImpl
    extends EvaluatorContext {
        final ElVariableInvoker parent;

        EvaluatorContextSibbingVariablesImpl(ElVariableInvoker parent) {
            this.parent = parent;
        }

        @Override
        public EvaluatorContextSibbingVariablesImpl invokeVariables(ElInvoker invoke, Object context, int variableCount) {
            Object parentContext = this.parent.invokeDirect(context);
            this.variableValues = variableCount < 10 ? new Object[10] : new Object[variableCount];
            invoke.invokeCurrent(context, parentContext, this.variableValues);
            return this;
        }

        @Override
        public EvaluatorContextSibbingVariablesImpl invokeVariables(ElInvoker invoke, Map context, int variableCount) {
            Object parentContext = this.parent.invokeDirect(context);
            this.variableValues = variableCount < 10 ? new Object[10] : new Object[variableCount];
            invoke.invokeCurrent(context, parentContext, this.variableValues);
            return this;
        }

        @Override
        protected EvaluatorContext cloneContext() {
            return new EvaluatorContextSibbingVariablesImpl(this.parent);
        }
    }

    static final class EvaluatorContextSingleVariableImpl
    extends EvaluatorContext {
        Object variableValue;

        EvaluatorContextSingleVariableImpl() {
        }

        @Override
        public Object getContextValue(ElVariableInvoker variableInvoker) {
            return this.variableValue;
        }

        @Override
        public EvaluatorContextSingleVariableImpl invokeVariables(ElInvoker invoke, Object context, int variableCount) {
            this.variableValue = invoke.invokeDirect(context);
            return this;
        }

        @Override
        public EvaluatorContextSingleVariableImpl invokeVariables(ElInvoker invoke, Map context, int variableCount) {
            this.variableValue = invoke.invokeDirect(context);
            return this;
        }

        @Override
        protected EvaluatorContext cloneContext() {
            return new EvaluatorContextSingleVariableImpl();
        }
    }
}

