/*
 * Decompiled with CFR 0.152.
 */
package io.github.wycst.wast.common.expression;

import io.github.wycst.wast.common.expression.ElChainVariableInvoker;
import io.github.wycst.wast.common.expression.ElInvoker;
import io.github.wycst.wast.common.expression.ElOperator;
import io.github.wycst.wast.common.expression.ElVariableInvoker;
import io.github.wycst.wast.common.expression.ElVariableUtils;
import io.github.wycst.wast.common.expression.EvaluateEnvironment;
import io.github.wycst.wast.common.expression.EvaluatorContext;
import io.github.wycst.wast.common.expression.ExprEvaluator;
import io.github.wycst.wast.common.expression.ExprParserContext;
import io.github.wycst.wast.common.expression.Expression;
import io.github.wycst.wast.common.expression.ExpressionException;
import io.github.wycst.wast.common.utils.NumberUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;

public class ExprParser
extends Expression {
    public static final int GROUP_TOKEN_OPS = 1;
    public static final int GROUP_TOKEN_VALUE = 2;
    public static final int RESET_TOKEN = 1;
    public static final int OPS_TOKEN = 2;
    public static final int NEGATE_TOKEN = 5;
    public static final int NOT_TOKEN = 6;
    public static final int BRACKET_TOKEN = 9;
    public static final int NUM_TOKEN = 10;
    public static final int STR_TOKEN = 11;
    public static final int IDENTIFIER_TOKEN = 12;
    public static final int ARR_TOKEN = 13;
    public static final int FUN_TOKEN = 14;
    public static final int BRACKET_END_TOKEN = 20;
    static final int MAX_OPTIMIZE_COUNT = 2049;
    private String exprSource;
    private char[] sourceChars;
    private int offset;
    private int count;
    private int readIndex;
    private String errorMsg;
    private Map<String, ElVariableInvoker> invokes;
    private Map<String, ElVariableInvoker> tailInvokes;
    protected ElInvoker tailChainInvoker;
    protected int variableCount;
    protected EvaluatorContext evaluatorContext;
    private int prevTokenType;
    private int tokenType = 1;
    private ElOperator operator;
    private int bracketCount;
    private int evaluatorCount;
    private ExprEvaluator exprEvaluator = this.createExprEvaluator();
    private ExprParserContext parserContext = new ExprParserContext();
    private final AtomicInteger cntForCompress = new AtomicInteger(0);
    private boolean compressed = false;
    private static final ThreadLocal<List<String>> localVariableKeys = new ThreadLocal<List<String>>(){

        @Override
        protected List<String> initialValue() {
            return new ArrayList<String>();
        }
    };

    public ExprParser(String exprSource) {
        this.init(exprSource);
        this.parse();
    }

    ExprParser(char[] buffers, int offset, int count) {
        this.init(buffers, offset, count);
        this.parse();
    }

    protected ExprParser() {
    }

    protected ExprParser global() {
        return this;
    }

    protected Map<String, ElVariableInvoker> getInvokes() {
        return this.invokes;
    }

    protected Map<String, ElVariableInvoker> getTailInvokes() {
        return this.tailInvokes;
    }

    protected ExprEvaluator createExprEvaluator() {
        return new ExprEvaluator();
    }

    protected String getSource() {
        return this.exprSource;
    }

    public int length() {
        return this.count;
    }

    protected ExprEvaluator getEvaluator() {
        return this.exprEvaluator;
    }

    protected void init(String exprSource) {
        this.exprSource = exprSource;
        this.count = exprSource.length();
        this.sourceChars = ExprParser.getChars(exprSource);
    }

    protected void init(char[] buffers, int offset, int count) {
        this.sourceChars = buffers;
        this.offset = offset;
        this.count = count;
    }

    protected void parse() {
        this.parseEvaluator();
        this.displacement(this.exprEvaluator);
        this.merge();
        this.compressVariables();
        this.checkOptimizeRequired();
    }

    private void checkOptimizeRequired() {
        if (this.evaluatorCount > 2049) {
            this.optimize();
        }
    }

    private void parseEvaluator() {
        this.parserContext.setContext(this.exprEvaluator, false, false);
        do {
            this.parseNext(this.parserContext);
            ++this.evaluatorCount;
        } while (this.readable());
    }

    private void merge() {
        if (this.exprEvaluator.evalType == 0) {
            this.exprEvaluator = this.exprEvaluator.left;
        } else {
            ExprParser.mergeLast(this.exprEvaluator);
        }
    }

    static final void mergeLast(ExprEvaluator root) {
        ExprEvaluator rr = root.right;
        if (rr != null && rr.evalType == 0 && rr.left != null) {
            root.right = rr.left;
        }
    }

    final void displacement(ExprEvaluator exprEvaluator) {
        this.displacementChain(exprEvaluator);
        this.displacementChain(exprEvaluator);
    }

    private void displacementChain(ExprEvaluator exprEvaluator) {
        this.parserContext.exprEvaluator = exprEvaluator;
        do {
            this.displacementSplit(this.parserContext);
        } while (this.parserContext.exprEvaluator != null);
    }

    final void displacementSplit(ExprParserContext exprParserContext) {
        ExprEvaluator exprEvaluator = exprParserContext.exprEvaluator;
        if (exprEvaluator == null) {
            return;
        }
        ElOperator exprOperator = exprEvaluator.operator;
        int level = exprOperator.level;
        int evalType = exprEvaluator.getEvalType();
        ExprEvaluator left = exprEvaluator.getLeft();
        ExprEvaluator right = exprEvaluator.getRight();
        if (right == null) {
            exprParserContext.exprEvaluator = null;
            return;
        }
        if (exprOperator == ElOperator.COLON) {
            this.displacement(right);
            exprParserContext.exprEvaluator = null;
            return;
        }
        int rLevel = right.operator.level;
        if (rLevel <= 0) {
            exprParserContext.exprEvaluator = null;
            return;
        }
        if (level > rLevel) {
            this.mergeRight(right, level);
            rLevel = right.operator.level;
        }
        int rEvalType = right.getEvalType();
        ExprEvaluator rLeft = right.getLeft();
        ExprEvaluator rRight = right.getRight();
        if (level <= rLevel) {
            ExprEvaluator newLeft = this.createExprEvaluator();
            newLeft.setEvalType(evalType);
            newLeft.setOperator(exprOperator);
            newLeft.setNegate(exprEvaluator.negate);
            newLeft.setLogicalNot(exprEvaluator.logicalNot);
            newLeft.setLeft(left);
            newLeft.setRight(rLeft);
            exprEvaluator.setOperator(right.operator);
            exprEvaluator.setNegate(right.isNegate());
            exprEvaluator.setLogicalNot(right.logicalNot);
            exprEvaluator.setEvalType(rEvalType);
            exprEvaluator.setLeft(newLeft);
            exprEvaluator.setRight(rRight);
            exprParserContext.exprEvaluator = exprEvaluator;
        } else {
            if (rLevel == 1) {
                this.displacement(right.getRight().getLeft());
            }
            exprParserContext.exprEvaluator = right;
        }
    }

    final void mergeRight(ExprEvaluator exprEvaluator, int targetLevel) {
        if (exprEvaluator == null) {
            return;
        }
        int evalType = exprEvaluator.getEvalType();
        int level = exprEvaluator.operator.level;
        if (level >= targetLevel) {
            return;
        }
        ExprEvaluator left = exprEvaluator.getLeft();
        ExprEvaluator right = exprEvaluator.getRight();
        if (right == null) {
            return;
        }
        if (exprEvaluator.operator == ElOperator.COLON) {
            this.displacement(right);
            return;
        }
        int rLevel = right.operator.level;
        if (rLevel <= 0) {
            return;
        }
        int rEvalType = right.getEvalType();
        ExprEvaluator rLeft = right.getLeft();
        ExprEvaluator rRight = right.getRight();
        if (level <= rLevel) {
            ExprEvaluator newLeft = this.createExprEvaluator();
            newLeft.setEvalType(evalType);
            newLeft.setOperator(exprEvaluator.operator);
            newLeft.setNegate(exprEvaluator.negate);
            newLeft.setLogicalNot(exprEvaluator.logicalNot);
            newLeft.setLeft(left);
            newLeft.setRight(rLeft);
            exprEvaluator.setOperator(right.operator);
            exprEvaluator.setNegate(right.negate);
            exprEvaluator.setLogicalNot(right.logicalNot);
            exprEvaluator.setEvalType(rEvalType);
            exprEvaluator.setLeft(newLeft);
            exprEvaluator.setRight(rRight);
            this.mergeRight(exprEvaluator, targetLevel);
        }
    }

    protected void compressVariables() {
        if (this.tailInvokes != null) {
            this.variableCount = this.invokes.size();
            int index = 0;
            boolean sibbingMode = true;
            ElVariableInvoker tailParent = null;
            for (ElVariableInvoker variableInvoker : this.invokes.values()) {
                variableInvoker.setIndex(index++);
                if (!variableInvoker.isTail() || !sibbingMode) continue;
                if (variableInvoker.parent == null) {
                    sibbingMode = false;
                    continue;
                }
                if (tailParent == null) {
                    tailParent = variableInvoker.parent;
                    continue;
                }
                if (tailParent == variableInvoker.parent) continue;
                sibbingMode = false;
            }
            if (this.tailInvokes.size() == 1) {
                this.tailChainInvoker = this.tailInvokes.values().iterator().next();
                this.evaluatorContext = new EvaluatorContext.EvaluatorContextSingleVariableImpl();
            } else {
                this.tailChainInvoker = ElChainVariableInvoker.buildTailChainInvoker(this.tailInvokes);
                if (sibbingMode) {
                    if (this.tailChainInvoker.size() == 2) {
                        ElChainVariableInvoker chainVariableInvoker = (ElChainVariableInvoker)this.tailChainInvoker;
                        this.evaluatorContext = new EvaluatorContext.EvaluatorContextTwinsImpl(tailParent, chainVariableInvoker.variableInvoke, chainVariableInvoker.next.variableInvoke);
                    } else {
                        this.evaluatorContext = new EvaluatorContext.EvaluatorContextSibbingVariablesImpl(tailParent);
                    }
                } else {
                    this.evaluatorContext = new EvaluatorContext();
                }
            }
        }
    }

    public final Collection<ElVariableInvoker> getTailVariableInvokers() {
        return this.tailInvokes == null ? new ArrayList<ElVariableInvoker>() : new ArrayList<ElVariableInvoker>(this.tailInvokes.values());
    }

    @Override
    public final List<String> getVariables() {
        if (this.variableCount > 0) {
            return new ArrayList<String>(this.tailInvokes.keySet());
        }
        return new ArrayList<String>();
    }

    private void parseOpsToken(ExprParserContext exprParserContext) {
        ExprEvaluator evaluator = exprParserContext.exprEvaluator;
        boolean negate = exprParserContext.negate;
        boolean logicalNot = exprParserContext.logicalNot;
        evaluator.setEvalType(1);
        ExprEvaluator right = this.createExprEvaluator();
        if (this.operator == ElOperator.MINUS) {
            evaluator.setOperator(ElOperator.PLUS);
            negate = true;
        } else {
            evaluator.setOperator(this.operator);
        }
        evaluator.setRight(right);
        exprParserContext.setContext(right, negate, logicalNot);
    }

    private void parseVarToken(ExprParserContext exprParserContext, char startChar, String identifierValue, List<String> variableKeys) {
        ExprEvaluator evaluator = exprParserContext.exprEvaluator;
        boolean negate = exprParserContext.negate;
        boolean logicalNot = exprParserContext.logicalNot;
        switch (startChar) {
            case 't': {
                if (!"true".equals(identifierValue)) break;
                ExprEvaluator.ConstantImpl left = new ExprEvaluator.ConstantImpl(!logicalNot);
                evaluator.setLeft(left);
                exprParserContext.setContext(evaluator, false, false);
                return;
            }
            case 'f': {
                if (!"false".equals(identifierValue)) break;
                ExprEvaluator.ConstantImpl left = new ExprEvaluator.ConstantImpl(logicalNot);
                evaluator.setLeft(left);
                exprParserContext.setContext(evaluator, false, false);
                return;
            }
            case 'n': {
                if (!"null".equals(identifierValue)) break;
                ExprEvaluator.ConstantImpl left = new ExprEvaluator.ConstantImpl(null);
                evaluator.setLeft(left);
                exprParserContext.setContext(evaluator, false, false);
                return;
            }
        }
        this.checkInitializedInvokes();
        ExprEvaluator.VariableImpl left = new ExprEvaluator.VariableImpl();
        left.setNegate(negate);
        left.setLogicalNot(logicalNot);
        left.setVariableInvoker(identifierValue == null ? ElVariableUtils.build(variableKeys, this.getInvokes(), this.getTailInvokes()) : ElVariableUtils.buildRoot(identifierValue, this.getInvokes(), this.getTailInvokes()));
        evaluator.setLeft(left);
        exprParserContext.setContext(evaluator, false, false);
    }

    void checkInitializedInvokes() {
        if (this.invokes == null) {
            this.invokes = new HashMap<String, ElVariableInvoker>();
            this.tailInvokes = new HashMap<String, ElVariableInvoker>();
        }
    }

    static final void parseNumToken(ExprParserContext exprParserContext, Number numberValue) {
        ExprEvaluator evaluator = exprParserContext.exprEvaluator;
        ExprEvaluator.ConstantImpl left = new ExprEvaluator.ConstantImpl(numberValue);
        evaluator.setLeft(left);
        exprParserContext.setContext(evaluator, false, false);
    }

    final void parseBracketToken(ExprParserContext exprParserContext) {
        ExprEvaluator evaluator = exprParserContext.exprEvaluator;
        boolean negate = exprParserContext.negate;
        boolean logicalNot = exprParserContext.logicalNot;
        ExprEvaluator bracketChild = this.createExprEvaluator();
        ExprParserContext bracketParserContext = new ExprParserContext(bracketChild, false, false);
        do {
            this.parseNext(bracketParserContext);
        } while (this.readable() && !bracketParserContext.endFlag);
        if (!bracketParserContext.endFlag) {
            String errorMessage = ExprParser.createErrorContextText(this.sourceChars, this.readIndex);
            throw new ExpressionException("syntax error, pos: " + this.readIndex + ",Expression[ " + errorMessage + " ], missing closing symbol')'");
        }
        this.displacementChain(bracketChild);
        ExprParser.mergeLast(bracketChild);
        ExprEvaluator bracketEvaluator = this.createExprEvaluator();
        bracketEvaluator.negate(negate).setLogicalNot(logicalNot);
        bracketEvaluator.setEvalType(4);
        bracketEvaluator.setOperator(ElOperator.BRACKET);
        bracketEvaluator.setRight(bracketChild);
        evaluator.setLeft(bracketEvaluator);
        exprParserContext.setContext(evaluator, false, false);
    }

    static final void parseStrToken(ExprParserContext exprParserContext, String strValue) {
        ExprEvaluator evaluator = exprParserContext.exprEvaluator;
        boolean negate = exprParserContext.negate;
        boolean logicalNot = exprParserContext.logicalNot;
        ExprEvaluator.ConstantImpl left = new ExprEvaluator.ConstantImpl(strValue);
        left.setNegate(negate);
        left.setLogicalNot(logicalNot);
        evaluator.setLeft(left);
        exprParserContext.setContext(evaluator, false, false);
    }

    final void parseArrToken(ExprParserContext exprParserContext, String arrStr) {
        ExprEvaluator evaluator = exprParserContext.exprEvaluator;
        boolean negate = exprParserContext.negate;
        boolean logicalNot = exprParserContext.logicalNot;
        ExprEvaluator left = this.createExprEvaluator();
        left.setNegate(negate);
        left.setLogicalNot(logicalNot);
        left.setArrayValue(arrStr);
        evaluator.setLeft(left);
        exprParserContext.setContext(evaluator, false, false);
    }

    final void parseFunToken(ExprParserContext exprParserContext, String functionName, String args) {
        ExprEvaluator evaluator = exprParserContext.exprEvaluator;
        boolean negate = exprParserContext.negate;
        boolean logicalNot = exprParserContext.logicalNot;
        ExprEvaluator.FunctionImpl left = new ExprEvaluator.FunctionImpl();
        left.setNegate(negate);
        left.setLogicalNot(logicalNot);
        left.setFunction(functionName, args, this.global());
        evaluator.setLeft(left);
        exprParserContext.setContext(evaluator, false, false);
    }

    final void parseMethodToken(ExprParserContext exprParserContext, List<String> variableKeys, String methodName, String args) {
        ExprEvaluator evaluator = exprParserContext.exprEvaluator;
        boolean negate = exprParserContext.negate;
        boolean logicalNot = exprParserContext.logicalNot;
        this.checkInitializedInvokes();
        ExprEvaluator.MethodImpl left = new ExprEvaluator.MethodImpl();
        left.setNegate(negate);
        left.setLogicalNot(logicalNot);
        left.setMethod(ElVariableUtils.build(variableKeys, this.getInvokes(), this.getTailInvokes()), methodName, args, this.global());
        evaluator.setLeft(left);
        exprParserContext.setContext(evaluator, false, false);
    }

    static final void parseNegateToken(ExprParserContext exprParserContext) {
        boolean negate = exprParserContext.negate;
        exprParserContext.negate = !negate;
    }

    static final void parseNotToken(ExprParserContext exprParserContext) {
        boolean logicalNot = exprParserContext.logicalNot;
        exprParserContext.logicalNot = !logicalNot;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private void parseNext(ExprParserContext exprParserContext) {
        block121: {
            block124: {
                block122: {
                    block126: {
                        block125: {
                            block123: {
                                this.resetToken();
                                while (this.readable() && ExprParser.isWhitespace(this.read())) {
                                    ++this.readIndex;
                                }
                                if (!this.readable()) {
                                    return;
                                }
                                currentChar = this.read();
                                isMinusSymbol = false;
                                if ((ExprParser.isDigit(currentChar) || (isMinusSymbol = currentChar == '-')) && ExprParser.isNotGroupTokenValue(this.prevTokenType)) {
                                    cnt = 0;
                                    readIndex = ++this.readIndex;
                                    numberRadix = 10;
                                    firstDigitChar = '\u0000';
                                    secondeDigitChar = '\u0000';
                                    if (isMinusSymbol) {
                                        if (readIndex + 1 < this.length()) {
                                            firstDigitChar = this.read(readIndex++);
                                            secondeDigitChar = this.read(readIndex++);
                                        }
                                    } else {
                                        firstDigitChar = currentChar;
                                        if (readIndex < this.length()) {
                                            secondeDigitChar = this.read(readIndex++);
                                        }
                                    }
                                    decimalVal = 0L;
                                    valInitSet = false;
                                    hexOrOctVal = 0L;
                                    if (firstDigitChar == '0') {
                                        if (secondeDigitChar == 'x' || secondeDigitChar == 'X') {
                                            numberRadix = 16;
                                            this.readIndex = readIndex;
                                            ++cnt;
                                            while (this.readable() && (val = ExprParser.digit(currentChar = this.read(), 16)) != -1) {
                                                hexOrOctVal = hexOrOctVal << 4 | (long)val;
                                                ++this.readIndex;
                                                ++cnt;
                                            }
                                            if (currentChar == 'l' || currentChar == 'L') {
                                                ++this.readIndex;
                                            }
                                        } else if (Character.isDigit(secondeDigitChar)) {
                                            numberRadix = 8;
                                            this.readIndex = readIndex;
                                            hexOrOctVal = ExprParser.digit(secondeDigitChar, 8);
                                            ++cnt;
                                            while (this.readable() && (val = ExprParser.digit(currentChar = this.read(), 8)) != -1) {
                                                hexOrOctVal = hexOrOctVal << 3 | (long)val;
                                                ++this.readIndex;
                                                ++cnt;
                                            }
                                            switch (currentChar) {
                                                case '.': 
                                                case 'D': 
                                                case 'E': 
                                                case 'F': 
                                                case 'd': 
                                                case 'e': 
                                                case 'f': {
                                                    numberRadix = 10;
                                                    decimalVal = hexOrOctVal;
                                                    valInitSet = true;
                                                    break;
                                                }
                                                case 'L': 
                                                case 'l': {
                                                    ++this.readIndex;
                                                }
                                            }
                                        }
                                    }
                                    mode = 0;
                                    specifySuffix = 0;
                                    expValue = 0;
                                    expNegative = false;
                                    decimalCount = 0;
                                    if (numberRadix == 10) {
                                        if (!isMinusSymbol && !valInitSet) {
                                            ++cnt;
                                            decimalVal = currentChar - 48;
                                        }
                                        while (this.readable() && ExprParser.isDigit(currentChar = this.read())) {
                                            decimalVal = decimalVal * 10L + (long)(currentChar - 48);
                                            ++this.readIndex;
                                            ++cnt;
                                        }
                                        if (currentChar == '.') {
                                            ++this.readIndex;
                                            mode = 1;
                                            while (this.readable() && ExprParser.isDigit(currentChar = this.read())) {
                                                decimalVal = decimalVal * 10L + (long)currentChar - 48L;
                                                ++decimalCount;
                                                ++cnt;
                                                ++this.readIndex;
                                            }
                                        }
                                        if (currentChar == 'E' || currentChar == 'e') {
                                            mode = 2;
                                            ++this.readIndex;
                                            currentChar = this.read();
                                            expNegative = currentChar == '-';
                                            if (expNegative || currentChar == '+') {
                                                ++this.readIndex;
                                                currentChar = this.read();
                                            }
                                            if (ExprParser.isDigit(currentChar)) {
                                                expValue = currentChar - 48;
                                                ++this.readIndex;
                                                while (this.readable() && ExprParser.isDigit(currentChar = this.read())) {
                                                    expValue = (expValue << 3) + (expValue << 1) + currentChar - 48;
                                                    ++this.readIndex;
                                                }
                                            }
                                        }
                                        switch (currentChar) {
                                            case 'L': 
                                            case 'l': {
                                                specifySuffix = 1;
                                                ++this.readIndex;
                                                break;
                                            }
                                            case 'F': 
                                            case 'f': {
                                                specifySuffix = 2;
                                                ++this.readIndex;
                                                break;
                                            }
                                            case 'D': 
                                            case 'd': {
                                                specifySuffix = 3;
                                                ++this.readIndex;
                                            }
                                        }
                                        value = decimalVal;
                                    } else {
                                        value = hexOrOctVal;
                                        decimalVal = hexOrOctVal;
                                    }
                                    if (cnt == 0 && isMinusSymbol) {
                                        switch (this.prevTokenType) {
                                            case 1: 
                                            case 2: 
                                            case 9: {
                                                this.tokenType = 5;
                                                this.checkTokenSyntaxError();
                                                ExprParser.parseNegateToken(exprParserContext);
                                                return;
                                            }
                                        }
                                        this.tokenType = 2;
                                        this.operator = ElOperator.MINUS;
                                        this.checkTokenSyntaxError();
                                        this.parseOpsToken(exprParserContext);
                                        return;
                                    }
                                    this.tokenType = 10;
                                    if (mode == 0) {
                                        if (exprParserContext.negate ^ isMinusSymbol) {
                                            value = -value;
                                        }
                                        numberValue /* !! */  = specifySuffix == 0 ? (value >= -9.223372036854776E18 && value <= 9.223372036854776E18 ? Long.valueOf((long)value) : Double.valueOf(value)) : (specifySuffix == 1 ? Long.valueOf((long)value) : (specifySuffix == 2 ? Float.valueOf((float)value) : Double.valueOf(value)));
                                    } else {
                                        expValue = expNegative != false ? -expValue - decimalCount : expValue - decimalCount;
                                        value = NumberUtils.scientificToIEEEDouble(decimalVal, -expValue);
                                        if (exprParserContext.negate ^ isMinusSymbol) {
                                            value = -value;
                                        }
                                        numberValue /* !! */  = specifySuffix == 0 ? Double.valueOf(value) : (specifySuffix == 1 ? Long.valueOf((long)value) : (specifySuffix == 2 ? Float.valueOf((float)value) : Double.valueOf(value)));
                                    }
                                    this.checkTokenSyntaxError();
                                    ExprParser.parseNumToken(exprParserContext, numberValue /* !! */ );
                                    return;
                                }
                                if (this.prevTokenType <= 2 || (elOperator = this.getOperator(currentChar)) == null) break block121;
                                firstMatchChar = currentChar;
                                ++this.readIndex;
                                this.tokenType = 2;
                                if (!this.readable() || ExprParser.isWhitespace(currentChar = this.read())) break block122;
                                if (currentChar != '*' || elOperator != ElOperator.MULTI) break block123;
                                this.operator = ElOperator.EXP;
                                ++this.readIndex;
                                break block124;
                            }
                            if (elOperator != ElOperator.AND) break block125;
                            if (currentChar == '&') {
                                ++this.readIndex;
                                this.operator = ElOperator.LOGICAL_AND;
                            } else {
                                this.errorMsg = String.valueOf(firstMatchChar) + currentChar;
                                this.throwOperationNotSupported();
                            }
                            break block124;
                        }
                        if (elOperator != ElOperator.OR) break block126;
                        if (currentChar == '|') {
                            ++this.readIndex;
                            this.operator = ElOperator.LOGICAL_OR;
                        } else {
                            this.errorMsg = String.valueOf(firstMatchChar) + currentChar;
                            this.throwOperationNotSupported();
                        }
                        break block124;
                    }
                    if (elOperator != ElOperator.NOT) ** GOTO lbl182
                    if (currentChar == '=') {
                        ++this.readIndex;
                        this.operator = ElOperator.NE;
                    } else {
                        if (currentChar == '!') {
                            this.tokenType = 6;
                            this.checkTokenSyntaxError();
                            ExprParser.parseNotToken(exprParserContext);
                            return;
                        }
                        if (this.getOperator(currentChar) != null) {
                            this.errorMsg = String.valueOf(firstMatchChar) + currentChar;
                            this.throwOperationNotSupported();
                        }
                        this.tokenType = 6;
                        this.checkTokenSyntaxError();
                        ExprParser.parseNotToken(exprParserContext);
                        return;
lbl182:
                        // 1 sources

                        if (elOperator == ElOperator.GT) {
                            if (currentChar == '>') {
                                ++this.readIndex;
                                this.operator = ElOperator.BIT_RIGHT;
                            } else if (currentChar == '=') {
                                ++this.readIndex;
                                this.operator = ElOperator.GE;
                            } else if (this.getOperator(currentChar) != null) {
                                this.errorMsg = String.valueOf(firstMatchChar) + currentChar;
                                this.throwOperationNotSupported();
                            }
                        } else if (elOperator == ElOperator.LT) {
                            if (currentChar == '<') {
                                ++this.readIndex;
                                this.operator = ElOperator.BIT_LEFT;
                            } else if (currentChar == '=') {
                                ++this.readIndex;
                                this.operator = ElOperator.LE;
                            } else if (this.getOperator(currentChar) != null) {
                                this.errorMsg = String.valueOf(firstMatchChar) + currentChar;
                                this.throwOperationNotSupported();
                            }
                        } else if (elOperator == ElOperator.EQ) {
                            if (currentChar == '=') {
                                ++this.readIndex;
                                this.operator = ElOperator.EQ;
                            } else {
                                this.errorMsg = String.valueOf(firstMatchChar) + currentChar;
                                this.throwOperationNotSupported();
                            }
                        }
                    }
                    break block124;
                }
                if (elOperator == ElOperator.EQ) {
                    this.errorMsg = String.valueOf(firstMatchChar);
                    this.throwOperationNotSupported();
                }
            }
            this.checkTokenSyntaxError();
            this.parseOpsToken(exprParserContext);
            return;
        }
        if (this.isBracketSymbol(currentChar)) {
            this.operator = ElOperator.BRACKET;
            ++this.readIndex;
            if (currentChar == '(') {
                this.tokenType = 9;
                ++this.bracketCount;
                this.checkBeforeBracketTokenSyntaxError();
                this.parseBracketToken(exprParserContext);
            } else {
                --this.bracketCount;
                this.tokenType = 20;
                if (this.bracketCount < 0) {
                    this.errorMsg = ")";
                    this.throwOperationNotSupported();
                }
                this.checkBeforeBracketEndTokenSyntaxError();
                exprParserContext.endFlag = true;
            }
        } else {
            if (ExprParser.isIdentifierStart(currentChar)) {
                start = this.readIndex++;
                startChar = currentChar;
                localOffset = start;
                variableKeys = this.getLocalVariableKeys();
                try {
                    while (this.readable() && ExprParser.isVariableAppend(currentChar = this.read())) {
                        if (currentChar == '.') {
                            if (this.readIndex == localOffset) {
                                errorMessage = ExprParser.createErrorContextText(this.sourceChars, this.readIndex);
                                throw new ExpressionException("syntax error, pos: " + this.readIndex + ", Expression[ " + errorMessage + " ],token ''' is duplicate or conflict with [] ");
                            }
                            variableKeys.add(new String(this.sourceChars, localOffset + this.offset, this.readIndex - localOffset));
                            localOffset = ++this.readIndex;
                            continue;
                        }
                        if (currentChar == '[') {
                            if (this.readIndex == localOffset) {
                                errorMessage = ExprParser.createErrorContextText(this.sourceChars, this.readIndex);
                                throw new ExpressionException("syntax error, pos: " + this.readIndex + ", Expression[ " + errorMessage + " ],token '[' is duplicate or conflict with '.' ");
                            }
                            variableKeys.add(new String(this.sourceChars, localOffset + this.offset, this.readIndex - localOffset));
                            localOffset = ++this.readIndex;
                            cnt = 1;
                            stringKey = true;
                            while (this.readable()) {
                                currentChar = this.read();
                                if (currentChar <= ' ') {
                                    ++this.readIndex;
                                    continue;
                                }
                                if (currentChar == '\'') {
                                    this.scanString();
                                    ++this.readIndex;
                                    while (this.readable() && (currentChar = this.read()) <= ' ') {
                                        ++this.readIndex;
                                    }
                                    if (currentChar != ']' || cnt != 1) continue;
                                    break;
                                }
                                stringKey = false;
                                if (currentChar == ']') {
                                    --cnt;
                                } else if (currentChar == '[') {
                                    ++cnt;
                                }
                                if (cnt == 0) break;
                                ++this.readIndex;
                            }
                            if (currentChar != ']') {
                                errorMessage = ExprParser.createErrorContextText(this.sourceChars, this.readIndex);
                                throw new ExpressionException("syntax error, pos: " + this.readIndex + ", Expression[ " + errorMessage + " ],\u672a\u627e\u5230\u4e0e\u5f00\u59cb\u5b57\u7b26'['\u76f8\u5339\u914d\u7684\u7ed3\u675f\u5b57\u7b26 ']'");
                            }
                            if (stringKey) {
                                et = this.readIndex + this.offset;
                                for (st = localOffset + this.offset; st < et && this.sourceChars[st] <= ' '; ++st) {
                                }
                                while (st < et && this.sourceChars[et - 1] <= ' ') {
                                    --et;
                                }
                                variableKeys.add(new String(this.sourceChars, st + 1, et - st - 2));
                            } else {
                                chars = new char[this.readIndex - localOffset + 2];
                                chars[0] = 40;
                                chars[chars.length - 1] = 41;
                                System.arraycopy(this.sourceChars, localOffset + this.offset, chars, 1, chars.length - 2);
                                variableKeys.add(new String(chars));
                            }
                            localOffset = ++this.readIndex;
                            continue;
                        }
                        ++this.readIndex;
                    }
                    identifierValue = new String(this.sourceChars, localOffset + this.offset, this.readIndex - localOffset);
                    v0 = oneLevelAccess = localOffset == start;
                    if (currentChar == '(') {
                        localOffset = ++this.readIndex;
                        bracketCount = 1;
                        while (this.readable()) {
                            currentChar = this.read();
                            if (currentChar == '\'') {
                                this.scanString();
                                ++this.readIndex;
                                continue;
                            }
                            ++this.readIndex;
                            if (currentChar == ')') {
                                --bracketCount;
                            } else if (currentChar == '(') {
                                ++bracketCount;
                            }
                            if (bracketCount != 0) continue;
                        }
                        if (currentChar != ')') {
                            errorMessage = ExprParser.createErrorContextText(this.sourceChars, this.readIndex);
                            throw new ExpressionException("syntax error, pos: " + this.readIndex + ",Expression[ " + errorMessage + " ], end token ')' not found !");
                        }
                        args = new String(this.sourceChars, localOffset + this.offset, this.readIndex - localOffset - 1);
                        if (oneLevelAccess) {
                            this.tokenType = 14;
                            this.checkTokenSyntaxError();
                            this.parseFunToken(exprParserContext, identifierValue, args);
                        } else {
                            this.tokenType = 14;
                            this.checkTokenSyntaxError();
                            this.parseMethodToken(exprParserContext, variableKeys, identifierValue, args);
                        }
                    } else {
                        if (localOffset > start && this.readIndex > localOffset) {
                            variableKeys.add(identifierValue);
                        }
                        this.tokenType = 12;
                        this.checkTokenSyntaxError();
                        this.parseVarToken(exprParserContext, startChar, oneLevelAccess != false ? identifierValue : null, variableKeys);
                    }
                }
                finally {
                    variableKeys.clear();
                }
                return;
            }
            if (currentChar == '!') {
                ++this.readIndex;
                this.tokenType = 6;
                ExprParser.parseNotToken(exprParserContext);
                return;
            }
            if (currentChar == '\'') {
                start = this.readIndex + 1;
                this.scanString();
                this.tokenType = 11;
                this.checkTokenSyntaxError();
                ExprParser.parseStrToken(exprParserContext, new String(this.sourceChars, this.offset + start, this.readIndex - start));
                ++this.readIndex;
                return;
            }
            if (currentChar == '{') {
                start = ++this.readIndex;
                while (this.readable() && (currentChar = this.read()) != '}') {
                    ++this.readIndex;
                    if (this.readIndex < this.length()) continue;
                }
                if (currentChar != '}') {
                    errorMessage = ExprParser.createErrorContextText(this.sourceChars, this.readIndex);
                    throw new ExpressionException("syntax error, pos: " + this.readIndex + ", Expression[ " + errorMessage + " ],\u672a\u627e\u5230\u4e0e\u5f00\u59cb\u5b57\u7b26'{'\u76f8\u5339\u914d\u7684\u7ed3\u675f\u5b57\u7b26 '}'");
                }
                this.tokenType = 13;
                this.checkTokenSyntaxError();
                this.parseArrToken(exprParserContext, new String(this.sourceChars, start + this.offset, this.readIndex - start));
                ++this.readIndex;
                return;
            }
            if (currentChar == '@') {
                ++this.readIndex;
                start = this.readIndex++;
                if (this.readable() && !Character.isJavaIdentifierStart(currentChar = this.read())) {
                    errorMessage = ExprParser.createErrorContextText(this.sourceChars, this.readIndex);
                    throw new ExpressionException("syntax error, pos: " + this.readIndex + ", Expression[ " + errorMessage + " ], unexpected function start char  : '" + currentChar + "'");
                }
                while (this.readable() && ExprParser.isIdentifierAppend(currentChar = this.read())) {
                    ++this.readIndex;
                    if (this.readIndex < this.length()) continue;
                }
                while (this.readable() && ExprParser.isWhitespace(currentChar = this.read())) {
                    ++this.readIndex;
                }
                if (currentChar != '(') {
                    readSource = new String(this.exprSource.substring(0, this.readIndex));
                    throw new ExpressionException("syntax error, pos: " + this.readIndex + ", source: '" + readSource + "' function start symbol '(' not found !");
                }
                functionName = new String(this.sourceChars, start + this.offset, this.readIndex - start);
                start = ++this.readIndex;
                bracketCount = 1;
                while (this.readable()) {
                    currentChar = this.read();
                    if (currentChar == '\'') {
                        this.scanString();
                        ++this.readIndex;
                        continue;
                    }
                    ++this.readIndex;
                    if (currentChar == ')') {
                        --bracketCount;
                    } else if (currentChar == '(') {
                        ++bracketCount;
                    }
                    if (bracketCount != 0) continue;
                }
                args = new String(this.sourceChars, start + this.offset, this.readIndex - start - 1);
                this.tokenType = 14;
                this.checkTokenSyntaxError();
                this.parseFunToken(exprParserContext, functionName, args);
                return;
            }
            if (this.prevTokenType == 1 && currentChar == '+') {
                ++this.readIndex;
                this.tokenType = 2;
                return;
            }
            errorMessage = ExprParser.createErrorContextText(this.sourceChars, this.readIndex);
            throw new ExpressionException("syntax error, pos: " + this.readIndex + ", unexpected token '" + currentChar + "', Expression[ " + errorMessage + " ]");
        }
    }

    protected List<String> getLocalVariableKeys() {
        return localVariableKeys.get();
    }

    private void scanString() {
        int currentChar = 0;
        ++this.readIndex;
        int prevCh = 0;
        while (this.readable()) {
            char c = this.read();
            currentChar = c;
            if (c == '\'' && prevCh != 92) break;
            ++this.readIndex;
            prevCh = currentChar;
        }
        if (currentChar != 39 || prevCh == 92) {
            String errorMessage = ExprParser.createErrorContextText(this.sourceChars, this.readIndex);
            throw new ExpressionException("syntax error, pos: " + this.readIndex + ", Expression[ " + errorMessage + " ],\u672a\u627e\u5230\u4e0e\u5f00\u59cb\u5b57\u7b26'''\u76f8\u5339\u914d\u7684\u7ed3\u675f\u5b57\u7b26 '''");
        }
    }

    final boolean readable() {
        return this.readIndex < this.count;
    }

    final char read() {
        return this.sourceChars[this.offset + this.readIndex];
    }

    final char read(int index) {
        return this.sourceChars[this.offset + index];
    }

    static final int getTokenTypeGroup(int tokenType) {
        switch (tokenType) {
            case 2: {
                return 1;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                return 2;
            }
        }
        return 0;
    }

    static final boolean isNotGroupTokenValue(int tokenType) {
        return tokenType < 10;
    }

    private void checkTokenSyntaxError() {
        int groupValue;
        int preGroupValue = ExprParser.getTokenTypeGroup(this.prevTokenType);
        if (preGroupValue == (groupValue = ExprParser.getTokenTypeGroup(this.tokenType))) {
            if (preGroupValue == 1) {
                String readSource = ExprParser.createErrorContextText(this.sourceChars, this.readIndex);
                throw new ExpressionException("syntax error, pos: " + this.readIndex + ", duplicate token operation, Expression[" + readSource + "]");
            }
            if (preGroupValue == 2) {
                String readSource = ExprParser.createErrorContextText(this.sourceChars, this.readIndex);
                throw new ExpressionException("syntax error, pos: " + this.readIndex + ", missing operation symbol between values, Expression[" + readSource + "]");
            }
        } else {
            if (groupValue == 2 && this.prevTokenType == 20) {
                String readSource = ExprParser.createErrorContextText(this.sourceChars, this.readIndex);
                throw new ExpressionException("syntax error, pos: " + this.readIndex + ", value cannot appear after the closing bracket, Expression[" + readSource + "]");
            }
            if (groupValue == 1 && this.prevTokenType == 9) {
                String readSource = ExprParser.createErrorContextText(this.sourceChars, this.readIndex);
                throw new ExpressionException("syntax error, pos: " + this.readIndex + ", unsupported operation symbols follow '(' , Expression[" + readSource + "]");
            }
        }
    }

    private void checkBeforeBracketEndTokenSyntaxError() {
        int preGroupValue = ExprParser.getTokenTypeGroup(this.prevTokenType);
        if (this.prevTokenType == 9 || preGroupValue == 1) {
            String readSource = ExprParser.createErrorContextText(this.sourceChars, this.readIndex);
            throw new ExpressionException("syntax error, pos: " + this.readIndex + ",unexpected symbol : '" + this.errorMsg + "', Expression[" + readSource + "]");
        }
    }

    private void checkBeforeBracketTokenSyntaxError() {
        int preGroupValue = ExprParser.getTokenTypeGroup(this.prevTokenType);
        if (this.prevTokenType == 20 && preGroupValue == 2) {
            String readSource = ExprParser.createErrorContextText(this.sourceChars, this.readIndex);
            throw new ExpressionException("syntax error, pos: " + this.readIndex + ",unexpected symbol : '" + this.errorMsg + "', Expression[" + readSource + "]");
        }
    }

    private void throwOperationNotSupported() {
        String readSource = ExprParser.createErrorContextText(this.sourceChars, this.readIndex);
        throw new ExpressionException("syntax error, pos: " + this.readIndex + ", unexpected symbol '" + this.errorMsg + "', Expression[" + readSource + "]");
    }

    static final boolean isWhitespace(char c) {
        return c <= ' ';
    }

    static final boolean isIdentifierStart(char c) {
        return c == '_' || c == '$' || Character.isLetter(c);
    }

    static final boolean isIdentifierAppend(char c) {
        return c == '_' || c == '$' || c == '.' || Character.isLetter(c) || ExprParser.isDigit(c);
    }

    static final boolean isVariableAppend(char c) {
        if (Character.isLetter(c)) {
            return true;
        }
        if (c <= ' ') {
            return false;
        }
        return c == '.' || c == '_' || c == '$' || ExprParser.isDigit(c) || c == '[';
    }

    static final int digit(char c, int numberRadix) {
        switch (c) {
            case '0': 
            case '1': 
            case '2': 
            case '3': 
            case '4': 
            case '5': 
            case '6': 
            case '7': 
            case '8': 
            case '9': {
                return c - 48;
            }
        }
        if (numberRadix == 16) {
            if (c >= 'a' && c <= 'f') {
                return c - 87;
            }
            if (c >= 'A' && c <= 'F') {
                return c - 55;
            }
        }
        return -1;
    }

    static final boolean isDigit(char c) {
        switch (c) {
            case '0': 
            case '1': 
            case '2': 
            case '3': 
            case '4': 
            case '5': 
            case '6': 
            case '7': 
            case '8': 
            case '9': {
                return true;
            }
        }
        return false;
    }

    private void resetToken() {
        this.prevTokenType = this.tokenType;
        this.tokenType = 1;
        this.operator = ElOperator.NONE;
    }

    private ElOperator getOperator(char symbol) {
        switch (symbol) {
            case '*': {
                this.operator = ElOperator.MULTI;
                return this.operator;
            }
            case '/': {
                this.operator = ElOperator.DIVISION;
                return this.operator;
            }
            case '%': {
                this.operator = ElOperator.MOD;
                return this.operator;
            }
            case '+': {
                this.operator = ElOperator.PLUS;
                return this.operator;
            }
            case '-': {
                this.operator = ElOperator.MINUS;
                return this.operator;
            }
            case '&': {
                this.operator = ElOperator.AND;
                return this.operator;
            }
            case '^': {
                this.operator = ElOperator.XOR;
                return this.operator;
            }
            case '|': {
                this.operator = ElOperator.OR;
                return this.operator;
            }
            case '!': {
                this.operator = ElOperator.NOT;
                return this.operator;
            }
            case '>': {
                this.operator = ElOperator.GT;
                return this.operator;
            }
            case '<': {
                this.operator = ElOperator.LT;
                return this.operator;
            }
            case '=': {
                this.operator = ElOperator.EQ;
                return this.operator;
            }
            case ':': {
                this.operator = ElOperator.COLON;
                return this.operator;
            }
            case '?': {
                this.operator = ElOperator.QUESTION;
                return this.operator;
            }
        }
        this.operator = null;
        return null;
    }

    final boolean isBracketSymbol(char c) {
        return c == '(' || c == ')';
    }

    @Override
    public Object evaluate() {
        return this.exprEvaluator.evaluate(EvaluatorContext.EMPTY, EvaluateEnvironment.DEFAULT);
    }

    @Override
    public Object evaluate(Object context) {
        if (context instanceof EvaluateEnvironment) {
            return this.evaluate((EvaluateEnvironment)context);
        }
        if (context instanceof Map) {
            return this.evaluate((Map)context);
        }
        return this.doEvaluate(this.variableCount == 0 ? EvaluatorContext.EMPTY : this.evaluatorContext.cloneContext().invokeVariables(this.tailChainInvoker, context, this.variableCount), EvaluateEnvironment.DEFAULT);
    }

    @Override
    public final Object evaluate(Map context) {
        return this.doEvaluate(this.variableCount == 0 ? EvaluatorContext.EMPTY : this.evaluatorContext.cloneContext().invokeVariables(this.tailChainInvoker, context, this.variableCount), EvaluateEnvironment.DEFAULT);
    }

    @Override
    public Object evaluate(Map context, EvaluateEnvironment evaluateEnvironment) {
        return this.doEvaluate(this.variableCount == 0 ? EvaluatorContext.EMPTY : this.evaluatorContext.cloneContext().invokeVariables(this.tailChainInvoker, context, this.variableCount), evaluateEnvironment);
    }

    @Override
    public Object evaluate(Object context, EvaluateEnvironment evaluateEnvironment) {
        return this.doEvaluate(this.variableCount == 0 ? EvaluatorContext.EMPTY : this.evaluatorContext.cloneContext().invokeVariables(this.tailChainInvoker, context, this.variableCount), evaluateEnvironment);
    }

    @Override
    public final Object evaluate(EvaluateEnvironment evaluateEnvironment) {
        if (this.variableCount == 0 || evaluateEnvironment == null) {
            return this.exprEvaluator.evaluate(EvaluatorContext.EMPTY, evaluateEnvironment);
        }
        if (evaluateEnvironment.isMapContext()) {
            return this.doEvaluate(this.evaluatorContext.cloneContext().invokeVariables(this.tailChainInvoker, (Map)evaluateEnvironment.getContext(), this.variableCount), evaluateEnvironment);
        }
        return this.doEvaluate(this.evaluatorContext.cloneContext().invokeVariables(this.tailChainInvoker, evaluateEnvironment.getContext(), this.variableCount), evaluateEnvironment);
    }

    final Object doEvaluate(EvaluatorContext evaluatorContext, EvaluateEnvironment evaluateEnvironment) {
        Object result = this.exprEvaluator.evaluate(evaluatorContext, evaluateEnvironment);
        if (!this.compressed && this.cntForCompress.getAndIncrement() == 1) {
            this.compressEvaluator();
        }
        return result;
    }

    protected final void compressEvaluator() {
        this.exprEvaluator = ExprParser.compressEvaluator(this.exprEvaluator);
        this.compressed = true;
    }

    private static ExprEvaluator compressEvaluator(ExprEvaluator exprEvaluator) {
        if (exprEvaluator.constant) {
            if (exprEvaluator instanceof ExprEvaluator.ConstantImpl) {
                return exprEvaluator;
            }
            return new ExprEvaluator.ConstantImpl(exprEvaluator.result);
        }
        if (exprEvaluator instanceof ExprEvaluator.StackSplitImpl) {
            ExprEvaluator.StackSplitImpl stackSplit = (ExprEvaluator.StackSplitImpl)exprEvaluator;
            stackSplit.front = ExprParser.compressEvaluator(stackSplit.front);
            stackSplit.left = ExprParser.compressEvaluator(stackSplit.left);
            return stackSplit;
        }
        if (exprEvaluator instanceof ExprEvaluator.ContextValueHolderImpl) {
            return exprEvaluator;
        }
        ExprEvaluator left = exprEvaluator.left;
        ExprEvaluator right = exprEvaluator.right;
        int evalType = exprEvaluator.getEvalType();
        if (evalType == 0) {
            return ExprParser.compressEvaluator(left);
        }
        if (evalType == 1) {
            left = ExprParser.compressEvaluator(left);
            if (right == null) {
                return left;
            }
            right = ExprParser.compressEvaluator(right);
            ElOperator eo = exprEvaluator.operator;
            if (eo == ElOperator.QUESTION) {
                return ExprEvaluator.TernaryImpl.of(exprEvaluator.update(left, right));
            }
            switch (eo) {
                case MULTI: {
                    return ExprEvaluator.MultiplyImpl.of(exprEvaluator.update(left, right));
                }
                case DIVISION: {
                    return ExprEvaluator.DivisionImpl.of(exprEvaluator.update(left, right));
                }
                case MOD: {
                    return ExprEvaluator.ModulusImpl.of(exprEvaluator.update(left, right));
                }
                case EXP: {
                    return ExprEvaluator.PowerImpl.of(exprEvaluator.update(left, right));
                }
                case PLUS: {
                    if (right.negate) {
                        right.setNegate(false);
                        return ExprEvaluator.MinusImpl.of(exprEvaluator.update(left, right));
                    }
                    return ExprEvaluator.PlusImpl.of(exprEvaluator.update(left, right));
                }
                case MINUS: {
                    return ExprEvaluator.MinusImpl.of(exprEvaluator.update(left, right));
                }
                case BIT_RIGHT: {
                    return ExprEvaluator.BitRightImpl.of(exprEvaluator.update(left, right));
                }
                case BIT_LEFT: {
                    return ExprEvaluator.BitLeftImpl.of(exprEvaluator.update(left, right));
                }
                case AND: {
                    return ExprEvaluator.BitAndImpl.of(exprEvaluator.update(left, right));
                }
                case XOR: {
                    return ExprEvaluator.BitXorImpl.of(exprEvaluator.update(left, right));
                }
                case OR: {
                    return ExprEvaluator.BitOrImpl.of(exprEvaluator.update(left, right));
                }
                case GT: {
                    return ExprEvaluator.GtImpl.of(exprEvaluator.update(left, right));
                }
                case LT: {
                    return ExprEvaluator.LtImpl.of(exprEvaluator.update(left, right));
                }
                case EQ: {
                    return ExprEvaluator.EqualImpl.of(exprEvaluator.update(left, right));
                }
                case GE: {
                    return ExprEvaluator.GEImpl.of(exprEvaluator.update(left, right));
                }
                case LE: {
                    return ExprEvaluator.LEImpl.of(exprEvaluator.update(left, right));
                }
                case NE: {
                    return ExprEvaluator.NEImpl.of(exprEvaluator.update(left, right));
                }
                case LOGICAL_AND: {
                    return ExprEvaluator.LogicalAndImpl.of(exprEvaluator.update(left, right));
                }
                case LOGICAL_OR: {
                    return ExprEvaluator.LogicalOrImpl.of(exprEvaluator.update(left, right));
                }
                case IN: {
                    return ExprEvaluator.InImpl.of(exprEvaluator.update(left, right));
                }
                case OUT: {
                    return ExprEvaluator.OutImpl.of(exprEvaluator.update(left, right));
                }
            }
            return exprEvaluator.update(left, right);
        }
        if (evalType == 4) {
            if (!exprEvaluator.negate && !exprEvaluator.logicalNot) {
                return ExprParser.compressEvaluator(right);
            }
            return ExprEvaluator.BracketImpl.of(exprEvaluator.update(left, ExprParser.compressEvaluator(right)));
        }
        if (evalType == 2) {
            if (!exprEvaluator.negate && !exprEvaluator.logicalNot) {
                return ((ExprEvaluator.VariableImpl)exprEvaluator).normal().internKey();
            }
            return ((ExprEvaluator.VariableImpl)exprEvaluator).internKey();
        }
        if (evalType == 3) {
            return exprEvaluator;
        }
        return left == null ? null : ExprParser.compressEvaluator(left);
    }

    protected static String createErrorContextText(char[] buf, int at) {
        try {
            int len = buf.length;
            char[] text = new char[40];
            int begin = Math.max(at - 18, 0);
            int count = at - begin;
            System.arraycopy(buf, begin, text, 0, count);
            text[count++] = 94;
            int end = Math.min(len, at + 18);
            System.arraycopy(buf, at, text, count, end - at);
            return new String(text, 0, count += end - at);
        }
        catch (Throwable throwable) {
            return "";
        }
    }

    public void optimize() {
        this.exprEvaluator = this.exprEvaluator.optimize();
    }
}

