/*
 * Decompiled with CFR 0.152.
 */
package io.github.wycst.wast.common.expression.compile;

import io.github.wycst.wast.common.expression.ElChainVariableInvoker;
import io.github.wycst.wast.common.expression.ElInvoker;
import io.github.wycst.wast.common.expression.ElVariableInvoker;
import io.github.wycst.wast.common.expression.ElVariableUtils;
import io.github.wycst.wast.common.expression.EvaluateEnvironment;
import io.github.wycst.wast.common.expression.ExprFunction;
import io.github.wycst.wast.common.expression.compile.CompilerExprParser;
import io.github.wycst.wast.common.expression.functions.JavassistExprFunction;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class CompilerEnvironment
extends EvaluateEnvironment {
    private boolean skipParse;
    private boolean enableSystem;
    private boolean disableSecurityCheck;
    private Set<String> disableKeys = new HashSet<String>();
    private Map<String, Class> variableTypeMap = new LinkedHashMap<String, Class>();
    private List<TypeNameInvoker> typeNameInvokers = new ArrayList<TypeNameInvoker>();
    Map<String, ExprFunctionMeta> javassistFunctionMetaMap = new LinkedHashMap<String, ExprFunctionMeta>();

    protected List<TypeNameInvoker> getTypeNameInvokers() {
        return this.typeNameInvokers;
    }

    protected Map<String, Class> getVariableTypes() {
        return this.variableTypeMap;
    }

    public EvaluateEnvironment registerJavassistFunction(String name, JavassistExprFunction function, Class<?> returnClass, Class<?> ... paramClassList) {
        name.getClass();
        returnClass.getClass();
        function.getClass();
        this.registerFunction(name, function);
        ExprFunctionMeta exprFunctionMeta = new ExprFunctionMeta(name, function, returnClass, paramClassList);
        this.javassistFunctionMetaMap.put(name, exprFunctionMeta);
        return this;
    }

    public void setVariableType(Class<?> type, String ... vars) {
        for (String var : vars) {
            if (type == System.class || type == Runtime.class) continue;
            if (!Modifier.isPublic(type.getModifiers())) {
                throw new UnsupportedOperationException(type + " is not public access");
            }
            this.variableTypeMap.put(var, type);
        }
    }

    void initTypeNameInvokers(CompilerExprParser parser) {
        this.typeNameInvokers.clear();
        if (parser.getVariableCount() == 0) {
            return;
        }
        Collection<ElVariableInvoker> tailInvokers = parser.getTailVariableInvokers();
        for (ElVariableInvoker tailInvoker : tailInvokers) {
            String varName = "_$" + tailInvoker.getIndex();
            Class<Double> type = this.variableTypeMap.get(tailInvoker.toString());
            if (type == null) {
                type = Double.TYPE;
            }
            this.typeNameInvokers.add(new TypeNameInvoker(varName, varName, type, tailInvoker));
        }
    }

    void initTypeNameInvokers() {
        if (this.variableTypeMap.size() == 0) {
            return;
        }
        this.typeNameInvokers.clear();
        HashMap<String, ElVariableInvoker> invokes = new HashMap<String, ElVariableInvoker>();
        HashMap<String, ElVariableInvoker> tailInvokes = new HashMap<String, ElVariableInvoker>();
        Set<Map.Entry<String, Class>> entrySet = this.variableTypeMap.entrySet();
        for (Map.Entry<String, Class> entry : entrySet) {
            String var = entry.getKey();
            Class type = entry.getValue();
            this.typeNameInvokers.add(new TypeNameInvoker(var, var.replace('.', '_'), type, ElVariableUtils.build(var, invokes, tailInvokes)));
        }
        Collections.sort(this.typeNameInvokers);
        ElInvoker variableValues = ElChainVariableInvoker.build(invokes, true);
        variableValues.internKey();
    }

    public boolean isSkipParse() {
        return this.skipParse;
    }

    public void setSkipParse(boolean skipParse) {
        this.skipParse = skipParse;
    }

    public boolean isEnableSystem() {
        return this.enableSystem;
    }

    public void setEnableSystem(boolean enableSystem) {
        this.enableSystem = enableSystem;
    }

    public boolean isDisableSecurityCheck() {
        return this.disableSecurityCheck;
    }

    public void setDisableSecurityCheck(boolean disableSecurityCheck) {
        this.disableSecurityCheck = disableSecurityCheck;
    }

    @Override
    protected Map<String, ExprFunction> getFunctionMap() {
        return super.getFunctionMap();
    }

    @Override
    protected ExprFunction getFunction(String functionName) {
        return super.getFunction(functionName);
    }

    public void setKeyBlacklist(String ... keys) {
        for (String key : keys) {
            this.disableKeys.add(key);
        }
    }

    public void setKeyBlacklist(Collection keys) {
        if (keys != null) {
            this.disableKeys.addAll(keys);
        }
    }

    public Set<String> getDisableKeys() {
        return this.disableKeys;
    }

    static class TypeNameInvoker
    implements Comparable<TypeNameInvoker> {
        final String varName;
        final String defineJavaIdentifier;
        final Class type;
        final ElVariableInvoker variableInvoker;

        public TypeNameInvoker(String varName, String defineJavaIdentifier, Class type, ElVariableInvoker variableInvoker) {
            this.varName = varName;
            this.defineJavaIdentifier = defineJavaIdentifier;
            this.type = type;
            this.variableInvoker = variableInvoker;
        }

        @Override
        public int compareTo(TypeNameInvoker o) {
            return this.varName.length() > o.varName.length() ? -1 : 1;
        }
    }

    static class ExprFunctionMeta {
        String name;
        JavassistExprFunction function;
        Class<?> returnClass;
        Class<?>[] paramClassList;

        ExprFunctionMeta(String name, JavassistExprFunction function, Class<?> returnClass, Class<?>[] paramClassList) {
            this.name = name;
            this.function = function;
            this.returnClass = returnClass;
            this.paramClassList = paramClassList;
        }
    }
}

