/*
 * Decompiled with CFR 0.152.
 */
package io.github.wycst.wast.common.utils;

import io.github.wycst.wast.common.reflect.ClassStructureWrapper;
import io.github.wycst.wast.common.reflect.GetterInfo;
import io.github.wycst.wast.common.reflect.SetterInfo;
import io.github.wycst.wast.common.utils.CollectionUtils;
import io.github.wycst.wast.common.utils.InvokeUtils;
import io.github.wycst.wast.common.utils.ObjectUtils;
import java.util.List;
import java.util.Map;
import java.util.Set;

public final class BeanUtils
extends InvokeUtils {
    public static void copy(Object srcBean, Object targetBean) {
        BeanUtils.copyProperties(srcBean, targetBean, null);
    }

    public static void copyProperties(Object src, Object target, String[] excludeFields) {
        boolean isSameBeanType;
        if (src == null || target == null) {
            return;
        }
        Map targetMap = null;
        ClassStructureWrapper targetClassStructureWrapper = null;
        Class<?> targetClass = target.getClass();
        boolean bl = isSameBeanType = src.getClass() == targetClass;
        if (target instanceof Map) {
            targetMap = (Map)target;
        } else {
            targetClassStructureWrapper = ClassStructureWrapper.get(targetClass);
        }
        if (src instanceof Map) {
            Map sourceMap = (Map)src;
            if (targetMap != null) {
                if (excludeFields == null || excludeFields.length == 0) {
                    targetMap.putAll(sourceMap);
                } else {
                    Set entrySet = sourceMap.entrySet();
                    for (Map.Entry entry : entrySet) {
                        Object key = entry.getKey();
                        Object value = entry.getValue();
                        if (CollectionUtils.indexOf(excludeFields, value) > -1) continue;
                        sourceMap.put(key, value);
                    }
                }
            } else {
                Set entrySet = sourceMap.entrySet();
                for (Map.Entry entry : entrySet) {
                    Object key = entry.getKey();
                    if (key == null || CollectionUtils.indexOf(excludeFields, key) > -1) continue;
                    Object value = entry.getValue();
                    SetterInfo setterInfo = targetClassStructureWrapper.getSetterInfo(key.toString());
                    if (setterInfo == null) continue;
                    value = ObjectUtils.toType(value, setterInfo.getParameterType());
                    BeanUtils.invokeSet(setterInfo, target, value);
                }
            }
        } else {
            ClassStructureWrapper sourceClassStructureWrapper = isSameBeanType ? targetClassStructureWrapper : ClassStructureWrapper.get(src.getClass());
            List<GetterInfo> sourceGetterInfos = sourceClassStructureWrapper.getGetterInfos();
            for (GetterInfo getterInfo : sourceGetterInfos) {
                String fieldName = getterInfo.getName();
                if (CollectionUtils.indexOf(excludeFields, fieldName) > -1) continue;
                Object value = BeanUtils.invokeGet(getterInfo, src);
                if (targetMap != null) {
                    targetMap.put(fieldName, value);
                    continue;
                }
                SetterInfo setterInfo = targetClassStructureWrapper.getSetterInfo(fieldName);
                if (setterInfo == null) continue;
                BeanUtils.invokeSet(setterInfo, target, ObjectUtils.toType(value, setterInfo.getParameterType()));
            }
        }
    }

    public static void mergeProperties(Object src, Object target) {
        boolean isSameBeanType;
        if (src == null || target == null) {
            return;
        }
        Class<?> targetClass = target.getClass();
        Map targetMap = null;
        ClassStructureWrapper targetClassStructureWrapper = null;
        boolean bl = isSameBeanType = src.getClass() == targetClass;
        if (target instanceof Map) {
            targetMap = (Map)target;
        } else {
            targetClassStructureWrapper = ClassStructureWrapper.get(targetClass);
        }
        if (src instanceof Map) {
            Map sourceMap = (Map)src;
            if (targetMap != null) {
                targetMap.putAll(sourceMap);
            } else {
                Set entrySet = sourceMap.entrySet();
                for (Map.Entry entry : entrySet) {
                    Object key = entry.getKey();
                    SetterInfo setterInfo = targetClassStructureWrapper.getSetterInfo(String.valueOf(key));
                    if (setterInfo == null) continue;
                    BeanUtils.invokeSet(setterInfo, target, ObjectUtils.toType(entry.getValue(), setterInfo.getParameterType()));
                }
            }
        } else {
            ClassStructureWrapper sourceClassStructureWrapper = isSameBeanType ? targetClassStructureWrapper : ClassStructureWrapper.get(src.getClass());
            List<GetterInfo> getterInfos = sourceClassStructureWrapper.getGetterInfos();
            for (GetterInfo getterInfo : getterInfos) {
                SetterInfo setterInfo;
                String fieldName = getterInfo.getName();
                Object value = BeanUtils.invokeGet(getterInfo, src);
                if (targetMap != null) {
                    targetMap.put(fieldName, value);
                    continue;
                }
                if (value == null || "".equals(value) || (setterInfo = targetClassStructureWrapper.getSetterInfo(fieldName)) == null) continue;
                BeanUtils.invokeSet(setterInfo, target, ObjectUtils.toType(value, setterInfo.getParameterType()));
            }
        }
    }
}

