/*
 * Decompiled with CFR 0.152.
 */
package io.github.wycst.wast.jdbc.executer;

import io.github.wycst.wast.jdbc.exception.OqlParematerException;
import io.github.wycst.wast.jdbc.executer.DefaultSqlExecuter;
import io.github.wycst.wast.jdbc.executer.EntitySqlMapping;
import io.github.wycst.wast.jdbc.executer.SqlType;
import io.github.wycst.wast.jdbc.query.sql.Sql;
import java.io.Serializable;
import java.util.List;

class EntityHandler {
    EntitySqlMapping entitySqlMapping;

    EntityHandler(EntitySqlMapping entitySqlMapping) {
        this.entitySqlMapping = entitySqlMapping;
    }

    <E> E getById(DefaultSqlExecuter sqlExecuter, Class<E> entityCls, Serializable id) {
        String selectSql = this.entitySqlMapping.getSelectSql();
        if (selectSql == null) {
            throw new OqlParematerException("\u914d\u7f6e\u9519\u8bef\uff1a" + entityCls + "\u53ef\u80fd\u6ca1\u6709\u5b9a\u4e49@Id,\u8bf7\u68c0\u67e5\u914d\u7f6e");
        }
        return sqlExecuter.queryObject(selectSql, entityCls, id);
    }

    <E> int deleteById(DefaultSqlExecuter sqlExecuter, Class<E> entityCls, Serializable id) {
        String sqlStringFormat = sqlExecuter.sqlTemplates[SqlType.DELETE.ordinal()];
        Sql sqlObject = this.entitySqlMapping.getDeleteSqlObject(sqlStringFormat, id);
        if (sqlObject == null) {
            throw new OqlParematerException("\u914d\u7f6e\u9519\u8bef\uff1a" + this.entitySqlMapping.getEntityClass() + "\u53ef\u80fd\u6ca1\u6709\u5b9a\u4e49@Id,\u8bf7\u68c0\u67e5\u914d\u7f6e");
        }
        return sqlExecuter.update(sqlObject.getFormalSql(), sqlObject.getParamValues());
    }

    <E> int updateEntity(DefaultSqlExecuter sqlExecuter, E entity) {
        String sqlStringFormat = sqlExecuter.sqlTemplates[SqlType.UPDATE.ordinal()];
        Sql sqlObject = this.entitySqlMapping.getUpdateSqlObject(sqlStringFormat, entity);
        if (sqlObject == null) {
            throw new OqlParematerException("\u914d\u7f6e\u9519\u8bef\uff1a" + this.entitySqlMapping.getEntityClass() + "\u53ef\u80fd\u6ca1\u6709\u5b9a\u4e49@Id,\u8bf7\u68c0\u67e5\u914d\u7f6e");
        }
        return sqlExecuter.update(sqlObject.getFormalSql(), sqlObject.getParamValues());
    }

    <E> void afterUpdate(DefaultSqlExecuter sqlExecuter, E entity) {
    }

    void afterBatchDelete() {
    }

    <E> List<E> executeQueryBy(DefaultSqlExecuter sqlExecuter, Class<E> entityCls, Object params) {
        Sql sqlObject = this.entitySqlMapping.getSelectSqlObject(params);
        return sqlExecuter.queryList(sqlObject.getFormalSql(), entityCls, sqlObject.getParamValues());
    }
}

