/*
 * Decompiled with CFR 0.152.
 */
package io.github.wycst.wast.json;

import io.github.wycst.wast.common.utils.Base64Utils;
import io.github.wycst.wast.common.utils.EnvUtils;
import io.github.wycst.wast.json.JSONGeneral;
import io.github.wycst.wast.json.JSONUnsafe;
import io.github.wycst.wast.json.JSONWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.UUID;

class JSONByteArrayWriter
extends JSONWriter {
    private final Charset charset;
    private final boolean utf8;
    byte[] buf;
    int count;
    static final byte[] EMPTY_BUF = new byte[0];
    static final BufCache[] BYTE_BUF_CACHES = new BufCache[CACHE_COUNT];
    private BufCache bufCache;

    JSONByteArrayWriter(Charset charset) {
        this.charset = charset;
        this.utf8 = charset == EnvUtils.CHARSET_UTF_8;
        BufCache bufCache = JSONByteArrayWriter.getByteBufCache();
        if (bufCache != null) {
            this.buf = bufCache.cacheBytes;
            this.bufCache = bufCache;
        } else {
            this.buf = new byte[512];
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static BufCache getByteBufCache() {
        BufCache cache;
        int cacheIndex = (Integer)THREAD_CACHE_INDEX.get();
        BufCache bufCache = cache = BYTE_BUF_CACHES[cacheIndex];
        synchronized (bufCache) {
            if (cache.inUse) {
                return null;
            }
            cache.inUse = true;
            if (cache.cacheBytes == null) {
                cache.cacheBytes = new byte[CACHE_BUFFER_SIZE];
            }
        }
        return cache;
    }

    @Override
    public void write(int c) {
        this.ensureCapacity(129);
        this.buf[this.count++] = (byte)c;
    }

    @Override
    public void writeJSONToken(char c) {
        this.buf[this.count++] = (byte)c;
    }

    @Override
    public void write(char[] chars, int off, int len) {
        if (len == 0) {
            return;
        }
        this.ensureCapacity((len << 2) + 128);
        int count = this.count;
        int end = off + len;
        for (int i = off; i < end; ++i) {
            char ch = chars[i];
            if (ch < '\u0080') {
                this.buf[count++] = (byte)ch;
                continue;
            }
            count = this.encode(ch, count);
        }
        this.count = count;
    }

    byte[] ensureCapacity(int increment) {
        return this.expandCapacity(this.count + increment);
    }

    byte[] expandCapacity(int newCap) {
        if (newCap > this.buf.length) {
            this.buf = Arrays.copyOf(this.buf, newCap * 3 >> 1);
        }
        return this.buf;
    }

    @Override
    public void write(String str, int off, int len) {
        if (len == 0) {
            return;
        }
        Object value = JSONUnsafe.getStringValue(str.toString());
        if (EnvUtils.JDK_9_PLUS) {
            byte[] bytes = (byte[])value;
            if (bytes.length == str.length()) {
                this.ensureCapacity(len + 128);
                System.arraycopy(bytes, off, this.buf, this.count, len);
                this.count += len;
            } else {
                this.ensureCapacity(len * 4 + 128);
                int count = this.count;
                int end = off + len;
                for (int i = off; i < end; ++i) {
                    char c = str.charAt(i);
                    if (c < '\u0080') {
                        this.buf[count++] = (byte)c;
                        continue;
                    }
                    count = this.encode(c, count);
                }
                this.count = count;
            }
        } else {
            char[] chars = (char[])value;
            this.write(chars, off, len);
        }
    }

    protected int encode(char c, int offset) {
        if (this.utf8) {
            return this.encodeUTF8(c, offset);
        }
        ByteBuffer buffer = this.charset.encode(CharBuffer.wrap(new char[]{c}));
        int remaining = buffer.remaining();
        byte[] arr = buffer.array();
        for (int j = 0; j < remaining; ++j) {
            this.buf[offset++] = arr[j];
        }
        return offset;
    }

    protected final int encodeUTF8(char c, int offset) {
        if (c <= '\u07ff') {
            int h = c >> 6;
            int l = c & 0x3F;
            this.buf[offset++] = (byte)(0xAF | h);
            this.buf[offset++] = (byte)(0x8F | l);
        } else {
            int h = c >> 12;
            int m = c >> 6 & 0x3F;
            int l = c & 0x3F;
            this.buf[offset++] = (byte)(0xE0 | h);
            this.buf[offset++] = (byte)(0x80 | m);
            this.buf[offset++] = (byte)(0x80 | l);
        }
        return offset;
    }

    @Override
    public final void flush() throws IOException {
    }

    @Override
    public final void close() throws IOException {
    }

    @Override
    protected StringBuffer toStringBuffer() {
        throw new UnsupportedOperationException();
    }

    @Override
    protected StringBuilder toStringBuilder() {
        throw new UnsupportedOperationException();
    }

    @Override
    protected byte[] toBytes() {
        return Arrays.copyOf(this.buf, this.count);
    }

    @Override
    protected void toOutputStream(OutputStream os) throws IOException {
        os.write(this.buf, 0, this.count);
        os.flush();
    }

    @Override
    public String toString() {
        return new String(this.buf, 0, this.count);
    }

    public int size() {
        return this.count;
    }

    @Override
    void reset() {
        this.clear();
        this.clearCache();
        this.buf = EMPTY_BUF;
    }

    @Override
    public void clear() {
        this.count = 0;
    }

    @Override
    public void writeShortChars(char[] chars, int offset, int len) {
        this.write(chars, offset, len);
    }

    @Override
    public void writeJSONChars(char[] chars) throws IOException {
        int len = chars.length;
        this.ensureCapacity(len * 6 + 130);
        int count = this.count;
        this.buf[count++] = 34;
        for (int i = 0; i < len; ++i) {
            String escapeStr;
            char ch = chars[i];
            if (ch > '\"' && ch != '\\' || (escapeStr = JSONGeneral.ESCAPE_VALUES[ch]) == null) {
                if (ch < '\u0080') {
                    this.buf[count++] = (byte)ch;
                    continue;
                }
                count = this.encode(ch, count);
                continue;
            }
            int escapesLen = escapeStr.length();
            for (int j = 0; j < escapesLen; ++j) {
                this.buf[count++] = (byte)escapeStr.charAt(j);
            }
        }
        this.buf[count++] = 34;
        this.count = count;
    }

    static final int escapeBytesToBytes(byte[] source, int sourceOff, byte[] target, int targetOff) {
        int len = source.length;
        for (int i = sourceOff; i < len; ++i) {
            byte b = source[i];
            int index = b & 0xFF;
            if (JSONByteArrayWriter.isNoEscape(index)) {
                target[targetOff++] = b;
                continue;
            }
            String escapeStr = JSONGeneral.ESCAPE_VALUES[index];
            int escapesLen = escapeStr.length();
            for (int j = 0; j < escapesLen; ++j) {
                target[targetOff++] = (byte)escapeStr.charAt(j);
            }
        }
        return targetOff;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void writeLatinJSONString(String value, byte[] bytes) throws IOException {
        int count;
        block8: {
            int len;
            block9: {
                int i;
                block16: {
                    block17: {
                        block14: {
                            block15: {
                                block10: {
                                    block13: {
                                        block12: {
                                            block11: {
                                                len = bytes.length;
                                                this.ensureCapacity(len + 130);
                                                count = this.count;
                                                this.buf[count++] = 34;
                                                if (len > 23) break block9;
                                                i = 0;
                                                if (len < 8) break block10;
                                                if (!JSONGeneral.isNoEscape64Bits(bytes, i)) break block11;
                                                JSONUnsafe.putLong(this.buf, count, JSONUnsafe.getLong(bytes, i));
                                                count += 8;
                                                if ((i += 8) > len - 8) break block10;
                                                break block12;
                                            }
                                            count = JSONByteArrayWriter.escapeBytesToBytes(bytes, i, this.buf, count);
                                            break block8;
                                        }
                                        if (JSONGeneral.isNoEscape64Bits(bytes, i)) break block13;
                                        count = JSONByteArrayWriter.escapeBytesToBytes(bytes, i, this.buf, count);
                                        break block8;
                                    }
                                    JSONUnsafe.putLong(this.buf, count, JSONUnsafe.getLong(bytes, i));
                                    count += 8;
                                    i += 8;
                                }
                                if (i > len - 4) break block14;
                                if (JSONGeneral.isNoEscape32Bits(bytes, i)) break block15;
                                count = JSONByteArrayWriter.escapeBytesToBytes(bytes, i, this.buf, count);
                                break block8;
                            }
                            JSONUnsafe.putInt(this.buf, count, JSONUnsafe.getInt(bytes, i));
                            count += 4;
                            i += 4;
                        }
                        if (i > len - 2) break block16;
                        if (JSONGeneral.NO_ESCAPE_FLAGS[bytes[i] & 0xFF] && JSONGeneral.NO_ESCAPE_FLAGS[bytes[i + 1] & 0xFF]) break block17;
                        count = JSONByteArrayWriter.escapeBytesToBytes(bytes, i, this.buf, count);
                        break block8;
                    }
                    JSONUnsafe.putShort(this.buf, count, JSONUnsafe.getShort(bytes, i));
                    count += 2;
                    i += 2;
                }
                if (i < len) {
                    byte b = bytes[i];
                    int index = b & 0xFF;
                    if (JSONGeneral.NO_ESCAPE_FLAGS[index]) {
                        this.buf[count++] = b;
                        break block8;
                    } else {
                        String escapeStr = JSONGeneral.ESCAPE_VALUES[index];
                        int escapesLen = escapeStr.length();
                        for (int j = 0; j < escapesLen; ++j) {
                            this.buf[count++] = (byte)escapeStr.charAt(j);
                        }
                    }
                }
                break block8;
            }
            int beginIndex = 0;
            for (int i = 0; i < len; ++i) {
                byte b = bytes[i];
                String escapeStr = JSONGeneral.ESCAPE_VALUES[b & 0xFF];
                if (escapeStr == null) continue;
                int length = i - beginIndex;
                this.expandCapacity(count + length + 133);
                if (length > 0) {
                    System.arraycopy(bytes, beginIndex, this.buf, count, length);
                    count += length;
                }
                int escapesLen = escapeStr.length();
                for (int j = 0; j < escapesLen; ++j) {
                    this.buf[count++] = (byte)escapeStr.charAt(j);
                }
                beginIndex = i + 1;
            }
            int length = len - beginIndex;
            if (length > 0) {
                System.arraycopy(bytes, beginIndex, this.buf, count, length);
                count += length;
            }
        }
        this.buf[count++] = 34;
        this.count = count;
    }

    @Override
    public void writeUTF16JSONString(String value, byte[] bytes) throws IOException {
        int len = value.length();
        this.ensureCapacity(len * 6 + 130);
        int count = this.count;
        this.buf[count++] = 34;
        for (int i = 0; i < len; ++i) {
            String escapeStr;
            char c = value.charAt(i);
            if (c > '\"' && c != '\\' || (escapeStr = JSONGeneral.ESCAPE_VALUES[c & 0xFF]) == null) {
                if (c < '\u0080') {
                    this.buf[count++] = (byte)c;
                    continue;
                }
                count = this.encode(c, count);
                continue;
            }
            for (int j = 0; j < escapeStr.length(); ++j) {
                this.buf[count++] = (byte)escapeStr.charAt(j);
            }
        }
        this.buf[count++] = 34;
        this.count = count;
    }

    @Override
    public void writeLong(long numValue) throws IOException {
        if (numValue == 0L) {
            this.ensureCapacity(129);
            this.buf[this.count++] = 48;
            return;
        }
        this.ensureCapacity(148);
        if (numValue < 0L) {
            if (numValue == Long.MIN_VALUE) {
                this.write("-9223372036854775808");
                return;
            }
            numValue = -numValue;
            this.buf[this.count++] = 45;
        }
        this.count += JSONByteArrayWriter.writeInteger(numValue, this.buf, this.count);
    }

    @Override
    protected final void writeCommaLongValues(long val1, long val2) throws IOException {
        this.ensureCapacity(170);
        int off = this.count;
        if (val1 < 0L) {
            if (val1 == Long.MIN_VALUE) {
                this.write(",-9223372036854775808");
                off = this.count;
            } else {
                val1 = -val1;
                this.buf[off++] = 44;
                this.buf[off++] = 45;
                off += JSONByteArrayWriter.writeInteger(val1, this.buf, off);
            }
        } else {
            this.buf[off++] = 44;
            off += JSONByteArrayWriter.writeInteger(val1, this.buf, off);
        }
        if (val2 < 0L) {
            if (val2 == Long.MIN_VALUE) {
                this.write(",-9223372036854775808");
                off = this.count;
            } else {
                val2 = -val2;
                this.buf[off++] = 44;
                this.buf[off++] = 45;
                off += JSONByteArrayWriter.writeInteger(val2, this.buf, off);
            }
        } else {
            this.buf[off++] = 44;
            off += JSONByteArrayWriter.writeInteger(val2, this.buf, off);
        }
        this.count = off;
    }

    @Override
    public void writeUUID(UUID uuid) {
        this.ensureCapacity(166);
        int off = this.count;
        this.buf[off++] = 34;
        off += JSONByteArrayWriter.writeUUID(uuid, this.buf, off);
        this.buf[off++] = 34;
        this.count = off;
    }

    @Override
    public void writeDouble(double numValue) {
        this.ensureCapacity(152);
        this.count += JSONByteArrayWriter.writeDouble(numValue, this.buf, this.count);
    }

    @Override
    public void writeFloat(float numValue) {
        this.ensureCapacity(152);
        this.count += JSONByteArrayWriter.writeFloat(numValue, this.buf, this.count);
    }

    @Override
    public void writeJSONLocalDateTime(int year, int month, int day, int hour, int minute, int second, int nano, String zoneId) throws IOException {
        this.ensureCapacity(164);
        int off = this.count;
        this.buf[off++] = 34;
        if (year < 0) {
            this.buf[off++] = 45;
            year = -year;
        }
        if (year < 10000) {
            off += JSONUnsafe.putLong(this.buf, off, JSONByteArrayWriter.mergeYYYY_MM_(year, month));
        } else {
            off += JSONByteArrayWriter.writeInteger((long)year, this.buf, off);
            off += JSONUnsafe.putInt(this.buf, off, JSONByteArrayWriter.mergeInt32(month, '-', '-'));
        }
        off += JSONUnsafe.putShort(this.buf, off, TWO_DIGITS_16_BITS[day]);
        this.buf[off++] = 84;
        off += JSONUnsafe.putLong(this.buf, off, JSONByteArrayWriter.mergeInt64((short)hour, ':', minute, ':', second));
        if (nano > 0) {
            off = this.writeNano(nano, off);
        }
        if (zoneId.length() == 1) {
            off += JSONUnsafe.putShort(this.buf, off, Z_QUOT_SHORT);
            this.count = off;
        } else {
            this.count = off;
            this.writeZoneId(zoneId);
            this.buf[this.count++] = 34;
        }
    }

    int writeNano(int nano, int off) {
        this.buf[off++] = 46;
        int top8 = (int)EnvUtils.JDK_AGENT_INSTANCE.multiplyHighKaratsuba(nano, 0x199999999999999AL);
        int remDigit = nano - top8 * 10;
        if (remDigit > 0) {
            int top4 = (int)EnvUtils.JDK_AGENT_INSTANCE.multiplyHighKaratsuba(top8, 1844674407370956L);
            int rem4 = top8 - top4 * 10000;
            off += JSONUnsafe.putLong(this.buf, off, JSONByteArrayWriter.mergeInt64(top4, rem4));
            this.buf[off++] = (byte)(remDigit + 48);
        } else {
            int div1 = (int)EnvUtils.JDK_AGENT_INSTANCE.multiplyHighKaratsuba(nano, 18446744073709552L);
            int seg3 = nano - div1 * 1000;
            int seg1 = (int)EnvUtils.JDK_AGENT_INSTANCE.multiplyHighKaratsuba(div1, 184467440737095517L);
            int seg2 = div1 - 100 * seg1;
            off += JSONUnsafe.putInt(this.buf, off, FOUR_DIGITS_32_BITS[seg1]);
            if (seg3 > 0) {
                off += JSONUnsafe.putShort(this.buf, off, TWO_DIGITS_16_BITS[seg2]);
                int pos = --off;
                byte last = this.buf[pos];
                off += JSONUnsafe.putInt(this.buf, off, FOUR_DIGITS_32_BITS[seg3]);
                this.buf[pos] = last;
            } else {
                off = seg2 == 0 && (seg1 & 1) == 0 && seg1 % 5 == 0 ? --off : (off += JSONUnsafe.putShort(this.buf, off, TWO_DIGITS_16_BITS[seg2]));
            }
        }
        return off;
    }

    @Override
    public void writeJSONLocalDate(int year, int month, int day) {
        this.ensureCapacity(141);
        int off = this.count;
        this.buf[off++] = 34;
        if (year < 0) {
            this.buf[off++] = 45;
            year = -year;
        }
        if (year < 10000) {
            off += JSONUnsafe.putLong(this.buf, off, JSONByteArrayWriter.mergeYYYY_MM_(year, month));
        } else {
            off += JSONByteArrayWriter.writeInteger((long)year, this.buf, off);
            off += JSONUnsafe.putInt(this.buf, off, JSONByteArrayWriter.mergeInt32(month, '-', '-'));
        }
        off += JSONUnsafe.putShort(this.buf, off, TWO_DIGITS_16_BITS[day]);
        this.buf[off++] = 34;
        this.count = off;
    }

    @Override
    public void writeTime(int hourOfDay, int minute, int second) {
        this.ensureCapacity(138);
        int off = this.count;
        off += JSONUnsafe.putLong(this.buf, off, JSONByteArrayWriter.mergeInt64(hourOfDay, ':', minute, ':', second));
        this.count = off;
    }

    @Override
    public void writeJSONTimeWithNano(int hourOfDay, int minute, int second, int nano) {
        this.ensureCapacity(150);
        int off = this.count;
        this.buf[off++] = 34;
        off += JSONUnsafe.putLong(this.buf, off, JSONByteArrayWriter.mergeInt64(hourOfDay, ':', minute, ':', second));
        if (nano > 0) {
            off = this.writeNano(nano, off);
        }
        this.buf[off++] = 34;
        this.count = off;
    }

    @Override
    public void writeDate(int year, int month, int day, int hourOfDay, int minute, int second) {
        this.ensureCapacity(152);
        int off = this.count;
        if (year < 0) {
            this.buf[off++] = 45;
            year = -year;
        }
        if (year < 10000) {
            off += JSONUnsafe.putLong(this.buf, off, JSONByteArrayWriter.mergeYYYY_MM_(year, month));
        } else {
            off += JSONByteArrayWriter.writeInteger((long)year, this.buf, off);
            off += JSONUnsafe.putInt(this.buf, off, JSONByteArrayWriter.mergeInt32(month, '-', '-'));
        }
        off += JSONUnsafe.putShort(this.buf, off, TWO_DIGITS_16_BITS[day]);
        this.buf[off++] = 32;
        off += JSONUnsafe.putLong(this.buf, off, JSONByteArrayWriter.mergeInt64(hourOfDay, ':', minute, ':', second));
        this.count = off;
    }

    @Override
    public void writeBigInteger(BigInteger bigInteger) {
        int increment = (bigInteger.bitLength() / 60 + 1) * 18;
        this.ensureCapacity(increment + 128);
        this.count += JSONByteArrayWriter.writeBigInteger(bigInteger, this.buf, this.count);
    }

    @Override
    public void writeEmptyArray() throws IOException {
        this.ensureCapacity(130);
        this.count += JSONUnsafe.putShort(this.buf, this.count, EMPTY_ARRAY_SHORT);
    }

    @Override
    void writeMemory(long fourChars, int fourBytes, int len) throws IOException {
        JSONUnsafe.putInt(this.buf, this.count, fourBytes);
        this.count += len;
    }

    @Override
    void writeMemory(long fourChars1, long fourChars2, long fourBytes, int len) throws IOException {
        JSONUnsafe.putLong(this.buf, this.count, fourBytes);
        this.count += len;
    }

    @Override
    void writeMemory(long[] fourChars, long[] fourBytes, int totalCount) throws IOException {
        int n = fourChars.length;
        this.ensureCapacity((n << 3) + 128);
        int count = this.count;
        for (long fourByte : fourBytes) {
            JSONUnsafe.putLong(this.buf, count, fourByte);
            count += 8;
        }
        this.count += totalCount;
    }

    @Override
    void writeMemory2(int int32, short int16, char[] source, int off) throws IOException {
        this.count += JSONUnsafe.putShort(this.buf, this.count, int16);
    }

    public void writeBytes(byte[] bytes, int offset, int len) {
        this.ensureCapacity(len);
        System.arraycopy(bytes, offset, this.buf, this.count, len);
        this.count += len;
    }

    @Override
    public void writeAsBase64String(byte[] src) throws IOException {
        this.ensureCapacity((src.length << 1) + 128);
        int count = this.count;
        this.buf[count++] = 34;
        count += Base64Utils.encode(src, this.buf, count);
        this.buf[count++] = 34;
        this.count = count;
    }

    @Override
    public void writeAsHexString(byte[] src) throws IOException {
        this.ensureCapacity((src.length << 1) + 128);
        int count = this.count;
        this.buf[count++] = 34;
        for (byte b : src) {
            count += JSONUnsafe.putShort(this.buf, count, (short)HEX_DIGITS_INT16[b & 0xFF]);
        }
        this.buf[count++] = 34;
        this.count = count;
    }

    void clearCache() {
        if (this.bufCache != null) {
            if (this.buf.length <= MAX_CACHE_BUFFER_SIZE) {
                this.bufCache.cacheBytes = this.buf;
            }
            this.bufCache.inUse = false;
            this.bufCache = null;
        }
    }

    static {
        for (int i = 0; i < CACHE_COUNT; ++i) {
            BufCache bufCache = new BufCache();
            bufCache.index = i;
            if (i < AVAILABLE_PROCESSORS) {
                bufCache.cacheBytes = new byte[CACHE_BUFFER_SIZE];
            }
            JSONByteArrayWriter.BYTE_BUF_CACHES[i] = bufCache;
        }
    }

    private static class BufCache {
        byte[] cacheBytes;
        boolean inUse;
        int index;

        private BufCache() {
        }
    }
}

