/*
 * Decompiled with CFR 0.152.
 */
package io.github.wycst.wast.json;

import io.github.wycst.wast.json.JSONUnsafe;
import java.util.LinkedHashSet;
import java.util.Map;

class JSONKeyValueMap<T> {
    final int capacity;
    final int mask;
    final EntryNode<T>[] valueEntryNodes;
    int count;
    final int maxCount;
    int primeValue;
    boolean collision;
    static final int[] PRIMES = new int[]{5, 7, 11, 13, 17, 19, 23, 29, 31};

    public static <E> JSONKeyValueMap<E> build(Map<String, E> values) {
        return JSONKeyValueMap.build(values, false);
    }

    public static <E> JSONKeyValueMap<E> build(Map<String, E> values, boolean forByte) {
        int size = values.size();
        BihvImpl bhNameValueMap = new BihvImpl(size << 1);
        int capacity = bhNameValueMap.capacity;
        EntryNode[] valueEntryNodes = bhNameValueMap.valueEntryNodes;
        String[] names = values.keySet().toArray(new String[size]);
        long[] hashValues = new long[size];
        int[] remValues = new int[size];
        LinkedHashSet<Integer> remSet = new LinkedHashSet<Integer>();
        for (int bits = 0; bits < 15; ++bits) {
            long hashValue;
            String name;
            int i;
            remSet.clear();
            for (i = 0; i < size; ++i) {
                name = names[i];
                hashValue = JSONKeyValueMap.bitHash(name, bits, forByte);
                int rem = (int)(hashValue & (long)(capacity - 1));
                hashValues[i] = hashValue;
                remValues[i] = rem;
                remSet.add(rem);
            }
            if (remSet.size() != size) continue;
            for (i = 0; i < size; ++i) {
                name = names[i];
                hashValue = hashValues[i];
                E value = values.get(name);
                valueEntryNodes[remValues[i]] = new EntryNode<E>(name.toCharArray(), name.getBytes(), value, hashValue);
            }
            if (bits == 0) {
                return new PlhvImpl(size, capacity, valueEntryNodes);
            }
            bhNameValueMap.bits = bits;
            bhNameValueMap.count = size;
            return bhNameValueMap;
        }
        JSONKeyValueMap<E> dftNameValueMap = new JSONKeyValueMap<E>(size << 1);
        LinkedHashSet<Long> hashValueSet = new LinkedHashSet<Long>();
        int primeValue = 5;
        int[] nArray = PRIMES;
        int value = nArray.length;
        for (int i = 0; i < value; ++i) {
            long hashValue;
            String name;
            int i2;
            int prime;
            primeValue = prime = nArray[i];
            hashValueSet.clear();
            remSet.clear();
            for (i2 = 0; i2 < size; ++i2) {
                name = names[i2];
                hashValue = JSONKeyValueMap.primeHash(name, prime, forByte);
                int rem = (int)(hashValue & (long)(capacity - 1));
                hashValues[i2] = hashValue;
                remValues[i2] = rem;
                hashValueSet.add(hashValue);
                remSet.add(rem);
            }
            if (remSet.size() != size) continue;
            valueEntryNodes = dftNameValueMap.valueEntryNodes;
            dftNameValueMap.primeValue = primeValue;
            for (i2 = 0; i2 < size; ++i2) {
                name = names[i2];
                hashValue = hashValues[i2];
                E value2 = values.get(name);
                valueEntryNodes[remValues[i2]] = new EntryNode<E>(name.toCharArray(), name.getBytes(), value2, hashValue);
            }
            return dftNameValueMap;
        }
        dftNameValueMap.collision = hashValueSet.size() < size;
        dftNameValueMap.primeValue = primeValue;
        for (int i = 0; i < size; ++i) {
            String name = names[i];
            long hashValue = hashValues[i];
            E value3 = values.get(name);
            dftNameValueMap.putValue(name, hashValue, value3);
        }
        return dftNameValueMap;
    }

    public static <E> JSONKeyValueMap<E> build(int mask, long[] hashValues, E[] values) {
        int cap = mask + 1;
        EntryNode[] valueEntryNodes = new EntryNode[cap];
        int len = hashValues.length;
        for (int i = 0; i < len; ++i) {
            long hashValue = hashValues[i];
            valueEntryNodes[(int)(hashValue & (long)mask)] = new EntryNode<E>(null, null, values[i], hashValues[i]);
        }
        return new JSONKeyValueMap(cap, cap, mask, valueEntryNodes);
    }

    public JSONKeyValueMap(int size) {
        if (size > 16384) {
            throw new IllegalArgumentException("too large for size " + size);
        }
        int capacity = JSONKeyValueMap.tableSizeFor(size) << 1;
        if (size > 1) {
            capacity = Math.max(capacity, 16);
        }
        this.maxCount = size;
        this.capacity = capacity;
        this.mask = capacity - 1;
        this.valueEntryNodes = new EntryNode[capacity];
    }

    JSONKeyValueMap(int capacity, EntryNode[] valueEntryNodes) {
        this(capacity << 1, capacity, capacity - 1, valueEntryNodes);
    }

    JSONKeyValueMap(int maxCount, int capacity, int mask, EntryNode[] valueEntryNodes) {
        this.maxCount = maxCount;
        this.capacity = capacity;
        this.mask = mask;
        this.valueEntryNodes = valueEntryNodes;
    }

    public boolean isPlusHash() {
        return false;
    }

    public boolean isBitHash() {
        return false;
    }

    public int getPrimeValue() {
        return this.primeValue;
    }

    public int getBits() {
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putValue(String name, long keyHash, T value) {
        JSONKeyValueMap jSONKeyValueMap = this;
        synchronized (jSONKeyValueMap) {
            if (this.count >= this.maxCount) {
                return;
            }
            ++this.count;
        }
        int index = (int)(keyHash & (long)this.mask);
        EntryNode<T> valueEntryNode = new EntryNode<T>(name.toCharArray(), name.getBytes(), value, keyHash);
        EntryNode<T> oldEntryNode = this.valueEntryNodes[index];
        this.valueEntryNodes[index] = valueEntryNode;
        if (oldEntryNode != null) {
            valueEntryNode.next = oldEntryNode;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putExactHashValue(long hash, T value) {
        JSONKeyValueMap jSONKeyValueMap = this;
        synchronized (jSONKeyValueMap) {
            if (this.count >= this.maxCount) {
                return;
            }
            ++this.count;
        }
        int index = (int)(hash & (long)this.mask);
        EntryNode<T> valueEntryNode = new EntryNode<T>(value, hash);
        EntryNode<T> oldEntryNode = this.valueEntryNodes[index];
        this.valueEntryNodes[index] = valueEntryNode;
        if (oldEntryNode != null) {
            valueEntryNode.next = oldEntryNode;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset() {
        JSONKeyValueMap jSONKeyValueMap = this;
        synchronized (jSONKeyValueMap) {
            this.count = 0;
            for (int i = 0; i < this.capacity; ++i) {
                this.valueEntryNodes[i] = null;
            }
        }
    }

    public final T getValue(String field) {
        char[] buf = field.toCharArray();
        long hashValue = 0L;
        for (char ch : buf) {
            hashValue = this.hash(hashValue, ch);
        }
        return this.getValue(buf, 0, buf.length, hashValue);
    }

    public final T getValue(char[] buf, int beginIndex, int endIndex, long hashValue) {
        int index = (int)(hashValue & (long)this.mask);
        EntryNode<T> entryNode = this.valueEntryNodes[index];
        if (entryNode == null) {
            return null;
        }
        int len = endIndex - beginIndex;
        while (!entryNode.equals(buf, beginIndex, len)) {
            entryNode = entryNode.next;
            if (entryNode != null) continue;
            return null;
        }
        return entryNode.value;
    }

    public final T getValue(byte[] bytes, int beginIndex, int endIndex, long hashValue) {
        int index = (int)(hashValue & (long)this.mask);
        EntryNode<T> entryNode = this.valueEntryNodes[index];
        if (entryNode == null) {
            return null;
        }
        int len = endIndex - beginIndex;
        while (!entryNode.equals(bytes, beginIndex, len)) {
            entryNode = entryNode.next;
            if (entryNode != null) continue;
            return null;
        }
        return entryNode.value;
    }

    public final T getValueByHash(long hashValue) {
        int index = (int)(hashValue & (long)this.mask);
        EntryNode<T> entryNode = this.valueEntryNodes[index];
        if (entryNode != null && entryNode.hash == hashValue) {
            return entryNode.value;
        }
        if (entryNode != null) {
            entryNode = entryNode.next;
            while (entryNode != null) {
                if (entryNode.hash == hashValue) {
                    return entryNode.value;
                }
                entryNode = entryNode.next;
            }
        }
        return null;
    }

    public boolean isCollision() {
        return this.collision;
    }

    public long hash(long hv, int c1, int c2) {
        hv = this.hash(hv, c1);
        return this.hash(hv, c2);
    }

    private static int tableSizeFor(int cap) {
        int bits = 31 - Integer.numberOfLeadingZeros(cap);
        int n = 1 << bits;
        return n == cap ? n : n << 1;
    }

    public long hash(long rv, int c) {
        return rv * (long)this.primeValue + (long)c;
    }

    static final long bitHash(String name, int bits, boolean forByte) {
        long val = 0L;
        if (forByte) {
            byte[] bytes = name.getBytes();
            int len = bytes.length;
            for (int i = 0; i < len; ++i) {
                val = (val << bits) + (long)bytes[i];
            }
        } else {
            for (int i = 0; i < name.length(); ++i) {
                val = (val << bits) + (long)name.charAt(i);
            }
        }
        return val;
    }

    static final long primeHash(String name, int primeValue, boolean forByte) {
        long val = 0L;
        if (forByte) {
            byte[] bytes = name.getBytes();
            int len = bytes.length;
            for (int i = 0; i < len; ++i) {
                val = val * (long)primeValue + (long)bytes[i];
            }
        } else {
            for (int i = 0; i < name.length(); ++i) {
                val = val * (long)primeValue + (long)name.charAt(i);
            }
        }
        return val;
    }

    static final class PlhvImpl<E>
    extends JSONKeyValueMap {
        public PlhvImpl(int count, int capacity, EntryNode[] valueEntryNodes) {
            super(capacity, valueEntryNodes);
            this.count = count;
        }

        @Override
        public long hash(long rv, int c) {
            return rv + (long)c;
        }

        @Override
        public long hash(long rv, int c1, int c2) {
            return rv + (long)c1 + (long)c2;
        }

        @Override
        public boolean isPlusHash() {
            return true;
        }
    }

    static final class BihvImpl<E>
    extends JSONKeyValueMap {
        private int bits;

        public BihvImpl(int size) {
            super(size);
        }

        @Override
        public long hash(long rv, int c) {
            return (rv << this.bits) + (long)c;
        }

        @Override
        public boolean isBitHash() {
            return true;
        }

        @Override
        public int getBits() {
            return this.bits;
        }
    }

    static class EntryNode<T> {
        long hash;
        char[] chars;
        byte[] bytes;
        long remCharsValue;
        long remBytesValue;
        T value;
        EntryNode<T> next;

        public EntryNode(T value, long keyHash) {
            this.hash = keyHash;
            this.value = value;
        }

        public EntryNode(char[] chars, byte[] bytes, T value, long keyHash) {
            this.chars = chars;
            this.bytes = bytes;
            this.hash = keyHash;
            this.value = value;
            int charLen = chars.length;
            int remChars = charLen & 3;
            long remValueForChars = 0L;
            switch (remChars) {
                case 1: {
                    remValueForChars = chars[charLen - 1];
                    break;
                }
                case 2: 
                case 3: {
                    remValueForChars = JSONUnsafe.getInt(chars, charLen - 2);
                }
            }
            this.remCharsValue = remValueForChars;
            int byteLen = bytes.length;
            int remBytes = charLen & 3;
            long remValueForBytes = 0L;
            switch (remBytes) {
                case 1: {
                    remValueForBytes = bytes[byteLen - 1];
                    break;
                }
                case 2: 
                case 3: {
                    remValueForBytes = JSONUnsafe.getShort(bytes, byteLen - 2);
                }
            }
            this.remBytesValue = remValueForBytes;
        }

        public final boolean equals(char[] buf, int offset, int len) {
            return len == this.chars.length && JSONUnsafe.equals(buf, offset, this.chars, 0, len, this.remCharsValue);
        }

        public final boolean equals(byte[] buf, int offset, int len) {
            return len == this.bytes.length && JSONUnsafe.equals(buf, offset, this.bytes, 0, len, this.remBytesValue);
        }
    }
}

