/*
 * Decompiled with CFR 0.152.
 */
package io.github.wycst.wast.json;

import io.github.wycst.wast.common.reflect.GenericParameterizedType;
import io.github.wycst.wast.common.reflect.ReflectConsts;
import io.github.wycst.wast.common.reflect.SetterInfo;
import io.github.wycst.wast.json.CharSource;
import io.github.wycst.wast.json.JSONParseContext;
import io.github.wycst.wast.json.JSONTypeDeserializer;
import io.github.wycst.wast.json.annotations.JsonDeserialize;
import io.github.wycst.wast.json.annotations.JsonProperty;
import io.github.wycst.wast.json.custom.JsonDeserializer;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public final class JSONPojoFieldDeserializer
extends JSONTypeDeserializer
implements Comparable<JSONPojoFieldDeserializer> {
    final String name;
    final int fieldIndex;
    final SetterInfo setterInfo;
    final JsonProperty jsonProperty;
    GenericParameterizedType genericParameterizedType;
    final ReflectConsts.ClassCategory classCategory;
    Class<?> implClass;
    JSONTypeDeserializer deserializer;
    boolean customDeserialize = false;
    final String pattern;
    final String timezone;
    boolean initialized;
    private static final Map<Class<? extends JsonDeserializer>, JsonDeserializer> customDeserializers = new ConcurrentHashMap<Class<? extends JsonDeserializer>, JsonDeserializer>();
    private boolean priority;

    JSONPojoFieldDeserializer(String name, SetterInfo setterInfo, JsonProperty jsonProperty) {
        this.name = name;
        this.setterInfo = setterInfo;
        this.fieldIndex = setterInfo.getIndex();
        this.jsonProperty = jsonProperty;
        this.genericParameterizedType = setterInfo.getGenericParameterizedType();
        Class<?> actualClass = this.genericParameterizedType.getActualType();
        this.classCategory = ReflectConsts.getClassCategory(actualClass);
        String pattern = null;
        String timezone = null;
        if (jsonProperty != null) {
            pattern = jsonProperty.pattern().trim();
            timezone = jsonProperty.timezone().trim();
            if (pattern.length() == 0) {
                pattern = null;
            }
            if (timezone.length() == 0) {
                timezone = null;
            }
        }
        this.pattern = pattern;
        this.timezone = timezone;
    }

    void initDeserializer() {
        if (!this.initialized) {
            boolean unfixedType = false;
            if (this.jsonProperty != null) {
                Class<?> impl = this.jsonProperty.impl();
                if (impl != Object.class && this.isAvailableImpl(impl)) {
                    this.implClass = impl;
                }
                unfixedType = this.jsonProperty.unfixedType();
            }
            if (this.implClass != null) {
                this.deserializer = JSONPojoFieldDeserializer.getTypeDeserializer(this.implClass);
                this.genericParameterizedType = GenericParameterizedType.actualType(this.implClass);
            } else {
                this.deserializer = this.setterInfo.isNonInstanceType() ? JSONPojoFieldDeserializer.getCachedTypeDeserializer(this.genericParameterizedType.getActualType()) : (this.genericParameterizedType.getActualClassCategory() == ReflectConsts.ClassCategory.ObjectCategory && unfixedType ? null : this.getDeserializer(this.genericParameterizedType));
            }
            this.initialized = true;
        }
    }

    private JSONTypeDeserializer getDeserializer(GenericParameterizedType genericParameterizedType) {
        JsonDeserialize jsonDeserialize = (JsonDeserialize)this.setterInfo.getAnnotation(JsonDeserialize.class);
        if (jsonDeserialize != null) {
            Class<? extends JsonDeserializer> jsonDeserializerClass = jsonDeserialize.value();
            this.customDeserialize = true;
            try {
                if (jsonDeserialize.singleton()) {
                    JsonDeserializer jsonDeserializer = customDeserializers.get(jsonDeserializerClass);
                    if (jsonDeserializer == null) {
                        jsonDeserializer = jsonDeserializerClass.newInstance();
                        customDeserializers.put(jsonDeserializerClass, jsonDeserializer);
                    }
                    return jsonDeserializer;
                }
                return jsonDeserializerClass.newInstance();
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
        return JSONTypeDeserializer.getFieldDeserializer(genericParameterizedType, this.jsonProperty);
    }

    public String getName() {
        return this.name;
    }

    public boolean isCustomDeserialize() {
        return this.customDeserialize;
    }

    @Override
    protected Object deserialize(CharSource charSource, char[] buf, int fromIndex, int toIndex, GenericParameterizedType parameterizedType, Object defaultValue, char endToken, JSONParseContext jsonParseContext) throws Exception {
        throw new UnsupportedOperationException();
    }

    @Override
    protected Object deserialize(CharSource charSource, byte[] buf, int fromIndex, int toIndex, GenericParameterizedType parameterizedType, Object defaultValue, byte endToken, JSONParseContext jsonParseContext) throws Exception {
        throw new UnsupportedOperationException();
    }

    Object getDefaultFieldValue(Object instance) {
        return JSON_SECURE_TRUSTED_ACCESS.getSetterDefault(this.setterInfo, instance);
    }

    public int getIndex() {
        return this.setterInfo.getIndex();
    }

    public Class<?> getImplClass() {
        return this.implClass;
    }

    public boolean isAvailableImpl(Class<?> cls) {
        boolean assignableFrom = this.genericParameterizedType.getActualType().isAssignableFrom(cls);
        if (!assignableFrom) {
            return false;
        }
        switch (this.classCategory) {
            case MapCategory: 
            case CollectionCategory: 
            case ObjectCategory: {
                return true;
            }
        }
        return false;
    }

    public boolean isInstance(Object value) {
        return value == null || this.genericParameterizedType.getActualType().isInstance(value);
    }

    public void setPriority(boolean priority) {
        this.priority = priority;
    }

    @Override
    public int compareTo(JSONPojoFieldDeserializer o) {
        if (this.setterInfo != o.setterInfo) {
            return -1;
        }
        return this.priority ? 1 : 0;
    }
}

