/*
 * Decompiled with CFR 0.152.
 */
package io.github.wycst.wast.json;

import io.github.wycst.wast.json.JSONGeneral;
import io.github.wycst.wast.json.JSONUnsafe;
import io.github.wycst.wast.json.JSONWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.math.BigInteger;
import java.util.UUID;

class JSONWrapWriter
extends JSONWriter {
    final Writer writer;

    JSONWrapWriter(Writer writer) {
        this.writer = writer;
    }

    public static JSONWrapWriter wrap(Writer writer) {
        return new JSONWrapWriter(writer);
    }

    @Override
    public String toString() {
        throw new UnsupportedOperationException();
    }

    @Override
    StringBuffer toStringBuffer() {
        throw new UnsupportedOperationException();
    }

    @Override
    StringBuilder toStringBuilder() {
        throw new UnsupportedOperationException();
    }

    @Override
    protected void toOutputStream(OutputStream os) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void writeShortChars(char[] chars, int offset, int len) throws IOException {
        this.write(chars, offset, len);
    }

    @Override
    public void writeLong(long numValue) throws IOException {
        if (numValue == 0L) {
            this.writer.write(48);
            return;
        }
        if (numValue < 0L) {
            if (numValue == Long.MIN_VALUE) {
                this.writer.write("-9223372036854775808");
                return;
            }
            numValue = -numValue;
            this.writer.write(45);
        }
        char[] buf = JSONGeneral.CACHED_CHARS_36.get();
        int count = JSONWrapWriter.writeInteger(numValue, buf, 0);
        this.writer.write(buf, 0, count);
    }

    @Override
    public void writeUUID(UUID uuid) throws IOException {
        char[] buf = JSONGeneral.CACHED_CHARS_36.get();
        JSONWrapWriter.writeUUID(uuid, buf, 0);
        this.writer.write(34);
        this.writer.write(buf, 0, 36);
        this.writer.write(34);
    }

    @Override
    public void writeDouble(double numValue) throws IOException {
        char[] chars = JSONGeneral.CACHED_CHARS_36.get();
        int len = JSONWrapWriter.writeDouble(numValue, chars, 0);
        this.writer.write(chars, 0, len);
    }

    @Override
    public void writeFloat(float numValue) throws IOException {
        char[] chars = JSONGeneral.CACHED_CHARS_36.get();
        int len = JSONWrapWriter.writeFloat(numValue, chars, 0);
        this.writer.write(chars, 0, len);
    }

    @Override
    public void writeJSONLocalDateTime(int year, int month, int day, int hour, int minute, int second, int nano, String zoneId) throws IOException {
        char[] buf = JSONGeneral.CACHED_CHARS_36.get();
        int off = 0;
        buf[off++] = 34;
        if (year < 0) {
            buf[off++] = 45;
            year = -year;
        }
        off = year < 10000 ? (off += JSONUnsafe.putLong(buf, off, FOUR_DIGITS_64_BITS[year])) : (off += JSONWrapWriter.writeInteger((long)year, buf, off));
        off += JSONUnsafe.putLong(buf, off, 0x2D000000000000L | (long)TWO_DIGITS_32_BITS[month] << 16 | 0x2DL);
        off += JSONUnsafe.putInt(buf, off, TWO_DIGITS_32_BITS[day]);
        off += JSONUnsafe.putLong(buf, off, JSONWrapWriter.mergeInt64(hour, 'T', ':'));
        off += JSONUnsafe.putInt(buf, off, TWO_DIGITS_32_BITS[minute]);
        buf[off++] = 58;
        off += JSONUnsafe.putInt(buf, off, TWO_DIGITS_32_BITS[second]);
        if (nano > 0) {
            off = JSONWrapWriter.writeNano(nano, buf, off);
        }
        if (zoneId.length() == 1) {
            off += JSONUnsafe.putInt(buf, off, Z_QUOT_INT);
            this.writer.write(buf, 0, off);
        } else {
            this.writer.write(buf, 0, off);
            this.writeZoneId(zoneId);
            this.writer.write(34);
        }
    }

    @Override
    public void writeJSONLocalDate(int year, int month, int day) throws IOException {
        char[] buf = JSONGeneral.CACHED_CHARS_36.get();
        int off = 0;
        buf[off++] = 34;
        if (year < 0) {
            buf[off++] = 45;
            year = -year;
        }
        off = year < 10000 ? (off += JSONUnsafe.putLong(buf, off, FOUR_DIGITS_64_BITS[year])) : (off += JSONWrapWriter.writeInteger((long)year, buf, off));
        off += JSONUnsafe.putLong(buf, off, 0x2D000000000000L | (long)TWO_DIGITS_32_BITS[month] << 16 | 0x2DL);
        off += JSONUnsafe.putInt(buf, off, TWO_DIGITS_32_BITS[day]);
        buf[off++] = 34;
        this.writer.write(buf, 0, off);
    }

    @Override
    public void writeTime(int hourOfDay, int minute, int second) throws IOException {
        char[] buf = JSONGeneral.CACHED_CHARS_36.get();
        int off = 0;
        off += JSONUnsafe.putInt(buf, off, TWO_DIGITS_32_BITS[hourOfDay]);
        off += JSONUnsafe.putLong(buf, off, JSONWrapWriter.mergeInt64(minute, ':', ':'));
        off += JSONUnsafe.putInt(buf, off, TWO_DIGITS_32_BITS[second]);
        this.writer.write(buf, 0, off);
    }

    @Override
    public void writeJSONTimeWithNano(int hourOfDay, int minute, int second, int nano) throws IOException {
        char[] buf = JSONGeneral.CACHED_CHARS_36.get();
        int off = 0;
        buf[off++] = 34;
        off += JSONUnsafe.putInt(buf, off, TWO_DIGITS_32_BITS[hourOfDay]);
        off += JSONUnsafe.putLong(buf, off, JSONWrapWriter.mergeInt64(minute, ':', ':'));
        off += JSONUnsafe.putInt(buf, off, TWO_DIGITS_32_BITS[second]);
        if (nano > 0) {
            off = JSONWrapWriter.writeNano(nano, buf, off);
        }
        buf[off++] = 34;
        this.writer.write(buf, 0, off);
    }

    @Override
    public void writeDate(int year, int month, int day, int hourOfDay, int minute, int second) throws IOException {
        char[] buf = JSONGeneral.CACHED_CHARS_36.get();
        int off = 0;
        if (year < 0) {
            buf[off++] = 45;
            year = -year;
        }
        off = year < 10000 ? (off += JSONUnsafe.putLong(buf, off, FOUR_DIGITS_64_BITS[year])) : (off += JSONWrapWriter.writeInteger((long)year, buf, off));
        off += JSONUnsafe.putLong(buf, off, JSONWrapWriter.mergeInt64(month, '-', '-'));
        off += JSONUnsafe.putInt(buf, off, TWO_DIGITS_32_BITS[day]);
        off += JSONUnsafe.putLong(buf, off, JSONWrapWriter.mergeInt64(hourOfDay, ' ', ':'));
        off += JSONUnsafe.putInt(buf, off, TWO_DIGITS_32_BITS[minute]);
        buf[off++] = 58;
        off += JSONUnsafe.putInt(buf, off, TWO_DIGITS_32_BITS[second]);
        this.writer.write(buf, 0, off);
    }

    @Override
    public void writeBigInteger(BigInteger bigInteger) throws IOException {
        int increment = (bigInteger.bitLength() / 60 + 1) * 18;
        char[] chars = new char[increment];
        int len = JSONWrapWriter.writeBigInteger(bigInteger, chars, 0);
        this.writer.write(chars, 0, len);
    }

    @Override
    public void write(int c) throws IOException {
        this.writer.write(c);
    }

    @Override
    public Writer append(char c) throws IOException {
        return this.writer.append(c);
    }

    @Override
    public void write(char[] cbuf) throws IOException {
        this.writer.write(cbuf);
    }

    @Override
    public void write(String str) throws IOException {
        this.writer.write(str);
    }

    @Override
    public void write(String str, int off, int len) throws IOException {
        this.writer.write(str, off, len);
    }

    @Override
    public void write(char[] cbuf, int off, int len) throws IOException {
        this.writer.write(cbuf, off, len);
    }

    @Override
    public void flush() throws IOException {
        this.writer.flush();
    }

    @Override
    public void close() throws IOException {
        this.writer.close();
    }
}

