/*
 * Decompiled with CFR 0.152.
 */
package io.github.wycst.wast.log;

import io.github.wycst.wast.log.ConsoleFormatter;
import io.github.wycst.wast.log.ConsoleHandler;
import io.github.wycst.wast.log.FileHandlerHolder;
import io.github.wycst.wast.log.LogFactory;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.FileHandler;
import java.util.logging.Handler;
import java.util.logging.Level;

public class LoggerManagerHandler {
    private static final Map<String, String> LOGGER_PROPERTIES = new HashMap<String, String>();
    private static final String LEVEL_KEY = "logger.level";
    private static Level level;
    private static Map<String, FileHandlerHolder> fileHandlerHolders;
    private static Map<String, Level> levelMap;
    private static ConsoleHandler consoleHandler;
    private static String consolePackages;

    static void init() {
        InputStream is = LogFactory.class.getResourceAsStream("/logging.properties");
        if (is != null) {
            Properties properties = new Properties();
            try {
                properties.load(is);
                LOGGER_PROPERTIES.putAll(properties);
                LoggerManagerHandler.parseLoggerHandlers();
            }
            catch (IOException iOException) {}
        } else {
            LoggerManagerHandler.parseLoggerHandlers();
        }
    }

    static void setConsoleLevel(Level level) {
        consoleHandler.setLevel(level);
    }

    private static void parseLoggerHandlers() {
        LoggerManagerHandler.setConsoleHandler();
        LoggerManagerHandler.setFileHandlers();
        LoggerManagerHandler.initLevelMap();
    }

    private static synchronized void setConsoleHandler() {
        if (consoleHandler == null) {
            consoleHandler = new ConsoleHandler();
            consoleHandler.setFormatter(new ConsoleFormatter());
        }
        consolePackages = LOGGER_PROPERTIES.get("logger.console.packages");
        Level consoleLevel = LoggerManagerHandler.getLevel(LOGGER_PROPERTIES.get("logger.console.level"), null);
        if (consoleLevel != null) {
            consoleHandler.setLevel(consoleLevel);
        }
    }

    private static void setFileHandlers() {
        fileHandlerHolders.clear();
        String loggerFileHandlers = LOGGER_PROPERTIES.get("logger.file.handlers");
        if (loggerFileHandlers != null) {
            String[] fileHandleNames = loggerFileHandlers.split(",");
            for (String fileHandleName : new HashSet<String>(Arrays.asList(fileHandleNames))) {
                String handlerPackages = LOGGER_PROPERTIES.get("logger.handler." + fileHandleName + ".packages");
                String handlerPattern = LOGGER_PROPERTIES.get("logger.handler." + fileHandleName + ".pattern");
                int limit = LoggerManagerHandler.getInt(LOGGER_PROPERTIES.get("logger.handler." + fileHandleName + ".limit"), Integer.MAX_VALUE);
                int count = LoggerManagerHandler.getInt(LOGGER_PROPERTIES.get("logger.handler." + fileHandleName + ".count"), 1);
                Level level = LoggerManagerHandler.getLevel(LOGGER_PROPERTIES.get("logger.handler." + fileHandleName + ".level"), null);
                if (handlerPattern == null) continue;
                try {
                    FileHandlerHolder fileHandlerHolder = new FileHandlerHolder(fileHandleName, handlerPattern, limit, count);
                    if (level != null) {
                        fileHandlerHolder.setLevel(level);
                    }
                    fileHandlerHolder.setPackages(handlerPackages);
                    fileHandlerHolders.put(fileHandleName, fileHandlerHolder);
                }
                catch (IOException iOException) {}
            }
        }
    }

    private static synchronized void initLevelMap() {
        levelMap.clear();
        for (String key : LOGGER_PROPERTIES.keySet()) {
            if (!key.endsWith(".level")) continue;
            String customPackageLevel = key.substring(0, key.length() - 6);
            Level level = LoggerManagerHandler.getLevel(LOGGER_PROPERTIES.get(key), null);
            if (level == null) continue;
            levelMap.put(customPackageLevel, level);
        }
    }

    static List<Handler> matchHandlers(Class<?> logCls) {
        ArrayList<Handler> fileHandlers = new ArrayList<Handler>();
        String logClassName = logCls.getName();
        if (LoggerManagerHandler.matchPackages(logClassName, consolePackages) && consoleHandler != null) {
            fileHandlers.add(consoleHandler);
        }
        for (FileHandlerHolder fileHandlerHolder : fileHandlerHolders.values()) {
            FileHandler fileHandler = fileHandlerHolder.getFileHandler();
            String packages = fileHandlerHolder.getPackages();
            if (!LoggerManagerHandler.matchPackages(logClassName, packages)) continue;
            fileHandlers.add(fileHandler);
        }
        return fileHandlers;
    }

    static Level matchLevel(Class<?> logCls) {
        String logClassName = logCls.getName();
        for (String pk : levelMap.keySet()) {
            if (!logClassName.startsWith(pk) && !logClassName.matches(pk)) continue;
            return levelMap.get(pk);
        }
        return null;
    }

    private static boolean matchPackages(String logClassName, String packages) {
        String[] pcks;
        if (packages == null || packages.length() == 0) {
            return true;
        }
        for (String pck : pcks = packages.split(",")) {
            if (!logClassName.startsWith(pck)) continue;
            return true;
        }
        return false;
    }

    private static Level getLevel(String levelName, Level level) {
        if (levelName == null || levelName.length() == 0) {
            return level;
        }
        return Level.parse(levelName);
    }

    private static int getInt(String value, int i) {
        try {
            return Integer.parseInt(value);
        }
        catch (Throwable throwable) {
            return i;
        }
    }

    public static void putAll(Map<String, String> logProps) {
        if (logProps != null) {
            LOGGER_PROPERTIES.putAll(logProps);
            LoggerManagerHandler.parseLoggerHandlers();
        }
    }

    static Set<String> logKeySet() {
        return LOGGER_PROPERTIES.keySet();
    }

    static void putLogProperty(String key, String value) {
        LOGGER_PROPERTIES.put(key, value);
    }

    static String getLogProperty(String key) {
        return LOGGER_PROPERTIES.get(key);
    }

    public static void clear() {
        LOGGER_PROPERTIES.clear();
        levelMap.clear();
        for (FileHandlerHolder handlerHolder : fileHandlerHolders.values()) {
            handlerHolder.clear();
        }
        fileHandlerHolders.clear();
    }

    public static Level getLogLevel() {
        String levelName = LOGGER_PROPERTIES.get(LEVEL_KEY);
        if (levelName == null) {
            return null;
        }
        if (level != null && levelName.equals(level.getName())) {
            return level;
        }
        try {
            level = Level.parse(levelName);
            return level;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return null;
        }
    }

    static {
        fileHandlerHolders = new ConcurrentHashMap<String, FileHandlerHolder>();
        levelMap = new HashMap<String, Level>();
    }
}

