/*
 * Decompiled with CFR 0.152.
 */
package io.github.wycst.wast.clients.http;

import io.github.wycst.wast.clients.http.definition.HttpClientRequest;
import io.github.wycst.wast.clients.http.definition.HttpClientResponse;
import io.github.wycst.wast.clients.http.executor.HttpClientExecutor;
import io.github.wycst.wast.clients.http.provider.ServiceProvider;
import io.github.wycst.wast.clients.http.url.UrlHttpClientExecutor;
import java.io.InputStream;
import java.util.Map;

class AbstractHttpClient {
    private HttpClientExecutor httpClientExecutor;

    public AbstractHttpClient() {
        this(new UrlHttpClientExecutor());
    }

    public AbstractHttpClient(HttpClientExecutor httpClientExecutor) {
        this.httpClientExecutor = httpClientExecutor;
    }

    public void setServiceProvider(ServiceProvider serviceProvider) {
        this.httpClientExecutor.setServiceProvider(serviceProvider);
    }

    public ServiceProvider getServiceProvider() {
        return this.httpClientExecutor.getServiceProvider();
    }

    public void setEnableLoadBalance(boolean enableLoadBalance) {
        this.httpClientExecutor.setEnableLoadBalance(enableLoadBalance);
    }

    public void setKeepAliveOnTimeout(boolean keepAliveOnTimeout) {
        this.httpClientExecutor.setKeepAliveOnTimeout(keepAliveOnTimeout);
    }

    public HttpClientResponse executeRequest(HttpClientRequest httpRequest) {
        return this.httpClientExecutor.executeRequest(httpRequest);
    }

    public final byte[] download(String url) {
        return this.httpClientExecutor.fastGetBody(url, null);
    }

    public final byte[] download(String url, Map<String, String> headers) {
        return this.httpClientExecutor.fastGetBody(url, headers);
    }

    public final InputStream downloadInputStream(String url, Map<String, String> headers) {
        return this.httpClientExecutor.fastGetInputStream(url, headers);
    }
}

