/*
 * Decompiled with CFR 0.152.
 */
package io.github.wycst.wast.common.beans.geo;

import io.github.wycst.wast.common.beans.geo.AbstractMultiGeometry;
import io.github.wycst.wast.common.beans.geo.GeometryContext;
import io.github.wycst.wast.common.beans.geo.GeometryType;
import io.github.wycst.wast.common.beans.geo.LineString;
import java.util.ArrayList;
import java.util.List;

public class MultiLineString
extends AbstractMultiGeometry {
    private List<LineString> elements = new ArrayList<LineString>();

    public MultiLineString() {
        super(GeometryType.MULTILINESTRING);
    }

    public void add(LineString lineString) {
        this.elements.add(lineString);
    }

    public void addAll(LineString ... lineStringList) {
        for (LineString lineString : lineStringList) {
            this.elements.add(lineString);
        }
    }

    public void addAll(List<LineString> lineStringList) {
        this.elements.addAll(lineStringList);
    }

    public LineString removeAt(int index) {
        return this.elements.remove(index);
    }

    public boolean remove(LineString lineString) {
        return this.elements.remove(lineString);
    }

    public void clear() {
        this.elements.clear();
    }

    @Override
    void appendBody(StringBuilder builder) {
        builder.append("(");
        int deleteDotIndex = -1;
        for (LineString lineString : this.elements) {
            lineString.appendBody(builder);
            builder.append(",");
            deleteDotIndex = builder.length() - 1;
        }
        if (deleteDotIndex > -1) {
            builder.deleteCharAt(deleteDotIndex);
        }
        builder.append(")");
    }

    @Override
    protected void readElement(char[] chars, GeometryContext geometryContext) {
        this.elements.add(new LineString(MultiLineString.readPoints(chars, geometryContext)));
    }

    public List<LineString> getElements() {
        return this.elements;
    }

    public void setElements(List<LineString> elements) {
        this.elements = elements;
    }
}

