/*
 * Decompiled with CFR 0.152.
 */
package io.github.wycst.wast.common.expression;

import io.github.wycst.wast.common.expression.ElInvoker;
import io.github.wycst.wast.common.expression.ElVariableInvoker;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;

public class ElChainVariableInvoker
implements ElInvoker {
    final ElVariableInvoker variableInvoke;
    ElChainVariableInvoker next;

    ElChainVariableInvoker(ElVariableInvoker variableInvoke) {
        this.variableInvoke = variableInvoke;
    }

    @Override
    public Object invokeDirect(Object context) {
        throw new UnsupportedOperationException("chain invoker is not supported");
    }

    @Override
    public Object invokeDirect(Map context) {
        throw new UnsupportedOperationException("chain invoker is not supported");
    }

    @Override
    public Object invoke(Object entityContext, Object[] variableValues) {
        try {
            this.variableInvoke.invoke(entityContext, variableValues);
        }
        catch (RuntimeException runtimeException) {
            throw new IllegalArgumentException(String.format("Unresolved field '%s', reason: %s", this.variableInvoke.toString(), runtimeException.getMessage()));
        }
        return this.next.invoke(entityContext, variableValues);
    }

    @Override
    public Object invoke(Map mapContext, Object[] variableValues) {
        try {
            this.variableInvoke.invoke(mapContext, variableValues);
        }
        catch (RuntimeException runtimeException) {
            throw new IllegalArgumentException(String.format("Unresolved field '%s', reason: %s", this.variableInvoke.toString(), runtimeException.getMessage()));
        }
        return this.next.invoke(mapContext, variableValues);
    }

    @Override
    public Object invokeCurrent(Map globalContext, Object parentContext, Object[] variableValues) {
        try {
            this.variableInvoke.invokeCurrent(globalContext, parentContext, variableValues);
        }
        catch (RuntimeException runtimeException) {
            throw new IllegalArgumentException(String.format("Unresolved field '%s', reason: %s", this.variableInvoke.toString(), runtimeException.getMessage()));
        }
        return this.next.invokeCurrent(globalContext, parentContext, variableValues);
    }

    @Override
    public Object invokeCurrent(Object globalContext, Object parentContext, Object[] variableValues) {
        try {
            this.variableInvoke.invokeCurrent(globalContext, parentContext, variableValues);
        }
        catch (RuntimeException runtimeException) {
            throw new IllegalArgumentException(String.format("Unresolved field '%s', reason: %s", this.variableInvoke.toString(), runtimeException.getMessage()));
        }
        return this.next.invokeCurrent(globalContext, parentContext, variableValues);
    }

    @Override
    public void internKey() {
        this.variableInvoke.internKey();
        if (this.next != null) {
            this.next.internKey();
        }
    }

    @Override
    public int size() {
        return this.next == null ? 1 : 1 + this.next.size();
    }

    public static final ElInvoker build(Map<String, ElVariableInvoker> variableInvokes) {
        return ElChainVariableInvoker.build(variableInvokes, false);
    }

    public static final ElInvoker build(Map<String, ElVariableInvoker> variableInvokes, boolean indexVariable) {
        Collection<ElVariableInvoker> collection = variableInvokes.values();
        int length = collection.size();
        int index = 0;
        boolean onlyOne = length == 1;
        ElChainVariableInvoker head = null;
        ElChainVariableInvoker prev = null;
        for (ElVariableInvoker variableInvoke : collection) {
            ElChainVariableInvoker node;
            if (indexVariable) {
                variableInvoke.setIndex(index);
            }
            if (onlyOne) {
                return variableInvoke;
            }
            boolean tail = ++index == length;
            ElChainVariableInvoker elChainVariableInvoker = node = tail ? new TailVariableInvoke(variableInvoke) : new ElChainVariableInvoker(variableInvoke);
            if (head == null) {
                head = node;
            } else {
                prev.next = node;
            }
            prev = node;
        }
        return head;
    }

    public static final ElInvoker buildTailChainInvoker(Map<String, ElVariableInvoker> tailInvokerMap) {
        Collection<ElVariableInvoker> tailInvokerValues = tailInvokerMap.values();
        ArrayList<ElVariableInvoker> leafTailValues = new ArrayList<ElVariableInvoker>();
        for (ElVariableInvoker variableInvoke : tailInvokerValues) {
            if (variableInvoke.hasChildren) continue;
            leafTailValues.add(variableInvoke);
        }
        int length = leafTailValues.size();
        if (length == 1) {
            return (ElInvoker)leafTailValues.get(0);
        }
        int index = 0;
        ElChainVariableInvoker head = null;
        ElChainVariableInvoker prev = null;
        for (ElVariableInvoker variableInvoke : leafTailValues) {
            ElChainVariableInvoker node;
            boolean tail = ++index == length;
            ElChainVariableInvoker elChainVariableInvoker = node = tail ? new TailVariableInvoke(variableInvoke) : new ElChainVariableInvoker(variableInvoke);
            if (head == null) {
                head = node;
            } else {
                prev.next = node;
            }
            prev = node;
        }
        return head;
    }

    static class TailVariableInvoke
    extends ElChainVariableInvoker {
        TailVariableInvoke(ElVariableInvoker variableInvoke) {
            super(variableInvoke);
        }

        @Override
        public Object invoke(Object entityContext, Object[] variableValues) {
            try {
                return this.variableInvoke.invoke(entityContext, variableValues);
            }
            catch (RuntimeException runtimeException) {
                throw new IllegalArgumentException(String.format("Unresolved field '%s', reason: %s", this.variableInvoke.toString(), runtimeException.getMessage()));
            }
        }

        @Override
        public Object invoke(Map mapContext, Object[] variableValues) {
            try {
                return this.variableInvoke.invoke(mapContext, variableValues);
            }
            catch (RuntimeException runtimeException) {
                throw new IllegalArgumentException(String.format("Unresolved field '%s', reason: %s", this.variableInvoke.toString(), runtimeException.getMessage()));
            }
        }

        @Override
        public Object invokeCurrent(Map globalContext, Object parentContext, Object[] variableValues) {
            try {
                return this.variableInvoke.invokeCurrent(globalContext, parentContext, variableValues);
            }
            catch (RuntimeException runtimeException) {
                throw new IllegalArgumentException(String.format("Unresolved field '%s', reason: %s", this.variableInvoke.toString(), runtimeException.getMessage()));
            }
        }

        @Override
        public Object invokeCurrent(Object globalContext, Object parentContext, Object[] variableValues) {
            try {
                return this.variableInvoke.invokeCurrent(globalContext, parentContext, variableValues);
            }
            catch (RuntimeException runtimeException) {
                throw new IllegalArgumentException(String.format("Unresolved field '%s', reason: %s", this.variableInvoke.toString(), runtimeException.getMessage()));
            }
        }
    }
}

