/*
 * Decompiled with CFR 0.152.
 */
package io.github.wycst.wast.common.expression;

import io.github.wycst.wast.common.expression.ElInvoker;
import io.github.wycst.wast.common.expression.Expression;
import io.github.wycst.wast.common.reflect.ClassStructureWrapper;
import io.github.wycst.wast.common.reflect.GetterInfo;
import io.github.wycst.wast.common.reflect.ReflectConsts;
import io.github.wycst.wast.common.utils.CollectionUtils;
import io.github.wycst.wast.common.utils.ObjectUtils;
import java.util.Map;

public class ElVariableInvoker
implements ElInvoker {
    String key;
    ValueInvokeHolder invokeHolder = ValueInvokeHolder.Empty;
    int index;
    ElVariableInvoker parent;
    boolean tail;
    boolean hasChildren;

    ElVariableInvoker(String key) {
        this.key = key;
    }

    ElVariableInvoker(String key, ElVariableInvoker parent) {
        parent.getClass();
        this.key = key;
        this.parent = parent;
    }

    public String toString() {
        return this.parent.toString() + "." + this.key;
    }

    public ElVariableInvoker getParent() {
        return this.parent;
    }

    public String getKey() {
        return this.key;
    }

    @Override
    public Object invokeDirect(Object context) {
        Object target = this.parent.invokeDirect(context);
        return this.invokeValue(target);
    }

    @Override
    public Object invokeDirect(Map context) {
        Object target = this.parent.invokeDirect(context);
        return this.invokeValue(target);
    }

    @Override
    public Object invoke(Object entityContext, Object[] variableValues) {
        Object value = variableValues[this.index];
        if (value != null) {
            return value;
        }
        Object target = this.parent.invoke(entityContext, variableValues);
        variableValues[this.index] = this.invokeValue(target);
        return variableValues[this.index];
    }

    @Override
    public Object invoke(Map mapContext, Object[] variableValues) {
        Object value = variableValues[this.index];
        if (value != null) {
            return value;
        }
        Object target = this.parent.invoke(mapContext, variableValues);
        variableValues[this.index] = this.invokeValue(target);
        return variableValues[this.index];
    }

    @Override
    public Object invokeCurrent(Map globalContext, Object parentContext, Object[] variableValues) {
        variableValues[this.index] = this.invokeValue(parentContext);
        return variableValues[this.index];
    }

    @Override
    public Object invokeCurrent(Object globalContext, Object parentContext, Object[] variableValues) {
        variableValues[this.index] = this.invokeValue(parentContext);
        return variableValues[this.index];
    }

    public Object invokeCurrent(Object globalContext, Object context) {
        return this.invokeValue(context);
    }

    public Object invokeCurrent(Map globalContext, Object context) {
        return this.invokeValue(context);
    }

    public final Object invokeValue(Object context) {
        try {
            Object target;
            Class<?> contextClass = context.getClass();
            ValueInvokeHolder localHoder = this.invokeHolder;
            if (contextClass == localHoder.targetClass) {
                target = localHoder.valueInvoke.getValue(context);
            } else {
                ValueInvoke<Map<String, Object>> valueInvoke;
                if (context instanceof Map) {
                    valueInvoke = new MapValueInvoke(this.key);
                } else {
                    GetterInfo getterInfo = null;
                    try {
                        getterInfo = ClassStructureWrapper.get(contextClass).getGetterInfo(this.key);
                        valueInvoke = getterInfo.isSupportedUnsafe() ? (getterInfo.isPrimitive() ? new ObjectPrimitiveFieldInvoke(getterInfo) : new ObjectFieldInvoke(getterInfo)) : new ObjectGetterInvoke(getterInfo);
                    }
                    catch (RuntimeException runtimeException) {
                        if (getterInfo == null) {
                            throw new IllegalArgumentException(String.format("Unresolved field '%s' from %s", this.key, contextClass.toString()));
                        }
                        throw runtimeException;
                    }
                }
                target = valueInvoke.getValue((Map<String, Object>)context);
                this.invokeHolder = new ValueInvokeHolder(contextClass, valueInvoke);
            }
            return target;
        }
        catch (Throwable throwable) {
            if (context == null) {
                throw new IllegalArgumentException(String.format("Unresolved field '%s' for target obj is null or not exist in the context ", this.key));
            }
            throw new IllegalArgumentException(String.format("Unresolved field '%s' from %s, resion: %s", this.key, context.getClass(), throwable.getMessage()), throwable);
        }
    }

    public void setIndex(int index) {
        this.index = index;
    }

    public int getIndex() {
        return this.index;
    }

    @Override
    public void internKey() {
        this.key = this.key.intern();
    }

    public boolean isTail() {
        return this.tail;
    }

    public void setTail(boolean tail) {
        this.tail = tail;
    }

    public boolean isChildEl() {
        return false;
    }

    @Override
    public int size() {
        return 1;
    }

    static class ValueInvokeHolder {
        static final ValueInvokeHolder Empty = new ValueInvokeHolder(null, null);
        final Class targetClass;
        final ValueInvoke valueInvoke;

        public ValueInvokeHolder(Class targetClass, ValueInvoke valueInvoke) {
            this.targetClass = targetClass;
            this.valueInvoke = valueInvoke;
        }
    }

    static final class ObjectPrimitiveFieldInvoke
    implements ValueInvoke {
        private final ReflectConsts.PrimitiveType primitiveType;
        private final long fieldOffset;

        ObjectPrimitiveFieldInvoke(GetterInfo getterInfo) {
            getterInfo.getClass();
            this.primitiveType = getterInfo.getPrimitiveType();
            this.fieldOffset = getterInfo.getFieldOffset();
        }

        public Object getValue(Object context) {
            return ElInvoker.SECURE_TRUSTED_ACCESS.getPrimitiveValue(this.primitiveType, context, this.fieldOffset);
        }
    }

    static final class ObjectFieldInvoke
    implements ValueInvoke {
        private final GetterInfo getterInfo;
        private final long fieldOffset;

        ObjectFieldInvoke(GetterInfo getterInfo) {
            getterInfo.getClass();
            this.getterInfo = getterInfo;
            this.fieldOffset = getterInfo.getFieldOffset();
        }

        public Object getValue(Object context) {
            return ElInvoker.SECURE_TRUSTED_ACCESS.getObjectValue(context, this.fieldOffset);
        }
    }

    static final class ObjectGetterInvoke
    implements ValueInvoke {
        private final GetterInfo getterInfo;

        ObjectGetterInvoke(GetterInfo getterInfo) {
            getterInfo.getClass();
            this.getterInfo = getterInfo;
        }

        public Object getValue(Object context) {
            return ElInvoker.SECURE_TRUSTED_ACCESS.get(this.getterInfo, context);
        }
    }

    static class MapValueInvoke
    implements ValueInvoke<Map<String, Object>> {
        private final String key;

        MapValueInvoke(String key) {
            this.key = key;
        }

        @Override
        public Object getValue(Map<String, Object> context) {
            return context.get(this.key);
        }

        public String toString() {
            return "[" + this.key + "]";
        }
    }

    static interface ValueInvoke<T> {
        public Object getValue(T var1);
    }

    static class ChildElVariableInvoke
    extends ElVariableInvoker {
        protected Expression el;

        ChildElVariableInvoke(String key) {
            super(key);
        }

        ChildElVariableInvoke(String key, ElVariableInvoker parent) {
            super(key, parent);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void parseChildEl() {
            if (this.el == null) {
                ChildElVariableInvoke childElVariableInvoke = this;
                synchronized (childElVariableInvoke) {
                    if (this.el == null) {
                        this.el = Expression.parse(this.key);
                    }
                }
            }
        }

        @Override
        public Object invokeDirect(Object context) {
            Object target;
            this.parseChildEl();
            Object realKey = this.el.evaluate(context);
            Object object = target = this.parent != null ? this.parent.invokeDirect(context) : context;
            if (realKey instanceof String) {
                return ObjectUtils.getAttrValue(target, (String)realKey);
            }
            if (realKey instanceof Long) {
                int indexValue = ((Long)realKey).intValue();
                return CollectionUtils.getElement(target, indexValue);
            }
            throw new IllegalArgumentException(String.format("Unresolved child el: '%s', val: %s ", this.key, String.valueOf(realKey)));
        }

        @Override
        public Object invokeDirect(Map context) {
            this.parseChildEl();
            Object realKey = this.el.evaluate(context);
            if (this.parent == null) {
                return context.get(String.valueOf(realKey));
            }
            Object target = this.parent.invokeDirect(context);
            if (realKey instanceof String) {
                return ObjectUtils.getAttrValue(target, (String)realKey);
            }
            if (realKey instanceof Long) {
                int indexValue = ((Long)realKey).intValue();
                return CollectionUtils.getElement(target, indexValue);
            }
            throw new IllegalArgumentException(String.format("Unresolved child el: '%s', val: %s ", this.key, String.valueOf(realKey)));
        }

        @Override
        public Object invoke(Object context, Object[] variableValues) {
            Object parentContext;
            Object value = variableValues[this.index];
            if (value != null) {
                return value;
            }
            this.parseChildEl();
            Object realKey = this.el.evaluate(context);
            Object object = parentContext = this.parent != null ? this.parent.invoke(context, variableValues) : context;
            if (realKey instanceof String) {
                variableValues[this.index] = ObjectUtils.getAttrValue(parentContext, (String)realKey);
                return variableValues[this.index];
            }
            if (realKey instanceof Long) {
                int indexValue = ((Long)realKey).intValue();
                variableValues[this.index] = CollectionUtils.getElement(parentContext, indexValue);
                return variableValues[this.index];
            }
            throw new IllegalArgumentException(String.format("Unresolved child el: '%s', val: %s ", this.key, String.valueOf(realKey)));
        }

        @Override
        public Object invoke(Map context, Object[] variableValues) {
            Map parentContext;
            Object value = variableValues[this.index];
            if (value != null) {
                return value;
            }
            this.parseChildEl();
            Object realKey = this.el.evaluate(context);
            Map map = parentContext = this.parent != null ? this.parent.invoke(context, variableValues) : context;
            if (realKey instanceof String) {
                variableValues[this.index] = ObjectUtils.getAttrValue(parentContext, (String)realKey);
                return variableValues[this.index];
            }
            if (realKey instanceof Long) {
                int indexValue = ((Long)realKey).intValue();
                variableValues[this.index] = CollectionUtils.getElement(parentContext, indexValue);
                return variableValues[this.index];
            }
            throw new IllegalArgumentException(String.format("Unresolved child el: '%s', val: %s ", this.key, String.valueOf(realKey)));
        }

        @Override
        public Object invokeCurrent(Map globalContext, Object parentContext, Object[] variableValues) {
            this.parseChildEl();
            Object realKey = this.el.evaluate(globalContext);
            if (realKey instanceof String) {
                variableValues[this.index] = ObjectUtils.getAttrValue(parentContext, (String)realKey);
                return variableValues[this.index];
            }
            if (realKey instanceof Long) {
                int indexValue = ((Long)realKey).intValue();
                variableValues[this.index] = CollectionUtils.getElement(parentContext, indexValue);
                return variableValues[this.index];
            }
            throw new IllegalArgumentException(String.format("Unresolved child el: '%s', val: %s ", this.key, String.valueOf(realKey)));
        }

        @Override
        public Object invokeCurrent(Object globalContext, Object parentContext, Object[] variableValues) {
            this.parseChildEl();
            Object realKey = this.el.evaluate(globalContext);
            if (realKey instanceof String) {
                variableValues[this.index] = ObjectUtils.getAttrValue(parentContext, (String)realKey);
                return variableValues[this.index];
            }
            if (realKey instanceof Long) {
                int indexValue = ((Long)realKey).intValue();
                variableValues[this.index] = CollectionUtils.getElement(parentContext, indexValue);
                return variableValues[this.index];
            }
            throw new IllegalArgumentException(String.format("Unresolved child el: '%s', val: %s ", this.key, String.valueOf(realKey)));
        }

        @Override
        public Object invokeCurrent(Object globalContext, Object parentContext) {
            this.parseChildEl();
            Object realKey = this.el.evaluate(globalContext);
            if (realKey instanceof String) {
                return ObjectUtils.getAttrValue(parentContext, (String)realKey);
            }
            if (realKey instanceof Long) {
                int indexValue = ((Long)realKey).intValue();
                return CollectionUtils.getElement(parentContext, indexValue);
            }
            throw new IllegalArgumentException(String.format("Unresolved child el: '%s', val: %s ", this.key, String.valueOf(realKey)));
        }

        @Override
        public Object invokeCurrent(Map globalContext, Object parentContext) {
            this.parseChildEl();
            Object realKey = this.el.evaluate(globalContext);
            if (realKey instanceof String) {
                return ObjectUtils.getAttrValue(parentContext, (String)realKey);
            }
            if (realKey instanceof Long) {
                int indexValue = ((Long)realKey).intValue();
                return CollectionUtils.getElement(parentContext, indexValue);
            }
            throw new IllegalArgumentException(String.format("Unresolved child el: '%s', val: %s ", this.key, String.valueOf(realKey)));
        }

        @Override
        public boolean isChildEl() {
            return true;
        }

        @Override
        public String toString() {
            return this.parent.toString() + "[" + this.key + "]";
        }
    }

    static class RootVariableInvoke
    extends ElVariableInvoker {
        public RootVariableInvoke(String key) {
            super(key);
        }

        @Override
        public Object invokeDirect(Object context) {
            return this.invokeValue(context);
        }

        @Override
        public Object invokeDirect(Map context) {
            return context.get(this.key);
        }

        @Override
        public Object invoke(Object entityContext, Object[] variableValues) {
            Object value = variableValues[this.index];
            if (value != null) {
                return value;
            }
            variableValues[this.index] = this.invokeValue(entityContext);
            return variableValues[this.index];
        }

        @Override
        public Object invoke(Map mapContext, Object[] variableValues) {
            Object value = variableValues[this.index];
            if (value != null) {
                return value;
            }
            variableValues[this.index] = mapContext.get(this.key);
            return variableValues[this.index];
        }

        @Override
        public String toString() {
            return this.key;
        }
    }
}

