/*
 * Decompiled with CFR 0.152.
 */
package io.github.wycst.wast.jdbc.executer;

import io.github.wycst.wast.common.beans.GregorianDate;
import io.github.wycst.wast.common.utils.ObjectUtils;
import io.github.wycst.wast.common.utils.StringUtils;
import io.github.wycst.wast.jdbc.exception.EntityException;
import io.github.wycst.wast.jdbc.exception.OqlParematerException;
import io.github.wycst.wast.jdbc.exception.SqlExecuteException;
import io.github.wycst.wast.jdbc.executer.CascadeFetchMapping;
import io.github.wycst.wast.jdbc.executer.DefaultSqlExecuter;
import io.github.wycst.wast.jdbc.executer.EntityManagementFactory;
import io.github.wycst.wast.jdbc.executer.EntitySqlMapping;
import io.github.wycst.wast.jdbc.executer.FieldColumn;
import io.github.wycst.wast.jdbc.executer.OqlExecuter;
import io.github.wycst.wast.jdbc.executer.OqlQuery;
import io.github.wycst.wast.jdbc.executer.SqlFunctionType;
import io.github.wycst.wast.jdbc.query.page.Page;
import io.github.wycst.wast.jdbc.query.sql.Sql;
import io.github.wycst.wast.jdbc.util.StreamCursor;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class EntityExecuter
implements OqlExecuter {
    private final DefaultSqlExecuter sqlExecuter;

    EntityExecuter(DefaultSqlExecuter sqlExecuter) {
        this.sqlExecuter = sqlExecuter;
    }

    @Override
    public DefaultSqlExecuter getSqlExecuter() {
        return this.sqlExecuter;
    }

    @Override
    public <E> E get(Class<E> entityCls, Serializable id) {
        return this.get(entityCls, id, false);
    }

    @Override
    public <E> E get(Class<E> entityCls, Serializable id, boolean fetch) {
        id.getClass();
        this.checkEntityClass(entityCls);
        EntitySqlMapping entitySqlMapping = this.getEntitySqlMapping(entityCls);
        E result = entitySqlMapping.getEntityHandler().getById(this.sqlExecuter, entityCls, id);
        if (fetch && result != null) {
            this.handleFetch(entitySqlMapping, result);
        }
        return result;
    }

    @Override
    public <E> List<E> queryAll(Class<E> cls) {
        return this.queryBy(cls, (E)null);
    }

    @Override
    public <E> E queryOne(Class<E> entityCls, Map<String, Object> params) {
        return this.executeQueryOne(entityCls, params);
    }

    @Override
    public <E> E queryOne(Class<E> entityCls, E params) {
        return this.executeQueryOne(entityCls, params);
    }

    @Override
    public <E> long queryCount(Class<E> entityCls) {
        return this.queryCount(entityCls, (E)null);
    }

    @Override
    public <E> long queryCount(Class<E> entityCls, Map<String, Object> params) {
        return this.executeQueryCount(entityCls, params);
    }

    @Override
    public <E> long queryCount(Class<E> entityCls, E params) {
        return this.executeQueryCount(entityCls, params);
    }

    @Override
    public <E> long queryCount(Class<E> cls, OqlQuery query, Object params) {
        this.checkEntityClass(cls);
        EntitySqlMapping entitySqlMapping = this.getEntitySqlMapping(cls);
        Sql countSqlObject = entitySqlMapping.getCountSqlObject(query, params);
        return this.sqlExecuter.queryValue(countSqlObject.getFormalSql(), Long.TYPE, countSqlObject.getParamValues());
    }

    @Override
    public <E> E queryUnique(Class<E> entityCls, Map<String, Object> params) {
        return this.executeQueryUnique(entityCls, params);
    }

    @Override
    public <E> E queryUnique(Class<E> entityCls, E params) {
        return this.executeQueryUnique(entityCls, params);
    }

    @Override
    public <E> List<E> queryList(Class<E> entityCls, OqlQuery query, Object params) {
        this.checkEntityClass(entityCls);
        EntitySqlMapping entitySqlMapping = this.getEntitySqlMapping(entityCls);
        Sql sqlObject = entitySqlMapping.getSelectSqlObject(query, params);
        return this.sqlExecuter.queryList(sqlObject.getFormalSql(), entityCls, sqlObject.getParamValues());
    }

    @Override
    public <E> List<E> queryList(Class<E> cls, OqlQuery query) {
        return this.queryList(cls, query, new HashMap());
    }

    @Override
    public <E> StreamCursor<E> queryStreamBy(Class<E> entityCls, Map<String, Object> params) {
        return this.executeQueryStreamBy(entityCls, params);
    }

    @Override
    public <E> StreamCursor<E> queryStreamBy(Class<E> entityCls, E params) {
        return this.executeQueryStreamBy(entityCls, params);
    }

    @Override
    public <E> StreamCursor<E> queryStream(Class<E> entityCls, OqlQuery query, Object params) {
        this.checkEntityClass(entityCls);
        EntitySqlMapping entitySqlMapping = this.getEntitySqlMapping(entityCls);
        Sql sqlObject = entitySqlMapping.getSelectSqlObject(query, params);
        return this.sqlExecuter.queryStream(sqlObject.getFormalSql(), entityCls, sqlObject.getParamValues());
    }

    @Override
    public <E> List<E> queryBy(Class<E> entityCls, Map<String, Object> params) {
        return this.executeQueryBy(entityCls, params);
    }

    @Override
    public <E> List<E> queryBy(Class<E> entityCls, E params) {
        return this.executeQueryBy(entityCls, params);
    }

    @Override
    public <E> List<E> queryByIds(Class<E> entityCls, List<? extends Serializable> ids) {
        if (ids == null || ids.isEmpty()) {
            return new ArrayList();
        }
        this.checkEntityClass(entityCls);
        EntitySqlMapping entitySqlMapping = this.getEntitySqlMapping(entityCls);
        String selectInSql = entitySqlMapping.getSelectSqlByIds(ids);
        return this.sqlExecuter.queryList(selectInSql, entityCls, ids.toArray());
    }

    @Override
    public <E> List<E> queryByIds(Class<E> entityCls, Serializable ... ids) {
        if (ids.length == 0) {
            return new ArrayList();
        }
        this.checkEntityClass(entityCls);
        EntitySqlMapping entitySqlMapping = this.getEntitySqlMapping(entityCls);
        List<Serializable> list = Arrays.asList(ids);
        String selectInSql = entitySqlMapping.getSelectSqlByIds(list);
        return this.sqlExecuter.queryList(selectInSql, entityCls, (Object[])ids);
    }

    @Override
    public <E> Page<E> queryPage(Page<E> page, OqlQuery query, Object params) {
        Class<E> entityCls = page.actualType();
        this.checkEntityClass(entityCls);
        EntitySqlMapping entitySqlMapping = this.getEntitySqlMapping(entityCls);
        Sql sqlObject = entitySqlMapping.getSelectSqlObject(query, params, true);
        this.executeQueryPage(page, entityCls, sqlObject);
        return page;
    }

    @Override
    public <E> Page<E> queryPage(Page<E> page) {
        return this.queryPage(page, (E)null);
    }

    @Override
    public <E> Page<E> queryPage(Page<E> page, Map<String, Object> params) {
        return this.executeQueryPage(page, params);
    }

    @Override
    public <E> Page<E> queryPage(Page<E> page, E params) {
        return this.executeQueryPage(page, params);
    }

    @Override
    public <E> Serializable insert(E entity) {
        Class<?> entityCls = entity.getClass();
        this.checkEntityClass(entityCls);
        EntitySqlMapping entitySqlMapping = this.getEntitySqlMapping(entityCls);
        Sql sqlObject = entitySqlMapping.getInsertSqlObject(entity);
        return this.sqlExecuter.insert(sqlObject.getFormalSql(), true, sqlObject.getParamValues());
    }

    @Override
    public <E> void insertList(List<E> entityList) {
        if (entityList.size() == 0) {
            return;
        }
        Class<?> entityCls = entityList.get(0).getClass();
        this.checkEntityClass(entityCls);
        EntitySqlMapping entitySqlMapping = this.getEntitySqlMapping(entityCls);
        if (entitySqlMapping.isUsePlaceholderOnInsert()) {
            if (this.isSupportBatchInsert()) {
                Sql batchInsertSqlObject = entitySqlMapping.getBatchInsertSqlObject(entityList);
                this.sqlExecuter.update(batchInsertSqlObject.getFormalSql(), batchInsertSqlObject.getParamValues());
            } else {
                for (E e : entityList) {
                    Sql sqlObject = entitySqlMapping.getInsertSqlObject(e);
                    this.sqlExecuter.insert(sqlObject.getFormalSql(), true, sqlObject.getParamValues());
                }
            }
        } else {
            Sql sqlObject = entitySqlMapping.getInsertSqlObjectList(entityList);
            this.sqlExecuter.updateCollection(sqlObject.getFormalSql(), sqlObject.getParamValuesList());
        }
    }

    @Override
    public <E> int mysqlBatchInsert(List<E> entityList) {
        if (!this.isSupportBatchInsert()) {
            throw new SqlExecuteException("\u5f53\u524d\u6570\u636e\u5e93\u4e0d\u652f\u6301\u6279\u91cf\u63d2\u5165");
        }
        if (entityList.size() == 0) {
            return 0;
        }
        Class<?> entityCls = entityList.get(0).getClass();
        this.checkEntityClass(entityCls);
        EntitySqlMapping entitySqlMapping = this.getEntitySqlMapping(entityCls);
        Sql batchInsertSqlObject = entitySqlMapping.getBatchInsertSqlObject(entityList);
        return this.sqlExecuter.update(batchInsertSqlObject.getFormalSql(), batchInsertSqlObject.getParamValues());
    }

    @Override
    public <E> int update(E entity) {
        Class<?> entityCls = entity.getClass();
        this.checkEntityClass(entityCls);
        EntitySqlMapping entitySqlMapping = this.getEntitySqlMapping(entityCls);
        return entitySqlMapping.getEntityHandler().updateEntity(this.sqlExecuter, entity);
    }

    @Override
    public <E> int updateBy(Class<E> entityCls, OqlQuery query, E params, String ... fields) {
        return this.handleUpdateByParams(entityCls, query, params, fields);
    }

    @Override
    public <E> int updateBy(Class<E> entityCls, OqlQuery query, Map<String, Object> params, String ... fields) {
        return this.handleUpdateByParams(entityCls, query, params, fields);
    }

    <E> int handleUpdateByParams(Class<E> entityCls, OqlQuery query, Object params, String ... fields) {
        if (fields.length == 0) {
            return 0;
        }
        if (params == null) {
            throw new SqlExecuteException("params is null");
        }
        this.checkEntityClass(entityCls);
        EntitySqlMapping entitySqlMapping = this.getEntitySqlMapping(entityCls);
        String sqlStringFormat = this.getSqlStringFormat(SqlFunctionType.UPDATE_BY_PARAMS);
        Sql sqlObject = entitySqlMapping.getUpdateSqlObject(sqlStringFormat, query, params, fields);
        return this.sqlExecuter.update(sqlObject.getFormalSql(), sqlObject.getParamValues());
    }

    @Override
    public <E> int updateFields(E e, String ... fields) {
        return this.updateFields(e, Arrays.asList(fields), false);
    }

    @Override
    public <E> int updateFields(E e, boolean isExclude, String ... fields) {
        return this.updateFields(e, Arrays.asList(fields), isExclude);
    }

    @Override
    public <E> int updateFields(E entity, List<String> fields) {
        return this.updateFields(entity, fields, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <E> int updateFields(E entity, List<String> fields, boolean isExclude) {
        Class<?> entityCls = entity.getClass();
        this.checkEntityClass(entityCls);
        EntitySqlMapping entitySqlMapping = this.getEntitySqlMapping(entityCls);
        String sqlStringFormat = this.getSqlStringFormat(SqlFunctionType.UPDATE_BY_ID);
        Sql sqlObject = entitySqlMapping.getUpdateSqlObject(sqlStringFormat, entity, fields, isExclude);
        if (sqlObject == null) {
            throw new OqlParematerException("\u914d\u7f6e\u9519\u8bef\uff1a" + entityCls + "\u53ef\u80fd\u6ca1\u6709\u5b9a\u4e49@Id,\u8bf7\u68c0\u67e5\u914d\u7f6e");
        }
        try {
            int n = this.sqlExecuter.update(sqlObject.getFormalSql(), sqlObject.getParamValues());
            return n;
        }
        finally {
            entitySqlMapping.getEntityHandler().afterUpdate(this.sqlExecuter, entity);
        }
    }

    @Override
    public <E> int deleteAll(Class<E> entityCls) {
        return this.deleteBy(entityCls, (Map<String, Object>)null);
    }

    @Override
    public <E> int delete(Class<E> entityCls, Serializable id) {
        return this.delete(entityCls, id, false);
    }

    @Override
    public <E> int delete(Class<E> entityCls, Serializable id, boolean cascade) {
        id.getClass();
        this.checkEntityClass(entityCls);
        EntitySqlMapping entitySqlMapping = this.getEntitySqlMapping(entityCls);
        if (cascade) {
            this.executeCascadeDelete(entitySqlMapping, id);
        }
        return entitySqlMapping.getEntityHandler().deleteById(this.sqlExecuter, entityCls, id);
    }

    @Override
    public <E> int deleteList(List<E> entityList) {
        if (entityList == null) {
            return 0;
        }
        int influenceRows = 0;
        Class<?> entityCls = entityList.get(0).getClass();
        this.checkEntityClass(entityCls);
        EntitySqlMapping entitySqlMapping = this.getEntitySqlMapping(entityCls);
        String sqlStringFormat = this.getSqlStringFormat(SqlFunctionType.DELETE_BY_ID);
        String deleteSql = entitySqlMapping.getDeleteSql(sqlStringFormat);
        if (deleteSql == null) {
            throw new OqlParematerException("\u914d\u7f6e\u9519\u8bef\uff1a" + entityCls + "\u53ef\u80fd\u6ca1\u6709\u5b9a\u4e49@Id,\u8bf7\u68c0\u67e5\u914d\u7f6e");
        }
        for (E entity : entityList) {
            Serializable id = entitySqlMapping.getId(entity);
            influenceRows += this.sqlExecuter.update(deleteSql, id);
        }
        if (influenceRows > 0) {
            entitySqlMapping.getEntityHandler().afterBatchDelete();
        }
        return influenceRows;
    }

    @Override
    public <E> int deleteByIds(Class<E> entityCls, List<? extends Serializable> ids) {
        if (ids == null || ids.size() == 0) {
            return 0;
        }
        this.checkEntityClass(entityCls);
        EntitySqlMapping entitySqlMapping = this.getEntitySqlMapping(entityCls);
        String sqlStringFormat = this.getSqlStringFormat(SqlFunctionType.DELETE_BY_ID);
        String deleteSql = entitySqlMapping.getDeleteSql(sqlStringFormat);
        if (deleteSql == null) {
            throw new OqlParematerException("\u914d\u7f6e\u9519\u8bef\uff1a" + entityCls + "\u53ef\u80fd\u6ca1\u6709\u5b9a\u4e49@Id,\u8bf7\u68c0\u67e5\u914d\u7f6e");
        }
        ArrayList<Object[]> dataList = new ArrayList<Object[]>();
        for (Serializable serializable : ids) {
            dataList.add(new Object[]{serializable});
        }
        this.sqlExecuter.updateCollection(deleteSql, dataList);
        return ids.size();
    }

    @Override
    public <E> int deleteByIds(Class<E> cls, Serializable ... ids) {
        return this.deleteByIds(cls, Arrays.asList(ids));
    }

    @Override
    public <E> int deleteBy(Class<E> entityCls, E params) {
        return this.handleDeleteBy(entityCls, params);
    }

    @Override
    public <E> int deleteBy(Class<E> entityCls, Map<String, Object> params) {
        return this.handleDeleteBy(entityCls, params);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    <E> int handleDeleteBy(Class<E> entityCls, Object params) {
        this.checkEntityClass(entityCls);
        EntitySqlMapping entitySqlMapping = this.getEntitySqlMapping(entityCls);
        String sqlTemplate = this.getSqlStringFormat(SqlFunctionType.DELETE_BY_PARAMS);
        Sql sqlObject = entitySqlMapping.getDeleteSqlObjectByParams(sqlTemplate, params);
        try {
            int n = this.sqlExecuter.update(sqlObject.getFormalSql(), sqlObject.getParamValues());
            return n;
        }
        finally {
            entitySqlMapping.getEntityHandler().afterBatchDelete();
        }
    }

    @Override
    public <E> int deleteBy(Class<E> entityCls, OqlQuery query, Object params) {
        this.checkEntityClass(entityCls);
        EntitySqlMapping entitySqlMapping = this.getEntitySqlMapping(entityCls);
        Sql sqlObject = entitySqlMapping.getSelectSqlObject(query, params);
        List<E> entityList = this.sqlExecuter.queryList(sqlObject.getFormalSql(), entityCls, sqlObject.getParamValues());
        return this.deleteList(entityList);
    }

    @Override
    public <E> String reverseDeleteSQL(E entity) {
        this.checkEntityClass(entity.getClass());
        EntitySqlMapping entitySqlMapping = this.getEntitySqlMapping(entity.getClass());
        return this.generateDeleteSql(entitySqlMapping, entity);
    }

    @Override
    public <E> String reverseInsertSQL(E entity) {
        this.checkEntityClass(entity.getClass());
        EntitySqlMapping entitySqlMapping = this.getEntitySqlMapping(entity.getClass());
        return this.generateInsertSql(entitySqlMapping, entity);
    }

    void checkEntityClass(Class<?> entityCls) {
        EntityManagementFactory.defaultManagementFactory().checkEntityClass(entityCls);
    }

    EntitySqlMapping getEntitySqlMapping(Class<?> entityCls) {
        return EntityManagementFactory.defaultManagementFactory().getEntitySqlMapping(entityCls);
    }

    void handleFetch(EntitySqlMapping entitySqlMapping, Object result) {
        List<CascadeFetchMapping> cascadeFetchMappings = entitySqlMapping.getCascadeFetchMappings();
        for (CascadeFetchMapping cascadeFetchMapping : cascadeFetchMappings) {
            if (!cascadeFetchMapping.isFetch()) continue;
            Map<String, Object> params = this.getCascadeFetchParams(cascadeFetchMapping, entitySqlMapping, result);
            if (params == null) {
                return;
            }
            int fieldTypeValue = cascadeFetchMapping.getFieldType();
            Class<?> targetEntityClass = cascadeFetchMapping.getTargetEntityClass();
            List<?> list = this.executeQueryBy(targetEntityClass, params);
            List<?> fetchFieldVal = null;
            if (fieldTypeValue == 1) {
                if (list.size() > 0) {
                    fetchFieldVal = list.get(0);
                }
            } else {
                fetchFieldVal = list;
            }
            if (fetchFieldVal == null) continue;
            cascadeFetchMapping.setFetchFieldValue(result, fetchFieldVal);
        }
    }

    Map<String, Object> getCascadeFetchParams(CascadeFetchMapping cascadeFetchMapping, EntitySqlMapping entitySqlMapping, Object result) {
        String fieldName = cascadeFetchMapping.getFieldName();
        FieldColumn fieldColumn = entitySqlMapping.getFieldColumnMapping().get(fieldName);
        if (fieldColumn == null) {
            Field fetchField = cascadeFetchMapping.getCascadeFetchField();
            Class<?> clazz = entitySqlMapping.getEntityClass();
            throw new EntityException(" Entity Class " + clazz + " and field[" + fetchField.getName() + "] is AnnotationPresent @CascadeFetch, but field '" + fieldName + "' is not exist");
        }
        HashMap<String, Object> params = null;
        Object val = entitySqlMapping.getFieldColumnValue(false, fieldColumn, result);
        if (val != null) {
            String targetFieldName = cascadeFetchMapping.getTargetFieldName();
            params = new HashMap<String, Object>();
            params.put(targetFieldName, val);
        }
        return params;
    }

    <E> E executeQueryOne(Class<E> entityCls, Object params) {
        this.checkEntityClass(entityCls);
        EntitySqlMapping entitySqlMapping = this.getEntitySqlMapping(entityCls);
        Sql sqlObject = entitySqlMapping.getSelectSqlObject(params);
        return this.sqlExecuter.queryObject(sqlObject.getFormalSql(), entityCls, sqlObject.getParamValues());
    }

    long executeQueryCount(Class<?> entityCls, Object params) {
        this.checkEntityClass(entityCls);
        EntitySqlMapping entitySqlMapping = this.getEntitySqlMapping(entityCls);
        Sql countSqlObject = entitySqlMapping.getCountSqlObject(params);
        return this.sqlExecuter.queryValue(countSqlObject.getFormalSql(), Long.TYPE, countSqlObject.getParamValues());
    }

    <E> E executeQueryUnique(Class<E> entityCls, Object params) {
        this.checkEntityClass(entityCls);
        EntitySqlMapping entitySqlMapping = this.getEntitySqlMapping(entityCls);
        Sql sqlObject = entitySqlMapping.getSelectSqlObject(params);
        return this.sqlExecuter.queryUniqueObject(sqlObject.getFormalSql(), entityCls, sqlObject.getParamValues());
    }

    <E> StreamCursor<E> executeQueryStreamBy(Class<E> entityCls, Object params) {
        this.checkEntityClass(entityCls);
        EntitySqlMapping entitySqlMapping = this.getEntitySqlMapping(entityCls);
        Sql sqlObject = entitySqlMapping.getSelectSqlObject(params);
        return this.sqlExecuter.queryStream(sqlObject.getFormalSql(), entityCls, sqlObject.getParamValues());
    }

    <E> List<E> executeQueryBy(Class<E> entityCls, Object params) {
        this.checkEntityClass(entityCls);
        EntitySqlMapping entitySqlMapping = this.getEntitySqlMapping(entityCls);
        return entitySqlMapping.getEntityHandler().executeQueryBy(this.sqlExecuter, entityCls, params);
    }

    <E> Page<E> executeQueryPage(Page<E> page, Object params) {
        Class<E> entityCls = page.actualType();
        this.checkEntityClass(entityCls);
        EntitySqlMapping entitySqlMapping = this.getEntitySqlMapping(entityCls);
        Sql sqlObject = entitySqlMapping.getSelectSqlObject(params, true);
        this.executeQueryPage(page, entityCls, sqlObject);
        return page;
    }

    <E> void executeQueryPage(Page<E> page, Class<E> entityCls, Sql sqlObject) {
        String totalSql = sqlObject.getTotalSql();
        String formalSql = sqlObject.getFormalSql();
        Object[] paramValues = sqlObject.getParamValues();
        String limitSql = this.sqlExecuter.getLimitSql(formalSql, page.getOffset(), page.getPageSize());
        List<E> rows = this.sqlExecuter.queryList(limitSql, entityCls, paramValues);
        page.setRows(rows);
        long total = this.sqlExecuter.queryValue(totalSql, Long.TYPE, paramValues);
        page.setTotal(total);
    }

    String getSqlStringFormat(SqlFunctionType sqlFunctionType) {
        return this.sqlExecuter.sqlTemplates[sqlFunctionType.ordinal()];
    }

    void executeCascadeDelete(EntitySqlMapping entitySqlMapping, Serializable id) {
        List<CascadeFetchMapping> cascadeFetchMappings = entitySqlMapping.getCascadeFetchMappings();
        Class<?> clazz = entitySqlMapping.getEntityClass();
        Object result = entitySqlMapping.getEntityHandler().getById(this.sqlExecuter, clazz, id);
        for (CascadeFetchMapping cascadeFetchMapping : cascadeFetchMappings) {
            if (!cascadeFetchMapping.isCascade()) continue;
            Map<String, Object> params = this.getCascadeFetchParams(cascadeFetchMapping, entitySqlMapping, result);
            if (params == null) {
                return;
            }
            Class<?> entityClass = cascadeFetchMapping.getTargetEntityClass();
            this.deleteBy(entityClass, params);
        }
    }

    String generateDeleteSql(EntitySqlMapping entitySqlMapping, Object entity) {
        Object primaryValue;
        if (entity == null) {
            return null;
        }
        String template = "DELETE FROM `%s` WHERE %s = ";
        if (this.sqlExecuter.clickHouse) {
            template = "ALTER TABLE %s DELETE WHERE %s = ";
        }
        if ((primaryValue = ObjectUtils.get(entity, entitySqlMapping.getPrimary().getField().getName())) instanceof String) {
            primaryValue = "'" + primaryValue + "'";
        }
        String sql = StringUtils.replacePlaceholder(template, "%s", entitySqlMapping.getTableName(), entitySqlMapping.getPrimary().getColumnName());
        return sql + primaryValue;
    }

    private String generateInsertSql(EntitySqlMapping entitySqlMapping, Object entity) {
        if (entity == null) {
            return null;
        }
        String tmpSql = "INSERT INTO `%s` (%s) VALUES (%s)";
        StringBuilder columns = new StringBuilder();
        StringBuilder values = new StringBuilder();
        int index = 0;
        Map<String, FieldColumn> fieldColumnMapping = entitySqlMapping.getFieldColumnMapping();
        int columnLength = fieldColumnMapping.size();
        for (Map.Entry<String, FieldColumn> entry : fieldColumnMapping.entrySet()) {
            String fieldName = entry.getKey();
            FieldColumn fieldColumn = entry.getValue();
            String columnName = fieldColumn.getColumnName();
            Object value = ObjectUtils.get(entity, fieldName);
            columns.append(columnName);
            if (value == null || value instanceof Number) {
                values.append(value);
            } else {
                if (value instanceof Date) {
                    value = new GregorianDate(((Date)value).getTime()).format();
                } else if (value instanceof String) {
                    value = ((String)value).replace("\\", "\\\\");
                    value = ((String)value).replace("\n", "\\n");
                    value = ((String)value).replace("\"", "\\\"");
                    value = ((String)value).replace("'", "\\'");
                }
                values.append("'").append(value).append("'");
            }
            if (++index >= columnLength) continue;
            columns.append(", ");
            values.append(", ");
        }
        return StringUtils.replacePlaceholder(tmpSql, "%s", entitySqlMapping.getTableName(), columns.toString(), values.toString());
    }

    public boolean isSupportBatchInsert() {
        return this.sqlExecuter.isSupportBatchInsert();
    }

    public <E> void clearCache(Class<E> entityCls) {
        this.checkEntityClass(entityCls);
        EntitySqlMapping entitySqlMapping = this.getEntitySqlMapping(entityCls);
        if (entitySqlMapping.isCacheable()) {
            entitySqlMapping.getCacheableEntityHandler().resetCaches();
        }
    }

    public <E> void clearAllCache() {
        EntityManagementFactory.defaultManagementFactory().clearAllCaches();
    }

    public void beginTransaction() {
        this.sqlExecuter.beginTransaction();
    }

    public void endTransaction() {
        this.sqlExecuter.endTransaction();
    }

    public void rollbackTransaction() {
        this.rollbackTransaction(true);
    }

    public void rollbackTransaction(boolean closeConnection) {
        this.sqlExecuter.rollbackTransaction(closeConnection);
    }

    public void commitTransaction() {
        this.sqlExecuter.commitTransaction();
    }

    public void commitTransaction(boolean closeConnection) {
        this.sqlExecuter.commitTransaction(closeConnection);
    }

    public void close() {
        this.sqlExecuter.close();
    }
}

