/*
 * Decompiled with CFR 0.152.
 */
package io.github.wycst.wast.jdbc.executer;

import io.github.wycst.wast.jdbc.executer.FieldColumn;
import java.io.Serializable;
import java.util.List;

public class FieldCondition {
    private final String field;
    private final Operator operator;
    private final Serializable value;
    private final boolean like;
    private String logicType = "and";

    public FieldCondition(String field, Operator ops, Serializable value) {
        this.field = field;
        this.operator = ops == null ? Operator.EQ : ops;
        this.value = value;
        this.like = this.operator.type == 1;
    }

    public FieldCondition(String field, Operator ops) {
        this(field, ops, null);
    }

    public String getField() {
        return this.field;
    }

    public String getOperator() {
        return this.operator.getSymbol();
    }

    public String likeValueLeft() {
        return this.operator.likeValueLeft();
    }

    public String likeValueRight() {
        return this.operator.likeValueRight();
    }

    public String getLogicType() {
        return this.logicType;
    }

    public void setLogicType(String logicType) {
        this.logicType = logicType;
    }

    public Serializable getValue() {
        return this.value;
    }

    public boolean isLike() {
        return this.like;
    }

    public void appendWhereValue(StringBuilder whereBuilder, List<Object> paramValues, Object conditionValue) {
        whereBuilder.append("?");
        paramValues.add(conditionValue);
    }

    public void appendWhereField(StringBuilder whereBuilder, FieldColumn fieldColumn) {
        whereBuilder.append("t.").append(fieldColumn.getColumnName()).append(" ").append(this.getOperator()).append(" ");
    }

    public static enum Operator {
        GT(">", 0),
        LT("<", 0),
        EQ("=", 0),
        GE(">=", 0),
        LE("<=", 0),
        NE("<>", 0),
        NE2("!=", 0),
        LIKE("LIKE", 1),
        LEFT_LIKE("LIKE", 1){

            @Override
            public String likeValueRight() {
                return "'";
            }
        }
        ,
        RIGHT_LIKE("LIKE", 1){

            @Override
            public String likeValueLeft() {
                return "'";
            }
        }
        ,
        CUSTOM_LIKE("LIKE", 1){

            @Override
            public String likeValueLeft() {
                return "'";
            }

            @Override
            public String likeValueRight() {
                return "'";
            }
        };

        final String symbol;
        final int type;

        private Operator(String symbol, int type) {
            this.symbol = symbol;
            this.type = type;
        }

        public String getSymbol() {
            return this.symbol;
        }

        public String likeValueLeft() {
            return "'%";
        }

        public String likeValueRight() {
            return "%'";
        }

        public int getType() {
            return this.type;
        }
    }
}

