/*
 * Decompiled with CFR 0.152.
 */
package io.github.wycst.wast.jdbc.executer;

import io.github.wycst.wast.jdbc.exception.SqlExecuteException;
import io.github.wycst.wast.jdbc.executer.BetweenFieldCondition;
import io.github.wycst.wast.jdbc.executer.ExistsSubQueryCondition;
import io.github.wycst.wast.jdbc.executer.FieldCondition;
import io.github.wycst.wast.jdbc.executer.FieldOrder;
import io.github.wycst.wast.jdbc.executer.InFieldCondition;
import io.github.wycst.wast.jdbc.executer.InSubQueryCondition;
import io.github.wycst.wast.jdbc.executer.IsNullFieldCondition;
import io.github.wycst.wast.jdbc.executer.SubOqlQuery;
import io.github.wycst.wast.jdbc.executer.SubQueryCondition;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;

public class OqlQuery {
    private final List<String> selectFields = new ArrayList<String>();
    private final List<FieldCondition> fieldConditions = new ArrayList<FieldCondition>();
    private final List<SubQueryCondition> subQueryConditions = new ArrayList<SubQueryCondition>();
    private final List<FieldOrder> orders = new ArrayList<FieldOrder>();
    private boolean disableJoin;
    private String logicTypeSpace = " AND ";

    OqlQuery() {
    }

    public static OqlQuery create() {
        return new OqlQuery();
    }

    public void reset() {
        this.clear();
        this.and().fetchJoin();
    }

    public OqlQuery and() {
        this.logicTypeSpace = " AND ";
        return this;
    }

    public OqlQuery or() {
        this.logicTypeSpace = " OR ";
        return this;
    }

    public String getLogicTypeSpace() {
        return this.logicTypeSpace;
    }

    public OqlQuery order(String field) {
        this.order(field, FieldOrder.Order.ASC);
        return this;
    }

    public OqlQuery orderAsc(String field) {
        this.order(field, FieldOrder.Order.ASC);
        return this;
    }

    public OqlQuery orderDesc(String field) {
        this.order(field, FieldOrder.Order.DESC);
        return this;
    }

    public OqlQuery order(String field, FieldOrder.Order by) {
        this.orders.add(new FieldOrder(field, by));
        return this;
    }

    public void clearSelectFields() {
        this.selectFields.clear();
    }

    public void clearConditions() {
        this.fieldConditions.clear();
        this.subQueryConditions.clear();
    }

    private void clearOrders() {
        this.orders.clear();
    }

    public void clear() {
        this.clearSelectFields();
        this.clearConditions();
        this.clearOrders();
    }

    public OqlQuery addSelectFields(String ... fields) {
        for (String field : fields) {
            if (this.selectFields.contains(field)) continue;
            this.selectFields.add(field);
        }
        return this;
    }

    public OqlQuery addConditions(String ... fields) {
        for (String field : fields) {
            this.addCondition(field, FieldCondition.Operator.EQ);
        }
        return this;
    }

    public OqlQuery addConditions(Collection<String> fields) {
        for (String field : fields) {
            this.addCondition(field, FieldCondition.Operator.EQ);
        }
        return this;
    }

    public OqlQuery addCondition(String field, FieldCondition.Operator ops, Serializable value) {
        this.fieldConditions.add(new FieldCondition(field, ops, value));
        return this;
    }

    public OqlQuery addCondition(String field, FieldCondition.Operator ops) {
        this.fieldConditions.add(new FieldCondition(field, ops));
        return this;
    }

    public OqlQuery between(String field, Serializable left, Serializable right) {
        this.fieldConditions.add(new BetweenFieldCondition(field, left, right));
        return this;
    }

    public OqlQuery between(String field, List<? extends Serializable> betweenValues) {
        if (betweenValues == null || betweenValues.size() < 2) {
            throw new SqlExecuteException("BETWEEN syntax must provide 2 values");
        }
        this.fieldConditions.add(new BetweenFieldCondition(field, betweenValues.get(0), betweenValues.get(1)));
        return this;
    }

    public OqlQuery between(String field, Serializable ... betweenValues) {
        if (betweenValues.length < 2) {
            throw new SqlExecuteException("BETWEEN syntax must provide 2 values");
        }
        this.fieldConditions.add(new BetweenFieldCondition(field, betweenValues[0], betweenValues[1]));
        return this;
    }

    public OqlQuery isNull(String field) {
        this.fieldConditions.add(new IsNullFieldCondition(field));
        return this;
    }

    public OqlQuery eq(String field, Serializable value) {
        this.fieldConditions.add(new FieldCondition(field, FieldCondition.Operator.EQ, value));
        return this;
    }

    public OqlQuery gt(String field, Serializable value) {
        this.fieldConditions.add(new FieldCondition(field, FieldCondition.Operator.GT, value));
        return this;
    }

    public OqlQuery lt(String field, Serializable value) {
        this.fieldConditions.add(new FieldCondition(field, FieldCondition.Operator.LT, value));
        return this;
    }

    public OqlQuery ge(String field, Serializable value) {
        this.fieldConditions.add(new FieldCondition(field, FieldCondition.Operator.GE, value));
        return this;
    }

    public OqlQuery le(String field, Serializable value) {
        this.fieldConditions.add(new FieldCondition(field, FieldCondition.Operator.LE, value));
        return this;
    }

    public OqlQuery in(String field, List<? extends Serializable> values) {
        this.fieldConditions.add(new InFieldCondition(field, values));
        return this;
    }

    public OqlQuery in(String field, SubOqlQuery subOqlQuery) {
        this.subQueryConditions.add(new InSubQueryCondition(field, subOqlQuery));
        return this;
    }

    public OqlQuery exists(SubOqlQuery subOqlQuery) {
        this.subQueryConditions.add(new ExistsSubQueryCondition(subOqlQuery));
        return this;
    }

    public OqlQuery clearConditions(String ... fields) {
        FieldCondition[] conditions = this.fieldConditions.toArray(new FieldCondition[this.fieldConditions.size()]);
        List<String> fieldList = Arrays.asList(fields);
        for (FieldCondition fieldCondition : conditions) {
            if (!fieldList.contains(fieldCondition.getField())) continue;
            this.fieldConditions.remove(fieldCondition);
        }
        return this;
    }

    public boolean isDisableJoin() {
        return this.disableJoin;
    }

    public void setDisableJoin(boolean disableJoin) {
        this.disableJoin = disableJoin;
    }

    public OqlQuery disableJoin() {
        this.disableJoin = true;
        return this;
    }

    public OqlQuery fetchJoin() {
        this.disableJoin = false;
        return this;
    }

    public List<String> getSelectFields() {
        return this.selectFields;
    }

    public List<FieldCondition> getConditions() {
        return this.fieldConditions;
    }

    public List<FieldOrder> getOrders() {
        return this.orders;
    }

    public List<SubQueryCondition> getSubQueryConditions() {
        return this.subQueryConditions;
    }
}

