/*
 * Decompiled with CFR 0.152.
 */
package io.github.wycst.wast.json;

import io.github.wycst.wast.common.reflect.ClassStructureWrapper;
import io.github.wycst.wast.common.reflect.GenericParameterizedType;
import io.github.wycst.wast.common.reflect.SetterInfo;
import io.github.wycst.wast.common.utils.Base64Utils;
import io.github.wycst.wast.common.utils.CollectionUtils;
import io.github.wycst.wast.common.utils.EnvUtils;
import io.github.wycst.wast.common.utils.ObjectUtils;
import io.github.wycst.wast.json.AsciiStringSource;
import io.github.wycst.wast.json.CharSource;
import io.github.wycst.wast.json.JSONDefaultParser;
import io.github.wycst.wast.json.JSONGeneral;
import io.github.wycst.wast.json.JSONNodeContext;
import io.github.wycst.wast.json.JSONOptions;
import io.github.wycst.wast.json.JSONParseContext;
import io.github.wycst.wast.json.JSONTypeDeserializer;
import io.github.wycst.wast.json.JSONUnsafe;
import io.github.wycst.wast.json.UTF16ByteArraySource;
import io.github.wycst.wast.json.exceptions.JSONException;
import io.github.wycst.wast.json.options.ReadOption;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public abstract class JSONNode
extends JSONGeneral
implements Comparable<JSONNode> {
    final JSONNode root;
    final JSONNodeContext parseContext;
    JSONNode parent;
    final int beginIndex;
    final int endIndex;
    String text;
    int offset;
    boolean completed;
    private Serializable path;
    Map<Serializable, JSONNode> fieldValues;
    JSONNode[] elementValues;
    int elementSize;
    int type;
    static final int OBJECT = 1;
    static final int ARRAY = 2;
    static final int STRING = 3;
    static final int NUMBER = 4;
    static final int BOOLEAN = 5;
    static final int NULL = 6;
    private final boolean isArray;
    private final boolean leaf;
    Serializable leafValue;
    private boolean changed;

    static final void addFieldValue(Map<Serializable, JSONNode> fieldValues, Serializable key, JSONNode value) {
        value.path = key;
        fieldValues.put(key, value);
    }

    final String getParentAbsolutePath() {
        if (this.parent == this.root) {
            return "";
        }
        return this.parent == null ? "" : this.parent.getAbsolutePath();
    }

    public final String getAbsolutePath() {
        if (this == this.root) {
            return String.valueOf(this.path == null ? "" : this.path);
        }
        if (!this.changed || !this.parent.isArray()) {
            return this.getParentAbsolutePath() + '/' + (this.path == null ? "" : this.path);
        }
        return this.getParentAbsolutePath() + '/' + CollectionUtils.indexOf(this.parent.elementValues, this);
    }

    public final String toString() {
        int hv = this.hashCode();
        String absolutePath = this.getAbsolutePath();
        if (this.leaf) {
            if (this.type == 3) {
                return "JNode@" + Integer.toHexString(hv) + "{path='" + absolutePath + "', value='" + this.leafValue + "'}";
            }
            return "JNode@" + Integer.toHexString(hv) + "{path='" + absolutePath + "', value=" + this.leafValue + "}";
        }
        return "JNode@" + Integer.toHexString(hv) + "{path='" + absolutePath + "'}";
    }

    JSONNode(RootContext rootContext, JSONNodeContext parseContext) {
        this.parseContext = parseContext;
        this.root = this;
        this.beginIndex = rootContext.beginIndex;
        this.offset = rootContext.beginIndex;
        this.endIndex = rootContext.endIndex;
        this.type = rootContext.type;
        this.leafValue = rootContext.leafValue;
        this.leaf = this.type > 2;
        this.isArray = this.type == 2;
        this.path = "/";
    }

    JSONNode(List<JSONNode> elementValues, int beginIndex, int endIndex, JSONNodeContext parseContext) {
        this.elementSize = elementValues.size();
        this.elementValues = elementValues.toArray(new JSONNode[this.elementSize]);
        this.completed = true;
        this.isArray = true;
        this.leaf = false;
        this.type = 2;
        this.parseContext = parseContext;
        this.beginIndex = beginIndex;
        this.endIndex = endIndex;
        this.root = this;
        this.path = "/";
    }

    JSONNode(Map<Serializable, JSONNode> fieldValues, int beginIndex, int endIndex, JSONNodeContext parseContext) {
        this.fieldValues = fieldValues;
        this.completed = true;
        this.isArray = false;
        this.leaf = false;
        this.type = 1;
        this.parseContext = parseContext;
        this.beginIndex = beginIndex;
        this.endIndex = endIndex;
        this.root = this;
        this.path = "/";
    }

    JSONNode(Serializable leafValue, int beginIndex, int endIndex, int type, JSONNodeContext parseContext, JSONNode rootNode) {
        this.leafValue = leafValue;
        this.completed = true;
        this.isArray = false;
        this.leaf = true;
        this.parseContext = parseContext;
        this.root = rootNode;
        this.beginIndex = beginIndex;
        this.endIndex = endIndex;
        this.type = type;
    }

    JSONNode(int beginIndex, int endIndex, int type, JSONNodeContext parseContext, JSONNode rootNode) {
        this.beginIndex = beginIndex;
        this.endIndex = endIndex;
        this.parseContext = parseContext;
        this.root = rootNode;
        this.type = type;
        this.leaf = type > 2;
        this.isArray = type == 2;
        this.offset = this.beginIndex;
    }

    static RootContext buildRootContext(char[] buf, int beginIndex, int endIndex) {
        int type;
        char start = '\u0000';
        char end = '\u0000';
        while (beginIndex < endIndex && (start = buf[beginIndex]) <= ' ') {
            ++beginIndex;
        }
        while (endIndex > beginIndex && (end = buf[endIndex - 1]) <= ' ') {
            --endIndex;
        }
        Boolean leafValue = null;
        if (start == '{' && end == '}') {
            type = 1;
        } else if (start == '[' && end == ']') {
            type = 2;
        } else if (start == '\"' && end == '\"') {
            type = 3;
        } else {
            int len = endIndex - beginIndex;
            switch (start) {
                case 't': {
                    long unsafeValue;
                    if (len == 4 && (unsafeValue = JSONUnsafe.getLong(buf, beginIndex)) == TRUE_LONG) {
                        type = 5;
                        leafValue = true;
                        break;
                    }
                    throw new JSONException("Syntax error, unexpected input '" + new String(buf, beginIndex, len) + "', position " + beginIndex);
                }
                case 'f': {
                    long unsafeValue;
                    if (len == 5 && (unsafeValue = JSONUnsafe.getLong(buf, beginIndex + 1)) == ALSE_LONG) {
                        type = 5;
                        leafValue = false;
                        break;
                    }
                    throw new JSONException("Syntax error, unexpected input '" + new String(buf, beginIndex, len) + "', position " + beginIndex);
                }
                case 'n': {
                    long unsafeValue;
                    if (len == 4 && (unsafeValue = JSONUnsafe.getLong(buf, beginIndex)) == NULL_LONG) {
                        type = 6;
                        leafValue = null;
                        break;
                    }
                    throw new JSONException("Syntax error, unexpected input '" + new String(buf, beginIndex, len) + "', position " + beginIndex);
                }
                default: {
                    type = 4;
                }
            }
        }
        return new RootContext(beginIndex, endIndex, type, leafValue);
    }

    static RootContext buildRootContext(byte[] buf, int beginIndex, int endIndex) {
        int type;
        byte start = 0;
        byte end = 0;
        while (beginIndex < endIndex && (start = buf[beginIndex]) <= 32) {
            ++beginIndex;
        }
        while (endIndex > beginIndex && (end = buf[endIndex - 1]) <= 32) {
            --endIndex;
        }
        Boolean leafValue = null;
        if (start == 123 && end == 125) {
            type = 1;
        } else if (start == 91 && end == 93) {
            type = 2;
        } else if (start == 34 && end == 34) {
            type = 3;
        } else {
            int len = endIndex - beginIndex;
            switch (start) {
                case 116: {
                    long unsafeValue;
                    if (len == 4 && (unsafeValue = (long)JSONUnsafe.getInt(buf, beginIndex)) == (long)TRUE_INT) {
                        type = 5;
                        leafValue = true;
                        break;
                    }
                    throw new JSONException("Syntax error, unexpected input '" + new String(buf, beginIndex, len) + "', position " + beginIndex);
                }
                case 102: {
                    long unsafeValue;
                    if (len == 5 && (unsafeValue = (long)JSONUnsafe.getInt(buf, beginIndex + 1)) == (long)ALSE_INT) {
                        type = 5;
                        leafValue = false;
                        break;
                    }
                    throw new JSONException("Syntax error, unexpected input '" + new String(buf, beginIndex, len) + "', position " + beginIndex);
                }
                case 110: {
                    long unsafeValue;
                    if (len == 4 && (unsafeValue = (long)JSONUnsafe.getInt(buf, beginIndex)) == (long)NULL_INT) {
                        type = 6;
                        leafValue = null;
                        break;
                    }
                    throw new JSONException("Syntax error, unexpected input '" + new String(buf, beginIndex, len) + "', position " + beginIndex);
                }
                default: {
                    type = 4;
                }
            }
        }
        return new RootContext(beginIndex, endIndex, type, leafValue);
    }

    public static JSONNode parse(String source, ReadOption ... readOptions) {
        return JSONNode.parseInternal(source, null, readOptions);
    }

    public static JSONNode parse(String source, String path, ReadOption ... readOptions) {
        return JSONNode.parseInternal(source, path, readOptions);
    }

    private static JSONNode parseInternal(String source, String path, ReadOption ... readOptions) {
        if (source == null) {
            return null;
        }
        source = source.trim();
        try {
            JSONNode root;
            JSONNodeContext parseContext = new JSONNodeContext();
            JSONOptions.readOptions(readOptions, parseContext);
            if (EnvUtils.JDK_9_PLUS) {
                byte[] bytes = (byte[])JSONUnsafe.getStringValue(source);
                if (bytes.length == source.length()) {
                    root = new B(AsciiStringSource.of(source, bytes), bytes, 0, bytes.length, parseContext);
                } else {
                    char[] chars = source.toCharArray();
                    root = new C(UTF16ByteArraySource.of(source), chars, 0, chars.length, parseContext);
                }
            } else {
                char[] chars = (char[])JSONUnsafe.getStringValue(source);
                root = new C(null, chars, 0, chars.length, parseContext);
            }
            if (path == null) {
                return root;
            }
            return root.get(path);
        }
        catch (Throwable throwable) {
            if (throwable instanceof JSONException) {
                throw (JSONException)throwable;
            }
            throw new JSONException(throwable.getMessage(), throwable);
        }
    }

    public static JSONNode from(String source, String path, ReadOption ... readOptions) {
        if (EnvUtils.JDK_9_PLUS) {
            byte[] bytes = (byte[])JSONUnsafe.getStringValue(source.toString());
            if (bytes.length == source.length()) {
                return JSONNode.parseInternal((CharSource)AsciiStringSource.of(source, bytes), bytes, path, readOptions);
            }
            char[] chars = source.toCharArray();
            return JSONNode.parseInternal((CharSource)UTF16ByteArraySource.of(source), chars, path, readOptions);
        }
        return JSONNode.parseInternal(null, (char[])JSONUnsafe.getStringValue(source.toString()), path, readOptions);
    }

    public static JSONNode from(char[] buf, String path, ReadOption ... readOptions) {
        return JSONNode.parseInternal(null, buf, path, readOptions);
    }

    static JSONNode parseInternal(CharSource charSource, char[] buf, String path, ReadOption ... readOptions) {
        JSONNodeContext parseContext = new JSONNodeContext();
        JSONOptions.readOptions(readOptions, parseContext);
        int toIndex = buf.length;
        if (path == null || (path = path.trim()).length() == 0) {
            return new C(charSource, buf, 0, toIndex, parseContext);
        }
        if (!path.startsWith("/")) {
            path = "/" + path;
        }
        return JSONNode.parseNode(charSource, buf, path, parseContext);
    }

    static JSONNode parseInternal(CharSource charSource, byte[] buf, String path, ReadOption ... readOptions) {
        JSONNodeContext parseContext = new JSONNodeContext();
        JSONOptions.readOptions(readOptions, parseContext);
        int toIndex = buf.length;
        if (path == null || (path = path.trim()).length() == 0) {
            return new B(charSource, buf, 0, toIndex, parseContext);
        }
        if (!path.startsWith("/")) {
            path = "/" + path;
        }
        return JSONNode.parseNode(charSource, buf, path, parseContext);
    }

    public static List extract(String json, String path, ReadOption ... readOptions) {
        if (EnvUtils.JDK_9_PLUS) {
            byte[] bytes = (byte[])JSONUnsafe.getStringValue(json.toString());
            if (bytes.length == json.length()) {
                return JSONNode.extractInternal((CharSource)AsciiStringSource.of(json, bytes), bytes, path, readOptions);
            }
            char[] chars = json.toCharArray();
            return JSONNode.extractInternal((CharSource)UTF16ByteArraySource.of(json), chars, path, readOptions);
        }
        return JSONNode.extractInternal(null, (char[])JSONUnsafe.getStringValue(json.toString()), path, readOptions);
    }

    public static List extract(char[] buf, String path, ReadOption ... readOptions) {
        return JSONNode.extractInternal(null, buf, path, readOptions);
    }

    static List extractInternal(CharSource charSource, char[] buf, String path, ReadOption ... readOptions) {
        JSONNodeContext parseContext = new JSONNodeContext();
        JSONOptions.readOptions(readOptions, parseContext);
        parseContext.extract = true;
        if (!path.startsWith("/")) {
            path = "/" + path;
        }
        JSONNode.parseNode(charSource, buf, path, parseContext);
        return parseContext.extractValues;
    }

    static List extractInternal(CharSource charSource, byte[] buf, String path, ReadOption ... readOptions) {
        JSONNodeContext parseContext = new JSONNodeContext();
        JSONOptions.readOptions(readOptions, parseContext);
        parseContext.extract = true;
        if (!path.startsWith("/")) {
            path = "/" + path;
        }
        JSONNode.parseNode(charSource, buf, path, parseContext);
        return parseContext.extractValues;
    }

    private static JSONNode parseNode(CharSource charSource, char[] buf, String path, JSONNodeContext parseContext) {
        int toIndex = buf.length;
        try {
            int endIndex;
            JSONNode result;
            int fromIndex;
            char beginChar = '\u0000';
            for (fromIndex = 0; fromIndex < toIndex && (beginChar = buf[fromIndex]) <= ' '; ++fromIndex) {
            }
            while (toIndex > fromIndex && buf[toIndex - 1] <= ' ') {
                --toIndex;
            }
            boolean allowComment = parseContext.allowComment;
            if (allowComment && beginChar == '/') {
                fromIndex = JSONNode.clearCommentAndWhiteSpaces(buf, fromIndex + 1, toIndex, (JSONParseContext)parseContext);
                beginChar = buf[fromIndex];
            }
            switch (beginChar) {
                case '{': {
                    result = JSONNode.parseObjectPathNode(charSource, buf, fromIndex, toIndex, path, 0, true, parseContext);
                    break;
                }
                case '[': {
                    result = JSONNode.parseArrayPathNode(charSource, buf, fromIndex, toIndex, path, 0, true, parseContext);
                    break;
                }
                case '\"': {
                    result = JSONNode.parseStringPathNode(charSource, buf, fromIndex, toIndex, false, parseContext, null);
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("Unsupported for begin character with '" + beginChar + "'");
                }
            }
            if (parseContext.validate && (endIndex = parseContext.endIndex) != toIndex - 1) {
                int wordNum = Math.min(50, buf.length - endIndex - 1);
                throw new JSONException("Syntax error, extra characters found, '" + new String(buf, endIndex + 1, wordNum) + "', at pos " + endIndex);
            }
            return result;
        }
        catch (Exception ex) {
            JSONNode.handleCatchException((Throwable)ex, buf, toIndex);
            throw new JSONException("Error: " + ex.getMessage(), ex);
        }
    }

    private static JSONNode parseNode(CharSource charSource, byte[] buf, String path, JSONNodeContext parseContext) {
        int toIndex = buf.length;
        try {
            int endIndex;
            JSONNode result;
            int fromIndex;
            byte beginByte = 0;
            for (fromIndex = 0; fromIndex < toIndex && (beginByte = buf[fromIndex]) <= 32; ++fromIndex) {
            }
            while (toIndex > fromIndex && buf[toIndex - 1] <= 32) {
                --toIndex;
            }
            boolean allowComment = parseContext.allowComment;
            if (allowComment && beginByte == 47) {
                fromIndex = JSONNode.clearCommentAndWhiteSpaces(buf, fromIndex + 1, toIndex, (JSONParseContext)parseContext);
                beginByte = buf[fromIndex];
            }
            switch (beginByte) {
                case 123: {
                    result = JSONNode.parseObjectPathNode(charSource, buf, fromIndex, toIndex, path, 0, true, parseContext);
                    break;
                }
                case 91: {
                    result = JSONNode.parseArrayPathNode(charSource, buf, fromIndex, toIndex, path, 0, true, parseContext);
                    break;
                }
                case 34: {
                    result = JSONNode.parseStringPathNode(charSource, buf, fromIndex, toIndex, false, parseContext, null);
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("Unsupported for begin character with '" + beginByte + "'");
                }
            }
            if (parseContext.validate && (endIndex = parseContext.endIndex) != toIndex - 1) {
                int wordNum = Math.min(50, buf.length - endIndex - 1);
                throw new JSONException("Syntax error, extra characters found, '" + new String(buf, endIndex + 1, wordNum) + "', at pos " + endIndex);
            }
            return result;
        }
        catch (Exception ex) {
            JSONNode.handleCatchException((Throwable)ex, buf, toIndex);
            throw new JSONException("Error: " + ex.getMessage(), ex);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static JSONNode parseObjectPathNode(CharSource charSource, char[] buf, int fromIndex, int toIndex, String path, int beginPathIndex, boolean returnIfMatched, JSONNodeContext jsonParseContext) throws Exception {
        int beginIndex = fromIndex + 1;
        String key = null;
        boolean empty = true;
        boolean allowComment = jsonParseContext.allowComment;
        LinkedHashMap<Serializable, JSONNode> fieldValues = null;
        boolean matched = false;
        boolean isLastPathLevel = false;
        int nextPathIndex = -1;
        if (beginPathIndex == -1) {
            isLastPathLevel = true;
        } else {
            nextPathIndex = path.indexOf(47, beginPathIndex + 1);
            boolean bl = isLastPathLevel = beginPathIndex == path.length() - 1;
        }
        if (isLastPathLevel) {
            fieldValues = new LinkedHashMap<Serializable, JSONNode>();
        }
        for (int i = beginIndex; i < toIndex; ++i) {
            boolean isClosingSymbol;
            JSONNode value;
            char ch;
            while ((ch = buf[i]) <= ' ') {
                ++i;
            }
            if (jsonParseContext.allowComment && ch == '/') {
                i = JSONNode.clearCommentAndWhiteSpaces(buf, i + 1, toIndex, (JSONParseContext)jsonParseContext);
                ch = buf[i];
            }
            if (ch == '\"') {
                key = JSONDefaultParser.parseMapKeyByCache(buf, i, toIndex, '\"', jsonParseContext);
                i = jsonParseContext.endIndex + 1;
                empty = false;
            } else {
                if (ch == '}') {
                    if (!empty) {
                        throw new JSONException("Syntax error, the closing symbol '}' is not allowed at pos " + i);
                    }
                    jsonParseContext.endIndex = i;
                    return null;
                }
                if (ch == '\'') {
                    if (!jsonParseContext.allowSingleQuotes) throw new JSONException("Syntax error, the single quote symbol ' is not allowed at pos " + i);
                    key = JSONDefaultParser.parseMapKeyByCache(buf, i, toIndex, '\'', jsonParseContext);
                    i = jsonParseContext.endIndex + 1;
                    empty = false;
                } else {
                    if (!jsonParseContext.allowUnquotedFieldNames) throw new JSONException("Syntax error, ''' or '\"' expected or add ReadOption.AllowUnquotedFieldNames ");
                    int begin = i;
                    while (i + 1 < toIndex && buf[++i] != ':') {
                    }
                    empty = false;
                    key = String.valueOf(JSONDefaultParser.parseKeyOfMap(buf, begin, i, true));
                }
            }
            while ((ch = buf[i]) <= ' ') {
                ++i;
            }
            if (allowComment && ch == '/') {
                i = JSONNode.clearCommentAndWhiteSpaces(buf, i + 1, toIndex, (JSONParseContext)jsonParseContext);
                ch = buf[i];
            }
            if (ch != ':') throw new JSONException("Syntax error, unexpected '" + ch + "', position " + i);
            if (!isLastPathLevel) {
                matched = JSONNode.stringEqual(path, beginPathIndex + 1, (nextPathIndex == -1 ? path.length() : nextPathIndex) - beginPathIndex - 1, key, 0, key.length());
            }
            while ((ch = buf[++i]) <= ' ') {
            }
            if (allowComment && ch == '/') {
                i = JSONNode.clearCommentAndWhiteSpaces(buf, i + 1, toIndex, (JSONParseContext)jsonParseContext);
                ch = buf[i];
            }
            boolean isLeafValue = false;
            boolean isSkipValue = isLastPathLevel ? false : !matched;
            boolean lazy = nextPathIndex == -1;
            switch (ch) {
                case '{': {
                    if (lazy || isSkipValue) {
                        JSONTypeDeserializer.MAP.skip(charSource, buf, i, toIndex, (JSONParseContext)jsonParseContext);
                        value = new C(charSource, buf, i, jsonParseContext.endIndex + 1, jsonParseContext);
                        break;
                    }
                    value = JSONNode.parseObjectPathNode(charSource, buf, i, toIndex, path, nextPathIndex, returnIfMatched, jsonParseContext);
                    break;
                }
                case '[': {
                    if (lazy || isSkipValue) {
                        JSONTypeDeserializer.COLLECTION.skip(charSource, buf, i, toIndex, (JSONParseContext)jsonParseContext);
                        value = new C(charSource, buf, i, jsonParseContext.endIndex + 1, jsonParseContext);
                        break;
                    }
                    value = JSONNode.parseArrayPathNode(charSource, buf, i, toIndex, path, nextPathIndex, returnIfMatched, jsonParseContext);
                    break;
                }
                case '\"': {
                    isLeafValue = true;
                    value = JSONNode.parseStringPathNode(charSource, buf, i, toIndex, isSkipValue, jsonParseContext, null);
                    break;
                }
                case 'n': {
                    isLeafValue = true;
                    value = JSONNode.parseNullPathNode(charSource, buf, i, toIndex, jsonParseContext, null);
                    break;
                }
                case 't': {
                    isLeafValue = true;
                    value = JSONNode.parseBoolTruePathNode(charSource, buf, i, toIndex, jsonParseContext, null);
                    i = jsonParseContext.endIndex;
                    break;
                }
                case 'f': {
                    isLeafValue = true;
                    value = JSONNode.parseBoolFalsePathNode(charSource, buf, i, toIndex, jsonParseContext, null);
                    break;
                }
                default: {
                    isLeafValue = true;
                    value = JSONNode.parseNumberPathNode(charSource, buf, i, toIndex, '}', jsonParseContext, null);
                }
            }
            i = jsonParseContext.endIndex;
            while ((ch = buf[++i]) <= ' ') {
            }
            if (allowComment && ch == '/') {
                i = JSONNode.clearCommentAndWhiteSpaces(buf, i + 1, toIndex, (JSONParseContext)jsonParseContext);
                ch = buf[i];
            }
            if (matched) {
                if (isLeafValue && nextPathIndex > -1) {
                    throw new JSONException(String.format("path '%s' error, '%s' is the last leaf level, The following path '%s' does not exist ", path, path.substring(0, nextPathIndex), path.substring(nextPathIndex)));
                }
                if ((isLastPathLevel || isLeafValue || nextPathIndex == -1) && jsonParseContext.extract) {
                    jsonParseContext.extractValue(isLeafValue ? value.leafValue : value);
                }
                jsonParseContext.endIndex = i;
                if (returnIfMatched) {
                    return value;
                }
            }
            boolean bl = isClosingSymbol = ch == '}';
            if (ch != ',' && !isClosingSymbol) throw new JSONException("Syntax error, unexpected '" + ch + "', position " + i);
            if (fieldValues != null) {
                JSONNode.addFieldValue(fieldValues, (Serializable)((Object)key), value);
            }
            if (!isClosingSymbol) continue;
            jsonParseContext.endIndex = i;
            if (!isLastPathLevel) return null;
            return new C(charSource, fieldValues, buf, fromIndex, i + 1, jsonParseContext);
        }
        throw new JSONException("Syntax error, the closing symbol '}' is not found ");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static JSONNode parseObjectPathNode(CharSource charSource, byte[] buf, int fromIndex, int toIndex, String path, int beginPathIndex, boolean returnIfMatched, JSONNodeContext jsonParseContext) throws Exception {
        int beginIndex = fromIndex + 1;
        String key = null;
        boolean empty = true;
        boolean allowComment = jsonParseContext.allowComment;
        LinkedHashMap<Serializable, JSONNode> fieldValues = null;
        boolean matched = false;
        boolean isLastPathLevel = false;
        int nextPathIndex = -1;
        if (beginPathIndex == -1) {
            isLastPathLevel = true;
        } else {
            nextPathIndex = path.indexOf(47, beginPathIndex + 1);
            boolean bl = isLastPathLevel = beginPathIndex == path.length() - 1;
        }
        if (isLastPathLevel) {
            fieldValues = new LinkedHashMap<Serializable, JSONNode>();
        }
        for (int i = beginIndex; i < toIndex; ++i) {
            boolean isClosingSymbol;
            JSONNode value;
            byte b;
            while ((b = buf[i]) <= 32) {
                ++i;
            }
            if (jsonParseContext.allowComment && b == 47) {
                i = JSONNode.clearCommentAndWhiteSpaces(buf, i + 1, toIndex, (JSONParseContext)jsonParseContext);
                b = buf[i];
            }
            if (b == 34) {
                key = JSONTypeDeserializer.parseMapKeyByCache(buf, i, toIndex, '\"', jsonParseContext);
                i = jsonParseContext.endIndex + 1;
                empty = false;
            } else {
                if (b == 125) {
                    if (!empty) {
                        throw new JSONException("Syntax error, the closing symbol '}' is not allowed at pos " + i);
                    }
                    jsonParseContext.endIndex = i;
                    return null;
                }
                if (b == 39) {
                    if (!jsonParseContext.allowSingleQuotes) throw new JSONException("Syntax error, the single quote symbol ' is not allowed at pos " + i);
                    key = JSONTypeDeserializer.parseMapKeyByCache(buf, i, toIndex, '\'', jsonParseContext);
                    i = jsonParseContext.endIndex + 1;
                    empty = false;
                } else if (jsonParseContext.allowUnquotedFieldNames) {
                    int begin = i;
                    while (i + 1 < toIndex && buf[++i] != 58) {
                    }
                    empty = false;
                    key = String.valueOf(JSONDefaultParser.parseKeyOfMap(buf, begin, i, true));
                }
            }
            while ((b = buf[i]) <= 32) {
                ++i;
            }
            if (allowComment && b == 47) {
                i = JSONNode.clearCommentAndWhiteSpaces(buf, i + 1, toIndex, (JSONParseContext)jsonParseContext);
                b = buf[i];
            }
            if (b != 58) throw new JSONException("Syntax error, unexpected '" + b + "', position " + i);
            if (!isLastPathLevel) {
                matched = JSONNode.stringEqual(path, beginPathIndex + 1, (nextPathIndex == -1 ? path.length() : nextPathIndex) - beginPathIndex - 1, key, 0, key.length());
            }
            while ((b = buf[++i]) <= 32) {
            }
            if (allowComment && b == 47) {
                i = JSONNode.clearCommentAndWhiteSpaces(buf, i + 1, toIndex, (JSONParseContext)jsonParseContext);
                b = buf[i];
            }
            boolean isLeafValue = false;
            boolean isSkipValue = isLastPathLevel ? false : !matched;
            boolean lazy = nextPathIndex == -1;
            switch (b) {
                case 123: {
                    if (lazy || isSkipValue) {
                        JSONTypeDeserializer.MAP.skip(charSource, buf, i, toIndex, (JSONParseContext)jsonParseContext);
                        value = new B(charSource, buf, i, jsonParseContext.endIndex + 1, jsonParseContext);
                        break;
                    }
                    value = JSONNode.parseObjectPathNode(charSource, buf, i, toIndex, path, nextPathIndex, returnIfMatched, jsonParseContext);
                    break;
                }
                case 91: {
                    if (lazy || isSkipValue) {
                        JSONTypeDeserializer.COLLECTION.skip(charSource, buf, i, toIndex, (JSONParseContext)jsonParseContext);
                        value = new B(charSource, buf, i, jsonParseContext.endIndex + 1, jsonParseContext);
                        break;
                    }
                    value = JSONNode.parseArrayPathNode(charSource, buf, i, toIndex, path, nextPathIndex, returnIfMatched, jsonParseContext);
                    break;
                }
                case 34: {
                    isLeafValue = true;
                    value = JSONNode.parseStringPathNode(charSource, buf, i, toIndex, isSkipValue, jsonParseContext, null);
                    break;
                }
                case 110: {
                    isLeafValue = true;
                    value = JSONNode.parseNullPathNode(charSource, buf, i, toIndex, jsonParseContext, null);
                    break;
                }
                case 116: {
                    isLeafValue = true;
                    value = JSONNode.parseBoolTruePathNode(charSource, buf, i, toIndex, jsonParseContext, null);
                    break;
                }
                case 102: {
                    isLeafValue = true;
                    value = JSONNode.parseBoolFalsePathNode(charSource, buf, i, toIndex, jsonParseContext, null);
                    break;
                }
                default: {
                    isLeafValue = true;
                    value = JSONNode.parseNumberPathNode(charSource, buf, i, toIndex, (byte)125, jsonParseContext, null);
                }
            }
            i = jsonParseContext.endIndex;
            while ((b = buf[++i]) <= 32) {
            }
            if (allowComment && b == 47) {
                i = JSONNode.clearCommentAndWhiteSpaces(buf, i + 1, toIndex, (JSONParseContext)jsonParseContext);
                b = buf[i];
            }
            if (matched) {
                if (isLeafValue && nextPathIndex > -1) {
                    throw new JSONException(String.format("path '%s' error, '%s' is the last leaf level, The following path '%s' does not exist ", path, path.substring(0, nextPathIndex), path.substring(nextPathIndex)));
                }
                if ((isLastPathLevel || isLeafValue || nextPathIndex == -1) && jsonParseContext.extract) {
                    jsonParseContext.extractValue(isLeafValue ? value.leafValue : value);
                }
                jsonParseContext.endIndex = i;
                if (returnIfMatched) {
                    return value;
                }
            }
            boolean bl = isClosingSymbol = b == 125;
            if (b != 44 && !isClosingSymbol) throw new JSONException("Syntax error, unexpected '" + b + "', position " + i);
            if (fieldValues != null) {
                JSONNode.addFieldValue(fieldValues, (Serializable)((Object)key), value);
            }
            if (!isClosingSymbol) continue;
            jsonParseContext.endIndex = i;
            if (!isLastPathLevel) return null;
            return new B(null, fieldValues, buf, fromIndex, i + 1, jsonParseContext);
        }
        throw new JSONException("Syntax error, the closing symbol '}' is not found ");
    }

    private static boolean stringEqual(String path, int s1, int len1, String key, int s2, int len2) {
        if (len1 != len2) {
            return false;
        }
        for (int i = 0; i < len1; ++i) {
            if (path.charAt(s1 + i) == key.charAt(s2 + i)) continue;
            return false;
        }
        return true;
    }

    private static JSONNode parseArrayPathNode(CharSource charSource, char[] buf, int fromIndex, int toIndex, String path, int beginPathIndex, boolean returnIfMatched, JSONNodeContext jsonParseContext) throws Exception {
        int beginIndex = fromIndex + 1;
        ArrayList<JSONNode> elementValues = null;
        boolean allowComment = jsonParseContext.allowComment;
        int elementIndex = 0;
        boolean fetchAllElement = false;
        boolean matched = false;
        boolean isLastPathLevel = false;
        boolean returnValueIfMathched = false;
        int targetElementIndex = -1;
        boolean EqualMode = false;
        boolean GtMode = true;
        int LtMode = -1;
        int AllMode = 2;
        int compareMode = 0;
        int nextPathIndex = -1;
        if (beginPathIndex == -1) {
            isLastPathLevel = true;
            matched = true;
            fetchAllElement = true;
        } else {
            int endPathIndex;
            nextPathIndex = path.indexOf(47, beginPathIndex + 1);
            int n = endPathIndex = nextPathIndex == -1 ? path.length() : nextPathIndex;
            if (beginPathIndex + 1 < endPathIndex) {
                int numEndIndex;
                int numBeginIndex;
                if (path.charAt(beginPathIndex + 1) == '[' && path.charAt(endPathIndex - 1) == ']') {
                    numBeginIndex = beginPathIndex + 2;
                    numEndIndex = endPathIndex - 1;
                } else {
                    numBeginIndex = beginPathIndex + 1;
                    numEndIndex = endPathIndex;
                }
                int len = numEndIndex - numBeginIndex;
                if (len <= 0) {
                    throw new UnsupportedOperationException("Path error, array element access must use [n] or n, n is a int value ");
                }
                char endCharOfPath = path.charAt(numEndIndex - 1);
                switch (endCharOfPath) {
                    case '*': {
                        if (len == 1) {
                            compareMode = 2;
                            fetchAllElement = true;
                            matched = true;
                            break;
                        }
                    }
                    case '+': {
                        compareMode = 1;
                    }
                    case '-': {
                        if (compareMode == 0) {
                            compareMode = -1;
                        }
                        --numEndIndex;
                    }
                    default: {
                        if (compareMode == 0) {
                            returnValueIfMathched = true;
                        }
                        targetElementIndex = JSONNode.readArrayIndex(path, numBeginIndex, numEndIndex - numBeginIndex);
                    }
                }
            }
            boolean bl = isLastPathLevel = nextPathIndex == -1 || beginPathIndex == path.length() - 1;
        }
        if (isLastPathLevel || !returnValueIfMathched) {
            elementValues = new ArrayList<JSONNode>();
        }
        for (int i = beginIndex; i < toIndex; ++i) {
            boolean isEnd;
            JSONNode value;
            char ch;
            boolean returnListIfMathched = false;
            if (!fetchAllElement) {
                int index = elementIndex++;
                switch (compareMode) {
                    case -1: {
                        matched = index <= targetElementIndex;
                        returnListIfMathched = index == targetElementIndex;
                        break;
                    }
                    case 0: {
                        matched = index == targetElementIndex;
                        break;
                    }
                    case 1: {
                        matched = index >= targetElementIndex;
                        break;
                    }
                    default: {
                        matched = true;
                    }
                }
            }
            while ((ch = buf[i]) <= ' ') {
                ++i;
            }
            if (allowComment && ch == '/') {
                i = JSONNode.clearCommentAndWhiteSpaces(buf, i + 1, toIndex, (JSONParseContext)jsonParseContext);
                ch = buf[i];
            }
            if (ch == ']') {
                if (elementValues != null && elementValues.size() > 0) {
                    throw new JSONException("Syntax error, not allowed ',' followed by ']', pos " + i);
                }
                jsonParseContext.endIndex = i;
                return null;
            }
            boolean isLeafValue = false;
            boolean isSkipValue = !matched;
            boolean lazy = nextPathIndex == -1;
            switch (ch) {
                case '{': {
                    if (lazy || isSkipValue) {
                        JSONTypeDeserializer.MAP.skip(charSource, buf, i, toIndex, (JSONParseContext)jsonParseContext);
                        value = new C(charSource, buf, i, jsonParseContext.endIndex + 1, jsonParseContext);
                        break;
                    }
                    value = JSONNode.parseObjectPathNode(charSource, buf, i, toIndex, path, nextPathIndex, returnValueIfMathched, jsonParseContext);
                    break;
                }
                case '[': {
                    if (lazy || isSkipValue) {
                        JSONTypeDeserializer.COLLECTION.skip(charSource, buf, i, toIndex, (JSONParseContext)jsonParseContext);
                        value = new C(charSource, buf, i, jsonParseContext.endIndex + 1, jsonParseContext);
                        break;
                    }
                    value = JSONNode.parseArrayPathNode(charSource, buf, i, toIndex, path, nextPathIndex, returnValueIfMathched, jsonParseContext);
                    break;
                }
                case '\"': {
                    isLeafValue = true;
                    value = JSONNode.parseStringPathNode(charSource, buf, i, toIndex, isSkipValue, jsonParseContext, null);
                    break;
                }
                case 'n': {
                    isLeafValue = true;
                    value = JSONNode.parseNullPathNode(charSource, buf, i, toIndex, jsonParseContext, null);
                    break;
                }
                case 't': {
                    isLeafValue = true;
                    value = JSONNode.parseBoolTruePathNode(charSource, buf, i, toIndex, jsonParseContext, null);
                    break;
                }
                case 'f': {
                    isLeafValue = true;
                    value = JSONNode.parseBoolFalsePathNode(charSource, buf, i, toIndex, jsonParseContext, null);
                    break;
                }
                default: {
                    isLeafValue = true;
                    value = JSONNode.parseNumberPathNode(charSource, buf, i, toIndex, ']', jsonParseContext, null);
                }
            }
            if (matched && elementValues != null) {
                elementValues.add(value);
            }
            i = jsonParseContext.endIndex;
            while (i + 1 < toIndex && (ch = buf[++i]) <= ' ') {
            }
            if (allowComment && ch == '/') {
                i = JSONNode.clearCommentAndWhiteSpaces(buf, i + 1, toIndex, (JSONParseContext)jsonParseContext);
                ch = buf[i];
            }
            if (matched) {
                if (isLeafValue && nextPathIndex > -1) {
                    throw new JSONException(String.format("path '%s' error, '%s' is the last level, The following path '%s' does not exist ", path, path.substring(0, nextPathIndex), path.substring(nextPathIndex)));
                }
                if (isLastPathLevel && jsonParseContext.extract) {
                    jsonParseContext.extractValue(isLeafValue ? value.leafValue : value);
                }
                if (returnIfMatched && returnValueIfMathched) {
                    return value;
                }
                if (returnListIfMathched) {
                    if (isLastPathLevel) {
                        return new C(charSource, elementValues, buf, fromIndex, i + 1, jsonParseContext);
                    }
                    return null;
                }
            }
            boolean bl = isEnd = ch == ']';
            if (ch == ',' || isEnd) {
                if (!isEnd) continue;
                jsonParseContext.endIndex = i;
                if (isLastPathLevel) {
                    return new C(charSource, elementValues, buf, fromIndex, i + 1, jsonParseContext);
                }
                return null;
            }
            throw new JSONException("Syntax error, unexpected '" + ch + "', position " + i + ", Missing ',' or '}'");
        }
        throw new JSONException("Syntax error, the closing symbol ']' is not found ");
    }

    private static JSONNode parseArrayPathNode(CharSource charSource, byte[] buf, int fromIndex, int toIndex, String path, int beginPathIndex, boolean returnIfMatched, JSONNodeContext jsonParseContext) throws Exception {
        int beginIndex = fromIndex + 1;
        ArrayList<JSONNode> elementValues = null;
        boolean allowComment = jsonParseContext.allowComment;
        int elementIndex = 0;
        boolean fetchAllElement = false;
        boolean matched = false;
        boolean isLastPathLevel = false;
        boolean returnValueIfMathched = false;
        int targetElementIndex = -1;
        boolean EqualMode = false;
        boolean GtMode = true;
        int LtMode = -1;
        int AllMode = 2;
        int compareMode = 0;
        int nextPathIndex = -1;
        if (beginPathIndex == -1) {
            isLastPathLevel = true;
            matched = true;
            fetchAllElement = true;
        } else {
            int endPathIndex;
            nextPathIndex = path.indexOf(47, beginPathIndex + 1);
            int n = endPathIndex = nextPathIndex == -1 ? path.length() : nextPathIndex;
            if (beginPathIndex + 1 < endPathIndex) {
                int numEndIndex;
                int numBeginIndex;
                if (path.charAt(beginPathIndex + 1) == '[' && path.charAt(endPathIndex - 1) == ']') {
                    numBeginIndex = beginPathIndex + 2;
                    numEndIndex = endPathIndex - 1;
                } else {
                    numBeginIndex = beginPathIndex + 1;
                    numEndIndex = endPathIndex;
                }
                int len = numEndIndex - numBeginIndex;
                if (len <= 0) {
                    throw new UnsupportedOperationException("Path error, array element access must use [n] or n, n is a int value ");
                }
                char endCharOfPath = path.charAt(numEndIndex - 1);
                switch (endCharOfPath) {
                    case '*': {
                        if (len == 1) {
                            compareMode = 2;
                            fetchAllElement = true;
                            matched = true;
                            break;
                        }
                    }
                    case '+': {
                        compareMode = 1;
                    }
                    case '-': {
                        if (compareMode == 0) {
                            compareMode = -1;
                        }
                        --numEndIndex;
                    }
                    default: {
                        if (compareMode == 0) {
                            returnValueIfMathched = true;
                        }
                        targetElementIndex = JSONNode.readArrayIndex(path, numBeginIndex, numEndIndex - numBeginIndex);
                    }
                }
            }
            boolean bl = isLastPathLevel = nextPathIndex == -1 || beginPathIndex == path.length() - 1;
        }
        if (isLastPathLevel || !returnValueIfMathched) {
            elementValues = new ArrayList<JSONNode>();
        }
        for (int i = beginIndex; i < toIndex; ++i) {
            boolean isEnd;
            JSONNode value;
            byte ch;
            boolean returnListIfMathched = false;
            if (!fetchAllElement) {
                int index = elementIndex++;
                switch (compareMode) {
                    case -1: {
                        matched = index <= targetElementIndex;
                        returnListIfMathched = index == targetElementIndex;
                        break;
                    }
                    case 0: {
                        matched = index == targetElementIndex;
                        break;
                    }
                    case 1: {
                        matched = index >= targetElementIndex;
                        break;
                    }
                    default: {
                        matched = true;
                    }
                }
            }
            while ((ch = buf[i]) <= 32) {
                ++i;
            }
            if (allowComment && ch == 47) {
                i = JSONNode.clearCommentAndWhiteSpaces(buf, i + 1, toIndex, (JSONParseContext)jsonParseContext);
                ch = buf[i];
            }
            if (ch == 93) {
                if (elementValues != null && elementValues.size() > 0) {
                    throw new JSONException("Syntax error, not allowed ',' followed by ']', pos " + i);
                }
                jsonParseContext.endIndex = i;
                return null;
            }
            boolean isLeafValue = false;
            boolean isSkipValue = !matched;
            boolean lazy = nextPathIndex == -1;
            switch (ch) {
                case 123: {
                    if (lazy || isSkipValue) {
                        JSONTypeDeserializer.MAP.skip(charSource, buf, i, toIndex, (JSONParseContext)jsonParseContext);
                        value = new B(charSource, buf, i, jsonParseContext.endIndex + 1, jsonParseContext);
                        break;
                    }
                    value = JSONNode.parseObjectPathNode(charSource, buf, i, toIndex, path, nextPathIndex, returnValueIfMathched, jsonParseContext);
                    break;
                }
                case 91: {
                    if (lazy || isSkipValue) {
                        JSONTypeDeserializer.COLLECTION.skip(charSource, buf, i, toIndex, (JSONParseContext)jsonParseContext);
                        value = new B(charSource, buf, i, jsonParseContext.endIndex + 1, jsonParseContext);
                        break;
                    }
                    value = JSONNode.parseArrayPathNode(charSource, buf, i, toIndex, path, nextPathIndex, returnValueIfMathched, jsonParseContext);
                    break;
                }
                case 34: {
                    isLeafValue = true;
                    value = JSONNode.parseStringPathNode(charSource, buf, i, toIndex, isSkipValue, jsonParseContext, null);
                    break;
                }
                case 110: {
                    isLeafValue = true;
                    value = JSONNode.parseNullPathNode(charSource, buf, i, toIndex, jsonParseContext, null);
                    break;
                }
                case 116: {
                    isLeafValue = true;
                    value = JSONNode.parseBoolTruePathNode(charSource, buf, i, toIndex, jsonParseContext, null);
                    break;
                }
                case 102: {
                    isLeafValue = true;
                    value = JSONNode.parseBoolFalsePathNode(charSource, buf, i, toIndex, jsonParseContext, null);
                    break;
                }
                default: {
                    isLeafValue = true;
                    value = JSONNode.parseNumberPathNode(charSource, buf, i, toIndex, (byte)93, jsonParseContext, null);
                }
            }
            if (matched && elementValues != null) {
                elementValues.add(value);
            }
            i = jsonParseContext.endIndex;
            while (i + 1 < toIndex && (ch = buf[++i]) <= 32) {
            }
            if (allowComment && ch == 47) {
                i = JSONNode.clearCommentAndWhiteSpaces(buf, i + 1, toIndex, (JSONParseContext)jsonParseContext);
                ch = buf[i];
            }
            if (matched) {
                if (isLeafValue && nextPathIndex > -1) {
                    throw new JSONException(String.format("path '%s' error, '%s' is the last level, The following path '%s' does not exist ", path, path.substring(0, nextPathIndex), path.substring(nextPathIndex)));
                }
                if (isLastPathLevel && jsonParseContext.extract) {
                    jsonParseContext.extractValue(isLeafValue ? value.leafValue : value);
                }
                if (returnIfMatched && returnValueIfMathched) {
                    return value;
                }
                if (returnListIfMathched) {
                    if (isLastPathLevel) {
                        return new B(charSource, elementValues, buf, fromIndex, i + 1, jsonParseContext);
                    }
                    return null;
                }
            }
            boolean bl = isEnd = ch == 93;
            if (ch == 44 || isEnd) {
                if (!isEnd) continue;
                jsonParseContext.endIndex = i;
                if (isLastPathLevel) {
                    return new B(null, elementValues, buf, fromIndex, i + 1, jsonParseContext);
                }
                return null;
            }
            throw new JSONException("Syntax error, unexpected '" + ch + "', position " + i + ", Missing ',' or '}'");
        }
        throw new JSONException("Syntax error, the closing symbol ']' is not found ");
    }

    private static JSONNode parseStringPathNode(CharSource charSource, char[] buf, int fromIndex, int toIndex, boolean skipValue, JSONNodeContext jsonParseContext, JSONNode rootNode) throws Exception {
        if (skipValue) {
            JSONTypeDeserializer.CHAR_SEQUENCE_STRING.skip(charSource, buf, fromIndex, '\"', (JSONParseContext)jsonParseContext);
            return null;
        }
        String value = (String)JSONTypeDeserializer.CHAR_SEQUENCE_STRING.deserializeString(charSource, buf, fromIndex, toIndex, '\"', GenericParameterizedType.StringType, (JSONParseContext)jsonParseContext);
        int endIndex = jsonParseContext.endIndex;
        return new C(charSource, (Serializable)((Object)value), buf, fromIndex, endIndex + 1, 3, jsonParseContext, rootNode);
    }

    private static JSONNode parseStringPathNode(CharSource charSource, byte[] buf, int fromIndex, int toIndex, boolean skipValue, JSONNodeContext jsonParseContext, JSONNode rootNode) throws Exception {
        if (skipValue) {
            JSONTypeDeserializer.CHAR_SEQUENCE_STRING.skip(charSource, buf, fromIndex, 34, (JSONParseContext)jsonParseContext);
            return null;
        }
        String value = (String)JSONTypeDeserializer.CHAR_SEQUENCE_STRING.deserializeString(charSource, buf, fromIndex, toIndex, 34, GenericParameterizedType.StringType, (JSONParseContext)jsonParseContext);
        int endIndex = jsonParseContext.endIndex;
        return new B(charSource, (Serializable)((Object)value), buf, fromIndex, endIndex + 1, 3, jsonParseContext, rootNode);
    }

    private static JSONNode parseNullPathNode(CharSource charSource, char[] buf, int fromIndex, int toIndex, JSONNodeContext jsonParseContext, JSONNode rootNode) throws Exception {
        JSONTypeDeserializer.NULL.deserialize(charSource, buf, fromIndex, toIndex, null, null, (JSONParseContext)jsonParseContext);
        int endIndex = jsonParseContext.endIndex;
        return new C(charSource, null, buf, fromIndex, endIndex + 1, 6, jsonParseContext, rootNode);
    }

    private static JSONNode parseNullPathNode(CharSource charSource, byte[] buf, int fromIndex, int toIndex, JSONNodeContext jsonParseContext, JSONNode rootNode) throws Exception {
        JSONTypeDeserializer.NULL.deserialize(charSource, buf, fromIndex, toIndex, null, null, (JSONParseContext)jsonParseContext);
        int endIndex = jsonParseContext.endIndex;
        return new B(charSource, null, buf, fromIndex, endIndex + 1, 6, jsonParseContext, rootNode);
    }

    private static JSONNode parseBoolTruePathNode(CharSource charSource, char[] buf, int fromIndex, int toIndex, JSONNodeContext jsonParseContext, JSONNode rootNode) throws Exception {
        JSONTypeDeserializer.parseTrue(buf, fromIndex, toIndex, (JSONParseContext)jsonParseContext);
        int endIndex = jsonParseContext.endIndex;
        return new C(charSource, Boolean.valueOf(true), buf, fromIndex, endIndex + 1, 5, jsonParseContext, rootNode);
    }

    private static JSONNode parseBoolTruePathNode(CharSource charSource, byte[] buf, int fromIndex, int toIndex, JSONNodeContext jsonParseContext, JSONNode rootNode) throws Exception {
        JSONTypeDeserializer.parseTrue(buf, fromIndex, toIndex, (JSONParseContext)jsonParseContext);
        int endIndex = jsonParseContext.endIndex;
        return new B(charSource, Boolean.valueOf(true), buf, fromIndex, endIndex + 1, 5, jsonParseContext, rootNode);
    }

    private static JSONNode parseBoolFalsePathNode(CharSource charSource, char[] buf, int fromIndex, int toIndex, JSONNodeContext jsonParseContext, JSONNode rootNode) throws Exception {
        JSONTypeDeserializer.parseFalse(buf, fromIndex, toIndex, (JSONParseContext)jsonParseContext);
        int endIndex = jsonParseContext.endIndex;
        return new C(charSource, Boolean.valueOf(false), buf, fromIndex, endIndex + 1, 5, jsonParseContext, rootNode);
    }

    private static JSONNode parseBoolFalsePathNode(CharSource charSource, byte[] buf, int fromIndex, int toIndex, JSONNodeContext jsonParseContext, JSONNode rootNode) throws Exception {
        JSONTypeDeserializer.parseFalse(buf, fromIndex, toIndex, (JSONParseContext)jsonParseContext);
        int endIndex = jsonParseContext.endIndex;
        return new B(charSource, Boolean.valueOf(false), buf, fromIndex, endIndex + 1, 5, jsonParseContext, rootNode);
    }

    private static JSONNode parseNumberPathNode(CharSource charSource, char[] buf, int fromIndex, int toIndex, char endToken, JSONNodeContext jsonParseContext, JSONNode rootNode) throws Exception {
        Number value = (Number)JSONTypeDeserializer.NUMBER.deserialize(charSource, buf, fromIndex, toIndex, GenericParameterizedType.AnyType, null, endToken, (JSONParseContext)jsonParseContext);
        int endIndex = jsonParseContext.endIndex;
        return new C(charSource, value, buf, fromIndex, endIndex + 1, 4, jsonParseContext, rootNode);
    }

    private static JSONNode parseNumberPathNode(CharSource charSource, byte[] buf, int fromIndex, int toIndex, byte endToken, JSONNodeContext jsonParseContext, JSONNode rootNode) throws Exception {
        Number value = (Number)JSONTypeDeserializer.NUMBER.deserialize(charSource, buf, fromIndex, toIndex, GenericParameterizedType.AnyType, null, endToken, (JSONParseContext)jsonParseContext);
        int endIndex = jsonParseContext.endIndex;
        return new B(charSource, value, buf, fromIndex, endIndex + 1, 4, jsonParseContext, rootNode);
    }

    public final JSONNode root() {
        return this.root;
    }

    public final JSONNode get(String path) {
        if (path == null) {
            return this;
        }
        path = path.trim();
        return this.get(path, 0, path.length());
    }

    private JSONNode get(String path, int beginIndex, int endIndex) {
        if (beginIndex == endIndex) {
            return this;
        }
        char beginChar = path.charAt(beginIndex);
        if (beginChar == '/') {
            return this.root.get(path, beginIndex + 1, endIndex);
        }
        if (this.leaf) {
            return null;
        }
        int splitIndex = path.indexOf(47, beginIndex + 1);
        if (splitIndex == -1) {
            return this.getPathNode(path, beginIndex, endIndex - beginIndex);
        }
        JSONNode childNode = this.getPathNode(path, beginIndex, splitIndex - beginIndex);
        if (childNode != null) {
            return childNode.get(path, splitIndex + 1, endIndex);
        }
        return null;
    }

    public final Collection<Serializable> keyNames() {
        if (this.isArray) {
            throw new UnsupportedOperationException();
        }
        if (!this.completed) {
            this.parseFullNode();
        }
        return this.fieldValues.keySet();
    }

    private JSONNode getPathNode(String path, int offset, int len) {
        if (this.isArray) {
            char ch = path.charAt(offset);
            int digit = JSONNode.digitDecimal(ch);
            int index = -1;
            try {
                if (digit > -1) {
                    index = digit;
                    int end = offset + len;
                    for (int i = offset + 1; i < end; ++i) {
                        ch = path.charAt(i);
                        digit = JSONNode.digitDecimal(ch);
                        if (digit != -1) {
                            index = index * 10 + digit;
                            continue;
                        }
                        if (ch <= ' ') continue;
                        throw new IllegalArgumentException("mismatch array index '" + path.substring(offset, offset + len) + "'");
                    }
                } else {
                    char endChar = path.charAt(offset + len - 1);
                    if (ch == '[' && endChar == ']') {
                        index = JSONNode.readArrayIndex(path, offset + 1, len - 2);
                    }
                }
                return this.getElementAt(index);
            }
            catch (Throwable throwable) {
                throw new IllegalArgumentException("mismatch array index '" + path.substring(offset, offset + len) + "'");
            }
        }
        String field = this.matchFieldName(path, offset, len);
        return this.getFieldNodeAt(field);
    }

    private String matchFieldName(String path, int offset, int len) {
        long hashValue = 92L;
        if (EnvUtils.JDK_9_PLUS) {
            byte[] bytes = (byte[])JSONNode.getStringValue(path);
            for (int i = 0; i < len; ++i) {
                byte ch = bytes[offset + i];
                hashValue = hashValue << 8 | (long)ch;
            }
            if (len <= 8) {
                return this.parseContext.getCacheEightBytesKey(bytes, offset, len, hashValue);
            }
            return this.parseContext.getCacheKey(bytes, offset, len, hashValue);
        }
        char[] chars = (char[])JSONNode.getStringValue(path);
        boolean ascii = true;
        for (int i = 0; i < len; ++i) {
            char ch = chars[offset + i];
            if (ch > '\u00ff') {
                hashValue = hashValue << 16 | (long)ch;
                ascii = false;
                continue;
            }
            hashValue = hashValue << 8 | (long)ch;
        }
        if (ascii && len <= 8) {
            return this.parseContext.getCacheEightCharsKey(chars, offset, len, hashValue);
        }
        return this.parseContext.getCacheKey(chars, offset, len, hashValue);
    }

    private JSONNode getFieldNodeAt(String field) {
        JSONNode value = null;
        if (this.fieldValues == null) {
            this.fieldValues = new LinkedHashMap<Serializable, JSONNode>(16);
        } else {
            value = this.fieldValues.get(field);
        }
        if (value != null) {
            return value;
        }
        if (this.completed) {
            return null;
        }
        return this.parseFieldNode(field, false);
    }

    private JSONNode getPathNode(String field) {
        if (this.isArray) {
            int index;
            int length = field.length();
            try {
                index = field.charAt(0) == '[' && field.charAt(length - 1) == ']' ? JSONNode.readArrayIndex(field, 1, length - 2) : JSONNode.readArrayIndex(field, 0, length);
            }
            catch (NumberFormatException exception) {
                throw new IllegalArgumentException(" field '" + field + " is mismatch array index ");
            }
            if (index > -1) {
                return this.getElementAt(index);
            }
            throw new IllegalArgumentException(" key '" + field + " is mismatch array index ");
        }
        return this.getFieldNodeAt(field);
    }

    protected static int readArrayIndex(String buf, int offset, int len) {
        int i;
        if (len == 0) {
            return -1;
        }
        int value = 0;
        int n = i + len;
        for (i = offset; i < n; ++i) {
            char ch = buf.charAt(i);
            int d = JSONNode.digitDecimal(ch);
            if (d < 0) {
                if (ch <= ' ') continue;
                throw new IllegalArgumentException("mismatch array index: \"" + buf.substring(offset, offset + len) + "\"");
            }
            value = value * 10 + d;
        }
        return value;
    }

    abstract JSONNode parseFieldNode(String var1, boolean var2);

    abstract JSONNode parseElementNodeAt(int var1);

    final void addElementNode(JSONNode value) {
        if (this.elementValues == null) {
            this.elementValues = new JSONNode[8];
        } else if (this.elementSize == this.elementValues.length) {
            JSONNode[] tmp = this.elementValues;
            this.elementValues = new JSONNode[this.elementSize << 1];
            System.arraycopy(tmp, 0, this.elementValues, 0, tmp.length);
        }
        value.path = Integer.valueOf(this.elementSize);
        this.elementValues[this.elementSize++] = value;
    }

    abstract JSONNode parseValueNode(int var1, char var2) throws Exception;

    public final JSONNode getElementAt(int index) {
        if (this.elementSize > index || this.completed) {
            return this.elementValues[index];
        }
        if (this.isArray) {
            return this.parseElementNodeAt(index);
        }
        throw new UnsupportedOperationException("element at " + index);
    }

    public final int getElementCount() {
        if (this.isArray) {
            if (this.completed) {
                return this.elementSize;
            }
            this.parseElementNodeAt(-1);
            return this.elementSize;
        }
        return -1;
    }

    public final JSONNode parent() {
        return this.parent;
    }

    public final <E> E getPathValue(String path, Class<E> clazz) {
        JSONNode jsonNode = this.get(path);
        if (jsonNode == null) {
            return null;
        }
        return jsonNode.getValue(clazz);
    }

    public final <E> E getChildValue(String name, Class<E> eClass) {
        JSONNode jsonNode = this.getPathNode(name);
        if (jsonNode == null) {
            return null;
        }
        if (jsonNode.isArray) {
            if (eClass == String.class) {
                return (E)jsonNode.source();
            }
            throw new UnsupportedOperationException("not matched " + eClass);
        }
        return jsonNode.getValue(eClass);
    }

    public abstract String getText();

    public final String getStringValue() {
        return this.getValue(String.class);
    }

    public final Serializable getValue() {
        if (this.leafValue != null) {
            return this.leafValue;
        }
        return (Serializable)this.getValue(null);
    }

    abstract byte[] hexString2Bytes();

    public final <E> E getValue(Class<E> eClass) {
        if (this.leaf) {
            if (eClass != null && eClass.isInstance(this.leafValue)) {
                return (E)this.leafValue;
            }
            if (this.type == 6) {
                return null;
            }
            if (eClass == null) {
                return (E)this.source();
            }
            if (eClass == String.class) {
                return (E)this.getText();
            }
            if (eClass == char[].class) {
                return (E)this.getText().toCharArray();
            }
            if (eClass == byte[].class) {
                String text = this.getText();
                if (this.parseContext.byteArrayFromHexString) {
                    return (E)this.hexString2Bytes();
                }
                return (E)Base64Utils.decode(text);
            }
            if (Enum.class.isAssignableFrom(eClass)) {
                if (this.type == 3) {
                    Class<E> enumCls = eClass;
                    return Enum.valueOf(enumCls, this.getText());
                }
                throw new JSONException("source [" + this.source() + "] cannot convert to Enum '" + eClass + "");
            }
            E result = ObjectUtils.toType(this.source(), eClass);
            if (result != null) {
                return result;
            }
            try {
                JSONTypeDeserializer typeDeserializer = JSONTypeDeserializer.getTypeDeserializer(eClass);
                if (typeDeserializer != null) {
                    return (E)typeDeserializer.valueOf(this.leafValue != null ? String.valueOf(this.leafValue) : this.source(), eClass);
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            return null;
        }
        if (this.isArray) {
            if (eClass == String.class) {
                return (E)this.getText();
            }
            if (eClass.isArray()) {
                return this.toArray(eClass);
            }
            throw new UnsupportedOperationException("please use toCollection method instead !");
        }
        if (eClass != null && (eClass.isEnum() || eClass.isPrimitive() || eClass.isArray())) {
            String msg = "source '" + this.source() + "' not supported to type " + eClass;
            throw new UnsupportedOperationException(msg);
        }
        return this.toBean(eClass);
    }

    public final <E> Map<?, E> toMap(Class<? extends Map> eClass, Class<E> valueCls) {
        return this.toBean(eClass, valueCls);
    }

    public final <E> E toBean(Class<E> eClass) {
        return this.toBean(eClass, null);
    }

    final <E> E toBean(Class<E> eClass, Class actualCls) {
        boolean isMapInstance;
        Object instance;
        if (eClass == String.class) {
            return (E)this.source();
        }
        if (this.leaf) {
            throw new UnsupportedOperationException("node is a leaf value, please call method getValue instead !");
        }
        ClassStructureWrapper structureWrapper = null;
        if (eClass == null || eClass == Map.class || eClass == LinkedHashMap.class) {
            instance = new LinkedHashMap();
            isMapInstance = true;
        } else {
            structureWrapper = ClassStructureWrapper.get(eClass);
            isMapInstance = structureWrapper.isAssignableFromMap();
            try {
                instance = !isMapInstance ? structureWrapper.newInstance() : eClass.newInstance();
            }
            catch (Throwable throwable) {
                throw new JSONException("create instance error.", throwable);
            }
        }
        if (!this.completed) {
            this.parseFullNode();
        }
        for (Map.Entry<Serializable, JSONNode> entry : this.fieldValues.entrySet()) {
            Object value;
            Serializable key = entry.getKey();
            JSONNode childNode = entry.getValue();
            if (isMapInstance) {
                Map map = (Map)instance;
                Object value2 = childNode.isArray ? childNode.toCollection(ArrayList.class, Object.class) : childNode.getValue(actualCls);
                map.put(key, value2);
                continue;
            }
            String fieldName = key.toString();
            SetterInfo setterInfo = structureWrapper.getSetterInfo(fieldName);
            if (setterInfo == null) continue;
            Class<?> parameterType = setterInfo.getParameterType();
            GenericParameterizedType parameterizedType = setterInfo.getGenericParameterizedType();
            if (childNode.isArray) {
                Class<Object> entityClass = parameterizedType.getValueType() == null ? Object.class : parameterizedType.getValueType().getActualType();
                value = childNode.toCollection(parameterizedType.getActualType(), entityClass);
            } else {
                value = childNode.getValue(parameterType);
            }
            JSON_SECURE_TRUSTED_ACCESS.set(setterInfo, instance, value);
        }
        return (E)instance;
    }

    public final <E> List<E> toList(Class<E> entityClass) {
        return (List)this.toCollection(ArrayList.class, entityClass);
    }

    public final <E> E toArray(Class<E> arrayClass) {
        if (!arrayClass.isArray()) {
            throw new JSONException(arrayClass + " is not an array class");
        }
        return (E)this.toCollection(arrayClass, arrayClass.getComponentType());
    }

    public final Object toCollection(Class<?> collectionCls, Class<?> entityClass) {
        collectionCls.getClass();
        if (!this.completed) {
            this.parseFullNode();
        }
        Collection collection = null;
        boolean isArrayCls = collectionCls.isArray();
        boolean primitive = entityClass.isPrimitive();
        Object arrayObj = null;
        if (isArrayCls) {
            arrayObj = Array.newInstance(entityClass, this.elementSize);
        } else {
            collection = JSONNode.createCollectionInstance(collectionCls, this.elementSize);
        }
        for (int i = 0; i < this.elementSize; ++i) {
            JSONNode node = this.elementValues[i];
            Object result = node.isArray ? (entityClass.isArray() ? node.toCollection(entityClass, entityClass.getComponentType()) : node.toCollection(ArrayList.class, Object.class)) : node.getValue(entityClass);
            if (isArrayCls) {
                if (primitive) {
                    Array.set(arrayObj, i, result);
                    continue;
                }
                ((Object[])arrayObj)[i] = result;
                continue;
            }
            collection.add(result);
        }
        return isArrayCls ? arrayObj : collection;
    }

    final void parseFullNode() {
        if (this.isArray) {
            this.parseElementNodeAt(-1);
        } else {
            if (this.fieldValues == null) {
                this.fieldValues = new LinkedHashMap<Serializable, JSONNode>(16);
            }
            this.parseFieldNode(null, false);
        }
    }

    public abstract String source();

    public final boolean isArray() {
        return this.isArray;
    }

    public final boolean isLeaf() {
        return this.leaf;
    }

    public final int getType() {
        return this.type;
    }

    @Override
    public final int compareTo(JSONNode o) {
        Serializable value = this.leafValue;
        Serializable o1 = o.leafValue;
        if (value instanceof Number && o1 instanceof Number) {
            Double v1 = ((Number)value).doubleValue();
            Double v2 = ((Number)o1).doubleValue();
            return v1.compareTo(v2);
        }
        if (value instanceof String && o1 instanceof String) {
            return ((String)((Object)value)).compareTo((String)((Object)o1));
        }
        if (value instanceof Comparable && o1 instanceof Comparable) {
            if (value.getClass() == o1.getClass()) {
                return ((Comparable)((Object)value)).compareTo(o1);
            }
            String v1 = value.toString();
            String v2 = o1.toString();
            return v1.compareTo(v2);
        }
        return 0;
    }

    private void writeTo(StringBuilder stringBuilder) {
        if (!this.changed) {
            this.writeSourceTo(stringBuilder);
            return;
        }
        switch (this.type) {
            case 1: {
                stringBuilder.append('{');
                int len = this.fieldValues.size();
                int i = 0;
                for (Map.Entry<Serializable, JSONNode> entry : this.fieldValues.entrySet()) {
                    String key = entry.getKey().toString();
                    JSONNode value = entry.getValue();
                    stringBuilder.append('\"').append(key).append("\":");
                    value.writeTo(stringBuilder);
                    if (i++ >= len - 1) continue;
                    stringBuilder.append(',');
                }
                stringBuilder.append('}');
                break;
            }
            case 2: {
                stringBuilder.append('[');
                for (int j = 0; j < this.elementSize; ++j) {
                    JSONNode value = this.elementValues[j];
                    value.writeTo(stringBuilder);
                    if (j >= this.elementSize - 1) continue;
                    stringBuilder.append(',');
                }
                stringBuilder.append(']');
                break;
            }
            case 3: {
                stringBuilder.append('\"');
                JSONNode.writeStringTo((String)((Object)this.leafValue), stringBuilder);
                stringBuilder.append('\"');
                break;
            }
            default: {
                stringBuilder.append(this.leafValue);
            }
        }
    }

    abstract void writeSourceTo(StringBuilder var1);

    private static void writeStringTo(String leafValue, StringBuilder content) {
        int len = leafValue.length();
        int beginIndex = 0;
        for (int i = 0; i < len; ++i) {
            String escapeStr;
            char ch = leafValue.charAt(i);
            if (ch > '\"' && ch != '\\' || (escapeStr = ESCAPE_VALUES[ch]) == null) continue;
            int length = i - beginIndex;
            if (length > 0) {
                content.append(leafValue, beginIndex, i);
            }
            content.append(escapeStr);
            beginIndex = i + 1;
        }
        content.append(leafValue, beginIndex, len);
    }

    public final void setPathValue(String path, Serializable value) {
        JSONNode node = this.get(path);
        if (node != null && node.leaf) {
            node.setLeafValue(value);
        }
    }

    public final void removeElementAt(int index) {
        if (!this.isArray) {
            throw new UnsupportedOperationException();
        }
        if (index >= this.elementSize || index < 0) {
            throw new IndexOutOfBoundsException(" length: " + this.elementSize + ", to remove index at " + index);
        }
        if (!this.completed) {
            this.parseFullNode();
        }
        int newLen = this.elementSize - 1;
        JSONNode[] newElementNodes = new JSONNode[newLen];
        System.arraycopy(this.elementValues, 0, newElementNodes, 0, index);
        System.arraycopy(this.elementValues, index + 1, newElementNodes, index, newLen - index);
        this.elementSize = newLen;
        this.handleChange();
    }

    public final JSONNode removeField(String field) {
        JSONNode removeNode;
        if (this.type != 1) {
            throw new UnsupportedOperationException();
        }
        if (!this.completed) {
            this.parseFullNode();
        }
        if ((removeNode = this.fieldValues.remove(field)) != null) {
            this.handleChange();
        }
        return removeNode;
    }

    public final List collect(String childPath) {
        return this.collect(childPath, String.class);
    }

    public final List collect(String childPath, Class typeClass) {
        if (!this.isArray) {
            throw new UnsupportedOperationException();
        }
        if (!this.completed) {
            this.parseFullNode();
        }
        ArrayList result = new ArrayList();
        for (int i = 0; i < this.elementSize; ++i) {
            JSONNode jsonNode = this.elementValues[i];
            result.add(jsonNode.getPathValue(childPath, typeClass));
        }
        return result;
    }

    public final void setLeafValue(Serializable value) {
        if (value == this.leafValue) {
            return;
        }
        this.leafValue = value;
        this.updateType();
        this.handleChange();
    }

    final void updateType() {
        if (this.leafValue == null) {
            this.type = 6;
        } else if (this.leafValue instanceof Number) {
            this.type = 4;
        } else if (this.leafValue instanceof Boolean) {
            this.type = 5;
        } else if (this.type == 3) {
            this.type = 3;
            this.text = (String)((Object)this.leafValue);
        }
    }

    public final void clear() {
        if (this.isArray) {
            for (JSONNode ele : this.elementValues) {
                if (ele == null) continue;
                ele.clear();
            }
        } else {
            for (JSONNode ele : this.fieldValues.values()) {
                ele.clear();
            }
        }
        this.text = null;
        this.leafValue = null;
        this.elementValues = null;
        this.fieldValues = null;
        this.clearSource();
    }

    protected abstract void clearSource();

    final void handleChange() {
        if (this.parent != null) {
            this.parent.handleChange();
        }
        this.changed = true;
    }

    public final String toJsonString() {
        if (!this.changed) {
            return this.source();
        }
        StringBuilder stringBuilder = new StringBuilder();
        this.writeTo(stringBuilder);
        return stringBuilder.toString();
    }

    static class B
    extends JSONNode {
        CharSource charSource;
        byte[] buf;

        B(CharSource charSource, byte[] buf, int beginIndex, int endIndex, JSONNodeContext parseContext) {
            super(B.buildRootContext(buf, beginIndex, endIndex), parseContext);
            this.charSource = charSource;
            this.buf = buf;
        }

        B(CharSource charSource, List<JSONNode> elementValues, byte[] buf, int beginIndex, int endIndex, JSONNodeContext parseContext) {
            super(elementValues, beginIndex, endIndex, parseContext);
            this.charSource = charSource;
            this.buf = buf;
        }

        B(CharSource charSource, Map<Serializable, JSONNode> fieldValues, byte[] buf, int beginIndex, int endIndex, JSONNodeContext parseContext) {
            super(fieldValues, beginIndex, endIndex, parseContext);
            this.charSource = charSource;
            this.buf = buf;
        }

        B(CharSource charSource, Serializable leafValue, byte[] buf, int beginIndex, int endIndex, int type, JSONNodeContext parseContext, JSONNode rootNode) {
            super(leafValue, beginIndex, endIndex, type, parseContext, rootNode);
            this.charSource = charSource;
            this.buf = buf;
        }

        public B(CharSource charSource, byte[] buf, int beginIndex, int endIndex, int type, JSONNodeContext parseContext, JSONNode rootNode) {
            super(beginIndex, endIndex, type, parseContext, rootNode);
            this.charSource = charSource;
            this.buf = buf;
        }

        @Override
        public String getText() {
            if (this.text == null) {
                if (this.type == 3) {
                    this.text = (String)JSONTypeDeserializer.CHAR_SEQUENCE_STRING.deserializeString(this.charSource, this.buf, this.beginIndex, this.endIndex, 34, GenericParameterizedType.StringType, (JSONParseContext)this.parseContext);
                    this.leafValue = this.text;
                } else {
                    return this.source();
                }
            }
            return this.text;
        }

        @Override
        public String source() {
            if (this.leafValue != null && this.type != 3) {
                return String.valueOf(this.leafValue);
            }
            if (this.type > 3) {
                if (this.text == null) {
                    String source;
                    this.text = source = new String(this.buf, this.beginIndex, this.endIndex - this.beginIndex);
                }
                return this.text;
            }
            return new String(this.buf, this.beginIndex, this.endIndex - this.beginIndex);
        }

        @Override
        void writeSourceTo(StringBuilder stringBuilder) {
            stringBuilder.append(new String(this.buf, this.beginIndex, this.endIndex - this.beginIndex));
        }

        @Override
        byte[] hexString2Bytes() {
            return B.hexString2Bytes(this.buf, this.beginIndex + 1, this.endIndex - this.beginIndex - 2);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        JSONNode parseFieldNode(String fieldName, boolean skipIfUnleaf) {
            if (this.completed) {
                return (JSONNode)this.fieldValues.get(fieldName);
            }
            boolean allowComment = this.parseContext.allowComment;
            boolean empty = true;
            for (int i = this.offset + 1; i < this.endIndex; ++i) {
                boolean isClosingSymbol;
                JSONNode value;
                boolean matchedField;
                String key;
                byte ch;
                while ((ch = this.buf[i]) <= 32) {
                    ++i;
                }
                if (allowComment && ch == 47) {
                    i = B.clearCommentAndWhiteSpaces(this.buf, i + 1, this.endIndex, (JSONParseContext)this.parseContext);
                    ch = this.buf[i];
                }
                int fieldKeyFrom = i;
                if (ch == 34) {
                    key = JSONTypeDeserializer.parseMapKeyByCache(this.buf, i, this.endIndex, '\"', this.parseContext);
                    empty = false;
                    i = this.parseContext.endIndex + 1;
                } else {
                    if (ch == 125) {
                        if (!empty) {
                            throw new JSONException("Syntax error, the closing symbol '}' is not allowed at pos " + i);
                        }
                        this.offset = i;
                        this.completed = true;
                        return null;
                    }
                    if (ch == 39) {
                        if (!this.parseContext.allowSingleQuotes) throw new JSONException("Syntax error, the single quote symbol ' is not allowed at pos " + i);
                        while (i + 1 < this.endIndex && (this.buf[++i] != 39 || this.buf[i - 1] == 92)) {
                        }
                        empty = false;
                        key = (String)((Object)JSONDefaultParser.parseKeyOfMap(this.buf, fieldKeyFrom, ++i, false));
                    } else if (this.parseContext.allowUnquotedFieldNames) {
                        while (i + 1 < this.endIndex && this.buf[++i] != 58) {
                        }
                        empty = false;
                        key = String.valueOf(JSONDefaultParser.parseKeyOfMap(this.buf, fieldKeyFrom, i, true));
                    } else {
                        String errorContextTextAt = B.createErrorContextText(this.buf, i);
                        throw new JSONException("Syntax error, at pos " + i + ", context text by '" + errorContextTextAt + "', unexpected '" + ch + "', expected '\"' or use option ReadOption.AllowUnquotedFieldNames ");
                    }
                }
                while ((ch = this.buf[i]) <= 32) {
                    ++i;
                }
                if (allowComment && ch == 47) {
                    i = B.clearCommentAndWhiteSpaces(this.buf, i + 1, this.endIndex, (JSONParseContext)this.parseContext);
                    ch = this.buf[i];
                }
                if (ch != 58) throw new JSONException("Syntax error, unexpected '" + ch + "', position " + i);
                boolean bl = matchedField = fieldName != null && fieldName.equals(key);
                while ((ch = this.buf[++i]) <= 32) {
                }
                if (allowComment && ch == 47) {
                    i = B.clearCommentAndWhiteSpaces(this.buf, i + 1, this.endIndex, (JSONParseContext)this.parseContext);
                }
                try {
                    value = this.parseValueNode(i, '}');
                }
                catch (Throwable throwable) {
                    if (!(throwable instanceof JSONException)) throw new JSONException(throwable.getMessage(), throwable);
                    throw (JSONException)throwable;
                }
                i = this.parseContext.endIndex;
                while ((ch = this.buf[++i]) <= 32) {
                }
                if (allowComment && ch == 47) {
                    i = B.clearCommentAndWhiteSpaces(this.buf, i + 1, this.endIndex, (JSONParseContext)this.parseContext);
                    ch = this.buf[i];
                }
                this.offset = i;
                boolean bl2 = isClosingSymbol = ch == 125;
                if (ch != 44 && !isClosingSymbol) throw new JSONException("Syntax error, unexpected '" + ch + "', position " + i);
                B.addFieldValue(this.fieldValues, (Serializable)((Object)key), value);
                if (isClosingSymbol) {
                    this.completed = true;
                }
                if (!matchedField) continue;
                return value;
            }
            return null;
        }

        @Override
        JSONNode parseValueNode(int beginIndex, char endChar) throws Exception {
            JSONNode value;
            byte ch = this.buf[beginIndex];
            switch (ch) {
                case 123: {
                    JSONTypeDeserializer.MAP.skip(this.charSource, this.buf, beginIndex, this.endIndex, (JSONParseContext)this.parseContext);
                    value = new B(this.charSource, this.buf, beginIndex, this.parseContext.endIndex + 1, 1, this.parseContext, this.root);
                    break;
                }
                case 91: {
                    JSONTypeDeserializer.COLLECTION.skip(this.charSource, this.buf, beginIndex, this.endIndex, (JSONParseContext)this.parseContext);
                    value = new B(this.charSource, this.buf, beginIndex, this.parseContext.endIndex + 1, 2, this.parseContext, this.root);
                    break;
                }
                case 34: {
                    value = JSONNode.parseStringPathNode(this.charSource, this.buf, beginIndex, this.endIndex, false, this.parseContext, this.root);
                    break;
                }
                case 110: {
                    value = JSONNode.parseNullPathNode(this.charSource, this.buf, beginIndex, this.endIndex, this.parseContext, this.root);
                    break;
                }
                case 116: {
                    value = JSONNode.parseBoolTruePathNode(this.charSource, this.buf, beginIndex, this.endIndex, this.parseContext, this.root);
                    break;
                }
                case 102: {
                    value = JSONNode.parseBoolFalsePathNode(this.charSource, this.buf, beginIndex, this.endIndex, this.parseContext, this.root);
                    break;
                }
                default: {
                    value = JSONNode.parseNumberPathNode(this.charSource, this.buf, beginIndex, this.endIndex, (byte)endChar, this.parseContext, this.root);
                }
            }
            value.parent = this;
            return value;
        }

        @Override
        JSONNode parseElementNodeAt(int index) {
            boolean allowComment = this.parseContext.allowComment;
            for (int i = this.offset + 1; i < this.endIndex; ++i) {
                boolean isEnd;
                JSONNode value;
                byte ch;
                while ((ch = this.buf[i]) <= 32) {
                    ++i;
                }
                if (allowComment && ch == 47) {
                    i = B.clearCommentAndWhiteSpaces(this.buf, i + 1, this.endIndex, (JSONParseContext)this.parseContext);
                    ch = this.buf[i];
                }
                if (ch == 93) {
                    if (this.elementSize > 0) {
                        throw new JSONException("Syntax error, not allowed ',' followed by ']', pos " + i);
                    }
                    this.offset = i;
                    this.completed = true;
                    return null;
                }
                boolean matchedIndex = index > -1 && index == this.elementSize;
                try {
                    value = this.parseValueNode(i, ']');
                }
                catch (Throwable throwable) {
                    if (throwable instanceof JSONException) {
                        throw (JSONException)throwable;
                    }
                    throw new JSONException(throwable.getMessage(), throwable);
                }
                i = this.parseContext.endIndex;
                while ((ch = this.buf[++i]) <= 32) {
                }
                if (allowComment && ch == 47) {
                    i = B.clearCommentAndWhiteSpaces(this.buf, i + 1, this.endIndex, (JSONParseContext)this.parseContext);
                    ch = this.buf[i];
                }
                this.offset = i;
                boolean bl = isEnd = ch == 93;
                if (ch == 44 || isEnd) {
                    this.addElementNode(value);
                    if (isEnd) {
                        this.completed = true;
                    }
                    if (!matchedIndex) continue;
                    return value;
                }
                throw new JSONException("Syntax error, unexpected '" + ch + "', position " + i + ", Missing ',' or '}'");
            }
            return null;
        }

        @Override
        protected void clearSource() {
            this.buf = null;
            this.charSource = null;
        }
    }

    static class C
    extends JSONNode {
        CharSource charSource;
        char[] buf;

        C(CharSource charSource, char[] buf, int beginIndex, int endIndex, JSONNodeContext parseContext) {
            super(C.buildRootContext(buf, beginIndex, endIndex), parseContext);
            this.charSource = charSource;
            this.buf = buf;
        }

        C(CharSource charSource, List<JSONNode> elementValues, char[] buf, int beginIndex, int endIndex, JSONNodeContext parseContext) {
            super(elementValues, beginIndex, endIndex, parseContext);
            this.charSource = charSource;
            this.buf = buf;
        }

        C(CharSource charSource, Map<Serializable, JSONNode> fieldValues, char[] buf, int beginIndex, int endIndex, JSONNodeContext parseContext) {
            super(fieldValues, beginIndex, endIndex, parseContext);
            this.charSource = charSource;
            this.buf = buf;
        }

        C(CharSource charSource, Serializable leafValue, char[] buf, int beginIndex, int endIndex, int type, JSONNodeContext parseContext, JSONNode rootNode) {
            super(leafValue, beginIndex, endIndex, type, parseContext, rootNode);
            this.charSource = charSource;
            this.buf = buf;
        }

        public C(CharSource charSource, char[] buf, int beginIndex, int endIndex, int type, JSONNodeContext parseContext, JSONNode rootNode) {
            super(beginIndex, endIndex, type, parseContext, rootNode);
            this.charSource = charSource;
            this.buf = buf;
        }

        @Override
        public String getText() {
            if (this.text == null) {
                if (this.type == 3) {
                    this.text = (String)JSONTypeDeserializer.CHAR_SEQUENCE_STRING.deserializeString(this.charSource, this.buf, this.beginIndex, this.endIndex, '\"', GenericParameterizedType.StringType, (JSONParseContext)this.parseContext);
                    this.leafValue = this.text;
                } else {
                    return this.source();
                }
            }
            return this.text;
        }

        @Override
        public String source() {
            if (this.leafValue != null && this.type != 3) {
                return String.valueOf(this.leafValue);
            }
            if (this.type > 3) {
                if (this.text == null) {
                    String source;
                    this.text = source = new String(this.buf, this.beginIndex, this.endIndex - this.beginIndex);
                }
                return this.text;
            }
            return new String(this.buf, this.beginIndex, this.endIndex - this.beginIndex);
        }

        @Override
        void writeSourceTo(StringBuilder stringBuilder) {
            stringBuilder.append(this.buf, this.beginIndex, this.endIndex - this.beginIndex);
        }

        @Override
        byte[] hexString2Bytes() {
            return C.hexString2Bytes(this.buf, this.beginIndex + 1, this.endIndex - this.beginIndex - 2);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        JSONNode parseFieldNode(String fieldName, boolean skipIfUnleaf) {
            if (this.completed) {
                return (JSONNode)this.fieldValues.get(fieldName);
            }
            boolean allowComment = this.parseContext.allowComment;
            boolean empty = true;
            for (int i = this.offset + 1; i < this.endIndex; ++i) {
                boolean isClosingSymbol;
                JSONNode value;
                boolean matchedField;
                String key;
                char ch;
                while ((ch = this.buf[i]) <= ' ') {
                    ++i;
                }
                if (allowComment && ch == '/') {
                    i = C.clearCommentAndWhiteSpaces(this.buf, i + 1, this.endIndex, (JSONParseContext)this.parseContext);
                    ch = this.buf[i];
                }
                int fieldKeyFrom = i;
                if (ch == '\"') {
                    key = JSONDefaultParser.parseMapKeyByCache(this.buf, i, this.endIndex, '\"', this.parseContext);
                    empty = false;
                    i = this.parseContext.endIndex + 1;
                } else {
                    if (ch == '}') {
                        if (!empty) {
                            throw new JSONException("Syntax error, the closing symbol '}' is not allowed at pos " + i);
                        }
                        this.offset = i;
                        this.completed = true;
                        return null;
                    }
                    if (ch == '\'') {
                        if (!this.parseContext.allowSingleQuotes) throw new JSONException("Syntax error, the single quote symbol ' is not allowed at pos " + i);
                        while (i + 1 < this.endIndex && (this.buf[++i] != '\'' || this.buf[i - 1] == '\\')) {
                        }
                        empty = false;
                        key = (String)((Object)JSONDefaultParser.parseKeyOfMap(this.buf, fieldKeyFrom, ++i, false));
                    } else if (this.parseContext.allowUnquotedFieldNames) {
                        while (i + 1 < this.endIndex && this.buf[++i] != ':') {
                        }
                        empty = false;
                        key = String.valueOf(JSONDefaultParser.parseKeyOfMap(this.buf, fieldKeyFrom, i, true));
                    } else {
                        String errorContextTextAt = C.createErrorContextText(this.buf, i);
                        throw new JSONException("Syntax error, at pos " + i + ", context text by '" + errorContextTextAt + "', unexpected '" + ch + "', expected '\"' or use option ReadOption.AllowUnquotedFieldNames ");
                    }
                }
                while ((ch = this.buf[i]) <= ' ') {
                    ++i;
                }
                if (allowComment && ch == '/') {
                    i = C.clearCommentAndWhiteSpaces(this.buf, i + 1, this.endIndex, (JSONParseContext)this.parseContext);
                    ch = this.buf[i];
                }
                if (ch != ':') throw new JSONException("Syntax error, unexpected '" + ch + "', position " + i);
                boolean bl = matchedField = fieldName != null && fieldName.equals(key);
                while ((ch = this.buf[++i]) <= ' ') {
                }
                if (allowComment && ch == '/') {
                    i = C.clearCommentAndWhiteSpaces(this.buf, i + 1, this.endIndex, (JSONParseContext)this.parseContext);
                    ch = this.buf[i];
                }
                try {
                    value = this.parseValueNode(i, '}');
                }
                catch (Throwable throwable) {
                    if (!(throwable instanceof JSONException)) throw new JSONException(throwable.getMessage(), throwable);
                    throw (JSONException)throwable;
                }
                i = this.parseContext.endIndex;
                while ((ch = this.buf[++i]) <= ' ') {
                }
                if (allowComment && ch == '/') {
                    i = C.clearCommentAndWhiteSpaces(this.buf, i + 1, this.endIndex, (JSONParseContext)this.parseContext);
                    ch = this.buf[i];
                }
                this.offset = i;
                boolean bl2 = isClosingSymbol = ch == '}';
                if (ch != ',' && !isClosingSymbol) throw new JSONException("Syntax error, unexpected '" + ch + "', position " + i);
                C.addFieldValue(this.fieldValues, (Serializable)((Object)key), value);
                if (isClosingSymbol) {
                    this.completed = true;
                }
                if (!matchedField) continue;
                return value;
            }
            return null;
        }

        @Override
        JSONNode parseValueNode(int beginIndex, char endChar) throws Exception {
            JSONNode value;
            char ch = this.buf[beginIndex];
            switch (ch) {
                case '{': {
                    JSONTypeDeserializer.MAP.skip(this.charSource, this.buf, beginIndex, this.endIndex, (JSONParseContext)this.parseContext);
                    value = new C(this.charSource, this.buf, beginIndex, this.parseContext.endIndex + 1, 1, this.parseContext, this.root);
                    break;
                }
                case '[': {
                    JSONTypeDeserializer.COLLECTION.skip(this.charSource, this.buf, beginIndex, this.endIndex, (JSONParseContext)this.parseContext);
                    value = new C(this.charSource, this.buf, beginIndex, this.parseContext.endIndex + 1, 2, this.parseContext, this.root);
                    break;
                }
                case '\"': {
                    value = JSONNode.parseStringPathNode(this.charSource, this.buf, beginIndex, this.endIndex, false, this.parseContext, this.root);
                    break;
                }
                case 'n': {
                    value = JSONNode.parseNullPathNode(this.charSource, this.buf, beginIndex, this.endIndex, this.parseContext, this.root);
                    break;
                }
                case 't': {
                    value = JSONNode.parseBoolTruePathNode(this.charSource, this.buf, beginIndex, this.endIndex, this.parseContext, this.root);
                    break;
                }
                case 'f': {
                    value = JSONNode.parseBoolFalsePathNode(this.charSource, this.buf, beginIndex, this.endIndex, this.parseContext, this.root);
                    break;
                }
                default: {
                    value = JSONNode.parseNumberPathNode(this.charSource, this.buf, beginIndex, this.endIndex, endChar, this.parseContext, this.root);
                }
            }
            value.parent = this;
            return value;
        }

        @Override
        JSONNode parseElementNodeAt(int index) {
            boolean allowComment = this.parseContext.allowComment;
            for (int i = this.offset + 1; i < this.endIndex; ++i) {
                boolean isEnd;
                JSONNode value;
                char ch;
                while ((ch = this.buf[i]) <= ' ') {
                    ++i;
                }
                if (allowComment && ch == '/') {
                    i = C.clearCommentAndWhiteSpaces(this.buf, i + 1, this.endIndex, (JSONParseContext)this.parseContext);
                    ch = this.buf[i];
                }
                if (ch == ']') {
                    if (this.elementSize > 0) {
                        throw new JSONException("Syntax error, not allowed ',' followed by ']', pos " + i);
                    }
                    this.offset = i;
                    this.completed = true;
                    return null;
                }
                boolean matchedIndex = index > -1 && index == this.elementSize;
                try {
                    value = this.parseValueNode(i, ']');
                }
                catch (Throwable throwable) {
                    if (throwable instanceof JSONException) {
                        throw (JSONException)throwable;
                    }
                    throw new JSONException(throwable.getMessage(), throwable);
                }
                i = this.parseContext.endIndex;
                while ((ch = this.buf[++i]) <= ' ') {
                }
                if (allowComment && ch == '/') {
                    i = C.clearCommentAndWhiteSpaces(this.buf, i + 1, this.endIndex, (JSONParseContext)this.parseContext);
                    ch = this.buf[i];
                }
                this.offset = i;
                boolean bl = isEnd = ch == ']';
                if (ch == ',' || isEnd) {
                    this.addElementNode(value);
                    if (isEnd) {
                        this.completed = true;
                    }
                    if (!matchedIndex) continue;
                    return value;
                }
                throw new JSONException("Syntax error, unexpected '" + ch + "', position " + i + ", Missing ',' or '}'");
            }
            return null;
        }

        @Override
        protected void clearSource() {
            this.buf = null;
            this.charSource = null;
        }
    }

    static class RootContext {
        final int beginIndex;
        final int endIndex;
        final int type;
        Serializable leafValue;

        public RootContext(int beginIndex, int endIndex, int type, Serializable leafValue) {
            this.beginIndex = beginIndex;
            this.endIndex = endIndex;
            this.type = type;
            this.leafValue = leafValue;
        }
    }
}

