/*
 * Decompiled with CFR 0.152.
 */
package io.github.wycst.wast.json;

import io.github.wycst.wast.common.compiler.JavaSourceObject;
import io.github.wycst.wast.common.reflect.GetterInfo;
import io.github.wycst.wast.common.reflect.ReflectConsts;
import io.github.wycst.wast.json.JSONConfig;
import io.github.wycst.wast.json.JSONPojoFieldSerializer;
import io.github.wycst.wast.json.JSONPojoSerializerCodeGen;
import io.github.wycst.wast.json.JSONPojoStructure;
import io.github.wycst.wast.json.JSONTypeSerializer;
import io.github.wycst.wast.json.JSONWriter;
import java.io.IOException;
import java.util.Collection;

public class JSONPojoSerializer<T>
extends JSONTypeSerializer {
    protected final JSONPojoStructure pojoStructure;
    protected final Class<?> pojoClass;

    protected JSONPojoSerializer(Class<T> pojoClass) {
        this.pojoClass = pojoClass;
        this.pojoStructure = JSONPojoStructure.get(pojoClass);
    }

    protected JSONPojoSerializer(JSONPojoStructure pojoStructure) {
        this.pojoStructure = pojoStructure;
        this.pojoClass = pojoStructure.getSourceClass();
    }

    @Override
    final void initialize() {
        this.pojoStructure.ensureInitializedFieldSerializers();
    }

    public void serializePojoCompact(T entity, JSONWriter writer, JSONConfig jsonConfig, int indentLevel) throws Exception {
        boolean writeFullProperty = jsonConfig.isFullProperty();
        boolean writeClassName = jsonConfig.isWriteClassName();
        boolean isEmptyFlag = !this.checkWriteClassName(writeClassName, writer, this.pojoClass, false, indentLevel, jsonConfig);
        JSONPojoFieldSerializer[] fieldSerializers = this.pojoStructure.getFieldSerializers(jsonConfig.isUseFields());
        boolean skipGetterOfNoExistField = jsonConfig.isSkipGetterOfNoneField();
        boolean unCamelCaseToUnderline = !jsonConfig.isCamelCaseToUnderline();
        for (JSONPojoFieldSerializer fieldSerializer : fieldSerializers) {
            Object value;
            GetterInfo getterInfo = fieldSerializer.getterInfo;
            if (!getterInfo.existField() && skipGetterOfNoExistField || (value = JSON_SECURE_TRUSTED_ACCESS.get(getterInfo, entity)) == null && !writeFullProperty) continue;
            if (isEmptyFlag) {
                isEmptyFlag = false;
            } else {
                writer.writeJSONToken(',');
            }
            if (value != null) {
                if (unCamelCaseToUnderline) {
                    fieldSerializer.writeFieldNameAndColonTo(writer);
                } else {
                    writer.append('\"').append(getterInfo.getUnderlineName()).append("\":");
                }
                fieldSerializer.serializer.serialize(value, writer, jsonConfig, -1);
                continue;
            }
            if (unCamelCaseToUnderline) {
                fieldSerializer.writeJSONFieldNameWithNull(writer);
                continue;
            }
            writer.append('\"').append(getterInfo.getUnderlineName()).append("\":null");
        }
    }

    public void serializePojoFormatOut(T entity, JSONWriter writer, JSONConfig jsonConfig, int indentLevel) throws Exception {
        boolean writeFullProperty = jsonConfig.isFullProperty();
        boolean writeClassName = jsonConfig.isWriteClassName();
        boolean formatOutColonSpace = jsonConfig.isFormatOutColonSpace();
        boolean isEmptyFlag = !this.checkWriteClassName(writeClassName, writer, this.pojoClass, true, indentLevel, jsonConfig);
        JSONPojoFieldSerializer[] fieldSerializers = this.pojoStructure.getFieldSerializers(jsonConfig.isUseFields());
        boolean skipGetterOfNoExistField = jsonConfig.isSkipGetterOfNoneField();
        boolean unCamelCaseToUnderline = !jsonConfig.isCamelCaseToUnderline();
        int indentPlus = indentLevel + 1;
        for (JSONPojoFieldSerializer fieldSerializer : fieldSerializers) {
            Object value;
            GetterInfo getterInfo = fieldSerializer.getterInfo;
            if (!getterInfo.existField() && skipGetterOfNoExistField || (value = JSON_SECURE_TRUSTED_ACCESS.get(getterInfo, entity)) == null && !writeFullProperty) continue;
            if (isEmptyFlag) {
                isEmptyFlag = false;
            } else {
                writer.writeJSONToken(',');
            }
            JSONPojoSerializer.writeFormatOutSymbols(writer, indentPlus, true, jsonConfig);
            if (value != null) {
                if (unCamelCaseToUnderline) {
                    fieldSerializer.writeFieldNameAndColonTo(writer);
                } else {
                    writer.append('\"').append(getterInfo.getUnderlineName()).append("\":");
                }
                if (formatOutColonSpace) {
                    writer.writeJSONToken(' ');
                }
                fieldSerializer.serializer.serialize(value, writer, jsonConfig, indentPlus);
                continue;
            }
            if (unCamelCaseToUnderline) {
                if (formatOutColonSpace) {
                    fieldSerializer.writeFieldNameAndColonTo(writer);
                    writer.write(" null");
                    continue;
                }
                fieldSerializer.writeJSONFieldNameWithNull(writer);
                continue;
            }
            writer.writeJSONToken('\"');
            writer.write(getterInfo.getUnderlineName());
            writer.writeJSONToken('\"');
            if (formatOutColonSpace) {
                writer.write(": null");
                continue;
            }
            writer.write(":null");
        }
        if (!isEmptyFlag) {
            JSONPojoSerializer.writeFormatOutSymbols(writer, indentLevel, true, jsonConfig);
        }
    }

    @Override
    protected final void serialize(Object obj, JSONWriter writer, JSONConfig jsonConfig, int indentLevel) throws Exception {
        Class<?> entityClass = obj.getClass();
        if (entityClass == this.pojoClass) {
            int hashcode = -1;
            if (jsonConfig.skipCircularReference) {
                hashcode = System.identityHashCode(obj);
                if (jsonConfig.getStatus(hashcode) == 0) {
                    writer.writeNull();
                    return;
                }
                jsonConfig.setStatus(hashcode, 0);
            }
            writer.writeJSONToken('{');
            boolean formatOut = jsonConfig.formatOut;
            Object entity = obj;
            if (formatOut) {
                this.serializePojoFormatOut(entity, writer, jsonConfig, indentLevel);
            } else {
                this.serializePojoCompact(entity, writer, jsonConfig, indentLevel);
            }
            writer.write(125);
            if (jsonConfig.skipCircularReference) {
                jsonConfig.setStatus(hashcode, -1);
            }
        } else {
            JSONTypeSerializer serializer = JSONPojoSerializer.getTypeSerializer(entityClass);
            serializer.serialize(obj, writer, jsonConfig, indentLevel);
        }
    }

    protected static final void doSerialize(JSONTypeSerializer serializer, Object fieldValue, JSONWriter writer, JSONConfig jsonConfig, int indentLevel) throws Exception {
        serializer.serialize(fieldValue, writer, jsonConfig, indentLevel);
    }

    protected static final Object invokeValue(JSONPojoFieldSerializer fieldSerializer, Object pojo) throws Exception {
        return JSON_SECURE_TRUSTED_ACCESS.get(fieldSerializer.getterInfo, pojo);
    }

    protected static final <T> T invokeValue(JSONPojoFieldSerializer fieldSerializer, Object pojo, Class<T> tClass) throws Exception {
        return (T)JSON_SECURE_TRUSTED_ACCESS.get(fieldSerializer.getterInfo, pojo);
    }

    protected static final void writeMemory(JSONWriter jsonWriter, long fourChars1, long fourChars2, long fourBytes, int len) throws IOException {
        jsonWriter.writeMemory(fourChars1, fourChars2, fourBytes, len);
    }

    protected static final void writeMemory(JSONWriter jsonWriter, long fourChars, int fourBytes, int len) throws IOException {
        jsonWriter.writeMemory(fourChars, fourBytes, len);
    }

    protected static final void writeStringArrayFormatOut(JSONWriter jsonWriter, String[] values, JSONConfig jsonConfig, int level) throws IOException {
        int levelPlus = level + 1;
        int len = values.length;
        if (len > 0) {
            jsonWriter.writeJSONToken('[');
            JSONPojoSerializer.writeFormatOutSymbols(jsonWriter, levelPlus, jsonConfig);
            int i = 1;
            jsonWriter.writeStringCompatibleNull(values[0]);
            if ((len & 1) == 0) {
                jsonWriter.writeJSONToken(',');
                JSONPojoSerializer.writeFormatOutSymbols(jsonWriter, levelPlus, jsonConfig);
                jsonWriter.writeStringCompatibleNull(values[1]);
                ++i;
            }
            while (i < len) {
                jsonWriter.writeJSONToken(',');
                JSONPojoSerializer.writeFormatOutSymbols(jsonWriter, levelPlus, jsonConfig);
                jsonWriter.writeStringCompatibleNull(values[i]);
                jsonWriter.writeJSONToken(',');
                JSONPojoSerializer.writeFormatOutSymbols(jsonWriter, levelPlus, jsonConfig);
                jsonWriter.writeStringCompatibleNull(values[i + 1]);
                i += 2;
            }
            JSONPojoSerializer.writeFormatOutSymbols(jsonWriter, level, true, jsonConfig);
            jsonWriter.writeJSONToken(']');
        } else {
            jsonWriter.writeEmptyArray();
        }
    }

    protected static final void writeStringCollectionFormatOut(JSONWriter jsonWriter, Collection values, JSONConfig jsonConfig, int level) throws IOException {
        int size = values.size();
        int levelPlus = level + 1;
        if (size > 0) {
            jsonWriter.writeJSONToken('[');
            boolean hasAddFlag = false;
            for (Object value : values) {
                if (hasAddFlag) {
                    jsonWriter.writeJSONToken(',');
                } else {
                    hasAddFlag = true;
                }
                JSONPojoSerializer.writeFormatOutSymbols(jsonWriter, levelPlus, jsonConfig);
                jsonWriter.writeStringCompatibleNull((String)value);
            }
            JSONPojoSerializer.writeFormatOutSymbols(jsonWriter, level, true, jsonConfig);
            jsonWriter.writeJSONToken(']');
        } else {
            jsonWriter.writeEmptyArray();
        }
    }

    protected static final void writeLongArrayFormatOut(JSONWriter jsonWriter, long[] values, JSONConfig jsonConfig, int level) throws IOException {
        int levelPlus = level + 1;
        int len = values.length;
        if (len > 0) {
            jsonWriter.writeJSONToken('[');
            int i = 1;
            JSONPojoSerializer.writeFormatOutSymbols(jsonWriter, levelPlus, jsonConfig);
            jsonWriter.writeLong(values[0]);
            if ((len & 1) == 0) {
                jsonWriter.writeJSONToken(',');
                JSONPojoSerializer.writeFormatOutSymbols(jsonWriter, levelPlus, jsonConfig);
                jsonWriter.writeLong(values[1]);
                ++i;
            }
            while (i < len) {
                jsonWriter.writeJSONToken(',');
                JSONPojoSerializer.writeFormatOutSymbols(jsonWriter, levelPlus, jsonConfig);
                jsonWriter.writeLong(values[i]);
                jsonWriter.writeJSONToken(',');
                JSONPojoSerializer.writeFormatOutSymbols(jsonWriter, levelPlus, jsonConfig);
                jsonWriter.writeLong(values[i + 1]);
                i += 2;
            }
            JSONPojoSerializer.writeFormatOutSymbols(jsonWriter, level, jsonConfig);
            jsonWriter.writeJSONToken(']');
        } else {
            jsonWriter.writeEmptyArray();
        }
    }

    protected static final void writeDoubleArrayFormatOut(JSONWriter jsonWriter, double[] values, JSONConfig jsonConfig, int level) throws IOException {
        int levelPlus = level + 1;
        int len = values.length;
        if (len > 0) {
            jsonWriter.writeJSONToken('[');
            int i = 1;
            JSONPojoSerializer.writeFormatOutSymbols(jsonWriter, levelPlus, jsonConfig);
            jsonWriter.writeDouble(values[0]);
            if ((len & 1) == 0) {
                jsonWriter.writeJSONToken(',');
                JSONPojoSerializer.writeFormatOutSymbols(jsonWriter, levelPlus, jsonConfig);
                jsonWriter.writeDouble(values[1]);
                ++i;
            }
            while (i < len) {
                jsonWriter.writeJSONToken(',');
                JSONPojoSerializer.writeFormatOutSymbols(jsonWriter, levelPlus, jsonConfig);
                jsonWriter.writeDouble(values[i]);
                jsonWriter.writeJSONToken(',');
                JSONPojoSerializer.writeFormatOutSymbols(jsonWriter, levelPlus, jsonConfig);
                jsonWriter.writeDouble(values[i + 1]);
                i += 2;
            }
            JSONPojoSerializer.writeFormatOutSymbols(jsonWriter, level, jsonConfig);
            jsonWriter.writeJSONToken(']');
        } else {
            jsonWriter.writeEmptyArray();
        }
    }

    static JavaSourceObject generateRuntimeJavaCodeSource(JSONPojoStructure jsonPojoStructure) {
        return JSONPojoSerializerCodeGen.generateJavaCodeSource(jsonPojoStructure, false, true);
    }

    static JavaSourceObject generateJavaCodeSource(JSONPojoStructure jsonPojoStructure, boolean printJavaSource) {
        return JSONPojoSerializerCodeGen.generateJavaCodeSource(jsonPojoStructure, printJavaSource, false);
    }

    public static JavaSourceObject generateJavaCodeSource(Class<?> pojoClass, boolean printJavaSource) {
        return JSONPojoSerializer.generateJavaCodeSource(pojoClass, printJavaSource, false);
    }

    public static JavaSourceObject generateJavaCodeSource(Class<?> pojoClass, boolean printJavaSource, boolean runtime) {
        ReflectConsts.ClassCategory classCategory = ReflectConsts.getClassCategory(pojoClass);
        if (classCategory != ReflectConsts.ClassCategory.ObjectCategory) {
            throw new UnsupportedOperationException(pojoClass + " is not a pojo class");
        }
        JSONPojoStructure jsonPojoStructure = JSONPojoStructure.get(pojoClass);
        if (!jsonPojoStructure.isSupportedJavaBeanConvention()) {
            throw new UnsupportedOperationException(pojoClass + " is not supported for code generator");
        }
        return JSONPojoSerializerCodeGen.generateJavaCodeSource(jsonPojoStructure, printJavaSource, runtime);
    }

    public static JavaSourceObject generateJavaCodeSource(Class<?> pojoClass) {
        return JSONPojoSerializer.generateJavaCodeSource(pojoClass, false);
    }
}

