/*
 * Decompiled with CFR 0.152.
 */
package io.github.wycst.wast.json.temporal;

import io.github.wycst.wast.common.beans.GeneralDate;
import io.github.wycst.wast.common.reflect.GenericParameterizedType;
import io.github.wycst.wast.json.JSONParseContext;
import io.github.wycst.wast.json.JSONTemporalDeserializer;
import io.github.wycst.wast.json.exceptions.JSONException;
import io.github.wycst.wast.json.temporal.TemporalConfig;
import java.time.LocalTime;

public class TemporalLocalTimeDeserializer
extends JSONTemporalDeserializer {
    public TemporalLocalTimeDeserializer(TemporalConfig temporalConfig) {
        super(temporalConfig);
    }

    @Override
    protected void checkClass(GenericParameterizedType genericParameterizedType) {
    }

    @Override
    protected Object deserializeTemporal(char[] buf, int fromIndex, int endIndex, JSONParseContext jsonParseContext) throws Exception {
        GeneralDate generalDate = this.dateTemplate.parseGeneralDate(buf, fromIndex + 1, endIndex - fromIndex - 1, ZERO_TIME_ZONE);
        return LocalTime.of(generalDate.getHourOfDay(), generalDate.getMinute(), generalDate.getSecond(), generalDate.getMillisecond() * 1000000);
    }

    @Override
    protected Object deserializeTemporal(byte[] buf, int fromIndex, int endIndex, JSONParseContext jsonParseContext) throws Exception {
        GeneralDate generalDate = this.dateTemplate.parseGeneralDate(buf, fromIndex + 1, endIndex - fromIndex - 1, ZERO_TIME_ZONE);
        return LocalTime.of(generalDate.getHourOfDay(), generalDate.getMinute(), generalDate.getSecond(), generalDate.getMillisecond() * 1000000);
    }

    @Override
    protected Object deserializeDefaultTemporal(char[] buf, int offset, char endToken, JSONParseContext jsonParseContext) throws Exception {
        int i = offset;
        char c = buf[i];
        if (!TemporalLocalTimeDeserializer.isDigit(c)) {
            String errorContextTextAt = TemporalLocalTimeDeserializer.createErrorContextText(buf, i);
            throw new JSONException("Syntax error, at pos " + i + ", context text by '" + errorContextTextAt + "', hour field error ");
        }
        int hour = c - 48;
        c = buf[++i];
        if (TemporalLocalTimeDeserializer.isDigit(c)) {
            hour = (hour << 3) + (hour << 1) + c - 48;
        }
        ++i;
        if (!TemporalLocalTimeDeserializer.isDigit(c = buf[++i])) {
            String errorContextTextAt = TemporalLocalTimeDeserializer.createErrorContextText(buf, i);
            throw new JSONException("Syntax error, at pos " + i + ", context text by '" + errorContextTextAt + "', minute field error ");
        }
        int minute = c - 48;
        c = buf[++i];
        if (TemporalLocalTimeDeserializer.isDigit(c)) {
            minute = (minute << 3) + (minute << 1) + c - 48;
        }
        ++i;
        if (!TemporalLocalTimeDeserializer.isDigit(c = buf[++i])) {
            String errorContextTextAt = TemporalLocalTimeDeserializer.createErrorContextText(buf, i);
            throw new JSONException("Syntax error, at pos " + i + ", context text by '" + errorContextTextAt + "', second field error ");
        }
        int second = c - 48;
        c = buf[++i];
        if (TemporalLocalTimeDeserializer.isDigit(c)) {
            second = (second << 3) + (second << 1) + c - 48;
            c = buf[++i];
        }
        int nanoOfSecond = 0;
        char c1 = c;
        if (c1 == '.') {
            boolean isDigitFlag;
            int cnt = 9;
            while ((isDigitFlag = TemporalLocalTimeDeserializer.isDigit(c1 = buf[++i])) && TemporalLocalTimeDeserializer.isDigit(c = buf[++i])) {
                cnt -= 2;
                nanoOfSecond = nanoOfSecond * 100 + c1 * 10 + c - 528;
            }
            if (isDigitFlag) {
                nanoOfSecond = (nanoOfSecond << 3) + (nanoOfSecond << 1) + c1 - 48;
                c1 = c;
                --cnt;
            }
            if (cnt > 0) {
                nanoOfSecond *= NANO_OF_SECOND_PADDING[cnt];
            }
        }
        if (c1 == endToken) {
            jsonParseContext.endIndex = i;
            return LocalTime.of(hour, minute, second, nanoOfSecond);
        }
        String errorContextTextAt = TemporalLocalTimeDeserializer.createErrorContextText(buf, i);
        throw new JSONException("Syntax error, at pos " + i + ", context text by '" + errorContextTextAt + "', unexpected token '" + c1 + "', expected '" + endToken + "'");
    }

    @Override
    protected Object deserializeDefaultTemporal(byte[] buf, int offset, char endToken, JSONParseContext jsonParseContext) throws Exception {
        int i = offset;
        byte b = buf[i];
        if (!TemporalLocalTimeDeserializer.isDigit(b)) {
            String errorContextTextAt = TemporalLocalTimeDeserializer.createErrorContextText(buf, i);
            throw new JSONException("Syntax error, at pos " + i + ", context text by '" + errorContextTextAt + "', hour field error ");
        }
        int hour = b - 48;
        b = buf[++i];
        if (TemporalLocalTimeDeserializer.isDigit(b)) {
            hour = (hour << 3) + (hour << 1) + b - 48;
        }
        ++i;
        if (!TemporalLocalTimeDeserializer.isDigit(b = buf[++i])) {
            String errorContextTextAt = TemporalLocalTimeDeserializer.createErrorContextText(buf, i);
            throw new JSONException("Syntax error, at pos " + i + ", context text by '" + errorContextTextAt + "', minute field error ");
        }
        int minute = b - 48;
        b = buf[++i];
        if (TemporalLocalTimeDeserializer.isDigit(b)) {
            minute = (minute << 3) + (minute << 1) + b - 48;
        }
        ++i;
        if (!TemporalLocalTimeDeserializer.isDigit(b = buf[++i])) {
            String errorContextTextAt = TemporalLocalTimeDeserializer.createErrorContextText(buf, i);
            throw new JSONException("Syntax error, at pos " + i + ", context text by '" + errorContextTextAt + "', second field error ");
        }
        int second = b - 48;
        b = buf[++i];
        if (TemporalLocalTimeDeserializer.isDigit(b)) {
            second = (second << 3) + (second << 1) + b - 48;
            b = buf[++i];
        }
        int nanoOfSecond = 0;
        byte c = b;
        if (c == 46) {
            boolean isDigitFlag;
            int cnt = 9;
            while ((isDigitFlag = TemporalLocalTimeDeserializer.isDigit(c = buf[++i])) && TemporalLocalTimeDeserializer.isDigit(b = buf[++i])) {
                cnt -= 2;
                nanoOfSecond = nanoOfSecond * 100 + c * 10 + b - 528;
            }
            if (isDigitFlag) {
                nanoOfSecond = (nanoOfSecond << 3) + (nanoOfSecond << 1) + c - 48;
                c = b;
                --cnt;
            }
            if (cnt > 0) {
                nanoOfSecond *= NANO_OF_SECOND_PADDING[cnt];
            }
        }
        if (c == endToken) {
            jsonParseContext.endIndex = i;
            return LocalTime.of(hour, minute, second, nanoOfSecond);
        }
        String errorContextTextAt = TemporalLocalTimeDeserializer.createErrorContextText(buf, i);
        throw new JSONException("Syntax error, at pos " + i + ", context text by '" + errorContextTextAt + "', unexpected token '" + (char)c + "', expected '" + endToken + "'");
    }

    @Override
    protected Object valueOf(String value, Class<?> actualType) throws Exception {
        return LocalTime.parse(value);
    }
}

