/*
 * Decompiled with CFR 0.152.
 */
package io.github.wycst.wast.log;

import io.github.wycst.wast.common.beans.GregorianDate;
import io.github.wycst.wast.common.utils.StringUtils;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.logging.Formatter;
import java.util.logging.Level;
import java.util.logging.LogRecord;

public class TextFormatter
extends Formatter {
    public String formatDate(long millis) {
        return new GregorianDate(millis).format("Y-M-d H:m:s.S");
    }

    public String formatLoggerName(LogRecord record) {
        return record.getLoggerName();
    }

    @Override
    public String format(LogRecord record) {
        boolean isException;
        Object[] parameters;
        StringBuilder sb = new StringBuilder();
        sb.append(this.formatDate(record.getMillis()));
        sb.append(" [");
        sb.append(Thread.currentThread().getName());
        sb.append("] ");
        sb.append(this.formatLevel(record.getLevel()));
        sb.append(" ");
        sb.append(this.formatLoggerName(record));
        sb.append(" - ");
        String message = record.getMessage();
        ResourceBundle catalog = record.getResourceBundle();
        if (catalog != null) {
            try {
                message = catalog.getString(record.getMessage());
            }
            catch (MissingResourceException ex) {
                message = record.getMessage();
            }
        }
        if ((parameters = record.getParameters()) != null && parameters.length > 0) {
            message = StringUtils.replacePlaceholder(message, "{}", parameters);
        }
        sb.append(message);
        sb.append("\n");
        boolean bl = isException = record.getThrown() != null;
        if (isException) {
            sb.append(StringUtils.getThrowableContent(record.getThrown()));
        }
        String result = sb.toString();
        if ("true".equals(System.getProperty("java.util.logging.console"))) {
            if (isException) {
                System.err.println(result);
            } else {
                System.out.print(result);
            }
        }
        return result;
    }

    private String formatLevel(Level level) {
        String levelName = level.getName();
        if (level == Level.INFO) {
            return "INFO ";
        }
        if (level == Level.WARNING) {
            return "WARN ";
        }
        if (level == Level.CONFIG) {
            return "DEBUG";
        }
        if (level == Level.SEVERE) {
            return "ERROR";
        }
        return levelName;
    }
}

