/*
 * Decompiled with CFR 0.152.
 */
package io.github.wycst.wast.clients.http.definition;

import io.github.wycst.wast.clients.http.definition.HttpClientParameter;
import io.github.wycst.wast.common.idgenerate.providers.IdGenerator;
import java.io.File;
import java.io.Serializable;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class HttpClientConfig {
    private static boolean defaultFollowRedirect = false;
    private static boolean defaultUseCaches = false;
    private static long defaultMaxConnectTimeout = 30000L;
    private static long defaultMaxReadTimeout = 30000L;
    private boolean keepAlive;
    private long maxConnectTimeout = defaultMaxConnectTimeout;
    private long maxReadTimeout = defaultMaxReadTimeout;
    private long maxCloseTimeout;
    private long maxContentLength;
    private boolean useCaches = defaultUseCaches;
    private boolean followRedirect = defaultFollowRedirect;
    private boolean keepAliveOnTimeout;
    private final Map<String, Serializable> headers = new HashMap<String, Serializable>();
    private final List<HttpClientParameter> parameterList = new ArrayList<HttpClientParameter>();
    private boolean multipart;
    private String boundary;
    private boolean chunked;
    private Object content;
    private boolean applicationJson;
    private String contentType = "application/x-www-form-urlencoded";
    private Proxy proxy;
    private String charset = "UTF-8";

    public long getMaxContentLength() {
        return this.maxContentLength;
    }

    public void setMaxContentLength(long maxContentLength) {
        this.maxContentLength = maxContentLength;
    }

    public void clearParameters() {
        this.parameterList.clear();
    }

    public void addTextParameters(HttpClientParameter ... clientParameters) {
        for (HttpClientParameter clientParameter : clientParameters) {
            if (clientParameter == null) continue;
            this.parameterList.add(clientParameter);
        }
    }

    public void addTextParameter(String name, String value) {
        this.parameterList.add(new HttpClientParameter(name, value));
    }

    public void addFileParameter(String name, File file, String contentType) {
        this.parameterList.add(new HttpClientParameter(name, file, contentType));
    }

    public void addFileParameter(String name, String fileName, byte[] fileContent, String contentType) {
        this.parameterList.add(new HttpClientParameter(name, fileName, fileContent, contentType));
    }

    public void setHeader(String name, Serializable value) {
        this.headers.put(name, (Serializable)((Object)String.valueOf(value)));
    }

    public void setHeaders(Map<String, String> headerMap) {
        if (headerMap != null) {
            this.headers.putAll(headerMap);
        }
    }

    public void removeHeader(String name) {
        this.headers.remove(name);
    }

    public Map<String, Serializable> getHeaders() {
        return this.headers;
    }

    public List<HttpClientParameter> getParameterList() {
        return this.parameterList;
    }

    public void clearHeaders() {
        this.headers.clear();
    }

    public void clear() {
        this.clearParameters();
        this.clearHeaders();
        this.content = null;
    }

    public boolean isKeepAlive() {
        return this.keepAlive;
    }

    public void setKeepAlive(boolean keepAlive) {
        this.keepAlive = keepAlive;
    }

    public long getMaxConnectTimeout() {
        return this.maxConnectTimeout;
    }

    public void setMaxConnectTimeout(long maxConnectTimeout) {
        this.maxConnectTimeout = maxConnectTimeout;
    }

    public long getMaxReadTimeout() {
        return this.maxReadTimeout;
    }

    public void setMaxReadTimeout(long maxReadTimeout) {
        this.maxReadTimeout = maxReadTimeout;
    }

    public long getMaxCloseTimeout() {
        return this.maxCloseTimeout;
    }

    public void setMaxCloseTimeout(long maxCloseTimeout) {
        this.maxCloseTimeout = maxCloseTimeout;
    }

    public void setProxy(Proxy proxy) {
        this.proxy = proxy;
    }

    public void setProxy(String proxyHost, int proxyPort) {
        InetSocketAddress proxyAddr = new InetSocketAddress(proxyHost, proxyPort);
        this.proxy = new Proxy(Proxy.Type.HTTP, proxyAddr);
    }

    public Proxy getProxy() {
        return this.proxy;
    }

    public boolean isMultipart() {
        return this.multipart;
    }

    public void setMultipart(boolean multipart) {
        this.multipart = multipart;
        if (multipart) {
            this.initMultipart();
        }
    }

    private void initMultipart() {
        if (this.boundary == null) {
            this.boundary = IdGenerator.hex();
        }
        this.contentType = "multipart/form-data; boundary=" + this.boundary;
    }

    public boolean isChunked() {
        return this.chunked;
    }

    public void setChunked(boolean chunked) {
        this.chunked = chunked;
    }

    public boolean isUseCaches() {
        return this.useCaches;
    }

    public void setUseCaches(boolean useCaches) {
        this.useCaches = useCaches;
    }

    public String getCharset() {
        return this.charset;
    }

    public void setCharset(String charset) {
        this.charset = charset;
    }

    public Object getRequestBody() {
        return this.content;
    }

    public void setRequestBody(Object requestBody, String contentType, boolean applicationJson) {
        this.content = requestBody;
        this.contentType = contentType;
        this.applicationJson = applicationJson;
    }

    public boolean isApplicationJson() {
        return this.applicationJson;
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    public String getContentType() {
        return this.contentType;
    }

    public String getBoundary() {
        return this.boundary;
    }

    public boolean isKeepAliveOnTimeout() {
        return this.keepAliveOnTimeout;
    }

    public void setKeepAliveOnTimeout(boolean keepAliveOnTimeout) {
        this.keepAliveOnTimeout = keepAliveOnTimeout;
    }

    public boolean isFollowRedirect() {
        return this.followRedirect;
    }

    public void setFollowRedirect(boolean followRedirect) {
        this.followRedirect = followRedirect;
    }

    public static HttpClientConfig create() {
        return new HttpClientConfig();
    }

    public static void setDefaultFollowRedirect(boolean defaultFollowRedirect) {
        HttpClientConfig.defaultFollowRedirect = defaultFollowRedirect;
    }

    public static void setDefaultUseCaches(boolean defaultUseCaches) {
        HttpClientConfig.defaultUseCaches = defaultUseCaches;
    }

    public static void setDefaultMaxConnectTimeout(long defaultMaxConnectTimeout) {
        HttpClientConfig.defaultMaxConnectTimeout = defaultMaxConnectTimeout;
    }

    public static void setDefaultMaxReadTimeout(long defaultMaxReadTimeout) {
        HttpClientConfig.defaultMaxReadTimeout = defaultMaxReadTimeout;
    }
}

