/*
 * Decompiled with CFR 0.152.
 */
package io.github.wycst.wast.common.beans.geo;

import io.github.wycst.wast.common.beans.geo.Geometry;
import io.github.wycst.wast.common.beans.geo.GeometryContext;
import io.github.wycst.wast.common.beans.geo.GeometryType;

abstract class AbstractMultiGeometry
extends Geometry {
    public AbstractMultiGeometry(GeometryType geometryType) {
        super(geometryType);
    }

    @Override
    final void readBody(char[] chars, GeometryContext geometryContext) {
        char ch;
        int offset = geometryContext.offset;
        while (true) {
            if ((ch = chars[++offset]) == ' ') {
                continue;
            }
            this.checkElementPrefix(ch, offset);
            geometryContext.offset = offset;
            this.readElement(chars, geometryContext);
            offset = geometryContext.offset;
            while ((ch = chars[++offset]) == ' ') {
            }
            if (ch == ')') {
                geometryContext.offset = offset;
                return;
            }
            if (ch != ',') break;
        }
        throw new IllegalArgumentException("Geometry syntax error, offset " + offset + " , expected ',', actual '" + ch + "'");
    }

    protected void checkElementPrefix(char ch, int offset) {
        if (ch != '(') {
            throw new IllegalArgumentException("Geometry syntax error, offset " + offset + " , expected '(', actual '" + ch + "'");
        }
    }

    protected abstract void readElement(char[] var1, GeometryContext var2);
}

