/*
 * Decompiled with CFR 0.152.
 */
package io.github.wycst.wast.common.beans.geo;

import io.github.wycst.wast.common.beans.geo.AbstractMultiGeometry;
import io.github.wycst.wast.common.beans.geo.Geometry;
import io.github.wycst.wast.common.beans.geo.GeometryContext;
import io.github.wycst.wast.common.beans.geo.GeometryType;
import java.util.ArrayList;
import java.util.List;

public class GeometryCollection
extends AbstractMultiGeometry {
    private List<Geometry> elements = new ArrayList<Geometry>();

    public GeometryCollection() {
        super(GeometryType.GEOMETRYCOLLECTION);
    }

    public void add(Geometry child) {
        this.elements.add(child);
    }

    public void addAll(Geometry ... childList) {
        for (Geometry child : childList) {
            this.elements.add(child);
        }
    }

    public void addAll(List<Geometry> childList) {
        this.elements.addAll(childList);
    }

    public Geometry removeAt(int index) {
        return this.elements.remove(index);
    }

    public boolean remove(Geometry geometry) {
        return this.elements.remove(geometry);
    }

    public void clear() {
        this.elements.clear();
    }

    @Override
    void appendBody(StringBuilder builder) {
        builder.append("(");
        int deleteDotIndex = -1;
        for (Geometry geometry : this.elements) {
            geometry.appendTo(builder);
            builder.append(",");
            deleteDotIndex = builder.length() - 1;
        }
        if (deleteDotIndex > -1) {
            builder.deleteCharAt(deleteDotIndex);
        }
        builder.append(")");
    }

    @Override
    protected void checkElementPrefix(char ch, int offset) {
    }

    @Override
    protected void readElement(char[] chars, GeometryContext geometryContext) {
        GeometryType geometryType = GeometryCollection.readGeometryType(chars, geometryContext);
        Geometry geometry = geometryType.newInstance();
        geometry.readBody(chars, geometryContext);
        this.add(geometry);
    }

    public List<Geometry> getElements() {
        return this.elements;
    }

    public void setElements(List<Geometry> elements) {
        this.elements = elements;
    }
}

