/*
 * Decompiled with CFR 0.152.
 */
package io.github.wycst.wast.common.expression;

import io.github.wycst.wast.common.beans.ArrayQueueMap;
import io.github.wycst.wast.common.expression.EvaluateEnvironment;
import io.github.wycst.wast.common.expression.ExprParser;
import io.github.wycst.wast.common.expression.Expression;
import io.github.wycst.wast.common.utils.ObjectUtils;

public final class CacheableExpression {
    static final ArrayQueueMap<String, Expression> ARRAY_QUEUE_MAP = new ArrayQueueMap(256);
    static int maxExprLength = 65536;

    public static void setMaxExprLength(int maxExprLength) {
        CacheableExpression.maxExprLength = maxExprLength;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Expression parse(String expr) {
        if ((expr = expr.trim()).length() > maxExprLength) {
            return new ExprParser(expr);
        }
        Expression expression = ARRAY_QUEUE_MAP.get(expr);
        if (expression == null) {
            ArrayQueueMap<String, Expression> arrayQueueMap = ARRAY_QUEUE_MAP;
            synchronized (arrayQueueMap) {
                expression = ARRAY_QUEUE_MAP.get(expr);
                if (expression == null) {
                    expression = new ExprParser(expr);
                    ARRAY_QUEUE_MAP.put(expr.trim(), expression);
                }
                return expression;
            }
        }
        return expression;
    }

    public static Object eval(String expr) {
        return CacheableExpression.parse(expr).evaluate();
    }

    public static Object eval(String expr, EvaluateEnvironment evaluateEnvironment) {
        return CacheableExpression.parse(expr).evaluate(evaluateEnvironment);
    }

    public static Object evalParameters(String expr, Object ... params) {
        return CacheableExpression.parse(expr).evaluateParameters(params);
    }

    public static <T> T evalParameters(String expr, Class<T> targetClass, Object ... params) {
        return ObjectUtils.toType(CacheableExpression.parse(expr).evaluateParameters(params), targetClass);
    }

    public static <T> T evalResult(String expr, EvaluateEnvironment evaluateEnvironment, Class<T> targetClass) {
        return ObjectUtils.toType(CacheableExpression.parse(expr).evaluate(evaluateEnvironment), targetClass);
    }

    public static void clearCaches() {
        ARRAY_QUEUE_MAP.clear();
    }
}

