/*
 * Decompiled with CFR 0.152.
 */
package io.github.wycst.wast.common.expression;

import io.github.wycst.wast.common.expression.ElVariableInvoker;
import io.github.wycst.wast.common.expression.ExpressionException;
import java.util.Map;

public class EvaluatorContext {
    public static final EvaluatorContext EMPTY = new EvaluatorContext();
    Object[] variableValues;
    Object value;

    EvaluatorContext() {
    }

    public EvaluatorContext(Object[] variableValues) {
        this.variableValues = variableValues;
    }

    public Object getContextValue(ElVariableInvoker variableInvoker) {
        try {
            return this.variableValues[variableInvoker.index];
        }
        catch (Throwable throwable) {
            throw new ExpressionException("unresolved property or variable: '" + variableInvoker + "' from context");
        }
    }

    static final class SingleVariableImpl
    extends EvaluatorContext {
        final Object variableValue;

        SingleVariableImpl(Object variableValue) {
            this.variableValue = variableValue;
        }

        @Override
        public Object getContextValue(ElVariableInvoker variableInvoker) {
            return this.variableValue;
        }
    }

    static final class ObjectRootImpl
    extends EvaluatorContext {
        private final Object context;

        ObjectRootImpl(Object context) {
            this.context = context;
        }

        @Override
        public Object getContextValue(ElVariableInvoker variableInvoker) {
            return variableInvoker.invokeValue(this.context);
        }
    }

    static final class MapRootImpl
    extends EvaluatorContext {
        private final Map context;

        MapRootImpl(Map context) {
            this.context = context;
        }

        @Override
        public Object getContextValue(ElVariableInvoker variableInvoker) {
            return this.context.get(variableInvoker.key);
        }
    }

    static final class ParametersImpl
    extends EvaluatorContext {
        public ParametersImpl(Object[] params) {
            this.variableValues = params;
        }

        @Override
        public Object getContextValue(ElVariableInvoker variableInvoker) {
            try {
                return this.variableValues[variableInvoker.tailIndex];
            }
            catch (Throwable throwable) {
                throw new ExpressionException("unresolved property or variable: '" + variableInvoker + "' from parameters[" + variableInvoker.tailIndex + "]");
            }
        }
    }

    static class TwinsImpl
    extends EvaluatorContext {
        final ElVariableInvoker one;
        Object oneValue;
        Object otherValue;

        TwinsImpl(ElVariableInvoker one, Object oneValue, Object otherValue) {
            this.one = one;
            this.oneValue = oneValue;
            this.otherValue = otherValue;
        }

        @Override
        public final Object getContextValue(ElVariableInvoker variableInvoker) {
            return variableInvoker == this.one ? this.oneValue : this.otherValue;
        }
    }
}

